// owl/mojom/password_prompt.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_PASSWORD_PROMPT_MOJOM_SHARED_INTERNAL_H_
#define OWL_MOJOM_PASSWORD_PROMPT_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/mojom/base/string16.mojom-shared-internal.h"
#include "ui/gfx/image/mojom/image.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace owl::mojom {
namespace internal {
class FederatedCredentials_Data;
class UsernamePasswordCredentials_Data;
class SavePasswordPromptDetails_Data;
class PasswordPromptCredentials_Data;

struct SavePasswordPromptType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)


class  PasswordPromptCredentials_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  PasswordPromptCredentials_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~PasswordPromptCredentials_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<PasswordPromptCredentials_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class PasswordPromptCredentials_Tag : uint32_t {

    
    kUsernamePasswordCredentials,
    
    kFederatedCredentials,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::UsernamePasswordCredentials_Data> f_username_password_credentials;
    mojo::internal::Pointer<internal::FederatedCredentials_Data> f_federated_credentials;
    uint64_t unknown;
  };

  uint32_t size;
  PasswordPromptCredentials_Tag tag;
  Union_ data;
};
static_assert(sizeof(PasswordPromptCredentials_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(PasswordPromptCredentials_Data)");
class  FederatedCredentials_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> upper_text;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> lower_text;

 private:
  friend class mojo::internal::MessageFragment<FederatedCredentials_Data>;

  FederatedCredentials_Data();
  ~FederatedCredentials_Data() = delete;
};
static_assert(sizeof(FederatedCredentials_Data) == 24,
              "Bad sizeof(FederatedCredentials_Data)");
// Used by FederatedCredentials::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct FederatedCredentials_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  FederatedCredentials_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~FederatedCredentials_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<FederatedCredentials_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    FederatedCredentials_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  UsernamePasswordCredentials_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> username;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> password;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data>>> all_usernames;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data>>> all_passwords;

 private:
  friend class mojo::internal::MessageFragment<UsernamePasswordCredentials_Data>;

  UsernamePasswordCredentials_Data();
  ~UsernamePasswordCredentials_Data() = delete;
};
static_assert(sizeof(UsernamePasswordCredentials_Data) == 40,
              "Bad sizeof(UsernamePasswordCredentials_Data)");
// Used by UsernamePasswordCredentials::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct UsernamePasswordCredentials_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  UsernamePasswordCredentials_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~UsernamePasswordCredentials_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<UsernamePasswordCredentials_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    UsernamePasswordCredentials_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  SavePasswordPromptDetails_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t type;
  uint8_t pad0_[4];
  internal::PasswordPromptCredentials_Data credentials;

 private:
  friend class mojo::internal::MessageFragment<SavePasswordPromptDetails_Data>;

  SavePasswordPromptDetails_Data();
  ~SavePasswordPromptDetails_Data() = delete;
};
static_assert(sizeof(SavePasswordPromptDetails_Data) == 32,
              "Bad sizeof(SavePasswordPromptDetails_Data)");
// Used by SavePasswordPromptDetails::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SavePasswordPromptDetails_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SavePasswordPromptDetails_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SavePasswordPromptDetails_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<SavePasswordPromptDetails_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SavePasswordPromptDetails_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // owl::mojom

#endif  // OWL_MOJOM_PASSWORD_PROMPT_MOJOM_SHARED_INTERNAL_H_