// owl/mojom/icloud_passkeys.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "owl/mojom/icloud_passkeys.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/icloud_passkeys.mojom-params-data.h"
#include "owl/mojom/icloud_passkeys.mojom-shared-message-ids.h"

#include "owl/mojom/icloud_passkeys.mojom-import-headers.h"
#include "owl/mojom/icloud_passkeys.mojom-test-utils.h"


namespace owl::mojom {
ICloudKeychainPasskeyResult::ICloudKeychainPasskeyResult()
    : raw_attestation_object() {}

ICloudKeychainPasskeyResult::ICloudKeychainPasskeyResult(
    const std::string& raw_attestation_object_in)
    : raw_attestation_object(std::move(raw_attestation_object_in)) {}

ICloudKeychainPasskeyResult::~ICloudKeychainPasskeyResult() = default;
size_t ICloudKeychainPasskeyResult::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->raw_attestation_object);
  return seed;
}

void ICloudKeychainPasskeyResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "raw_attestation_object"), this->raw_attestation_object,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ICloudKeychainPasskeyResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PRFInput::PRFInput()
    : id(),
      input1(),
      input2() {}

PRFInput::PRFInput(
    std::optional<std::vector<uint8_t>> id_in,
    std::vector<uint8_t> input1_in,
    std::optional<std::vector<uint8_t>> input2_in)
    : id(std::move(id_in)),
      input1(std::move(input1_in)),
      input2(std::move(input2_in)) {}

PRFInput::~PRFInput() = default;

void PRFInput::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input1"), this->input1,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input2"), this->input2,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PRFInput::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PublicKeyCredentialDescriptor::PublicKeyCredentialDescriptor()
    : id(),
      transports() {}

PublicKeyCredentialDescriptor::PublicKeyCredentialDescriptor(
    std::vector<uint8_t> id_in,
    std::vector<std::string> transports_in)
    : id(std::move(id_in)),
      transports(std::move(transports_in)) {}

PublicKeyCredentialDescriptor::~PublicKeyCredentialDescriptor() = default;

void PublicKeyCredentialDescriptor::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transports"), this->transports,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PublicKeyCredentialDescriptor::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RequestID::RequestID()
    : group_id() {}

RequestID::RequestID(
    const std::string& group_id_in)
    : group_id(std::move(group_id_in)) {}

RequestID::~RequestID() = default;
size_t RequestID::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->group_id);
  return seed;
}

void RequestID::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "group_id"), this->group_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RequestID::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CtapMakeCredentialRequest::CtapMakeCredentialRequest()
    : request_id(),
      rp_id(),
      client_data_hash(),
      user_id(),
      user_name(),
      user_verification(),
      user_display_name(),
      has_prf(),
      prf_input(),
      large_blob_support(),
      public_key_algorithms(),
      resident_key_required(),
      exclude_list() {}

CtapMakeCredentialRequest::CtapMakeCredentialRequest(
    RequestIDPtr request_id_in,
    const std::string& rp_id_in,
    std::vector<uint8_t> client_data_hash_in,
    std::vector<uint8_t> user_id_in,
    const std::string& user_name_in,
    UserVerificationRequirement user_verification_in,
    const std::optional<std::string>& user_display_name_in,
    bool has_prf_in,
    PRFInputPtr prf_input_in,
    LargeBlobSupport large_blob_support_in,
    std::vector<int32_t> public_key_algorithms_in,
    bool resident_key_required_in,
    std::vector<PublicKeyCredentialDescriptorPtr> exclude_list_in)
    : request_id(std::move(request_id_in)),
      rp_id(std::move(rp_id_in)),
      client_data_hash(std::move(client_data_hash_in)),
      user_id(std::move(user_id_in)),
      user_name(std::move(user_name_in)),
      user_verification(std::move(user_verification_in)),
      user_display_name(std::move(user_display_name_in)),
      has_prf(std::move(has_prf_in)),
      prf_input(std::move(prf_input_in)),
      large_blob_support(std::move(large_blob_support_in)),
      public_key_algorithms(std::move(public_key_algorithms_in)),
      resident_key_required(std::move(resident_key_required_in)),
      exclude_list(std::move(exclude_list_in)) {}

CtapMakeCredentialRequest::~CtapMakeCredentialRequest() = default;

void CtapMakeCredentialRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_id"), this->request_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type RequestIDPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rp_id"), this->rp_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_data_hash"), this->client_data_hash,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_id"), this->user_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_name"), this->user_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_verification"), this->user_verification,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type UserVerificationRequirement>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_display_name"), this->user_display_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_prf"), this->has_prf,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prf_input"), this->prf_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PRFInputPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "large_blob_support"), this->large_blob_support,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type LargeBlobSupport>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "public_key_algorithms"), this->public_key_algorithms,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<int32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resident_key_required"), this->resident_key_required,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "exclude_list"), this->exclude_list,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<PublicKeyCredentialDescriptorPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CtapMakeCredentialRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CtapGetAssertionRequest::CtapGetAssertionRequest()
    : request_id(),
      rp_id(),
      client_data_hash(),
      allowed_ids(),
      user_verification(),
      prf_inputs(),
      large_blob_read(),
      large_blob_write() {}

CtapGetAssertionRequest::CtapGetAssertionRequest(
    RequestIDPtr request_id_in,
    const std::string& rp_id_in,
    std::vector<uint8_t> client_data_hash_in,
    std::vector<std::vector<uint8_t>> allowed_ids_in,
    UserVerificationRequirement user_verification_in,
    std::vector<PRFInputPtr> prf_inputs_in,
    bool large_blob_read_in,
    std::optional<std::vector<uint8_t>> large_blob_write_in)
    : request_id(std::move(request_id_in)),
      rp_id(std::move(rp_id_in)),
      client_data_hash(std::move(client_data_hash_in)),
      allowed_ids(std::move(allowed_ids_in)),
      user_verification(std::move(user_verification_in)),
      prf_inputs(std::move(prf_inputs_in)),
      large_blob_read(std::move(large_blob_read_in)),
      large_blob_write(std::move(large_blob_write_in)) {}

CtapGetAssertionRequest::~CtapGetAssertionRequest() = default;

void CtapGetAssertionRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_id"), this->request_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type RequestIDPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rp_id"), this->rp_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_data_hash"), this->client_data_hash,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allowed_ids"), this->allowed_ids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_verification"), this->user_verification,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type UserVerificationRequirement>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prf_inputs"), this->prf_inputs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<PRFInputPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "large_blob_read"), this->large_blob_read,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "large_blob_write"), this->large_blob_write,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CtapGetAssertionRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ICloudCredentialPrfData::ICloudCredentialPrfData()
    : prf_enabled(),
      prf_results() {}

ICloudCredentialPrfData::ICloudCredentialPrfData(
    bool prf_enabled_in,
    std::optional<std::vector<uint8_t>> prf_results_in)
    : prf_enabled(std::move(prf_enabled_in)),
      prf_results(std::move(prf_results_in)) {}

ICloudCredentialPrfData::~ICloudCredentialPrfData() = default;

void ICloudCredentialPrfData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prf_enabled"), this->prf_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prf_results"), this->prf_results,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ICloudCredentialPrfData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ICloudCredential::ICloudCredential()
    : raw_attestation_object(),
      credential_id(),
      prf_data(),
      is_bespoke_large_blob() {}

ICloudCredential::ICloudCredential(
    std::vector<uint8_t> raw_attestation_object_in,
    std::vector<uint8_t> credential_id_in,
    ICloudCredentialPrfDataPtr prf_data_in,
    bool is_bespoke_large_blob_in)
    : raw_attestation_object(std::move(raw_attestation_object_in)),
      credential_id(std::move(credential_id_in)),
      prf_data(std::move(prf_data_in)),
      is_bespoke_large_blob(std::move(is_bespoke_large_blob_in)) {}

ICloudCredential::~ICloudCredential() = default;

void ICloudCredential::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "raw_attestation_object"), this->raw_attestation_object,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "credential_id"), this->credential_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prf_data"), this->prf_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ICloudCredentialPrfDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_bespoke_large_blob"), this->is_bespoke_large_blob,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ICloudCredential::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MakeCredentialResult::MakeCredentialResult()
    : credential(),
      failure_reason() {}

MakeCredentialResult::MakeCredentialResult(
    ICloudCredentialPtr credential_in,
    std::optional<MakeCredentialFailureReason> failure_reason_in)
    : credential(std::move(credential_in)),
      failure_reason(std::move(failure_reason_in)) {}

MakeCredentialResult::~MakeCredentialResult() = default;

void MakeCredentialResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "credential"), this->credential,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ICloudCredentialPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "failure_reason"), this->failure_reason,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<MakeCredentialFailureReason>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MakeCredentialResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AuthenticatorData::AuthenticatorData()
    : raw_authenticator_data(),
      signature(),
      user_id(),
      credential_id(),
      hmac_secret(),
      large_blob(),
      large_blob_written() {}

AuthenticatorData::AuthenticatorData(
    std::vector<uint8_t> raw_authenticator_data_in,
    std::vector<uint8_t> signature_in,
    std::vector<uint8_t> user_id_in,
    std::vector<uint8_t> credential_id_in,
    std::optional<std::vector<uint8_t>> hmac_secret_in,
    std::optional<std::vector<uint8_t>> large_blob_in,
    bool large_blob_written_in)
    : raw_authenticator_data(std::move(raw_authenticator_data_in)),
      signature(std::move(signature_in)),
      user_id(std::move(user_id_in)),
      credential_id(std::move(credential_id_in)),
      hmac_secret(std::move(hmac_secret_in)),
      large_blob(std::move(large_blob_in)),
      large_blob_written(std::move(large_blob_written_in)) {}

AuthenticatorData::~AuthenticatorData() = default;

void AuthenticatorData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "raw_authenticator_data"), this->raw_authenticator_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "signature"), this->signature,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_id"), this->user_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "credential_id"), this->credential_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hmac_secret"), this->hmac_secret,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "large_blob"), this->large_blob,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "large_blob_written"), this->large_blob_written,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AuthenticatorData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GetAssertionResult::GetAssertionResult()
    : data(),
      failure_reason() {}

GetAssertionResult::GetAssertionResult(
    AuthenticatorDataPtr data_in,
    std::optional<GetAssertionFailureReason> failure_reason_in)
    : data(std::move(data_in)),
      failure_reason(std::move(failure_reason_in)) {}

GetAssertionResult::~GetAssertionResult() = default;

void GetAssertionResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AuthenticatorDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "failure_reason"), this->failure_reason,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<GetAssertionFailureReason>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GetAssertionResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ExistingCredential::ExistingCredential()
    : credential_id(),
      provider_name(),
      user_handle(),
      name() {}

ExistingCredential::ExistingCredential(
    std::vector<uint8_t> credential_id_in,
    const std::optional<std::string>& provider_name_in,
    std::vector<uint8_t> user_handle_in,
    const std::string& name_in)
    : credential_id(std::move(credential_id_in)),
      provider_name(std::move(provider_name_in)),
      user_handle(std::move(user_handle_in)),
      name(std::move(name_in)) {}

ExistingCredential::~ExistingCredential() = default;

void ExistingCredential::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "credential_id"), this->credential_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "provider_name"), this->provider_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_handle"), this->user_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ExistingCredential::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GetCredentialsResult::GetCredentialsResult()
    : credentials(),
      failure_reason() {}

GetCredentialsResult::GetCredentialsResult(
    std::optional<std::vector<ExistingCredentialPtr>> credentials_in,
    std::optional<GetCredentialsFailureReason> failure_reason_in)
    : credentials(std::move(credentials_in)),
      failure_reason(std::move(failure_reason_in)) {}

GetCredentialsResult::~GetCredentialsResult() = default;

void GetCredentialsResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "credentials"), this->credentials,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<std::vector<ExistingCredentialPtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "failure_reason"), this->failure_reason,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<GetCredentialsFailureReason>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GetCredentialsResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ICloudKeychainPasskeyBridge::IPCStableHashFunction ICloudKeychainPasskeyBridge::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ICloudKeychainPasskeyBridge>(message.name())) {
    case messages::ICloudKeychainPasskeyBridge::kMakeCredentialAuthorizeIfNecessary: {
      return &ICloudKeychainPasskeyBridge::MakeCredentialAuthorizeIfNecessary_Sym::IPCStableHash;
    }
    case messages::ICloudKeychainPasskeyBridge::kGetAssertionAuthorizeIfNecessary: {
      return &ICloudKeychainPasskeyBridge::GetAssertionAuthorizeIfNecessary_Sym::IPCStableHash;
    }
    case messages::ICloudKeychainPasskeyBridge::kGetCredentials: {
      return &ICloudKeychainPasskeyBridge::GetCredentials_Sym::IPCStableHash;
    }
    case messages::ICloudKeychainPasskeyBridge::kCancel: {
      return &ICloudKeychainPasskeyBridge::Cancel_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ICloudKeychainPasskeyBridge::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ICloudKeychainPasskeyBridge>(message.name())) {
      case messages::ICloudKeychainPasskeyBridge::kMakeCredentialAuthorizeIfNecessary:
            return "Receive owl::mojom::ICloudKeychainPasskeyBridge::MakeCredentialAuthorizeIfNecessary";
      case messages::ICloudKeychainPasskeyBridge::kGetAssertionAuthorizeIfNecessary:
            return "Receive owl::mojom::ICloudKeychainPasskeyBridge::GetAssertionAuthorizeIfNecessary";
      case messages::ICloudKeychainPasskeyBridge::kGetCredentials:
            return "Receive owl::mojom::ICloudKeychainPasskeyBridge::GetCredentials";
      case messages::ICloudKeychainPasskeyBridge::kCancel:
            return "Receive owl::mojom::ICloudKeychainPasskeyBridge::Cancel";
    }
  } else {
    switch (static_cast<messages::ICloudKeychainPasskeyBridge>(message.name())) {
      case messages::ICloudKeychainPasskeyBridge::kMakeCredentialAuthorizeIfNecessary:
            return "Receive reply owl::mojom::ICloudKeychainPasskeyBridge::MakeCredentialAuthorizeIfNecessary";
      case messages::ICloudKeychainPasskeyBridge::kGetAssertionAuthorizeIfNecessary:
            return "Receive reply owl::mojom::ICloudKeychainPasskeyBridge::GetAssertionAuthorizeIfNecessary";
      case messages::ICloudKeychainPasskeyBridge::kGetCredentials:
            return "Receive reply owl::mojom::ICloudKeychainPasskeyBridge::GetCredentials";
      case messages::ICloudKeychainPasskeyBridge::kCancel:
            return "Receive reply owl::mojom::ICloudKeychainPasskeyBridge::Cancel";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ICloudKeychainPasskeyBridge::MakeCredentialAuthorizeIfNecessary_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbe819d8a;  // IPCStableHash for owl::mojom::ICloudKeychainPasskeyBridge::MakeCredentialAuthorizeIfNecessary
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ICloudKeychainPasskeyBridge::GetAssertionAuthorizeIfNecessary_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x435fb60f;  // IPCStableHash for owl::mojom::ICloudKeychainPasskeyBridge::GetAssertionAuthorizeIfNecessary
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ICloudKeychainPasskeyBridge::GetCredentials_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6cee6efa;  // IPCStableHash for owl::mojom::ICloudKeychainPasskeyBridge::GetCredentials
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ICloudKeychainPasskeyBridge::Cancel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x65a839b5;  // IPCStableHash for owl::mojom::ICloudKeychainPasskeyBridge::Cancel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_ForwardToCallback(
      ICloudKeychainPasskeyBridge::MakeCredentialAuthorizeIfNecessaryCallback callback
      ) : callback_(std::move(callback)) {
  }

  ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_ForwardToCallback(const ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_ForwardToCallback&) = delete;
  ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_ForwardToCallback& operator=(const ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ICloudKeychainPasskeyBridge::MakeCredentialAuthorizeIfNecessaryCallback callback_;
};

class ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_ForwardToCallback(
      ICloudKeychainPasskeyBridge::GetAssertionAuthorizeIfNecessaryCallback callback
      ) : callback_(std::move(callback)) {
  }

  ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_ForwardToCallback(const ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_ForwardToCallback&) = delete;
  ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_ForwardToCallback& operator=(const ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ICloudKeychainPasskeyBridge::GetAssertionAuthorizeIfNecessaryCallback callback_;
};

class ICloudKeychainPasskeyBridge_GetCredentials_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ICloudKeychainPasskeyBridge_GetCredentials_ForwardToCallback(
      ICloudKeychainPasskeyBridge::GetCredentialsCallback callback
      ) : callback_(std::move(callback)) {
  }

  ICloudKeychainPasskeyBridge_GetCredentials_ForwardToCallback(const ICloudKeychainPasskeyBridge_GetCredentials_ForwardToCallback&) = delete;
  ICloudKeychainPasskeyBridge_GetCredentials_ForwardToCallback& operator=(const ICloudKeychainPasskeyBridge_GetCredentials_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ICloudKeychainPasskeyBridge::GetCredentialsCallback callback_;
};

ICloudKeychainPasskeyBridgeProxy::ICloudKeychainPasskeyBridgeProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ICloudKeychainPasskeyBridgeProxy::MakeCredentialAuthorizeIfNecessary(
    CtapMakeCredentialRequestPtr in_request, MakeCredentialAuthorizeIfNecessaryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::ICloudKeychainPasskeyBridge::MakeCredentialAuthorizeIfNecessary", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type CtapMakeCredentialRequestPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ICloudKeychainPasskeyBridge::kMakeCredentialAuthorizeIfNecessary), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::CtapMakeCredentialRequestDataView>(
    in_request,
    request_fragment);

  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request in ICloudKeychainPasskeyBridge.MakeCredentialAuthorizeIfNecessary request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ICloudKeychainPasskeyBridge::Name_);
  message.set_method_name("MakeCredentialAuthorizeIfNecessary");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ICloudKeychainPasskeyBridgeProxy::GetAssertionAuthorizeIfNecessary(
    CtapGetAssertionRequestPtr in_request, GetAssertionAuthorizeIfNecessaryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::ICloudKeychainPasskeyBridge::GetAssertionAuthorizeIfNecessary", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type CtapGetAssertionRequestPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ICloudKeychainPasskeyBridge::kGetAssertionAuthorizeIfNecessary), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::CtapGetAssertionRequestDataView>(
    in_request,
    request_fragment);

  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request in ICloudKeychainPasskeyBridge.GetAssertionAuthorizeIfNecessary request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ICloudKeychainPasskeyBridge::Name_);
  message.set_method_name("GetAssertionAuthorizeIfNecessary");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ICloudKeychainPasskeyBridgeProxy::GetCredentials(
    const std::string& in_rp_id, GetCredentialsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::ICloudKeychainPasskeyBridge::GetCredentials", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rp_id"), in_rp_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ICloudKeychainPasskeyBridge::kGetCredentials), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ICloudKeychainPasskeyBridge_GetCredentials_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->rp_id)::BaseType> rp_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_rp_id,
    rp_id_fragment);

  params->rp_id.Set(
      rp_id_fragment.is_null() ? nullptr : rp_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->rp_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null rp_id in ICloudKeychainPasskeyBridge.GetCredentials request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ICloudKeychainPasskeyBridge::Name_);
  message.set_method_name("GetCredentials");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ICloudKeychainPasskeyBridge_GetCredentials_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ICloudKeychainPasskeyBridgeProxy::Cancel(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::ICloudKeychainPasskeyBridge::Cancel");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ICloudKeychainPasskeyBridge::kCancel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ICloudKeychainPasskeyBridge_Cancel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ICloudKeychainPasskeyBridge::Name_);
  message.set_method_name("Cancel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ICloudKeychainPasskeyBridge::MakeCredentialAuthorizeIfNecessaryCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_ProxyToResponder> proxy(
        new ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ICloudKeychainPasskeyBridge::MakeCredentialAuthorizeIfNecessaryCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      MakeCredentialResultPtr in_result);
};

bool ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ICloudKeychainPasskeyBridge.0
  bool success = true;
  MakeCredentialResultPtr p_result{};
  ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ICloudKeychainPasskeyBridge::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_ProxyToResponder::Run(
    MakeCredentialResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::ICloudKeychainPasskeyBridge::MakeCredentialAuthorizeIfNecessary", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type MakeCredentialResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ICloudKeychainPasskeyBridge::kMakeCredentialAuthorizeIfNecessary), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::MakeCredentialResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ICloudKeychainPasskeyBridge::Name_);
  message.set_method_name("MakeCredentialAuthorizeIfNecessary");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ICloudKeychainPasskeyBridge::GetAssertionAuthorizeIfNecessaryCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_ProxyToResponder> proxy(
        new ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ICloudKeychainPasskeyBridge::GetAssertionAuthorizeIfNecessaryCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      GetAssertionResultPtr in_result);
};

bool ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ICloudKeychainPasskeyBridge.1
  bool success = true;
  GetAssertionResultPtr p_result{};
  ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ICloudKeychainPasskeyBridge::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_ProxyToResponder::Run(
    GetAssertionResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::ICloudKeychainPasskeyBridge::GetAssertionAuthorizeIfNecessary", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type GetAssertionResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ICloudKeychainPasskeyBridge::kGetAssertionAuthorizeIfNecessary), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::GetAssertionResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ICloudKeychainPasskeyBridge::Name_);
  message.set_method_name("GetAssertionAuthorizeIfNecessary");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ICloudKeychainPasskeyBridge_GetCredentials_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ICloudKeychainPasskeyBridge::GetCredentialsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ICloudKeychainPasskeyBridge_GetCredentials_ProxyToResponder> proxy(
        new ICloudKeychainPasskeyBridge_GetCredentials_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ICloudKeychainPasskeyBridge_GetCredentials_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ICloudKeychainPasskeyBridge_GetCredentials_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ICloudKeychainPasskeyBridge_GetCredentials_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ICloudKeychainPasskeyBridge::GetCredentialsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      GetCredentialsResultPtr in_result);
};

bool ICloudKeychainPasskeyBridge_GetCredentials_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ICloudKeychainPasskeyBridge_GetCredentials_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ICloudKeychainPasskeyBridge_GetCredentials_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ICloudKeychainPasskeyBridge.2
  bool success = true;
  GetCredentialsResultPtr p_result{};
  ICloudKeychainPasskeyBridge_GetCredentials_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ICloudKeychainPasskeyBridge::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void ICloudKeychainPasskeyBridge_GetCredentials_ProxyToResponder::Run(
    GetCredentialsResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::ICloudKeychainPasskeyBridge::GetCredentials", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type GetCredentialsResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ICloudKeychainPasskeyBridge::kGetCredentials), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ICloudKeychainPasskeyBridge_GetCredentials_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::GetCredentialsResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ICloudKeychainPasskeyBridge::Name_);
  message.set_method_name("GetCredentials");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ICloudKeychainPasskeyBridgeStubDispatch::Accept(
    ICloudKeychainPasskeyBridge* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ICloudKeychainPasskeyBridge>(message->header()->name)) {
    case messages::ICloudKeychainPasskeyBridge::kMakeCredentialAuthorizeIfNecessary: {
      break;
    }
    case messages::ICloudKeychainPasskeyBridge::kGetAssertionAuthorizeIfNecessary: {
      break;
    }
    case messages::ICloudKeychainPasskeyBridge::kGetCredentials: {
      break;
    }
    case messages::ICloudKeychainPasskeyBridge::kCancel: {
      DCHECK(message->is_serialized());
      internal::ICloudKeychainPasskeyBridge_Cancel_Params_Data* params =
          reinterpret_cast<internal::ICloudKeychainPasskeyBridge_Cancel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ICloudKeychainPasskeyBridge.3
      bool success = true;
      ICloudKeychainPasskeyBridge_Cancel_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ICloudKeychainPasskeyBridge::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Cancel(        );
      return true;
    }
  }
  return false;
}

// static
bool ICloudKeychainPasskeyBridgeStubDispatch::AcceptWithResponder(
    ICloudKeychainPasskeyBridge* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ICloudKeychainPasskeyBridge>(message->header()->name)) {
    case messages::ICloudKeychainPasskeyBridge::kMakeCredentialAuthorizeIfNecessary: {
      internal::ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_Params_Data* params =
          reinterpret_cast<
              internal::ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ICloudKeychainPasskeyBridge.0
      bool success = true;
      CtapMakeCredentialRequestPtr p_request{};
      ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ICloudKeychainPasskeyBridge::Name_, 0, false);
        return false;
      }
      auto callback =
          ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MakeCredentialAuthorizeIfNecessary(        
        std::move(p_request), std::move(callback));
      return true;
    }
    case messages::ICloudKeychainPasskeyBridge::kGetAssertionAuthorizeIfNecessary: {
      internal::ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_Params_Data* params =
          reinterpret_cast<
              internal::ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ICloudKeychainPasskeyBridge.1
      bool success = true;
      CtapGetAssertionRequestPtr p_request{};
      ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ICloudKeychainPasskeyBridge::Name_, 1, false);
        return false;
      }
      auto callback =
          ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAssertionAuthorizeIfNecessary(        
        std::move(p_request), std::move(callback));
      return true;
    }
    case messages::ICloudKeychainPasskeyBridge::kGetCredentials: {
      internal::ICloudKeychainPasskeyBridge_GetCredentials_Params_Data* params =
          reinterpret_cast<
              internal::ICloudKeychainPasskeyBridge_GetCredentials_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ICloudKeychainPasskeyBridge.2
      bool success = true;
      std::string p_rp_id{};
      ICloudKeychainPasskeyBridge_GetCredentials_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRpId(&p_rp_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ICloudKeychainPasskeyBridge::Name_, 2, false);
        return false;
      }
      auto callback =
          ICloudKeychainPasskeyBridge_GetCredentials_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetCredentials(        
        std::move(p_rp_id), std::move(callback));
      return true;
    }
    case messages::ICloudKeychainPasskeyBridge::kCancel: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kICloudKeychainPasskeyBridgeValidationInfo[] = {
    { &internal::ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_Params_Data::Validate,
     &internal::ICloudKeychainPasskeyBridge_MakeCredentialAuthorizeIfNecessary_ResponseParams_Data::Validate},
    { &internal::ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_Params_Data::Validate,
     &internal::ICloudKeychainPasskeyBridge_GetAssertionAuthorizeIfNecessary_ResponseParams_Data::Validate},
    { &internal::ICloudKeychainPasskeyBridge_GetCredentials_Params_Data::Validate,
     &internal::ICloudKeychainPasskeyBridge_GetCredentials_ResponseParams_Data::Validate},
    { &internal::ICloudKeychainPasskeyBridge_Cancel_Params_Data::Validate,
     nullptr /* no response */},
};

bool ICloudKeychainPasskeyBridgeRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::ICloudKeychainPasskeyBridge::Name_,
    kICloudKeychainPasskeyBridgeValidationInfo);
}

bool ICloudKeychainPasskeyBridgeResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::owl::mojom::ICloudKeychainPasskeyBridge::Name_,
    kICloudKeychainPasskeyBridgeValidationInfo);
}


}  // owl::mojom


namespace mojo {


// static
bool StructTraits<::owl::mojom::ICloudKeychainPasskeyResult::DataView, ::owl::mojom::ICloudKeychainPasskeyResultPtr>::Read(
    ::owl::mojom::ICloudKeychainPasskeyResult::DataView input,
    ::owl::mojom::ICloudKeychainPasskeyResultPtr* output) {
  bool success = true;
  ::owl::mojom::ICloudKeychainPasskeyResultPtr result(::owl::mojom::ICloudKeychainPasskeyResult::New());
  
      if (success && !input.ReadRawAttestationObject(&result->raw_attestation_object))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::PRFInput::DataView, ::owl::mojom::PRFInputPtr>::Read(
    ::owl::mojom::PRFInput::DataView input,
    ::owl::mojom::PRFInputPtr* output) {
  bool success = true;
  ::owl::mojom::PRFInputPtr result(::owl::mojom::PRFInput::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadInput1(&result->input1))
        success = false;
      if (success && !input.ReadInput2(&result->input2))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::PublicKeyCredentialDescriptor::DataView, ::owl::mojom::PublicKeyCredentialDescriptorPtr>::Read(
    ::owl::mojom::PublicKeyCredentialDescriptor::DataView input,
    ::owl::mojom::PublicKeyCredentialDescriptorPtr* output) {
  bool success = true;
  ::owl::mojom::PublicKeyCredentialDescriptorPtr result(::owl::mojom::PublicKeyCredentialDescriptor::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadTransports(&result->transports))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::RequestID::DataView, ::owl::mojom::RequestIDPtr>::Read(
    ::owl::mojom::RequestID::DataView input,
    ::owl::mojom::RequestIDPtr* output) {
  bool success = true;
  ::owl::mojom::RequestIDPtr result(::owl::mojom::RequestID::New());
  
      if (success && !input.ReadGroupId(&result->group_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::CtapMakeCredentialRequest::DataView, ::owl::mojom::CtapMakeCredentialRequestPtr>::Read(
    ::owl::mojom::CtapMakeCredentialRequest::DataView input,
    ::owl::mojom::CtapMakeCredentialRequestPtr* output) {
  bool success = true;
  ::owl::mojom::CtapMakeCredentialRequestPtr result(::owl::mojom::CtapMakeCredentialRequest::New());
  
      if (success && !input.ReadRequestId(&result->request_id))
        success = false;
      if (success && !input.ReadRpId(&result->rp_id))
        success = false;
      if (success && !input.ReadClientDataHash(&result->client_data_hash))
        success = false;
      if (success && !input.ReadUserId(&result->user_id))
        success = false;
      if (success && !input.ReadUserName(&result->user_name))
        success = false;
      if (success && !input.ReadUserVerification(&result->user_verification))
        success = false;
      if (success && !input.ReadUserDisplayName(&result->user_display_name))
        success = false;
      if (success)
        result->has_prf = input.has_prf();
      if (success && !input.ReadPrfInput(&result->prf_input))
        success = false;
      if (success && !input.ReadLargeBlobSupport(&result->large_blob_support))
        success = false;
      if (success && !input.ReadPublicKeyAlgorithms(&result->public_key_algorithms))
        success = false;
      if (success)
        result->resident_key_required = input.resident_key_required();
      if (success && !input.ReadExcludeList(&result->exclude_list))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::CtapGetAssertionRequest::DataView, ::owl::mojom::CtapGetAssertionRequestPtr>::Read(
    ::owl::mojom::CtapGetAssertionRequest::DataView input,
    ::owl::mojom::CtapGetAssertionRequestPtr* output) {
  bool success = true;
  ::owl::mojom::CtapGetAssertionRequestPtr result(::owl::mojom::CtapGetAssertionRequest::New());
  
      if (success && !input.ReadRequestId(&result->request_id))
        success = false;
      if (success && !input.ReadRpId(&result->rp_id))
        success = false;
      if (success && !input.ReadClientDataHash(&result->client_data_hash))
        success = false;
      if (success && !input.ReadAllowedIds(&result->allowed_ids))
        success = false;
      if (success && !input.ReadUserVerification(&result->user_verification))
        success = false;
      if (success && !input.ReadPrfInputs(&result->prf_inputs))
        success = false;
      if (success)
        result->large_blob_read = input.large_blob_read();
      if (success && !input.ReadLargeBlobWrite(&result->large_blob_write))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::ICloudCredentialPrfData::DataView, ::owl::mojom::ICloudCredentialPrfDataPtr>::Read(
    ::owl::mojom::ICloudCredentialPrfData::DataView input,
    ::owl::mojom::ICloudCredentialPrfDataPtr* output) {
  bool success = true;
  ::owl::mojom::ICloudCredentialPrfDataPtr result(::owl::mojom::ICloudCredentialPrfData::New());
  
      if (success)
        result->prf_enabled = input.prf_enabled();
      if (success && !input.ReadPrfResults(&result->prf_results))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::ICloudCredential::DataView, ::owl::mojom::ICloudCredentialPtr>::Read(
    ::owl::mojom::ICloudCredential::DataView input,
    ::owl::mojom::ICloudCredentialPtr* output) {
  bool success = true;
  ::owl::mojom::ICloudCredentialPtr result(::owl::mojom::ICloudCredential::New());
  
      if (success && !input.ReadRawAttestationObject(&result->raw_attestation_object))
        success = false;
      if (success && !input.ReadCredentialId(&result->credential_id))
        success = false;
      if (success && !input.ReadPrfData(&result->prf_data))
        success = false;
      if (success)
        result->is_bespoke_large_blob = input.is_bespoke_large_blob();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::MakeCredentialResult::DataView, ::owl::mojom::MakeCredentialResultPtr>::Read(
    ::owl::mojom::MakeCredentialResult::DataView input,
    ::owl::mojom::MakeCredentialResultPtr* output) {
  bool success = true;
  ::owl::mojom::MakeCredentialResultPtr result(::owl::mojom::MakeCredentialResult::New());
  
      if (success && !input.ReadCredential(&result->credential))
        success = false;
      if (success && !input.ReadFailureReason(&result->failure_reason)) {
        success = false;
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::AuthenticatorData::DataView, ::owl::mojom::AuthenticatorDataPtr>::Read(
    ::owl::mojom::AuthenticatorData::DataView input,
    ::owl::mojom::AuthenticatorDataPtr* output) {
  bool success = true;
  ::owl::mojom::AuthenticatorDataPtr result(::owl::mojom::AuthenticatorData::New());
  
      if (success && !input.ReadRawAuthenticatorData(&result->raw_authenticator_data))
        success = false;
      if (success && !input.ReadSignature(&result->signature))
        success = false;
      if (success && !input.ReadUserId(&result->user_id))
        success = false;
      if (success && !input.ReadCredentialId(&result->credential_id))
        success = false;
      if (success && !input.ReadHmacSecret(&result->hmac_secret))
        success = false;
      if (success && !input.ReadLargeBlob(&result->large_blob))
        success = false;
      if (success)
        result->large_blob_written = input.large_blob_written();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::GetAssertionResult::DataView, ::owl::mojom::GetAssertionResultPtr>::Read(
    ::owl::mojom::GetAssertionResult::DataView input,
    ::owl::mojom::GetAssertionResultPtr* output) {
  bool success = true;
  ::owl::mojom::GetAssertionResultPtr result(::owl::mojom::GetAssertionResult::New());
  
      if (success && !input.ReadData(&result->data))
        success = false;
      if (success && !input.ReadFailureReason(&result->failure_reason)) {
        success = false;
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::ExistingCredential::DataView, ::owl::mojom::ExistingCredentialPtr>::Read(
    ::owl::mojom::ExistingCredential::DataView input,
    ::owl::mojom::ExistingCredentialPtr* output) {
  bool success = true;
  ::owl::mojom::ExistingCredentialPtr result(::owl::mojom::ExistingCredential::New());
  
      if (success && !input.ReadCredentialId(&result->credential_id))
        success = false;
      if (success && !input.ReadProviderName(&result->provider_name))
        success = false;
      if (success && !input.ReadUserHandle(&result->user_handle))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::GetCredentialsResult::DataView, ::owl::mojom::GetCredentialsResultPtr>::Read(
    ::owl::mojom::GetCredentialsResult::DataView input,
    ::owl::mojom::GetCredentialsResultPtr* output) {
  bool success = true;
  ::owl::mojom::GetCredentialsResultPtr result(::owl::mojom::GetCredentialsResult::New());
  
      if (success && !input.ReadCredentials(&result->credentials))
        success = false;
      if (success && !input.ReadFailureReason(&result->failure_reason)) {
        success = false;
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace owl::mojom {


void ICloudKeychainPasskeyBridgeInterceptorForTesting::MakeCredentialAuthorizeIfNecessary(CtapMakeCredentialRequestPtr request, MakeCredentialAuthorizeIfNecessaryCallback callback) {
  GetForwardingInterface()->MakeCredentialAuthorizeIfNecessary(
    std::move(request)
    , std::move(callback));
}
void ICloudKeychainPasskeyBridgeInterceptorForTesting::GetAssertionAuthorizeIfNecessary(CtapGetAssertionRequestPtr request, GetAssertionAuthorizeIfNecessaryCallback callback) {
  GetForwardingInterface()->GetAssertionAuthorizeIfNecessary(
    std::move(request)
    , std::move(callback));
}
void ICloudKeychainPasskeyBridgeInterceptorForTesting::GetCredentials(const std::string& rp_id, GetCredentialsCallback callback) {
  GetForwardingInterface()->GetCredentials(
    std::move(rp_id)
    , std::move(callback));
}
void ICloudKeychainPasskeyBridgeInterceptorForTesting::Cancel() {
  GetForwardingInterface()->Cancel();
}
ICloudKeychainPasskeyBridgeAsyncWaiter::ICloudKeychainPasskeyBridgeAsyncWaiter(
    ICloudKeychainPasskeyBridge* proxy) : proxy_(proxy) {}

ICloudKeychainPasskeyBridgeAsyncWaiter::~ICloudKeychainPasskeyBridgeAsyncWaiter() = default;


void ICloudKeychainPasskeyBridgeAsyncWaiter::MakeCredentialAuthorizeIfNecessary(
    CtapMakeCredentialRequestPtr request, MakeCredentialResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->MakeCredentialAuthorizeIfNecessary(
      std::move(request),
      base::BindOnce(
          [](base::RunLoop* loop,
             MakeCredentialResultPtr* out_result
,
             MakeCredentialResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

MakeCredentialResultPtr ICloudKeychainPasskeyBridgeAsyncWaiter::MakeCredentialAuthorizeIfNecessary(
    CtapMakeCredentialRequestPtr request) {
  MakeCredentialResultPtr async_wait_result;
  MakeCredentialAuthorizeIfNecessary(std::move(request),&async_wait_result);
  return async_wait_result;
}

void ICloudKeychainPasskeyBridgeAsyncWaiter::GetAssertionAuthorizeIfNecessary(
    CtapGetAssertionRequestPtr request, GetAssertionResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->GetAssertionAuthorizeIfNecessary(
      std::move(request),
      base::BindOnce(
          [](base::RunLoop* loop,
             GetAssertionResultPtr* out_result
,
             GetAssertionResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

GetAssertionResultPtr ICloudKeychainPasskeyBridgeAsyncWaiter::GetAssertionAuthorizeIfNecessary(
    CtapGetAssertionRequestPtr request) {
  GetAssertionResultPtr async_wait_result;
  GetAssertionAuthorizeIfNecessary(std::move(request),&async_wait_result);
  return async_wait_result;
}

void ICloudKeychainPasskeyBridgeAsyncWaiter::GetCredentials(
    const std::string& rp_id, GetCredentialsResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->GetCredentials(
      std::move(rp_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             GetCredentialsResultPtr* out_result
,
             GetCredentialsResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

GetCredentialsResultPtr ICloudKeychainPasskeyBridgeAsyncWaiter::GetCredentials(
    const std::string& rp_id) {
  GetCredentialsResultPtr async_wait_result;
  GetCredentials(std::move(rp_id),&async_wait_result);
  return async_wait_result;
}






}  // owl::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif