// owl/mojom/autofill_deprecated.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_AUTOFILL_DEPRECATED_MOJOM_H_
#define OWL_MOJOM_AUTOFILL_DEPRECATED_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/autofill_deprecated.mojom-features.h"  // IWYU pragma: export
#include "owl/mojom/autofill_deprecated.mojom-shared.h"  // IWYU pragma: export
#include "owl/mojom/autofill_deprecated.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom-forward.h"
#include "owl/mojom/autofill.mojom-forward.h"
#include "owl/mojom/autofill_popup.mojom.h"
#include "url/mojom/url.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace owl::mojom {

class AutofillControllerClientProxy;

template <typename ImplRefTraits>
class AutofillControllerClientStub;

class AutofillControllerClientRequestValidator;


class AutofillControllerClient
    : public AutofillControllerClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.AutofillControllerClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AutofillControllerClientInterfaceBase;
  using Proxy_ = AutofillControllerClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = AutofillControllerClientStub<ImplRefTraits>;

  using RequestValidator_ = AutofillControllerClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kShowMinVersion = 0,
    kHideMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Show_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Hide_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AutofillControllerClient() = default;

  virtual void Show(AutofillPopupRequestDeprecatedPtr request) = 0;

  virtual void Hide() = 0;
};

class AutofillControllerHostProxy;

template <typename ImplRefTraits>
class AutofillControllerHostStub;

class AutofillControllerHostRequestValidator;
class AutofillControllerHostResponseValidator;


class AutofillControllerHost
    : public AutofillControllerHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.AutofillControllerHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AutofillControllerHostInterfaceBase;
  using Proxy_ = AutofillControllerHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = AutofillControllerHostStub<ImplRefTraits>;

  using RequestValidator_ = AutofillControllerHostRequestValidator;
  using ResponseValidator_ = AutofillControllerHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kAcceptMinVersion = 0,
    kSelectMinVersion = 0,
    kDismissMinVersion = 0,
    kGetAddressListMinVersion = 0,
    kGetCreditCardListMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Accept_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Select_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Dismiss_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAddressList_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetCreditCardList_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AutofillControllerHost() = default;

  virtual void Accept(int32_t index) = 0;

  virtual void Select(int32_t index) = 0;

  virtual void Dismiss() = 0;

  using GetAddressListCallback = base::OnceCallback<void(std::vector<::owl::mojom::AutofillAddressEntryPtr>)>;
  using GetAddressListMojoCallback = base::OnceCallback<void(std::vector<::owl::mojom::AutofillAddressEntryPtr>)>;

  virtual void GetAddressList(GetAddressListCallback callback) = 0;

  using GetCreditCardListCallback = base::OnceCallback<void(std::vector<::owl::mojom::AutofillCreditCardEntryPtr>)>;
  using GetCreditCardListMojoCallback = base::OnceCallback<void(std::vector<::owl::mojom::AutofillCreditCardEntryPtr>)>;

  virtual void GetCreditCardList(GetCreditCardListCallback callback) = 0;
};



class  AutofillControllerClientProxy
    : public AutofillControllerClient {
 public:
  using InterfaceType = AutofillControllerClient;

  explicit AutofillControllerClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Show(AutofillPopupRequestDeprecatedPtr request) final;
  
  void Hide() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  AutofillControllerHostProxy
    : public AutofillControllerHost {
 public:
  using InterfaceType = AutofillControllerHost;

  explicit AutofillControllerHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Accept(int32_t index) final;
  
  void Select(int32_t index) final;
  
  void Dismiss() final;
  
  void GetAddressList(GetAddressListCallback callback) final;
  
  void GetCreditCardList(GetCreditCardListCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  AutofillControllerClientStubDispatch {
 public:
  static bool Accept(AutofillControllerClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AutofillControllerClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AutofillControllerClient>>
class AutofillControllerClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AutofillControllerClientStub() = default;
  ~AutofillControllerClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AutofillControllerClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AutofillControllerClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AutofillControllerHostStubDispatch {
 public:
  static bool Accept(AutofillControllerHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AutofillControllerHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AutofillControllerHost>>
class AutofillControllerHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AutofillControllerHostStub() = default;
  ~AutofillControllerHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AutofillControllerHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AutofillControllerHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AutofillControllerClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  AutofillControllerHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  AutofillControllerHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  AutofillPopupRequestDeprecated {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AutofillPopupRequestDeprecated, T>::value>;
  using DataView = AutofillPopupRequestDeprecatedDataView;
  using Data_ = internal::AutofillPopupRequestDeprecated_Data;

  template <typename... Args>
  static AutofillPopupRequestDeprecatedPtr New(Args&&... args) {
    return AutofillPopupRequestDeprecatedPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AutofillPopupRequestDeprecatedPtr From(const U& u) {
    return mojo::TypeConverter<AutofillPopupRequestDeprecatedPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AutofillPopupRequestDeprecated>::Convert(*this);
  }


  AutofillPopupRequestDeprecated();

  AutofillPopupRequestDeprecated(
      double x,
      double y,
      double width,
      double height,
      std::vector<::owl::mojom::AutofillSuggestionPtr> suggestions);

AutofillPopupRequestDeprecated(const AutofillPopupRequestDeprecated&) = delete;
AutofillPopupRequestDeprecated& operator=(const AutofillPopupRequestDeprecated&) = delete;

  ~AutofillPopupRequestDeprecated();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AutofillPopupRequestDeprecatedPtr>
  AutofillPopupRequestDeprecatedPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AutofillPopupRequestDeprecated::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AutofillPopupRequestDeprecated::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AutofillPopupRequestDeprecated::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AutofillPopupRequestDeprecated::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AutofillPopupRequestDeprecated_UnserializedMessageContext<
            UserType, AutofillPopupRequestDeprecated::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AutofillPopupRequestDeprecated::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AutofillPopupRequestDeprecated::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AutofillPopupRequestDeprecated_UnserializedMessageContext<
            UserType, AutofillPopupRequestDeprecated::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AutofillPopupRequestDeprecated::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  double x;
  
  double y;
  
  double width;
  
  double height;
  
  std::vector<::owl::mojom::AutofillSuggestionPtr> suggestions;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AutofillPopupRequestDeprecated::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AutofillPopupRequestDeprecated::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AutofillPopupRequestDeprecated::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AutofillPopupRequestDeprecated::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AutofillPopupRequestDeprecatedPtr AutofillPopupRequestDeprecated::Clone() const {
  return New(
      mojo::Clone(x),
      mojo::Clone(y),
      mojo::Clone(width),
      mojo::Clone(height),
      mojo::Clone(suggestions)
  );
}

template <typename T, AutofillPopupRequestDeprecated::EnableIfSame<T>*>
bool AutofillPopupRequestDeprecated::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->x, other_struct.x))
    return false;
  if (!mojo::Equals(this->y, other_struct.y))
    return false;
  if (!mojo::Equals(this->width, other_struct.width))
    return false;
  if (!mojo::Equals(this->height, other_struct.height))
    return false;
  if (!mojo::Equals(this->suggestions, other_struct.suggestions))
    return false;
  return true;
}

template <typename T, AutofillPopupRequestDeprecated::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.x < rhs.x)
    return true;
  if (rhs.x < lhs.x)
    return false;
  if (lhs.y < rhs.y)
    return true;
  if (rhs.y < lhs.y)
    return false;
  if (lhs.width < rhs.width)
    return true;
  if (rhs.width < lhs.width)
    return false;
  if (lhs.height < rhs.height)
    return true;
  if (rhs.height < lhs.height)
    return false;
  if (lhs.suggestions < rhs.suggestions)
    return true;
  if (rhs.suggestions < lhs.suggestions)
    return false;
  return false;
}


}  // owl::mojom

namespace mojo {


template <>
struct  StructTraits<::owl::mojom::AutofillPopupRequestDeprecated::DataView,
                                         ::owl::mojom::AutofillPopupRequestDeprecatedPtr> {
  static bool IsNull(const ::owl::mojom::AutofillPopupRequestDeprecatedPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::AutofillPopupRequestDeprecatedPtr* output) { output->reset(); }

  static decltype(::owl::mojom::AutofillPopupRequestDeprecated::x) x(
      const ::owl::mojom::AutofillPopupRequestDeprecatedPtr& input) {
    return input->x;
  }

  static decltype(::owl::mojom::AutofillPopupRequestDeprecated::y) y(
      const ::owl::mojom::AutofillPopupRequestDeprecatedPtr& input) {
    return input->y;
  }

  static decltype(::owl::mojom::AutofillPopupRequestDeprecated::width) width(
      const ::owl::mojom::AutofillPopupRequestDeprecatedPtr& input) {
    return input->width;
  }

  static decltype(::owl::mojom::AutofillPopupRequestDeprecated::height) height(
      const ::owl::mojom::AutofillPopupRequestDeprecatedPtr& input) {
    return input->height;
  }

  static  decltype(::owl::mojom::AutofillPopupRequestDeprecated::suggestions)& suggestions(
       ::owl::mojom::AutofillPopupRequestDeprecatedPtr& input) {
    return input->suggestions;
  }

  static bool Read(::owl::mojom::AutofillPopupRequestDeprecated::DataView input, ::owl::mojom::AutofillPopupRequestDeprecatedPtr* output);
};

}  // namespace mojo

#endif  // OWL_MOJOM_AUTOFILL_DEPRECATED_MOJOM_H_