// mojo/public/mojom/base/values.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "mojo/public/mojom/base/values.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "mojo/public/mojom/base/values.mojom-params-data.h"
#include "mojo/public/mojom/base/values.mojom-shared-message-ids.h"

#include "mojo/public/mojom/base/values.mojom-blink-import-headers.h"
#include "mojo/public/mojom/base/values.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace mojo_base::mojom::blink {
DictionaryValue::DictionaryValue()
    : storage() {}

DictionaryValue::DictionaryValue(
    ::blink::HashMap<::blink::String, ::base::Value> storage_in)
    : storage(std::move(storage_in)) {}

DictionaryValue::~DictionaryValue() = default;

void DictionaryValue::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "storage"), this->storage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::HashMap<::blink::String, ::base::Value>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DictionaryValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ListValue::ListValue()
    : storage() {}

ListValue::ListValue(
    ::blink::Vector<::base::Value> storage_in)
    : storage(std::move(storage_in)) {}

ListValue::~ListValue() = default;

void ListValue::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "storage"), this->storage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<::base::Value>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ListValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ValuePtr
Value::NewNullValue(
    uint8_t value) {
  return ValuePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kNullValue)>,
      std::move(value));
}

ValuePtr
Value::NewBoolValue(
    bool value) {
  return ValuePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kBoolValue)>,
      std::move(value));
}

ValuePtr
Value::NewIntValue(
    int32_t value) {
  return ValuePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kIntValue)>,
      std::move(value));
}

ValuePtr
Value::NewDoubleValue(
    double value) {
  return ValuePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kDoubleValue)>,
      std::move(value));
}

ValuePtr
Value::NewStringValue(
    const ::blink::String& value) {
  return ValuePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kStringValue)>,
      std::move(value));
}

ValuePtr
Value::NewBinaryValue(
    ::blink::Vector<uint8_t> value) {
  return ValuePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kBinaryValue)>,
      std::move(value));
}

ValuePtr
Value::NewDictionaryValue(
    ::base::Value::Dict value) {
  return ValuePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kDictionaryValue)>,
      std::move(value));
}

ValuePtr
Value::NewListValue(
    ::base::Value::List value) {
  return ValuePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kListValue)>,
      std::move(value));
}

Value::Value(
    std::in_place_index_t<static_cast<size_t>(Tag::kNullValue)>,
    uint8_t value)
    : tag_(Tag::kNullValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kNullValue)>,
            std::move(value)) {}

Value::Value(
    std::in_place_index_t<static_cast<size_t>(Tag::kBoolValue)>,
    bool value)
    : tag_(Tag::kBoolValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kBoolValue)>,
            std::move(value)) {}

Value::Value(
    std::in_place_index_t<static_cast<size_t>(Tag::kIntValue)>,
    int32_t value)
    : tag_(Tag::kIntValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kIntValue)>,
            std::move(value)) {}

Value::Value(
    std::in_place_index_t<static_cast<size_t>(Tag::kDoubleValue)>,
    double value)
    : tag_(Tag::kDoubleValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kDoubleValue)>,
            std::move(value)) {}

Value::Value(
    std::in_place_index_t<static_cast<size_t>(Tag::kStringValue)>,
    const ::blink::String& value)
    : tag_(Tag::kStringValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kStringValue)>,
            std::move(value)) {}

Value::Value(
    std::in_place_index_t<static_cast<size_t>(Tag::kBinaryValue)>,
    ::blink::Vector<uint8_t> value)
    : tag_(Tag::kBinaryValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kBinaryValue)>,
            std::move(value)) {}

Value::Value(
    std::in_place_index_t<static_cast<size_t>(Tag::kDictionaryValue)>,
    ::base::Value::Dict value)
    : tag_(Tag::kDictionaryValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kDictionaryValue)>,
            std::move(value)) {}

Value::Value(
    std::in_place_index_t<static_cast<size_t>(Tag::kListValue)>,
    ::base::Value::List value)
    : tag_(Tag::kListValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kListValue)>,
            std::move(value)) {}
Value::~Value() {
  DestroyActive();
}

void Value::set_null_value(uint8_t null_value) {
  if (tag_ != Tag::kNullValue) {
    DestroyActive();
    tag_ = Tag::kNullValue;
  }
  data_.null_value = null_value;
}

void Value::set_bool_value(bool bool_value) {
  if (tag_ != Tag::kBoolValue) {
    DestroyActive();
    tag_ = Tag::kBoolValue;
  }
  data_.bool_value = bool_value;
}

void Value::set_int_value(int32_t int_value) {
  if (tag_ != Tag::kIntValue) {
    DestroyActive();
    tag_ = Tag::kIntValue;
  }
  data_.int_value = int_value;
}

void Value::set_double_value(double double_value) {
  if (tag_ != Tag::kDoubleValue) {
    DestroyActive();
    tag_ = Tag::kDoubleValue;
  }
  data_.double_value = double_value;
}

void Value::set_string_value(const ::blink::String& string_value) {
  if (tag_ == Tag::kStringValue) {
    data_.string_value = std::move(string_value);
  } else {
    DestroyActive();
    tag_ = Tag::kStringValue;
    new (&data_.string_value) ::blink::String(
        std::move(string_value));
  }
}

void Value::set_binary_value(::blink::Vector<uint8_t> binary_value) {
  if (tag_ == Tag::kBinaryValue) {
    data_.binary_value = std::move(binary_value);
  } else {
    DestroyActive();
    tag_ = Tag::kBinaryValue;
    new (&data_.binary_value) ::blink::Vector<uint8_t>(
        std::move(binary_value));
  }
}

void Value::set_dictionary_value(::base::Value::Dict dictionary_value) {
  if (tag_ == Tag::kDictionaryValue) {
    data_.dictionary_value = std::move(dictionary_value);
  } else {
    DestroyActive();
    tag_ = Tag::kDictionaryValue;
    new (&data_.dictionary_value) ::base::Value::Dict(
        std::move(dictionary_value));
  }
}

void Value::set_list_value(::base::Value::List list_value) {
  if (tag_ == Tag::kListValue) {
    data_.list_value = std::move(list_value);
  } else {
    DestroyActive();
    tag_ = Tag::kListValue;
    new (&data_.list_value) ::base::Value::List(
        std::move(list_value));
  }
}


Value::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kNullValue)>,
    uint8_t value)
    : null_value(std::move(value)) {}

Value::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kBoolValue)>,
    bool value)
    : bool_value(std::move(value)) {}

Value::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kIntValue)>,
    int32_t value)
    : int_value(std::move(value)) {}

Value::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kDoubleValue)>,
    double value)
    : double_value(std::move(value)) {}

Value::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kStringValue)>,
    const ::blink::String& value)
    : string_value(std::move(value)) {}

Value::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kBinaryValue)>,
    ::blink::Vector<uint8_t> value)
    : binary_value(std::move(value)) {}

Value::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kDictionaryValue)>,
    ::base::Value::Dict value)
    : dictionary_value(std::move(value)) {}

Value::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kListValue)>,
    ::base::Value::List value)
    : list_value(std::move(value)) {}

void Value::DestroyActive() {
  switch (tag_) {

    case Tag::kNullValue:
      std::destroy_at(&data_.null_value);
      break;
    case Tag::kBoolValue:
      std::destroy_at(&data_.bool_value);
      break;
    case Tag::kIntValue:
      std::destroy_at(&data_.int_value);
      break;
    case Tag::kDoubleValue:
      std::destroy_at(&data_.double_value);
      break;
    case Tag::kStringValue:
      std::destroy_at(&data_.string_value);
      break;
    case Tag::kBinaryValue:
      std::destroy_at(&data_.binary_value);
      break;
    case Tag::kDictionaryValue:
      std::destroy_at(&data_.dictionary_value);
      break;
    case Tag::kListValue:
      std::destroy_at(&data_.list_value);
      break;
  }
}

bool Value::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // mojo_base::mojom::blink


namespace mojo {


// static
bool StructTraits<::mojo_base::mojom::blink::DictionaryValue::DataView, ::mojo_base::mojom::blink::DictionaryValuePtr>::Read(
    ::mojo_base::mojom::blink::DictionaryValue::DataView input,
    ::mojo_base::mojom::blink::DictionaryValuePtr* output) {
  bool success = true;
  ::mojo_base::mojom::blink::DictionaryValuePtr result(::mojo_base::mojom::blink::DictionaryValue::New());
  
      if (success && !input.ReadStorage(&result->storage))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::mojo_base::mojom::blink::ListValue::DataView, ::mojo_base::mojom::blink::ListValuePtr>::Read(
    ::mojo_base::mojom::blink::ListValue::DataView input,
    ::mojo_base::mojom::blink::ListValuePtr* output) {
  bool success = true;
  ::mojo_base::mojom::blink::ListValuePtr result(::mojo_base::mojom::blink::ListValue::New());
  
      if (success && !input.ReadStorage(&result->storage))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::mojo_base::mojom::blink::Value::DataView, ::mojo_base::mojom::blink::ValuePtr>::Read(
    ::mojo_base::mojom::blink::Value::DataView input,
    ::mojo_base::mojom::blink::ValuePtr* output) {
  using UnionType = ::mojo_base::mojom::blink::Value;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kNullValue: {
      *output = UnionType::NewNullValue(input.null_value());
      break;
    }
    case Tag::kBoolValue: {
      *output = UnionType::NewBoolValue(input.bool_value());
      break;
    }
    case Tag::kIntValue: {
      *output = UnionType::NewIntValue(input.int_value());
      break;
    }
    case Tag::kDoubleValue: {
      *output = UnionType::NewDoubleValue(input.double_value());
      break;
    }
    case Tag::kStringValue: {
      ::blink::String result_string_value{};
      if (!input.ReadStringValue(&result_string_value))
        return false;

      *output = UnionType::NewStringValue(
          std::move(result_string_value));
      break;
    }
    case Tag::kBinaryValue: {
      ::blink::Vector<uint8_t> result_binary_value{};
      if (!input.ReadBinaryValue(&result_binary_value))
        return false;

      *output = UnionType::NewBinaryValue(
          std::move(result_binary_value));
      break;
    }
    case Tag::kDictionaryValue: {
      ::base::Value::Dict result_dictionary_value{};
      if (!input.ReadDictionaryValue(&result_dictionary_value))
        return false;

      *output = UnionType::NewDictionaryValue(
          std::move(result_dictionary_value));
      break;
    }
    case Tag::kListValue: {
      ::base::Value::List result_list_value{};
      if (!input.ReadListValue(&result_list_value))
        return false;

      *output = UnionType::NewListValue(
          std::move(result_list_value));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace mojo_base::mojom::blink {




}  // mojo_base::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif