// mojo/public/mojom/base/shared_memory.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_MOJOM_BASE_SHARED_MEMORY_MOJOM_H_
#define MOJO_PUBLIC_MOJOM_BASE_SHARED_MEMORY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "mojo/public/mojom/base/shared_memory.mojom-features.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/shared_memory.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/base/shared_memory_mojom_traits.h"
#include "base/component_export.h"




namespace mojo_base::mojom {










class COMPONENT_EXPORT(MOJO_BASE_MOJOM) ReadOnlySharedMemoryRegion {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ReadOnlySharedMemoryRegion, T>::value>;
  using DataView = ReadOnlySharedMemoryRegionDataView;
  using Data_ = internal::ReadOnlySharedMemoryRegion_Data;

  template <typename... Args>
  static ReadOnlySharedMemoryRegionPtr New(Args&&... args) {
    return ReadOnlySharedMemoryRegionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ReadOnlySharedMemoryRegionPtr From(const U& u) {
    return mojo::TypeConverter<ReadOnlySharedMemoryRegionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ReadOnlySharedMemoryRegion>::Convert(*this);
  }


  ReadOnlySharedMemoryRegion();

  explicit ReadOnlySharedMemoryRegion(
      ::mojo::ScopedSharedBufferHandle buffer);

ReadOnlySharedMemoryRegion(const ReadOnlySharedMemoryRegion&) = delete;
ReadOnlySharedMemoryRegion& operator=(const ReadOnlySharedMemoryRegion&) = delete;

  ~ReadOnlySharedMemoryRegion();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ReadOnlySharedMemoryRegionPtr>
  ReadOnlySharedMemoryRegionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ReadOnlySharedMemoryRegion::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ReadOnlySharedMemoryRegion::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ReadOnlySharedMemoryRegion::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ReadOnlySharedMemoryRegion::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ReadOnlySharedMemoryRegion_UnserializedMessageContext<
            UserType, ReadOnlySharedMemoryRegion::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ReadOnlySharedMemoryRegion::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ReadOnlySharedMemoryRegion::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ReadOnlySharedMemoryRegion_UnserializedMessageContext<
            UserType, ReadOnlySharedMemoryRegion::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ReadOnlySharedMemoryRegion::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::ScopedSharedBufferHandle buffer;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ReadOnlySharedMemoryRegion::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ReadOnlySharedMemoryRegion::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ReadOnlySharedMemoryRegion::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ReadOnlySharedMemoryRegion::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(MOJO_BASE_MOJOM) WritableSharedMemoryRegion {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WritableSharedMemoryRegion, T>::value>;
  using DataView = WritableSharedMemoryRegionDataView;
  using Data_ = internal::WritableSharedMemoryRegion_Data;

  template <typename... Args>
  static WritableSharedMemoryRegionPtr New(Args&&... args) {
    return WritableSharedMemoryRegionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WritableSharedMemoryRegionPtr From(const U& u) {
    return mojo::TypeConverter<WritableSharedMemoryRegionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WritableSharedMemoryRegion>::Convert(*this);
  }


  WritableSharedMemoryRegion();

  explicit WritableSharedMemoryRegion(
      ::mojo::ScopedSharedBufferHandle buffer);

WritableSharedMemoryRegion(const WritableSharedMemoryRegion&) = delete;
WritableSharedMemoryRegion& operator=(const WritableSharedMemoryRegion&) = delete;

  ~WritableSharedMemoryRegion();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WritableSharedMemoryRegionPtr>
  WritableSharedMemoryRegionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WritableSharedMemoryRegion::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WritableSharedMemoryRegion::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WritableSharedMemoryRegion::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WritableSharedMemoryRegion::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WritableSharedMemoryRegion_UnserializedMessageContext<
            UserType, WritableSharedMemoryRegion::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WritableSharedMemoryRegion::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WritableSharedMemoryRegion::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WritableSharedMemoryRegion_UnserializedMessageContext<
            UserType, WritableSharedMemoryRegion::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WritableSharedMemoryRegion::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::ScopedSharedBufferHandle buffer;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WritableSharedMemoryRegion::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WritableSharedMemoryRegion::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WritableSharedMemoryRegion::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WritableSharedMemoryRegion::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(MOJO_BASE_MOJOM) UnsafeSharedMemoryRegion {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UnsafeSharedMemoryRegion, T>::value>;
  using DataView = UnsafeSharedMemoryRegionDataView;
  using Data_ = internal::UnsafeSharedMemoryRegion_Data;

  template <typename... Args>
  static UnsafeSharedMemoryRegionPtr New(Args&&... args) {
    return UnsafeSharedMemoryRegionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UnsafeSharedMemoryRegionPtr From(const U& u) {
    return mojo::TypeConverter<UnsafeSharedMemoryRegionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UnsafeSharedMemoryRegion>::Convert(*this);
  }


  UnsafeSharedMemoryRegion();

  explicit UnsafeSharedMemoryRegion(
      ::mojo::ScopedSharedBufferHandle buffer);

UnsafeSharedMemoryRegion(const UnsafeSharedMemoryRegion&) = delete;
UnsafeSharedMemoryRegion& operator=(const UnsafeSharedMemoryRegion&) = delete;

  ~UnsafeSharedMemoryRegion();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UnsafeSharedMemoryRegionPtr>
  UnsafeSharedMemoryRegionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UnsafeSharedMemoryRegion::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UnsafeSharedMemoryRegion::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UnsafeSharedMemoryRegion::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UnsafeSharedMemoryRegion::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UnsafeSharedMemoryRegion_UnserializedMessageContext<
            UserType, UnsafeSharedMemoryRegion::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UnsafeSharedMemoryRegion::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UnsafeSharedMemoryRegion::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UnsafeSharedMemoryRegion_UnserializedMessageContext<
            UserType, UnsafeSharedMemoryRegion::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UnsafeSharedMemoryRegion::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::ScopedSharedBufferHandle buffer;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UnsafeSharedMemoryRegion::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UnsafeSharedMemoryRegion::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UnsafeSharedMemoryRegion::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UnsafeSharedMemoryRegion::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ReadOnlySharedMemoryRegionPtr ReadOnlySharedMemoryRegion::Clone() const {
  return New(
      mojo::Clone(buffer)
  );
}

template <typename T, ReadOnlySharedMemoryRegion::EnableIfSame<T>*>
bool ReadOnlySharedMemoryRegion::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->buffer, other_struct.buffer))
    return false;
  return true;
}

template <typename T, ReadOnlySharedMemoryRegion::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.buffer < rhs.buffer)
    return true;
  if (rhs.buffer < lhs.buffer)
    return false;
  return false;
}
template <typename StructPtrType>
WritableSharedMemoryRegionPtr WritableSharedMemoryRegion::Clone() const {
  return New(
      mojo::Clone(buffer)
  );
}

template <typename T, WritableSharedMemoryRegion::EnableIfSame<T>*>
bool WritableSharedMemoryRegion::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->buffer, other_struct.buffer))
    return false;
  return true;
}

template <typename T, WritableSharedMemoryRegion::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.buffer < rhs.buffer)
    return true;
  if (rhs.buffer < lhs.buffer)
    return false;
  return false;
}
template <typename StructPtrType>
UnsafeSharedMemoryRegionPtr UnsafeSharedMemoryRegion::Clone() const {
  return New(
      mojo::Clone(buffer)
  );
}

template <typename T, UnsafeSharedMemoryRegion::EnableIfSame<T>*>
bool UnsafeSharedMemoryRegion::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->buffer, other_struct.buffer))
    return false;
  return true;
}

template <typename T, UnsafeSharedMemoryRegion::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.buffer < rhs.buffer)
    return true;
  if (rhs.buffer < lhs.buffer)
    return false;
  return false;
}


}  // mojo_base::mojom

namespace mojo {


template <>
struct COMPONENT_EXPORT(MOJO_BASE_MOJOM) StructTraits<::mojo_base::mojom::ReadOnlySharedMemoryRegion::DataView,
                                         ::mojo_base::mojom::ReadOnlySharedMemoryRegionPtr> {
  static bool IsNull(const ::mojo_base::mojom::ReadOnlySharedMemoryRegionPtr& input) { return !input; }
  static void SetToNull(::mojo_base::mojom::ReadOnlySharedMemoryRegionPtr* output) { output->reset(); }

  static  decltype(::mojo_base::mojom::ReadOnlySharedMemoryRegion::buffer)& buffer(
       ::mojo_base::mojom::ReadOnlySharedMemoryRegionPtr& input) {
    return input->buffer;
  }

  static bool Read(::mojo_base::mojom::ReadOnlySharedMemoryRegion::DataView input, ::mojo_base::mojom::ReadOnlySharedMemoryRegionPtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_BASE_MOJOM) StructTraits<::mojo_base::mojom::WritableSharedMemoryRegion::DataView,
                                         ::mojo_base::mojom::WritableSharedMemoryRegionPtr> {
  static bool IsNull(const ::mojo_base::mojom::WritableSharedMemoryRegionPtr& input) { return !input; }
  static void SetToNull(::mojo_base::mojom::WritableSharedMemoryRegionPtr* output) { output->reset(); }

  static  decltype(::mojo_base::mojom::WritableSharedMemoryRegion::buffer)& buffer(
       ::mojo_base::mojom::WritableSharedMemoryRegionPtr& input) {
    return input->buffer;
  }

  static bool Read(::mojo_base::mojom::WritableSharedMemoryRegion::DataView input, ::mojo_base::mojom::WritableSharedMemoryRegionPtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_BASE_MOJOM) StructTraits<::mojo_base::mojom::UnsafeSharedMemoryRegion::DataView,
                                         ::mojo_base::mojom::UnsafeSharedMemoryRegionPtr> {
  static bool IsNull(const ::mojo_base::mojom::UnsafeSharedMemoryRegionPtr& input) { return !input; }
  static void SetToNull(::mojo_base::mojom::UnsafeSharedMemoryRegionPtr* output) { output->reset(); }

  static  decltype(::mojo_base::mojom::UnsafeSharedMemoryRegion::buffer)& buffer(
       ::mojo_base::mojom::UnsafeSharedMemoryRegionPtr& input) {
    return input->buffer;
  }

  static bool Read(::mojo_base::mojom::UnsafeSharedMemoryRegion::DataView input, ::mojo_base::mojom::UnsafeSharedMemoryRegionPtr* output);
};

}  // namespace mojo

#endif  // MOJO_PUBLIC_MOJOM_BASE_SHARED_MEMORY_MOJOM_H_