// mojo/public/mojom/base/generic_pending_receiver.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'mojo/public/mojom/base/generic_pending_receiver.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('mojoBase.mojom');



  function GenericPendingReceiver(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GenericPendingReceiver.prototype.initDefaults_ = function() {
    this.interfaceName = null;
    this.receivingPipe = null;
  };
  GenericPendingReceiver.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GenericPendingReceiver.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GenericPendingReceiver.interfaceName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate GenericPendingReceiver.receivingPipe
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GenericPendingReceiver.encodedSize = codec.kStructHeaderSize + 16;

  GenericPendingReceiver.decode = function(decoder) {
    var packed;
    var val = new GenericPendingReceiver();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.interfaceName =
        decoder.decodeStruct(codec.String);
    val.receivingPipe =
        decoder.decodeStruct(codec.Handle);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  GenericPendingReceiver.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GenericPendingReceiver.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.interfaceName);
    encoder.encodeStruct(codec.Handle, val.receivingPipe);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  exports.GenericPendingReceiver = GenericPendingReceiver;
})();