// mojo/public/mojom/base/error.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "mojo/public/mojom/base/error.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "mojo/public/mojom/base/error.mojom-params-data.h"
namespace mojo_base {
namespace mojom {

NOINLINE static const char* CodeToStringHelper(Code value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Code::kCancelled:
      return "kCancelled";
    case Code::kUnknown:
      return "kUnknown";
    case Code::kInvalidArgument:
      return "kInvalidArgument";
    case Code::kDeadlineExceeded:
      return "kDeadlineExceeded";
    case Code::kNotFound:
      return "kNotFound";
    case Code::kAlreadyExists:
      return "kAlreadyExists";
    case Code::kPermissionDenied:
      return "kPermissionDenied";
    case Code::kResourceExhausted:
      return "kResourceExhausted";
    case Code::kFailedPrecondition:
      return "kFailedPrecondition";
    case Code::kAborted:
      return "kAborted";
    case Code::kOutOfRange:
      return "kOutOfRange";
    case Code::kUnimplemented:
      return "kUnimplemented";
    case Code::kInternal:
      return "kInternal";
    case Code::kUnavailable:
      return "kUnavailable";
    case Code::kDataLoss:
      return "kDataLoss";
    case Code::kUnauthenticated:
      return "kUnauthenticated";
    default:
      return nullptr;
  }
}

std::string CodeToString(Code value) {
  const char *str = CodeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Code value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Code value) {
  return os << CodeToString(value);
}

namespace internal {


// static
bool Error_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Error_Data* object =
      static_cast<const Error_Data*>(data);


  if (!::mojo_base::mojom::internal::Code_Data
        ::Validate(object->code, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

Error_Data::Error_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace mojo_base

namespace perfetto {

// static
void TraceFormatTraits<::mojo_base::mojom::Code>::WriteIntoTrace(
   perfetto::TracedValue context, ::mojo_base::mojom::Code value) {
  return std::move(context).WriteString(::mojo_base::mojom::CodeToString(value));
}

} // namespace perfetto