// mojo/public/mojom/base/empty.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_MOJOM_BASE_EMPTY_MOJOM_H_
#define MOJO_PUBLIC_MOJOM_BASE_EMPTY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "mojo/public/mojom/base/empty.mojom-features.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/empty.mojom-shared.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/empty.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "mojo/public/cpp/base/empty_mojom_traits.h"
#include "base/component_export.h"




namespace mojo_base::mojom {





class COMPONENT_EXPORT(MOJO_BASE_MOJOM) Empty {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Empty, T>::value>;
  using DataView = EmptyDataView;
  using Data_ = internal::Empty_Data;

  template <typename... Args>
  static EmptyPtr New(Args&&... args) {
    return EmptyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EmptyPtr From(const U& u) {
    return mojo::TypeConverter<EmptyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Empty>::Convert(*this);
  }


  Empty();


  ~Empty();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EmptyPtr>
  EmptyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Empty::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Empty::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Empty::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Empty::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Empty::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Empty::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Empty_UnserializedMessageContext<
            UserType, Empty::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Empty::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Empty::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Empty_UnserializedMessageContext<
            UserType, Empty::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Empty::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Empty::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Empty::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Empty::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Empty::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
EmptyPtr Empty::Clone() const {
  return New(
  );
}

template <typename T, Empty::EnableIfSame<T>*>
bool Empty::Equals(const T& other_struct) const {
  return true;
}

template <typename T, Empty::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}


}  // mojo_base::mojom

namespace mojo {


template <>
struct COMPONENT_EXPORT(MOJO_BASE_MOJOM) StructTraits<::mojo_base::mojom::Empty::DataView,
                                         ::mojo_base::mojom::EmptyPtr> {
  static bool IsNull(const ::mojo_base::mojom::EmptyPtr& input) { return !input; }
  static void SetToNull(::mojo_base::mojom::EmptyPtr* output) { output->reset(); }

  static bool Read(::mojo_base::mojom::Empty::DataView input, ::mojo_base::mojom::EmptyPtr* output);
};

}  // namespace mojo

#endif  // MOJO_PUBLIC_MOJOM_BASE_EMPTY_MOJOM_H_