// media/mojo/mojom/webrtc_video_perf.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_WEBRTC_VIDEO_PERF_MOJOM_DATA_VIEW_H_
#define MEDIA_MOJO_MOJOM_WEBRTC_VIDEO_PERF_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "media/mojo/mojom/webrtc_video_perf.mojom-shared-internal.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"


namespace media::mojom {
class WebrtcPredictionFeaturesDataView;

class WebrtcVideoStatsDataView;



}  // media::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::WebrtcPredictionFeaturesDataView> {
  using Data = ::media::mojom::internal::WebrtcPredictionFeatures_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::WebrtcVideoStatsDataView> {
  using Data = ::media::mojom::internal::WebrtcVideoStats_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {
// Interface base classes. They are used for type safety check.
class WebrtcVideoPerfRecorderInterfaceBase {};

using WebrtcVideoPerfRecorderPtrDataView =
    mojo::InterfacePtrDataView<WebrtcVideoPerfRecorderInterfaceBase>;
using WebrtcVideoPerfRecorderRequestDataView =
    mojo::InterfaceRequestDataView<WebrtcVideoPerfRecorderInterfaceBase>;
using WebrtcVideoPerfRecorderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebrtcVideoPerfRecorderInterfaceBase>;
using WebrtcVideoPerfRecorderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebrtcVideoPerfRecorderInterfaceBase>;
class WebrtcVideoPerfHistoryInterfaceBase {};

using WebrtcVideoPerfHistoryPtrDataView =
    mojo::InterfacePtrDataView<WebrtcVideoPerfHistoryInterfaceBase>;
using WebrtcVideoPerfHistoryRequestDataView =
    mojo::InterfaceRequestDataView<WebrtcVideoPerfHistoryInterfaceBase>;
using WebrtcVideoPerfHistoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebrtcVideoPerfHistoryInterfaceBase>;
using WebrtcVideoPerfHistoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebrtcVideoPerfHistoryInterfaceBase>;


class WebrtcPredictionFeaturesDataView {
 public:
  WebrtcPredictionFeaturesDataView() = default;

  WebrtcPredictionFeaturesDataView(
      internal::WebrtcPredictionFeatures_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool is_decode_stats() const {
    return data_->is_decode_stats;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadProfile(UserType* output) const {
    auto data_value = data_->profile;
    return mojo::internal::Deserialize<::media::mojom::VideoCodecProfile>(
        data_value, output);
  }
  ::media::mojom::VideoCodecProfile profile() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoCodecProfile>(data_->profile));
  }
  int32_t video_pixels() const {
    return data_->video_pixels;
  }
  bool hardware_accelerated() const {
    return data_->hardware_accelerated;
  }
 private:
  internal::WebrtcPredictionFeatures_Data* data_ = nullptr;
};


class WebrtcVideoStatsDataView {
 public:
  WebrtcVideoStatsDataView() = default;

  WebrtcVideoStatsDataView(
      internal::WebrtcVideoStats_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t frames_processed() const {
    return data_->frames_processed;
  }
  uint32_t key_frames_processed() const {
    return data_->key_frames_processed;
  }
  float p99_processing_time_ms() const {
    return data_->p99_processing_time_ms;
  }
 private:
  internal::WebrtcVideoStats_Data* data_ = nullptr;
};


}  // media::mojom

#endif  // MEDIA_MOJO_MOJOM_WEBRTC_VIDEO_PERF_MOJOM_DATA_VIEW_H_