// media/mojo/mojom/video_decoder.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/video_decoder.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/video_decoder.mojom-params-data.h"
#include "media/mojo/mojom/video_decoder.mojom-shared-message-ids.h"

#include "media/mojo/mojom/video_decoder.mojom-blink-import-headers.h"
#include "media/mojo/mojom/video_decoder.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace media::mojom::blink {
SupportedVideoDecoderConfig::SupportedVideoDecoderConfig()
    : profile_min(),
      profile_max(),
      coded_size_min(),
      coded_size_max(),
      allow_encrypted(),
      require_encrypted() {}

SupportedVideoDecoderConfig::SupportedVideoDecoderConfig(
    ::media::VideoCodecProfile profile_min_in,
    ::media::VideoCodecProfile profile_max_in,
    const ::gfx::Size& coded_size_min_in,
    const ::gfx::Size& coded_size_max_in,
    bool allow_encrypted_in,
    bool require_encrypted_in)
    : profile_min(std::move(profile_min_in)),
      profile_max(std::move(profile_max_in)),
      coded_size_min(std::move(coded_size_min_in)),
      coded_size_max(std::move(coded_size_max_in)),
      allow_encrypted(std::move(allow_encrypted_in)),
      require_encrypted(std::move(require_encrypted_in)) {}

SupportedVideoDecoderConfig::~SupportedVideoDecoderConfig() = default;

void SupportedVideoDecoderConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "profile_min"), this->profile_min,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoCodecProfile>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "profile_max"), this->profile_max,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoCodecProfile>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "coded_size_min"), this->coded_size_min,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "coded_size_max"), this->coded_size_max,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_encrypted"), this->allow_encrypted,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "require_encrypted"), this->require_encrypted,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SupportedVideoDecoderConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CommandBufferId::CommandBufferId()
    : channel_token(),
      route_id() {}

CommandBufferId::CommandBufferId(
    const ::base::UnguessableToken& channel_token_in,
    int32_t route_id_in)
    : channel_token(std::move(channel_token_in)),
      route_id(std::move(route_id_in)) {}

CommandBufferId::~CommandBufferId() = default;

void CommandBufferId::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "channel_token"), this->channel_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::UnguessableToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "route_id"), this->route_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CommandBufferId::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CdmPtr
Cdm::NewCdmId(
    const ::base::UnguessableToken& value) {
  return CdmPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kCdmId)>,
      std::move(value));
}

Cdm::Cdm(
    std::in_place_index_t<static_cast<size_t>(Tag::kCdmId)>,
    const ::base::UnguessableToken& value)
    : tag_(Tag::kCdmId),
      data_(std::in_place_index<static_cast<size_t>(Tag::kCdmId)>,
            std::move(value)) {}
Cdm::~Cdm() {
  DestroyActive();
}

void Cdm::set_cdm_id(const ::base::UnguessableToken& cdm_id) {
  if (tag_ == Tag::kCdmId) {
    data_.cdm_id = std::move(cdm_id);
  } else {
    DestroyActive();
    tag_ = Tag::kCdmId;
    new (&data_.cdm_id) ::base::UnguessableToken(
        std::move(cdm_id));
  }
}


Cdm::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kCdmId)>,
    const ::base::UnguessableToken& value)
    : cdm_id(std::move(value)) {}

void Cdm::DestroyActive() {
  switch (tag_) {

    case Tag::kCdmId:
      std::destroy_at(&data_.cdm_id);
      break;
  }
}

bool Cdm::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

VideoFrameHandleReleaser::IPCStableHashFunction VideoFrameHandleReleaser::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::VideoFrameHandleReleaser>(message.name())) {
    case messages::VideoFrameHandleReleaser::kReleaseVideoFrame: {
      return &VideoFrameHandleReleaser::ReleaseVideoFrame_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* VideoFrameHandleReleaser::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::VideoFrameHandleReleaser>(message.name())) {
      case messages::VideoFrameHandleReleaser::kReleaseVideoFrame:
            return "Receive media::mojom::VideoFrameHandleReleaser::ReleaseVideoFrame";
    }
  } else {
    switch (static_cast<messages::VideoFrameHandleReleaser>(message.name())) {
      case messages::VideoFrameHandleReleaser::kReleaseVideoFrame:
            return "Receive reply media::mojom::VideoFrameHandleReleaser::ReleaseVideoFrame";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t VideoFrameHandleReleaser::ReleaseVideoFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe771a835;  // IPCStableHash for media::mojom::VideoFrameHandleReleaser::ReleaseVideoFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

VideoFrameHandleReleaserProxy::VideoFrameHandleReleaserProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VideoFrameHandleReleaserProxy::ReleaseVideoFrame(
    const ::base::UnguessableToken& in_release_token, const std::optional<::gpu::SyncToken>& in_release_sync_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoFrameHandleReleaser::ReleaseVideoFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("release_token"), in_release_token,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("release_sync_token"), in_release_sync_token,
                        "<value of type const std::optional<::gpu::SyncToken>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoFrameHandleReleaser::kReleaseVideoFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoFrameHandleReleaser_ReleaseVideoFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->release_token)::BaseType> release_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_release_token,
    release_token_fragment);

  params->release_token.Set(
      release_token_fragment.is_null() ? nullptr : release_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->release_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null release_token in VideoFrameHandleReleaser.ReleaseVideoFrame request");
  mojo::internal::MessageFragment<
      typename decltype(params->release_sync_token)::BaseType> release_sync_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView>(
    in_release_sync_token,
    release_sync_token_fragment);

  params->release_sync_token.Set(
      release_sync_token_fragment.is_null() ? nullptr : release_sync_token_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoFrameHandleReleaser::Name_);
  message.set_method_name("ReleaseVideoFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool VideoFrameHandleReleaserStubDispatch::Accept(
    VideoFrameHandleReleaser* impl,
    mojo::Message* message) {
  switch (static_cast<messages::VideoFrameHandleReleaser>(message->header()->name)) {
    case messages::VideoFrameHandleReleaser::kReleaseVideoFrame: {
      DCHECK(message->is_serialized());
      internal::VideoFrameHandleReleaser_ReleaseVideoFrame_Params_Data* params =
          reinterpret_cast<internal::VideoFrameHandleReleaser_ReleaseVideoFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoFrameHandleReleaser.0
      bool success = true;
      ::base::UnguessableToken p_release_token{};
      std::optional<::gpu::SyncToken> p_release_sync_token{};
      VideoFrameHandleReleaser_ReleaseVideoFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReleaseToken(&p_release_token))
        success = false;
      if (success && !input_data_view.ReadReleaseSyncToken(&p_release_sync_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoFrameHandleReleaser::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReleaseVideoFrame(        
        std::move(p_release_token), 
        std::move(p_release_sync_token));
      return true;
    }
  }
  return false;
}

// static
bool VideoFrameHandleReleaserStubDispatch::AcceptWithResponder(
    VideoFrameHandleReleaser* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::VideoFrameHandleReleaser>(message->header()->name)) {
    case messages::VideoFrameHandleReleaser::kReleaseVideoFrame: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kVideoFrameHandleReleaserValidationInfo[] = {
    { &internal::VideoFrameHandleReleaser_ReleaseVideoFrame_Params_Data::Validate,
     nullptr /* no response */},
};

bool VideoFrameHandleReleaserRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::blink::VideoFrameHandleReleaser::Name_,
    kVideoFrameHandleReleaserValidationInfo);
}

// The declaration includes the definition on other builds.

VideoDecoder::IPCStableHashFunction VideoDecoder::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::VideoDecoder>(message.name())) {
    case messages::VideoDecoder::kGetSupportedConfigs: {
      return &VideoDecoder::GetSupportedConfigs_Sym::IPCStableHash;
    }
    case messages::VideoDecoder::kConstruct: {
      return &VideoDecoder::Construct_Sym::IPCStableHash;
    }
    case messages::VideoDecoder::kInitialize: {
      return &VideoDecoder::Initialize_Sym::IPCStableHash;
    }
    case messages::VideoDecoder::kDecode: {
      return &VideoDecoder::Decode_Sym::IPCStableHash;
    }
    case messages::VideoDecoder::kReset: {
      return &VideoDecoder::Reset_Sym::IPCStableHash;
    }
    case messages::VideoDecoder::kOnOverlayInfoChanged: {
      return &VideoDecoder::OnOverlayInfoChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* VideoDecoder::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::VideoDecoder>(message.name())) {
      case messages::VideoDecoder::kGetSupportedConfigs:
            return "Receive media::mojom::VideoDecoder::GetSupportedConfigs";
      case messages::VideoDecoder::kConstruct:
            return "Receive media::mojom::VideoDecoder::Construct";
      case messages::VideoDecoder::kInitialize:
            return "Receive media::mojom::VideoDecoder::Initialize";
      case messages::VideoDecoder::kDecode:
            return "Receive media::mojom::VideoDecoder::Decode";
      case messages::VideoDecoder::kReset:
            return "Receive media::mojom::VideoDecoder::Reset";
      case messages::VideoDecoder::kOnOverlayInfoChanged:
            return "Receive media::mojom::VideoDecoder::OnOverlayInfoChanged";
    }
  } else {
    switch (static_cast<messages::VideoDecoder>(message.name())) {
      case messages::VideoDecoder::kGetSupportedConfigs:
            return "Receive reply media::mojom::VideoDecoder::GetSupportedConfigs";
      case messages::VideoDecoder::kConstruct:
            return "Receive reply media::mojom::VideoDecoder::Construct";
      case messages::VideoDecoder::kInitialize:
            return "Receive reply media::mojom::VideoDecoder::Initialize";
      case messages::VideoDecoder::kDecode:
            return "Receive reply media::mojom::VideoDecoder::Decode";
      case messages::VideoDecoder::kReset:
            return "Receive reply media::mojom::VideoDecoder::Reset";
      case messages::VideoDecoder::kOnOverlayInfoChanged:
            return "Receive reply media::mojom::VideoDecoder::OnOverlayInfoChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t VideoDecoder::GetSupportedConfigs_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbed435bc;  // IPCStableHash for media::mojom::VideoDecoder::GetSupportedConfigs
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoDecoder::Construct_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9628c7e0;  // IPCStableHash for media::mojom::VideoDecoder::Construct
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoDecoder::Initialize_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x580d5c3b;  // IPCStableHash for media::mojom::VideoDecoder::Initialize
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoDecoder::Decode_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa76d6651;  // IPCStableHash for media::mojom::VideoDecoder::Decode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoDecoder::Reset_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7828121a;  // IPCStableHash for media::mojom::VideoDecoder::Reset
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoDecoder::OnOverlayInfoChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7168e8fb;  // IPCStableHash for media::mojom::VideoDecoder::OnOverlayInfoChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool VideoDecoder::GetSupportedConfigs(::blink::Vector<SupportedVideoDecoderConfigPtr>* out_supported_configs, ::media::VideoDecoderType* out_decoder_type) {
  NOTREACHED();
}
class VideoDecoder_GetSupportedConfigs_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  VideoDecoder_GetSupportedConfigs_HandleSyncResponse(
      bool* result, ::blink::Vector<SupportedVideoDecoderConfigPtr>* out_supported_configs, ::media::VideoDecoderType* out_decoder_type)
      : result_(result), out_supported_configs_(out_supported_configs), out_decoder_type_(out_decoder_type) {
    DCHECK(!*result_);
  }

  VideoDecoder_GetSupportedConfigs_HandleSyncResponse(const VideoDecoder_GetSupportedConfigs_HandleSyncResponse&) = delete;
  VideoDecoder_GetSupportedConfigs_HandleSyncResponse& operator=(const VideoDecoder_GetSupportedConfigs_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::blink::Vector<SupportedVideoDecoderConfigPtr>* out_supported_configs_;
  ::media::VideoDecoderType* out_decoder_type_;};

class VideoDecoder_GetSupportedConfigs_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VideoDecoder_GetSupportedConfigs_ForwardToCallback(
      VideoDecoder::GetSupportedConfigsCallback callback
      ) : callback_(std::move(callback)) {
  }

  VideoDecoder_GetSupportedConfigs_ForwardToCallback(const VideoDecoder_GetSupportedConfigs_ForwardToCallback&) = delete;
  VideoDecoder_GetSupportedConfigs_ForwardToCallback& operator=(const VideoDecoder_GetSupportedConfigs_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  VideoDecoder::GetSupportedConfigsCallback callback_;
};

class VideoDecoder_Initialize_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VideoDecoder_Initialize_ForwardToCallback(
      VideoDecoder::InitializeCallback callback
      ) : callback_(std::move(callback)) {
  }

  VideoDecoder_Initialize_ForwardToCallback(const VideoDecoder_Initialize_ForwardToCallback&) = delete;
  VideoDecoder_Initialize_ForwardToCallback& operator=(const VideoDecoder_Initialize_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  VideoDecoder::InitializeCallback callback_;
};

class VideoDecoder_Decode_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VideoDecoder_Decode_ForwardToCallback(
      VideoDecoder::DecodeCallback callback
      ) : callback_(std::move(callback)) {
  }

  VideoDecoder_Decode_ForwardToCallback(const VideoDecoder_Decode_ForwardToCallback&) = delete;
  VideoDecoder_Decode_ForwardToCallback& operator=(const VideoDecoder_Decode_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  VideoDecoder::DecodeCallback callback_;
};

class VideoDecoder_Reset_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VideoDecoder_Reset_ForwardToCallback(
      VideoDecoder::ResetCallback callback
      ) : callback_(std::move(callback)) {
  }

  VideoDecoder_Reset_ForwardToCallback(const VideoDecoder_Reset_ForwardToCallback&) = delete;
  VideoDecoder_Reset_ForwardToCallback& operator=(const VideoDecoder_Reset_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  VideoDecoder::ResetCallback callback_;
};

VideoDecoderProxy::VideoDecoderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool VideoDecoderProxy::GetSupportedConfigs(
    ::blink::Vector<SupportedVideoDecoderConfigPtr>* out_param_supported_configs, ::media::VideoDecoderType* out_param_decoder_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call media::mojom::VideoDecoder::GetSupportedConfigs (sync)");
#else
  TRACE_EVENT0("mojom", "VideoDecoder::GetSupportedConfigs");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoDecoder::kGetSupportedConfigs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoDecoder_GetSupportedConfigs_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoDecoder::Name_);
  message.set_method_name("GetSupportedConfigs");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoDecoder_GetSupportedConfigs_HandleSyncResponse(
          &result, out_param_supported_configs, out_param_decoder_type));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "VideoDecoder::GetSupportedConfigs", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("supported_configs"), out_param_supported_configs,
                        "<value of type ::blink::Vector<SupportedVideoDecoderConfigPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("decoder_type"), out_param_decoder_type,
                        "<value of type ::media::VideoDecoderType>");
   });
#endif
  return result;
}

void VideoDecoderProxy::GetSupportedConfigs(
    GetSupportedConfigsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::VideoDecoder::GetSupportedConfigs");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoDecoder::kGetSupportedConfigs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoDecoder_GetSupportedConfigs_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoDecoder::Name_);
  message.set_method_name("GetSupportedConfigs");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoDecoder_GetSupportedConfigs_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void VideoDecoderProxy::Construct(
    ::mojo::PendingAssociatedRemote<VideoDecoderClient> in_client, ::mojo::PendingRemote<::media::mojom::blink::MediaLog> in_media_log, ::mojo::PendingReceiver<VideoFrameHandleReleaser> in_video_frame_handle_releaser, ::mojo::ScopedDataPipeConsumerHandle in_decoder_buffer_pipe, CommandBufferIdPtr in_command_buffer_id, const ::gfx::ColorSpace& in_target_color_space) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoDecoder::Construct", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<VideoDecoderClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("media_log"), in_media_log,
                        "<value of type ::mojo::PendingRemote<::media::mojom::blink::MediaLog>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("video_frame_handle_releaser"), in_video_frame_handle_releaser,
                        "<value of type ::mojo::PendingReceiver<VideoFrameHandleReleaser>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("decoder_buffer_pipe"), in_decoder_buffer_pipe,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("command_buffer_id"), in_command_buffer_id,
                        "<value of type CommandBufferIdPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target_color_space"), in_target_color_space,
                        "<value of type const ::gfx::ColorSpace&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoDecoder::kConstruct), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoDecoder_Construct_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::VideoDecoderClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in VideoDecoder.Construct request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::MediaLogInterfaceBase>>(
    in_media_log,
    &params->media_log,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->media_log)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid media_log in VideoDecoder.Construct request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::VideoFrameHandleReleaserInterfaceBase>>(
    in_video_frame_handle_releaser,
    &params->video_frame_handle_releaser,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->video_frame_handle_releaser)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid video_frame_handle_releaser in VideoDecoder.Construct request");

  
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
    in_decoder_buffer_pipe,
    &params->decoder_buffer_pipe,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->decoder_buffer_pipe)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid decoder_buffer_pipe in VideoDecoder.Construct request");
  mojo::internal::MessageFragment<
      typename decltype(params->command_buffer_id)::BaseType> command_buffer_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::CommandBufferIdDataView>(
    in_command_buffer_id,
    command_buffer_id_fragment);

  params->command_buffer_id.Set(
      command_buffer_id_fragment.is_null() ? nullptr : command_buffer_id_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->target_color_space)::BaseType> target_color_space_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::ColorSpaceDataView>(
    in_target_color_space,
    target_color_space_fragment);

  params->target_color_space.Set(
      target_color_space_fragment.is_null() ? nullptr : target_color_space_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->target_color_space.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null target_color_space in VideoDecoder.Construct request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoDecoder::Name_);
  message.set_method_name("Construct");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoDecoderProxy::Initialize(
    ::media::mojom::blink::VideoDecoderConfigPtr in_config, bool in_low_delay, CdmPtr in_cdm, InitializeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoDecoder::Initialize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type ::media::mojom::blink::VideoDecoderConfigPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("low_delay"), in_low_delay,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cdm"), in_cdm,
                        "<value of type CdmPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoDecoder::kInitialize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoDecoder_Initialize_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::VideoDecoderConfigDataView>(
    in_config,
    config_fragment);

  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->config.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null config in VideoDecoder.Initialize request");

  params->low_delay = in_low_delay;
  mojo::internal::MessageFragment<decltype(params->cdm)>
      cdm_fragment(params.message());
  cdm_fragment.Claim(&params->cdm);
  
  mojo::internal::Serialize<::media::mojom::CdmDataView>(
    in_cdm,
    cdm_fragment,
    true);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoDecoder::Name_);
  message.set_method_name("Initialize");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoDecoder_Initialize_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void VideoDecoderProxy::Decode(
    ::media::mojom::blink::DecoderBufferPtr in_buffer, DecodeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoDecoder::Decode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type ::media::mojom::blink::DecoderBufferPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoDecoder::kDecode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoDecoder_Decode_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->buffer)>
      buffer_fragment(params.message());
  buffer_fragment.Claim(&params->buffer);
  
  mojo::internal::Serialize<::media::mojom::DecoderBufferDataView>(
    in_buffer,
    buffer_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->buffer.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null buffer in VideoDecoder.Decode request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoDecoder::Name_);
  message.set_method_name("Decode");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoDecoder_Decode_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void VideoDecoderProxy::Reset(
    ResetCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::VideoDecoder::Reset");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoDecoder::kReset), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoDecoder_Reset_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoDecoder::Name_);
  message.set_method_name("Reset");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoDecoder_Reset_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void VideoDecoderProxy::OnOverlayInfoChanged(
    OverlayInfoPtr in_overlay_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoDecoder::OnOverlayInfoChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("overlay_info"), in_overlay_info,
                        "<value of type OverlayInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoDecoder::kOnOverlayInfoChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoDecoder_OnOverlayInfoChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->overlay_info)::BaseType> overlay_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::OverlayInfoDataView>(
    in_overlay_info,
    overlay_info_fragment);

  params->overlay_info.Set(
      overlay_info_fragment.is_null() ? nullptr : overlay_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->overlay_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null overlay_info in VideoDecoder.OnOverlayInfoChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoDecoder::Name_);
  message.set_method_name("OnOverlayInfoChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class VideoDecoder_GetSupportedConfigs_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static VideoDecoder::GetSupportedConfigsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<VideoDecoder_GetSupportedConfigs_ProxyToResponder> proxy(
        new VideoDecoder_GetSupportedConfigs_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&VideoDecoder_GetSupportedConfigs_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VideoDecoder_GetSupportedConfigs_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  VideoDecoder_GetSupportedConfigs_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "VideoDecoder::GetSupportedConfigsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::Vector<SupportedVideoDecoderConfigPtr> in_supported_configs, ::media::VideoDecoderType in_decoder_type);
};

bool VideoDecoder_GetSupportedConfigs_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::VideoDecoder_GetSupportedConfigs_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VideoDecoder_GetSupportedConfigs_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for VideoDecoder.0
  bool success = true;
  ::blink::Vector<SupportedVideoDecoderConfigPtr> p_supported_configs{};
  ::media::VideoDecoderType p_decoder_type{};
  VideoDecoder_GetSupportedConfigs_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSupportedConfigs(&p_supported_configs))
    success = false;
  if (success && !input_data_view.ReadDecoderType(&p_decoder_type))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoDecoder::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_supported_configs), 
std::move(p_decoder_type));
  }
  return true;
}

void VideoDecoder_GetSupportedConfigs_ProxyToResponder::Run(
    ::blink::Vector<SupportedVideoDecoderConfigPtr> in_supported_configs, ::media::VideoDecoderType in_decoder_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::VideoDecoder::GetSupportedConfigs", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("supported_configs"), in_supported_configs,
                        "<value of type ::blink::Vector<SupportedVideoDecoderConfigPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("decoder_type"), in_decoder_type,
                        "<value of type ::media::VideoDecoderType>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoDecoder::kGetSupportedConfigs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoDecoder_GetSupportedConfigs_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->supported_configs)::BaseType>
      supported_configs_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& supported_configs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::SupportedVideoDecoderConfigDataView>>(
    in_supported_configs,
    supported_configs_fragment,
    &supported_configs_validate_params);

  params->supported_configs.Set(
      supported_configs_fragment.is_null() ? nullptr : supported_configs_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->supported_configs.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null supported_configs in ");

  
  mojo::internal::Serialize<::media::mojom::VideoDecoderType>(
    in_decoder_type,
    &params->decoder_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoDecoder::Name_);
  message.set_method_name("GetSupportedConfigs");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool VideoDecoder_GetSupportedConfigs_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::VideoDecoder_GetSupportedConfigs_ResponseParams_Data* params =
      reinterpret_cast<internal::VideoDecoder_GetSupportedConfigs_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for VideoDecoder.0
  bool success = true;
  ::blink::Vector<SupportedVideoDecoderConfigPtr> p_supported_configs{};
  ::media::VideoDecoderType p_decoder_type{};
  VideoDecoder_GetSupportedConfigs_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSupportedConfigs(&p_supported_configs))
    success = false;
  if (success && !input_data_view.ReadDecoderType(&p_decoder_type))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoDecoder::Name_, 0, true);
    return false;
  }
  *out_supported_configs_ = std::move(p_supported_configs);
  *out_decoder_type_ = std::move(p_decoder_type);
  *result_ = true;
  return true;
}
class VideoDecoder_Initialize_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static VideoDecoder::InitializeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<VideoDecoder_Initialize_ProxyToResponder> proxy(
        new VideoDecoder_Initialize_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&VideoDecoder_Initialize_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VideoDecoder_Initialize_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  VideoDecoder_Initialize_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "VideoDecoder::InitializeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::media::mojom::blink::DecoderStatusPtr in_status, bool in_needs_bitstream_conversion, int32_t in_max_decode_requests, ::media::VideoDecoderType in_decoder_type, bool in_needs_transcryption);
};

bool VideoDecoder_Initialize_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::VideoDecoder_Initialize_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VideoDecoder_Initialize_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for VideoDecoder.2
  bool success = true;
  ::media::mojom::blink::DecoderStatusPtr p_status{};
  bool p_needs_bitstream_conversion{};
  int32_t p_max_decode_requests{};
  ::media::VideoDecoderType p_decoder_type{};
  bool p_needs_transcryption{};
  VideoDecoder_Initialize_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success)
    p_needs_bitstream_conversion = input_data_view.needs_bitstream_conversion();
  if (success)
    p_max_decode_requests = input_data_view.max_decode_requests();
  if (success && !input_data_view.ReadDecoderType(&p_decoder_type))
    success = false;
  if (success)
    p_needs_transcryption = input_data_view.needs_transcryption();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoDecoder::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_needs_bitstream_conversion), 
std::move(p_max_decode_requests), 
std::move(p_decoder_type), 
std::move(p_needs_transcryption));
  }
  return true;
}

void VideoDecoder_Initialize_ProxyToResponder::Run(
    ::media::mojom::blink::DecoderStatusPtr in_status, bool in_needs_bitstream_conversion, int32_t in_max_decode_requests, ::media::VideoDecoderType in_decoder_type, bool in_needs_transcryption) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::VideoDecoder::Initialize", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::media::mojom::blink::DecoderStatusPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("needs_bitstream_conversion"), in_needs_bitstream_conversion,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_decode_requests"), in_max_decode_requests,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("decoder_type"), in_decoder_type,
                        "<value of type ::media::VideoDecoderType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("needs_transcryption"), in_needs_transcryption,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoDecoder::kInitialize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoDecoder_Initialize_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::DecoderStatusDataView>(
    in_status,
    status_fragment);

  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->status.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null status in ");

  params->needs_bitstream_conversion = in_needs_bitstream_conversion;

  params->max_decode_requests = in_max_decode_requests;

  
  mojo::internal::Serialize<::media::mojom::VideoDecoderType>(
    in_decoder_type,
    &params->decoder_type);

  params->needs_transcryption = in_needs_transcryption;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoDecoder::Name_);
  message.set_method_name("Initialize");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VideoDecoder_Decode_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static VideoDecoder::DecodeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<VideoDecoder_Decode_ProxyToResponder> proxy(
        new VideoDecoder_Decode_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&VideoDecoder_Decode_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VideoDecoder_Decode_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  VideoDecoder_Decode_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "VideoDecoder::DecodeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::media::mojom::blink::DecoderStatusPtr in_status);
};

bool VideoDecoder_Decode_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::VideoDecoder_Decode_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VideoDecoder_Decode_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for VideoDecoder.3
  bool success = true;
  ::media::mojom::blink::DecoderStatusPtr p_status{};
  VideoDecoder_Decode_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoDecoder::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void VideoDecoder_Decode_ProxyToResponder::Run(
    ::media::mojom::blink::DecoderStatusPtr in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::VideoDecoder::Decode", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::media::mojom::blink::DecoderStatusPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoDecoder::kDecode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoDecoder_Decode_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::DecoderStatusDataView>(
    in_status,
    status_fragment);

  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->status.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null status in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoDecoder::Name_);
  message.set_method_name("Decode");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VideoDecoder_Reset_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static VideoDecoder::ResetCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<VideoDecoder_Reset_ProxyToResponder> proxy(
        new VideoDecoder_Reset_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&VideoDecoder_Reset_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VideoDecoder_Reset_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  VideoDecoder_Reset_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "VideoDecoder::ResetCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool VideoDecoder_Reset_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::VideoDecoder_Reset_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VideoDecoder_Reset_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for VideoDecoder.4
  bool success = true;
  VideoDecoder_Reset_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoDecoder::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void VideoDecoder_Reset_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply media::mojom::VideoDecoder::Reset");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoDecoder::kReset), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoDecoder_Reset_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoDecoder::Name_);
  message.set_method_name("Reset");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool VideoDecoderStubDispatch::Accept(
    VideoDecoder* impl,
    mojo::Message* message) {
  switch (static_cast<messages::VideoDecoder>(message->header()->name)) {
    case messages::VideoDecoder::kGetSupportedConfigs: {
      break;
    }
    case messages::VideoDecoder::kConstruct: {
      DCHECK(message->is_serialized());
      internal::VideoDecoder_Construct_Params_Data* params =
          reinterpret_cast<internal::VideoDecoder_Construct_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoDecoder.1
      bool success = true;
      ::mojo::PendingAssociatedRemote<VideoDecoderClient> p_client{};
      ::mojo::PendingRemote<::media::mojom::blink::MediaLog> p_media_log{};
      ::mojo::PendingReceiver<VideoFrameHandleReleaser> p_video_frame_handle_releaser{};
      ::mojo::ScopedDataPipeConsumerHandle p_decoder_buffer_pipe{};
      CommandBufferIdPtr p_command_buffer_id{};
      ::gfx::ColorSpace p_target_color_space{};
      VideoDecoder_Construct_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success) {
        p_media_log =
            input_data_view.TakeMediaLog<decltype(p_media_log)>();
      }
      if (success) {
        p_video_frame_handle_releaser =
            input_data_view.TakeVideoFrameHandleReleaser<decltype(p_video_frame_handle_releaser)>();
      }
      if (success)
        p_decoder_buffer_pipe = input_data_view.TakeDecoderBufferPipe();
      if (success && !input_data_view.ReadCommandBufferId(&p_command_buffer_id))
        success = false;
      if (success && !input_data_view.ReadTargetColorSpace(&p_target_color_space))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoDecoder::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Construct(        
        std::move(p_client), 
        std::move(p_media_log), 
        std::move(p_video_frame_handle_releaser), 
        std::move(p_decoder_buffer_pipe), 
        std::move(p_command_buffer_id), 
        std::move(p_target_color_space));
      return true;
    }
    case messages::VideoDecoder::kInitialize: {
      break;
    }
    case messages::VideoDecoder::kDecode: {
      break;
    }
    case messages::VideoDecoder::kReset: {
      break;
    }
    case messages::VideoDecoder::kOnOverlayInfoChanged: {
      DCHECK(message->is_serialized());
      internal::VideoDecoder_OnOverlayInfoChanged_Params_Data* params =
          reinterpret_cast<internal::VideoDecoder_OnOverlayInfoChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoDecoder.5
      bool success = true;
      OverlayInfoPtr p_overlay_info{};
      VideoDecoder_OnOverlayInfoChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOverlayInfo(&p_overlay_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoDecoder::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnOverlayInfoChanged(        
        std::move(p_overlay_info));
      return true;
    }
  }
  return false;
}

// static
bool VideoDecoderStubDispatch::AcceptWithResponder(
    VideoDecoder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::VideoDecoder>(message->header()->name)) {
    case messages::VideoDecoder::kGetSupportedConfigs: {
      internal::VideoDecoder_GetSupportedConfigs_Params_Data* params =
          reinterpret_cast<
              internal::VideoDecoder_GetSupportedConfigs_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for VideoDecoder.0
      bool success = true;
      VideoDecoder_GetSupportedConfigs_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoDecoder::Name_, 0, false);
        return false;
      }
      auto callback =
          VideoDecoder_GetSupportedConfigs_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSupportedConfigs(std::move(callback));
      return true;
    }
    case messages::VideoDecoder::kConstruct: {
      break;
    }
    case messages::VideoDecoder::kInitialize: {
      internal::VideoDecoder_Initialize_Params_Data* params =
          reinterpret_cast<
              internal::VideoDecoder_Initialize_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for VideoDecoder.2
      bool success = true;
      ::media::mojom::blink::VideoDecoderConfigPtr p_config{};
      bool p_low_delay{};
      CdmPtr p_cdm{};
      VideoDecoder_Initialize_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfig(&p_config))
        success = false;
      if (success)
        p_low_delay = input_data_view.low_delay();
      if (success && !input_data_view.ReadCdm(&p_cdm))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoDecoder::Name_, 2, false);
        return false;
      }
      auto callback =
          VideoDecoder_Initialize_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Initialize(        
        std::move(p_config), 
        std::move(p_low_delay), 
        std::move(p_cdm), std::move(callback));
      return true;
    }
    case messages::VideoDecoder::kDecode: {
      internal::VideoDecoder_Decode_Params_Data* params =
          reinterpret_cast<
              internal::VideoDecoder_Decode_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for VideoDecoder.3
      bool success = true;
      ::media::mojom::blink::DecoderBufferPtr p_buffer{};
      VideoDecoder_Decode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoDecoder::Name_, 3, false);
        return false;
      }
      auto callback =
          VideoDecoder_Decode_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Decode(        
        std::move(p_buffer), std::move(callback));
      return true;
    }
    case messages::VideoDecoder::kReset: {
      internal::VideoDecoder_Reset_Params_Data* params =
          reinterpret_cast<
              internal::VideoDecoder_Reset_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for VideoDecoder.4
      bool success = true;
      VideoDecoder_Reset_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoDecoder::Name_, 4, false);
        return false;
      }
      auto callback =
          VideoDecoder_Reset_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Reset(std::move(callback));
      return true;
    }
    case messages::VideoDecoder::kOnOverlayInfoChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kVideoDecoderValidationInfo[] = {
    { &internal::VideoDecoder_GetSupportedConfigs_Params_Data::Validate,
     &internal::VideoDecoder_GetSupportedConfigs_ResponseParams_Data::Validate},
    { &internal::VideoDecoder_Construct_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VideoDecoder_Initialize_Params_Data::Validate,
     &internal::VideoDecoder_Initialize_ResponseParams_Data::Validate},
    { &internal::VideoDecoder_Decode_Params_Data::Validate,
     &internal::VideoDecoder_Decode_ResponseParams_Data::Validate},
    { &internal::VideoDecoder_Reset_Params_Data::Validate,
     &internal::VideoDecoder_Reset_ResponseParams_Data::Validate},
    { &internal::VideoDecoder_OnOverlayInfoChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool VideoDecoderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::blink::VideoDecoder::Name_,
    kVideoDecoderValidationInfo);
}

bool VideoDecoderResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::media::mojom::blink::VideoDecoder::Name_,
    kVideoDecoderValidationInfo);
}
// The declaration includes the definition on other builds.

VideoDecoderClient::IPCStableHashFunction VideoDecoderClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::VideoDecoderClient>(message.name())) {
    case messages::VideoDecoderClient::kOnVideoFrameDecoded: {
      return &VideoDecoderClient::OnVideoFrameDecoded_Sym::IPCStableHash;
    }
    case messages::VideoDecoderClient::kOnWaiting: {
      return &VideoDecoderClient::OnWaiting_Sym::IPCStableHash;
    }
    case messages::VideoDecoderClient::kRequestOverlayInfo: {
      return &VideoDecoderClient::RequestOverlayInfo_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* VideoDecoderClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::VideoDecoderClient>(message.name())) {
      case messages::VideoDecoderClient::kOnVideoFrameDecoded:
            return "Receive media::mojom::VideoDecoderClient::OnVideoFrameDecoded";
      case messages::VideoDecoderClient::kOnWaiting:
            return "Receive media::mojom::VideoDecoderClient::OnWaiting";
      case messages::VideoDecoderClient::kRequestOverlayInfo:
            return "Receive media::mojom::VideoDecoderClient::RequestOverlayInfo";
    }
  } else {
    switch (static_cast<messages::VideoDecoderClient>(message.name())) {
      case messages::VideoDecoderClient::kOnVideoFrameDecoded:
            return "Receive reply media::mojom::VideoDecoderClient::OnVideoFrameDecoded";
      case messages::VideoDecoderClient::kOnWaiting:
            return "Receive reply media::mojom::VideoDecoderClient::OnWaiting";
      case messages::VideoDecoderClient::kRequestOverlayInfo:
            return "Receive reply media::mojom::VideoDecoderClient::RequestOverlayInfo";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t VideoDecoderClient::OnVideoFrameDecoded_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd5b760cc;  // IPCStableHash for media::mojom::VideoDecoderClient::OnVideoFrameDecoded
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoDecoderClient::OnWaiting_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x10c2eb22;  // IPCStableHash for media::mojom::VideoDecoderClient::OnWaiting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoDecoderClient::RequestOverlayInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xffebdab4;  // IPCStableHash for media::mojom::VideoDecoderClient::RequestOverlayInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

VideoDecoderClientProxy::VideoDecoderClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VideoDecoderClientProxy::OnVideoFrameDecoded(
    ::media::mojom::blink::VideoFramePtr in_frame, bool in_can_read_without_stalling, const std::optional<::base::UnguessableToken>& in_release_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoDecoderClient::OnVideoFrameDecoded", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame"), in_frame,
                        "<value of type ::media::mojom::blink::VideoFramePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("can_read_without_stalling"), in_can_read_without_stalling,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("release_token"), in_release_token,
                        "<value of type const std::optional<::base::UnguessableToken>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoDecoderClient::kOnVideoFrameDecoded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoDecoderClient_OnVideoFrameDecoded_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame)::BaseType> frame_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::VideoFrameDataView>(
    in_frame,
    frame_fragment);

  params->frame.Set(
      frame_fragment.is_null() ? nullptr : frame_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame in VideoDecoderClient.OnVideoFrameDecoded request");

  params->can_read_without_stalling = in_can_read_without_stalling;
  mojo::internal::MessageFragment<
      typename decltype(params->release_token)::BaseType> release_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_release_token,
    release_token_fragment);

  params->release_token.Set(
      release_token_fragment.is_null() ? nullptr : release_token_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoDecoderClient::Name_);
  message.set_method_name("OnVideoFrameDecoded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoDecoderClientProxy::OnWaiting(
    ::media::mojom::blink::WaitingReason in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoDecoderClient::OnWaiting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type ::media::mojom::blink::WaitingReason>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoDecoderClient::kOnWaiting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoDecoderClient_OnWaiting_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::WaitingReason>(
    in_reason,
    &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoDecoderClient::Name_);
  message.set_method_name("OnWaiting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoDecoderClientProxy::RequestOverlayInfo(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::VideoDecoderClient::RequestOverlayInfo");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoDecoderClient::kRequestOverlayInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoDecoderClient_RequestOverlayInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoDecoderClient::Name_);
  message.set_method_name("RequestOverlayInfo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool VideoDecoderClientStubDispatch::Accept(
    VideoDecoderClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::VideoDecoderClient>(message->header()->name)) {
    case messages::VideoDecoderClient::kOnVideoFrameDecoded: {
      DCHECK(message->is_serialized());
      internal::VideoDecoderClient_OnVideoFrameDecoded_Params_Data* params =
          reinterpret_cast<internal::VideoDecoderClient_OnVideoFrameDecoded_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoDecoderClient.0
      bool success = true;
      ::media::mojom::blink::VideoFramePtr p_frame{};
      bool p_can_read_without_stalling{};
      std::optional<::base::UnguessableToken> p_release_token{};
      VideoDecoderClient_OnVideoFrameDecoded_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrame(&p_frame))
        success = false;
      if (success)
        p_can_read_without_stalling = input_data_view.can_read_without_stalling();
      if (success && !input_data_view.ReadReleaseToken(&p_release_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoDecoderClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnVideoFrameDecoded(        
        std::move(p_frame), 
        std::move(p_can_read_without_stalling), 
        std::move(p_release_token));
      return true;
    }
    case messages::VideoDecoderClient::kOnWaiting: {
      DCHECK(message->is_serialized());
      internal::VideoDecoderClient_OnWaiting_Params_Data* params =
          reinterpret_cast<internal::VideoDecoderClient_OnWaiting_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoDecoderClient.1
      bool success = true;
      ::media::mojom::blink::WaitingReason p_reason{};
      VideoDecoderClient_OnWaiting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoDecoderClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnWaiting(        
        std::move(p_reason));
      return true;
    }
    case messages::VideoDecoderClient::kRequestOverlayInfo: {
      DCHECK(message->is_serialized());
      internal::VideoDecoderClient_RequestOverlayInfo_Params_Data* params =
          reinterpret_cast<internal::VideoDecoderClient_RequestOverlayInfo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoDecoderClient.2
      bool success = true;
      VideoDecoderClient_RequestOverlayInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoDecoderClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestOverlayInfo(        );
      return true;
    }
  }
  return false;
}

// static
bool VideoDecoderClientStubDispatch::AcceptWithResponder(
    VideoDecoderClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::VideoDecoderClient>(message->header()->name)) {
    case messages::VideoDecoderClient::kOnVideoFrameDecoded: {
      break;
    }
    case messages::VideoDecoderClient::kOnWaiting: {
      break;
    }
    case messages::VideoDecoderClient::kRequestOverlayInfo: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kVideoDecoderClientValidationInfo[] = {
    { &internal::VideoDecoderClient_OnVideoFrameDecoded_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VideoDecoderClient_OnWaiting_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VideoDecoderClient_RequestOverlayInfo_Params_Data::Validate,
     nullptr /* no response */},
};

bool VideoDecoderClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::blink::VideoDecoderClient::Name_,
    kVideoDecoderClientValidationInfo);
}



}  // media::mojom::blink


namespace mojo {


// static
bool StructTraits<::media::mojom::blink::SupportedVideoDecoderConfig::DataView, ::media::mojom::blink::SupportedVideoDecoderConfigPtr>::Read(
    ::media::mojom::blink::SupportedVideoDecoderConfig::DataView input,
    ::media::mojom::blink::SupportedVideoDecoderConfigPtr* output) {
  bool success = true;
  ::media::mojom::blink::SupportedVideoDecoderConfigPtr result(::media::mojom::blink::SupportedVideoDecoderConfig::New());
  
      if (success && !input.ReadProfileMin(&result->profile_min))
        success = false;
      if (success && !input.ReadProfileMax(&result->profile_max))
        success = false;
      if (success && !input.ReadCodedSizeMin(&result->coded_size_min))
        success = false;
      if (success && !input.ReadCodedSizeMax(&result->coded_size_max))
        success = false;
      if (success)
        result->allow_encrypted = input.allow_encrypted();
      if (success)
        result->require_encrypted = input.require_encrypted();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::CommandBufferId::DataView, ::media::mojom::blink::CommandBufferIdPtr>::Read(
    ::media::mojom::blink::CommandBufferId::DataView input,
    ::media::mojom::blink::CommandBufferIdPtr* output) {
  bool success = true;
  ::media::mojom::blink::CommandBufferIdPtr result(::media::mojom::blink::CommandBufferId::New());
  
      if (success && !input.ReadChannelToken(&result->channel_token))
        success = false;
      if (success)
        result->route_id = input.route_id();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::media::mojom::blink::Cdm::DataView, ::media::mojom::blink::CdmPtr>::Read(
    ::media::mojom::blink::Cdm::DataView input,
    ::media::mojom::blink::CdmPtr* output) {
  using UnionType = ::media::mojom::blink::Cdm;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kCdmId: {
      ::base::UnguessableToken result_cdm_id{};
      if (!input.ReadCdmId(&result_cdm_id))
        return false;

      *output = UnionType::NewCdmId(
          std::move(result_cdm_id));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom::blink {


void VideoFrameHandleReleaserInterceptorForTesting::ReleaseVideoFrame(const ::base::UnguessableToken& release_token, const std::optional<::gpu::SyncToken>& release_sync_token) {
  GetForwardingInterface()->ReleaseVideoFrame(
    std::move(release_token)
    , 
    std::move(release_sync_token)
    );
}
VideoFrameHandleReleaserAsyncWaiter::VideoFrameHandleReleaserAsyncWaiter(
    VideoFrameHandleReleaser* proxy) : proxy_(proxy) {}

VideoFrameHandleReleaserAsyncWaiter::~VideoFrameHandleReleaserAsyncWaiter() = default;





void VideoDecoderInterceptorForTesting::GetSupportedConfigs(GetSupportedConfigsCallback callback) {
  GetForwardingInterface()->GetSupportedConfigs(std::move(callback));
}
void VideoDecoderInterceptorForTesting::Construct(::mojo::PendingAssociatedRemote<VideoDecoderClient> client, ::mojo::PendingRemote<::media::mojom::blink::MediaLog> media_log, ::mojo::PendingReceiver<VideoFrameHandleReleaser> video_frame_handle_releaser, ::mojo::ScopedDataPipeConsumerHandle decoder_buffer_pipe, CommandBufferIdPtr command_buffer_id, const ::gfx::ColorSpace& target_color_space) {
  GetForwardingInterface()->Construct(
    std::move(client)
    , 
    std::move(media_log)
    , 
    std::move(video_frame_handle_releaser)
    , 
    std::move(decoder_buffer_pipe)
    , 
    std::move(command_buffer_id)
    , 
    std::move(target_color_space)
    );
}
void VideoDecoderInterceptorForTesting::Initialize(::media::mojom::blink::VideoDecoderConfigPtr config, bool low_delay, CdmPtr cdm, InitializeCallback callback) {
  GetForwardingInterface()->Initialize(
    std::move(config)
    , 
    std::move(low_delay)
    , 
    std::move(cdm)
    , std::move(callback));
}
void VideoDecoderInterceptorForTesting::Decode(::media::mojom::blink::DecoderBufferPtr buffer, DecodeCallback callback) {
  GetForwardingInterface()->Decode(
    std::move(buffer)
    , std::move(callback));
}
void VideoDecoderInterceptorForTesting::Reset(ResetCallback callback) {
  GetForwardingInterface()->Reset(std::move(callback));
}
void VideoDecoderInterceptorForTesting::OnOverlayInfoChanged(OverlayInfoPtr overlay_info) {
  GetForwardingInterface()->OnOverlayInfoChanged(
    std::move(overlay_info)
    );
}
VideoDecoderAsyncWaiter::VideoDecoderAsyncWaiter(
    VideoDecoder* proxy) : proxy_(proxy) {}

VideoDecoderAsyncWaiter::~VideoDecoderAsyncWaiter() = default;


void VideoDecoderAsyncWaiter::GetSupportedConfigs(
    ::blink::Vector<SupportedVideoDecoderConfigPtr>* out_supported_configs, ::media::VideoDecoderType* out_decoder_type) {
  base::RunLoop loop;
  proxy_->GetSupportedConfigs(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::Vector<SupportedVideoDecoderConfigPtr>* out_supported_configs
,
             ::media::VideoDecoderType* out_decoder_type
,
             ::blink::Vector<SupportedVideoDecoderConfigPtr> supported_configs,
             ::media::VideoDecoderType decoder_type) {*out_supported_configs = std::move(supported_configs);*out_decoder_type = std::move(decoder_type);
            loop->Quit();
          },
          &loop,
          out_supported_configs,
          out_decoder_type));
  loop.Run();
}



void VideoDecoderAsyncWaiter::Initialize(
    ::media::mojom::blink::VideoDecoderConfigPtr config, bool low_delay, CdmPtr cdm, ::media::mojom::blink::DecoderStatusPtr* out_status, bool* out_needs_bitstream_conversion, int32_t* out_max_decode_requests, ::media::VideoDecoderType* out_decoder_type, bool* out_needs_transcryption) {
  base::RunLoop loop;
  proxy_->Initialize(
      std::move(config),
      std::move(low_delay),
      std::move(cdm),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::media::mojom::blink::DecoderStatusPtr* out_status
,
             bool* out_needs_bitstream_conversion
,
             int32_t* out_max_decode_requests
,
             ::media::VideoDecoderType* out_decoder_type
,
             bool* out_needs_transcryption
,
             ::media::mojom::blink::DecoderStatusPtr status,
             bool needs_bitstream_conversion,
             int32_t max_decode_requests,
             ::media::VideoDecoderType decoder_type,
             bool needs_transcryption) {*out_status = std::move(status);*out_needs_bitstream_conversion = std::move(needs_bitstream_conversion);*out_max_decode_requests = std::move(max_decode_requests);*out_decoder_type = std::move(decoder_type);*out_needs_transcryption = std::move(needs_transcryption);
            loop->Quit();
          },
          &loop,
          out_status,
          out_needs_bitstream_conversion,
          out_max_decode_requests,
          out_decoder_type,
          out_needs_transcryption));
  loop.Run();
}



void VideoDecoderAsyncWaiter::Decode(
    ::media::mojom::blink::DecoderBufferPtr buffer, ::media::mojom::blink::DecoderStatusPtr* out_status) {
  base::RunLoop loop;
  proxy_->Decode(
      std::move(buffer),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::media::mojom::blink::DecoderStatusPtr* out_status
,
             ::media::mojom::blink::DecoderStatusPtr status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::media::mojom::blink::DecoderStatusPtr VideoDecoderAsyncWaiter::Decode(
    ::media::mojom::blink::DecoderBufferPtr buffer) {
  ::media::mojom::blink::DecoderStatusPtr async_wait_result;
  Decode(std::move(buffer),&async_wait_result);
  return async_wait_result;
}

void VideoDecoderAsyncWaiter::Reset(
    ) {
  base::RunLoop loop;
  proxy_->Reset(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void VideoDecoderClientInterceptorForTesting::OnVideoFrameDecoded(::media::mojom::blink::VideoFramePtr frame, bool can_read_without_stalling, const std::optional<::base::UnguessableToken>& release_token) {
  GetForwardingInterface()->OnVideoFrameDecoded(
    std::move(frame)
    , 
    std::move(can_read_without_stalling)
    , 
    std::move(release_token)
    );
}
void VideoDecoderClientInterceptorForTesting::OnWaiting(::media::mojom::blink::WaitingReason reason) {
  GetForwardingInterface()->OnWaiting(
    std::move(reason)
    );
}
void VideoDecoderClientInterceptorForTesting::RequestOverlayInfo() {
  GetForwardingInterface()->RequestOverlayInfo();
}
VideoDecoderClientAsyncWaiter::VideoDecoderClientAsyncWaiter(
    VideoDecoderClient* proxy) : proxy_(proxy) {}

VideoDecoderClientAsyncWaiter::~VideoDecoderClientAsyncWaiter() = default;







}  // media::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif