// media/mojo/mojom/speech_recognizer.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_SPEECH_RECOGNIZER_MOJOM_SEND_VALIDATION_H_
#define MEDIA_MOJO_MOJOM_SPEECH_RECOGNIZER_MOJOM_SEND_VALIDATION_H_

#include "media/mojo/mojom/speech_recognizer.mojom-shared-internal.h"
#include "media/mojo/mojom/speech_recognition_audio_forwarder.mojom-shared.h"
#include "media/mojo/mojom/speech_recognition_error.mojom-shared.h"
#include "media/mojo/mojom/speech_recognition_grammar.mojom-shared.h"
#include "media/mojo/mojom/speech_recognition_result.mojom-shared.h"
#include "media/mojo/mojom/speech_recognition_recognition_context.mojom-shared.h"

#include "media/mojo/mojom/speech_recognizer.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::AvailabilityStatus, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::StartSpeechRecognitionRequestParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::StartSpeechRecognitionRequestParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::StartSpeechRecognitionRequestParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::session_receiver(input)) in_session_receiver = Traits::session_receiver(input);

      
      mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::SpeechRecognitionSessionInterfaceBase>>(
        in_session_receiver,
        &fragment->session_receiver,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->session_receiver)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid session_receiver in StartSpeechRecognitionRequestParams struct");

      decltype(Traits::client(input)) in_client = Traits::client(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::SpeechRecognitionSessionClientInterfaceBase>>(
        in_client,
        &fragment->client,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->client)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid client in StartSpeechRecognitionRequestParams struct");

      decltype(Traits::language(input)) in_language = Traits::language(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->language)::BaseType> language_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_language,
        language_fragment);

      fragment->language.Set(
          language_fragment.is_null() ? nullptr : language_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->language.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null language in StartSpeechRecognitionRequestParams struct");

      decltype(Traits::grammars(input)) in_grammars = Traits::grammars(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->grammars)::BaseType>
          grammars_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& grammars_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::SpeechRecognitionGrammarDataView>, send_validation>(
        in_grammars,
        grammars_fragment,
        &grammars_validate_params);

      fragment->grammars.Set(
          grammars_fragment.is_null() ? nullptr : grammars_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->grammars.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null grammars in StartSpeechRecognitionRequestParams struct");

      decltype(Traits::recognition_context(input)) in_recognition_context = Traits::recognition_context(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->recognition_context)::BaseType> recognition_context_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::SpeechRecognitionRecognitionContextDataView, send_validation>(
        in_recognition_context,
        recognition_context_fragment);

      fragment->recognition_context.Set(
          recognition_context_fragment.is_null() ? nullptr : recognition_context_fragment.data());

      fragment->max_hypotheses = Traits::max_hypotheses(input);

      fragment->continuous = Traits::continuous(input);

      fragment->interim_results = Traits::interim_results(input);

      fragment->on_device = Traits::on_device(input);

      fragment->allow_cloud_fallback = Traits::allow_cloud_fallback(input);

      decltype(Traits::audio_forwarder(input)) in_audio_forwarder = Traits::audio_forwarder(input);

      
      mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::SpeechRecognitionAudioForwarderInterfaceBase>>(
        in_audio_forwarder,
        &fragment->audio_forwarder,
        &fragment.message());

      fragment->channel_count = Traits::channel_count(input);

      fragment->sample_rate = Traits::sample_rate(input);
  }
};

}  // namespace mojo::internal

#endif  // MEDIA_MOJO_MOJOM_SPEECH_RECOGNIZER_MOJOM_SEND_VALIDATION_H_