// media/mojo/mojom/speech_recognition_audio_forwarder.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/speech_recognition_audio_forwarder.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/speech_recognition_audio_forwarder.mojom-params-data.h"
#include "media/mojo/mojom/speech_recognition_audio_forwarder.mojom-shared-message-ids.h"

#include "media/mojo/mojom/speech_recognition_audio_forwarder.mojom-import-headers.h"
#include "media/mojo/mojom/speech_recognition_audio_forwarder.mojom-test-utils.h"


namespace media::mojom {
// The declaration includes the definition on other builds.

SpeechRecognitionAudioForwarder::IPCStableHashFunction SpeechRecognitionAudioForwarder::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SpeechRecognitionAudioForwarder>(message.name())) {
    case messages::SpeechRecognitionAudioForwarder::kAddAudioFromRenderer: {
      return &SpeechRecognitionAudioForwarder::AddAudioFromRenderer_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SpeechRecognitionAudioForwarder::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SpeechRecognitionAudioForwarder>(message.name())) {
      case messages::SpeechRecognitionAudioForwarder::kAddAudioFromRenderer:
            return "Receive media::mojom::SpeechRecognitionAudioForwarder::AddAudioFromRenderer";
    }
  } else {
    switch (static_cast<messages::SpeechRecognitionAudioForwarder>(message.name())) {
      case messages::SpeechRecognitionAudioForwarder::kAddAudioFromRenderer:
            return "Receive reply media::mojom::SpeechRecognitionAudioForwarder::AddAudioFromRenderer";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SpeechRecognitionAudioForwarder::AddAudioFromRenderer_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9991c4c2;  // IPCStableHash for media::mojom::SpeechRecognitionAudioForwarder::AddAudioFromRenderer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SpeechRecognitionAudioForwarderProxy::SpeechRecognitionAudioForwarderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeechRecognitionAudioForwarderProxy::AddAudioFromRenderer(
    ::media::mojom::AudioDataS16Ptr in_buffer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::SpeechRecognitionAudioForwarder::AddAudioFromRenderer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type ::media::mojom::AudioDataS16Ptr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionAudioForwarder::kAddAudioFromRenderer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionAudioForwarder_AddAudioFromRenderer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->buffer)::BaseType> buffer_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::AudioDataS16DataView>(
    in_buffer,
    buffer_fragment);

  params->buffer.Set(
      buffer_fragment.is_null() ? nullptr : buffer_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->buffer.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null buffer in SpeechRecognitionAudioForwarder.AddAudioFromRenderer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionAudioForwarder::Name_);
  message.set_method_name("AddAudioFromRenderer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SpeechRecognitionAudioForwarderStubDispatch::Accept(
    SpeechRecognitionAudioForwarder* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SpeechRecognitionAudioForwarder>(message->header()->name)) {
    case messages::SpeechRecognitionAudioForwarder::kAddAudioFromRenderer: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionAudioForwarder_AddAudioFromRenderer_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionAudioForwarder_AddAudioFromRenderer_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechRecognitionAudioForwarder.1
      bool success = true;
      ::media::mojom::AudioDataS16Ptr p_buffer{};
      SpeechRecognitionAudioForwarder_AddAudioFromRenderer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionAudioForwarder::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddAudioFromRenderer(        
        std::move(p_buffer));
      return true;
    }
  }
  return false;
}

// static
bool SpeechRecognitionAudioForwarderStubDispatch::AcceptWithResponder(
    SpeechRecognitionAudioForwarder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SpeechRecognitionAudioForwarder>(message->header()->name)) {
    case messages::SpeechRecognitionAudioForwarder::kAddAudioFromRenderer: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSpeechRecognitionAudioForwarderValidationInfo[] = {
    {nullptr, nullptr},  // nonexistent
    { &internal::SpeechRecognitionAudioForwarder_AddAudioFromRenderer_Params_Data::Validate,
     nullptr /* no response */},
};

bool SpeechRecognitionAudioForwarderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::SpeechRecognitionAudioForwarder::Name_,
    kSpeechRecognitionAudioForwarderValidationInfo);
}



}  // media::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom {


void SpeechRecognitionAudioForwarderInterceptorForTesting::AddAudioFromRenderer(::media::mojom::AudioDataS16Ptr buffer) {
  GetForwardingInterface()->AddAudioFromRenderer(
    std::move(buffer)
    );
}
SpeechRecognitionAudioForwarderAsyncWaiter::SpeechRecognitionAudioForwarderAsyncWaiter(
    SpeechRecognitionAudioForwarder* proxy) : proxy_(proxy) {}

SpeechRecognitionAudioForwarderAsyncWaiter::~SpeechRecognitionAudioForwarderAsyncWaiter() = default;







}  // media::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif