// media/mojo/mojom/speech_recognition.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  Rect as gfx_mojom_Rect,
  RectSpec as gfx_mojom_RectSpec
} from '../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  AudioDataS16 as media_mojom_AudioDataS16,
  AudioDataS16Spec as media_mojom_AudioDataS16Spec
} from './audio_data.mojom.m.js';

import {
  SpeechRecognitionAudioForwarderRemote as media_mojom_SpeechRecognitionAudioForwarderRemote,
  SpeechRecognitionAudioForwarderPendingReceiver as media_mojom_SpeechRecognitionAudioForwarderPendingReceiver
} from './speech_recognition_audio_forwarder.mojom.m.js';

import {
  SpeechRecognitionRecognitionContext as media_mojom_SpeechRecognitionRecognitionContext,
  SpeechRecognitionRecognitionContextSpec as media_mojom_SpeechRecognitionRecognitionContextSpec
} from './speech_recognition_recognition_context.mojom.m.js';

import {
  SpeechRecognitionSessionRemote as media_mojom_SpeechRecognitionSessionRemote,
  SpeechRecognitionSessionPendingReceiver as media_mojom_SpeechRecognitionSessionPendingReceiver,
  SpeechRecognitionSessionClientRemote as media_mojom_SpeechRecognitionSessionClientRemote,
  SpeechRecognitionSessionClientPendingReceiver as media_mojom_SpeechRecognitionSessionClientPendingReceiver
} from './speech_recognizer.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ConfidenceLevelSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ConfidenceLevel = {
  
  kUnknown: 0,
  kNotConfident: 1,
  kConfident: 2,
  kHighlyConfident: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AsrSwitchResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AsrSwitchResult = {
  
  kDefaultNoSwitch: 0,
  kSwitchSucceeded: 1,
  kSwitchFailed: 2,
  kSwitchSkipedNoLp: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SpeechRecognitionModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SpeechRecognitionMode = {
  
  kUnknown: 0,
  kIme: 1,
  kCaption: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const RecognizerClientTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const RecognizerClientType = {
  
  kUnknown: 0,
  kDictation: 1,
  kLiveCaption: 2,
  kProjector: 3,
  kCastModerator: 4,
  kSchoolTools: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SpeechRecognitionContextPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.SpeechRecognitionContext', scope);
  }
}

/** @interface */
export class SpeechRecognitionContextInterface {
  
  /**
   * @param { !SpeechRecognitionRecognizerPendingReceiver } receiver
   * @param { !SpeechRecognitionRecognizerClientRemote } client
   * @param { !SpeechRecognitionOptions } options
   * @return {!Promise<{
        isMultichannelSupported: !boolean,
   *  }>}
   */

  bindRecognizer(receiver, client, options) {}
  
  /**
   * @param { !media_mojom_SpeechRecognitionSessionPendingReceiver } sessionReceiver
   * @param { !media_mojom_SpeechRecognitionSessionClientRemote } sessionClient
   * @param { !media_mojom_SpeechRecognitionAudioForwarderPendingReceiver } audioForwarder
   * @param { !number } channelCount
   * @param { !number } sampleRate
   * @param { !SpeechRecognitionOptions } options
   * @param { !boolean } continuous
   */

  bindWebSpeechRecognizer(sessionReceiver, sessionClient, audioForwarder, channelCount, sampleRate, options, continuous) {}
}

/**
 * @implements { SpeechRecognitionContextInterface }
 */
export class SpeechRecognitionContextRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SpeechRecognitionContextPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SpeechRecognitionContextPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SpeechRecognitionContextPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !SpeechRecognitionRecognizerPendingReceiver } receiver
   * @param { !SpeechRecognitionRecognizerClientRemote } client
   * @param { !SpeechRecognitionOptions } options
   * @return {!Promise<{
        isMultichannelSupported: !boolean,
   *  }>}
   */

  bindRecognizer(
      receiver,
      client,
      options) {
    return this.proxy.sendMessage(
        0,
        SpeechRecognitionContext_BindRecognizer_ParamsSpec.$,
        SpeechRecognitionContext_BindRecognizer_ResponseParamsSpec.$,
        [
          receiver,
          client,
          options
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_SpeechRecognitionSessionPendingReceiver } sessionReceiver
   * @param { !media_mojom_SpeechRecognitionSessionClientRemote } sessionClient
   * @param { !media_mojom_SpeechRecognitionAudioForwarderPendingReceiver } audioForwarder
   * @param { !number } channelCount
   * @param { !number } sampleRate
   * @param { !SpeechRecognitionOptions } options
   * @param { !boolean } continuous
   */

  bindWebSpeechRecognizer(
      sessionReceiver,
      sessionClient,
      audioForwarder,
      channelCount,
      sampleRate,
      options,
      continuous) {
    this.proxy.sendMessage(
        1,
        SpeechRecognitionContext_BindWebSpeechRecognizer_ParamsSpec.$,
        null,
        [
          sessionReceiver,
          sessionClient,
          audioForwarder,
          channelCount,
          sampleRate,
          options,
          continuous
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SpeechRecognitionContext
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SpeechRecognitionContextReceiver {
  /**
   * @param {!SpeechRecognitionContextInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SpeechRecognitionContextRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SpeechRecognitionContextRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SpeechRecognitionContextRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SpeechRecognitionContext_BindRecognizer_ParamsSpec.$,
        SpeechRecognitionContext_BindRecognizer_ResponseParamsSpec.$,
        impl.bindRecognizer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SpeechRecognitionContext_BindWebSpeechRecognizer_ParamsSpec.$,
        null,
        impl.bindWebSpeechRecognizer.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SpeechRecognitionContext {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.SpeechRecognitionContext";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SpeechRecognitionContextRemote}
   */
  static getRemote() {
    let remote = new SpeechRecognitionContextRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SpeechRecognitionContext
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SpeechRecognitionContextCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SpeechRecognitionContextRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SpeechRecognitionContextRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindRecognizer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SpeechRecognitionContext_BindRecognizer_ParamsSpec.$,
        SpeechRecognitionContext_BindRecognizer_ResponseParamsSpec.$,
        this.bindRecognizer.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindWebSpeechRecognizer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SpeechRecognitionContext_BindWebSpeechRecognizer_ParamsSpec.$,
        null,
        this.bindWebSpeechRecognizer.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SpeechRecognitionRecognizerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.SpeechRecognitionRecognizer', scope);
  }
}

/** @interface */
export class SpeechRecognitionRecognizerInterface {
  
  /**
   * @param { !media_mojom_AudioDataS16 } buffer
   * @param { ?mojoBase_mojom_TimeDelta } mediaStartPts
   */

  sendAudioToSpeechRecognitionService(buffer, mediaStartPts) {}
  
  /**
   */

  markDone() {}
  
  /**
   * @param { !string } language
   */

  onLanguageChanged(language) {}
  
  /**
   * @param { !boolean } maskOffensiveWords
   */

  onMaskOffensiveWordsChanged(maskOffensiveWords) {}
  
  /**
   * @param { !media_mojom_SpeechRecognitionRecognitionContext } recognitionContext
   */

  updateRecognitionContext(recognitionContext) {}
}

/**
 * @implements { SpeechRecognitionRecognizerInterface }
 */
export class SpeechRecognitionRecognizerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SpeechRecognitionRecognizerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SpeechRecognitionRecognizerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SpeechRecognitionRecognizerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media_mojom_AudioDataS16 } buffer
   * @param { ?mojoBase_mojom_TimeDelta } mediaStartPts
   */

  sendAudioToSpeechRecognitionService(
      buffer,
      mediaStartPts) {
    this.proxy.sendMessage(
        0,
        SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_ParamsSpec.$,
        null,
        [
          buffer,
          mediaStartPts
        ],
        false);
  }

  
  /**
   */

  markDone() {
    this.proxy.sendMessage(
        1,
        SpeechRecognitionRecognizer_MarkDone_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } language
   */

  onLanguageChanged(
      language) {
    this.proxy.sendMessage(
        2,
        SpeechRecognitionRecognizer_OnLanguageChanged_ParamsSpec.$,
        null,
        [
          language
        ],
        false);
  }

  
  /**
   * @param { !boolean } maskOffensiveWords
   */

  onMaskOffensiveWordsChanged(
      maskOffensiveWords) {
    this.proxy.sendMessage(
        3,
        SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_ParamsSpec.$,
        null,
        [
          maskOffensiveWords
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_SpeechRecognitionRecognitionContext } recognitionContext
   */

  updateRecognitionContext(
      recognitionContext) {
    this.proxy.sendMessage(
        4,
        SpeechRecognitionRecognizer_UpdateRecognitionContext_ParamsSpec.$,
        null,
        [
          recognitionContext
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SpeechRecognitionRecognizer
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SpeechRecognitionRecognizerReceiver {
  /**
   * @param {!SpeechRecognitionRecognizerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SpeechRecognitionRecognizerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SpeechRecognitionRecognizerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SpeechRecognitionRecognizerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_ParamsSpec.$,
        null,
        impl.sendAudioToSpeechRecognitionService.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SpeechRecognitionRecognizer_MarkDone_ParamsSpec.$,
        null,
        impl.markDone.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        SpeechRecognitionRecognizer_OnLanguageChanged_ParamsSpec.$,
        null,
        impl.onLanguageChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_ParamsSpec.$,
        null,
        impl.onMaskOffensiveWordsChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        SpeechRecognitionRecognizer_UpdateRecognitionContext_ParamsSpec.$,
        null,
        impl.updateRecognitionContext.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SpeechRecognitionRecognizer {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.SpeechRecognitionRecognizer";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SpeechRecognitionRecognizerRemote}
   */
  static getRemote() {
    let remote = new SpeechRecognitionRecognizerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SpeechRecognitionRecognizer
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SpeechRecognitionRecognizerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SpeechRecognitionRecognizerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SpeechRecognitionRecognizerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendAudioToSpeechRecognitionService =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_ParamsSpec.$,
        null,
        this.sendAudioToSpeechRecognitionService.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.markDone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SpeechRecognitionRecognizer_MarkDone_ParamsSpec.$,
        null,
        this.markDone.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onLanguageChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        SpeechRecognitionRecognizer_OnLanguageChanged_ParamsSpec.$,
        null,
        this.onLanguageChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onMaskOffensiveWordsChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_ParamsSpec.$,
        null,
        this.onMaskOffensiveWordsChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateRecognitionContext =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        SpeechRecognitionRecognizer_UpdateRecognitionContext_ParamsSpec.$,
        null,
        this.updateRecognitionContext.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SpeechRecognitionRecognizerClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.SpeechRecognitionRecognizerClient', scope);
  }
}

/** @interface */
export class SpeechRecognitionRecognizerClientInterface {
  
  /**
   * @param { !SpeechRecognitionResult } result
   * @return {!Promise<{
        continueRecognition: !boolean,
   *  }>}
   */

  onSpeechRecognitionRecognitionEvent(result) {}
  
  /**
   */

  onSpeechRecognitionStopped() {}
  
  /**
   */

  onSpeechRecognitionError() {}
  
  /**
   * @param { !LanguageIdentificationEvent } event
   */

  onLanguageIdentificationEvent(event) {}
}

/**
 * @implements { SpeechRecognitionRecognizerClientInterface }
 */
export class SpeechRecognitionRecognizerClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SpeechRecognitionRecognizerClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SpeechRecognitionRecognizerClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SpeechRecognitionRecognizerClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !SpeechRecognitionResult } result
   * @return {!Promise<{
        continueRecognition: !boolean,
   *  }>}
   */

  onSpeechRecognitionRecognitionEvent(
      result) {
    return this.proxy.sendMessage(
        0,
        SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ParamsSpec.$,
        SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParamsSpec.$,
        [
          result
        ],
        false);
  }

  
  /**
   */

  onSpeechRecognitionStopped() {
    this.proxy.sendMessage(
        1,
        SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  onSpeechRecognitionError() {
    this.proxy.sendMessage(
        2,
        SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !LanguageIdentificationEvent } event
   */

  onLanguageIdentificationEvent(
      event) {
    this.proxy.sendMessage(
        3,
        SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_ParamsSpec.$,
        null,
        [
          event
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SpeechRecognitionRecognizerClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SpeechRecognitionRecognizerClientReceiver {
  /**
   * @param {!SpeechRecognitionRecognizerClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SpeechRecognitionRecognizerClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SpeechRecognitionRecognizerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SpeechRecognitionRecognizerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ParamsSpec.$,
        SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParamsSpec.$,
        impl.onSpeechRecognitionRecognitionEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_ParamsSpec.$,
        null,
        impl.onSpeechRecognitionStopped.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_ParamsSpec.$,
        null,
        impl.onSpeechRecognitionError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_ParamsSpec.$,
        null,
        impl.onLanguageIdentificationEvent.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SpeechRecognitionRecognizerClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.SpeechRecognitionRecognizerClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SpeechRecognitionRecognizerClientRemote}
   */
  static getRemote() {
    let remote = new SpeechRecognitionRecognizerClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SpeechRecognitionRecognizerClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SpeechRecognitionRecognizerClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SpeechRecognitionRecognizerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SpeechRecognitionRecognizerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSpeechRecognitionRecognitionEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ParamsSpec.$,
        SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParamsSpec.$,
        this.onSpeechRecognitionRecognitionEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSpeechRecognitionStopped =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_ParamsSpec.$,
        null,
        this.onSpeechRecognitionStopped.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSpeechRecognitionError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_ParamsSpec.$,
        null,
        this.onSpeechRecognitionError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onLanguageIdentificationEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_ParamsSpec.$,
        null,
        this.onLanguageIdentificationEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SpeechRecognitionBrowserObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.SpeechRecognitionBrowserObserver', scope);
  }
}

/** @interface */
export class SpeechRecognitionBrowserObserverInterface {
  
  /**
   * @param { !boolean } isSpeechRecognitionAvailable
   */

  speechRecognitionAvailabilityChanged(isSpeechRecognitionAvailable) {}
  
  /**
   * @param { !string } language
   */

  speechRecognitionLanguageChanged(language) {}
  
  /**
   * @param { !boolean } maskOffensiveWords
   */

  speechRecognitionMaskOffensiveWordsChanged(maskOffensiveWords) {}
}

/**
 * @implements { SpeechRecognitionBrowserObserverInterface }
 */
export class SpeechRecognitionBrowserObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SpeechRecognitionBrowserObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SpeechRecognitionBrowserObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SpeechRecognitionBrowserObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } isSpeechRecognitionAvailable
   */

  speechRecognitionAvailabilityChanged(
      isSpeechRecognitionAvailable) {
    this.proxy.sendMessage(
        0,
        SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_ParamsSpec.$,
        null,
        [
          isSpeechRecognitionAvailable
        ],
        false);
  }

  
  /**
   * @param { !string } language
   */

  speechRecognitionLanguageChanged(
      language) {
    this.proxy.sendMessage(
        1,
        SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_ParamsSpec.$,
        null,
        [
          language
        ],
        false);
  }

  
  /**
   * @param { !boolean } maskOffensiveWords
   */

  speechRecognitionMaskOffensiveWordsChanged(
      maskOffensiveWords) {
    this.proxy.sendMessage(
        2,
        SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_ParamsSpec.$,
        null,
        [
          maskOffensiveWords
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SpeechRecognitionBrowserObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SpeechRecognitionBrowserObserverReceiver {
  /**
   * @param {!SpeechRecognitionBrowserObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SpeechRecognitionBrowserObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SpeechRecognitionBrowserObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SpeechRecognitionBrowserObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_ParamsSpec.$,
        null,
        impl.speechRecognitionAvailabilityChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_ParamsSpec.$,
        null,
        impl.speechRecognitionLanguageChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_ParamsSpec.$,
        null,
        impl.speechRecognitionMaskOffensiveWordsChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SpeechRecognitionBrowserObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.SpeechRecognitionBrowserObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SpeechRecognitionBrowserObserverRemote}
   */
  static getRemote() {
    let remote = new SpeechRecognitionBrowserObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SpeechRecognitionBrowserObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SpeechRecognitionBrowserObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SpeechRecognitionBrowserObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SpeechRecognitionBrowserObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.speechRecognitionAvailabilityChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_ParamsSpec.$,
        null,
        this.speechRecognitionAvailabilityChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.speechRecognitionLanguageChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_ParamsSpec.$,
        null,
        this.speechRecognitionLanguageChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.speechRecognitionMaskOffensiveWordsChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_ParamsSpec.$,
        null,
        this.speechRecognitionMaskOffensiveWordsChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SpeechRecognitionSurfacePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.SpeechRecognitionSurface', scope);
  }
}

/** @interface */
export class SpeechRecognitionSurfaceInterface {
  
  /**
   */

  activate() {}
  
  /**
   * @return {!Promise<{
        bounds: ?gfx_mojom_Rect,
   *  }>}
   */

  getBounds() {}
}

/**
 * @implements { SpeechRecognitionSurfaceInterface }
 */
export class SpeechRecognitionSurfaceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SpeechRecognitionSurfacePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SpeechRecognitionSurfacePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SpeechRecognitionSurfacePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  activate() {
    this.proxy.sendMessage(
        0,
        SpeechRecognitionSurface_Activate_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        bounds: ?gfx_mojom_Rect,
   *  }>}
   */

  getBounds() {
    return this.proxy.sendMessage(
        1,
        SpeechRecognitionSurface_GetBounds_ParamsSpec.$,
        SpeechRecognitionSurface_GetBounds_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SpeechRecognitionSurface
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SpeechRecognitionSurfaceReceiver {
  /**
   * @param {!SpeechRecognitionSurfaceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SpeechRecognitionSurfaceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SpeechRecognitionSurfaceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SpeechRecognitionSurfaceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SpeechRecognitionSurface_Activate_ParamsSpec.$,
        null,
        impl.activate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SpeechRecognitionSurface_GetBounds_ParamsSpec.$,
        SpeechRecognitionSurface_GetBounds_ResponseParamsSpec.$,
        impl.getBounds.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SpeechRecognitionSurface {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.SpeechRecognitionSurface";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SpeechRecognitionSurfaceRemote}
   */
  static getRemote() {
    let remote = new SpeechRecognitionSurfaceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SpeechRecognitionSurface
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SpeechRecognitionSurfaceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SpeechRecognitionSurfaceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SpeechRecognitionSurfaceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.activate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SpeechRecognitionSurface_Activate_ParamsSpec.$,
        null,
        this.activate.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getBounds =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SpeechRecognitionSurface_GetBounds_ParamsSpec.$,
        SpeechRecognitionSurface_GetBounds_ResponseParamsSpec.$,
        this.getBounds.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SpeechRecognitionSurfaceClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.SpeechRecognitionSurfaceClient', scope);
  }
}

/** @interface */
export class SpeechRecognitionSurfaceClientInterface {
  
  /**
   */

  onSessionEnded() {}
  
  /**
   */

  onFullscreenToggled() {}
}

/**
 * @implements { SpeechRecognitionSurfaceClientInterface }
 */
export class SpeechRecognitionSurfaceClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SpeechRecognitionSurfaceClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SpeechRecognitionSurfaceClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SpeechRecognitionSurfaceClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onSessionEnded() {
    this.proxy.sendMessage(
        0,
        SpeechRecognitionSurfaceClient_OnSessionEnded_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  onFullscreenToggled() {
    this.proxy.sendMessage(
        1,
        SpeechRecognitionSurfaceClient_OnFullscreenToggled_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SpeechRecognitionSurfaceClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SpeechRecognitionSurfaceClientReceiver {
  /**
   * @param {!SpeechRecognitionSurfaceClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SpeechRecognitionSurfaceClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SpeechRecognitionSurfaceClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SpeechRecognitionSurfaceClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SpeechRecognitionSurfaceClient_OnSessionEnded_ParamsSpec.$,
        null,
        impl.onSessionEnded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SpeechRecognitionSurfaceClient_OnFullscreenToggled_ParamsSpec.$,
        null,
        impl.onFullscreenToggled.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SpeechRecognitionSurfaceClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.SpeechRecognitionSurfaceClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SpeechRecognitionSurfaceClientRemote}
   */
  static getRemote() {
    let remote = new SpeechRecognitionSurfaceClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SpeechRecognitionSurfaceClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SpeechRecognitionSurfaceClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SpeechRecognitionSurfaceClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SpeechRecognitionSurfaceClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSessionEnded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SpeechRecognitionSurfaceClient_OnSessionEnded_ParamsSpec.$,
        null,
        this.onSessionEnded.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onFullscreenToggled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SpeechRecognitionSurfaceClient_OnFullscreenToggled_ParamsSpec.$,
        null,
        this.onFullscreenToggled.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SpeechRecognitionClientBrowserInterfacePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.SpeechRecognitionClientBrowserInterface', scope);
  }
}

/** @interface */
export class SpeechRecognitionClientBrowserInterfaceInterface {
  
  /**
   * @param { !SpeechRecognitionBrowserObserverRemote } observer
   */

  bindSpeechRecognitionBrowserObserver(observer) {}
  
  /**
   */

  rEMOVED1() {}
}

/**
 * @implements { SpeechRecognitionClientBrowserInterfaceInterface }
 */
export class SpeechRecognitionClientBrowserInterfaceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SpeechRecognitionClientBrowserInterfacePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SpeechRecognitionClientBrowserInterfacePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SpeechRecognitionClientBrowserInterfacePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !SpeechRecognitionBrowserObserverRemote } observer
   */

  bindSpeechRecognitionBrowserObserver(
      observer) {
    this.proxy.sendMessage(
        0,
        SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }

  
  /**
   */

  rEMOVED1() {
    this.proxy.sendMessage(
        1,
        SpeechRecognitionClientBrowserInterface_REMOVED_1_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SpeechRecognitionClientBrowserInterface
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SpeechRecognitionClientBrowserInterfaceReceiver {
  /**
   * @param {!SpeechRecognitionClientBrowserInterfaceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SpeechRecognitionClientBrowserInterfaceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SpeechRecognitionClientBrowserInterfaceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SpeechRecognitionClientBrowserInterfaceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_ParamsSpec.$,
        null,
        impl.bindSpeechRecognitionBrowserObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SpeechRecognitionClientBrowserInterface_REMOVED_1_ParamsSpec.$,
        null,
        impl.rEMOVED1.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SpeechRecognitionClientBrowserInterface {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.SpeechRecognitionClientBrowserInterface";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SpeechRecognitionClientBrowserInterfaceRemote}
   */
  static getRemote() {
    let remote = new SpeechRecognitionClientBrowserInterfaceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SpeechRecognitionClientBrowserInterface
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SpeechRecognitionClientBrowserInterfaceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SpeechRecognitionClientBrowserInterfaceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SpeechRecognitionClientBrowserInterfaceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindSpeechRecognitionBrowserObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_ParamsSpec.$,
        null,
        this.bindSpeechRecognitionBrowserObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.rEMOVED1 =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SpeechRecognitionClientBrowserInterface_REMOVED_1_ParamsSpec.$,
        null,
        this.rEMOVED1.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HypothesisPartsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaTimestampRangeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TimingInformationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LanguageIdentificationEventSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionContext_BindRecognizer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionContext_BindRecognizer_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionContext_BindWebSpeechRecognizer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionRecognizer_MarkDone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionRecognizer_OnLanguageChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionRecognizer_UpdateRecognitionContext_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionSurface_Activate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionSurface_GetBounds_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionSurface_GetBounds_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionSurfaceClient_OnSessionEnded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionSurfaceClient_OnFullscreenToggled_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionClientBrowserInterface_REMOVED_1_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    HypothesisPartsSpec.$,
    'HypothesisParts',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hypothesisPartOffset', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class HypothesisParts {
  constructor() {
    /** @type { !Array<!string> } */
    this.text;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.hypothesisPartOffset;
  }
}



mojo.internal.Struct(
    MediaTimestampRangeSpec.$,
    'MediaTimestampRange',
    [
      mojo.internal.StructField(
        'start', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'end', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MediaTimestampRange {
  constructor() {
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.start;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.end;
  }
}



mojo.internal.Struct(
    TimingInformationSpec.$,
    'TimingInformation',
    [
      mojo.internal.StructField(
        'audioStartTime', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'audioEndTime', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hypothesisParts', 16,
        0,
        mojo.internal.Array(HypothesisPartsSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'originatingMediaTimestamps', 24,
        0,
        mojo.internal.Array(MediaTimestampRangeSpec.$, false),
        null,
        true /* nullable */,
        11,
      ),
    ],
    [[0, 32],[11, 40],]);



/**
 * @record
 */
export class TimingInformation {
  constructor() {
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.audioStartTime;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.audioEndTime;
    /** @type { (Array<!HypothesisParts>|undefined) } */
    this.hypothesisParts;
    /** @type { (Array<!MediaTimestampRange>|undefined) } */
    this.originatingMediaTimestamps;
  }
}



mojo.internal.Struct(
    SpeechRecognitionResultSpec.$,
    'SpeechRecognitionResult',
    [
      mojo.internal.StructField(
        'transcription', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isFinal', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timingInformation', 16,
        0,
        TimingInformationSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class SpeechRecognitionResult {
  constructor() {
    /** @type { !string } */
    this.transcription;
    /** @type { !boolean } */
    this.isFinal;
    /** @type { (TimingInformation|undefined) } */
    this.timingInformation;
  }
}



mojo.internal.Struct(
    LanguageIdentificationEventSpec.$,
    'LanguageIdentificationEvent',
    [
      mojo.internal.StructField(
        'language', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'confidenceLevel', 8,
        0,
        ConfidenceLevelSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'asr_switch_result_$flag', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        1,
        {
          isPrimary: true,
          linkedValueFieldName: "asr_switch_result_$value",
          originalFieldName: "asrSwitchResult",
        }
      ),
      mojo.internal.StructField(
        'asr_switch_result_$value', 16,
        0,
        AsrSwitchResultSpec.$,
        0,
        false /* nullable */,
        1,
        {
          isPrimary: false,
          originalFieldName: "asrSwitchResult",
        }
      ),
    ],
    [[0, 24],[1, 32],]);



/**
 * @record
 */
export class LanguageIdentificationEvent {
  constructor() {
    /** @type { !string } */
    this.language;
    /** @type { !ConfidenceLevel } */
    this.confidenceLevel;
    /** @type { (AsrSwitchResult|undefined) } */
    this.asrSwitchResult;
  }
}



mojo.internal.Struct(
    SpeechRecognitionOptionsSpec.$,
    'SpeechRecognitionOptions',
    [
      mojo.internal.StructField(
        'recognitionMode', 0,
        0,
        SpeechRecognitionModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'enableFormatting', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'language', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isServerBased', 4,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        1,
      ),
      mojo.internal.StructField(
        'recognizerClientType', 16,
        0,
        RecognizerClientTypeSpec.$,
        0,
        false /* nullable */,
        1,
      ),
      mojo.internal.StructField(
        'skipContinuouslyEmptyAudio', 4,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        4,
      ),
      mojo.internal.StructField(
        'experimentRecognizerRoutingKey', 24,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        5,
      ),
      mojo.internal.StructField(
        'channelCount', 20,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        6,
      ),
      mojo.internal.StructField(
        'sampleRate', 32,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        6,
      ),
      mojo.internal.StructField(
        'recognitionContext', 40,
        0,
        media_mojom_SpeechRecognitionRecognitionContextSpec.$,
        null,
        true /* nullable */,
        8,
      ),
    ],
    [[0, 24],[1, 32],[4, 32],[5, 40],[6, 48],[8, 56],]);



/**
 * @record
 */
export class SpeechRecognitionOptions {
  constructor() {
    /** @type { !SpeechRecognitionMode } */
    this.recognitionMode;
    /** @type { !boolean } */
    this.enableFormatting;
    /** @type { (string|undefined) } */
    this.language;
    /** @type { !boolean } */
    this.isServerBased;
    /** @type { !RecognizerClientType } */
    this.recognizerClientType;
    /** @type { !boolean } */
    this.skipContinuouslyEmptyAudio;
    /** @type { (string|undefined) } */
    this.experimentRecognizerRoutingKey;
    /** @type { !number } */
    this.channelCount;
    /** @type { !number } */
    this.sampleRate;
    /** @type { (media_mojom_SpeechRecognitionRecognitionContext|undefined) } */
    this.recognitionContext;
  }
}



mojo.internal.Struct(
    SpeechRecognitionContext_BindRecognizer_ParamsSpec.$,
    'SpeechRecognitionContext_BindRecognizer_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(SpeechRecognitionRecognizerPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 4,
        0,
        mojo.internal.InterfaceProxy(SpeechRecognitionRecognizerClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'options', 16,
        0,
        SpeechRecognitionOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class SpeechRecognitionContext_BindRecognizer_Params {
  constructor() {
    /** @type { !SpeechRecognitionRecognizerPendingReceiver } */
    this.receiver;
    /** @type { !SpeechRecognitionRecognizerClientRemote } */
    this.client;
    /** @type { !SpeechRecognitionOptions } */
    this.options;
  }
}



mojo.internal.Struct(
    SpeechRecognitionContext_BindRecognizer_ResponseParamsSpec.$,
    'SpeechRecognitionContext_BindRecognizer_ResponseParams',
    [
      mojo.internal.StructField(
        'isMultichannelSupported', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SpeechRecognitionContext_BindRecognizer_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.isMultichannelSupported;
  }
}



mojo.internal.Struct(
    SpeechRecognitionContext_BindWebSpeechRecognizer_ParamsSpec.$,
    'SpeechRecognitionContext_BindWebSpeechRecognizer_Params',
    [
      mojo.internal.StructField(
        'sessionReceiver', 0,
        0,
        mojo.internal.InterfaceRequest(media_mojom_SpeechRecognitionSessionPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sessionClient', 4,
        0,
        mojo.internal.InterfaceProxy(media_mojom_SpeechRecognitionSessionClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'audioForwarder', 12,
        0,
        mojo.internal.InterfaceRequest(media_mojom_SpeechRecognitionAudioForwarderPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'channelCount', 16,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sampleRate', 20,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'options', 24,
        0,
        SpeechRecognitionOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'continuous', 32,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class SpeechRecognitionContext_BindWebSpeechRecognizer_Params {
  constructor() {
    /** @type { !media_mojom_SpeechRecognitionSessionPendingReceiver } */
    this.sessionReceiver;
    /** @type { !media_mojom_SpeechRecognitionSessionClientRemote } */
    this.sessionClient;
    /** @type { !media_mojom_SpeechRecognitionAudioForwarderPendingReceiver } */
    this.audioForwarder;
    /** @type { !number } */
    this.channelCount;
    /** @type { !number } */
    this.sampleRate;
    /** @type { !SpeechRecognitionOptions } */
    this.options;
    /** @type { !boolean } */
    this.continuous;
  }
}



mojo.internal.Struct(
    SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_ParamsSpec.$,
    'SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        media_mojom_AudioDataS16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mediaStartPts', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        true /* nullable */,
        10,
      ),
    ],
    [[0, 16],[10, 24],]);



/**
 * @record
 */
export class SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params {
  constructor() {
    /** @type { !media_mojom_AudioDataS16 } */
    this.buffer;
    /** @type { (mojoBase_mojom_TimeDelta|undefined) } */
    this.mediaStartPts;
  }
}



mojo.internal.Struct(
    SpeechRecognitionRecognizer_MarkDone_ParamsSpec.$,
    'SpeechRecognitionRecognizer_MarkDone_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SpeechRecognitionRecognizer_MarkDone_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SpeechRecognitionRecognizer_OnLanguageChanged_ParamsSpec.$,
    'SpeechRecognitionRecognizer_OnLanguageChanged_Params',
    [
      mojo.internal.StructField(
        'language', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SpeechRecognitionRecognizer_OnLanguageChanged_Params {
  constructor() {
    /** @type { !string } */
    this.language;
  }
}



mojo.internal.Struct(
    SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_ParamsSpec.$,
    'SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_Params',
    [
      mojo.internal.StructField(
        'maskOffensiveWords', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_Params {
  constructor() {
    /** @type { !boolean } */
    this.maskOffensiveWords;
  }
}



mojo.internal.Struct(
    SpeechRecognitionRecognizer_UpdateRecognitionContext_ParamsSpec.$,
    'SpeechRecognitionRecognizer_UpdateRecognitionContext_Params',
    [
      mojo.internal.StructField(
        'recognitionContext', 0,
        0,
        media_mojom_SpeechRecognitionRecognitionContextSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SpeechRecognitionRecognizer_UpdateRecognitionContext_Params {
  constructor() {
    /** @type { !media_mojom_SpeechRecognitionRecognitionContext } */
    this.recognitionContext;
  }
}



mojo.internal.Struct(
    SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ParamsSpec.$,
    'SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        SpeechRecognitionResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params {
  constructor() {
    /** @type { !SpeechRecognitionResult } */
    this.result;
  }
}



mojo.internal.Struct(
    SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParamsSpec.$,
    'SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'continueRecognition', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.continueRecognition;
  }
}



mojo.internal.Struct(
    SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_ParamsSpec.$,
    'SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_ParamsSpec.$,
    'SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_ParamsSpec.$,
    'SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params',
    [
      mojo.internal.StructField(
        'event', 0,
        0,
        LanguageIdentificationEventSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params {
  constructor() {
    /** @type { !LanguageIdentificationEvent } */
    this.event;
  }
}



mojo.internal.Struct(
    SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_ParamsSpec.$,
    'SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params',
    [
      mojo.internal.StructField(
        'isSpeechRecognitionAvailable', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params {
  constructor() {
    /** @type { !boolean } */
    this.isSpeechRecognitionAvailable;
  }
}



mojo.internal.Struct(
    SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_ParamsSpec.$,
    'SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params',
    [
      mojo.internal.StructField(
        'language', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params {
  constructor() {
    /** @type { !string } */
    this.language;
  }
}



mojo.internal.Struct(
    SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_ParamsSpec.$,
    'SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_Params',
    [
      mojo.internal.StructField(
        'maskOffensiveWords', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_Params {
  constructor() {
    /** @type { !boolean } */
    this.maskOffensiveWords;
  }
}



mojo.internal.Struct(
    SpeechRecognitionSurface_Activate_ParamsSpec.$,
    'SpeechRecognitionSurface_Activate_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SpeechRecognitionSurface_Activate_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SpeechRecognitionSurface_GetBounds_ParamsSpec.$,
    'SpeechRecognitionSurface_GetBounds_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SpeechRecognitionSurface_GetBounds_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SpeechRecognitionSurface_GetBounds_ResponseParamsSpec.$,
    'SpeechRecognitionSurface_GetBounds_ResponseParams',
    [
      mojo.internal.StructField(
        'bounds', 0,
        0,
        gfx_mojom_RectSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SpeechRecognitionSurface_GetBounds_ResponseParams {
  constructor() {
    /** @type { (gfx_mojom_Rect|undefined) } */
    this.bounds;
  }
}



mojo.internal.Struct(
    SpeechRecognitionSurfaceClient_OnSessionEnded_ParamsSpec.$,
    'SpeechRecognitionSurfaceClient_OnSessionEnded_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SpeechRecognitionSurfaceClient_OnSessionEnded_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SpeechRecognitionSurfaceClient_OnFullscreenToggled_ParamsSpec.$,
    'SpeechRecognitionSurfaceClient_OnFullscreenToggled_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SpeechRecognitionSurfaceClient_OnFullscreenToggled_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_ParamsSpec.$,
    'SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(SpeechRecognitionBrowserObserverRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params {
  constructor() {
    /** @type { !SpeechRecognitionBrowserObserverRemote } */
    this.observer;
  }
}



mojo.internal.Struct(
    SpeechRecognitionClientBrowserInterface_REMOVED_1_ParamsSpec.$,
    'SpeechRecognitionClientBrowserInterface_REMOVED_1_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SpeechRecognitionClientBrowserInterface_REMOVED_1_Params {
  constructor() {
  }
}

