// media/mojo/mojom/speech_recognition.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('media.mojom.SpeechRecognitionAudioForwarder');
goog.require('media.mojom.SpeechRecognitionSession');
goog.require('media.mojom.SpeechRecognitionSessionClient');
goog.require('media.mojom.AudioDataS16');
goog.require('gfx.mojom.Rect');
goog.require('media.mojom.SpeechRecognitionRecognitionContext');
goog.require('mojoBase.mojom.TimeDelta');




goog.provide('media.mojom.ConfidenceLevel');
goog.provide('media.mojom.ConfidenceLevelSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.ConfidenceLevelSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.ConfidenceLevel = {
  
  kUnknown: 0,
  kNotConfident: 1,
  kConfident: 2,
  kHighlyConfident: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

goog.provide('media.mojom.AsrSwitchResult');
goog.provide('media.mojom.AsrSwitchResultSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.AsrSwitchResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.AsrSwitchResult = {
  
  kDefaultNoSwitch: 0,
  kSwitchSucceeded: 1,
  kSwitchFailed: 2,
  kSwitchSkipedNoLp: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

goog.provide('media.mojom.SpeechRecognitionMode');
goog.provide('media.mojom.SpeechRecognitionModeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.SpeechRecognitionModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.SpeechRecognitionMode = {
  
  kUnknown: 0,
  kIme: 1,
  kCaption: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

goog.provide('media.mojom.RecognizerClientType');
goog.provide('media.mojom.RecognizerClientTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.RecognizerClientTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.RecognizerClientType = {
  
  kUnknown: 0,
  kDictation: 1,
  kLiveCaption: 2,
  kProjector: 3,
  kCastModerator: 4,
  kSchoolTools: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};



goog.provide('media.mojom.SpeechRecognitionContext');
goog.provide('media.mojom.SpeechRecognitionContextReceiver');
goog.provide('media.mojom.SpeechRecognitionContextCallbackRouter');
goog.provide('media.mojom.SpeechRecognitionContextInterface');
goog.provide('media.mojom.SpeechRecognitionContextRemote');
goog.provide('media.mojom.SpeechRecognitionContextPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.SpeechRecognitionContextPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.SpeechRecognitionContext.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.SpeechRecognitionContextInterface = class {
  
  /**
   * @param { !media.mojom.SpeechRecognitionRecognizerPendingReceiver } receiver
   * @param { !media.mojom.SpeechRecognitionRecognizerClientRemote } client
   * @param { !media.mojom.SpeechRecognitionOptions } options
   * @return {!Promise<{
        isMultichannelSupported: !boolean,
   *  }>}
   */

  bindRecognizer(receiver, client, options) {}
  
  /**
   * @param { !media.mojom.SpeechRecognitionSessionPendingReceiver } sessionReceiver
   * @param { !media.mojom.SpeechRecognitionSessionClientRemote } sessionClient
   * @param { !media.mojom.SpeechRecognitionAudioForwarderPendingReceiver } audioForwarder
   * @param { !number } channelCount
   * @param { !number } sampleRate
   * @param { !media.mojom.SpeechRecognitionOptions } options
   * @param { !boolean } continuous
   */

  bindWebSpeechRecognizer(sessionReceiver, sessionClient, audioForwarder, channelCount, sampleRate, options, continuous) {}
};

/**
 * @export
 * @implements { media.mojom.SpeechRecognitionContextInterface }
 */
media.mojom.SpeechRecognitionContextRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.SpeechRecognitionContextPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.SpeechRecognitionContextPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.SpeechRecognitionContextPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media.mojom.SpeechRecognitionRecognizerPendingReceiver } receiver
   * @param { !media.mojom.SpeechRecognitionRecognizerClientRemote } client
   * @param { !media.mojom.SpeechRecognitionOptions } options
   * @return {!Promise<{
        isMultichannelSupported: !boolean,
   *  }>}
   */

  bindRecognizer(
      receiver,
      client,
      options) {
    return this.proxy.sendMessage(
        0,
        media.mojom.SpeechRecognitionContext_BindRecognizer_ParamsSpec.$,
        media.mojom.SpeechRecognitionContext_BindRecognizer_ResponseParamsSpec.$,
        [
          receiver,
          client,
          options
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.SpeechRecognitionSessionPendingReceiver } sessionReceiver
   * @param { !media.mojom.SpeechRecognitionSessionClientRemote } sessionClient
   * @param { !media.mojom.SpeechRecognitionAudioForwarderPendingReceiver } audioForwarder
   * @param { !number } channelCount
   * @param { !number } sampleRate
   * @param { !media.mojom.SpeechRecognitionOptions } options
   * @param { !boolean } continuous
   */

  bindWebSpeechRecognizer(
      sessionReceiver,
      sessionClient,
      audioForwarder,
      channelCount,
      sampleRate,
      options,
      continuous) {
    this.proxy.sendMessage(
        1,
        media.mojom.SpeechRecognitionContext_BindWebSpeechRecognizer_ParamsSpec.$,
        null,
        [
          sessionReceiver,
          sessionClient,
          audioForwarder,
          channelCount,
          sampleRate,
          options,
          continuous
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SpeechRecognitionContext
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.SpeechRecognitionContextReceiver = class {
  /**
   * @param {!media.mojom.SpeechRecognitionContextInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.SpeechRecognitionContextRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.SpeechRecognitionContextRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.SpeechRecognitionContextRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.SpeechRecognitionContext_BindRecognizer_ParamsSpec.$,
        media.mojom.SpeechRecognitionContext_BindRecognizer_ResponseParamsSpec.$,
        impl.bindRecognizer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.SpeechRecognitionContext_BindWebSpeechRecognizer_ParamsSpec.$,
        null,
        impl.bindWebSpeechRecognizer.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.SpeechRecognitionContext = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.SpeechRecognitionContext";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.SpeechRecognitionContextRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.SpeechRecognitionContextRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SpeechRecognitionContext
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.SpeechRecognitionContextCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.SpeechRecognitionContextRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.SpeechRecognitionContextRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindRecognizer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.SpeechRecognitionContext_BindRecognizer_ParamsSpec.$,
        media.mojom.SpeechRecognitionContext_BindRecognizer_ResponseParamsSpec.$,
        this.bindRecognizer.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindWebSpeechRecognizer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.SpeechRecognitionContext_BindWebSpeechRecognizer_ParamsSpec.$,
        null,
        this.bindWebSpeechRecognizer.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.SpeechRecognitionRecognizer');
goog.provide('media.mojom.SpeechRecognitionRecognizerReceiver');
goog.provide('media.mojom.SpeechRecognitionRecognizerCallbackRouter');
goog.provide('media.mojom.SpeechRecognitionRecognizerInterface');
goog.provide('media.mojom.SpeechRecognitionRecognizerRemote');
goog.provide('media.mojom.SpeechRecognitionRecognizerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.SpeechRecognitionRecognizerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.SpeechRecognitionRecognizer.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.SpeechRecognitionRecognizerInterface = class {
  
  /**
   * @param { !media.mojom.AudioDataS16 } buffer
   * @param { ?mojoBase.mojom.TimeDelta } mediaStartPts
   */

  sendAudioToSpeechRecognitionService(buffer, mediaStartPts) {}
  
  /**
   */

  markDone() {}
  
  /**
   * @param { !string } language
   */

  onLanguageChanged(language) {}
  
  /**
   * @param { !boolean } maskOffensiveWords
   */

  onMaskOffensiveWordsChanged(maskOffensiveWords) {}
  
  /**
   * @param { !media.mojom.SpeechRecognitionRecognitionContext } recognitionContext
   */

  updateRecognitionContext(recognitionContext) {}
};

/**
 * @export
 * @implements { media.mojom.SpeechRecognitionRecognizerInterface }
 */
media.mojom.SpeechRecognitionRecognizerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.SpeechRecognitionRecognizerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.SpeechRecognitionRecognizerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.SpeechRecognitionRecognizerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media.mojom.AudioDataS16 } buffer
   * @param { ?mojoBase.mojom.TimeDelta } mediaStartPts
   */

  sendAudioToSpeechRecognitionService(
      buffer,
      mediaStartPts) {
    this.proxy.sendMessage(
        0,
        media.mojom.SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_ParamsSpec.$,
        null,
        [
          buffer,
          mediaStartPts
        ],
        false);
  }

  
  /**
   */

  markDone() {
    this.proxy.sendMessage(
        1,
        media.mojom.SpeechRecognitionRecognizer_MarkDone_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } language
   */

  onLanguageChanged(
      language) {
    this.proxy.sendMessage(
        2,
        media.mojom.SpeechRecognitionRecognizer_OnLanguageChanged_ParamsSpec.$,
        null,
        [
          language
        ],
        false);
  }

  
  /**
   * @param { !boolean } maskOffensiveWords
   */

  onMaskOffensiveWordsChanged(
      maskOffensiveWords) {
    this.proxy.sendMessage(
        3,
        media.mojom.SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_ParamsSpec.$,
        null,
        [
          maskOffensiveWords
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.SpeechRecognitionRecognitionContext } recognitionContext
   */

  updateRecognitionContext(
      recognitionContext) {
    this.proxy.sendMessage(
        4,
        media.mojom.SpeechRecognitionRecognizer_UpdateRecognitionContext_ParamsSpec.$,
        null,
        [
          recognitionContext
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SpeechRecognitionRecognizer
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.SpeechRecognitionRecognizerReceiver = class {
  /**
   * @param {!media.mojom.SpeechRecognitionRecognizerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.SpeechRecognitionRecognizerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.SpeechRecognitionRecognizerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.SpeechRecognitionRecognizerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_ParamsSpec.$,
        null,
        impl.sendAudioToSpeechRecognitionService.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.SpeechRecognitionRecognizer_MarkDone_ParamsSpec.$,
        null,
        impl.markDone.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        media.mojom.SpeechRecognitionRecognizer_OnLanguageChanged_ParamsSpec.$,
        null,
        impl.onLanguageChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        media.mojom.SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_ParamsSpec.$,
        null,
        impl.onMaskOffensiveWordsChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        media.mojom.SpeechRecognitionRecognizer_UpdateRecognitionContext_ParamsSpec.$,
        null,
        impl.updateRecognitionContext.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.SpeechRecognitionRecognizer = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.SpeechRecognitionRecognizer";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.SpeechRecognitionRecognizerRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.SpeechRecognitionRecognizerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SpeechRecognitionRecognizer
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.SpeechRecognitionRecognizerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.SpeechRecognitionRecognizerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.SpeechRecognitionRecognizerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendAudioToSpeechRecognitionService =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_ParamsSpec.$,
        null,
        this.sendAudioToSpeechRecognitionService.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.markDone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.SpeechRecognitionRecognizer_MarkDone_ParamsSpec.$,
        null,
        this.markDone.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onLanguageChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        media.mojom.SpeechRecognitionRecognizer_OnLanguageChanged_ParamsSpec.$,
        null,
        this.onLanguageChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onMaskOffensiveWordsChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        media.mojom.SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_ParamsSpec.$,
        null,
        this.onMaskOffensiveWordsChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateRecognitionContext =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        media.mojom.SpeechRecognitionRecognizer_UpdateRecognitionContext_ParamsSpec.$,
        null,
        this.updateRecognitionContext.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.SpeechRecognitionRecognizerClient');
goog.provide('media.mojom.SpeechRecognitionRecognizerClientReceiver');
goog.provide('media.mojom.SpeechRecognitionRecognizerClientCallbackRouter');
goog.provide('media.mojom.SpeechRecognitionRecognizerClientInterface');
goog.provide('media.mojom.SpeechRecognitionRecognizerClientRemote');
goog.provide('media.mojom.SpeechRecognitionRecognizerClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.SpeechRecognitionRecognizerClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.SpeechRecognitionRecognizerClient.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.SpeechRecognitionRecognizerClientInterface = class {
  
  /**
   * @param { !media.mojom.SpeechRecognitionResult } result
   * @return {!Promise<{
        continueRecognition: !boolean,
   *  }>}
   */

  onSpeechRecognitionRecognitionEvent(result) {}
  
  /**
   */

  onSpeechRecognitionStopped() {}
  
  /**
   */

  onSpeechRecognitionError() {}
  
  /**
   * @param { !media.mojom.LanguageIdentificationEvent } event
   */

  onLanguageIdentificationEvent(event) {}
};

/**
 * @export
 * @implements { media.mojom.SpeechRecognitionRecognizerClientInterface }
 */
media.mojom.SpeechRecognitionRecognizerClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.SpeechRecognitionRecognizerClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.SpeechRecognitionRecognizerClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.SpeechRecognitionRecognizerClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media.mojom.SpeechRecognitionResult } result
   * @return {!Promise<{
        continueRecognition: !boolean,
   *  }>}
   */

  onSpeechRecognitionRecognitionEvent(
      result) {
    return this.proxy.sendMessage(
        0,
        media.mojom.SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ParamsSpec.$,
        media.mojom.SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParamsSpec.$,
        [
          result
        ],
        false);
  }

  
  /**
   */

  onSpeechRecognitionStopped() {
    this.proxy.sendMessage(
        1,
        media.mojom.SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  onSpeechRecognitionError() {
    this.proxy.sendMessage(
        2,
        media.mojom.SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.LanguageIdentificationEvent } event
   */

  onLanguageIdentificationEvent(
      event) {
    this.proxy.sendMessage(
        3,
        media.mojom.SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_ParamsSpec.$,
        null,
        [
          event
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SpeechRecognitionRecognizerClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.SpeechRecognitionRecognizerClientReceiver = class {
  /**
   * @param {!media.mojom.SpeechRecognitionRecognizerClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.SpeechRecognitionRecognizerClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.SpeechRecognitionRecognizerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.SpeechRecognitionRecognizerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ParamsSpec.$,
        media.mojom.SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParamsSpec.$,
        impl.onSpeechRecognitionRecognitionEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_ParamsSpec.$,
        null,
        impl.onSpeechRecognitionStopped.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        media.mojom.SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_ParamsSpec.$,
        null,
        impl.onSpeechRecognitionError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        media.mojom.SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_ParamsSpec.$,
        null,
        impl.onLanguageIdentificationEvent.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.SpeechRecognitionRecognizerClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.SpeechRecognitionRecognizerClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.SpeechRecognitionRecognizerClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.SpeechRecognitionRecognizerClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SpeechRecognitionRecognizerClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.SpeechRecognitionRecognizerClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.SpeechRecognitionRecognizerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.SpeechRecognitionRecognizerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSpeechRecognitionRecognitionEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ParamsSpec.$,
        media.mojom.SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParamsSpec.$,
        this.onSpeechRecognitionRecognitionEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSpeechRecognitionStopped =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_ParamsSpec.$,
        null,
        this.onSpeechRecognitionStopped.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSpeechRecognitionError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        media.mojom.SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_ParamsSpec.$,
        null,
        this.onSpeechRecognitionError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onLanguageIdentificationEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        media.mojom.SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_ParamsSpec.$,
        null,
        this.onLanguageIdentificationEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.SpeechRecognitionBrowserObserver');
goog.provide('media.mojom.SpeechRecognitionBrowserObserverReceiver');
goog.provide('media.mojom.SpeechRecognitionBrowserObserverCallbackRouter');
goog.provide('media.mojom.SpeechRecognitionBrowserObserverInterface');
goog.provide('media.mojom.SpeechRecognitionBrowserObserverRemote');
goog.provide('media.mojom.SpeechRecognitionBrowserObserverPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.SpeechRecognitionBrowserObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.SpeechRecognitionBrowserObserver.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.SpeechRecognitionBrowserObserverInterface = class {
  
  /**
   * @param { !boolean } isSpeechRecognitionAvailable
   */

  speechRecognitionAvailabilityChanged(isSpeechRecognitionAvailable) {}
  
  /**
   * @param { !string } language
   */

  speechRecognitionLanguageChanged(language) {}
  
  /**
   * @param { !boolean } maskOffensiveWords
   */

  speechRecognitionMaskOffensiveWordsChanged(maskOffensiveWords) {}
};

/**
 * @export
 * @implements { media.mojom.SpeechRecognitionBrowserObserverInterface }
 */
media.mojom.SpeechRecognitionBrowserObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.SpeechRecognitionBrowserObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.SpeechRecognitionBrowserObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.SpeechRecognitionBrowserObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } isSpeechRecognitionAvailable
   */

  speechRecognitionAvailabilityChanged(
      isSpeechRecognitionAvailable) {
    this.proxy.sendMessage(
        0,
        media.mojom.SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_ParamsSpec.$,
        null,
        [
          isSpeechRecognitionAvailable
        ],
        false);
  }

  
  /**
   * @param { !string } language
   */

  speechRecognitionLanguageChanged(
      language) {
    this.proxy.sendMessage(
        1,
        media.mojom.SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_ParamsSpec.$,
        null,
        [
          language
        ],
        false);
  }

  
  /**
   * @param { !boolean } maskOffensiveWords
   */

  speechRecognitionMaskOffensiveWordsChanged(
      maskOffensiveWords) {
    this.proxy.sendMessage(
        2,
        media.mojom.SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_ParamsSpec.$,
        null,
        [
          maskOffensiveWords
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SpeechRecognitionBrowserObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.SpeechRecognitionBrowserObserverReceiver = class {
  /**
   * @param {!media.mojom.SpeechRecognitionBrowserObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.SpeechRecognitionBrowserObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.SpeechRecognitionBrowserObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.SpeechRecognitionBrowserObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_ParamsSpec.$,
        null,
        impl.speechRecognitionAvailabilityChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_ParamsSpec.$,
        null,
        impl.speechRecognitionLanguageChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        media.mojom.SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_ParamsSpec.$,
        null,
        impl.speechRecognitionMaskOffensiveWordsChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.SpeechRecognitionBrowserObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.SpeechRecognitionBrowserObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.SpeechRecognitionBrowserObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.SpeechRecognitionBrowserObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SpeechRecognitionBrowserObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.SpeechRecognitionBrowserObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.SpeechRecognitionBrowserObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.SpeechRecognitionBrowserObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.speechRecognitionAvailabilityChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_ParamsSpec.$,
        null,
        this.speechRecognitionAvailabilityChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.speechRecognitionLanguageChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_ParamsSpec.$,
        null,
        this.speechRecognitionLanguageChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.speechRecognitionMaskOffensiveWordsChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        media.mojom.SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_ParamsSpec.$,
        null,
        this.speechRecognitionMaskOffensiveWordsChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.SpeechRecognitionSurface');
goog.provide('media.mojom.SpeechRecognitionSurfaceReceiver');
goog.provide('media.mojom.SpeechRecognitionSurfaceCallbackRouter');
goog.provide('media.mojom.SpeechRecognitionSurfaceInterface');
goog.provide('media.mojom.SpeechRecognitionSurfaceRemote');
goog.provide('media.mojom.SpeechRecognitionSurfacePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.SpeechRecognitionSurfacePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.SpeechRecognitionSurface.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.SpeechRecognitionSurfaceInterface = class {
  
  /**
   */

  activate() {}
  
  /**
   * @return {!Promise<{
        bounds: ?gfx.mojom.Rect,
   *  }>}
   */

  getBounds() {}
};

/**
 * @export
 * @implements { media.mojom.SpeechRecognitionSurfaceInterface }
 */
media.mojom.SpeechRecognitionSurfaceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.SpeechRecognitionSurfacePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.SpeechRecognitionSurfacePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.SpeechRecognitionSurfacePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  activate() {
    this.proxy.sendMessage(
        0,
        media.mojom.SpeechRecognitionSurface_Activate_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        bounds: ?gfx.mojom.Rect,
   *  }>}
   */

  getBounds() {
    return this.proxy.sendMessage(
        1,
        media.mojom.SpeechRecognitionSurface_GetBounds_ParamsSpec.$,
        media.mojom.SpeechRecognitionSurface_GetBounds_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SpeechRecognitionSurface
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.SpeechRecognitionSurfaceReceiver = class {
  /**
   * @param {!media.mojom.SpeechRecognitionSurfaceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.SpeechRecognitionSurfaceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.SpeechRecognitionSurfaceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.SpeechRecognitionSurfaceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.SpeechRecognitionSurface_Activate_ParamsSpec.$,
        null,
        impl.activate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.SpeechRecognitionSurface_GetBounds_ParamsSpec.$,
        media.mojom.SpeechRecognitionSurface_GetBounds_ResponseParamsSpec.$,
        impl.getBounds.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.SpeechRecognitionSurface = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.SpeechRecognitionSurface";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.SpeechRecognitionSurfaceRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.SpeechRecognitionSurfaceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SpeechRecognitionSurface
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.SpeechRecognitionSurfaceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.SpeechRecognitionSurfaceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.SpeechRecognitionSurfaceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.activate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.SpeechRecognitionSurface_Activate_ParamsSpec.$,
        null,
        this.activate.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getBounds =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.SpeechRecognitionSurface_GetBounds_ParamsSpec.$,
        media.mojom.SpeechRecognitionSurface_GetBounds_ResponseParamsSpec.$,
        this.getBounds.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.SpeechRecognitionSurfaceClient');
goog.provide('media.mojom.SpeechRecognitionSurfaceClientReceiver');
goog.provide('media.mojom.SpeechRecognitionSurfaceClientCallbackRouter');
goog.provide('media.mojom.SpeechRecognitionSurfaceClientInterface');
goog.provide('media.mojom.SpeechRecognitionSurfaceClientRemote');
goog.provide('media.mojom.SpeechRecognitionSurfaceClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.SpeechRecognitionSurfaceClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.SpeechRecognitionSurfaceClient.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.SpeechRecognitionSurfaceClientInterface = class {
  
  /**
   */

  onSessionEnded() {}
  
  /**
   */

  onFullscreenToggled() {}
};

/**
 * @export
 * @implements { media.mojom.SpeechRecognitionSurfaceClientInterface }
 */
media.mojom.SpeechRecognitionSurfaceClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.SpeechRecognitionSurfaceClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.SpeechRecognitionSurfaceClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.SpeechRecognitionSurfaceClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onSessionEnded() {
    this.proxy.sendMessage(
        0,
        media.mojom.SpeechRecognitionSurfaceClient_OnSessionEnded_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  onFullscreenToggled() {
    this.proxy.sendMessage(
        1,
        media.mojom.SpeechRecognitionSurfaceClient_OnFullscreenToggled_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SpeechRecognitionSurfaceClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.SpeechRecognitionSurfaceClientReceiver = class {
  /**
   * @param {!media.mojom.SpeechRecognitionSurfaceClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.SpeechRecognitionSurfaceClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.SpeechRecognitionSurfaceClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.SpeechRecognitionSurfaceClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.SpeechRecognitionSurfaceClient_OnSessionEnded_ParamsSpec.$,
        null,
        impl.onSessionEnded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.SpeechRecognitionSurfaceClient_OnFullscreenToggled_ParamsSpec.$,
        null,
        impl.onFullscreenToggled.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.SpeechRecognitionSurfaceClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.SpeechRecognitionSurfaceClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.SpeechRecognitionSurfaceClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.SpeechRecognitionSurfaceClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SpeechRecognitionSurfaceClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.SpeechRecognitionSurfaceClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.SpeechRecognitionSurfaceClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.SpeechRecognitionSurfaceClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSessionEnded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.SpeechRecognitionSurfaceClient_OnSessionEnded_ParamsSpec.$,
        null,
        this.onSessionEnded.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onFullscreenToggled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.SpeechRecognitionSurfaceClient_OnFullscreenToggled_ParamsSpec.$,
        null,
        this.onFullscreenToggled.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.SpeechRecognitionClientBrowserInterface');
goog.provide('media.mojom.SpeechRecognitionClientBrowserInterfaceReceiver');
goog.provide('media.mojom.SpeechRecognitionClientBrowserInterfaceCallbackRouter');
goog.provide('media.mojom.SpeechRecognitionClientBrowserInterfaceInterface');
goog.provide('media.mojom.SpeechRecognitionClientBrowserInterfaceRemote');
goog.provide('media.mojom.SpeechRecognitionClientBrowserInterfacePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.SpeechRecognitionClientBrowserInterfacePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.SpeechRecognitionClientBrowserInterface.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.SpeechRecognitionClientBrowserInterfaceInterface = class {
  
  /**
   * @param { !media.mojom.SpeechRecognitionBrowserObserverRemote } observer
   */

  bindSpeechRecognitionBrowserObserver(observer) {}
  
  /**
   */

  rEMOVED1() {}
};

/**
 * @export
 * @implements { media.mojom.SpeechRecognitionClientBrowserInterfaceInterface }
 */
media.mojom.SpeechRecognitionClientBrowserInterfaceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.SpeechRecognitionClientBrowserInterfacePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.SpeechRecognitionClientBrowserInterfacePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.SpeechRecognitionClientBrowserInterfacePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media.mojom.SpeechRecognitionBrowserObserverRemote } observer
   */

  bindSpeechRecognitionBrowserObserver(
      observer) {
    this.proxy.sendMessage(
        0,
        media.mojom.SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }

  
  /**
   */

  rEMOVED1() {
    this.proxy.sendMessage(
        1,
        media.mojom.SpeechRecognitionClientBrowserInterface_REMOVED_1_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SpeechRecognitionClientBrowserInterface
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.SpeechRecognitionClientBrowserInterfaceReceiver = class {
  /**
   * @param {!media.mojom.SpeechRecognitionClientBrowserInterfaceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.SpeechRecognitionClientBrowserInterfaceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.SpeechRecognitionClientBrowserInterfaceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.SpeechRecognitionClientBrowserInterfaceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_ParamsSpec.$,
        null,
        impl.bindSpeechRecognitionBrowserObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.SpeechRecognitionClientBrowserInterface_REMOVED_1_ParamsSpec.$,
        null,
        impl.rEMOVED1.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.SpeechRecognitionClientBrowserInterface = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.SpeechRecognitionClientBrowserInterface";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.SpeechRecognitionClientBrowserInterfaceRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.SpeechRecognitionClientBrowserInterfaceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SpeechRecognitionClientBrowserInterface
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.SpeechRecognitionClientBrowserInterfaceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.SpeechRecognitionClientBrowserInterfaceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.SpeechRecognitionClientBrowserInterfaceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindSpeechRecognitionBrowserObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_ParamsSpec.$,
        null,
        this.bindSpeechRecognitionBrowserObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.rEMOVED1 =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.SpeechRecognitionClientBrowserInterface_REMOVED_1_ParamsSpec.$,
        null,
        this.rEMOVED1.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.HypothesisPartsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.HypothesisPartsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.MediaTimestampRangeSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.MediaTimestampRangeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.TimingInformationSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.TimingInformationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.SpeechRecognitionResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.LanguageIdentificationEventSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.LanguageIdentificationEventSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.SpeechRecognitionOptionsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.SpeechRecognitionContext_BindRecognizer_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionContext_BindRecognizer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.SpeechRecognitionContext_BindRecognizer_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionContext_BindRecognizer_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.SpeechRecognitionContext_BindWebSpeechRecognizer_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionContext_BindWebSpeechRecognizer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.SpeechRecognitionRecognizer_MarkDone_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionRecognizer_MarkDone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.SpeechRecognitionRecognizer_OnLanguageChanged_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionRecognizer_OnLanguageChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.SpeechRecognitionRecognizer_UpdateRecognitionContext_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionRecognizer_UpdateRecognitionContext_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.SpeechRecognitionSurface_Activate_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionSurface_Activate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.SpeechRecognitionSurface_GetBounds_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionSurface_GetBounds_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.SpeechRecognitionSurface_GetBounds_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionSurface_GetBounds_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.SpeechRecognitionSurfaceClient_OnSessionEnded_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionSurfaceClient_OnSessionEnded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.SpeechRecognitionSurfaceClient_OnFullscreenToggled_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionSurfaceClient_OnFullscreenToggled_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.SpeechRecognitionClientBrowserInterface_REMOVED_1_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SpeechRecognitionClientBrowserInterface_REMOVED_1_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    media.mojom.HypothesisPartsSpec.$,
    'HypothesisParts',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hypothesisPartOffset', 8,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.HypothesisParts');

/** @record */
media.mojom.HypothesisParts = class {
  constructor() {
    /** @export { !Array<!string> } */
    this.text;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.hypothesisPartOffset;
  }
};



mojo.internal.Struct(
    media.mojom.MediaTimestampRangeSpec.$,
    'MediaTimestampRange',
    [
      mojo.internal.StructField(
        'start', 0,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'end', 8,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.MediaTimestampRange');

/** @record */
media.mojom.MediaTimestampRange = class {
  constructor() {
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.start;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.end;
  }
};



mojo.internal.Struct(
    media.mojom.TimingInformationSpec.$,
    'TimingInformation',
    [
      mojo.internal.StructField(
        'audioStartTime', 0,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'audioEndTime', 8,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hypothesisParts', 16,
        0,
        mojo.internal.Array(media.mojom.HypothesisPartsSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'originatingMediaTimestamps', 24,
        0,
        mojo.internal.Array(media.mojom.MediaTimestampRangeSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],[11, 40],]);



goog.provide('media.mojom.TimingInformation');

/** @record */
media.mojom.TimingInformation = class {
  constructor() {
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.audioStartTime;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.audioEndTime;
    /** @export { (Array<!media.mojom.HypothesisParts>|undefined) } */
    this.hypothesisParts;
    /** @export { (Array<!media.mojom.MediaTimestampRange>|undefined) } */
    this.originatingMediaTimestamps;
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionResultSpec.$,
    'SpeechRecognitionResult',
    [
      mojo.internal.StructField(
        'transcription', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isFinal', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'timingInformation', 16,
        0,
        media.mojom.TimingInformationSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('media.mojom.SpeechRecognitionResult');

/** @record */
media.mojom.SpeechRecognitionResult = class {
  constructor() {
    /** @export { !string } */
    this.transcription;
    /** @export { !boolean } */
    this.isFinal;
    /** @export { (media.mojom.TimingInformation|undefined) } */
    this.timingInformation;
  }
};



mojo.internal.Struct(
    media.mojom.LanguageIdentificationEventSpec.$,
    'LanguageIdentificationEvent',
    [
      mojo.internal.StructField(
        'language', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'confidenceLevel', 8,
        0,
        media.mojom.ConfidenceLevelSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'asr_switch_result_$flag', 12,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "asr_switch_result_$value",
          originalFieldName: "asrSwitchResult",
        }
      ),
      mojo.internal.StructField(
        'asr_switch_result_$value', 16,
        0,
        media.mojom.AsrSwitchResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "asrSwitchResult",
        }
      ),
    ],
    [[0, 24],[1, 32],]);



goog.provide('media.mojom.LanguageIdentificationEvent');

/** @record */
media.mojom.LanguageIdentificationEvent = class {
  constructor() {
    /** @export { !string } */
    this.language;
    /** @export { !media.mojom.ConfidenceLevel } */
    this.confidenceLevel;
    /** @export { (media.mojom.AsrSwitchResult|undefined) } */
    this.asrSwitchResult;
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionOptionsSpec.$,
    'SpeechRecognitionOptions',
    [
      mojo.internal.StructField(
        'recognitionMode', 0,
        0,
        media.mojom.SpeechRecognitionModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'enableFormatting', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'language', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isServerBased', 4,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'recognizerClientType', 16,
        0,
        media.mojom.RecognizerClientTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'skipContinuouslyEmptyAudio', 4,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'experimentRecognizerRoutingKey', 24,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'channelCount', 20,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sampleRate', 32,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'recognitionContext', 40,
        0,
        media.mojom.SpeechRecognitionRecognitionContextSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],[1, 32],[4, 32],[5, 40],[6, 48],[8, 56],]);



goog.provide('media.mojom.SpeechRecognitionOptions');

/** @record */
media.mojom.SpeechRecognitionOptions = class {
  constructor() {
    /** @export { !media.mojom.SpeechRecognitionMode } */
    this.recognitionMode;
    /** @export { !boolean } */
    this.enableFormatting;
    /** @export { (string|undefined) } */
    this.language;
    /** @export { !boolean } */
    this.isServerBased;
    /** @export { !media.mojom.RecognizerClientType } */
    this.recognizerClientType;
    /** @export { !boolean } */
    this.skipContinuouslyEmptyAudio;
    /** @export { (string|undefined) } */
    this.experimentRecognizerRoutingKey;
    /** @export { !number } */
    this.channelCount;
    /** @export { !number } */
    this.sampleRate;
    /** @export { (media.mojom.SpeechRecognitionRecognitionContext|undefined) } */
    this.recognitionContext;
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionContext_BindRecognizer_ParamsSpec.$,
    'SpeechRecognitionContext_BindRecognizer_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(media.mojom.SpeechRecognitionRecognizerPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 4,
        0,
        mojo.internal.InterfaceProxy(media.mojom.SpeechRecognitionRecognizerClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'options', 16,
        0,
        media.mojom.SpeechRecognitionOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('media.mojom.SpeechRecognitionContext_BindRecognizer_Params');

/** @record */
media.mojom.SpeechRecognitionContext_BindRecognizer_Params = class {
  constructor() {
    /** @export { !media.mojom.SpeechRecognitionRecognizerPendingReceiver } */
    this.receiver;
    /** @export { !media.mojom.SpeechRecognitionRecognizerClientRemote } */
    this.client;
    /** @export { !media.mojom.SpeechRecognitionOptions } */
    this.options;
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionContext_BindRecognizer_ResponseParamsSpec.$,
    'SpeechRecognitionContext_BindRecognizer_ResponseParams',
    [
      mojo.internal.StructField(
        'isMultichannelSupported', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.SpeechRecognitionContext_BindRecognizer_ResponseParams');

/** @record */
media.mojom.SpeechRecognitionContext_BindRecognizer_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.isMultichannelSupported;
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionContext_BindWebSpeechRecognizer_ParamsSpec.$,
    'SpeechRecognitionContext_BindWebSpeechRecognizer_Params',
    [
      mojo.internal.StructField(
        'sessionReceiver', 0,
        0,
        mojo.internal.InterfaceRequest(media.mojom.SpeechRecognitionSessionPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sessionClient', 4,
        0,
        mojo.internal.InterfaceProxy(media.mojom.SpeechRecognitionSessionClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'audioForwarder', 12,
        0,
        mojo.internal.InterfaceRequest(media.mojom.SpeechRecognitionAudioForwarderPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'channelCount', 16,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sampleRate', 20,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'options', 24,
        0,
        media.mojom.SpeechRecognitionOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'continuous', 32,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('media.mojom.SpeechRecognitionContext_BindWebSpeechRecognizer_Params');

/** @record */
media.mojom.SpeechRecognitionContext_BindWebSpeechRecognizer_Params = class {
  constructor() {
    /** @export { !media.mojom.SpeechRecognitionSessionPendingReceiver } */
    this.sessionReceiver;
    /** @export { !media.mojom.SpeechRecognitionSessionClientRemote } */
    this.sessionClient;
    /** @export { !media.mojom.SpeechRecognitionAudioForwarderPendingReceiver } */
    this.audioForwarder;
    /** @export { !number } */
    this.channelCount;
    /** @export { !number } */
    this.sampleRate;
    /** @export { !media.mojom.SpeechRecognitionOptions } */
    this.options;
    /** @export { !boolean } */
    this.continuous;
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_ParamsSpec.$,
    'SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        media.mojom.AudioDataS16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mediaStartPts', 8,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],[10, 24],]);



goog.provide('media.mojom.SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params');

/** @record */
media.mojom.SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params = class {
  constructor() {
    /** @export { !media.mojom.AudioDataS16 } */
    this.buffer;
    /** @export { (mojoBase.mojom.TimeDelta|undefined) } */
    this.mediaStartPts;
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionRecognizer_MarkDone_ParamsSpec.$,
    'SpeechRecognitionRecognizer_MarkDone_Params',
    [
    ],
    [[0, 8],]);



goog.provide('media.mojom.SpeechRecognitionRecognizer_MarkDone_Params');

/** @record */
media.mojom.SpeechRecognitionRecognizer_MarkDone_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionRecognizer_OnLanguageChanged_ParamsSpec.$,
    'SpeechRecognitionRecognizer_OnLanguageChanged_Params',
    [
      mojo.internal.StructField(
        'language', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.SpeechRecognitionRecognizer_OnLanguageChanged_Params');

/** @record */
media.mojom.SpeechRecognitionRecognizer_OnLanguageChanged_Params = class {
  constructor() {
    /** @export { !string } */
    this.language;
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_ParamsSpec.$,
    'SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_Params',
    [
      mojo.internal.StructField(
        'maskOffensiveWords', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_Params');

/** @record */
media.mojom.SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.maskOffensiveWords;
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionRecognizer_UpdateRecognitionContext_ParamsSpec.$,
    'SpeechRecognitionRecognizer_UpdateRecognitionContext_Params',
    [
      mojo.internal.StructField(
        'recognitionContext', 0,
        0,
        media.mojom.SpeechRecognitionRecognitionContextSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.SpeechRecognitionRecognizer_UpdateRecognitionContext_Params');

/** @record */
media.mojom.SpeechRecognitionRecognizer_UpdateRecognitionContext_Params = class {
  constructor() {
    /** @export { !media.mojom.SpeechRecognitionRecognitionContext } */
    this.recognitionContext;
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ParamsSpec.$,
    'SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        media.mojom.SpeechRecognitionResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params');

/** @record */
media.mojom.SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params = class {
  constructor() {
    /** @export { !media.mojom.SpeechRecognitionResult } */
    this.result;
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParamsSpec.$,
    'SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'continueRecognition', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams');

/** @record */
media.mojom.SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.continueRecognition;
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_ParamsSpec.$,
    'SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_Params',
    [
    ],
    [[0, 8],]);



goog.provide('media.mojom.SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_Params');

/** @record */
media.mojom.SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_ParamsSpec.$,
    'SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params',
    [
    ],
    [[0, 8],]);



goog.provide('media.mojom.SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params');

/** @record */
media.mojom.SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_ParamsSpec.$,
    'SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params',
    [
      mojo.internal.StructField(
        'event', 0,
        0,
        media.mojom.LanguageIdentificationEventSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params');

/** @record */
media.mojom.SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params = class {
  constructor() {
    /** @export { !media.mojom.LanguageIdentificationEvent } */
    this.event;
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_ParamsSpec.$,
    'SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params',
    [
      mojo.internal.StructField(
        'isSpeechRecognitionAvailable', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params');

/** @record */
media.mojom.SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.isSpeechRecognitionAvailable;
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_ParamsSpec.$,
    'SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params',
    [
      mojo.internal.StructField(
        'language', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params');

/** @record */
media.mojom.SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params = class {
  constructor() {
    /** @export { !string } */
    this.language;
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_ParamsSpec.$,
    'SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_Params',
    [
      mojo.internal.StructField(
        'maskOffensiveWords', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_Params');

/** @record */
media.mojom.SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.maskOffensiveWords;
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionSurface_Activate_ParamsSpec.$,
    'SpeechRecognitionSurface_Activate_Params',
    [
    ],
    [[0, 8],]);



goog.provide('media.mojom.SpeechRecognitionSurface_Activate_Params');

/** @record */
media.mojom.SpeechRecognitionSurface_Activate_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionSurface_GetBounds_ParamsSpec.$,
    'SpeechRecognitionSurface_GetBounds_Params',
    [
    ],
    [[0, 8],]);



goog.provide('media.mojom.SpeechRecognitionSurface_GetBounds_Params');

/** @record */
media.mojom.SpeechRecognitionSurface_GetBounds_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionSurface_GetBounds_ResponseParamsSpec.$,
    'SpeechRecognitionSurface_GetBounds_ResponseParams',
    [
      mojo.internal.StructField(
        'bounds', 0,
        0,
        gfx.mojom.RectSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.SpeechRecognitionSurface_GetBounds_ResponseParams');

/** @record */
media.mojom.SpeechRecognitionSurface_GetBounds_ResponseParams = class {
  constructor() {
    /** @export { (gfx.mojom.Rect|undefined) } */
    this.bounds;
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionSurfaceClient_OnSessionEnded_ParamsSpec.$,
    'SpeechRecognitionSurfaceClient_OnSessionEnded_Params',
    [
    ],
    [[0, 8],]);



goog.provide('media.mojom.SpeechRecognitionSurfaceClient_OnSessionEnded_Params');

/** @record */
media.mojom.SpeechRecognitionSurfaceClient_OnSessionEnded_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionSurfaceClient_OnFullscreenToggled_ParamsSpec.$,
    'SpeechRecognitionSurfaceClient_OnFullscreenToggled_Params',
    [
    ],
    [[0, 8],]);



goog.provide('media.mojom.SpeechRecognitionSurfaceClient_OnFullscreenToggled_Params');

/** @record */
media.mojom.SpeechRecognitionSurfaceClient_OnFullscreenToggled_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_ParamsSpec.$,
    'SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(media.mojom.SpeechRecognitionBrowserObserverRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params');

/** @record */
media.mojom.SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params = class {
  constructor() {
    /** @export { !media.mojom.SpeechRecognitionBrowserObserverRemote } */
    this.observer;
  }
};



mojo.internal.Struct(
    media.mojom.SpeechRecognitionClientBrowserInterface_REMOVED_1_ParamsSpec.$,
    'SpeechRecognitionClientBrowserInterface_REMOVED_1_Params',
    [
    ],
    [[0, 8],]);



goog.provide('media.mojom.SpeechRecognitionClientBrowserInterface_REMOVED_1_Params');

/** @record */
media.mojom.SpeechRecognitionClientBrowserInterface_REMOVED_1_Params = class {
  constructor() {
  }
};

