// media/mojo/mojom/remoting_common.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_REMOTING_COMMON_MOJOM_SHARED_H_
#define MEDIA_MOJO_MOJOM_REMOTING_COMMON_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/remoting_common.mojom-shared-internal.h"




#include "media/mojo/mojom/remoting_common.mojom-data-view.h"




namespace std {

template <>
struct hash<::media::mojom::RemotingStopReason>
    : public mojo::internal::EnumHashImpl<::media::mojom::RemotingStopReason> {};

template <>
struct hash<::media::mojom::RemotingStartFailReason>
    : public mojo::internal::EnumHashImpl<::media::mojom::RemotingStartFailReason> {};

template <>
struct hash<::media::mojom::RemotingSinkFeature>
    : public mojo::internal::EnumHashImpl<::media::mojom::RemotingSinkFeature> {};

template <>
struct hash<::media::mojom::RemotingSinkAudioCapability>
    : public mojo::internal::EnumHashImpl<::media::mojom::RemotingSinkAudioCapability> {};

template <>
struct hash<::media::mojom::RemotingSinkVideoCapability>
    : public mojo::internal::EnumHashImpl<::media::mojom::RemotingSinkVideoCapability> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::RemotingStopReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::RemotingStopReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::RemotingStopReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::RemotingStartFailReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::RemotingStartFailReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::RemotingStartFailReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::RemotingSinkFeature, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::RemotingSinkFeature, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::RemotingSinkFeature>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::RemotingSinkAudioCapability, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::RemotingSinkAudioCapability, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::RemotingSinkAudioCapability>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::RemotingSinkVideoCapability, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::RemotingSinkVideoCapability, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::RemotingSinkVideoCapability>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::RemotingSinkMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::RemotingSinkMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::RemotingSinkMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::features(input)) in_features = Traits::features(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->features)::BaseType>
        features_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& features_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::RemotingSinkFeature_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::RemotingSinkFeature>>(
      in_features,
      features_fragment,
      &features_validate_params);

    fragment->features.Set(
        features_fragment.is_null() ? nullptr : features_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->features.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null features in RemotingSinkMetadata struct");

    decltype(Traits::audio_capabilities(input)) in_audio_capabilities = Traits::audio_capabilities(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->audio_capabilities)::BaseType>
        audio_capabilities_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& audio_capabilities_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::RemotingSinkAudioCapability_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::RemotingSinkAudioCapability>>(
      in_audio_capabilities,
      audio_capabilities_fragment,
      &audio_capabilities_validate_params);

    fragment->audio_capabilities.Set(
        audio_capabilities_fragment.is_null() ? nullptr : audio_capabilities_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->audio_capabilities.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null audio_capabilities in RemotingSinkMetadata struct");

    decltype(Traits::video_capabilities(input)) in_video_capabilities = Traits::video_capabilities(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->video_capabilities)::BaseType>
        video_capabilities_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& video_capabilities_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::RemotingSinkVideoCapability_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::RemotingSinkVideoCapability>>(
      in_video_capabilities,
      video_capabilities_fragment,
      &video_capabilities_validate_params);

    fragment->video_capabilities.Set(
        video_capabilities_fragment.is_null() ? nullptr : video_capabilities_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->video_capabilities.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null video_capabilities in RemotingSinkMetadata struct");

    decltype(Traits::friendly_name(input)) in_friendly_name = Traits::friendly_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->friendly_name)::BaseType> friendly_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_friendly_name,
      friendly_name_fragment);

    fragment->friendly_name.Set(
        friendly_name_fragment.is_null() ? nullptr : friendly_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->friendly_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null friendly_name in RemotingSinkMetadata struct");
  }

  static bool Deserialize(::media::mojom::internal::RemotingSinkMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::RemotingSinkMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media::mojom {

inline void RemotingSinkMetadataDataView::GetFeaturesDataView(
    mojo::ArrayDataView<RemotingSinkFeature>* output) {
  auto pointer = data_->features.Get();
  *output = mojo::ArrayDataView<RemotingSinkFeature>(pointer, message_);
}
inline void RemotingSinkMetadataDataView::GetAudioCapabilitiesDataView(
    mojo::ArrayDataView<RemotingSinkAudioCapability>* output) {
  auto pointer = data_->audio_capabilities.Get();
  *output = mojo::ArrayDataView<RemotingSinkAudioCapability>(pointer, message_);
}
inline void RemotingSinkMetadataDataView::GetVideoCapabilitiesDataView(
    mojo::ArrayDataView<RemotingSinkVideoCapability>* output) {
  auto pointer = data_->video_capabilities.Get();
  *output = mojo::ArrayDataView<RemotingSinkVideoCapability>(pointer, message_);
}
inline void RemotingSinkMetadataDataView::GetFriendlyNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->friendly_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // media::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::RemotingStopReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::RemotingStopReason value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::RemotingStartFailReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::RemotingStartFailReason value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::RemotingSinkFeature> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::RemotingSinkFeature value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::RemotingSinkAudioCapability> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::RemotingSinkAudioCapability value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::RemotingSinkVideoCapability> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::RemotingSinkVideoCapability value);
};

} // namespace perfetto

#endif  // MEDIA_MOJO_MOJOM_REMOTING_COMMON_MOJOM_SHARED_H_