// media/mojo/mojom/remoting.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/remoting.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/remoting.mojom-params-data.h"
#include "media/mojo/mojom/remoting.mojom-shared-message-ids.h"

#include "media/mojo/mojom/remoting.mojom-import-headers.h"
#include "media/mojo/mojom/remoting.mojom-test-utils.h"
#include "media/mojo/mojom/video_decoder_config_mojom_traits.h"


namespace media::mojom {
// The declaration includes the definition on other builds.

RemoterFactory::IPCStableHashFunction RemoterFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RemoterFactory>(message.name())) {
    case messages::RemoterFactory::kCreate: {
      return &RemoterFactory::Create_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RemoterFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RemoterFactory>(message.name())) {
      case messages::RemoterFactory::kCreate:
            return "Receive media::mojom::RemoterFactory::Create";
    }
  } else {
    switch (static_cast<messages::RemoterFactory>(message.name())) {
      case messages::RemoterFactory::kCreate:
            return "Receive reply media::mojom::RemoterFactory::Create";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RemoterFactory::Create_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1e77a697;  // IPCStableHash for media::mojom::RemoterFactory::Create
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

RemoterFactoryProxy::RemoterFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RemoterFactoryProxy::Create(
    ::mojo::PendingRemote<RemotingSource> in_source, ::mojo::PendingReceiver<Remoter> in_remoter) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::RemoterFactory::Create", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type ::mojo::PendingRemote<RemotingSource>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remoter"), in_remoter,
                        "<value of type ::mojo::PendingReceiver<Remoter>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoterFactory::kCreate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RemoterFactory_Create_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::RemotingSourceInterfaceBase>>(
    in_source,
    &params->source,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->source)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid source in RemoterFactory.Create request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::RemoterInterfaceBase>>(
    in_remoter,
    &params->remoter,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->remoter)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid remoter in RemoterFactory.Create request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoterFactory::Name_);
  message.set_method_name("Create");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool RemoterFactoryStubDispatch::Accept(
    RemoterFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RemoterFactory>(message->header()->name)) {
    case messages::RemoterFactory::kCreate: {
      DCHECK(message->is_serialized());
      internal::RemoterFactory_Create_Params_Data* params =
          reinterpret_cast<internal::RemoterFactory_Create_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoterFactory.0
      bool success = true;
      ::mojo::PendingRemote<RemotingSource> p_source{};
      ::mojo::PendingReceiver<Remoter> p_remoter{};
      RemoterFactory_Create_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_source =
            input_data_view.TakeSource<decltype(p_source)>();
      }
      if (success) {
        p_remoter =
            input_data_view.TakeRemoter<decltype(p_remoter)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoterFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Create(        
        std::move(p_source), 
        std::move(p_remoter));
      return true;
    }
  }
  return false;
}

// static
bool RemoterFactoryStubDispatch::AcceptWithResponder(
    RemoterFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RemoterFactory>(message->header()->name)) {
    case messages::RemoterFactory::kCreate: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRemoterFactoryValidationInfo[] = {
    { &internal::RemoterFactory_Create_Params_Data::Validate,
     nullptr /* no response */},
};

bool RemoterFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::RemoterFactory::Name_,
    kRemoterFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

RemotingDataStreamSender::IPCStableHashFunction RemotingDataStreamSender::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RemotingDataStreamSender>(message.name())) {
    case messages::RemotingDataStreamSender::kSendFrame: {
      return &RemotingDataStreamSender::SendFrame_Sym::IPCStableHash;
    }
    case messages::RemotingDataStreamSender::kCancelInFlightData: {
      return &RemotingDataStreamSender::CancelInFlightData_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RemotingDataStreamSender::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RemotingDataStreamSender>(message.name())) {
      case messages::RemotingDataStreamSender::kSendFrame:
            return "Receive media::mojom::RemotingDataStreamSender::SendFrame";
      case messages::RemotingDataStreamSender::kCancelInFlightData:
            return "Receive media::mojom::RemotingDataStreamSender::CancelInFlightData";
    }
  } else {
    switch (static_cast<messages::RemotingDataStreamSender>(message.name())) {
      case messages::RemotingDataStreamSender::kSendFrame:
            return "Receive reply media::mojom::RemotingDataStreamSender::SendFrame";
      case messages::RemotingDataStreamSender::kCancelInFlightData:
            return "Receive reply media::mojom::RemotingDataStreamSender::CancelInFlightData";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RemotingDataStreamSender::SendFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xac85f8f0;  // IPCStableHash for media::mojom::RemotingDataStreamSender::SendFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemotingDataStreamSender::CancelInFlightData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa3c94bf7;  // IPCStableHash for media::mojom::RemotingDataStreamSender::CancelInFlightData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class RemotingDataStreamSender_SendFrame_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RemotingDataStreamSender_SendFrame_ForwardToCallback(
      RemotingDataStreamSender::SendFrameCallback callback
      ) : callback_(std::move(callback)) {
  }

  RemotingDataStreamSender_SendFrame_ForwardToCallback(const RemotingDataStreamSender_SendFrame_ForwardToCallback&) = delete;
  RemotingDataStreamSender_SendFrame_ForwardToCallback& operator=(const RemotingDataStreamSender_SendFrame_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  RemotingDataStreamSender::SendFrameCallback callback_;
};

RemotingDataStreamSenderProxy::RemotingDataStreamSenderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RemotingDataStreamSenderProxy::SendFrame(
    ::media::mojom::DecoderBufferPtr in_frame, SendFrameCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::RemotingDataStreamSender::SendFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame"), in_frame,
                        "<value of type ::media::mojom::DecoderBufferPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemotingDataStreamSender::kSendFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RemotingDataStreamSender_SendFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->frame)>
      frame_fragment(params.message());
  frame_fragment.Claim(&params->frame);
  
  mojo::internal::Serialize<::media::mojom::DecoderBufferDataView>(
    in_frame,
    frame_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame in RemotingDataStreamSender.SendFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemotingDataStreamSender::Name_);
  message.set_method_name("SendFrame");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RemotingDataStreamSender_SendFrame_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void RemotingDataStreamSenderProxy::CancelInFlightData(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::RemotingDataStreamSender::CancelInFlightData");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemotingDataStreamSender::kCancelInFlightData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RemotingDataStreamSender_CancelInFlightData_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemotingDataStreamSender::Name_);
  message.set_method_name("CancelInFlightData");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class RemotingDataStreamSender_SendFrame_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static RemotingDataStreamSender::SendFrameCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<RemotingDataStreamSender_SendFrame_ProxyToResponder> proxy(
        new RemotingDataStreamSender_SendFrame_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&RemotingDataStreamSender_SendFrame_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RemotingDataStreamSender_SendFrame_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  RemotingDataStreamSender_SendFrame_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "RemotingDataStreamSender::SendFrameCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool RemotingDataStreamSender_SendFrame_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RemotingDataStreamSender_SendFrame_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RemotingDataStreamSender_SendFrame_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for RemotingDataStreamSender.0
  bool success = true;
  RemotingDataStreamSender_SendFrame_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RemotingDataStreamSender::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void RemotingDataStreamSender_SendFrame_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply media::mojom::RemotingDataStreamSender::SendFrame");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemotingDataStreamSender::kSendFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RemotingDataStreamSender_SendFrame_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemotingDataStreamSender::Name_);
  message.set_method_name("SendFrame");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool RemotingDataStreamSenderStubDispatch::Accept(
    RemotingDataStreamSender* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RemotingDataStreamSender>(message->header()->name)) {
    case messages::RemotingDataStreamSender::kSendFrame: {
      break;
    }
    case messages::RemotingDataStreamSender::kCancelInFlightData: {
      DCHECK(message->is_serialized());
      internal::RemotingDataStreamSender_CancelInFlightData_Params_Data* params =
          reinterpret_cast<internal::RemotingDataStreamSender_CancelInFlightData_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemotingDataStreamSender.1
      bool success = true;
      RemotingDataStreamSender_CancelInFlightData_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemotingDataStreamSender::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelInFlightData(        );
      return true;
    }
  }
  return false;
}

// static
bool RemotingDataStreamSenderStubDispatch::AcceptWithResponder(
    RemotingDataStreamSender* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RemotingDataStreamSender>(message->header()->name)) {
    case messages::RemotingDataStreamSender::kSendFrame: {
      internal::RemotingDataStreamSender_SendFrame_Params_Data* params =
          reinterpret_cast<
              internal::RemotingDataStreamSender_SendFrame_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for RemotingDataStreamSender.0
      bool success = true;
      ::media::mojom::DecoderBufferPtr p_frame{};
      RemotingDataStreamSender_SendFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrame(&p_frame))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemotingDataStreamSender::Name_, 0, false);
        return false;
      }
      auto callback =
          RemotingDataStreamSender_SendFrame_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendFrame(        
        std::move(p_frame), std::move(callback));
      return true;
    }
    case messages::RemotingDataStreamSender::kCancelInFlightData: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRemotingDataStreamSenderValidationInfo[] = {
    { &internal::RemotingDataStreamSender_SendFrame_Params_Data::Validate,
     &internal::RemotingDataStreamSender_SendFrame_ResponseParams_Data::Validate},
    { &internal::RemotingDataStreamSender_CancelInFlightData_Params_Data::Validate,
     nullptr /* no response */},
};

bool RemotingDataStreamSenderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::RemotingDataStreamSender::Name_,
    kRemotingDataStreamSenderValidationInfo);
}

bool RemotingDataStreamSenderResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::media::mojom::RemotingDataStreamSender::Name_,
    kRemotingDataStreamSenderValidationInfo);
}
// The declaration includes the definition on other builds.

Remoter::IPCStableHashFunction Remoter::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Remoter>(message.name())) {
    case messages::Remoter::kStart: {
      return &Remoter::Start_Sym::IPCStableHash;
    }
    case messages::Remoter::kStartWithPermissionAlreadyGranted: {
      return &Remoter::StartWithPermissionAlreadyGranted_Sym::IPCStableHash;
    }
    case messages::Remoter::kStartDataStreams: {
      return &Remoter::StartDataStreams_Sym::IPCStableHash;
    }
    case messages::Remoter::kStop: {
      return &Remoter::Stop_Sym::IPCStableHash;
    }
    case messages::Remoter::kSendMessageToSink: {
      return &Remoter::SendMessageToSink_Sym::IPCStableHash;
    }
    case messages::Remoter::kEstimateTransmissionCapacity: {
      return &Remoter::EstimateTransmissionCapacity_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Remoter::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Remoter>(message.name())) {
      case messages::Remoter::kStart:
            return "Receive media::mojom::Remoter::Start";
      case messages::Remoter::kStartWithPermissionAlreadyGranted:
            return "Receive media::mojom::Remoter::StartWithPermissionAlreadyGranted";
      case messages::Remoter::kStartDataStreams:
            return "Receive media::mojom::Remoter::StartDataStreams";
      case messages::Remoter::kStop:
            return "Receive media::mojom::Remoter::Stop";
      case messages::Remoter::kSendMessageToSink:
            return "Receive media::mojom::Remoter::SendMessageToSink";
      case messages::Remoter::kEstimateTransmissionCapacity:
            return "Receive media::mojom::Remoter::EstimateTransmissionCapacity";
    }
  } else {
    switch (static_cast<messages::Remoter>(message.name())) {
      case messages::Remoter::kStart:
            return "Receive reply media::mojom::Remoter::Start";
      case messages::Remoter::kStartWithPermissionAlreadyGranted:
            return "Receive reply media::mojom::Remoter::StartWithPermissionAlreadyGranted";
      case messages::Remoter::kStartDataStreams:
            return "Receive reply media::mojom::Remoter::StartDataStreams";
      case messages::Remoter::kStop:
            return "Receive reply media::mojom::Remoter::Stop";
      case messages::Remoter::kSendMessageToSink:
            return "Receive reply media::mojom::Remoter::SendMessageToSink";
      case messages::Remoter::kEstimateTransmissionCapacity:
            return "Receive reply media::mojom::Remoter::EstimateTransmissionCapacity";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Remoter::Start_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc9e383be;  // IPCStableHash for media::mojom::Remoter::Start
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Remoter::StartWithPermissionAlreadyGranted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa093cac2;  // IPCStableHash for media::mojom::Remoter::StartWithPermissionAlreadyGranted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Remoter::StartDataStreams_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3109af3c;  // IPCStableHash for media::mojom::Remoter::StartDataStreams
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Remoter::Stop_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7957e8b7;  // IPCStableHash for media::mojom::Remoter::Stop
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Remoter::SendMessageToSink_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x591b7447;  // IPCStableHash for media::mojom::Remoter::SendMessageToSink
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Remoter::EstimateTransmissionCapacity_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x14f0de7f;  // IPCStableHash for media::mojom::Remoter::EstimateTransmissionCapacity
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class Remoter_EstimateTransmissionCapacity_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Remoter_EstimateTransmissionCapacity_ForwardToCallback(
      Remoter::EstimateTransmissionCapacityCallback callback
      ) : callback_(std::move(callback)) {
  }

  Remoter_EstimateTransmissionCapacity_ForwardToCallback(const Remoter_EstimateTransmissionCapacity_ForwardToCallback&) = delete;
  Remoter_EstimateTransmissionCapacity_ForwardToCallback& operator=(const Remoter_EstimateTransmissionCapacity_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Remoter::EstimateTransmissionCapacityCallback callback_;
};

RemoterProxy::RemoterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RemoterProxy::Start(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::Remoter::Start");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Remoter::kStart), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Remoter_Start_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Remoter::Name_);
  message.set_method_name("Start");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoterProxy::StartWithPermissionAlreadyGranted(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::Remoter::StartWithPermissionAlreadyGranted");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Remoter::kStartWithPermissionAlreadyGranted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Remoter_StartWithPermissionAlreadyGranted_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Remoter::Name_);
  message.set_method_name("StartWithPermissionAlreadyGranted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoterProxy::StartDataStreams(
    ::mojo::ScopedDataPipeConsumerHandle in_audio_pipe, ::mojo::ScopedDataPipeConsumerHandle in_video_pipe, ::mojo::PendingReceiver<RemotingDataStreamSender> in_audio_sender, ::mojo::PendingReceiver<RemotingDataStreamSender> in_video_sender) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::Remoter::StartDataStreams", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio_pipe"), in_audio_pipe,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("video_pipe"), in_video_pipe,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio_sender"), in_audio_sender,
                        "<value of type ::mojo::PendingReceiver<RemotingDataStreamSender>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("video_sender"), in_video_sender,
                        "<value of type ::mojo::PendingReceiver<RemotingDataStreamSender>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Remoter::kStartDataStreams), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Remoter_StartDataStreams_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
    in_audio_pipe,
    &params->audio_pipe,
    &params.message());

  
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
    in_video_pipe,
    &params->video_pipe,
    &params.message());

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::RemotingDataStreamSenderInterfaceBase>>(
    in_audio_sender,
    &params->audio_sender,
    &params.message());

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::RemotingDataStreamSenderInterfaceBase>>(
    in_video_sender,
    &params->video_sender,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Remoter::Name_);
  message.set_method_name("StartDataStreams");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoterProxy::Stop(
    ::media::mojom::RemotingStopReason in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::Remoter::Stop", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type ::media::mojom::RemotingStopReason>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Remoter::kStop), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Remoter_Stop_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::RemotingStopReason>(
    in_reason,
    &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Remoter::Name_);
  message.set_method_name("Stop");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoterProxy::SendMessageToSink(
    const std::vector<uint8_t>& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::Remoter::SendMessageToSink", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Remoter::kSendMessageToSink), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Remoter_SendMessageToSink_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType>
      message_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_message,
    message_fragment,
    &message_validate_params);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in Remoter.SendMessageToSink request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Remoter::Name_);
  message.set_method_name("SendMessageToSink");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoterProxy::EstimateTransmissionCapacity(
    EstimateTransmissionCapacityCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::Remoter::EstimateTransmissionCapacity");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Remoter::kEstimateTransmissionCapacity), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Remoter_EstimateTransmissionCapacity_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Remoter::Name_);
  message.set_method_name("EstimateTransmissionCapacity");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Remoter_EstimateTransmissionCapacity_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class Remoter_EstimateTransmissionCapacity_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Remoter::EstimateTransmissionCapacityCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Remoter_EstimateTransmissionCapacity_ProxyToResponder> proxy(
        new Remoter_EstimateTransmissionCapacity_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Remoter_EstimateTransmissionCapacity_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Remoter_EstimateTransmissionCapacity_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Remoter_EstimateTransmissionCapacity_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Remoter::EstimateTransmissionCapacityCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      double in_rate);
};

bool Remoter_EstimateTransmissionCapacity_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Remoter_EstimateTransmissionCapacity_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Remoter_EstimateTransmissionCapacity_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Remoter.5
  bool success = true;
  double p_rate{};
  Remoter_EstimateTransmissionCapacity_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_rate = input_data_view.rate();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Remoter::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_rate));
  }
  return true;
}

void Remoter_EstimateTransmissionCapacity_ProxyToResponder::Run(
    double in_rate) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::Remoter::EstimateTransmissionCapacity", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rate"), in_rate,
                        "<value of type double>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Remoter::kEstimateTransmissionCapacity), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Remoter_EstimateTransmissionCapacity_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->rate = in_rate;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Remoter::Name_);
  message.set_method_name("EstimateTransmissionCapacity");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool RemoterStubDispatch::Accept(
    Remoter* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Remoter>(message->header()->name)) {
    case messages::Remoter::kStart: {
      DCHECK(message->is_serialized());
      internal::Remoter_Start_Params_Data* params =
          reinterpret_cast<internal::Remoter_Start_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Remoter.0
      bool success = true;
      Remoter_Start_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Remoter::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Start(        );
      return true;
    }
    case messages::Remoter::kStartWithPermissionAlreadyGranted: {
      DCHECK(message->is_serialized());
      internal::Remoter_StartWithPermissionAlreadyGranted_Params_Data* params =
          reinterpret_cast<internal::Remoter_StartWithPermissionAlreadyGranted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Remoter.1
      bool success = true;
      Remoter_StartWithPermissionAlreadyGranted_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Remoter::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartWithPermissionAlreadyGranted(        );
      return true;
    }
    case messages::Remoter::kStartDataStreams: {
      DCHECK(message->is_serialized());
      internal::Remoter_StartDataStreams_Params_Data* params =
          reinterpret_cast<internal::Remoter_StartDataStreams_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Remoter.2
      bool success = true;
      ::mojo::ScopedDataPipeConsumerHandle p_audio_pipe{};
      ::mojo::ScopedDataPipeConsumerHandle p_video_pipe{};
      ::mojo::PendingReceiver<RemotingDataStreamSender> p_audio_sender{};
      ::mojo::PendingReceiver<RemotingDataStreamSender> p_video_sender{};
      Remoter_StartDataStreams_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_audio_pipe = input_data_view.TakeAudioPipe();
      if (success)
        p_video_pipe = input_data_view.TakeVideoPipe();
      if (success) {
        p_audio_sender =
            input_data_view.TakeAudioSender<decltype(p_audio_sender)>();
      }
      if (success) {
        p_video_sender =
            input_data_view.TakeVideoSender<decltype(p_video_sender)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Remoter::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartDataStreams(        
        std::move(p_audio_pipe), 
        std::move(p_video_pipe), 
        std::move(p_audio_sender), 
        std::move(p_video_sender));
      return true;
    }
    case messages::Remoter::kStop: {
      DCHECK(message->is_serialized());
      internal::Remoter_Stop_Params_Data* params =
          reinterpret_cast<internal::Remoter_Stop_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Remoter.3
      bool success = true;
      ::media::mojom::RemotingStopReason p_reason{};
      Remoter_Stop_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Remoter::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Stop(        
        std::move(p_reason));
      return true;
    }
    case messages::Remoter::kSendMessageToSink: {
      DCHECK(message->is_serialized());
      internal::Remoter_SendMessageToSink_Params_Data* params =
          reinterpret_cast<internal::Remoter_SendMessageToSink_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Remoter.4
      bool success = true;
      std::vector<uint8_t> p_message{};
      Remoter_SendMessageToSink_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Remoter::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendMessageToSink(        
        std::move(p_message));
      return true;
    }
    case messages::Remoter::kEstimateTransmissionCapacity: {
      break;
    }
  }
  return false;
}

// static
bool RemoterStubDispatch::AcceptWithResponder(
    Remoter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Remoter>(message->header()->name)) {
    case messages::Remoter::kStart: {
      break;
    }
    case messages::Remoter::kStartWithPermissionAlreadyGranted: {
      break;
    }
    case messages::Remoter::kStartDataStreams: {
      break;
    }
    case messages::Remoter::kStop: {
      break;
    }
    case messages::Remoter::kSendMessageToSink: {
      break;
    }
    case messages::Remoter::kEstimateTransmissionCapacity: {
      internal::Remoter_EstimateTransmissionCapacity_Params_Data* params =
          reinterpret_cast<
              internal::Remoter_EstimateTransmissionCapacity_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Remoter.5
      bool success = true;
      Remoter_EstimateTransmissionCapacity_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Remoter::Name_, 5, false);
        return false;
      }
      auto callback =
          Remoter_EstimateTransmissionCapacity_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EstimateTransmissionCapacity(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRemoterValidationInfo[] = {
    { &internal::Remoter_Start_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Remoter_StartWithPermissionAlreadyGranted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Remoter_StartDataStreams_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Remoter_Stop_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Remoter_SendMessageToSink_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Remoter_EstimateTransmissionCapacity_Params_Data::Validate,
     &internal::Remoter_EstimateTransmissionCapacity_ResponseParams_Data::Validate},
};

bool RemoterRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::Remoter::Name_,
    kRemoterValidationInfo);
}

bool RemoterResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::media::mojom::Remoter::Name_,
    kRemoterValidationInfo);
}
// The declaration includes the definition on other builds.

RemotingSource::IPCStableHashFunction RemotingSource::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RemotingSource>(message.name())) {
    case messages::RemotingSource::kOnSinkAvailable: {
      return &RemotingSource::OnSinkAvailable_Sym::IPCStableHash;
    }
    case messages::RemotingSource::kOnSinkGone: {
      return &RemotingSource::OnSinkGone_Sym::IPCStableHash;
    }
    case messages::RemotingSource::kOnStarted: {
      return &RemotingSource::OnStarted_Sym::IPCStableHash;
    }
    case messages::RemotingSource::kOnStartFailed: {
      return &RemotingSource::OnStartFailed_Sym::IPCStableHash;
    }
    case messages::RemotingSource::kOnMessageFromSink: {
      return &RemotingSource::OnMessageFromSink_Sym::IPCStableHash;
    }
    case messages::RemotingSource::kOnStopped: {
      return &RemotingSource::OnStopped_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RemotingSource::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RemotingSource>(message.name())) {
      case messages::RemotingSource::kOnSinkAvailable:
            return "Receive media::mojom::RemotingSource::OnSinkAvailable";
      case messages::RemotingSource::kOnSinkGone:
            return "Receive media::mojom::RemotingSource::OnSinkGone";
      case messages::RemotingSource::kOnStarted:
            return "Receive media::mojom::RemotingSource::OnStarted";
      case messages::RemotingSource::kOnStartFailed:
            return "Receive media::mojom::RemotingSource::OnStartFailed";
      case messages::RemotingSource::kOnMessageFromSink:
            return "Receive media::mojom::RemotingSource::OnMessageFromSink";
      case messages::RemotingSource::kOnStopped:
            return "Receive media::mojom::RemotingSource::OnStopped";
    }
  } else {
    switch (static_cast<messages::RemotingSource>(message.name())) {
      case messages::RemotingSource::kOnSinkAvailable:
            return "Receive reply media::mojom::RemotingSource::OnSinkAvailable";
      case messages::RemotingSource::kOnSinkGone:
            return "Receive reply media::mojom::RemotingSource::OnSinkGone";
      case messages::RemotingSource::kOnStarted:
            return "Receive reply media::mojom::RemotingSource::OnStarted";
      case messages::RemotingSource::kOnStartFailed:
            return "Receive reply media::mojom::RemotingSource::OnStartFailed";
      case messages::RemotingSource::kOnMessageFromSink:
            return "Receive reply media::mojom::RemotingSource::OnMessageFromSink";
      case messages::RemotingSource::kOnStopped:
            return "Receive reply media::mojom::RemotingSource::OnStopped";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RemotingSource::OnSinkAvailable_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf3661ef5;  // IPCStableHash for media::mojom::RemotingSource::OnSinkAvailable
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemotingSource::OnSinkGone_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa66081c6;  // IPCStableHash for media::mojom::RemotingSource::OnSinkGone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemotingSource::OnStarted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb6b461b4;  // IPCStableHash for media::mojom::RemotingSource::OnStarted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemotingSource::OnStartFailed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x99c452d4;  // IPCStableHash for media::mojom::RemotingSource::OnStartFailed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemotingSource::OnMessageFromSink_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc5ab9c2f;  // IPCStableHash for media::mojom::RemotingSource::OnMessageFromSink
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemotingSource::OnStopped_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2078baea;  // IPCStableHash for media::mojom::RemotingSource::OnStopped
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

RemotingSourceProxy::RemotingSourceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RemotingSourceProxy::OnSinkAvailable(
    ::media::mojom::RemotingSinkMetadataPtr in_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::RemotingSource::OnSinkAvailable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metadata"), in_metadata,
                        "<value of type ::media::mojom::RemotingSinkMetadataPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemotingSource::kOnSinkAvailable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RemotingSource_OnSinkAvailable_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->metadata)::BaseType> metadata_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::RemotingSinkMetadataDataView>(
    in_metadata,
    metadata_fragment);

  params->metadata.Set(
      metadata_fragment.is_null() ? nullptr : metadata_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->metadata.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null metadata in RemotingSource.OnSinkAvailable request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemotingSource::Name_);
  message.set_method_name("OnSinkAvailable");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemotingSourceProxy::OnSinkGone(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::RemotingSource::OnSinkGone");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemotingSource::kOnSinkGone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RemotingSource_OnSinkGone_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemotingSource::Name_);
  message.set_method_name("OnSinkGone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemotingSourceProxy::OnStarted(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::RemotingSource::OnStarted");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemotingSource::kOnStarted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RemotingSource_OnStarted_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemotingSource::Name_);
  message.set_method_name("OnStarted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemotingSourceProxy::OnStartFailed(
    ::media::mojom::RemotingStartFailReason in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::RemotingSource::OnStartFailed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type ::media::mojom::RemotingStartFailReason>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemotingSource::kOnStartFailed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RemotingSource_OnStartFailed_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::RemotingStartFailReason>(
    in_reason,
    &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemotingSource::Name_);
  message.set_method_name("OnStartFailed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemotingSourceProxy::OnMessageFromSink(
    const std::vector<uint8_t>& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::RemotingSource::OnMessageFromSink", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemotingSource::kOnMessageFromSink), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RemotingSource_OnMessageFromSink_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType>
      message_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_message,
    message_fragment,
    &message_validate_params);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in RemotingSource.OnMessageFromSink request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemotingSource::Name_);
  message.set_method_name("OnMessageFromSink");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemotingSourceProxy::OnStopped(
    ::media::mojom::RemotingStopReason in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::RemotingSource::OnStopped", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type ::media::mojom::RemotingStopReason>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemotingSource::kOnStopped), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RemotingSource_OnStopped_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::RemotingStopReason>(
    in_reason,
    &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemotingSource::Name_);
  message.set_method_name("OnStopped");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool RemotingSourceStubDispatch::Accept(
    RemotingSource* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RemotingSource>(message->header()->name)) {
    case messages::RemotingSource::kOnSinkAvailable: {
      DCHECK(message->is_serialized());
      internal::RemotingSource_OnSinkAvailable_Params_Data* params =
          reinterpret_cast<internal::RemotingSource_OnSinkAvailable_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemotingSource.0
      bool success = true;
      ::media::mojom::RemotingSinkMetadataPtr p_metadata{};
      RemotingSource_OnSinkAvailable_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMetadata(&p_metadata))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemotingSource::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSinkAvailable(        
        std::move(p_metadata));
      return true;
    }
    case messages::RemotingSource::kOnSinkGone: {
      DCHECK(message->is_serialized());
      internal::RemotingSource_OnSinkGone_Params_Data* params =
          reinterpret_cast<internal::RemotingSource_OnSinkGone_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemotingSource.1
      bool success = true;
      RemotingSource_OnSinkGone_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemotingSource::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSinkGone(        );
      return true;
    }
    case messages::RemotingSource::kOnStarted: {
      DCHECK(message->is_serialized());
      internal::RemotingSource_OnStarted_Params_Data* params =
          reinterpret_cast<internal::RemotingSource_OnStarted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemotingSource.2
      bool success = true;
      RemotingSource_OnStarted_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemotingSource::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStarted(        );
      return true;
    }
    case messages::RemotingSource::kOnStartFailed: {
      DCHECK(message->is_serialized());
      internal::RemotingSource_OnStartFailed_Params_Data* params =
          reinterpret_cast<internal::RemotingSource_OnStartFailed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemotingSource.3
      bool success = true;
      ::media::mojom::RemotingStartFailReason p_reason{};
      RemotingSource_OnStartFailed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemotingSource::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStartFailed(        
        std::move(p_reason));
      return true;
    }
    case messages::RemotingSource::kOnMessageFromSink: {
      DCHECK(message->is_serialized());
      internal::RemotingSource_OnMessageFromSink_Params_Data* params =
          reinterpret_cast<internal::RemotingSource_OnMessageFromSink_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemotingSource.4
      bool success = true;
      std::vector<uint8_t> p_message{};
      RemotingSource_OnMessageFromSink_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemotingSource::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMessageFromSink(        
        std::move(p_message));
      return true;
    }
    case messages::RemotingSource::kOnStopped: {
      DCHECK(message->is_serialized());
      internal::RemotingSource_OnStopped_Params_Data* params =
          reinterpret_cast<internal::RemotingSource_OnStopped_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemotingSource.5
      bool success = true;
      ::media::mojom::RemotingStopReason p_reason{};
      RemotingSource_OnStopped_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemotingSource::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStopped(        
        std::move(p_reason));
      return true;
    }
  }
  return false;
}

// static
bool RemotingSourceStubDispatch::AcceptWithResponder(
    RemotingSource* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RemotingSource>(message->header()->name)) {
    case messages::RemotingSource::kOnSinkAvailable: {
      break;
    }
    case messages::RemotingSource::kOnSinkGone: {
      break;
    }
    case messages::RemotingSource::kOnStarted: {
      break;
    }
    case messages::RemotingSource::kOnStartFailed: {
      break;
    }
    case messages::RemotingSource::kOnMessageFromSink: {
      break;
    }
    case messages::RemotingSource::kOnStopped: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRemotingSourceValidationInfo[] = {
    { &internal::RemotingSource_OnSinkAvailable_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemotingSource_OnSinkGone_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemotingSource_OnStarted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemotingSource_OnStartFailed_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemotingSource_OnMessageFromSink_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemotingSource_OnStopped_Params_Data::Validate,
     nullptr /* no response */},
};

bool RemotingSourceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::RemotingSource::Name_,
    kRemotingSourceValidationInfo);
}

// The declaration includes the definition on other builds.

Remotee::IPCStableHashFunction Remotee::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Remotee>(message.name())) {
    case messages::Remotee::kOnRemotingSinkReady: {
      return &Remotee::OnRemotingSinkReady_Sym::IPCStableHash;
    }
    case messages::Remotee::kSendMessageToSource: {
      return &Remotee::SendMessageToSource_Sym::IPCStableHash;
    }
    case messages::Remotee::kStartDataStreams: {
      return &Remotee::StartDataStreams_Sym::IPCStableHash;
    }
    case messages::Remotee::kOnFlushUntil: {
      return &Remotee::OnFlushUntil_Sym::IPCStableHash;
    }
    case messages::Remotee::kOnVideoNaturalSizeChange: {
      return &Remotee::OnVideoNaturalSizeChange_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Remotee::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Remotee>(message.name())) {
      case messages::Remotee::kOnRemotingSinkReady:
            return "Receive media::mojom::Remotee::OnRemotingSinkReady";
      case messages::Remotee::kSendMessageToSource:
            return "Receive media::mojom::Remotee::SendMessageToSource";
      case messages::Remotee::kStartDataStreams:
            return "Receive media::mojom::Remotee::StartDataStreams";
      case messages::Remotee::kOnFlushUntil:
            return "Receive media::mojom::Remotee::OnFlushUntil";
      case messages::Remotee::kOnVideoNaturalSizeChange:
            return "Receive media::mojom::Remotee::OnVideoNaturalSizeChange";
    }
  } else {
    switch (static_cast<messages::Remotee>(message.name())) {
      case messages::Remotee::kOnRemotingSinkReady:
            return "Receive reply media::mojom::Remotee::OnRemotingSinkReady";
      case messages::Remotee::kSendMessageToSource:
            return "Receive reply media::mojom::Remotee::SendMessageToSource";
      case messages::Remotee::kStartDataStreams:
            return "Receive reply media::mojom::Remotee::StartDataStreams";
      case messages::Remotee::kOnFlushUntil:
            return "Receive reply media::mojom::Remotee::OnFlushUntil";
      case messages::Remotee::kOnVideoNaturalSizeChange:
            return "Receive reply media::mojom::Remotee::OnVideoNaturalSizeChange";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Remotee::OnRemotingSinkReady_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe92fbfd0;  // IPCStableHash for media::mojom::Remotee::OnRemotingSinkReady
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Remotee::SendMessageToSource_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xddf5c792;  // IPCStableHash for media::mojom::Remotee::SendMessageToSource
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Remotee::StartDataStreams_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa8cd5074;  // IPCStableHash for media::mojom::Remotee::StartDataStreams
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Remotee::OnFlushUntil_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x692a6a42;  // IPCStableHash for media::mojom::Remotee::OnFlushUntil
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Remotee::OnVideoNaturalSizeChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6781233e;  // IPCStableHash for media::mojom::Remotee::OnVideoNaturalSizeChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

RemoteeProxy::RemoteeProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RemoteeProxy::OnRemotingSinkReady(
    ::mojo::PendingRemote<RemotingSink> in_sink) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::Remotee::OnRemotingSinkReady", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sink"), in_sink,
                        "<value of type ::mojo::PendingRemote<RemotingSink>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Remotee::kOnRemotingSinkReady), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Remotee_OnRemotingSinkReady_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::RemotingSinkInterfaceBase>>(
    in_sink,
    &params->sink,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->sink)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid sink in Remotee.OnRemotingSinkReady request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Remotee::Name_);
  message.set_method_name("OnRemotingSinkReady");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteeProxy::SendMessageToSource(
    const std::vector<uint8_t>& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::Remotee::SendMessageToSource", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Remotee::kSendMessageToSource), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Remotee_SendMessageToSource_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType>
      message_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_message,
    message_fragment,
    &message_validate_params);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in Remotee.SendMessageToSource request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Remotee::Name_);
  message.set_method_name("SendMessageToSource");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteeProxy::StartDataStreams(
    ::mojo::PendingRemote<RemotingDataStreamReceiver> in_audio_stream, ::mojo::PendingRemote<RemotingDataStreamReceiver> in_video_stream) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::Remotee::StartDataStreams", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio_stream"), in_audio_stream,
                        "<value of type ::mojo::PendingRemote<RemotingDataStreamReceiver>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("video_stream"), in_video_stream,
                        "<value of type ::mojo::PendingRemote<RemotingDataStreamReceiver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Remotee::kStartDataStreams), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Remotee_StartDataStreams_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::RemotingDataStreamReceiverInterfaceBase>>(
    in_audio_stream,
    &params->audio_stream,
    &params.message());

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::RemotingDataStreamReceiverInterfaceBase>>(
    in_video_stream,
    &params->video_stream,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Remotee::Name_);
  message.set_method_name("StartDataStreams");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteeProxy::OnFlushUntil(
    uint32_t in_audio_frame_count, uint32_t in_video_frame_count) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::Remotee::OnFlushUntil", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio_frame_count"), in_audio_frame_count,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("video_frame_count"), in_video_frame_count,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Remotee::kOnFlushUntil), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Remotee_OnFlushUntil_Params_Data> params(
          message);
  params.Allocate();

  params->audio_frame_count = in_audio_frame_count;

  params->video_frame_count = in_video_frame_count;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Remotee::Name_);
  message.set_method_name("OnFlushUntil");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteeProxy::OnVideoNaturalSizeChange(
    const ::gfx::Size& in_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::Remotee::OnVideoNaturalSizeChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size,
                        "<value of type const ::gfx::Size&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Remotee::kOnVideoNaturalSizeChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Remotee_OnVideoNaturalSizeChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->size)::BaseType> size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_size,
    size_fragment);

  params->size.Set(
      size_fragment.is_null() ? nullptr : size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null size in Remotee.OnVideoNaturalSizeChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Remotee::Name_);
  message.set_method_name("OnVideoNaturalSizeChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool RemoteeStubDispatch::Accept(
    Remotee* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Remotee>(message->header()->name)) {
    case messages::Remotee::kOnRemotingSinkReady: {
      DCHECK(message->is_serialized());
      internal::Remotee_OnRemotingSinkReady_Params_Data* params =
          reinterpret_cast<internal::Remotee_OnRemotingSinkReady_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Remotee.0
      bool success = true;
      ::mojo::PendingRemote<RemotingSink> p_sink{};
      Remotee_OnRemotingSinkReady_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_sink =
            input_data_view.TakeSink<decltype(p_sink)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Remotee::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnRemotingSinkReady(        
        std::move(p_sink));
      return true;
    }
    case messages::Remotee::kSendMessageToSource: {
      DCHECK(message->is_serialized());
      internal::Remotee_SendMessageToSource_Params_Data* params =
          reinterpret_cast<internal::Remotee_SendMessageToSource_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Remotee.1
      bool success = true;
      std::vector<uint8_t> p_message{};
      Remotee_SendMessageToSource_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Remotee::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendMessageToSource(        
        std::move(p_message));
      return true;
    }
    case messages::Remotee::kStartDataStreams: {
      DCHECK(message->is_serialized());
      internal::Remotee_StartDataStreams_Params_Data* params =
          reinterpret_cast<internal::Remotee_StartDataStreams_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Remotee.2
      bool success = true;
      ::mojo::PendingRemote<RemotingDataStreamReceiver> p_audio_stream{};
      ::mojo::PendingRemote<RemotingDataStreamReceiver> p_video_stream{};
      Remotee_StartDataStreams_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_audio_stream =
            input_data_view.TakeAudioStream<decltype(p_audio_stream)>();
      }
      if (success) {
        p_video_stream =
            input_data_view.TakeVideoStream<decltype(p_video_stream)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Remotee::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartDataStreams(        
        std::move(p_audio_stream), 
        std::move(p_video_stream));
      return true;
    }
    case messages::Remotee::kOnFlushUntil: {
      DCHECK(message->is_serialized());
      internal::Remotee_OnFlushUntil_Params_Data* params =
          reinterpret_cast<internal::Remotee_OnFlushUntil_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Remotee.3
      bool success = true;
      uint32_t p_audio_frame_count{};
      uint32_t p_video_frame_count{};
      Remotee_OnFlushUntil_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_audio_frame_count = input_data_view.audio_frame_count();
      if (success)
        p_video_frame_count = input_data_view.video_frame_count();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Remotee::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFlushUntil(        
        std::move(p_audio_frame_count), 
        std::move(p_video_frame_count));
      return true;
    }
    case messages::Remotee::kOnVideoNaturalSizeChange: {
      DCHECK(message->is_serialized());
      internal::Remotee_OnVideoNaturalSizeChange_Params_Data* params =
          reinterpret_cast<internal::Remotee_OnVideoNaturalSizeChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Remotee.4
      bool success = true;
      ::gfx::Size p_size{};
      Remotee_OnVideoNaturalSizeChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSize(&p_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Remotee::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnVideoNaturalSizeChange(        
        std::move(p_size));
      return true;
    }
  }
  return false;
}

// static
bool RemoteeStubDispatch::AcceptWithResponder(
    Remotee* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Remotee>(message->header()->name)) {
    case messages::Remotee::kOnRemotingSinkReady: {
      break;
    }
    case messages::Remotee::kSendMessageToSource: {
      break;
    }
    case messages::Remotee::kStartDataStreams: {
      break;
    }
    case messages::Remotee::kOnFlushUntil: {
      break;
    }
    case messages::Remotee::kOnVideoNaturalSizeChange: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRemoteeValidationInfo[] = {
    { &internal::Remotee_OnRemotingSinkReady_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Remotee_SendMessageToSource_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Remotee_StartDataStreams_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Remotee_OnFlushUntil_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Remotee_OnVideoNaturalSizeChange_Params_Data::Validate,
     nullptr /* no response */},
};

bool RemoteeRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::Remotee::Name_,
    kRemoteeValidationInfo);
}

// The declaration includes the definition on other builds.

RemotingSink::IPCStableHashFunction RemotingSink::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RemotingSink>(message.name())) {
    case messages::RemotingSink::kOnMessageFromSource: {
      return &RemotingSink::OnMessageFromSource_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RemotingSink::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RemotingSink>(message.name())) {
      case messages::RemotingSink::kOnMessageFromSource:
            return "Receive media::mojom::RemotingSink::OnMessageFromSource";
    }
  } else {
    switch (static_cast<messages::RemotingSink>(message.name())) {
      case messages::RemotingSink::kOnMessageFromSource:
            return "Receive reply media::mojom::RemotingSink::OnMessageFromSource";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RemotingSink::OnMessageFromSource_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf37087ab;  // IPCStableHash for media::mojom::RemotingSink::OnMessageFromSource
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

RemotingSinkProxy::RemotingSinkProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RemotingSinkProxy::OnMessageFromSource(
    const std::vector<uint8_t>& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::RemotingSink::OnMessageFromSource", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemotingSink::kOnMessageFromSource), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RemotingSink_OnMessageFromSource_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType>
      message_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_message,
    message_fragment,
    &message_validate_params);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in RemotingSink.OnMessageFromSource request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemotingSink::Name_);
  message.set_method_name("OnMessageFromSource");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool RemotingSinkStubDispatch::Accept(
    RemotingSink* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RemotingSink>(message->header()->name)) {
    case messages::RemotingSink::kOnMessageFromSource: {
      DCHECK(message->is_serialized());
      internal::RemotingSink_OnMessageFromSource_Params_Data* params =
          reinterpret_cast<internal::RemotingSink_OnMessageFromSource_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemotingSink.0
      bool success = true;
      std::vector<uint8_t> p_message{};
      RemotingSink_OnMessageFromSource_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemotingSink::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMessageFromSource(        
        std::move(p_message));
      return true;
    }
  }
  return false;
}

// static
bool RemotingSinkStubDispatch::AcceptWithResponder(
    RemotingSink* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RemotingSink>(message->header()->name)) {
    case messages::RemotingSink::kOnMessageFromSource: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRemotingSinkValidationInfo[] = {
    { &internal::RemotingSink_OnMessageFromSource_Params_Data::Validate,
     nullptr /* no response */},
};

bool RemotingSinkRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::RemotingSink::Name_,
    kRemotingSinkValidationInfo);
}

// The declaration includes the definition on other builds.

RemotingDataStreamReceiver::IPCStableHashFunction RemotingDataStreamReceiver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RemotingDataStreamReceiver>(message.name())) {
    case messages::RemotingDataStreamReceiver::kInitializeDataPipe: {
      return &RemotingDataStreamReceiver::InitializeDataPipe_Sym::IPCStableHash;
    }
    case messages::RemotingDataStreamReceiver::kReceiveFrame: {
      return &RemotingDataStreamReceiver::ReceiveFrame_Sym::IPCStableHash;
    }
    case messages::RemotingDataStreamReceiver::kFlushUntil: {
      return &RemotingDataStreamReceiver::FlushUntil_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RemotingDataStreamReceiver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RemotingDataStreamReceiver>(message.name())) {
      case messages::RemotingDataStreamReceiver::kInitializeDataPipe:
            return "Receive media::mojom::RemotingDataStreamReceiver::InitializeDataPipe";
      case messages::RemotingDataStreamReceiver::kReceiveFrame:
            return "Receive media::mojom::RemotingDataStreamReceiver::ReceiveFrame";
      case messages::RemotingDataStreamReceiver::kFlushUntil:
            return "Receive media::mojom::RemotingDataStreamReceiver::FlushUntil";
    }
  } else {
    switch (static_cast<messages::RemotingDataStreamReceiver>(message.name())) {
      case messages::RemotingDataStreamReceiver::kInitializeDataPipe:
            return "Receive reply media::mojom::RemotingDataStreamReceiver::InitializeDataPipe";
      case messages::RemotingDataStreamReceiver::kReceiveFrame:
            return "Receive reply media::mojom::RemotingDataStreamReceiver::ReceiveFrame";
      case messages::RemotingDataStreamReceiver::kFlushUntil:
            return "Receive reply media::mojom::RemotingDataStreamReceiver::FlushUntil";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RemotingDataStreamReceiver::InitializeDataPipe_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb7166f95;  // IPCStableHash for media::mojom::RemotingDataStreamReceiver::InitializeDataPipe
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemotingDataStreamReceiver::ReceiveFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5e122687;  // IPCStableHash for media::mojom::RemotingDataStreamReceiver::ReceiveFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemotingDataStreamReceiver::FlushUntil_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x13951831;  // IPCStableHash for media::mojom::RemotingDataStreamReceiver::FlushUntil
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

RemotingDataStreamReceiverProxy::RemotingDataStreamReceiverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RemotingDataStreamReceiverProxy::InitializeDataPipe(
    ::mojo::ScopedDataPipeConsumerHandle in_data_pipe) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::RemotingDataStreamReceiver::InitializeDataPipe", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_pipe"), in_data_pipe,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemotingDataStreamReceiver::kInitializeDataPipe), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RemotingDataStreamReceiver_InitializeDataPipe_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
    in_data_pipe,
    &params->data_pipe,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->data_pipe)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid data_pipe in RemotingDataStreamReceiver.InitializeDataPipe request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemotingDataStreamReceiver::Name_);
  message.set_method_name("InitializeDataPipe");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemotingDataStreamReceiverProxy::ReceiveFrame(
    uint32_t in_frame_count, ::media::mojom::DecoderBufferPtr in_buffer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::RemotingDataStreamReceiver::ReceiveFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_count"), in_frame_count,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type ::media::mojom::DecoderBufferPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemotingDataStreamReceiver::kReceiveFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RemotingDataStreamReceiver_ReceiveFrame_Params_Data> params(
          message);
  params.Allocate();

  params->frame_count = in_frame_count;
  mojo::internal::MessageFragment<decltype(params->buffer)>
      buffer_fragment(params.message());
  buffer_fragment.Claim(&params->buffer);
  
  mojo::internal::Serialize<::media::mojom::DecoderBufferDataView>(
    in_buffer,
    buffer_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->buffer.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null buffer in RemotingDataStreamReceiver.ReceiveFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemotingDataStreamReceiver::Name_);
  message.set_method_name("ReceiveFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemotingDataStreamReceiverProxy::FlushUntil(
    uint32_t in_frame_count) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::RemotingDataStreamReceiver::FlushUntil", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_count"), in_frame_count,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemotingDataStreamReceiver::kFlushUntil), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RemotingDataStreamReceiver_FlushUntil_Params_Data> params(
          message);
  params.Allocate();

  params->frame_count = in_frame_count;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemotingDataStreamReceiver::Name_);
  message.set_method_name("FlushUntil");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool RemotingDataStreamReceiverStubDispatch::Accept(
    RemotingDataStreamReceiver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RemotingDataStreamReceiver>(message->header()->name)) {
    case messages::RemotingDataStreamReceiver::kInitializeDataPipe: {
      DCHECK(message->is_serialized());
      internal::RemotingDataStreamReceiver_InitializeDataPipe_Params_Data* params =
          reinterpret_cast<internal::RemotingDataStreamReceiver_InitializeDataPipe_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemotingDataStreamReceiver.0
      bool success = true;
      ::mojo::ScopedDataPipeConsumerHandle p_data_pipe{};
      RemotingDataStreamReceiver_InitializeDataPipe_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_data_pipe = input_data_view.TakeDataPipe();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemotingDataStreamReceiver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InitializeDataPipe(        
        std::move(p_data_pipe));
      return true;
    }
    case messages::RemotingDataStreamReceiver::kReceiveFrame: {
      DCHECK(message->is_serialized());
      internal::RemotingDataStreamReceiver_ReceiveFrame_Params_Data* params =
          reinterpret_cast<internal::RemotingDataStreamReceiver_ReceiveFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemotingDataStreamReceiver.1
      bool success = true;
      uint32_t p_frame_count{};
      ::media::mojom::DecoderBufferPtr p_buffer{};
      RemotingDataStreamReceiver_ReceiveFrame_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frame_count = input_data_view.frame_count();
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemotingDataStreamReceiver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReceiveFrame(        
        std::move(p_frame_count), 
        std::move(p_buffer));
      return true;
    }
    case messages::RemotingDataStreamReceiver::kFlushUntil: {
      DCHECK(message->is_serialized());
      internal::RemotingDataStreamReceiver_FlushUntil_Params_Data* params =
          reinterpret_cast<internal::RemotingDataStreamReceiver_FlushUntil_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemotingDataStreamReceiver.2
      bool success = true;
      uint32_t p_frame_count{};
      RemotingDataStreamReceiver_FlushUntil_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frame_count = input_data_view.frame_count();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemotingDataStreamReceiver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FlushUntil(        
        std::move(p_frame_count));
      return true;
    }
  }
  return false;
}

// static
bool RemotingDataStreamReceiverStubDispatch::AcceptWithResponder(
    RemotingDataStreamReceiver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RemotingDataStreamReceiver>(message->header()->name)) {
    case messages::RemotingDataStreamReceiver::kInitializeDataPipe: {
      break;
    }
    case messages::RemotingDataStreamReceiver::kReceiveFrame: {
      break;
    }
    case messages::RemotingDataStreamReceiver::kFlushUntil: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRemotingDataStreamReceiverValidationInfo[] = {
    { &internal::RemotingDataStreamReceiver_InitializeDataPipe_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemotingDataStreamReceiver_ReceiveFrame_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemotingDataStreamReceiver_FlushUntil_Params_Data::Validate,
     nullptr /* no response */},
};

bool RemotingDataStreamReceiverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::RemotingDataStreamReceiver::Name_,
    kRemotingDataStreamReceiverValidationInfo);
}



}  // media::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom {


void RemoterFactoryInterceptorForTesting::Create(::mojo::PendingRemote<RemotingSource> source, ::mojo::PendingReceiver<Remoter> remoter) {
  GetForwardingInterface()->Create(
    std::move(source)
    , 
    std::move(remoter)
    );
}
RemoterFactoryAsyncWaiter::RemoterFactoryAsyncWaiter(
    RemoterFactory* proxy) : proxy_(proxy) {}

RemoterFactoryAsyncWaiter::~RemoterFactoryAsyncWaiter() = default;





void RemotingDataStreamSenderInterceptorForTesting::SendFrame(::media::mojom::DecoderBufferPtr frame, SendFrameCallback callback) {
  GetForwardingInterface()->SendFrame(
    std::move(frame)
    , std::move(callback));
}
void RemotingDataStreamSenderInterceptorForTesting::CancelInFlightData() {
  GetForwardingInterface()->CancelInFlightData();
}
RemotingDataStreamSenderAsyncWaiter::RemotingDataStreamSenderAsyncWaiter(
    RemotingDataStreamSender* proxy) : proxy_(proxy) {}

RemotingDataStreamSenderAsyncWaiter::~RemotingDataStreamSenderAsyncWaiter() = default;


void RemotingDataStreamSenderAsyncWaiter::SendFrame(
    ::media::mojom::DecoderBufferPtr frame) {
  base::RunLoop loop;
  proxy_->SendFrame(
      std::move(frame),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void RemoterInterceptorForTesting::Start() {
  GetForwardingInterface()->Start();
}
void RemoterInterceptorForTesting::StartWithPermissionAlreadyGranted() {
  GetForwardingInterface()->StartWithPermissionAlreadyGranted();
}
void RemoterInterceptorForTesting::StartDataStreams(::mojo::ScopedDataPipeConsumerHandle audio_pipe, ::mojo::ScopedDataPipeConsumerHandle video_pipe, ::mojo::PendingReceiver<RemotingDataStreamSender> audio_sender, ::mojo::PendingReceiver<RemotingDataStreamSender> video_sender) {
  GetForwardingInterface()->StartDataStreams(
    std::move(audio_pipe)
    , 
    std::move(video_pipe)
    , 
    std::move(audio_sender)
    , 
    std::move(video_sender)
    );
}
void RemoterInterceptorForTesting::Stop(::media::mojom::RemotingStopReason reason) {
  GetForwardingInterface()->Stop(
    std::move(reason)
    );
}
void RemoterInterceptorForTesting::SendMessageToSink(const std::vector<uint8_t>& message) {
  GetForwardingInterface()->SendMessageToSink(
    std::move(message)
    );
}
void RemoterInterceptorForTesting::EstimateTransmissionCapacity(EstimateTransmissionCapacityCallback callback) {
  GetForwardingInterface()->EstimateTransmissionCapacity(std::move(callback));
}
RemoterAsyncWaiter::RemoterAsyncWaiter(
    Remoter* proxy) : proxy_(proxy) {}

RemoterAsyncWaiter::~RemoterAsyncWaiter() = default;


void RemoterAsyncWaiter::EstimateTransmissionCapacity(
    double* out_rate) {
  base::RunLoop loop;
  proxy_->EstimateTransmissionCapacity(
      base::BindOnce(
          [](base::RunLoop* loop,
             double* out_rate
,
             double rate) {*out_rate = std::move(rate);
            loop->Quit();
          },
          &loop,
          out_rate));
  loop.Run();
}

double RemoterAsyncWaiter::EstimateTransmissionCapacity(
    ) {
  double async_wait_result;
  EstimateTransmissionCapacity(&async_wait_result);
  return async_wait_result;
}




void RemotingSourceInterceptorForTesting::OnSinkAvailable(::media::mojom::RemotingSinkMetadataPtr metadata) {
  GetForwardingInterface()->OnSinkAvailable(
    std::move(metadata)
    );
}
void RemotingSourceInterceptorForTesting::OnSinkGone() {
  GetForwardingInterface()->OnSinkGone();
}
void RemotingSourceInterceptorForTesting::OnStarted() {
  GetForwardingInterface()->OnStarted();
}
void RemotingSourceInterceptorForTesting::OnStartFailed(::media::mojom::RemotingStartFailReason reason) {
  GetForwardingInterface()->OnStartFailed(
    std::move(reason)
    );
}
void RemotingSourceInterceptorForTesting::OnMessageFromSink(const std::vector<uint8_t>& message) {
  GetForwardingInterface()->OnMessageFromSink(
    std::move(message)
    );
}
void RemotingSourceInterceptorForTesting::OnStopped(::media::mojom::RemotingStopReason reason) {
  GetForwardingInterface()->OnStopped(
    std::move(reason)
    );
}
RemotingSourceAsyncWaiter::RemotingSourceAsyncWaiter(
    RemotingSource* proxy) : proxy_(proxy) {}

RemotingSourceAsyncWaiter::~RemotingSourceAsyncWaiter() = default;





void RemoteeInterceptorForTesting::OnRemotingSinkReady(::mojo::PendingRemote<RemotingSink> sink) {
  GetForwardingInterface()->OnRemotingSinkReady(
    std::move(sink)
    );
}
void RemoteeInterceptorForTesting::SendMessageToSource(const std::vector<uint8_t>& message) {
  GetForwardingInterface()->SendMessageToSource(
    std::move(message)
    );
}
void RemoteeInterceptorForTesting::StartDataStreams(::mojo::PendingRemote<RemotingDataStreamReceiver> audio_stream, ::mojo::PendingRemote<RemotingDataStreamReceiver> video_stream) {
  GetForwardingInterface()->StartDataStreams(
    std::move(audio_stream)
    , 
    std::move(video_stream)
    );
}
void RemoteeInterceptorForTesting::OnFlushUntil(uint32_t audio_frame_count, uint32_t video_frame_count) {
  GetForwardingInterface()->OnFlushUntil(
    std::move(audio_frame_count)
    , 
    std::move(video_frame_count)
    );
}
void RemoteeInterceptorForTesting::OnVideoNaturalSizeChange(const ::gfx::Size& size) {
  GetForwardingInterface()->OnVideoNaturalSizeChange(
    std::move(size)
    );
}
RemoteeAsyncWaiter::RemoteeAsyncWaiter(
    Remotee* proxy) : proxy_(proxy) {}

RemoteeAsyncWaiter::~RemoteeAsyncWaiter() = default;





void RemotingSinkInterceptorForTesting::OnMessageFromSource(const std::vector<uint8_t>& message) {
  GetForwardingInterface()->OnMessageFromSource(
    std::move(message)
    );
}
RemotingSinkAsyncWaiter::RemotingSinkAsyncWaiter(
    RemotingSink* proxy) : proxy_(proxy) {}

RemotingSinkAsyncWaiter::~RemotingSinkAsyncWaiter() = default;





void RemotingDataStreamReceiverInterceptorForTesting::InitializeDataPipe(::mojo::ScopedDataPipeConsumerHandle data_pipe) {
  GetForwardingInterface()->InitializeDataPipe(
    std::move(data_pipe)
    );
}
void RemotingDataStreamReceiverInterceptorForTesting::ReceiveFrame(uint32_t frame_count, ::media::mojom::DecoderBufferPtr buffer) {
  GetForwardingInterface()->ReceiveFrame(
    std::move(frame_count)
    , 
    std::move(buffer)
    );
}
void RemotingDataStreamReceiverInterceptorForTesting::FlushUntil(uint32_t frame_count) {
  GetForwardingInterface()->FlushUntil(
    std::move(frame_count)
    );
}
RemotingDataStreamReceiverAsyncWaiter::RemotingDataStreamReceiverAsyncWaiter(
    RemotingDataStreamReceiver* proxy) : proxy_(proxy) {}

RemotingDataStreamReceiverAsyncWaiter::~RemotingDataStreamReceiverAsyncWaiter() = default;







}  // media::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif