// media/mojo/mojom/output_protection.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class OutputProtectionPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.OutputProtection', scope);
  }
}

/** @interface */
export class OutputProtectionInterface {
  
  /**
   * @return {!Promise<{
        success: !boolean,
        linkMask: !number,
        protectionMask: !number,
   *  }>}
   */

  queryStatus() {}
  
  /**
   * @param { !number } desiredProtectionMask
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  enableProtection(desiredProtectionMask) {}
}

/**
 * @implements { OutputProtectionInterface }
 */
export class OutputProtectionRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!OutputProtectionPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          OutputProtectionPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!OutputProtectionPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        success: !boolean,
        linkMask: !number,
        protectionMask: !number,
   *  }>}
   */

  queryStatus() {
    return this.proxy.sendMessage(
        0,
        OutputProtection_QueryStatus_ParamsSpec.$,
        OutputProtection_QueryStatus_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } desiredProtectionMask
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  enableProtection(
      desiredProtectionMask) {
    return this.proxy.sendMessage(
        1,
        OutputProtection_EnableProtection_ParamsSpec.$,
        OutputProtection_EnableProtection_ResponseParamsSpec.$,
        [
          desiredProtectionMask
        ],
        false);
  }
}

/**
 * An object which receives request messages for the OutputProtection
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class OutputProtectionReceiver {
  /**
   * @param {!OutputProtectionInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!OutputProtectionRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        OutputProtectionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!OutputProtectionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        OutputProtection_QueryStatus_ParamsSpec.$,
        OutputProtection_QueryStatus_ResponseParamsSpec.$,
        impl.queryStatus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        OutputProtection_EnableProtection_ParamsSpec.$,
        OutputProtection_EnableProtection_ResponseParamsSpec.$,
        impl.enableProtection.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class OutputProtection {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.OutputProtection";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!OutputProtectionRemote}
   */
  static getRemote() {
    let remote = new OutputProtectionRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const OutputProtection_ProtectionTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const OutputProtection_ProtectionType = {
  
  NONE: 0,
  HDCP: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};
/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const OutputProtection_LinkTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const OutputProtection_LinkType = {
  
  NONE: 0,
  UNKNOWN: 1,
  INTERNAL: 2,
  VGA: 4,
  HDMI: 8,
  DVI: 16,
  DISPLAYPORT: 32,
  NETWORK: 64,
  MIN_VALUE: 0,
  MAX_VALUE: 64,
};

/**
 * An object which receives request messages for the OutputProtection
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class OutputProtectionCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      OutputProtectionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!OutputProtectionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queryStatus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        OutputProtection_QueryStatus_ParamsSpec.$,
        OutputProtection_QueryStatus_ResponseParamsSpec.$,
        this.queryStatus.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enableProtection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        OutputProtection_EnableProtection_ParamsSpec.$,
        OutputProtection_EnableProtection_ResponseParamsSpec.$,
        this.enableProtection.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OutputProtection_QueryStatus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OutputProtection_QueryStatus_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OutputProtection_EnableProtection_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OutputProtection_EnableProtection_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    OutputProtection_QueryStatus_ParamsSpec.$,
    'OutputProtection_QueryStatus_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class OutputProtection_QueryStatus_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    OutputProtection_QueryStatus_ResponseParamsSpec.$,
    'OutputProtection_QueryStatus_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'linkMask', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'protectionMask', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class OutputProtection_QueryStatus_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { !number } */
    this.linkMask;
    /** @type { !number } */
    this.protectionMask;
  }
}



mojo.internal.Struct(
    OutputProtection_EnableProtection_ParamsSpec.$,
    'OutputProtection_EnableProtection_Params',
    [
      mojo.internal.StructField(
        'desiredProtectionMask', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class OutputProtection_EnableProtection_Params {
  constructor() {
    /** @type { !number } */
    this.desiredProtectionMask;
  }
}



mojo.internal.Struct(
    OutputProtection_EnableProtection_ResponseParamsSpec.$,
    'OutputProtection_EnableProtection_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class OutputProtection_EnableProtection_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}

