// media/mojo/mojom/media_types.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_MEDIA_TYPES_MOJOM_SEND_VALIDATION_H_
#define MEDIA_MOJO_MOJOM_MEDIA_TYPES_MOJOM_SEND_VALIDATION_H_

#include "media/mojo/mojom/media_types.mojom-shared-internal.h"
#include "gpu/ipc/common/exported_shared_image.mojom-shared.h"
#include "gpu/ipc/common/mailbox.mojom-shared.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "gpu/ipc/common/vulkan_ycbcr_info.mojom-shared.h"
#include "media/mojo/mojom/audio_data.mojom-shared.h"
#include "media/mojo/mojom/encryption_pattern.mojom-shared.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"
#include "ui/gfx/mojom/hdr_metadata.mojom-shared.h"

#include "media/mojo/mojom/media_types.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::VideoRotation, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::EncryptionType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::SVCScalabilityMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::SVCInterLayerPredMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::CdmSessionClosedReason, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::EffectState, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::MediaStreamType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::InputStreamErrorCode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::RendererType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::DemuxerType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::CreateCdmStatus, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::AutoPipReason, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::MediaLogRecordDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::MediaLogRecordDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::MediaLogRecord_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::VideoTransformationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoTransformationDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoTransformation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::media::mojom::VideoRotation>(
        Traits::rotation(input),
        &fragment->rotation);

      fragment->mirrored = Traits::mirrored(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::VideoAspectRatioDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoAspectRatioDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoAspectRatio_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::media::mojom::VideoAspectRatio_Type>(
        Traits::type(input),
        &fragment->type);

      fragment->value = Traits::value(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::VideoColorSpaceDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoColorSpaceDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoColorSpace_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::media::mojom::VideoColorSpace_PrimaryID>(
        Traits::primaries(input),
        &fragment->primaries);

      
      mojo::internal::Serialize<::media::mojom::VideoColorSpace_TransferID>(
        Traits::transfer(input),
        &fragment->transfer);

      
      mojo::internal::Serialize<::media::mojom::VideoColorSpace_MatrixID>(
        Traits::matrix(input),
        &fragment->matrix);

      
      mojo::internal::Serialize<::media::mojom::VideoColorSpace_RangeID>(
        Traits::range(input),
        &fragment->range);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::AudioDecoderConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::AudioDecoderConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::AudioDecoderConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::media::mojom::AudioCodec>(
        Traits::codec(input),
        &fragment->codec);

      
      mojo::internal::Serialize<::media::mojom::SampleFormat>(
        Traits::sample_format(input),
        &fragment->sample_format);

      
      mojo::internal::Serialize<::media::mojom::ChannelLayout>(
        Traits::channel_layout(input),
        &fragment->channel_layout);

      fragment->samples_per_second = Traits::samples_per_second(input);

      decltype(Traits::extra_data(input)) in_extra_data = Traits::extra_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->extra_data)::BaseType>
          extra_data_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& extra_data_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_extra_data,
        extra_data_fragment,
        &extra_data_validate_params);

      fragment->extra_data.Set(
          extra_data_fragment.is_null() ? nullptr : extra_data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->extra_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null extra_data in AudioDecoderConfig struct");

      
      mojo::internal::Serialize<::media::mojom::EncryptionScheme>(
        Traits::encryption_scheme(input),
        &fragment->encryption_scheme);

      decltype(Traits::seek_preroll(input)) in_seek_preroll = Traits::seek_preroll(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->seek_preroll)::BaseType> seek_preroll_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_seek_preroll,
        seek_preroll_fragment);

      fragment->seek_preroll.Set(
          seek_preroll_fragment.is_null() ? nullptr : seek_preroll_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->seek_preroll.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null seek_preroll in AudioDecoderConfig struct");

      fragment->codec_delay = Traits::codec_delay(input);

      
      mojo::internal::Serialize<::media::mojom::AudioCodecProfile>(
        Traits::profile(input),
        &fragment->profile);

      
      mojo::internal::Serialize<::media::mojom::ChannelLayout>(
        Traits::target_output_channel_layout(input),
        &fragment->target_output_channel_layout);

      
      mojo::internal::Serialize<::media::mojom::SampleFormat>(
        Traits::target_output_sample_format(input),
        &fragment->target_output_sample_format);

      fragment->should_discard_decoder_delay = Traits::should_discard_decoder_delay(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::VideoDecoderConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoDecoderConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoDecoderConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::media::mojom::VideoCodec>(
        Traits::codec(input),
        &fragment->codec);

      
      mojo::internal::Serialize<::media::mojom::VideoCodecProfile>(
        Traits::profile(input),
        &fragment->profile);

      fragment->level = Traits::level(input);

      fragment->has_alpha = Traits::has_alpha(input);

      decltype(Traits::transformation(input)) in_transformation = Traits::transformation(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->transformation)::BaseType> transformation_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::VideoTransformationDataView, send_validation>(
        in_transformation,
        transformation_fragment);

      fragment->transformation.Set(
          transformation_fragment.is_null() ? nullptr : transformation_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->transformation.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null transformation in VideoDecoderConfig struct");

      decltype(Traits::coded_size(input)) in_coded_size = Traits::coded_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->coded_size)::BaseType> coded_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_coded_size,
        coded_size_fragment);

      fragment->coded_size.Set(
          coded_size_fragment.is_null() ? nullptr : coded_size_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->coded_size.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null coded_size in VideoDecoderConfig struct");

      decltype(Traits::visible_rect(input)) in_visible_rect = Traits::visible_rect(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->visible_rect)::BaseType> visible_rect_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_visible_rect,
        visible_rect_fragment);

      fragment->visible_rect.Set(
          visible_rect_fragment.is_null() ? nullptr : visible_rect_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->visible_rect.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null visible_rect in VideoDecoderConfig struct");

      decltype(Traits::natural_size(input)) in_natural_size = Traits::natural_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->natural_size)::BaseType> natural_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_natural_size,
        natural_size_fragment);

      fragment->natural_size.Set(
          natural_size_fragment.is_null() ? nullptr : natural_size_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->natural_size.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null natural_size in VideoDecoderConfig struct");

      decltype(Traits::aspect_ratio(input)) in_aspect_ratio = Traits::aspect_ratio(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->aspect_ratio)::BaseType> aspect_ratio_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::VideoAspectRatioDataView, send_validation>(
        in_aspect_ratio,
        aspect_ratio_fragment);

      fragment->aspect_ratio.Set(
          aspect_ratio_fragment.is_null() ? nullptr : aspect_ratio_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->aspect_ratio.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null aspect_ratio in VideoDecoderConfig struct");

      decltype(Traits::extra_data(input)) in_extra_data = Traits::extra_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->extra_data)::BaseType>
          extra_data_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& extra_data_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_extra_data,
        extra_data_fragment,
        &extra_data_validate_params);

      fragment->extra_data.Set(
          extra_data_fragment.is_null() ? nullptr : extra_data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->extra_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null extra_data in VideoDecoderConfig struct");

      
      mojo::internal::Serialize<::media::mojom::EncryptionScheme>(
        Traits::encryption_scheme(input),
        &fragment->encryption_scheme);

      decltype(Traits::color_space_info(input)) in_color_space_info = Traits::color_space_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->color_space_info)::BaseType> color_space_info_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::VideoColorSpaceDataView, send_validation>(
        in_color_space_info,
        color_space_info_fragment);

      fragment->color_space_info.Set(
          color_space_info_fragment.is_null() ? nullptr : color_space_info_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->color_space_info.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null color_space_info in VideoDecoderConfig struct");

      decltype(Traits::hdr_metadata(input)) in_hdr_metadata = Traits::hdr_metadata(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->hdr_metadata)::BaseType> hdr_metadata_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::HDRMetadataDataView, send_validation>(
        in_hdr_metadata,
        hdr_metadata_fragment);

      fragment->hdr_metadata.Set(
          hdr_metadata_fragment.is_null() ? nullptr : hdr_metadata_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::SubsampleEntryDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::SubsampleEntryDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::SubsampleEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::DecryptConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::DecryptConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::DecryptConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::media::mojom::EncryptionScheme>(
        Traits::encryption_scheme(input),
        &fragment->encryption_scheme);

      decltype(Traits::key_id(input)) in_key_id = Traits::key_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->key_id)::BaseType> key_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView, send_validation>(
        in_key_id,
        key_id_fragment);

      fragment->key_id.Set(
          key_id_fragment.is_null() ? nullptr : key_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->key_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null key_id in DecryptConfig struct");

      decltype(Traits::iv(input)) in_iv = Traits::iv(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->iv)::BaseType> iv_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView, send_validation>(
        in_iv,
        iv_fragment);

      fragment->iv.Set(
          iv_fragment.is_null() ? nullptr : iv_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->iv.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null iv in DecryptConfig struct");

      decltype(Traits::subsamples(input)) in_subsamples = Traits::subsamples(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->subsamples)::BaseType>
          subsamples_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& subsamples_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::SubsampleEntryDataView>, send_validation>(
        in_subsamples,
        subsamples_fragment,
        &subsamples_validate_params);

      fragment->subsamples.Set(
          subsamples_fragment.is_null() ? nullptr : subsamples_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->subsamples.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null subsamples in DecryptConfig struct");

      decltype(Traits::encryption_pattern(input)) in_encryption_pattern = Traits::encryption_pattern(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->encryption_pattern)::BaseType> encryption_pattern_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::EncryptionPatternDataView, send_validation>(
        in_encryption_pattern,
        encryption_pattern_fragment);

      fragment->encryption_pattern.Set(
          encryption_pattern_fragment.is_null() ? nullptr : encryption_pattern_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::DecoderBufferSideDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::DecoderBufferSideDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::DecoderBufferSideData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::spatial_layers(input)) in_spatial_layers = Traits::spatial_layers(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->spatial_layers)::BaseType>
          spatial_layers_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& spatial_layers_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>, send_validation>(
        in_spatial_layers,
        spatial_layers_fragment,
        &spatial_layers_validate_params);

      fragment->spatial_layers.Set(
          spatial_layers_fragment.is_null() ? nullptr : spatial_layers_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->spatial_layers.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null spatial_layers in DecoderBufferSideData struct");

      decltype(Traits::alpha_data(input)) in_alpha_data = Traits::alpha_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->alpha_data)::BaseType>
          alpha_data_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& alpha_data_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_alpha_data,
        alpha_data_fragment,
        &alpha_data_validate_params);

      fragment->alpha_data.Set(
          alpha_data_fragment.is_null() ? nullptr : alpha_data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->alpha_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null alpha_data in DecoderBufferSideData struct");

      fragment->secure_handle = Traits::secure_handle(input);

      decltype(Traits::front_discard(input)) in_front_discard = Traits::front_discard(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->front_discard)::BaseType> front_discard_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_front_discard,
        front_discard_fragment);

      fragment->front_discard.Set(
          front_discard_fragment.is_null() ? nullptr : front_discard_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->front_discard.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null front_discard in DecoderBufferSideData struct");

      decltype(Traits::back_discard(input)) in_back_discard = Traits::back_discard(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->back_discard)::BaseType> back_discard_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_back_discard,
        back_discard_fragment);

      fragment->back_discard.Set(
          back_discard_fragment.is_null() ? nullptr : back_discard_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->back_discard.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null back_discard in DecoderBufferSideData struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::DataDecoderBufferDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::DataDecoderBufferDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::DataDecoderBuffer_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_timestamp,
        timestamp_fragment);

      fragment->timestamp.Set(
          timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->timestamp.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null timestamp in DataDecoderBuffer struct");

      decltype(Traits::duration(input)) in_duration = Traits::duration(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->duration)::BaseType> duration_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_duration,
        duration_fragment);

      fragment->duration.Set(
          duration_fragment.is_null() ? nullptr : duration_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->duration.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null duration in DataDecoderBuffer struct");

      fragment->data_size = Traits::data_size(input);

      fragment->is_key_frame = Traits::is_key_frame(input);

      decltype(Traits::decrypt_config(input)) in_decrypt_config = Traits::decrypt_config(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->decrypt_config)::BaseType> decrypt_config_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::DecryptConfigDataView, send_validation>(
        in_decrypt_config,
        decrypt_config_fragment);

      fragment->decrypt_config.Set(
          decrypt_config_fragment.is_null() ? nullptr : decrypt_config_fragment.data());

      decltype(Traits::side_data(input)) in_side_data = Traits::side_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->side_data)::BaseType> side_data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::DecoderBufferSideDataDataView, send_validation>(
        in_side_data,
        side_data_fragment);

      fragment->side_data.Set(
          side_data_fragment.is_null() ? nullptr : side_data_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::EosDecoderBufferDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::EosDecoderBufferDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::EosDecoderBuffer_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::next_config(input)) in_next_config = Traits::next_config(input);
      mojo::internal::MessageFragment<decltype(fragment->next_config)>
          next_config_fragment(fragment.message());
      next_config_fragment.Claim(&fragment->next_config);
      
      mojo::internal::Serialize<::media::mojom::DecoderBufferSideDataNextConfigDataView, send_validation>(
        in_next_config,
        next_config_fragment,
        true);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::AudioBufferDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::AudioBufferDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::AudioBuffer_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::media::mojom::SampleFormat>(
        Traits::sample_format(input),
        &fragment->sample_format);

      
      mojo::internal::Serialize<::media::mojom::ChannelLayout>(
        Traits::channel_layout(input),
        &fragment->channel_layout);

      fragment->channel_count = Traits::channel_count(input);

      fragment->sample_rate = Traits::sample_rate(input);

      fragment->frame_count = Traits::frame_count(input);

      fragment->end_of_stream = Traits::end_of_stream(input);

      decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_timestamp,
        timestamp_fragment);

      fragment->timestamp.Set(
          timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->timestamp.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null timestamp in AudioBuffer struct");

      decltype(Traits::data(input)) in_data = Traits::data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->data)::BaseType>
          data_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_data,
        data_fragment,
        &data_validate_params);

      fragment->data.Set(
          data_fragment.is_null() ? nullptr : data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in AudioBuffer struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::CaptureVersionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::CaptureVersionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::CaptureVersion_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->source = Traits::source(input);

      fragment->sub_capture = Traits::sub_capture(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::VideoFrameMetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoFrameMetadataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoFrameMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->allow_overlay = Traits::allow_overlay(input);

      decltype(Traits::capture_begin_time(input)) in_capture_begin_time = Traits::capture_begin_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->capture_begin_time)::BaseType> capture_begin_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_capture_begin_time,
        capture_begin_time_fragment);

      fragment->capture_begin_time.Set(
          capture_begin_time_fragment.is_null() ? nullptr : capture_begin_time_fragment.data());

      decltype(Traits::capture_end_time(input)) in_capture_end_time = Traits::capture_end_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->capture_end_time)::BaseType> capture_end_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_capture_end_time,
        capture_end_time_fragment);

      fragment->capture_end_time.Set(
          capture_end_time_fragment.is_null() ? nullptr : capture_end_time_fragment.data());

      fragment->has_capture_counter = Traits::has_capture_counter(input);

      fragment->capture_counter = Traits::capture_counter(input);

      decltype(Traits::capture_update_rect(input)) in_capture_update_rect = Traits::capture_update_rect(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->capture_update_rect)::BaseType> capture_update_rect_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_capture_update_rect,
        capture_update_rect_fragment);

      fragment->capture_update_rect.Set(
          capture_update_rect_fragment.is_null() ? nullptr : capture_update_rect_fragment.data());

      decltype(Traits::source_size(input)) in_source_size = Traits::source_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->source_size)::BaseType> source_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_source_size,
        source_size_fragment);

      fragment->source_size.Set(
          source_size_fragment.is_null() ? nullptr : source_size_fragment.data());

      decltype(Traits::region_capture_rect(input)) in_region_capture_rect = Traits::region_capture_rect(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->region_capture_rect)::BaseType> region_capture_rect_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_region_capture_rect,
        region_capture_rect_fragment);

      fragment->region_capture_rect.Set(
          region_capture_rect_fragment.is_null() ? nullptr : region_capture_rect_fragment.data());

      decltype(Traits::capture_version(input)) in_capture_version = Traits::capture_version(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->capture_version)::BaseType> capture_version_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::CaptureVersionDataView, send_validation>(
        in_capture_version,
        capture_version_fragment);

      fragment->capture_version.Set(
          capture_version_fragment.is_null() ? nullptr : capture_version_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->capture_version.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null capture_version in VideoFrameMetadata struct");

      fragment->copy_required = Traits::copy_required(input);

      fragment->end_of_stream = Traits::end_of_stream(input);

      decltype(Traits::frame_duration(input)) in_frame_duration = Traits::frame_duration(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->frame_duration)::BaseType> frame_duration_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_frame_duration,
        frame_duration_fragment);

      fragment->frame_duration.Set(
          frame_duration_fragment.is_null() ? nullptr : frame_duration_fragment.data());

      fragment->has_frame_rate = Traits::has_frame_rate(input);

      fragment->frame_rate = Traits::frame_rate(input);

      fragment->interactive_content = Traits::interactive_content(input);

      decltype(Traits::reference_time(input)) in_reference_time = Traits::reference_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->reference_time)::BaseType> reference_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_reference_time,
        reference_time_fragment);

      fragment->reference_time.Set(
          reference_time_fragment.is_null() ? nullptr : reference_time_fragment.data());

      fragment->read_lock_fences_enabled = Traits::read_lock_fences_enabled(input);

      decltype(Traits::transformation(input)) in_transformation = Traits::transformation(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->transformation)::BaseType> transformation_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::VideoTransformationDataView, send_validation>(
        in_transformation,
        transformation_fragment);

      fragment->transformation.Set(
          transformation_fragment.is_null() ? nullptr : transformation_fragment.data());

      fragment->in_surface_view = Traits::in_surface_view(input);

      fragment->wants_promotion_hint = Traits::wants_promotion_hint(input);

      fragment->protected_video = Traits::protected_video(input);

      fragment->hw_protected = Traits::hw_protected(input);

      fragment->needs_detiling = Traits::needs_detiling(input);

      fragment->is_webgpu_compatible = Traits::is_webgpu_compatible(input);

      decltype(Traits::tracking_token(input)) in_tracking_token = Traits::tracking_token(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->tracking_token)::BaseType> tracking_token_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView, send_validation>(
        in_tracking_token,
        tracking_token_fragment);

      fragment->tracking_token.Set(
          tracking_token_fragment.is_null() ? nullptr : tracking_token_fragment.data());

      fragment->power_efficient = Traits::power_efficient(input);

      fragment->has_device_scale_factor = Traits::has_device_scale_factor(input);

      fragment->device_scale_factor = Traits::device_scale_factor(input);

      fragment->has_page_scale_factor = Traits::has_page_scale_factor(input);

      fragment->page_scale_factor = Traits::page_scale_factor(input);

      fragment->has_root_scroll_offset_x = Traits::has_root_scroll_offset_x(input);

      fragment->root_scroll_offset_x = Traits::root_scroll_offset_x(input);

      fragment->has_root_scroll_offset_y = Traits::has_root_scroll_offset_y(input);

      fragment->root_scroll_offset_y = Traits::root_scroll_offset_y(input);

      fragment->has_top_controls_visible_height = Traits::has_top_controls_visible_height(input);

      fragment->top_controls_visible_height = Traits::top_controls_visible_height(input);

      decltype(Traits::decode_begin_time(input)) in_decode_begin_time = Traits::decode_begin_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->decode_begin_time)::BaseType> decode_begin_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_decode_begin_time,
        decode_begin_time_fragment);

      fragment->decode_begin_time.Set(
          decode_begin_time_fragment.is_null() ? nullptr : decode_begin_time_fragment.data());

      decltype(Traits::decode_end_time(input)) in_decode_end_time = Traits::decode_end_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->decode_end_time)::BaseType> decode_end_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_decode_end_time,
        decode_end_time_fragment);

      fragment->decode_end_time.Set(
          decode_end_time_fragment.is_null() ? nullptr : decode_end_time_fragment.data());

      decltype(Traits::processing_time(input)) in_processing_time = Traits::processing_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->processing_time)::BaseType> processing_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_processing_time,
        processing_time_fragment);

      fragment->processing_time.Set(
          processing_time_fragment.is_null() ? nullptr : processing_time_fragment.data());

      fragment->has_rtp_timestamp = Traits::has_rtp_timestamp(input);

      fragment->rtp_timestamp = Traits::rtp_timestamp(input);

      decltype(Traits::receive_time(input)) in_receive_time = Traits::receive_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->receive_time)::BaseType> receive_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_receive_time,
        receive_time_fragment);

      fragment->receive_time.Set(
          receive_time_fragment.is_null() ? nullptr : receive_time_fragment.data());

      decltype(Traits::wallclock_frame_duration(input)) in_wallclock_frame_duration = Traits::wallclock_frame_duration(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->wallclock_frame_duration)::BaseType> wallclock_frame_duration_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_wallclock_frame_duration,
        wallclock_frame_duration_fragment);

      fragment->wallclock_frame_duration.Set(
          wallclock_frame_duration_fragment.is_null() ? nullptr : wallclock_frame_duration_fragment.data());
      fragment->frame_sequence_$flag = Traits::frame_sequence(input).has_value();
      if (Traits::frame_sequence(input).has_value()) {
        fragment->frame_sequence_$value = Traits::frame_sequence(input).value();
      }
      fragment->source_id_$flag = Traits::source_id(input).has_value();
      if (Traits::source_id(input).has_value()) {
        fragment->source_id_$value = Traits::source_id(input).value();
      }

      
      mojo::internal::Serialize<::media::mojom::EffectState>(
        Traits::background_blur(input),
        &fragment->background_blur);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::VideoFrameDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoFrameDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoFrame_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::media::mojom::VideoPixelFormat>(
        Traits::format(input),
        &fragment->format);

      decltype(Traits::coded_size(input)) in_coded_size = Traits::coded_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->coded_size)::BaseType> coded_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_coded_size,
        coded_size_fragment);

      fragment->coded_size.Set(
          coded_size_fragment.is_null() ? nullptr : coded_size_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->coded_size.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null coded_size in VideoFrame struct");

      decltype(Traits::visible_rect(input)) in_visible_rect = Traits::visible_rect(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->visible_rect)::BaseType> visible_rect_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_visible_rect,
        visible_rect_fragment);

      fragment->visible_rect.Set(
          visible_rect_fragment.is_null() ? nullptr : visible_rect_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->visible_rect.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null visible_rect in VideoFrame struct");

      decltype(Traits::natural_size(input)) in_natural_size = Traits::natural_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->natural_size)::BaseType> natural_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_natural_size,
        natural_size_fragment);

      fragment->natural_size.Set(
          natural_size_fragment.is_null() ? nullptr : natural_size_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->natural_size.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null natural_size in VideoFrame struct");

      decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_timestamp,
        timestamp_fragment);

      fragment->timestamp.Set(
          timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->timestamp.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null timestamp in VideoFrame struct");

      decltype(Traits::data(input)) in_data = Traits::data(input);
      mojo::internal::MessageFragment<decltype(fragment->data)>
          data_fragment(fragment.message());
      data_fragment.Claim(&fragment->data);
      
      mojo::internal::Serialize<::media::mojom::VideoFrameDataDataView, send_validation>(
        in_data,
        data_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in VideoFrame struct");

      decltype(Traits::metadata(input)) in_metadata = Traits::metadata(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->metadata)::BaseType> metadata_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::VideoFrameMetadataDataView, send_validation>(
        in_metadata,
        metadata_fragment);

      fragment->metadata.Set(
          metadata_fragment.is_null() ? nullptr : metadata_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->metadata.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null metadata in VideoFrame struct");

      decltype(Traits::color_space(input)) in_color_space = Traits::color_space(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->color_space)::BaseType> color_space_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::ColorSpaceDataView, send_validation>(
        in_color_space,
        color_space_fragment);

      fragment->color_space.Set(
          color_space_fragment.is_null() ? nullptr : color_space_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->color_space.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null color_space in VideoFrame struct");

      decltype(Traits::hdr_metadata(input)) in_hdr_metadata = Traits::hdr_metadata(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->hdr_metadata)::BaseType> hdr_metadata_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::HDRMetadataDataView, send_validation>(
        in_hdr_metadata,
        hdr_metadata_fragment);

      fragment->hdr_metadata.Set(
          hdr_metadata_fragment.is_null() ? nullptr : hdr_metadata_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::EosVideoFrameDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::EosVideoFrameDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::EosVideoFrameData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::SharedMemoryVideoFrameDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::SharedMemoryVideoFrameDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::SharedMemoryVideoFrameData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::frame_data(input)) in_frame_data = Traits::frame_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->frame_data)::BaseType> frame_data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView, send_validation>(
        in_frame_data,
        frame_data_fragment);

      fragment->frame_data.Set(
          frame_data_fragment.is_null() ? nullptr : frame_data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->frame_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_data in SharedMemoryVideoFrameData struct");

      decltype(Traits::strides(input)) in_strides = Traits::strides(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->strides)::BaseType>
          strides_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& strides_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<int32_t>, send_validation>(
        in_strides,
        strides_fragment,
        &strides_validate_params);

      fragment->strides.Set(
          strides_fragment.is_null() ? nullptr : strides_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->strides.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null strides in SharedMemoryVideoFrameData struct");

      decltype(Traits::offsets(input)) in_offsets = Traits::offsets(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->offsets)::BaseType>
          offsets_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& offsets_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>, send_validation>(
        in_offsets,
        offsets_fragment,
        &offsets_validate_params);

      fragment->offsets.Set(
          offsets_fragment.is_null() ? nullptr : offsets_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->offsets.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null offsets in SharedMemoryVideoFrameData struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::GpuMemoryBufferSharedImageVideoFrameDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::GpuMemoryBufferSharedImageVideoFrameDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::GpuMemoryBufferSharedImageVideoFrameData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::gpu_memory_buffer_handle(input)) in_gpu_memory_buffer_handle = Traits::gpu_memory_buffer_handle(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->gpu_memory_buffer_handle)::BaseType> gpu_memory_buffer_handle_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferHandleDataView, send_validation>(
        in_gpu_memory_buffer_handle,
        gpu_memory_buffer_handle_fragment);

      fragment->gpu_memory_buffer_handle.Set(
          gpu_memory_buffer_handle_fragment.is_null() ? nullptr : gpu_memory_buffer_handle_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->gpu_memory_buffer_handle.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null gpu_memory_buffer_handle in GpuMemoryBufferSharedImageVideoFrameData struct");

      decltype(Traits::shared_image(input)) in_shared_image = Traits::shared_image(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->shared_image)::BaseType> shared_image_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::ExportedSharedImageDataView, send_validation>(
        in_shared_image,
        shared_image_fragment);

      fragment->shared_image.Set(
          shared_image_fragment.is_null() ? nullptr : shared_image_fragment.data());

      decltype(Traits::sync_token(input)) in_sync_token = Traits::sync_token(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sync_token)::BaseType> sync_token_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView, send_validation>(
        in_sync_token,
        sync_token_fragment);

      fragment->sync_token.Set(
          sync_token_fragment.is_null() ? nullptr : sync_token_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->sync_token.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sync_token in GpuMemoryBufferSharedImageVideoFrameData struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::SharedImageVideoFrameDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::SharedImageVideoFrameDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::SharedImageVideoFrameData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::shared_image(input)) in_shared_image = Traits::shared_image(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->shared_image)::BaseType> shared_image_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::ExportedSharedImageDataView, send_validation>(
        in_shared_image,
        shared_image_fragment);

      fragment->shared_image.Set(
          shared_image_fragment.is_null() ? nullptr : shared_image_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->shared_image.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null shared_image in SharedImageVideoFrameData struct");

      decltype(Traits::sync_token(input)) in_sync_token = Traits::sync_token(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sync_token)::BaseType> sync_token_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView, send_validation>(
        in_sync_token,
        sync_token_fragment);

      fragment->sync_token.Set(
          sync_token_fragment.is_null() ? nullptr : sync_token_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->sync_token.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sync_token in SharedImageVideoFrameData struct");

      fragment->is_mappable_si_enabled = Traits::is_mappable_si_enabled(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::OpaqueVideoFrameDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::OpaqueVideoFrameDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::OpaqueVideoFrameData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::PipelineStatisticsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::PipelineStatisticsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::PipelineStatistics_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->audio_bytes_decoded = Traits::audio_bytes_decoded(input);

      fragment->video_bytes_decoded = Traits::video_bytes_decoded(input);

      fragment->video_frames_decoded = Traits::video_frames_decoded(input);

      fragment->video_frames_dropped = Traits::video_frames_dropped(input);

      fragment->audio_memory_usage = Traits::audio_memory_usage(input);

      fragment->video_memory_usage = Traits::video_memory_usage(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::PredictionFeaturesDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::PredictionFeaturesDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::PredictionFeatures_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::media::mojom::VideoCodecProfile>(
        Traits::profile(input),
        &fragment->profile);

      decltype(Traits::video_size(input)) in_video_size = Traits::video_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->video_size)::BaseType> video_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_video_size,
        video_size_fragment);

      fragment->video_size.Set(
          video_size_fragment.is_null() ? nullptr : video_size_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->video_size.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null video_size in PredictionFeatures struct");

      fragment->frames_per_sec = Traits::frames_per_sec(input);

      decltype(Traits::key_system(input)) in_key_system = Traits::key_system(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->key_system)::BaseType> key_system_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_key_system,
        key_system_fragment);

      fragment->key_system.Set(
          key_system_fragment.is_null() ? nullptr : key_system_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->key_system.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null key_system in PredictionFeatures struct");

      fragment->use_hw_secure_codecs = Traits::use_hw_secure_codecs(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::PredictionTargetsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::PredictionTargetsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::PredictionTargets_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->frames_decoded = Traits::frames_decoded(input);

      fragment->frames_dropped = Traits::frames_dropped(input);

      fragment->frames_power_efficient = Traits::frames_power_efficient(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::AudioPipelineInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::AudioPipelineInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::AudioPipelineInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::media::mojom::AudioDecoderType>(
        Traits::decoder_type(input),
        &fragment->decoder_type);

      fragment->is_platform_decoder = Traits::is_platform_decoder(input);

      fragment->has_decrypting_demuxer_stream = Traits::has_decrypting_demuxer_stream(input);

      
      mojo::internal::Serialize<::media::mojom::EncryptionType>(
        Traits::encryption_type(input),
        &fragment->encryption_type);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::VideoPipelineInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoPipelineInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoPipelineInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::media::mojom::VideoDecoderType>(
        Traits::decoder_type(input),
        &fragment->decoder_type);

      fragment->is_platform_decoder = Traits::is_platform_decoder(input);

      fragment->has_decrypting_demuxer_stream = Traits::has_decrypting_demuxer_stream(input);

      
      mojo::internal::Serialize<::media::mojom::EncryptionType>(
        Traits::encryption_type(input),
        &fragment->encryption_type);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::StatusDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::StatusDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::StatusData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::group(input)) in_group = Traits::group(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->group)::BaseType> group_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_group,
        group_fragment);

      fragment->group.Set(
          group_fragment.is_null() ? nullptr : group_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->group.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null group in StatusData struct");

      fragment->code = Traits::code(input);

      decltype(Traits::message(input)) in_message = Traits::message(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->message)::BaseType> message_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_message,
        message_fragment);

      fragment->message.Set(
          message_fragment.is_null() ? nullptr : message_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->message.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null message in StatusData struct");

      decltype(Traits::frames(input)) in_frames = Traits::frames(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->frames)::BaseType> frames_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::ListValueDataView, send_validation>(
        in_frames,
        frames_fragment);

      fragment->frames.Set(
          frames_fragment.is_null() ? nullptr : frames_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->frames.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frames in StatusData struct");

      decltype(Traits::cause(input)) in_cause = Traits::cause(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cause)::BaseType> cause_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::StatusDataDataView, send_validation>(
        in_cause,
        cause_fragment);

      fragment->cause.Set(
          cause_fragment.is_null() ? nullptr : cause_fragment.data());

      decltype(Traits::data(input)) in_data = Traits::data(input);
      mojo::internal::MessageFragment<decltype(fragment->data)>
          data_fragment(fragment.message());
      data_fragment.Claim(&fragment->data);
      
      mojo::internal::Serialize<::mojo_base::mojom::ValueDataView, send_validation>(
        in_data,
        data_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in StatusData struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::EncoderStatusDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::EncoderStatusDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::EncoderStatus_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::internal(input)) in_internal = Traits::internal(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->internal)::BaseType> internal_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::StatusDataDataView, send_validation>(
        in_internal,
        internal_fragment);

      fragment->internal.Set(
          internal_fragment.is_null() ? nullptr : internal_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::DecoderStatusDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::DecoderStatusDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::DecoderStatus_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::internal(input)) in_internal = Traits::internal(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->internal)::BaseType> internal_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::StatusDataDataView, send_validation>(
        in_internal,
        internal_fragment);

      fragment->internal.Set(
          internal_fragment.is_null() ? nullptr : internal_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::PipelineStatusDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::PipelineStatusDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::PipelineStatus_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::internal(input)) in_internal = Traits::internal(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->internal)::BaseType> internal_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::StatusDataDataView, send_validation>(
        in_internal,
        internal_fragment);

      fragment->internal.Set(
          internal_fragment.is_null() ? nullptr : internal_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::AutoPipInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::AutoPipInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::AutoPipInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::media::mojom::AutoPipReason>(
        Traits::auto_pip_reason(input),
        &fragment->auto_pip_reason);

      fragment->has_audio_focus = Traits::has_audio_focus(input);

      fragment->is_playing = Traits::is_playing(input);

      fragment->was_recently_audible = Traits::was_recently_audible(input);

      fragment->has_safe_url = Traits::has_safe_url(input);

      fragment->meets_media_engagement_conditions = Traits::meets_media_engagement_conditions(input);

      fragment->blocked_due_to_content_setting = Traits::blocked_due_to_content_setting(input);
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::DecoderBufferSideDataNextConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::media::mojom::DecoderBufferSideDataNextConfigDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::media::mojom::internal::DecoderBufferSideDataNextConfig_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::media::mojom::DecoderBufferSideDataNextConfigDataView::Tag::kNextAudioConfig: {
    decltype(Traits::next_audio_config(input))
    in_next_audio_config = Traits::next_audio_config(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_next_audio_config)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::media::mojom::AudioDecoderConfigDataView, send_validation>(
  in_next_audio_config,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null next_audio_config in DecoderBufferSideDataNextConfig union");
    fragment->data.f_next_audio_config.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::media::mojom::DecoderBufferSideDataNextConfigDataView::Tag::kNextVideoConfig: {
    decltype(Traits::next_video_config(input))
    in_next_video_config = Traits::next_video_config(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_next_video_config)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::media::mojom::VideoDecoderConfigDataView, send_validation>(
  in_next_video_config,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null next_video_config in DecoderBufferSideDataNextConfig union");
    fragment->data.f_next_video_config.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::DecoderBufferDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::media::mojom::DecoderBufferDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::media::mojom::internal::DecoderBuffer_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::media::mojom::DecoderBufferDataView::Tag::kEos: {
    decltype(Traits::eos(input))
    in_eos = Traits::eos(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_eos)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::media::mojom::EosDecoderBufferDataView, send_validation>(
  in_eos,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null eos in DecoderBuffer union");
    fragment->data.f_eos.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::media::mojom::DecoderBufferDataView::Tag::kData: {
    decltype(Traits::data(input))
    in_data = Traits::data(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_data)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::media::mojom::DataDecoderBufferDataView, send_validation>(
  in_data,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null data in DecoderBuffer union");
    fragment->data.f_data.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::VideoFrameDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::media::mojom::VideoFrameDataDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::media::mojom::internal::VideoFrameData_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::media::mojom::VideoFrameDataDataView::Tag::kEosData: {
    decltype(Traits::eos_data(input))
    in_eos_data = Traits::eos_data(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_eos_data)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::media::mojom::EosVideoFrameDataDataView, send_validation>(
  in_eos_data,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null eos_data in VideoFrameData union");
    fragment->data.f_eos_data.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::media::mojom::VideoFrameDataDataView::Tag::kSharedMemoryData: {
    decltype(Traits::shared_memory_data(input))
    in_shared_memory_data = Traits::shared_memory_data(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_shared_memory_data)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::media::mojom::SharedMemoryVideoFrameDataDataView, send_validation>(
  in_shared_memory_data,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null shared_memory_data in VideoFrameData union");
    fragment->data.f_shared_memory_data.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::media::mojom::VideoFrameDataDataView::Tag::kGpuMemoryBufferSharedImageData: {
    decltype(Traits::gpu_memory_buffer_shared_image_data(input))
    in_gpu_memory_buffer_shared_image_data = Traits::gpu_memory_buffer_shared_image_data(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_gpu_memory_buffer_shared_image_data)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::media::mojom::GpuMemoryBufferSharedImageVideoFrameDataDataView, send_validation>(
  in_gpu_memory_buffer_shared_image_data,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null gpu_memory_buffer_shared_image_data in VideoFrameData union");
    fragment->data.f_gpu_memory_buffer_shared_image_data.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::media::mojom::VideoFrameDataDataView::Tag::kSharedImageData: {
    decltype(Traits::shared_image_data(input))
    in_shared_image_data = Traits::shared_image_data(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_shared_image_data)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::media::mojom::SharedImageVideoFrameDataDataView, send_validation>(
  in_shared_image_data,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null shared_image_data in VideoFrameData union");
    fragment->data.f_shared_image_data.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::media::mojom::VideoFrameDataDataView::Tag::kOpaqueData: {
    decltype(Traits::opaque_data(input))
    in_opaque_data = Traits::opaque_data(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_opaque_data)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::media::mojom::OpaqueVideoFrameDataDataView, send_validation>(
  in_opaque_data,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null opaque_data in VideoFrameData union");
    fragment->data.f_opaque_data.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // MEDIA_MOJO_MOJOM_MEDIA_TYPES_MOJOM_SEND_VALIDATION_H_