// media/mojo/mojom/media_service.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_MEDIA_SERVICE_MOJOM_BLINK_H_
#define MEDIA_MOJO_MOJOM_MEDIA_SERVICE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/media_service.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/media_service.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/media_service.mojom-blink-forward.h"  // IWYU pragma: export
#include "media/mojo/mojom/frame_interface_factory.mojom-blink-forward.h"
#include "media/mojo/mojom/interface_factory.mojom-blink-forward.h"
#include "sandbox/policy/mojom/sandbox.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif



constexpr ::sandbox::mojom::blink::Sandbox kMediaSandbox = ::sandbox::mojom::blink::Sandbox::kGpu;


namespace media::mojom::blink {

class MediaServiceProxy;

template <typename ImplRefTraits>
class MediaServiceStub;

class MediaServiceRequestValidator;


class BLINK_PLATFORM_EXPORT MediaService
    : public MediaServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.MediaService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kGpu;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MediaServiceInterfaceBase;
  using Proxy_ = MediaServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaServiceStub<ImplRefTraits>;

  using RequestValidator_ = MediaServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateInterfaceFactoryMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateInterfaceFactory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MediaService() = default;

  virtual void CreateInterfaceFactory(::mojo::PendingReceiver<::media::mojom::blink::InterfaceFactory> factory, ::mojo::PendingRemote<::media::mojom::blink::FrameInterfaceFactory> frame_interfaces) = 0;
};



class BLINK_PLATFORM_EXPORT MediaServiceProxy
    : public MediaService {
 public:
  using InterfaceType = MediaService;

  explicit MediaServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateInterfaceFactory(::mojo::PendingReceiver<::media::mojom::blink::InterfaceFactory> factory, ::mojo::PendingRemote<::media::mojom::blink::FrameInterfaceFactory> frame_interfaces) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT MediaServiceStubDispatch {
 public:
  static bool Accept(MediaService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaService>>
class MediaServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaServiceStub() = default;
  ~MediaServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT MediaServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // media::mojom::blink

namespace mojo {

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_MEDIA_SERVICE_MOJOM_BLINK_H_