// media/mojo/mojom/encryption_pattern.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'media/mojo/mojom/encryption_pattern.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('media.mojom');



  function EncryptionPattern(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EncryptionPattern.prototype.initDefaults_ = function() {
    this.cryptByteBlock = 0;
    this.skipByteBlock = 0;
  };
  EncryptionPattern.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EncryptionPattern.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  EncryptionPattern.encodedSize = codec.kStructHeaderSize + 8;

  EncryptionPattern.decode = function(decoder) {
    var packed;
    var val = new EncryptionPattern();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.cryptByteBlock =
        decoder.decodeStruct(codec.Uint32);
    val.skipByteBlock =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  EncryptionPattern.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EncryptionPattern.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.cryptByteBlock);
    encoder.encodeStruct(codec.Uint32, val.skipByteBlock);
  };
  exports.EncryptionPattern = EncryptionPattern;
})();