// media/mojo/mojom/content_decryption_module.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/content_decryption_module.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/content_decryption_module.mojom-params-data.h"
#include "media/mojo/mojom/content_decryption_module.mojom-shared-message-ids.h"

#include "media/mojo/mojom/content_decryption_module.mojom-import-headers.h"
#include "media/mojo/mojom/content_decryption_module.mojom-test-utils.h"


namespace media::mojom {
CdmConfig::CdmConfig()
    : key_system(),
      allow_distinctive_identifier(),
      allow_persistent_state(),
      use_hw_secure_codecs() {}

CdmConfig::CdmConfig(
    const std::string& key_system_in,
    bool allow_distinctive_identifier_in,
    bool allow_persistent_state_in,
    bool use_hw_secure_codecs_in)
    : key_system(std::move(key_system_in)),
      allow_distinctive_identifier(std::move(allow_distinctive_identifier_in)),
      allow_persistent_state(std::move(allow_persistent_state_in)),
      use_hw_secure_codecs(std::move(use_hw_secure_codecs_in)) {}

CdmConfig::~CdmConfig() = default;

void CdmConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_system"), this->key_system,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_distinctive_identifier"), this->allow_distinctive_identifier,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_persistent_state"), this->allow_persistent_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "use_hw_secure_codecs"), this->use_hw_secure_codecs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CdmConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CdmPromiseResult::CdmPromiseResult()
    : success(),
      exception(),
      system_code(),
      error_message() {}

CdmPromiseResult::CdmPromiseResult(
    bool success_in,
    ::media::CdmPromise::Exception exception_in,
    uint32_t system_code_in,
    const std::string& error_message_in)
    : success(std::move(success_in)),
      exception(std::move(exception_in)),
      system_code(std::move(system_code_in)),
      error_message(std::move(error_message_in)) {}

CdmPromiseResult::~CdmPromiseResult() = default;

void CdmPromiseResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "success"), this->success,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "exception"), this->exception,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::CdmPromise::Exception>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "system_code"), this->system_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error_message"), this->error_message,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CdmPromiseResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CdmKeyInformation::CdmKeyInformation()
    : key_id(),
      status(),
      system_code() {}

CdmKeyInformation::CdmKeyInformation(
    std::vector<uint8_t> key_id_in,
    ::media::CdmKeyInformation::KeyStatus status_in,
    uint32_t system_code_in)
    : key_id(std::move(key_id_in)),
      status(std::move(status_in)),
      system_code(std::move(system_code_in)) {}

CdmKeyInformation::~CdmKeyInformation() = default;

void CdmKeyInformation::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_id"), this->key_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status"), this->status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::CdmKeyInformation::KeyStatus>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "system_code"), this->system_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CdmKeyInformation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CdmContext::CdmContext()
    : cdm_id(),
      decryptor() {}

CdmContext::CdmContext(
    const ::base::UnguessableToken& cdm_id_in,
    ::mojo::PendingRemote<::media::mojom::Decryptor> decryptor_in)
    : cdm_id(std::move(cdm_id_in)),
      decryptor(std::move(decryptor_in)) {}

CdmContext::~CdmContext() = default;

void CdmContext::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cdm_id"), this->cdm_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::UnguessableToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "decryptor"), this->decryptor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::media::mojom::Decryptor>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CdmContext::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ContentDecryptionModule::IPCStableHashFunction ContentDecryptionModule::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ContentDecryptionModule>(message.name())) {
    case messages::ContentDecryptionModule::kSetClient: {
      return &ContentDecryptionModule::SetClient_Sym::IPCStableHash;
    }
    case messages::ContentDecryptionModule::kSetServerCertificate: {
      return &ContentDecryptionModule::SetServerCertificate_Sym::IPCStableHash;
    }
    case messages::ContentDecryptionModule::kGetStatusForPolicy: {
      return &ContentDecryptionModule::GetStatusForPolicy_Sym::IPCStableHash;
    }
    case messages::ContentDecryptionModule::kCreateSessionAndGenerateRequest: {
      return &ContentDecryptionModule::CreateSessionAndGenerateRequest_Sym::IPCStableHash;
    }
    case messages::ContentDecryptionModule::kLoadSession: {
      return &ContentDecryptionModule::LoadSession_Sym::IPCStableHash;
    }
    case messages::ContentDecryptionModule::kUpdateSession: {
      return &ContentDecryptionModule::UpdateSession_Sym::IPCStableHash;
    }
    case messages::ContentDecryptionModule::kCloseSession: {
      return &ContentDecryptionModule::CloseSession_Sym::IPCStableHash;
    }
    case messages::ContentDecryptionModule::kRemoveSession: {
      return &ContentDecryptionModule::RemoveSession_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ContentDecryptionModule::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ContentDecryptionModule>(message.name())) {
      case messages::ContentDecryptionModule::kSetClient:
            return "Receive media::mojom::ContentDecryptionModule::SetClient";
      case messages::ContentDecryptionModule::kSetServerCertificate:
            return "Receive media::mojom::ContentDecryptionModule::SetServerCertificate";
      case messages::ContentDecryptionModule::kGetStatusForPolicy:
            return "Receive media::mojom::ContentDecryptionModule::GetStatusForPolicy";
      case messages::ContentDecryptionModule::kCreateSessionAndGenerateRequest:
            return "Receive media::mojom::ContentDecryptionModule::CreateSessionAndGenerateRequest";
      case messages::ContentDecryptionModule::kLoadSession:
            return "Receive media::mojom::ContentDecryptionModule::LoadSession";
      case messages::ContentDecryptionModule::kUpdateSession:
            return "Receive media::mojom::ContentDecryptionModule::UpdateSession";
      case messages::ContentDecryptionModule::kCloseSession:
            return "Receive media::mojom::ContentDecryptionModule::CloseSession";
      case messages::ContentDecryptionModule::kRemoveSession:
            return "Receive media::mojom::ContentDecryptionModule::RemoveSession";
    }
  } else {
    switch (static_cast<messages::ContentDecryptionModule>(message.name())) {
      case messages::ContentDecryptionModule::kSetClient:
            return "Receive reply media::mojom::ContentDecryptionModule::SetClient";
      case messages::ContentDecryptionModule::kSetServerCertificate:
            return "Receive reply media::mojom::ContentDecryptionModule::SetServerCertificate";
      case messages::ContentDecryptionModule::kGetStatusForPolicy:
            return "Receive reply media::mojom::ContentDecryptionModule::GetStatusForPolicy";
      case messages::ContentDecryptionModule::kCreateSessionAndGenerateRequest:
            return "Receive reply media::mojom::ContentDecryptionModule::CreateSessionAndGenerateRequest";
      case messages::ContentDecryptionModule::kLoadSession:
            return "Receive reply media::mojom::ContentDecryptionModule::LoadSession";
      case messages::ContentDecryptionModule::kUpdateSession:
            return "Receive reply media::mojom::ContentDecryptionModule::UpdateSession";
      case messages::ContentDecryptionModule::kCloseSession:
            return "Receive reply media::mojom::ContentDecryptionModule::CloseSession";
      case messages::ContentDecryptionModule::kRemoveSession:
            return "Receive reply media::mojom::ContentDecryptionModule::RemoveSession";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ContentDecryptionModule::SetClient_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc9c8df64;  // IPCStableHash for media::mojom::ContentDecryptionModule::SetClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ContentDecryptionModule::SetServerCertificate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x38dd6bd7;  // IPCStableHash for media::mojom::ContentDecryptionModule::SetServerCertificate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ContentDecryptionModule::GetStatusForPolicy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x89445846;  // IPCStableHash for media::mojom::ContentDecryptionModule::GetStatusForPolicy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ContentDecryptionModule::CreateSessionAndGenerateRequest_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x72710ca2;  // IPCStableHash for media::mojom::ContentDecryptionModule::CreateSessionAndGenerateRequest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ContentDecryptionModule::LoadSession_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x353e4cb0;  // IPCStableHash for media::mojom::ContentDecryptionModule::LoadSession
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ContentDecryptionModule::UpdateSession_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9d9c7493;  // IPCStableHash for media::mojom::ContentDecryptionModule::UpdateSession
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ContentDecryptionModule::CloseSession_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa6436ecd;  // IPCStableHash for media::mojom::ContentDecryptionModule::CloseSession
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ContentDecryptionModule::RemoveSession_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x84ab8cd2;  // IPCStableHash for media::mojom::ContentDecryptionModule::RemoveSession
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ContentDecryptionModule_SetServerCertificate_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ContentDecryptionModule_SetServerCertificate_ForwardToCallback(
      ContentDecryptionModule::SetServerCertificateCallback callback
      ) : callback_(std::move(callback)) {
  }

  ContentDecryptionModule_SetServerCertificate_ForwardToCallback(const ContentDecryptionModule_SetServerCertificate_ForwardToCallback&) = delete;
  ContentDecryptionModule_SetServerCertificate_ForwardToCallback& operator=(const ContentDecryptionModule_SetServerCertificate_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ContentDecryptionModule::SetServerCertificateCallback callback_;
};

class ContentDecryptionModule_GetStatusForPolicy_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ContentDecryptionModule_GetStatusForPolicy_ForwardToCallback(
      ContentDecryptionModule::GetStatusForPolicyCallback callback
      ) : callback_(std::move(callback)) {
  }

  ContentDecryptionModule_GetStatusForPolicy_ForwardToCallback(const ContentDecryptionModule_GetStatusForPolicy_ForwardToCallback&) = delete;
  ContentDecryptionModule_GetStatusForPolicy_ForwardToCallback& operator=(const ContentDecryptionModule_GetStatusForPolicy_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ContentDecryptionModule::GetStatusForPolicyCallback callback_;
};

class ContentDecryptionModule_CreateSessionAndGenerateRequest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ContentDecryptionModule_CreateSessionAndGenerateRequest_ForwardToCallback(
      ContentDecryptionModule::CreateSessionAndGenerateRequestCallback callback
      ) : callback_(std::move(callback)) {
  }

  ContentDecryptionModule_CreateSessionAndGenerateRequest_ForwardToCallback(const ContentDecryptionModule_CreateSessionAndGenerateRequest_ForwardToCallback&) = delete;
  ContentDecryptionModule_CreateSessionAndGenerateRequest_ForwardToCallback& operator=(const ContentDecryptionModule_CreateSessionAndGenerateRequest_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ContentDecryptionModule::CreateSessionAndGenerateRequestCallback callback_;
};

class ContentDecryptionModule_LoadSession_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ContentDecryptionModule_LoadSession_ForwardToCallback(
      ContentDecryptionModule::LoadSessionCallback callback
      ) : callback_(std::move(callback)) {
  }

  ContentDecryptionModule_LoadSession_ForwardToCallback(const ContentDecryptionModule_LoadSession_ForwardToCallback&) = delete;
  ContentDecryptionModule_LoadSession_ForwardToCallback& operator=(const ContentDecryptionModule_LoadSession_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ContentDecryptionModule::LoadSessionCallback callback_;
};

class ContentDecryptionModule_UpdateSession_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ContentDecryptionModule_UpdateSession_ForwardToCallback(
      ContentDecryptionModule::UpdateSessionCallback callback
      ) : callback_(std::move(callback)) {
  }

  ContentDecryptionModule_UpdateSession_ForwardToCallback(const ContentDecryptionModule_UpdateSession_ForwardToCallback&) = delete;
  ContentDecryptionModule_UpdateSession_ForwardToCallback& operator=(const ContentDecryptionModule_UpdateSession_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ContentDecryptionModule::UpdateSessionCallback callback_;
};

class ContentDecryptionModule_CloseSession_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ContentDecryptionModule_CloseSession_ForwardToCallback(
      ContentDecryptionModule::CloseSessionCallback callback
      ) : callback_(std::move(callback)) {
  }

  ContentDecryptionModule_CloseSession_ForwardToCallback(const ContentDecryptionModule_CloseSession_ForwardToCallback&) = delete;
  ContentDecryptionModule_CloseSession_ForwardToCallback& operator=(const ContentDecryptionModule_CloseSession_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ContentDecryptionModule::CloseSessionCallback callback_;
};

class ContentDecryptionModule_RemoveSession_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ContentDecryptionModule_RemoveSession_ForwardToCallback(
      ContentDecryptionModule::RemoveSessionCallback callback
      ) : callback_(std::move(callback)) {
  }

  ContentDecryptionModule_RemoveSession_ForwardToCallback(const ContentDecryptionModule_RemoveSession_ForwardToCallback&) = delete;
  ContentDecryptionModule_RemoveSession_ForwardToCallback& operator=(const ContentDecryptionModule_RemoveSession_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ContentDecryptionModule::RemoveSessionCallback callback_;
};

ContentDecryptionModuleProxy::ContentDecryptionModuleProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ContentDecryptionModuleProxy::SetClient(
    ::mojo::PendingAssociatedRemote<ContentDecryptionModuleClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::ContentDecryptionModule::SetClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<ContentDecryptionModuleClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentDecryptionModule::kSetClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::ContentDecryptionModule_SetClient_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::ContentDecryptionModuleClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in ContentDecryptionModule.SetClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModule::Name_);
  message.set_method_name("SetClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ContentDecryptionModuleProxy::SetServerCertificate(
    const std::vector<uint8_t>& in_certificate_data, SetServerCertificateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::ContentDecryptionModule::SetServerCertificate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("certificate_data"), in_certificate_data,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentDecryptionModule::kSetServerCertificate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::ContentDecryptionModule_SetServerCertificate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->certificate_data)::BaseType>
      certificate_data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& certificate_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_certificate_data,
    certificate_data_fragment,
    &certificate_data_validate_params);

  params->certificate_data.Set(
      certificate_data_fragment.is_null() ? nullptr : certificate_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->certificate_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null certificate_data in ContentDecryptionModule.SetServerCertificate request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModule::Name_);
  message.set_method_name("SetServerCertificate");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ContentDecryptionModule_SetServerCertificate_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ContentDecryptionModuleProxy::GetStatusForPolicy(
    ::media::HdcpVersion in_min_hdcp_version, GetStatusForPolicyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::ContentDecryptionModule::GetStatusForPolicy", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("min_hdcp_version"), in_min_hdcp_version,
                        "<value of type ::media::HdcpVersion>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentDecryptionModule::kGetStatusForPolicy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::ContentDecryptionModule_GetStatusForPolicy_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::HdcpVersion>(
    in_min_hdcp_version,
    &params->min_hdcp_version);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModule::Name_);
  message.set_method_name("GetStatusForPolicy");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ContentDecryptionModule_GetStatusForPolicy_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ContentDecryptionModuleProxy::CreateSessionAndGenerateRequest(
    ::media::CdmSessionType in_session_type, ::media::EmeInitDataType in_init_data_type, const std::vector<uint8_t>& in_init_data, CreateSessionAndGenerateRequestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::ContentDecryptionModule::CreateSessionAndGenerateRequest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_type"), in_session_type,
                        "<value of type ::media::CdmSessionType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("init_data_type"), in_init_data_type,
                        "<value of type ::media::EmeInitDataType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("init_data"), in_init_data,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentDecryptionModule::kCreateSessionAndGenerateRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::ContentDecryptionModule_CreateSessionAndGenerateRequest_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::CdmSessionType>(
    in_session_type,
    &params->session_type);

  
  mojo::internal::Serialize<::media::mojom::EmeInitDataType>(
    in_init_data_type,
    &params->init_data_type);
  mojo::internal::MessageFragment<
      typename decltype(params->init_data)::BaseType>
      init_data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& init_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_init_data,
    init_data_fragment,
    &init_data_validate_params);

  params->init_data.Set(
      init_data_fragment.is_null() ? nullptr : init_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->init_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null init_data in ContentDecryptionModule.CreateSessionAndGenerateRequest request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModule::Name_);
  message.set_method_name("CreateSessionAndGenerateRequest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ContentDecryptionModule_CreateSessionAndGenerateRequest_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ContentDecryptionModuleProxy::LoadSession(
    ::media::CdmSessionType in_session_type, const std::string& in_session_id, LoadSessionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::ContentDecryptionModule::LoadSession", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_type"), in_session_type,
                        "<value of type ::media::CdmSessionType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentDecryptionModule::kLoadSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::ContentDecryptionModule_LoadSession_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::CdmSessionType>(
    in_session_type,
    &params->session_type);
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_session_id,
    session_id_fragment);

  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session_id in ContentDecryptionModule.LoadSession request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModule::Name_);
  message.set_method_name("LoadSession");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ContentDecryptionModule_LoadSession_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ContentDecryptionModuleProxy::UpdateSession(
    const std::string& in_session_id, const std::vector<uint8_t>& in_response, UpdateSessionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::ContentDecryptionModule::UpdateSession", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response"), in_response,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentDecryptionModule::kUpdateSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::ContentDecryptionModule_UpdateSession_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_session_id,
    session_id_fragment);

  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session_id in ContentDecryptionModule.UpdateSession request");
  mojo::internal::MessageFragment<
      typename decltype(params->response)::BaseType>
      response_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& response_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_response,
    response_fragment,
    &response_validate_params);

  params->response.Set(
      response_fragment.is_null() ? nullptr : response_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->response.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null response in ContentDecryptionModule.UpdateSession request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModule::Name_);
  message.set_method_name("UpdateSession");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ContentDecryptionModule_UpdateSession_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ContentDecryptionModuleProxy::CloseSession(
    const std::string& in_session_id, CloseSessionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::ContentDecryptionModule::CloseSession", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentDecryptionModule::kCloseSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::ContentDecryptionModule_CloseSession_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_session_id,
    session_id_fragment);

  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session_id in ContentDecryptionModule.CloseSession request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModule::Name_);
  message.set_method_name("CloseSession");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ContentDecryptionModule_CloseSession_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ContentDecryptionModuleProxy::RemoveSession(
    const std::string& in_session_id, RemoveSessionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::ContentDecryptionModule::RemoveSession", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentDecryptionModule::kRemoveSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::ContentDecryptionModule_RemoveSession_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_session_id,
    session_id_fragment);

  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session_id in ContentDecryptionModule.RemoveSession request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModule::Name_);
  message.set_method_name("RemoveSession");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ContentDecryptionModule_RemoveSession_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ContentDecryptionModule_SetServerCertificate_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ContentDecryptionModule::SetServerCertificateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ContentDecryptionModule_SetServerCertificate_ProxyToResponder> proxy(
        new ContentDecryptionModule_SetServerCertificate_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ContentDecryptionModule_SetServerCertificate_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ContentDecryptionModule_SetServerCertificate_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ContentDecryptionModule_SetServerCertificate_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ContentDecryptionModule::SetServerCertificateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CdmPromiseResultPtr in_result);
};

bool ContentDecryptionModule_SetServerCertificate_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ContentDecryptionModule_SetServerCertificate_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ContentDecryptionModule_SetServerCertificate_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ContentDecryptionModule.1
  bool success = true;
  CdmPromiseResultPtr p_result{};
  ContentDecryptionModule_SetServerCertificate_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ContentDecryptionModule::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void ContentDecryptionModule_SetServerCertificate_ProxyToResponder::Run(
    CdmPromiseResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::ContentDecryptionModule::SetServerCertificate", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type CdmPromiseResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentDecryptionModule::kSetServerCertificate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::ContentDecryptionModule_SetServerCertificate_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::CdmPromiseResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModule::Name_);
  message.set_method_name("SetServerCertificate");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ContentDecryptionModule_GetStatusForPolicy_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ContentDecryptionModule::GetStatusForPolicyCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ContentDecryptionModule_GetStatusForPolicy_ProxyToResponder> proxy(
        new ContentDecryptionModule_GetStatusForPolicy_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ContentDecryptionModule_GetStatusForPolicy_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ContentDecryptionModule_GetStatusForPolicy_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ContentDecryptionModule_GetStatusForPolicy_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ContentDecryptionModule::GetStatusForPolicyCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CdmPromiseResultPtr in_result, ::media::CdmKeyInformation::KeyStatus in_key_status);
};

bool ContentDecryptionModule_GetStatusForPolicy_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ContentDecryptionModule_GetStatusForPolicy_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ContentDecryptionModule_GetStatusForPolicy_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ContentDecryptionModule.2
  bool success = true;
  CdmPromiseResultPtr p_result{};
  ::media::CdmKeyInformation::KeyStatus p_key_status{};
  ContentDecryptionModule_GetStatusForPolicy_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadKeyStatus(&p_key_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ContentDecryptionModule::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_key_status));
  }
  return true;
}

void ContentDecryptionModule_GetStatusForPolicy_ProxyToResponder::Run(
    CdmPromiseResultPtr in_result, ::media::CdmKeyInformation::KeyStatus in_key_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::ContentDecryptionModule::GetStatusForPolicy", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type CdmPromiseResultPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_status"), in_key_status,
                        "<value of type ::media::CdmKeyInformation::KeyStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentDecryptionModule::kGetStatusForPolicy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::ContentDecryptionModule_GetStatusForPolicy_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::CdmPromiseResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

  
  mojo::internal::Serialize<::media::mojom::CdmKeyStatus>(
    in_key_status,
    &params->key_status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModule::Name_);
  message.set_method_name("GetStatusForPolicy");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ContentDecryptionModule_CreateSessionAndGenerateRequest_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ContentDecryptionModule::CreateSessionAndGenerateRequestCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ContentDecryptionModule_CreateSessionAndGenerateRequest_ProxyToResponder> proxy(
        new ContentDecryptionModule_CreateSessionAndGenerateRequest_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ContentDecryptionModule_CreateSessionAndGenerateRequest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ContentDecryptionModule_CreateSessionAndGenerateRequest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ContentDecryptionModule_CreateSessionAndGenerateRequest_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ContentDecryptionModule::CreateSessionAndGenerateRequestCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CdmPromiseResultPtr in_result, const std::string& in_session_id);
};

bool ContentDecryptionModule_CreateSessionAndGenerateRequest_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ContentDecryptionModule.3
  bool success = true;
  CdmPromiseResultPtr p_result{};
  std::string p_session_id{};
  ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadSessionId(&p_session_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ContentDecryptionModule::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_session_id));
  }
  return true;
}

void ContentDecryptionModule_CreateSessionAndGenerateRequest_ProxyToResponder::Run(
    CdmPromiseResultPtr in_result, const std::string& in_session_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::ContentDecryptionModule::CreateSessionAndGenerateRequest", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type CdmPromiseResultPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentDecryptionModule::kCreateSessionAndGenerateRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::CdmPromiseResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_session_id,
    session_id_fragment);

  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session_id in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModule::Name_);
  message.set_method_name("CreateSessionAndGenerateRequest");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ContentDecryptionModule_LoadSession_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ContentDecryptionModule::LoadSessionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ContentDecryptionModule_LoadSession_ProxyToResponder> proxy(
        new ContentDecryptionModule_LoadSession_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ContentDecryptionModule_LoadSession_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ContentDecryptionModule_LoadSession_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ContentDecryptionModule_LoadSession_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ContentDecryptionModule::LoadSessionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CdmPromiseResultPtr in_result, const std::string& in_session_id);
};

bool ContentDecryptionModule_LoadSession_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ContentDecryptionModule_LoadSession_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ContentDecryptionModule_LoadSession_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ContentDecryptionModule.4
  bool success = true;
  CdmPromiseResultPtr p_result{};
  std::string p_session_id{};
  ContentDecryptionModule_LoadSession_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadSessionId(&p_session_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ContentDecryptionModule::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_session_id));
  }
  return true;
}

void ContentDecryptionModule_LoadSession_ProxyToResponder::Run(
    CdmPromiseResultPtr in_result, const std::string& in_session_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::ContentDecryptionModule::LoadSession", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type CdmPromiseResultPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentDecryptionModule::kLoadSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::ContentDecryptionModule_LoadSession_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::CdmPromiseResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_session_id,
    session_id_fragment);

  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session_id in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModule::Name_);
  message.set_method_name("LoadSession");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ContentDecryptionModule_UpdateSession_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ContentDecryptionModule::UpdateSessionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ContentDecryptionModule_UpdateSession_ProxyToResponder> proxy(
        new ContentDecryptionModule_UpdateSession_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ContentDecryptionModule_UpdateSession_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ContentDecryptionModule_UpdateSession_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ContentDecryptionModule_UpdateSession_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ContentDecryptionModule::UpdateSessionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CdmPromiseResultPtr in_result);
};

bool ContentDecryptionModule_UpdateSession_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ContentDecryptionModule_UpdateSession_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ContentDecryptionModule_UpdateSession_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ContentDecryptionModule.5
  bool success = true;
  CdmPromiseResultPtr p_result{};
  ContentDecryptionModule_UpdateSession_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ContentDecryptionModule::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void ContentDecryptionModule_UpdateSession_ProxyToResponder::Run(
    CdmPromiseResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::ContentDecryptionModule::UpdateSession", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type CdmPromiseResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentDecryptionModule::kUpdateSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::ContentDecryptionModule_UpdateSession_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::CdmPromiseResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModule::Name_);
  message.set_method_name("UpdateSession");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ContentDecryptionModule_CloseSession_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ContentDecryptionModule::CloseSessionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ContentDecryptionModule_CloseSession_ProxyToResponder> proxy(
        new ContentDecryptionModule_CloseSession_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ContentDecryptionModule_CloseSession_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ContentDecryptionModule_CloseSession_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ContentDecryptionModule_CloseSession_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ContentDecryptionModule::CloseSessionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CdmPromiseResultPtr in_result);
};

bool ContentDecryptionModule_CloseSession_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ContentDecryptionModule_CloseSession_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ContentDecryptionModule_CloseSession_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ContentDecryptionModule.6
  bool success = true;
  CdmPromiseResultPtr p_result{};
  ContentDecryptionModule_CloseSession_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ContentDecryptionModule::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void ContentDecryptionModule_CloseSession_ProxyToResponder::Run(
    CdmPromiseResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::ContentDecryptionModule::CloseSession", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type CdmPromiseResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentDecryptionModule::kCloseSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::ContentDecryptionModule_CloseSession_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::CdmPromiseResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModule::Name_);
  message.set_method_name("CloseSession");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ContentDecryptionModule_RemoveSession_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ContentDecryptionModule::RemoveSessionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ContentDecryptionModule_RemoveSession_ProxyToResponder> proxy(
        new ContentDecryptionModule_RemoveSession_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ContentDecryptionModule_RemoveSession_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ContentDecryptionModule_RemoveSession_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ContentDecryptionModule_RemoveSession_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ContentDecryptionModule::RemoveSessionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CdmPromiseResultPtr in_result);
};

bool ContentDecryptionModule_RemoveSession_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ContentDecryptionModule_RemoveSession_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ContentDecryptionModule_RemoveSession_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ContentDecryptionModule.7
  bool success = true;
  CdmPromiseResultPtr p_result{};
  ContentDecryptionModule_RemoveSession_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ContentDecryptionModule::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void ContentDecryptionModule_RemoveSession_ProxyToResponder::Run(
    CdmPromiseResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::ContentDecryptionModule::RemoveSession", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type CdmPromiseResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentDecryptionModule::kRemoveSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::ContentDecryptionModule_RemoveSession_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::CdmPromiseResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModule::Name_);
  message.set_method_name("RemoveSession");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ContentDecryptionModuleStubDispatch::Accept(
    ContentDecryptionModule* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ContentDecryptionModule>(message->header()->name)) {
    case messages::ContentDecryptionModule::kSetClient: {
      DCHECK(message->is_serialized());
      internal::ContentDecryptionModule_SetClient_Params_Data* params =
          reinterpret_cast<internal::ContentDecryptionModule_SetClient_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ContentDecryptionModule.0
      bool success = true;
      ::mojo::PendingAssociatedRemote<ContentDecryptionModuleClient> p_client{};
      ContentDecryptionModule_SetClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentDecryptionModule::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetClient(        
        std::move(p_client));
      return true;
    }
    case messages::ContentDecryptionModule::kSetServerCertificate: {
      break;
    }
    case messages::ContentDecryptionModule::kGetStatusForPolicy: {
      break;
    }
    case messages::ContentDecryptionModule::kCreateSessionAndGenerateRequest: {
      break;
    }
    case messages::ContentDecryptionModule::kLoadSession: {
      break;
    }
    case messages::ContentDecryptionModule::kUpdateSession: {
      break;
    }
    case messages::ContentDecryptionModule::kCloseSession: {
      break;
    }
    case messages::ContentDecryptionModule::kRemoveSession: {
      break;
    }
  }
  return false;
}

// static
bool ContentDecryptionModuleStubDispatch::AcceptWithResponder(
    ContentDecryptionModule* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ContentDecryptionModule>(message->header()->name)) {
    case messages::ContentDecryptionModule::kSetClient: {
      break;
    }
    case messages::ContentDecryptionModule::kSetServerCertificate: {
      internal::ContentDecryptionModule_SetServerCertificate_Params_Data* params =
          reinterpret_cast<
              internal::ContentDecryptionModule_SetServerCertificate_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ContentDecryptionModule.1
      bool success = true;
      std::vector<uint8_t> p_certificate_data{};
      ContentDecryptionModule_SetServerCertificate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCertificateData(&p_certificate_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentDecryptionModule::Name_, 1, false);
        return false;
      }
      auto callback =
          ContentDecryptionModule_SetServerCertificate_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetServerCertificate(        
        std::move(p_certificate_data), std::move(callback));
      return true;
    }
    case messages::ContentDecryptionModule::kGetStatusForPolicy: {
      internal::ContentDecryptionModule_GetStatusForPolicy_Params_Data* params =
          reinterpret_cast<
              internal::ContentDecryptionModule_GetStatusForPolicy_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ContentDecryptionModule.2
      bool success = true;
      ::media::HdcpVersion p_min_hdcp_version{};
      ContentDecryptionModule_GetStatusForPolicy_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMinHdcpVersion(&p_min_hdcp_version))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentDecryptionModule::Name_, 2, false);
        return false;
      }
      auto callback =
          ContentDecryptionModule_GetStatusForPolicy_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetStatusForPolicy(        
        std::move(p_min_hdcp_version), std::move(callback));
      return true;
    }
    case messages::ContentDecryptionModule::kCreateSessionAndGenerateRequest: {
      internal::ContentDecryptionModule_CreateSessionAndGenerateRequest_Params_Data* params =
          reinterpret_cast<
              internal::ContentDecryptionModule_CreateSessionAndGenerateRequest_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ContentDecryptionModule.3
      bool success = true;
      ::media::CdmSessionType p_session_type{};
      ::media::EmeInitDataType p_init_data_type{};
      std::vector<uint8_t> p_init_data{};
      ContentDecryptionModule_CreateSessionAndGenerateRequest_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSessionType(&p_session_type))
        success = false;
      if (success && !input_data_view.ReadInitDataType(&p_init_data_type))
        success = false;
      if (success && !input_data_view.ReadInitData(&p_init_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentDecryptionModule::Name_, 3, false);
        return false;
      }
      auto callback =
          ContentDecryptionModule_CreateSessionAndGenerateRequest_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateSessionAndGenerateRequest(        
        std::move(p_session_type), 
        std::move(p_init_data_type), 
        std::move(p_init_data), std::move(callback));
      return true;
    }
    case messages::ContentDecryptionModule::kLoadSession: {
      internal::ContentDecryptionModule_LoadSession_Params_Data* params =
          reinterpret_cast<
              internal::ContentDecryptionModule_LoadSession_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ContentDecryptionModule.4
      bool success = true;
      ::media::CdmSessionType p_session_type{};
      std::string p_session_id{};
      ContentDecryptionModule_LoadSession_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSessionType(&p_session_type))
        success = false;
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentDecryptionModule::Name_, 4, false);
        return false;
      }
      auto callback =
          ContentDecryptionModule_LoadSession_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LoadSession(        
        std::move(p_session_type), 
        std::move(p_session_id), std::move(callback));
      return true;
    }
    case messages::ContentDecryptionModule::kUpdateSession: {
      internal::ContentDecryptionModule_UpdateSession_Params_Data* params =
          reinterpret_cast<
              internal::ContentDecryptionModule_UpdateSession_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ContentDecryptionModule.5
      bool success = true;
      std::string p_session_id{};
      std::vector<uint8_t> p_response{};
      ContentDecryptionModule_UpdateSession_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (success && !input_data_view.ReadResponse(&p_response))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentDecryptionModule::Name_, 5, false);
        return false;
      }
      auto callback =
          ContentDecryptionModule_UpdateSession_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateSession(        
        std::move(p_session_id), 
        std::move(p_response), std::move(callback));
      return true;
    }
    case messages::ContentDecryptionModule::kCloseSession: {
      internal::ContentDecryptionModule_CloseSession_Params_Data* params =
          reinterpret_cast<
              internal::ContentDecryptionModule_CloseSession_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ContentDecryptionModule.6
      bool success = true;
      std::string p_session_id{};
      ContentDecryptionModule_CloseSession_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentDecryptionModule::Name_, 6, false);
        return false;
      }
      auto callback =
          ContentDecryptionModule_CloseSession_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseSession(        
        std::move(p_session_id), std::move(callback));
      return true;
    }
    case messages::ContentDecryptionModule::kRemoveSession: {
      internal::ContentDecryptionModule_RemoveSession_Params_Data* params =
          reinterpret_cast<
              internal::ContentDecryptionModule_RemoveSession_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ContentDecryptionModule.7
      bool success = true;
      std::string p_session_id{};
      ContentDecryptionModule_RemoveSession_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentDecryptionModule::Name_, 7, false);
        return false;
      }
      auto callback =
          ContentDecryptionModule_RemoveSession_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveSession(        
        std::move(p_session_id), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kContentDecryptionModuleValidationInfo[] = {
    { &internal::ContentDecryptionModule_SetClient_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ContentDecryptionModule_SetServerCertificate_Params_Data::Validate,
     &internal::ContentDecryptionModule_SetServerCertificate_ResponseParams_Data::Validate},
    { &internal::ContentDecryptionModule_GetStatusForPolicy_Params_Data::Validate,
     &internal::ContentDecryptionModule_GetStatusForPolicy_ResponseParams_Data::Validate},
    { &internal::ContentDecryptionModule_CreateSessionAndGenerateRequest_Params_Data::Validate,
     &internal::ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParams_Data::Validate},
    { &internal::ContentDecryptionModule_LoadSession_Params_Data::Validate,
     &internal::ContentDecryptionModule_LoadSession_ResponseParams_Data::Validate},
    { &internal::ContentDecryptionModule_UpdateSession_Params_Data::Validate,
     &internal::ContentDecryptionModule_UpdateSession_ResponseParams_Data::Validate},
    { &internal::ContentDecryptionModule_CloseSession_Params_Data::Validate,
     &internal::ContentDecryptionModule_CloseSession_ResponseParams_Data::Validate},
    { &internal::ContentDecryptionModule_RemoveSession_Params_Data::Validate,
     &internal::ContentDecryptionModule_RemoveSession_ResponseParams_Data::Validate},
};

bool ContentDecryptionModuleRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::ContentDecryptionModule::Name_,
    kContentDecryptionModuleValidationInfo);
}

bool ContentDecryptionModuleResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::media::mojom::ContentDecryptionModule::Name_,
    kContentDecryptionModuleValidationInfo);
}
// The declaration includes the definition on other builds.

ContentDecryptionModuleClient::IPCStableHashFunction ContentDecryptionModuleClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ContentDecryptionModuleClient>(message.name())) {
    case messages::ContentDecryptionModuleClient::kOnSessionMessage: {
      return &ContentDecryptionModuleClient::OnSessionMessage_Sym::IPCStableHash;
    }
    case messages::ContentDecryptionModuleClient::kOnSessionClosed: {
      return &ContentDecryptionModuleClient::OnSessionClosed_Sym::IPCStableHash;
    }
    case messages::ContentDecryptionModuleClient::kOnSessionKeysChange: {
      return &ContentDecryptionModuleClient::OnSessionKeysChange_Sym::IPCStableHash;
    }
    case messages::ContentDecryptionModuleClient::kOnSessionExpirationUpdate: {
      return &ContentDecryptionModuleClient::OnSessionExpirationUpdate_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ContentDecryptionModuleClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ContentDecryptionModuleClient>(message.name())) {
      case messages::ContentDecryptionModuleClient::kOnSessionMessage:
            return "Receive media::mojom::ContentDecryptionModuleClient::OnSessionMessage";
      case messages::ContentDecryptionModuleClient::kOnSessionClosed:
            return "Receive media::mojom::ContentDecryptionModuleClient::OnSessionClosed";
      case messages::ContentDecryptionModuleClient::kOnSessionKeysChange:
            return "Receive media::mojom::ContentDecryptionModuleClient::OnSessionKeysChange";
      case messages::ContentDecryptionModuleClient::kOnSessionExpirationUpdate:
            return "Receive media::mojom::ContentDecryptionModuleClient::OnSessionExpirationUpdate";
    }
  } else {
    switch (static_cast<messages::ContentDecryptionModuleClient>(message.name())) {
      case messages::ContentDecryptionModuleClient::kOnSessionMessage:
            return "Receive reply media::mojom::ContentDecryptionModuleClient::OnSessionMessage";
      case messages::ContentDecryptionModuleClient::kOnSessionClosed:
            return "Receive reply media::mojom::ContentDecryptionModuleClient::OnSessionClosed";
      case messages::ContentDecryptionModuleClient::kOnSessionKeysChange:
            return "Receive reply media::mojom::ContentDecryptionModuleClient::OnSessionKeysChange";
      case messages::ContentDecryptionModuleClient::kOnSessionExpirationUpdate:
            return "Receive reply media::mojom::ContentDecryptionModuleClient::OnSessionExpirationUpdate";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ContentDecryptionModuleClient::OnSessionMessage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe03b3f9c;  // IPCStableHash for media::mojom::ContentDecryptionModuleClient::OnSessionMessage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ContentDecryptionModuleClient::OnSessionClosed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7e57acd6;  // IPCStableHash for media::mojom::ContentDecryptionModuleClient::OnSessionClosed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ContentDecryptionModuleClient::OnSessionKeysChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa7b36196;  // IPCStableHash for media::mojom::ContentDecryptionModuleClient::OnSessionKeysChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ContentDecryptionModuleClient::OnSessionExpirationUpdate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdd8501cd;  // IPCStableHash for media::mojom::ContentDecryptionModuleClient::OnSessionExpirationUpdate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ContentDecryptionModuleClientProxy::ContentDecryptionModuleClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ContentDecryptionModuleClientProxy::OnSessionMessage(
    const std::string& in_session_id, ::media::CdmMessageType in_message_type, const std::vector<uint8_t>& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::ContentDecryptionModuleClient::OnSessionMessage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message_type"), in_message_type,
                        "<value of type ::media::CdmMessageType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentDecryptionModuleClient::kOnSessionMessage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::ContentDecryptionModuleClient_OnSessionMessage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_session_id,
    session_id_fragment);

  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session_id in ContentDecryptionModuleClient.OnSessionMessage request");

  
  mojo::internal::Serialize<::media::mojom::CdmMessageType>(
    in_message_type,
    &params->message_type);
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType>
      message_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_message,
    message_fragment,
    &message_validate_params);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in ContentDecryptionModuleClient.OnSessionMessage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModuleClient::Name_);
  message.set_method_name("OnSessionMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ContentDecryptionModuleClientProxy::OnSessionClosed(
    const std::string& in_session_id, ::media::CdmSessionClosedReason in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::ContentDecryptionModuleClient::OnSessionClosed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type ::media::CdmSessionClosedReason>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentDecryptionModuleClient::kOnSessionClosed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::ContentDecryptionModuleClient_OnSessionClosed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_session_id,
    session_id_fragment);

  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session_id in ContentDecryptionModuleClient.OnSessionClosed request");

  
  mojo::internal::Serialize<::media::mojom::CdmSessionClosedReason>(
    in_reason,
    &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModuleClient::Name_);
  message.set_method_name("OnSessionClosed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ContentDecryptionModuleClientProxy::OnSessionKeysChange(
    const std::string& in_session_id, bool in_has_additional_usable_key, std::vector<::std::unique_ptr<::media::CdmKeyInformation>> in_keys_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::ContentDecryptionModuleClient::OnSessionKeysChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_additional_usable_key"), in_has_additional_usable_key,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("keys_info"), in_keys_info,
                        "<value of type std::vector<::std::unique_ptr<::media::CdmKeyInformation>>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentDecryptionModuleClient::kOnSessionKeysChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::ContentDecryptionModuleClient_OnSessionKeysChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_session_id,
    session_id_fragment);

  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session_id in ContentDecryptionModuleClient.OnSessionKeysChange request");

  params->has_additional_usable_key = in_has_additional_usable_key;
  mojo::internal::MessageFragment<
      typename decltype(params->keys_info)::BaseType>
      keys_info_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& keys_info_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::CdmKeyInformationDataView>>(
    in_keys_info,
    keys_info_fragment,
    &keys_info_validate_params);

  params->keys_info.Set(
      keys_info_fragment.is_null() ? nullptr : keys_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->keys_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null keys_info in ContentDecryptionModuleClient.OnSessionKeysChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModuleClient::Name_);
  message.set_method_name("OnSessionKeysChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ContentDecryptionModuleClientProxy::OnSessionExpirationUpdate(
    const std::string& in_session_id, double in_new_expiry_time_sec) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::ContentDecryptionModuleClient::OnSessionExpirationUpdate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_expiry_time_sec"), in_new_expiry_time_sec,
                        "<value of type double>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentDecryptionModuleClient::kOnSessionExpirationUpdate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::ContentDecryptionModuleClient_OnSessionExpirationUpdate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_session_id,
    session_id_fragment);

  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session_id in ContentDecryptionModuleClient.OnSessionExpirationUpdate request");

  params->new_expiry_time_sec = in_new_expiry_time_sec;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentDecryptionModuleClient::Name_);
  message.set_method_name("OnSessionExpirationUpdate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ContentDecryptionModuleClientStubDispatch::Accept(
    ContentDecryptionModuleClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ContentDecryptionModuleClient>(message->header()->name)) {
    case messages::ContentDecryptionModuleClient::kOnSessionMessage: {
      DCHECK(message->is_serialized());
      internal::ContentDecryptionModuleClient_OnSessionMessage_Params_Data* params =
          reinterpret_cast<internal::ContentDecryptionModuleClient_OnSessionMessage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ContentDecryptionModuleClient.0
      bool success = true;
      std::string p_session_id{};
      ::media::CdmMessageType p_message_type{};
      std::vector<uint8_t> p_message{};
      ContentDecryptionModuleClient_OnSessionMessage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (success && !input_data_view.ReadMessageType(&p_message_type))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentDecryptionModuleClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSessionMessage(        
        std::move(p_session_id), 
        std::move(p_message_type), 
        std::move(p_message));
      return true;
    }
    case messages::ContentDecryptionModuleClient::kOnSessionClosed: {
      DCHECK(message->is_serialized());
      internal::ContentDecryptionModuleClient_OnSessionClosed_Params_Data* params =
          reinterpret_cast<internal::ContentDecryptionModuleClient_OnSessionClosed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ContentDecryptionModuleClient.1
      bool success = true;
      std::string p_session_id{};
      ::media::CdmSessionClosedReason p_reason{};
      ContentDecryptionModuleClient_OnSessionClosed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentDecryptionModuleClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSessionClosed(        
        std::move(p_session_id), 
        std::move(p_reason));
      return true;
    }
    case messages::ContentDecryptionModuleClient::kOnSessionKeysChange: {
      DCHECK(message->is_serialized());
      internal::ContentDecryptionModuleClient_OnSessionKeysChange_Params_Data* params =
          reinterpret_cast<internal::ContentDecryptionModuleClient_OnSessionKeysChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ContentDecryptionModuleClient.2
      bool success = true;
      std::string p_session_id{};
      bool p_has_additional_usable_key{};
      std::vector<::std::unique_ptr<::media::CdmKeyInformation>> p_keys_info{};
      ContentDecryptionModuleClient_OnSessionKeysChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (success)
        p_has_additional_usable_key = input_data_view.has_additional_usable_key();
      if (success && !input_data_view.ReadKeysInfo(&p_keys_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentDecryptionModuleClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSessionKeysChange(        
        std::move(p_session_id), 
        std::move(p_has_additional_usable_key), 
        std::move(p_keys_info));
      return true;
    }
    case messages::ContentDecryptionModuleClient::kOnSessionExpirationUpdate: {
      DCHECK(message->is_serialized());
      internal::ContentDecryptionModuleClient_OnSessionExpirationUpdate_Params_Data* params =
          reinterpret_cast<internal::ContentDecryptionModuleClient_OnSessionExpirationUpdate_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ContentDecryptionModuleClient.3
      bool success = true;
      std::string p_session_id{};
      double p_new_expiry_time_sec{};
      ContentDecryptionModuleClient_OnSessionExpirationUpdate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (success)
        p_new_expiry_time_sec = input_data_view.new_expiry_time_sec();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentDecryptionModuleClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSessionExpirationUpdate(        
        std::move(p_session_id), 
        std::move(p_new_expiry_time_sec));
      return true;
    }
  }
  return false;
}

// static
bool ContentDecryptionModuleClientStubDispatch::AcceptWithResponder(
    ContentDecryptionModuleClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ContentDecryptionModuleClient>(message->header()->name)) {
    case messages::ContentDecryptionModuleClient::kOnSessionMessage: {
      break;
    }
    case messages::ContentDecryptionModuleClient::kOnSessionClosed: {
      break;
    }
    case messages::ContentDecryptionModuleClient::kOnSessionKeysChange: {
      break;
    }
    case messages::ContentDecryptionModuleClient::kOnSessionExpirationUpdate: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kContentDecryptionModuleClientValidationInfo[] = {
    { &internal::ContentDecryptionModuleClient_OnSessionMessage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ContentDecryptionModuleClient_OnSessionClosed_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ContentDecryptionModuleClient_OnSessionKeysChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ContentDecryptionModuleClient_OnSessionExpirationUpdate_Params_Data::Validate,
     nullptr /* no response */},
};

bool ContentDecryptionModuleClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::ContentDecryptionModuleClient::Name_,
    kContentDecryptionModuleClientValidationInfo);
}

// The declaration includes the definition on other builds.

CdmFactory::IPCStableHashFunction CdmFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CdmFactory>(message.name())) {
    case messages::CdmFactory::kCreateCdm: {
      return &CdmFactory::CreateCdm_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CdmFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CdmFactory>(message.name())) {
      case messages::CdmFactory::kCreateCdm:
            return "Receive media::mojom::CdmFactory::CreateCdm";
    }
  } else {
    switch (static_cast<messages::CdmFactory>(message.name())) {
      case messages::CdmFactory::kCreateCdm:
            return "Receive reply media::mojom::CdmFactory::CreateCdm";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CdmFactory::CreateCdm_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4d44217f;  // IPCStableHash for media::mojom::CdmFactory::CreateCdm
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class CdmFactory_CreateCdm_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CdmFactory_CreateCdm_ForwardToCallback(
      CdmFactory::CreateCdmCallback callback
      ) : callback_(std::move(callback)) {
  }

  CdmFactory_CreateCdm_ForwardToCallback(const CdmFactory_CreateCdm_ForwardToCallback&) = delete;
  CdmFactory_CreateCdm_ForwardToCallback& operator=(const CdmFactory_CreateCdm_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CdmFactory::CreateCdmCallback callback_;
};

CdmFactoryProxy::CdmFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CdmFactoryProxy::CreateCdm(
    const ::media::CdmConfig& in_cdm_config, CreateCdmCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::CdmFactory::CreateCdm", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cdm_config"), in_cdm_config,
                        "<value of type const ::media::CdmConfig&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CdmFactory::kCreateCdm), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmFactory_CreateCdm_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cdm_config)::BaseType> cdm_config_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::CdmConfigDataView>(
    in_cdm_config,
    cdm_config_fragment);

  params->cdm_config.Set(
      cdm_config_fragment.is_null() ? nullptr : cdm_config_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cdm_config.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cdm_config in CdmFactory.CreateCdm request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmFactory::Name_);
  message.set_method_name("CreateCdm");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CdmFactory_CreateCdm_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class CdmFactory_CreateCdm_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CdmFactory::CreateCdmCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CdmFactory_CreateCdm_ProxyToResponder> proxy(
        new CdmFactory_CreateCdm_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CdmFactory_CreateCdm_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CdmFactory_CreateCdm_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CdmFactory_CreateCdm_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CdmFactory::CreateCdmCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingRemote<ContentDecryptionModule> in_cdm, CdmContextPtr in_cdm_context, ::media::CreateCdmStatus in_status);
};

bool CdmFactory_CreateCdm_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CdmFactory_CreateCdm_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CdmFactory_CreateCdm_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CdmFactory.0
  bool success = true;
  ::mojo::PendingRemote<ContentDecryptionModule> p_cdm{};
  CdmContextPtr p_cdm_context{};
  ::media::CreateCdmStatus p_status{};
  CdmFactory_CreateCdm_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_cdm =
        input_data_view.TakeCdm<decltype(p_cdm)>();
  }
  if (success && !input_data_view.ReadCdmContext(&p_cdm_context))
    success = false;
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CdmFactory::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_cdm), 
std::move(p_cdm_context), 
std::move(p_status));
  }
  return true;
}

void CdmFactory_CreateCdm_ProxyToResponder::Run(
    ::mojo::PendingRemote<ContentDecryptionModule> in_cdm, CdmContextPtr in_cdm_context, ::media::CreateCdmStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::CdmFactory::CreateCdm", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cdm"), in_cdm,
                        "<value of type ::mojo::PendingRemote<ContentDecryptionModule>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cdm_context"), in_cdm_context,
                        "<value of type CdmContextPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::media::CreateCdmStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CdmFactory::kCreateCdm), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmFactory_CreateCdm_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::ContentDecryptionModuleInterfaceBase>>(
    in_cdm,
    &params->cdm,
    &params.message());
  mojo::internal::MessageFragment<
      typename decltype(params->cdm_context)::BaseType> cdm_context_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::CdmContextDataView>(
    in_cdm_context,
    cdm_context_fragment);

  params->cdm_context.Set(
      cdm_context_fragment.is_null() ? nullptr : cdm_context_fragment.data());

  
  mojo::internal::Serialize<::media::mojom::CreateCdmStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmFactory::Name_);
  message.set_method_name("CreateCdm");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CdmFactoryStubDispatch::Accept(
    CdmFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CdmFactory>(message->header()->name)) {
    case messages::CdmFactory::kCreateCdm: {
      break;
    }
  }
  return false;
}

// static
bool CdmFactoryStubDispatch::AcceptWithResponder(
    CdmFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CdmFactory>(message->header()->name)) {
    case messages::CdmFactory::kCreateCdm: {
      internal::CdmFactory_CreateCdm_Params_Data* params =
          reinterpret_cast<
              internal::CdmFactory_CreateCdm_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CdmFactory.0
      bool success = true;
      ::media::CdmConfig p_cdm_config{};
      CdmFactory_CreateCdm_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCdmConfig(&p_cdm_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CdmFactory::Name_, 0, false);
        return false;
      }
      auto callback =
          CdmFactory_CreateCdm_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateCdm(        
        std::move(p_cdm_config), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCdmFactoryValidationInfo[] = {
    { &internal::CdmFactory_CreateCdm_Params_Data::Validate,
     &internal::CdmFactory_CreateCdm_ResponseParams_Data::Validate},
};

bool CdmFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::CdmFactory::Name_,
    kCdmFactoryValidationInfo);
}

bool CdmFactoryResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::media::mojom::CdmFactory::Name_,
    kCdmFactoryValidationInfo);
}


}  // media::mojom


namespace mojo {


// static
bool StructTraits<::media::mojom::CdmConfig::DataView, ::media::mojom::CdmConfigPtr>::Read(
    ::media::mojom::CdmConfig::DataView input,
    ::media::mojom::CdmConfigPtr* output) {
  bool success = true;
  ::media::mojom::CdmConfigPtr result(::media::mojom::CdmConfig::New());
  
      if (success && !input.ReadKeySystem(&result->key_system))
        success = false;
      if (success)
        result->allow_distinctive_identifier = input.allow_distinctive_identifier();
      if (success)
        result->allow_persistent_state = input.allow_persistent_state();
      if (success)
        result->use_hw_secure_codecs = input.use_hw_secure_codecs();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::CdmPromiseResult::DataView, ::media::mojom::CdmPromiseResultPtr>::Read(
    ::media::mojom::CdmPromiseResult::DataView input,
    ::media::mojom::CdmPromiseResultPtr* output) {
  bool success = true;
  ::media::mojom::CdmPromiseResultPtr result(::media::mojom::CdmPromiseResult::New());
  
      if (success)
        result->success = input.success();
      if (success && !input.ReadException(&result->exception))
        success = false;
      if (success)
        result->system_code = input.system_code();
      if (success && !input.ReadErrorMessage(&result->error_message))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::CdmKeyInformation::DataView, ::media::mojom::CdmKeyInformationPtr>::Read(
    ::media::mojom::CdmKeyInformation::DataView input,
    ::media::mojom::CdmKeyInformationPtr* output) {
  bool success = true;
  ::media::mojom::CdmKeyInformationPtr result(::media::mojom::CdmKeyInformation::New());
  
      if (success && !input.ReadKeyId(&result->key_id))
        success = false;
      if (success && !input.ReadStatus(&result->status))
        success = false;
      if (success)
        result->system_code = input.system_code();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::CdmContext::DataView, ::media::mojom::CdmContextPtr>::Read(
    ::media::mojom::CdmContext::DataView input,
    ::media::mojom::CdmContextPtr* output) {
  bool success = true;
  ::media::mojom::CdmContextPtr result(::media::mojom::CdmContext::New());
  
      if (success && !input.ReadCdmId(&result->cdm_id))
        success = false;
      if (success) {
        result->decryptor =
            input.TakeDecryptor<decltype(result->decryptor)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom {


void ContentDecryptionModuleInterceptorForTesting::SetClient(::mojo::PendingAssociatedRemote<ContentDecryptionModuleClient> client) {
  GetForwardingInterface()->SetClient(
    std::move(client)
    );
}
void ContentDecryptionModuleInterceptorForTesting::SetServerCertificate(const std::vector<uint8_t>& certificate_data, SetServerCertificateCallback callback) {
  GetForwardingInterface()->SetServerCertificate(
    std::move(certificate_data)
    , std::move(callback));
}
void ContentDecryptionModuleInterceptorForTesting::GetStatusForPolicy(::media::HdcpVersion min_hdcp_version, GetStatusForPolicyCallback callback) {
  GetForwardingInterface()->GetStatusForPolicy(
    std::move(min_hdcp_version)
    , std::move(callback));
}
void ContentDecryptionModuleInterceptorForTesting::CreateSessionAndGenerateRequest(::media::CdmSessionType session_type, ::media::EmeInitDataType init_data_type, const std::vector<uint8_t>& init_data, CreateSessionAndGenerateRequestCallback callback) {
  GetForwardingInterface()->CreateSessionAndGenerateRequest(
    std::move(session_type)
    , 
    std::move(init_data_type)
    , 
    std::move(init_data)
    , std::move(callback));
}
void ContentDecryptionModuleInterceptorForTesting::LoadSession(::media::CdmSessionType session_type, const std::string& session_id, LoadSessionCallback callback) {
  GetForwardingInterface()->LoadSession(
    std::move(session_type)
    , 
    std::move(session_id)
    , std::move(callback));
}
void ContentDecryptionModuleInterceptorForTesting::UpdateSession(const std::string& session_id, const std::vector<uint8_t>& response, UpdateSessionCallback callback) {
  GetForwardingInterface()->UpdateSession(
    std::move(session_id)
    , 
    std::move(response)
    , std::move(callback));
}
void ContentDecryptionModuleInterceptorForTesting::CloseSession(const std::string& session_id, CloseSessionCallback callback) {
  GetForwardingInterface()->CloseSession(
    std::move(session_id)
    , std::move(callback));
}
void ContentDecryptionModuleInterceptorForTesting::RemoveSession(const std::string& session_id, RemoveSessionCallback callback) {
  GetForwardingInterface()->RemoveSession(
    std::move(session_id)
    , std::move(callback));
}
ContentDecryptionModuleAsyncWaiter::ContentDecryptionModuleAsyncWaiter(
    ContentDecryptionModule* proxy) : proxy_(proxy) {}

ContentDecryptionModuleAsyncWaiter::~ContentDecryptionModuleAsyncWaiter() = default;


void ContentDecryptionModuleAsyncWaiter::SetServerCertificate(
    const std::vector<uint8_t>& certificate_data, CdmPromiseResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->SetServerCertificate(
      std::move(certificate_data),
      base::BindOnce(
          [](base::RunLoop* loop,
             CdmPromiseResultPtr* out_result
,
             CdmPromiseResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

CdmPromiseResultPtr ContentDecryptionModuleAsyncWaiter::SetServerCertificate(
    const std::vector<uint8_t>& certificate_data) {
  CdmPromiseResultPtr async_wait_result;
  SetServerCertificate(std::move(certificate_data),&async_wait_result);
  return async_wait_result;
}

void ContentDecryptionModuleAsyncWaiter::GetStatusForPolicy(
    ::media::HdcpVersion min_hdcp_version, CdmPromiseResultPtr* out_result, ::media::CdmKeyInformation::KeyStatus* out_key_status) {
  base::RunLoop loop;
  proxy_->GetStatusForPolicy(
      std::move(min_hdcp_version),
      base::BindOnce(
          [](base::RunLoop* loop,
             CdmPromiseResultPtr* out_result
,
             ::media::CdmKeyInformation::KeyStatus* out_key_status
,
             CdmPromiseResultPtr result,
             ::media::CdmKeyInformation::KeyStatus key_status) {*out_result = std::move(result);*out_key_status = std::move(key_status);
            loop->Quit();
          },
          &loop,
          out_result,
          out_key_status));
  loop.Run();
}



void ContentDecryptionModuleAsyncWaiter::CreateSessionAndGenerateRequest(
    ::media::CdmSessionType session_type, ::media::EmeInitDataType init_data_type, const std::vector<uint8_t>& init_data, CdmPromiseResultPtr* out_result, std::string* out_session_id) {
  base::RunLoop loop;
  proxy_->CreateSessionAndGenerateRequest(
      std::move(session_type),
      std::move(init_data_type),
      std::move(init_data),
      base::BindOnce(
          [](base::RunLoop* loop,
             CdmPromiseResultPtr* out_result
,
             std::string* out_session_id
,
             CdmPromiseResultPtr result,
             const std::string& session_id) {*out_result = std::move(result);*out_session_id = std::move(session_id);
            loop->Quit();
          },
          &loop,
          out_result,
          out_session_id));
  loop.Run();
}



void ContentDecryptionModuleAsyncWaiter::LoadSession(
    ::media::CdmSessionType session_type, const std::string& session_id, CdmPromiseResultPtr* out_result, std::string* out_session_id) {
  base::RunLoop loop;
  proxy_->LoadSession(
      std::move(session_type),
      std::move(session_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             CdmPromiseResultPtr* out_result
,
             std::string* out_session_id
,
             CdmPromiseResultPtr result,
             const std::string& session_id) {*out_result = std::move(result);*out_session_id = std::move(session_id);
            loop->Quit();
          },
          &loop,
          out_result,
          out_session_id));
  loop.Run();
}



void ContentDecryptionModuleAsyncWaiter::UpdateSession(
    const std::string& session_id, const std::vector<uint8_t>& response, CdmPromiseResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->UpdateSession(
      std::move(session_id),
      std::move(response),
      base::BindOnce(
          [](base::RunLoop* loop,
             CdmPromiseResultPtr* out_result
,
             CdmPromiseResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

CdmPromiseResultPtr ContentDecryptionModuleAsyncWaiter::UpdateSession(
    const std::string& session_id, const std::vector<uint8_t>& response) {
  CdmPromiseResultPtr async_wait_result;
  UpdateSession(std::move(session_id),std::move(response),&async_wait_result);
  return async_wait_result;
}

void ContentDecryptionModuleAsyncWaiter::CloseSession(
    const std::string& session_id, CdmPromiseResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->CloseSession(
      std::move(session_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             CdmPromiseResultPtr* out_result
,
             CdmPromiseResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

CdmPromiseResultPtr ContentDecryptionModuleAsyncWaiter::CloseSession(
    const std::string& session_id) {
  CdmPromiseResultPtr async_wait_result;
  CloseSession(std::move(session_id),&async_wait_result);
  return async_wait_result;
}

void ContentDecryptionModuleAsyncWaiter::RemoveSession(
    const std::string& session_id, CdmPromiseResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->RemoveSession(
      std::move(session_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             CdmPromiseResultPtr* out_result
,
             CdmPromiseResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

CdmPromiseResultPtr ContentDecryptionModuleAsyncWaiter::RemoveSession(
    const std::string& session_id) {
  CdmPromiseResultPtr async_wait_result;
  RemoveSession(std::move(session_id),&async_wait_result);
  return async_wait_result;
}




void ContentDecryptionModuleClientInterceptorForTesting::OnSessionMessage(const std::string& session_id, ::media::CdmMessageType message_type, const std::vector<uint8_t>& message) {
  GetForwardingInterface()->OnSessionMessage(
    std::move(session_id)
    , 
    std::move(message_type)
    , 
    std::move(message)
    );
}
void ContentDecryptionModuleClientInterceptorForTesting::OnSessionClosed(const std::string& session_id, ::media::CdmSessionClosedReason reason) {
  GetForwardingInterface()->OnSessionClosed(
    std::move(session_id)
    , 
    std::move(reason)
    );
}
void ContentDecryptionModuleClientInterceptorForTesting::OnSessionKeysChange(const std::string& session_id, bool has_additional_usable_key, std::vector<::std::unique_ptr<::media::CdmKeyInformation>> keys_info) {
  GetForwardingInterface()->OnSessionKeysChange(
    std::move(session_id)
    , 
    std::move(has_additional_usable_key)
    , 
    std::move(keys_info)
    );
}
void ContentDecryptionModuleClientInterceptorForTesting::OnSessionExpirationUpdate(const std::string& session_id, double new_expiry_time_sec) {
  GetForwardingInterface()->OnSessionExpirationUpdate(
    std::move(session_id)
    , 
    std::move(new_expiry_time_sec)
    );
}
ContentDecryptionModuleClientAsyncWaiter::ContentDecryptionModuleClientAsyncWaiter(
    ContentDecryptionModuleClient* proxy) : proxy_(proxy) {}

ContentDecryptionModuleClientAsyncWaiter::~ContentDecryptionModuleClientAsyncWaiter() = default;





void CdmFactoryInterceptorForTesting::CreateCdm(const ::media::CdmConfig& cdm_config, CreateCdmCallback callback) {
  GetForwardingInterface()->CreateCdm(
    std::move(cdm_config)
    , std::move(callback));
}
CdmFactoryAsyncWaiter::CdmFactoryAsyncWaiter(
    CdmFactory* proxy) : proxy_(proxy) {}

CdmFactoryAsyncWaiter::~CdmFactoryAsyncWaiter() = default;


void CdmFactoryAsyncWaiter::CreateCdm(
    const ::media::CdmConfig& cdm_config, ::mojo::PendingRemote<ContentDecryptionModule>* out_cdm, CdmContextPtr* out_cdm_context, ::media::CreateCdmStatus* out_status) {
  base::RunLoop loop;
  proxy_->CreateCdm(
      std::move(cdm_config),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingRemote<ContentDecryptionModule>* out_cdm
,
             CdmContextPtr* out_cdm_context
,
             ::media::CreateCdmStatus* out_status
,
             ::mojo::PendingRemote<ContentDecryptionModule> cdm,
             CdmContextPtr cdm_context,
             ::media::CreateCdmStatus status) {*out_cdm = std::move(cdm);*out_cdm_context = std::move(cdm_context);*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_cdm,
          out_cdm_context,
          out_status));
  loop.Run();
}








}  // media::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif