// media/mojo/mojom/content_decryption_module.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_CONTENT_DECRYPTION_MODULE_MOJOM_TEST_UTILS_H_
#define MEDIA_MOJO_MOJOM_CONTENT_DECRYPTION_MODULE_MOJOM_TEST_UTILS_H_

#include "media/mojo/mojom/content_decryption_module.mojom.h"


namespace media::mojom {


class  ContentDecryptionModuleInterceptorForTesting : public ContentDecryptionModule {
  virtual ContentDecryptionModule* GetForwardingInterface() = 0;
  void SetClient(::mojo::PendingAssociatedRemote<ContentDecryptionModuleClient> client) override;
  void SetServerCertificate(const std::vector<uint8_t>& certificate_data, SetServerCertificateCallback callback) override;
  void GetStatusForPolicy(::media::HdcpVersion min_hdcp_version, GetStatusForPolicyCallback callback) override;
  void CreateSessionAndGenerateRequest(::media::CdmSessionType session_type, ::media::EmeInitDataType init_data_type, const std::vector<uint8_t>& init_data, CreateSessionAndGenerateRequestCallback callback) override;
  void LoadSession(::media::CdmSessionType session_type, const std::string& session_id, LoadSessionCallback callback) override;
  void UpdateSession(const std::string& session_id, const std::vector<uint8_t>& response, UpdateSessionCallback callback) override;
  void CloseSession(const std::string& session_id, CloseSessionCallback callback) override;
  void RemoveSession(const std::string& session_id, RemoveSessionCallback callback) override;
};
class  ContentDecryptionModuleAsyncWaiter {
 public:
  explicit ContentDecryptionModuleAsyncWaiter(ContentDecryptionModule* proxy);

  ContentDecryptionModuleAsyncWaiter(const ContentDecryptionModuleAsyncWaiter&) = delete;
  ContentDecryptionModuleAsyncWaiter& operator=(const ContentDecryptionModuleAsyncWaiter&) = delete;

  ~ContentDecryptionModuleAsyncWaiter();
  void SetServerCertificate(
      const std::vector<uint8_t>& certificate_data, CdmPromiseResultPtr* out_result);
  CdmPromiseResultPtr SetServerCertificate(const std::vector<uint8_t>& certificate_data);
  void GetStatusForPolicy(
      ::media::HdcpVersion min_hdcp_version, CdmPromiseResultPtr* out_result, ::media::CdmKeyInformation::KeyStatus* out_key_status);
  
  void CreateSessionAndGenerateRequest(
      ::media::CdmSessionType session_type, ::media::EmeInitDataType init_data_type, const std::vector<uint8_t>& init_data, CdmPromiseResultPtr* out_result, std::string* out_session_id);
  
  void LoadSession(
      ::media::CdmSessionType session_type, const std::string& session_id, CdmPromiseResultPtr* out_result, std::string* out_session_id);
  
  void UpdateSession(
      const std::string& session_id, const std::vector<uint8_t>& response, CdmPromiseResultPtr* out_result);
  CdmPromiseResultPtr UpdateSession(const std::string& session_id, const std::vector<uint8_t>& response);
  void CloseSession(
      const std::string& session_id, CdmPromiseResultPtr* out_result);
  CdmPromiseResultPtr CloseSession(const std::string& session_id);
  void RemoveSession(
      const std::string& session_id, CdmPromiseResultPtr* out_result);
  CdmPromiseResultPtr RemoveSession(const std::string& session_id);

 private:
  ContentDecryptionModule* const proxy_;
};


class  ContentDecryptionModuleClientInterceptorForTesting : public ContentDecryptionModuleClient {
  virtual ContentDecryptionModuleClient* GetForwardingInterface() = 0;
  void OnSessionMessage(const std::string& session_id, ::media::CdmMessageType message_type, const std::vector<uint8_t>& message) override;
  void OnSessionClosed(const std::string& session_id, ::media::CdmSessionClosedReason reason) override;
  void OnSessionKeysChange(const std::string& session_id, bool has_additional_usable_key, std::vector<::std::unique_ptr<::media::CdmKeyInformation>> keys_info) override;
  void OnSessionExpirationUpdate(const std::string& session_id, double new_expiry_time_sec) override;
};
class  ContentDecryptionModuleClientAsyncWaiter {
 public:
  explicit ContentDecryptionModuleClientAsyncWaiter(ContentDecryptionModuleClient* proxy);

  ContentDecryptionModuleClientAsyncWaiter(const ContentDecryptionModuleClientAsyncWaiter&) = delete;
  ContentDecryptionModuleClientAsyncWaiter& operator=(const ContentDecryptionModuleClientAsyncWaiter&) = delete;

  ~ContentDecryptionModuleClientAsyncWaiter();

 private:
  ContentDecryptionModuleClient* const proxy_;
};


class  CdmFactoryInterceptorForTesting : public CdmFactory {
  virtual CdmFactory* GetForwardingInterface() = 0;
  void CreateCdm(const ::media::CdmConfig& cdm_config, CreateCdmCallback callback) override;
};
class  CdmFactoryAsyncWaiter {
 public:
  explicit CdmFactoryAsyncWaiter(CdmFactory* proxy);

  CdmFactoryAsyncWaiter(const CdmFactoryAsyncWaiter&) = delete;
  CdmFactoryAsyncWaiter& operator=(const CdmFactoryAsyncWaiter&) = delete;

  ~CdmFactoryAsyncWaiter();
  void CreateCdm(
      const ::media::CdmConfig& cdm_config, ::mojo::PendingRemote<ContentDecryptionModule>* out_cdm, CdmContextPtr* out_cdm_context, ::media::CreateCdmStatus* out_status);
  

 private:
  CdmFactory* const proxy_;
};




}  // media::mojom

#endif  // MEDIA_MOJO_MOJOM_CONTENT_DECRYPTION_MODULE_MOJOM_TEST_UTILS_H_