// media/mojo/mojom/audio_processing.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_AUDIO_PROCESSING_MOJOM_SHARED_INTERNAL_H_
#define MEDIA_MOJO_MOJOM_AUDIO_PROCESSING_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace media::mojom {
namespace internal {
class AudioProcessingStats_Data;
class AudioProcessingSettings_Data;
class AudioProcessingConfig_Data;

#pragma pack(push, 1)
class  AudioProcessingStats_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t has_echo_return_loss : 1;
  uint8_t has_echo_return_loss_enhancement : 1;
  uint8_t pad1_[7];
  double echo_return_loss;
  double echo_return_loss_enhancement;

 private:
  friend class mojo::internal::MessageFragment<AudioProcessingStats_Data>;

  AudioProcessingStats_Data();
  ~AudioProcessingStats_Data() = delete;
};
static_assert(sizeof(AudioProcessingStats_Data) == 32,
              "Bad sizeof(AudioProcessingStats_Data)");
// Used by AudioProcessingStats::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct AudioProcessingStats_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  AudioProcessingStats_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~AudioProcessingStats_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<AudioProcessingStats_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    AudioProcessingStats_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  AudioProcessingSettings_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t echo_cancellation : 1;
  uint8_t noise_suppression : 1;
  uint8_t automatic_gain_control : 1;
  uint8_t multi_channel_capture_processing : 1;
  uint8_t use_loopback_aec_reference : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<AudioProcessingSettings_Data>;

  AudioProcessingSettings_Data();
  ~AudioProcessingSettings_Data() = delete;
};
static_assert(sizeof(AudioProcessingSettings_Data) == 16,
              "Bad sizeof(AudioProcessingSettings_Data)");
// Used by AudioProcessingSettings::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct AudioProcessingSettings_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  AudioProcessingSettings_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~AudioProcessingSettings_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<AudioProcessingSettings_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    AudioProcessingSettings_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  AudioProcessingConfig_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data controls_receiver;
  uint8_t pad0_[4];
  mojo::internal::Pointer<internal::AudioProcessingSettings_Data> settings;

 private:
  friend class mojo::internal::MessageFragment<AudioProcessingConfig_Data>;

  AudioProcessingConfig_Data();
  ~AudioProcessingConfig_Data() = delete;
};
static_assert(sizeof(AudioProcessingConfig_Data) == 24,
              "Bad sizeof(AudioProcessingConfig_Data)");
// Used by AudioProcessingConfig::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct AudioProcessingConfig_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  AudioProcessingConfig_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~AudioProcessingConfig_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<AudioProcessingConfig_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    AudioProcessingConfig_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // media::mojom

#endif  // MEDIA_MOJO_MOJOM_AUDIO_PROCESSING_MOJOM_SHARED_INTERNAL_H_