// media/mojo/mojom/audio_output_stream.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('media.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.AudioOutputStreamPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.AudioOutputStream.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { media.mojom.AudioOutputStreamInterface }
 */
media.mojom.AudioOutputStreamRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.AudioOutputStreamPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.AudioOutputStreamPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.AudioOutputStreamPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  play() {
    this.proxy.sendMessage(
        0,
        media.mojom.AudioOutputStream_Play_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  pause() {
    this.proxy.sendMessage(
        1,
        media.mojom.AudioOutputStream_Pause_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  flush() {
    this.proxy.sendMessage(
        2,
        media.mojom.AudioOutputStream_Flush_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } volume
   */

  setVolume(
      volume) {
    this.proxy.sendMessage(
        3,
        media.mojom.AudioOutputStream_SetVolume_ParamsSpec.$,
        null,
        [
          volume
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AudioOutputStream
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.AudioOutputStreamReceiver = class {
  /**
   * @param {!media.mojom.AudioOutputStreamInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.AudioOutputStreamRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.AudioOutputStreamRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.AudioOutputStreamRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.AudioOutputStream_Play_ParamsSpec.$,
        null,
        impl.play.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.AudioOutputStream_Pause_ParamsSpec.$,
        null,
        impl.pause.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        media.mojom.AudioOutputStream_Flush_ParamsSpec.$,
        null,
        impl.flush.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        media.mojom.AudioOutputStream_SetVolume_ParamsSpec.$,
        null,
        impl.setVolume.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.AudioOutputStream = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.AudioOutputStream";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.AudioOutputStreamRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.AudioOutputStreamRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AudioOutputStream
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.AudioOutputStreamCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.AudioOutputStreamRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.AudioOutputStreamRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.play =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.AudioOutputStream_Play_ParamsSpec.$,
        null,
        this.play.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.pause =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.AudioOutputStream_Pause_ParamsSpec.$,
        null,
        this.pause.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.flush =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        media.mojom.AudioOutputStream_Flush_ParamsSpec.$,
        null,
        this.flush.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setVolume =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        media.mojom.AudioOutputStream_SetVolume_ParamsSpec.$,
        null,
        this.setVolume.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.AudioOutputStreamObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.AudioOutputStreamObserver.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { media.mojom.AudioOutputStreamObserverInterface }
 */
media.mojom.AudioOutputStreamObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.AudioOutputStreamObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.AudioOutputStreamObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.AudioOutputStreamObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  didStartPlaying() {
    this.proxy.sendMessage(
        0,
        media.mojom.AudioOutputStreamObserver_DidStartPlaying_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  didStopPlaying() {
    this.proxy.sendMessage(
        1,
        media.mojom.AudioOutputStreamObserver_DidStopPlaying_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } isAudible
   */

  didChangeAudibleState(
      isAudible) {
    this.proxy.sendMessage(
        2,
        media.mojom.AudioOutputStreamObserver_DidChangeAudibleState_ParamsSpec.$,
        null,
        [
          isAudible
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AudioOutputStreamObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.AudioOutputStreamObserverReceiver = class {
  /**
   * @param {!media.mojom.AudioOutputStreamObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.AudioOutputStreamObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.AudioOutputStreamObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.AudioOutputStreamObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.AudioOutputStreamObserver_DidStartPlaying_ParamsSpec.$,
        null,
        impl.didStartPlaying.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.AudioOutputStreamObserver_DidStopPlaying_ParamsSpec.$,
        null,
        impl.didStopPlaying.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        media.mojom.AudioOutputStreamObserver_DidChangeAudibleState_ParamsSpec.$,
        null,
        impl.didChangeAudibleState.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.AudioOutputStreamObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.AudioOutputStreamObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.AudioOutputStreamObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.AudioOutputStreamObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.AudioOutputStreamObserver.DisconnectReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.AudioOutputStreamObserver_DisconnectReason = {
  
  kDefault: 0,
  kPlatformError: 1,
  kTerminatedByClient: 2,
  kStreamCreationFailed: 3,
  kDocumentDestroyed: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};

/**
 * An object which receives request messages for the AudioOutputStreamObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.AudioOutputStreamObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.AudioOutputStreamObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.AudioOutputStreamObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didStartPlaying =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.AudioOutputStreamObserver_DidStartPlaying_ParamsSpec.$,
        null,
        this.didStartPlaying.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didStopPlaying =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.AudioOutputStreamObserver_DidStopPlaying_ParamsSpec.$,
        null,
        this.didStopPlaying.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didChangeAudibleState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        media.mojom.AudioOutputStreamObserver_DidChangeAudibleState_ParamsSpec.$,
        null,
        this.didChangeAudibleState.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.AudioOutputStreamProviderPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.AudioOutputStreamProvider.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { media.mojom.AudioOutputStreamProviderInterface }
 */
media.mojom.AudioOutputStreamProviderRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.AudioOutputStreamProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.AudioOutputStreamProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.AudioOutputStreamProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media.mojom.AudioParameters } params
   * @param { !media.mojom.AudioOutputStreamProviderClientRemote } client
   */

  acquire(
      params,
      client) {
    this.proxy.sendMessage(
        0,
        media.mojom.AudioOutputStreamProvider_Acquire_ParamsSpec.$,
        null,
        [
          params,
          client
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AudioOutputStreamProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.AudioOutputStreamProviderReceiver = class {
  /**
   * @param {!media.mojom.AudioOutputStreamProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.AudioOutputStreamProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.AudioOutputStreamProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.AudioOutputStreamProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.AudioOutputStreamProvider_Acquire_ParamsSpec.$,
        null,
        impl.acquire.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.AudioOutputStreamProvider = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.AudioOutputStreamProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.AudioOutputStreamProviderRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.AudioOutputStreamProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AudioOutputStreamProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.AudioOutputStreamProviderCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.AudioOutputStreamProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.AudioOutputStreamProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.acquire =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.AudioOutputStreamProvider_Acquire_ParamsSpec.$,
        null,
        this.acquire.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.AudioOutputStreamProviderClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.AudioOutputStreamProviderClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { media.mojom.AudioOutputStreamProviderClientInterface }
 */
media.mojom.AudioOutputStreamProviderClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.AudioOutputStreamProviderClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.AudioOutputStreamProviderClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.AudioOutputStreamProviderClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media.mojom.AudioOutputStreamRemote } stream
   * @param { !media.mojom.ReadWriteAudioDataPipe } dataPipe
   */

  created(
      stream,
      dataPipe) {
    this.proxy.sendMessage(
        0,
        media.mojom.AudioOutputStreamProviderClient_Created_ParamsSpec.$,
        null,
        [
          stream,
          dataPipe
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AudioOutputStreamProviderClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.AudioOutputStreamProviderClientReceiver = class {
  /**
   * @param {!media.mojom.AudioOutputStreamProviderClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.AudioOutputStreamProviderClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.AudioOutputStreamProviderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.AudioOutputStreamProviderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.AudioOutputStreamProviderClient_Created_ParamsSpec.$,
        null,
        impl.created.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.AudioOutputStreamProviderClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.AudioOutputStreamProviderClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.AudioOutputStreamProviderClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.AudioOutputStreamProviderClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AudioOutputStreamProviderClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.AudioOutputStreamProviderClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.AudioOutputStreamProviderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.AudioOutputStreamProviderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.created =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.AudioOutputStreamProviderClient_Created_ParamsSpec.$,
        null,
        this.created.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.DeviceSwitchInterfacePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.DeviceSwitchInterface.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { media.mojom.DeviceSwitchInterfaceInterface }
 */
media.mojom.DeviceSwitchInterfaceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.DeviceSwitchInterfacePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.DeviceSwitchInterfacePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.DeviceSwitchInterfacePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } outputDeviceId
   */

  switchAudioOutputDeviceId(
      outputDeviceId) {
    this.proxy.sendMessage(
        0,
        media.mojom.DeviceSwitchInterface_SwitchAudioOutputDeviceId_ParamsSpec.$,
        null,
        [
          outputDeviceId
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DeviceSwitchInterface
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.DeviceSwitchInterfaceReceiver = class {
  /**
   * @param {!media.mojom.DeviceSwitchInterfaceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.DeviceSwitchInterfaceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.DeviceSwitchInterfaceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.DeviceSwitchInterfaceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.DeviceSwitchInterface_SwitchAudioOutputDeviceId_ParamsSpec.$,
        null,
        impl.switchAudioOutputDeviceId.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.DeviceSwitchInterface = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.DeviceSwitchInterface";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.DeviceSwitchInterfaceRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.DeviceSwitchInterfaceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DeviceSwitchInterface
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.DeviceSwitchInterfaceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.DeviceSwitchInterfaceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.DeviceSwitchInterfaceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.switchAudioOutputDeviceId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.DeviceSwitchInterface_SwitchAudioOutputDeviceId_ParamsSpec.$,
        null,
        this.switchAudioOutputDeviceId.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioOutputStream_Play_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioOutputStream_Pause_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioOutputStream_Flush_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioOutputStream_SetVolume_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioOutputStreamObserver_DidStartPlaying_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioOutputStreamObserver_DidStopPlaying_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioOutputStreamObserver_DidChangeAudibleState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioOutputStreamProvider_Acquire_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioOutputStreamProviderClient_Created_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.DeviceSwitchInterface_SwitchAudioOutputDeviceId_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    media.mojom.AudioOutputStream_Play_ParamsSpec.$,
    'AudioOutputStream_Play_Params',
    [
    ],
    [[0, 8],]);





/** @record */
media.mojom.AudioOutputStream_Play_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.AudioOutputStream_Pause_ParamsSpec.$,
    'AudioOutputStream_Pause_Params',
    [
    ],
    [[0, 8],]);





/** @record */
media.mojom.AudioOutputStream_Pause_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.AudioOutputStream_Flush_ParamsSpec.$,
    'AudioOutputStream_Flush_Params',
    [
    ],
    [[0, 8],]);





/** @record */
media.mojom.AudioOutputStream_Flush_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.AudioOutputStream_SetVolume_ParamsSpec.$,
    'AudioOutputStream_SetVolume_Params',
    [
      mojo.internal.StructField(
        'volume', 0,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.AudioOutputStream_SetVolume_Params = class {
  constructor() {
    /** @export { !number } */
    this.volume;
  }
};



mojo.internal.Struct(
    media.mojom.AudioOutputStreamObserver_DidStartPlaying_ParamsSpec.$,
    'AudioOutputStreamObserver_DidStartPlaying_Params',
    [
    ],
    [[0, 8],]);





/** @record */
media.mojom.AudioOutputStreamObserver_DidStartPlaying_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.AudioOutputStreamObserver_DidStopPlaying_ParamsSpec.$,
    'AudioOutputStreamObserver_DidStopPlaying_Params',
    [
    ],
    [[0, 8],]);





/** @record */
media.mojom.AudioOutputStreamObserver_DidStopPlaying_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.AudioOutputStreamObserver_DidChangeAudibleState_ParamsSpec.$,
    'AudioOutputStreamObserver_DidChangeAudibleState_Params',
    [
      mojo.internal.StructField(
        'isAudible', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.AudioOutputStreamObserver_DidChangeAudibleState_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.isAudible;
  }
};



mojo.internal.Struct(
    media.mojom.AudioOutputStreamProvider_Acquire_ParamsSpec.$,
    'AudioOutputStreamProvider_Acquire_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        media.mojom.AudioParametersSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 8,
        0,
        mojo.internal.InterfaceProxy(media.mojom.AudioOutputStreamProviderClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
media.mojom.AudioOutputStreamProvider_Acquire_Params = class {
  constructor() {
    /** @export { !media.mojom.AudioParameters } */
    this.params;
    /** @export { !media.mojom.AudioOutputStreamProviderClientRemote } */
    this.client;
  }
};



mojo.internal.Struct(
    media.mojom.AudioOutputStreamProviderClient_Created_ParamsSpec.$,
    'AudioOutputStreamProviderClient_Created_Params',
    [
      mojo.internal.StructField(
        'stream', 0,
        0,
        mojo.internal.InterfaceProxy(media.mojom.AudioOutputStreamRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dataPipe', 8,
        0,
        media.mojom.ReadWriteAudioDataPipeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
media.mojom.AudioOutputStreamProviderClient_Created_Params = class {
  constructor() {
    /** @export { !media.mojom.AudioOutputStreamRemote } */
    this.stream;
    /** @export { !media.mojom.ReadWriteAudioDataPipe } */
    this.dataPipe;
  }
};



mojo.internal.Struct(
    media.mojom.DeviceSwitchInterface_SwitchAudioOutputDeviceId_ParamsSpec.$,
    'DeviceSwitchInterface_SwitchAudioOutputDeviceId_Params',
    [
      mojo.internal.StructField(
        'outputDeviceId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.DeviceSwitchInterface_SwitchAudioOutputDeviceId_Params = class {
  constructor() {
    /** @export { !string } */
    this.outputDeviceId;
  }
};

