// media/mojo/mojom/audio_encoder.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  AudioParameters as media_mojom_AudioParameters,
  AudioParametersSpec as media_mojom_AudioParametersSpec
} from './audio_parameters.mojom.m.js';

import {
  AudioCodec as media_mojom_AudioCodec,
  AudioCodecSpec as media_mojom_AudioCodecSpec,
  AudioBuffer as media_mojom_AudioBuffer,
  AudioBufferSpec as media_mojom_AudioBufferSpec,
  EncoderStatus as media_mojom_EncoderStatus,
  EncoderStatusSpec as media_mojom_EncoderStatusSpec
} from './media_types.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AacOutputFormatSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AacOutputFormat = {
  
  kAAC: 0,
  kADTS: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AudioEncoderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.AudioEncoder', scope);
  }
}

/** @interface */
export class AudioEncoderInterface {
  
  /**
   * @param { !Object } client
   * @param { !AudioEncoderConfig } config
   * @return {!Promise<{
        status: !media_mojom_EncoderStatus,
   *  }>}
   */

  initialize(client, config) {}
  
  /**
   * @param { !media_mojom_AudioBuffer } buffer
   * @return {!Promise<{
        status: !media_mojom_EncoderStatus,
   *  }>}
   */

  encode(buffer) {}
  
  /**
   * @return {!Promise<{
        status: !media_mojom_EncoderStatus,
   *  }>}
   */

  flush() {}
}

/**
 * @implements { AudioEncoderInterface }
 */
export class AudioEncoderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AudioEncoderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AudioEncoderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AudioEncoderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Object } client
   * @param { !AudioEncoderConfig } config
   * @return {!Promise<{
        status: !media_mojom_EncoderStatus,
   *  }>}
   */

  initialize(
      client,
      config) {
    return this.proxy.sendMessage(
        0,
        AudioEncoder_Initialize_ParamsSpec.$,
        AudioEncoder_Initialize_ResponseParamsSpec.$,
        [
          client,
          config
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_AudioBuffer } buffer
   * @return {!Promise<{
        status: !media_mojom_EncoderStatus,
   *  }>}
   */

  encode(
      buffer) {
    return this.proxy.sendMessage(
        1,
        AudioEncoder_Encode_ParamsSpec.$,
        AudioEncoder_Encode_ResponseParamsSpec.$,
        [
          buffer
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        status: !media_mojom_EncoderStatus,
   *  }>}
   */

  flush() {
    return this.proxy.sendMessage(
        2,
        AudioEncoder_Flush_ParamsSpec.$,
        AudioEncoder_Flush_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AudioEncoder
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AudioEncoderReceiver {
  /**
   * @param {!AudioEncoderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AudioEncoderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AudioEncoderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioEncoderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AudioEncoder_Initialize_ParamsSpec.$,
        AudioEncoder_Initialize_ResponseParamsSpec.$,
        impl.initialize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AudioEncoder_Encode_ParamsSpec.$,
        AudioEncoder_Encode_ResponseParamsSpec.$,
        impl.encode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        AudioEncoder_Flush_ParamsSpec.$,
        AudioEncoder_Flush_ResponseParamsSpec.$,
        impl.flush.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AudioEncoder {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.AudioEncoder";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AudioEncoderRemote}
   */
  static getRemote() {
    let remote = new AudioEncoderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AudioEncoder
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AudioEncoderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AudioEncoderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioEncoderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initialize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AudioEncoder_Initialize_ParamsSpec.$,
        AudioEncoder_Initialize_ResponseParamsSpec.$,
        this.initialize.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.encode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AudioEncoder_Encode_ParamsSpec.$,
        AudioEncoder_Encode_ResponseParamsSpec.$,
        this.encode.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.flush =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        AudioEncoder_Flush_ParamsSpec.$,
        AudioEncoder_Flush_ResponseParamsSpec.$,
        this.flush.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AudioEncoderClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.AudioEncoderClient', scope);
  }
}

/** @interface */
export class AudioEncoderClientInterface {
  
  /**
   * @param { !EncodedAudioBuffer } buffer
   * @param { !Array<!number> } description
   */

  onEncodedBufferReady(buffer, description) {}
}

/**
 * @implements { AudioEncoderClientInterface }
 */
export class AudioEncoderClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AudioEncoderClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AudioEncoderClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AudioEncoderClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !EncodedAudioBuffer } buffer
   * @param { !Array<!number> } description
   */

  onEncodedBufferReady(
      buffer,
      description) {
    this.proxy.sendMessage(
        0,
        AudioEncoderClient_OnEncodedBufferReady_ParamsSpec.$,
        null,
        [
          buffer,
          description
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AudioEncoderClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AudioEncoderClientReceiver {
  /**
   * @param {!AudioEncoderClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AudioEncoderClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AudioEncoderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioEncoderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AudioEncoderClient_OnEncodedBufferReady_ParamsSpec.$,
        null,
        impl.onEncodedBufferReady.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AudioEncoderClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.AudioEncoderClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AudioEncoderClientRemote}
   */
  static getRemote() {
    let remote = new AudioEncoderClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AudioEncoderClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AudioEncoderClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AudioEncoderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioEncoderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onEncodedBufferReady =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AudioEncoderClient_OnEncodedBufferReady_ParamsSpec.$,
        null,
        this.onEncodedBufferReady.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AacAudioEncoderConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioEncoderConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EncodedAudioBufferSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioEncoder_Initialize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioEncoder_Initialize_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioEncoder_Encode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioEncoder_Encode_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioEncoder_Flush_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioEncoder_Flush_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioEncoderClient_OnEncodedBufferReady_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    AacAudioEncoderConfigSpec.$,
    'AacAudioEncoderConfig',
    [
      mojo.internal.StructField(
        'format', 0,
        0,
        AacOutputFormatSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AacAudioEncoderConfig {
  constructor() {
    /** @type { !AacOutputFormat } */
    this.format;
  }
}



mojo.internal.Struct(
    AudioEncoderConfigSpec.$,
    'AudioEncoderConfig',
    [
      mojo.internal.StructField(
        'codec', 0,
        0,
        media_mojom_AudioCodecSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'channelCount', 4,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sampleRate', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bitrate', 12,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'aac', 16,
        0,
        AacAudioEncoderConfigSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class AudioEncoderConfig {
  constructor() {
    /** @type { !media_mojom_AudioCodec } */
    this.codec;
    /** @type { !number } */
    this.channelCount;
    /** @type { !number } */
    this.sampleRate;
    /** @type { !number } */
    this.bitrate;
    /** @type { !AacAudioEncoderConfig } */
    this.aac;
  }
}



mojo.internal.Struct(
    EncodedAudioBufferSpec.$,
    'EncodedAudioBuffer',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        media_mojom_AudioParametersSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timestamp', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'duration', 16,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 24,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class EncodedAudioBuffer {
  constructor() {
    /** @type { !media_mojom_AudioParameters } */
    this.params;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.timestamp;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.duration;
    /** @type { !Array<!number> } */
    this.data;
  }
}



mojo.internal.Struct(
    AudioEncoder_Initialize_ParamsSpec.$,
    'AudioEncoder_Initialize_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(AudioEncoderClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'config', 8,
        0,
        AudioEncoderConfigSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AudioEncoder_Initialize_Params {
  constructor() {
    /** @type { !Object } */
    this.client;
    /** @type { !AudioEncoderConfig } */
    this.config;
  }
}



mojo.internal.Struct(
    AudioEncoder_Initialize_ResponseParamsSpec.$,
    'AudioEncoder_Initialize_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media_mojom_EncoderStatusSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioEncoder_Initialize_ResponseParams {
  constructor() {
    /** @type { !media_mojom_EncoderStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    AudioEncoder_Encode_ParamsSpec.$,
    'AudioEncoder_Encode_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        media_mojom_AudioBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioEncoder_Encode_Params {
  constructor() {
    /** @type { !media_mojom_AudioBuffer } */
    this.buffer;
  }
}



mojo.internal.Struct(
    AudioEncoder_Encode_ResponseParamsSpec.$,
    'AudioEncoder_Encode_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media_mojom_EncoderStatusSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioEncoder_Encode_ResponseParams {
  constructor() {
    /** @type { !media_mojom_EncoderStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    AudioEncoder_Flush_ParamsSpec.$,
    'AudioEncoder_Flush_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AudioEncoder_Flush_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    AudioEncoder_Flush_ResponseParamsSpec.$,
    'AudioEncoder_Flush_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media_mojom_EncoderStatusSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioEncoder_Flush_ResponseParams {
  constructor() {
    /** @type { !media_mojom_EncoderStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    AudioEncoderClient_OnEncodedBufferReady_ParamsSpec.$,
    'AudioEncoderClient_OnEncodedBufferReady_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        EncodedAudioBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'description', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AudioEncoderClient_OnEncodedBufferReady_Params {
  constructor() {
    /** @type { !EncodedAudioBuffer } */
    this.buffer;
    /** @type { !Array<!number> } */
    this.description;
  }
}

