// media/mojo/mojom/audio_encoder.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_AUDIO_ENCODER_MOJOM_SEND_VALIDATION_H_
#define MEDIA_MOJO_MOJOM_AUDIO_ENCODER_MOJOM_SEND_VALIDATION_H_

#include "media/mojo/mojom/audio_encoder.mojom-shared-internal.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "media/mojo/mojom/audio_parameters.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"

#include "media/mojo/mojom/audio_encoder.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::AacOutputFormat, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::AacAudioEncoderConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::AacAudioEncoderConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::AacAudioEncoderConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::media::mojom::AacOutputFormat>(
        Traits::format(input),
        &fragment->format);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::AudioEncoderConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::AudioEncoderConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::AudioEncoderConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::media::mojom::AudioCodec>(
        Traits::codec(input),
        &fragment->codec);

      fragment->channel_count = Traits::channel_count(input);

      fragment->sample_rate = Traits::sample_rate(input);

      fragment->bitrate = Traits::bitrate(input);

      decltype(Traits::aac(input)) in_aac = Traits::aac(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->aac)::BaseType> aac_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::AacAudioEncoderConfigDataView, send_validation>(
        in_aac,
        aac_fragment);

      fragment->aac.Set(
          aac_fragment.is_null() ? nullptr : aac_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->aac.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null aac in AudioEncoderConfig struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::EncodedAudioBufferDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::EncodedAudioBufferDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::EncodedAudioBuffer_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::params(input)) in_params = Traits::params(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->params)::BaseType> params_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::AudioParametersDataView, send_validation>(
        in_params,
        params_fragment);

      fragment->params.Set(
          params_fragment.is_null() ? nullptr : params_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->params.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null params in EncodedAudioBuffer struct");

      decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_timestamp,
        timestamp_fragment);

      fragment->timestamp.Set(
          timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->timestamp.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null timestamp in EncodedAudioBuffer struct");

      decltype(Traits::duration(input)) in_duration = Traits::duration(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->duration)::BaseType> duration_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_duration,
        duration_fragment);

      fragment->duration.Set(
          duration_fragment.is_null() ? nullptr : duration_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->duration.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null duration in EncodedAudioBuffer struct");

      decltype(Traits::data(input)) in_data = Traits::data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->data)::BaseType>
          data_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_data,
        data_fragment,
        &data_validate_params);

      fragment->data.Set(
          data_fragment.is_null() ? nullptr : data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in EncodedAudioBuffer struct");
  }
};

}  // namespace mojo::internal

#endif  // MEDIA_MOJO_MOJOM_AUDIO_ENCODER_MOJOM_SEND_VALIDATION_H_