// media/mojo/mojom/audio_decoder.mojom-blink-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_AUDIO_DECODER_MOJOM_BLINK_TEST_UTILS_H_
#define MEDIA_MOJO_MOJOM_AUDIO_DECODER_MOJOM_BLINK_TEST_UTILS_H_

#include "media/mojo/mojom/audio_decoder.mojom-blink.h"
#include "third_party/blink/public/platform/web_common.h"


namespace media::mojom::blink {


class BLINK_PLATFORM_EXPORT AudioDecoderInterceptorForTesting : public AudioDecoder {
  virtual AudioDecoder* GetForwardingInterface() = 0;
  void GetSupportedConfigs(GetSupportedConfigsCallback callback) override;
  void Construct(::mojo::PendingAssociatedRemote<AudioDecoderClient> client, ::mojo::PendingRemote<::media::mojom::blink::MediaLog> media_log) override;
  void Initialize(::media::mojom::blink::AudioDecoderConfigPtr config, const std::optional<::base::UnguessableToken>& cdm_id, InitializeCallback callback) override;
  void SetDataSource(::mojo::ScopedDataPipeConsumerHandle receive_pipe) override;
  void Decode(::media::mojom::blink::DecoderBufferPtr buffer, DecodeCallback callback) override;
  void Reset(ResetCallback callback) override;
};
class BLINK_PLATFORM_EXPORT AudioDecoderAsyncWaiter {
 public:
  explicit AudioDecoderAsyncWaiter(AudioDecoder* proxy);

  AudioDecoderAsyncWaiter(const AudioDecoderAsyncWaiter&) = delete;
  AudioDecoderAsyncWaiter& operator=(const AudioDecoderAsyncWaiter&) = delete;

  ~AudioDecoderAsyncWaiter();
  void GetSupportedConfigs(
      ::blink::Vector<SupportedAudioDecoderConfigPtr>* out_supported_configs);
  ::blink::Vector<SupportedAudioDecoderConfigPtr> GetSupportedConfigs();
  void Initialize(
      ::media::mojom::blink::AudioDecoderConfigPtr config, const std::optional<::base::UnguessableToken>& cdm_id, ::media::mojom::blink::DecoderStatusPtr* out_success, bool* out_needs_bitstream_conversion, ::media::AudioDecoderType* out_decoder_type);
  
  void Decode(
      ::media::mojom::blink::DecoderBufferPtr buffer, ::media::mojom::blink::DecoderStatusPtr* out_status);
  ::media::mojom::blink::DecoderStatusPtr Decode(::media::mojom::blink::DecoderBufferPtr buffer);
  void Reset(
      );
  

 private:
  AudioDecoder* const proxy_;
};


class BLINK_PLATFORM_EXPORT AudioDecoderClientInterceptorForTesting : public AudioDecoderClient {
  virtual AudioDecoderClient* GetForwardingInterface() = 0;
  void OnBufferDecoded(::media::mojom::blink::AudioBufferPtr buffer) override;
  void OnWaiting(::media::mojom::blink::WaitingReason reason) override;
};
class BLINK_PLATFORM_EXPORT AudioDecoderClientAsyncWaiter {
 public:
  explicit AudioDecoderClientAsyncWaiter(AudioDecoderClient* proxy);

  AudioDecoderClientAsyncWaiter(const AudioDecoderClientAsyncWaiter&) = delete;
  AudioDecoderClientAsyncWaiter& operator=(const AudioDecoderClientAsyncWaiter&) = delete;

  ~AudioDecoderClientAsyncWaiter();

 private:
  AudioDecoderClient* const proxy_;
};




}  // media::mojom::blink

#endif  // MEDIA_MOJO_MOJOM_AUDIO_DECODER_MOJOM_BLINK_TEST_UTILS_H_