// media/capture/mojom/video_effects_manager.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/capture/mojom/video_effects_manager.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/capture/mojom/video_effects_manager.mojom-params-data.h"
namespace media {
namespace mojom {

NOINLINE static const char* SetConfigurationResultToStringHelper(SetConfigurationResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SetConfigurationResult::kOk:
      return "kOk";
    case SetConfigurationResult::kError:
      return "kError";
    default:
      return nullptr;
  }
}

std::string SetConfigurationResultToString(SetConfigurationResult value) {
  const char *str = SetConfigurationResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SetConfigurationResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SetConfigurationResult value) {
  return os << SetConfigurationResultToString(value);
}

namespace internal {


// static
bool ImageEnhancement_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ImageEnhancement_Data* object =
      static_cast<const ImageEnhancement_Data*>(data);

  return true;
}

ImageEnhancement_Data::ImageEnhancement_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Blur_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Blur_Data* object =
      static_cast<const Blur_Data*>(data);

  return true;
}

Blur_Data::Blur_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Framing_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Framing_Data* object =
      static_cast<const Framing_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->padding_ratios, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->padding_ratios, validation_context))
    return false;

  return true;
}

Framing_Data::Framing_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEffectsConfiguration_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoEffectsConfiguration_Data* object =
      static_cast<const VideoEffectsConfiguration_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->image_enhancement, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->blur, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->framing, validation_context))
    return false;

  return true;
}

VideoEffectsConfiguration_Data::VideoEffectsConfiguration_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEffectsConfigurationObserver_OnConfigurationChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoEffectsConfigurationObserver_OnConfigurationChanged_Params_Data* object =
      static_cast<const VideoEffectsConfigurationObserver_OnConfigurationChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->configuration, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->configuration, validation_context))
    return false;

  return true;
}

VideoEffectsConfigurationObserver_OnConfigurationChanged_Params_Data::VideoEffectsConfigurationObserver_OnConfigurationChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ReadonlyVideoEffectsManager_GetConfiguration_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ReadonlyVideoEffectsManager_GetConfiguration_Params_Data* object =
      static_cast<const ReadonlyVideoEffectsManager_GetConfiguration_Params_Data*>(data);

  return true;
}

ReadonlyVideoEffectsManager_GetConfiguration_Params_Data::ReadonlyVideoEffectsManager_GetConfiguration_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ReadonlyVideoEffectsManager_GetConfiguration_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ReadonlyVideoEffectsManager_GetConfiguration_ResponseParams_Data* object =
      static_cast<const ReadonlyVideoEffectsManager_GetConfiguration_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->configuration, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->configuration, validation_context))
    return false;

  return true;
}

ReadonlyVideoEffectsManager_GetConfiguration_ResponseParams_Data::ReadonlyVideoEffectsManager_GetConfiguration_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ReadonlyVideoEffectsManager_AddObserver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ReadonlyVideoEffectsManager_AddObserver_Params_Data* object =
      static_cast<const ReadonlyVideoEffectsManager_AddObserver_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ReadonlyVideoEffectsManager_AddObserver_Params_Data::ReadonlyVideoEffectsManager_AddObserver_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::SetConfigurationResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::SetConfigurationResult value) {
  return std::move(context).WriteString(::media::mojom::SetConfigurationResultToString(value));
}

} // namespace perfetto