// media/capture/mojom/video_capture.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_MOJOM_SEND_VALIDATION_H_
#define MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_MOJOM_SEND_VALIDATION_H_

#include "media/capture/mojom/video_capture.mojom-shared-internal.h"
#include "media/capture/mojom/video_capture_buffer.mojom-shared.h"
#include "media/capture/mojom/video_capture_types.mojom-shared.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"

#include "media/capture/mojom/video_capture.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::VideoCaptureState, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::VideoCaptureResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::media::mojom::VideoCaptureResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::media::mojom::internal::VideoCaptureResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::media::mojom::VideoCaptureResultDataView::Tag::kState: {
    decltype(Traits::state(input))
    in_state = Traits::state(input);
        
mojo::internal::Serialize<::media::mojom::VideoCaptureState, send_validation>(
  in_state,
  &fragment->data.f_state);
    break;
  }
  case ::media::mojom::VideoCaptureResultDataView::Tag::kErrorCode: {
    decltype(Traits::error_code(input))
    in_error_code = Traits::error_code(input);
        
mojo::internal::Serialize<::media::mojom::VideoCaptureError, send_validation>(
  in_error_code,
  &fragment->data.f_error_code);
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_MOJOM_SEND_VALIDATION_H_