// media/capture/mojom/image_capture.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_CAPTURE_MOJOM_IMAGE_CAPTURE_MOJOM_SEND_VALIDATION_H_
#define MEDIA_CAPTURE_MOJOM_IMAGE_CAPTURE_MOJOM_SEND_VALIDATION_H_

#include "media/capture/mojom/image_capture.mojom-shared-internal.h"

#include "media/capture/mojom/image_capture.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::BackgroundBlurMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::EyeGazeCorrectionMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::MeteringMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::RedEyeReduction, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::FillLightMode, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::RangeDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::RangeDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::Range_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->max = Traits::max(input);

      fragment->min = Traits::min(input);

      fragment->current = Traits::current(input);

      fragment->step = Traits::step(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::PhotoStateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::PhotoStateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::PhotoState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::supported_white_balance_modes(input)) in_supported_white_balance_modes = Traits::supported_white_balance_modes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->supported_white_balance_modes)::BaseType>
          supported_white_balance_modes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& supported_white_balance_modes_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::MeteringMode_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::MeteringMode>, send_validation>(
        in_supported_white_balance_modes,
        supported_white_balance_modes_fragment,
        &supported_white_balance_modes_validate_params);

      fragment->supported_white_balance_modes.Set(
          supported_white_balance_modes_fragment.is_null() ? nullptr : supported_white_balance_modes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->supported_white_balance_modes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null supported_white_balance_modes in PhotoState struct");

      
      mojo::internal::Serialize<::media::mojom::MeteringMode>(
        Traits::current_white_balance_mode(input),
        &fragment->current_white_balance_mode);

      decltype(Traits::supported_exposure_modes(input)) in_supported_exposure_modes = Traits::supported_exposure_modes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->supported_exposure_modes)::BaseType>
          supported_exposure_modes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& supported_exposure_modes_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::MeteringMode_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::MeteringMode>, send_validation>(
        in_supported_exposure_modes,
        supported_exposure_modes_fragment,
        &supported_exposure_modes_validate_params);

      fragment->supported_exposure_modes.Set(
          supported_exposure_modes_fragment.is_null() ? nullptr : supported_exposure_modes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->supported_exposure_modes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null supported_exposure_modes in PhotoState struct");

      
      mojo::internal::Serialize<::media::mojom::MeteringMode>(
        Traits::current_exposure_mode(input),
        &fragment->current_exposure_mode);

      decltype(Traits::supported_focus_modes(input)) in_supported_focus_modes = Traits::supported_focus_modes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->supported_focus_modes)::BaseType>
          supported_focus_modes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& supported_focus_modes_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::MeteringMode_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::MeteringMode>, send_validation>(
        in_supported_focus_modes,
        supported_focus_modes_fragment,
        &supported_focus_modes_validate_params);

      fragment->supported_focus_modes.Set(
          supported_focus_modes_fragment.is_null() ? nullptr : supported_focus_modes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->supported_focus_modes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null supported_focus_modes in PhotoState struct");

      
      mojo::internal::Serialize<::media::mojom::MeteringMode>(
        Traits::current_focus_mode(input),
        &fragment->current_focus_mode);

      decltype(Traits::points_of_interest(input)) in_points_of_interest = Traits::points_of_interest(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->points_of_interest)::BaseType>
          points_of_interest_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& points_of_interest_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::Point2DDataView>, send_validation>(
        in_points_of_interest,
        points_of_interest_fragment,
        &points_of_interest_validate_params);

      fragment->points_of_interest.Set(
          points_of_interest_fragment.is_null() ? nullptr : points_of_interest_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->points_of_interest.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null points_of_interest in PhotoState struct");

      decltype(Traits::exposure_compensation(input)) in_exposure_compensation = Traits::exposure_compensation(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->exposure_compensation)::BaseType> exposure_compensation_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::RangeDataView, send_validation>(
        in_exposure_compensation,
        exposure_compensation_fragment);

      fragment->exposure_compensation.Set(
          exposure_compensation_fragment.is_null() ? nullptr : exposure_compensation_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->exposure_compensation.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null exposure_compensation in PhotoState struct");

      decltype(Traits::exposure_time(input)) in_exposure_time = Traits::exposure_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->exposure_time)::BaseType> exposure_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::RangeDataView, send_validation>(
        in_exposure_time,
        exposure_time_fragment);

      fragment->exposure_time.Set(
          exposure_time_fragment.is_null() ? nullptr : exposure_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->exposure_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null exposure_time in PhotoState struct");

      decltype(Traits::color_temperature(input)) in_color_temperature = Traits::color_temperature(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->color_temperature)::BaseType> color_temperature_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::RangeDataView, send_validation>(
        in_color_temperature,
        color_temperature_fragment);

      fragment->color_temperature.Set(
          color_temperature_fragment.is_null() ? nullptr : color_temperature_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->color_temperature.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null color_temperature in PhotoState struct");

      decltype(Traits::iso(input)) in_iso = Traits::iso(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->iso)::BaseType> iso_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::RangeDataView, send_validation>(
        in_iso,
        iso_fragment);

      fragment->iso.Set(
          iso_fragment.is_null() ? nullptr : iso_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->iso.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null iso in PhotoState struct");

      decltype(Traits::brightness(input)) in_brightness = Traits::brightness(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->brightness)::BaseType> brightness_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::RangeDataView, send_validation>(
        in_brightness,
        brightness_fragment);

      fragment->brightness.Set(
          brightness_fragment.is_null() ? nullptr : brightness_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->brightness.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null brightness in PhotoState struct");

      decltype(Traits::contrast(input)) in_contrast = Traits::contrast(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->contrast)::BaseType> contrast_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::RangeDataView, send_validation>(
        in_contrast,
        contrast_fragment);

      fragment->contrast.Set(
          contrast_fragment.is_null() ? nullptr : contrast_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->contrast.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null contrast in PhotoState struct");

      decltype(Traits::saturation(input)) in_saturation = Traits::saturation(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->saturation)::BaseType> saturation_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::RangeDataView, send_validation>(
        in_saturation,
        saturation_fragment);

      fragment->saturation.Set(
          saturation_fragment.is_null() ? nullptr : saturation_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->saturation.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null saturation in PhotoState struct");

      decltype(Traits::sharpness(input)) in_sharpness = Traits::sharpness(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sharpness)::BaseType> sharpness_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::RangeDataView, send_validation>(
        in_sharpness,
        sharpness_fragment);

      fragment->sharpness.Set(
          sharpness_fragment.is_null() ? nullptr : sharpness_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->sharpness.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sharpness in PhotoState struct");

      decltype(Traits::focus_distance(input)) in_focus_distance = Traits::focus_distance(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->focus_distance)::BaseType> focus_distance_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::RangeDataView, send_validation>(
        in_focus_distance,
        focus_distance_fragment);

      fragment->focus_distance.Set(
          focus_distance_fragment.is_null() ? nullptr : focus_distance_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->focus_distance.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null focus_distance in PhotoState struct");

      decltype(Traits::pan(input)) in_pan = Traits::pan(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->pan)::BaseType> pan_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::RangeDataView, send_validation>(
        in_pan,
        pan_fragment);

      fragment->pan.Set(
          pan_fragment.is_null() ? nullptr : pan_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->pan.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pan in PhotoState struct");

      decltype(Traits::tilt(input)) in_tilt = Traits::tilt(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->tilt)::BaseType> tilt_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::RangeDataView, send_validation>(
        in_tilt,
        tilt_fragment);

      fragment->tilt.Set(
          tilt_fragment.is_null() ? nullptr : tilt_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->tilt.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tilt in PhotoState struct");

      decltype(Traits::zoom(input)) in_zoom = Traits::zoom(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->zoom)::BaseType> zoom_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::RangeDataView, send_validation>(
        in_zoom,
        zoom_fragment);

      fragment->zoom.Set(
          zoom_fragment.is_null() ? nullptr : zoom_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->zoom.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null zoom in PhotoState struct");

      fragment->supports_torch = Traits::supports_torch(input);

      fragment->torch = Traits::torch(input);

      
      mojo::internal::Serialize<::media::mojom::RedEyeReduction>(
        Traits::red_eye_reduction(input),
        &fragment->red_eye_reduction);

      decltype(Traits::height(input)) in_height = Traits::height(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->height)::BaseType> height_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::RangeDataView, send_validation>(
        in_height,
        height_fragment);

      fragment->height.Set(
          height_fragment.is_null() ? nullptr : height_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->height.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null height in PhotoState struct");

      decltype(Traits::width(input)) in_width = Traits::width(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->width)::BaseType> width_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::RangeDataView, send_validation>(
        in_width,
        width_fragment);

      fragment->width.Set(
          width_fragment.is_null() ? nullptr : width_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->width.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null width in PhotoState struct");

      decltype(Traits::fill_light_mode(input)) in_fill_light_mode = Traits::fill_light_mode(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->fill_light_mode)::BaseType>
          fill_light_mode_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& fill_light_mode_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::FillLightMode_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::FillLightMode>, send_validation>(
        in_fill_light_mode,
        fill_light_mode_fragment,
        &fill_light_mode_validate_params);

      fragment->fill_light_mode.Set(
          fill_light_mode_fragment.is_null() ? nullptr : fill_light_mode_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->fill_light_mode.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null fill_light_mode in PhotoState struct");

      decltype(Traits::supported_background_blur_modes(input)) in_supported_background_blur_modes = Traits::supported_background_blur_modes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->supported_background_blur_modes)::BaseType>
          supported_background_blur_modes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& supported_background_blur_modes_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::BackgroundBlurMode_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::BackgroundBlurMode>, send_validation>(
        in_supported_background_blur_modes,
        supported_background_blur_modes_fragment,
        &supported_background_blur_modes_validate_params);

      fragment->supported_background_blur_modes.Set(
          supported_background_blur_modes_fragment.is_null() ? nullptr : supported_background_blur_modes_fragment.data());

      
      mojo::internal::Serialize<::media::mojom::BackgroundBlurMode>(
        Traits::background_blur_mode(input),
        &fragment->background_blur_mode);

      decltype(Traits::supported_face_framing_modes(input)) in_supported_face_framing_modes = Traits::supported_face_framing_modes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->supported_face_framing_modes)::BaseType>
          supported_face_framing_modes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& supported_face_framing_modes_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::MeteringMode_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::MeteringMode>, send_validation>(
        in_supported_face_framing_modes,
        supported_face_framing_modes_fragment,
        &supported_face_framing_modes_validate_params);

      fragment->supported_face_framing_modes.Set(
          supported_face_framing_modes_fragment.is_null() ? nullptr : supported_face_framing_modes_fragment.data());

      
      mojo::internal::Serialize<::media::mojom::MeteringMode>(
        Traits::current_face_framing_mode(input),
        &fragment->current_face_framing_mode);

      decltype(Traits::supported_eye_gaze_correction_modes(input)) in_supported_eye_gaze_correction_modes = Traits::supported_eye_gaze_correction_modes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->supported_eye_gaze_correction_modes)::BaseType>
          supported_eye_gaze_correction_modes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& supported_eye_gaze_correction_modes_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::EyeGazeCorrectionMode_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::EyeGazeCorrectionMode>, send_validation>(
        in_supported_eye_gaze_correction_modes,
        supported_eye_gaze_correction_modes_fragment,
        &supported_eye_gaze_correction_modes_validate_params);

      fragment->supported_eye_gaze_correction_modes.Set(
          supported_eye_gaze_correction_modes_fragment.is_null() ? nullptr : supported_eye_gaze_correction_modes_fragment.data());

      
      mojo::internal::Serialize<::media::mojom::EyeGazeCorrectionMode>(
        Traits::current_eye_gaze_correction_mode(input),
        &fragment->current_eye_gaze_correction_mode);

      decltype(Traits::supported_background_segmentation_mask_states(input)) in_supported_background_segmentation_mask_states = Traits::supported_background_segmentation_mask_states(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->supported_background_segmentation_mask_states)::BaseType>
          supported_background_segmentation_mask_states_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& supported_background_segmentation_mask_states_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<bool>, send_validation>(
        in_supported_background_segmentation_mask_states,
        supported_background_segmentation_mask_states_fragment,
        &supported_background_segmentation_mask_states_validate_params);

      fragment->supported_background_segmentation_mask_states.Set(
          supported_background_segmentation_mask_states_fragment.is_null() ? nullptr : supported_background_segmentation_mask_states_fragment.data());

      fragment->current_background_segmentation_mask_state = Traits::current_background_segmentation_mask_state(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::Point2DDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::Point2DDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::Point2D_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->x = Traits::x(input);

      fragment->y = Traits::y(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::PhotoSettingsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::PhotoSettingsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::PhotoSettings_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->has_white_balance_mode = Traits::has_white_balance_mode(input);

      
      mojo::internal::Serialize<::media::mojom::MeteringMode>(
        Traits::white_balance_mode(input),
        &fragment->white_balance_mode);

      fragment->has_exposure_mode = Traits::has_exposure_mode(input);

      
      mojo::internal::Serialize<::media::mojom::MeteringMode>(
        Traits::exposure_mode(input),
        &fragment->exposure_mode);

      fragment->has_focus_mode = Traits::has_focus_mode(input);

      
      mojo::internal::Serialize<::media::mojom::MeteringMode>(
        Traits::focus_mode(input),
        &fragment->focus_mode);

      decltype(Traits::points_of_interest(input)) in_points_of_interest = Traits::points_of_interest(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->points_of_interest)::BaseType>
          points_of_interest_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& points_of_interest_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::Point2DDataView>, send_validation>(
        in_points_of_interest,
        points_of_interest_fragment,
        &points_of_interest_validate_params);

      fragment->points_of_interest.Set(
          points_of_interest_fragment.is_null() ? nullptr : points_of_interest_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->points_of_interest.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null points_of_interest in PhotoSettings struct");

      fragment->has_exposure_compensation = Traits::has_exposure_compensation(input);

      fragment->exposure_compensation = Traits::exposure_compensation(input);

      fragment->has_exposure_time = Traits::has_exposure_time(input);

      fragment->exposure_time = Traits::exposure_time(input);

      fragment->has_color_temperature = Traits::has_color_temperature(input);

      fragment->color_temperature = Traits::color_temperature(input);

      fragment->has_iso = Traits::has_iso(input);

      fragment->iso = Traits::iso(input);

      fragment->has_brightness = Traits::has_brightness(input);

      fragment->brightness = Traits::brightness(input);

      fragment->has_contrast = Traits::has_contrast(input);

      fragment->contrast = Traits::contrast(input);

      fragment->has_saturation = Traits::has_saturation(input);

      fragment->saturation = Traits::saturation(input);

      fragment->has_sharpness = Traits::has_sharpness(input);

      fragment->sharpness = Traits::sharpness(input);

      fragment->has_focus_distance = Traits::has_focus_distance(input);

      fragment->focus_distance = Traits::focus_distance(input);

      fragment->has_pan = Traits::has_pan(input);

      fragment->pan = Traits::pan(input);

      fragment->has_tilt = Traits::has_tilt(input);

      fragment->tilt = Traits::tilt(input);

      fragment->has_zoom = Traits::has_zoom(input);

      fragment->zoom = Traits::zoom(input);

      fragment->has_torch = Traits::has_torch(input);

      fragment->torch = Traits::torch(input);

      fragment->has_fill_light_mode = Traits::has_fill_light_mode(input);

      
      mojo::internal::Serialize<::media::mojom::FillLightMode>(
        Traits::fill_light_mode(input),
        &fragment->fill_light_mode);

      fragment->has_width = Traits::has_width(input);

      fragment->width = Traits::width(input);

      fragment->has_height = Traits::has_height(input);

      fragment->height = Traits::height(input);

      fragment->has_red_eye_reduction = Traits::has_red_eye_reduction(input);

      fragment->red_eye_reduction = Traits::red_eye_reduction(input);

      fragment->has_background_blur_mode = Traits::has_background_blur_mode(input);

      
      mojo::internal::Serialize<::media::mojom::BackgroundBlurMode>(
        Traits::background_blur_mode(input),
        &fragment->background_blur_mode);

      fragment->has_face_framing_mode = Traits::has_face_framing_mode(input);

      
      mojo::internal::Serialize<::media::mojom::MeteringMode>(
        Traits::face_framing_mode(input),
        &fragment->face_framing_mode);
      fragment->eye_gaze_correction_mode_$flag = Traits::eye_gaze_correction_mode(input).has_value();
      if (Traits::eye_gaze_correction_mode(input).has_value()) {
        
        mojo::internal::Serialize<::media::mojom::EyeGazeCorrectionMode>(
          Traits::eye_gaze_correction_mode(input).value(),
          &fragment->eye_gaze_correction_mode_$value);
      } else {
        fragment->eye_gaze_correction_mode_$value =
            static_cast<int32_t>(::media::mojom::EyeGazeCorrectionMode::kMinValue);
      }
      fragment->background_segmentation_mask_state_$flag = Traits::background_segmentation_mask_state(input).has_value();
      if (Traits::background_segmentation_mask_state(input).has_value()) {
        fragment->background_segmentation_mask_state_$value = Traits::background_segmentation_mask_state(input).value();
      }
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::BlobDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::BlobDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::Blob_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::mime_type(input)) in_mime_type = Traits::mime_type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mime_type)::BaseType> mime_type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_mime_type,
        mime_type_fragment);

      fragment->mime_type.Set(
          mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->mime_type.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mime_type in Blob struct");

      decltype(Traits::data(input)) in_data = Traits::data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->data)::BaseType>
          data_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_data,
        data_fragment,
        &data_validate_params);

      fragment->data.Set(
          data_fragment.is_null() ? nullptr : data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in Blob struct");
  }
};

}  // namespace mojo::internal

#endif  // MEDIA_CAPTURE_MOJOM_IMAGE_CAPTURE_MOJOM_SEND_VALIDATION_H_