// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef headless_protocol_Target_h
#define headless_protocol_Target_h

#include "headless/public/headless_export.h"
#include "headless/lib/browser/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace headless {
namespace protocol {
namespace Target {
using TargetID = String;
using WindowState = String;

// ------------- Forward and enum declarations.

namespace WindowStateEnum {
HEADLESS_EXPORT extern const char Normal[];
HEADLESS_EXPORT extern const char Minimized[];
HEADLESS_EXPORT extern const char Maximized[];
HEADLESS_EXPORT extern const char Fullscreen[];
} // namespace WindowStateEnum

// ------------- Type and builder declarations.

// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.

// ------------- Backend interface.

class HEADLESS_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse CloseTarget(const String& in_targetId, bool* out_success) = 0;
    virtual DispatchResponse CreateTarget(const String& in_url, std::optional<int> in_left, std::optional<int> in_top, std::optional<int> in_width, std::optional<int> in_height, std::optional<String> in_windowState, std::optional<String> in_browserContextId, std::optional<bool> in_enableBeginFrameControl, std::optional<bool> in_newWindow, std::optional<bool> in_background, std::optional<bool> in_forTab, std::optional<bool> in_hidden, String* out_targetId) = 0;

    virtual DispatchResponse Disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class HEADLESS_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class HEADLESS_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class HEADLESS_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Target
} // namespace headless
} // namespace protocol

#endif // !defined(headless_protocol_Target_h)
