// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef headless_protocol_HeadlessExperimental_h
#define headless_protocol_HeadlessExperimental_h

#include "headless/public/headless_export.h"
#include "headless/lib/browser/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "headless/lib/browser/protocol/page.h"

namespace headless {
namespace protocol {
namespace HeadlessExperimental {
class ScreenshotParams;

// ------------- Forward and enum declarations.

// ------------- Type and builder declarations.

class HEADLESS_EXPORT ScreenshotParams : public ::crdtp::ProtocolObject<ScreenshotParams> {
public:
    ~ScreenshotParams() override;  // Defined below

    struct HEADLESS_EXPORT FormatEnum {
        static const char* Jpeg;
        static const char* Png;
        static const char* Webp;
    }; // FormatEnum

    bool HasFormat() { return !!m_format; }
    String GetFormat(const String& defaultValue) const {
       return m_format.value_or(defaultValue);
    }
    const std::optional<String>& GetFormat() const {
       return m_format;
    }
    void SetFormat(const String& value);  // Defined below

    bool HasQuality() { return !!m_quality; }
    int GetQuality(int defaultValue) const {
       return m_quality.value_or(defaultValue);
    }
    const std::optional<int>& GetQuality() const {
       return m_quality;
    }
    void SetQuality(int value);  // Defined below

    bool HasOptimizeForSpeed() { return !!m_optimizeForSpeed; }
    bool GetOptimizeForSpeed(bool defaultValue) const {
       return m_optimizeForSpeed.value_or(defaultValue);
    }
    const std::optional<bool>& GetOptimizeForSpeed() const {
       return m_optimizeForSpeed;
    }
    void SetOptimizeForSpeed(bool value);  // Defined below

    template<int STATE>
    class ScreenshotParamsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        ScreenshotParamsBuilder<STATE>& SetFormat(const String& value);  // Defined below

        ScreenshotParamsBuilder<STATE>& SetQuality(int value);  // Defined below

        ScreenshotParamsBuilder<STATE>& SetOptimizeForSpeed(bool value);  // Defined below

        std::unique_ptr<ScreenshotParams> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ScreenshotParams;
        ScreenshotParamsBuilder() : m_result(new ScreenshotParams()) { }

        template<int STEP> ScreenshotParamsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ScreenshotParamsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::HeadlessExperimental::ScreenshotParams> m_result;
    };

    static ScreenshotParamsBuilder<0> Create()
    {
        return ScreenshotParamsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ScreenshotParams();  // Defined below

    std::optional<String> m_format;
    std::optional<int> m_quality;
    std::optional<bool> m_optimizeForSpeed;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline ScreenshotParams::~ScreenshotParams() = default;
inline void ScreenshotParams::SetFormat(const String& value) { m_format = value; }
inline void ScreenshotParams::SetQuality(int value) { m_quality = value; }
inline void ScreenshotParams::SetOptimizeForSpeed(bool value) { m_optimizeForSpeed = value; }

template<int STATE>
inline ScreenshotParams::ScreenshotParamsBuilder<STATE>& ScreenshotParams::ScreenshotParamsBuilder<STATE>::SetFormat(const String& value) {
  m_result->SetFormat(value);
  return *this;
}
template<int STATE>
inline ScreenshotParams::ScreenshotParamsBuilder<STATE>& ScreenshotParams::ScreenshotParamsBuilder<STATE>::SetQuality(int value) {
  m_result->SetQuality(value);
  return *this;
}
template<int STATE>
inline ScreenshotParams::ScreenshotParamsBuilder<STATE>& ScreenshotParams::ScreenshotParamsBuilder<STATE>::SetOptimizeForSpeed(bool value) {
  m_result->SetOptimizeForSpeed(value);
  return *this;
}

inline ScreenshotParams::ScreenshotParams() {
}

// ------------- Backend interface.

class HEADLESS_EXPORT Backend {
public:
    virtual ~Backend() { }

    class HEADLESS_EXPORT BeginFrameCallback {
    public:
        virtual void sendSuccess(bool hasDamage, std::optional<Binary> screenshotData) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~BeginFrameCallback() { }
    };
    virtual void BeginFrame(std::optional<double> in_frameTimeTicks, std::optional<double> in_interval, std::optional<bool> in_noDisplayUpdates, std::unique_ptr<protocol::HeadlessExperimental::ScreenshotParams> in_screenshot, std::unique_ptr<BeginFrameCallback> callback) = 0;
    virtual DispatchResponse Disable() = 0;
    virtual DispatchResponse Enable() = 0;

};

// ------------- Frontend interface.

class HEADLESS_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class HEADLESS_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class HEADLESS_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace HeadlessExperimental
} // namespace headless
} // namespace protocol

#endif // !defined(headless_protocol_HeadlessExperimental_h)
