// gpu/ipc/common/memory_stats.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "gpu/ipc/common/memory_stats.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "gpu/ipc/common/memory_stats.mojom-params-data.h"
#include "gpu/ipc/common/memory_stats.mojom-shared-message-ids.h"

#include "gpu/ipc/common/memory_stats.mojom-import-headers.h"
#include "gpu/ipc/common/memory_stats.mojom-test-utils.h"


namespace gpu::mojom {
VideoMemoryProcessStats::VideoMemoryProcessStats()
    : video_memory_bytes(),
      has_duplicates() {}

VideoMemoryProcessStats::VideoMemoryProcessStats(
    uint64_t video_memory_bytes_in,
    bool has_duplicates_in)
    : video_memory_bytes(std::move(video_memory_bytes_in)),
      has_duplicates(std::move(has_duplicates_in)) {}

VideoMemoryProcessStats::~VideoMemoryProcessStats() = default;

void VideoMemoryProcessStats::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_memory_bytes"), this->video_memory_bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_duplicates"), this->has_duplicates,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoMemoryProcessStats::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoMemoryUsageStats::VideoMemoryUsageStats()
    : process_map(),
      bytes_allocated() {}

VideoMemoryUsageStats::VideoMemoryUsageStats(
    const base::flat_map<int32_t, ::gpu::VideoMemoryUsageStats::ProcessStats>& process_map_in,
    uint64_t bytes_allocated_in)
    : process_map(std::move(process_map_in)),
      bytes_allocated(std::move(bytes_allocated_in)) {}

VideoMemoryUsageStats::~VideoMemoryUsageStats() = default;

void VideoMemoryUsageStats::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "process_map"), this->process_map,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<int32_t, ::gpu::VideoMemoryUsageStats::ProcessStats>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bytes_allocated"), this->bytes_allocated,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoMemoryUsageStats::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // gpu::mojom


namespace mojo {


// static
bool StructTraits<::gpu::mojom::VideoMemoryProcessStats::DataView, ::gpu::mojom::VideoMemoryProcessStatsPtr>::Read(
    ::gpu::mojom::VideoMemoryProcessStats::DataView input,
    ::gpu::mojom::VideoMemoryProcessStatsPtr* output) {
  bool success = true;
  ::gpu::mojom::VideoMemoryProcessStatsPtr result(::gpu::mojom::VideoMemoryProcessStats::New());
  
      if (success)
        result->video_memory_bytes = input.video_memory_bytes();
      if (success)
        result->has_duplicates = input.has_duplicates();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::VideoMemoryUsageStats::DataView, ::gpu::mojom::VideoMemoryUsageStatsPtr>::Read(
    ::gpu::mojom::VideoMemoryUsageStats::DataView input,
    ::gpu::mojom::VideoMemoryUsageStatsPtr* output) {
  bool success = true;
  ::gpu::mojom::VideoMemoryUsageStatsPtr result(::gpu::mojom::VideoMemoryUsageStats::New());
  
      if (success && !input.ReadProcessMap(&result->process_map))
        success = false;
      if (success)
        result->bytes_allocated = input.bytes_allocated();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace gpu::mojom {




}  // gpu::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif