// gpu/ipc/common/gpu_info.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "gpu/ipc/common/gpu_info.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "gpu/ipc/common/gpu_info.mojom-params-data.h"
namespace gpu {
namespace mojom {

NOINLINE static const char* SkiaBackendTypeToStringHelper(SkiaBackendType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SkiaBackendType::kUnknown:
      return "kUnknown";
    case SkiaBackendType::kNone:
      return "kNone";
    case SkiaBackendType::kGaneshGL:
      return "kGaneshGL";
    case SkiaBackendType::kGaneshVulkan:
      return "kGaneshVulkan";
    case SkiaBackendType::kGraphiteDawnVulkan:
      return "kGraphiteDawnVulkan";
    case SkiaBackendType::kGraphiteDawnMetal:
      return "kGraphiteDawnMetal";
    case SkiaBackendType::kGraphiteDawnD3D11:
      return "kGraphiteDawnD3D11";
    case SkiaBackendType::kGraphiteDawnD3D12:
      return "kGraphiteDawnD3D12";
    case SkiaBackendType::kGraphiteMetal:
      return "kGraphiteMetal";
    default:
      return nullptr;
  }
}

std::string SkiaBackendTypeToString(SkiaBackendType value) {
  const char *str = SkiaBackendTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SkiaBackendType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SkiaBackendType value) {
  return os << SkiaBackendTypeToString(value);
}

NOINLINE static const char* VideoCodecProfileToStringHelper(VideoCodecProfile value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VideoCodecProfile::VIDEO_CODEC_PROFILE_UNKNOWN:
      return "VIDEO_CODEC_PROFILE_UNKNOWN";
    case VideoCodecProfile::H264PROFILE_BASELINE:
      return "H264PROFILE_BASELINE";
    case VideoCodecProfile::H264PROFILE_MAIN:
      return "H264PROFILE_MAIN";
    case VideoCodecProfile::H264PROFILE_EXTENDED:
      return "H264PROFILE_EXTENDED";
    case VideoCodecProfile::H264PROFILE_HIGH:
      return "H264PROFILE_HIGH";
    case VideoCodecProfile::H264PROFILE_HIGH10PROFILE:
      return "H264PROFILE_HIGH10PROFILE";
    case VideoCodecProfile::H264PROFILE_HIGH422PROFILE:
      return "H264PROFILE_HIGH422PROFILE";
    case VideoCodecProfile::H264PROFILE_HIGH444PREDICTIVEPROFILE:
      return "H264PROFILE_HIGH444PREDICTIVEPROFILE";
    case VideoCodecProfile::H264PROFILE_SCALABLEBASELINE:
      return "H264PROFILE_SCALABLEBASELINE";
    case VideoCodecProfile::H264PROFILE_SCALABLEHIGH:
      return "H264PROFILE_SCALABLEHIGH";
    case VideoCodecProfile::H264PROFILE_STEREOHIGH:
      return "H264PROFILE_STEREOHIGH";
    case VideoCodecProfile::H264PROFILE_MULTIVIEWHIGH:
      return "H264PROFILE_MULTIVIEWHIGH";
    case VideoCodecProfile::VP8PROFILE_ANY:
      return "VP8PROFILE_ANY";
    case VideoCodecProfile::VP9PROFILE_PROFILE0:
      return "VP9PROFILE_PROFILE0";
    case VideoCodecProfile::VP9PROFILE_PROFILE1:
      return "VP9PROFILE_PROFILE1";
    case VideoCodecProfile::VP9PROFILE_PROFILE2:
      return "VP9PROFILE_PROFILE2";
    case VideoCodecProfile::VP9PROFILE_PROFILE3:
      return "VP9PROFILE_PROFILE3";
    case VideoCodecProfile::HEVCPROFILE_MAIN:
      return "HEVCPROFILE_MAIN";
    case VideoCodecProfile::HEVCPROFILE_MAIN10:
      return "HEVCPROFILE_MAIN10";
    case VideoCodecProfile::HEVCPROFILE_MAIN_STILL_PICTURE:
      return "HEVCPROFILE_MAIN_STILL_PICTURE";
    case VideoCodecProfile::DOLBYVISION_PROFILE0:
      return "DOLBYVISION_PROFILE0";
    case VideoCodecProfile::DOLBYVISION_PROFILE5:
      return "DOLBYVISION_PROFILE5";
    case VideoCodecProfile::DOLBYVISION_PROFILE7:
      return "DOLBYVISION_PROFILE7";
    case VideoCodecProfile::THEORAPROFILE_ANY:
      return "THEORAPROFILE_ANY";
    case VideoCodecProfile::AV1PROFILE_PROFILE_MAIN:
      return "AV1PROFILE_PROFILE_MAIN";
    case VideoCodecProfile::AV1PROFILE_PROFILE_HIGH:
      return "AV1PROFILE_PROFILE_HIGH";
    case VideoCodecProfile::AV1PROFILE_PROFILE_PRO:
      return "AV1PROFILE_PROFILE_PRO";
    case VideoCodecProfile::DOLBYVISION_PROFILE8:
      return "DOLBYVISION_PROFILE8";
    case VideoCodecProfile::DOLBYVISION_PROFILE9:
      return "DOLBYVISION_PROFILE9";
    case VideoCodecProfile::HEVCPROFILE_REXT:
      return "HEVCPROFILE_REXT";
    case VideoCodecProfile::HEVCPROFILE_HIGH_THROUGHPUT:
      return "HEVCPROFILE_HIGH_THROUGHPUT";
    case VideoCodecProfile::HEVCPROFILE_MULTIVIEW_MAIN:
      return "HEVCPROFILE_MULTIVIEW_MAIN";
    case VideoCodecProfile::HEVCPROFILE_SCALABLE_MAIN:
      return "HEVCPROFILE_SCALABLE_MAIN";
    case VideoCodecProfile::HEVCPROFILE_3D_MAIN:
      return "HEVCPROFILE_3D_MAIN";
    case VideoCodecProfile::HEVCPROFILE_SCREEN_EXTENDED:
      return "HEVCPROFILE_SCREEN_EXTENDED";
    case VideoCodecProfile::HEVCPROFILE_SCALABLE_REXT:
      return "HEVCPROFILE_SCALABLE_REXT";
    case VideoCodecProfile::HEVCPROFILE_HIGH_THROUGHPUT_SCREEN_EXTENDED:
      return "HEVCPROFILE_HIGH_THROUGHPUT_SCREEN_EXTENDED";
    case VideoCodecProfile::VVCPROFILE_MAIN10:
      return "VVCPROFILE_MAIN10";
    case VideoCodecProfile::VVCPROFILE_MAIN12:
      return "VVCPROFILE_MAIN12";
    case VideoCodecProfile::VVCPROFILE_MAIN12_INTRA:
      return "VVCPROFILE_MAIN12_INTRA";
    case VideoCodecProfile::VVCPROIFLE_MULTILAYER_MAIN10:
      return "VVCPROIFLE_MULTILAYER_MAIN10";
    case VideoCodecProfile::VVCPROFILE_MAIN10_444:
      return "VVCPROFILE_MAIN10_444";
    case VideoCodecProfile::VVCPROFILE_MAIN12_444:
      return "VVCPROFILE_MAIN12_444";
    case VideoCodecProfile::VVCPROFILE_MAIN16_444:
      return "VVCPROFILE_MAIN16_444";
    case VideoCodecProfile::VVCPROFILE_MAIN12_444_INTRA:
      return "VVCPROFILE_MAIN12_444_INTRA";
    case VideoCodecProfile::VVCPROFILE_MAIN16_444_INTRA:
      return "VVCPROFILE_MAIN16_444_INTRA";
    case VideoCodecProfile::VVCPROFILE_MULTILAYER_MAIN10_444:
      return "VVCPROFILE_MULTILAYER_MAIN10_444";
    case VideoCodecProfile::VVCPROFILE_MAIN10_STILL_PICTURE:
      return "VVCPROFILE_MAIN10_STILL_PICTURE";
    case VideoCodecProfile::VVCPROFILE_MAIN12_STILL_PICTURE:
      return "VVCPROFILE_MAIN12_STILL_PICTURE";
    case VideoCodecProfile::VVCPROFILE_MAIN10_444_STILL_PICTURE:
      return "VVCPROFILE_MAIN10_444_STILL_PICTURE";
    case VideoCodecProfile::VVCPROFILE_MAIN12_444_STILL_PICTURE:
      return "VVCPROFILE_MAIN12_444_STILL_PICTURE";
    case VideoCodecProfile::VVCPROFILE_MAIN16_444_STILL_PICTURE:
      return "VVCPROFILE_MAIN16_444_STILL_PICTURE";
    default:
      return nullptr;
  }
}

std::string VideoCodecProfileToString(VideoCodecProfile value) {
  const char *str = VideoCodecProfileToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VideoCodecProfile value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VideoCodecProfile value) {
  return os << VideoCodecProfileToString(value);
}

NOINLINE static const char* ImageDecodeAcceleratorTypeToStringHelper(ImageDecodeAcceleratorType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ImageDecodeAcceleratorType::kJpeg:
      return "kJpeg";
    case ImageDecodeAcceleratorType::kWebP:
      return "kWebP";
    case ImageDecodeAcceleratorType::kUnknown:
      return "kUnknown";
    default:
      return nullptr;
  }
}

std::string ImageDecodeAcceleratorTypeToString(ImageDecodeAcceleratorType value) {
  const char *str = ImageDecodeAcceleratorTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ImageDecodeAcceleratorType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ImageDecodeAcceleratorType value) {
  return os << ImageDecodeAcceleratorTypeToString(value);
}

NOINLINE static const char* ImageDecodeAcceleratorSubsamplingToStringHelper(ImageDecodeAcceleratorSubsampling value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ImageDecodeAcceleratorSubsampling::k420:
      return "k420";
    case ImageDecodeAcceleratorSubsampling::k422:
      return "k422";
    case ImageDecodeAcceleratorSubsampling::k444:
      return "k444";
    default:
      return nullptr;
  }
}

std::string ImageDecodeAcceleratorSubsamplingToString(ImageDecodeAcceleratorSubsampling value) {
  const char *str = ImageDecodeAcceleratorSubsamplingToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ImageDecodeAcceleratorSubsampling value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ImageDecodeAcceleratorSubsampling value) {
  return os << ImageDecodeAcceleratorSubsamplingToString(value);
}

namespace internal {


// static
bool GpuDevice_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuDevice_Data* object =
      static_cast<const GpuDevice_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->vendor_string, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& vendor_string_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->vendor_string, validation_context,
                                         &vendor_string_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_string, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& device_string_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->device_string, validation_context,
                                         &device_string_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->driver_vendor, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& driver_vendor_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->driver_vendor, validation_context,
                                         &driver_vendor_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->driver_version, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& driver_version_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->driver_version, validation_context,
                                         &driver_version_validate_params)) {
    return false;
  }


  if (!::gl::mojom::internal::GpuPreference_Data
        ::Validate(object->gpu_preference, validation_context))
    return false;

  return true;
}

GpuDevice_Data::GpuDevice_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoDecodeAcceleratorSupportedProfile_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoDecodeAcceleratorSupportedProfile_Data* object =
      static_cast<const VideoDecodeAcceleratorSupportedProfile_Data*>(data);


  if (!::gpu::mojom::internal::VideoCodecProfile_Data
        ::Validate(object->profile, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->max_resolution, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->max_resolution, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->min_resolution, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->min_resolution, validation_context))
    return false;

  return true;
}

VideoDecodeAcceleratorSupportedProfile_Data::VideoDecodeAcceleratorSupportedProfile_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoDecodeAcceleratorCapabilities_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoDecodeAcceleratorCapabilities_Data* object =
      static_cast<const VideoDecodeAcceleratorCapabilities_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->supported_profiles, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& supported_profiles_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->supported_profiles, validation_context,
                                         &supported_profiles_validate_params)) {
    return false;
  }

  return true;
}

VideoDecodeAcceleratorCapabilities_Data::VideoDecodeAcceleratorCapabilities_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncodeAcceleratorSupportedProfile_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoEncodeAcceleratorSupportedProfile_Data* object =
      static_cast<const VideoEncodeAcceleratorSupportedProfile_Data*>(data);


  if (!::gpu::mojom::internal::VideoCodecProfile_Data
        ::Validate(object->profile, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->min_resolution, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->min_resolution, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->max_resolution, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->max_resolution, validation_context))
    return false;

  return true;
}

VideoEncodeAcceleratorSupportedProfile_Data::VideoEncodeAcceleratorSupportedProfile_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ImageDecodeAcceleratorSupportedProfile_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ImageDecodeAcceleratorSupportedProfile_Data* object =
      static_cast<const ImageDecodeAcceleratorSupportedProfile_Data*>(data);


  if (!::gpu::mojom::internal::ImageDecodeAcceleratorType_Data
        ::Validate(object->image_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->min_encoded_dimensions, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->min_encoded_dimensions, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->max_encoded_dimensions, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->max_encoded_dimensions, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->subsamplings, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& subsamplings_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::gpu::mojom::internal::ImageDecodeAcceleratorSubsampling_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->subsamplings, validation_context,
                                         &subsamplings_validate_params)) {
    return false;
  }

  return true;
}

ImageDecodeAcceleratorSupportedProfile_Data::ImageDecodeAcceleratorSupportedProfile_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 192, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuInfo_Data* object =
      static_cast<const GpuInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->initialization_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->initialization_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gpu, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->gpu, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->secondary_gpus, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& secondary_gpus_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->secondary_gpus, validation_context,
                                         &secondary_gpus_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->npus, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& npus_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->npus, validation_context,
                                         &npus_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pixel_shader_version, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& pixel_shader_version_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->pixel_shader_version, validation_context,
                                         &pixel_shader_version_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->vertex_shader_version, 8, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& vertex_shader_version_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->vertex_shader_version, validation_context,
                                         &vertex_shader_version_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->max_msaa_samples, 9, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& max_msaa_samples_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->max_msaa_samples, validation_context,
                                         &max_msaa_samples_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->machine_model_name, 10, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& machine_model_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->machine_model_name, validation_context,
                                         &machine_model_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->machine_model_version, 11, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& machine_model_version_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->machine_model_version, validation_context,
                                         &machine_model_version_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_type, 12, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& display_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->display_type, validation_context,
                                         &display_type_validate_params)) {
    return false;
  }


  if (!::gpu::mojom::internal::SkiaBackendType_Data
        ::Validate(object->skia_backend_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gl_version, 14, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& gl_version_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->gl_version, validation_context,
                                         &gl_version_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gl_vendor, 15, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& gl_vendor_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->gl_vendor, validation_context,
                                         &gl_vendor_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gl_renderer, 16, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& gl_renderer_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->gl_renderer, validation_context,
                                         &gl_renderer_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gl_extensions, 17, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& gl_extensions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->gl_extensions, validation_context,
                                         &gl_extensions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gl_ws_vendor, 18, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& gl_ws_vendor_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->gl_ws_vendor, validation_context,
                                         &gl_ws_vendor_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gl_ws_version, 19, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& gl_ws_version_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->gl_ws_version, validation_context,
                                         &gl_ws_version_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gl_ws_extensions, 20, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& gl_ws_extensions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->gl_ws_extensions, validation_context,
                                         &gl_ws_extensions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gl_implementation_parts, 22, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->gl_implementation_parts, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->direct_rendering_version, 23, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& direct_rendering_version_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->direct_rendering_version, validation_context,
                                         &direct_rendering_version_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->video_decode_accelerator_supported_profiles, 28, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& video_decode_accelerator_supported_profiles_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->video_decode_accelerator_supported_profiles, validation_context,
                                         &video_decode_accelerator_supported_profiles_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->video_encode_accelerator_supported_profiles, 29, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& video_encode_accelerator_supported_profiles_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->video_encode_accelerator_supported_profiles, validation_context,
                                         &video_encode_accelerator_supported_profiles_validate_params)) {
    return false;
  }

  return true;
}

GpuInfo_Data::GpuInfo_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace gpu

namespace perfetto {

// static
void TraceFormatTraits<::gpu::mojom::SkiaBackendType>::WriteIntoTrace(
   perfetto::TracedValue context, ::gpu::mojom::SkiaBackendType value) {
  return std::move(context).WriteString(::gpu::mojom::SkiaBackendTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::gpu::mojom::VideoCodecProfile>::WriteIntoTrace(
   perfetto::TracedValue context, ::gpu::mojom::VideoCodecProfile value) {
  return std::move(context).WriteString(::gpu::mojom::VideoCodecProfileToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::gpu::mojom::ImageDecodeAcceleratorType>::WriteIntoTrace(
   perfetto::TracedValue context, ::gpu::mojom::ImageDecodeAcceleratorType value) {
  return std::move(context).WriteString(::gpu::mojom::ImageDecodeAcceleratorTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::gpu::mojom::ImageDecodeAcceleratorSubsampling>::WriteIntoTrace(
   perfetto::TracedValue context, ::gpu::mojom::ImageDecodeAcceleratorSubsampling value) {
  return std::move(context).WriteString(::gpu::mojom::ImageDecodeAcceleratorSubsamplingToString(value));
}

} // namespace perfetto