// gpu/ipc/common/gpu_disk_cache_type.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'gpu/ipc/common/gpu_disk_cache_type.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('gpu.mojom');


  var GpuDiskCacheType = {};
  GpuDiskCacheType.kGlShaders = 0;
  GpuDiskCacheType.kDawnWebGPU = 1;
  GpuDiskCacheType.kDawnGraphite = 2;
  GpuDiskCacheType.MIN_VALUE = 0;
  GpuDiskCacheType.MAX_VALUE = 2;

  GpuDiskCacheType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  GpuDiskCacheType.toKnownEnumValue = function(value) {
    return value;
  };

  GpuDiskCacheType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function GpuDiskCacheGlShaderHandle(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GpuDiskCacheGlShaderHandle.prototype.initDefaults_ = function() {
    this.value = 0;
  };
  GpuDiskCacheGlShaderHandle.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GpuDiskCacheGlShaderHandle.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  GpuDiskCacheGlShaderHandle.encodedSize = codec.kStructHeaderSize + 8;

  GpuDiskCacheGlShaderHandle.decode = function(decoder) {
    var packed;
    var val = new GpuDiskCacheGlShaderHandle();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  GpuDiskCacheGlShaderHandle.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GpuDiskCacheGlShaderHandle.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function GpuDiskCacheDawnWebGPUHandle(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GpuDiskCacheDawnWebGPUHandle.prototype.initDefaults_ = function() {
    this.value = 0;
  };
  GpuDiskCacheDawnWebGPUHandle.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GpuDiskCacheDawnWebGPUHandle.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  GpuDiskCacheDawnWebGPUHandle.encodedSize = codec.kStructHeaderSize + 8;

  GpuDiskCacheDawnWebGPUHandle.decode = function(decoder) {
    var packed;
    var val = new GpuDiskCacheDawnWebGPUHandle();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  GpuDiskCacheDawnWebGPUHandle.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GpuDiskCacheDawnWebGPUHandle.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function GpuDiskCacheDawnGraphiteHandle(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GpuDiskCacheDawnGraphiteHandle.prototype.initDefaults_ = function() {
    this.value = 0;
  };
  GpuDiskCacheDawnGraphiteHandle.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GpuDiskCacheDawnGraphiteHandle.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  GpuDiskCacheDawnGraphiteHandle.encodedSize = codec.kStructHeaderSize + 8;

  GpuDiskCacheDawnGraphiteHandle.decode = function(decoder) {
    var packed;
    var val = new GpuDiskCacheDawnGraphiteHandle();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  GpuDiskCacheDawnGraphiteHandle.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GpuDiskCacheDawnGraphiteHandle.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };

  function GpuDiskCacheHandle(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  GpuDiskCacheHandle.Tags = {
    glShaderHandle: 0,
    dawnWebgpuHandle: 1,
    dawnGraphiteHandle: 2,
  };

  GpuDiskCacheHandle.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  GpuDiskCacheHandle.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "glShaderHandle",
        "dawnWebgpuHandle",
        "dawnGraphiteHandle",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a GpuDiskCacheHandle member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(GpuDiskCacheHandle.prototype, "glShaderHandle", {
    get: function() {
      if (this.$tag != GpuDiskCacheHandle.Tags.glShaderHandle) {
        throw new ReferenceError(
            "GpuDiskCacheHandle.glShaderHandle is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = GpuDiskCacheHandle.Tags.glShaderHandle;
      this.$data = value;
    }
  });
  Object.defineProperty(GpuDiskCacheHandle.prototype, "dawnWebgpuHandle", {
    get: function() {
      if (this.$tag != GpuDiskCacheHandle.Tags.dawnWebgpuHandle) {
        throw new ReferenceError(
            "GpuDiskCacheHandle.dawnWebgpuHandle is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = GpuDiskCacheHandle.Tags.dawnWebgpuHandle;
      this.$data = value;
    }
  });
  Object.defineProperty(GpuDiskCacheHandle.prototype, "dawnGraphiteHandle", {
    get: function() {
      if (this.$tag != GpuDiskCacheHandle.Tags.dawnGraphiteHandle) {
        throw new ReferenceError(
            "GpuDiskCacheHandle.dawnGraphiteHandle is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = GpuDiskCacheHandle.Tags.dawnGraphiteHandle;
      this.$data = value;
    }
  });


    GpuDiskCacheHandle.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case GpuDiskCacheHandle.Tags.glShaderHandle:
          encoder.encodeStructPointer(GpuDiskCacheGlShaderHandle, val.glShaderHandle);
          break;
        case GpuDiskCacheHandle.Tags.dawnWebgpuHandle:
          encoder.encodeStructPointer(GpuDiskCacheDawnWebGPUHandle, val.dawnWebgpuHandle);
          break;
        case GpuDiskCacheHandle.Tags.dawnGraphiteHandle:
          encoder.encodeStructPointer(GpuDiskCacheDawnGraphiteHandle, val.dawnGraphiteHandle);
          break;
      }
      encoder.align();
    };


    GpuDiskCacheHandle.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new GpuDiskCacheHandle();
      var tag = decoder.readUint32();
      switch (tag) {
        case GpuDiskCacheHandle.Tags.glShaderHandle:
          result.glShaderHandle = decoder.decodeStructPointer(GpuDiskCacheGlShaderHandle);
          break;
        case GpuDiskCacheHandle.Tags.dawnWebgpuHandle:
          result.dawnWebgpuHandle = decoder.decodeStructPointer(GpuDiskCacheDawnWebGPUHandle);
          break;
        case GpuDiskCacheHandle.Tags.dawnGraphiteHandle:
          result.dawnGraphiteHandle = decoder.decodeStructPointer(GpuDiskCacheDawnGraphiteHandle);
          break;
      }
      decoder.align();

      return result;
    };


    GpuDiskCacheHandle.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case GpuDiskCacheHandle.Tags.glShaderHandle:
          

    // validate GpuDiskCacheHandle.glShaderHandle
    err = messageValidator.validateStructPointer(data_offset, GpuDiskCacheGlShaderHandle, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case GpuDiskCacheHandle.Tags.dawnWebgpuHandle:
          

    // validate GpuDiskCacheHandle.dawnWebgpuHandle
    err = messageValidator.validateStructPointer(data_offset, GpuDiskCacheDawnWebGPUHandle, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case GpuDiskCacheHandle.Tags.dawnGraphiteHandle:
          

    // validate GpuDiskCacheHandle.dawnGraphiteHandle
    err = messageValidator.validateStructPointer(data_offset, GpuDiskCacheDawnGraphiteHandle, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  GpuDiskCacheHandle.encodedSize = 16;
  exports.GpuDiskCacheType = GpuDiskCacheType;
  exports.GpuDiskCacheGlShaderHandle = GpuDiskCacheGlShaderHandle;
  exports.GpuDiskCacheDawnWebGPUHandle = GpuDiskCacheDawnWebGPUHandle;
  exports.GpuDiskCacheDawnGraphiteHandle = GpuDiskCacheDawnGraphiteHandle;
  exports.GpuDiskCacheHandle = GpuDiskCacheHandle;
})();