// gpu/ipc/common/gpu_channel.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_GPU_CHANNEL_MOJOM_PARAMS_DATA_H_
#define GPU_IPC_COMMON_GPU_CHANNEL_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace gpu::mojom {
namespace internal {
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) GpuChannel_CrashForTesting_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<GpuChannel_CrashForTesting_Params_Data>;

  GpuChannel_CrashForTesting_Params_Data();
  ~GpuChannel_CrashForTesting_Params_Data() = delete;
};
static_assert(sizeof(GpuChannel_CrashForTesting_Params_Data) == 8,
              "Bad sizeof(GpuChannel_CrashForTesting_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) GpuChannel_TerminateForTesting_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<GpuChannel_TerminateForTesting_Params_Data>;

  GpuChannel_TerminateForTesting_Params_Data();
  ~GpuChannel_TerminateForTesting_Params_Data() = delete;
};
static_assert(sizeof(GpuChannel_TerminateForTesting_Params_Data) == 8,
              "Bad sizeof(GpuChannel_TerminateForTesting_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) GpuChannel_GetChannelToken_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<GpuChannel_GetChannelToken_Params_Data>;

  GpuChannel_GetChannelToken_Params_Data();
  ~GpuChannel_GetChannelToken_Params_Data() = delete;
};
static_assert(sizeof(GpuChannel_GetChannelToken_Params_Data) == 8,
              "Bad sizeof(GpuChannel_GetChannelToken_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) GpuChannel_GetChannelToken_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> token;

 private:
  friend class mojo::internal::MessageFragment<GpuChannel_GetChannelToken_ResponseParams_Data>;

  GpuChannel_GetChannelToken_ResponseParams_Data();
  ~GpuChannel_GetChannelToken_ResponseParams_Data() = delete;
};
static_assert(sizeof(GpuChannel_GetChannelToken_ResponseParams_Data) == 16,
              "Bad sizeof(GpuChannel_GetChannelToken_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) GpuChannel_Flush_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<GpuChannel_Flush_Params_Data>;

  GpuChannel_Flush_Params_Data();
  ~GpuChannel_Flush_Params_Data() = delete;
};
static_assert(sizeof(GpuChannel_Flush_Params_Data) == 8,
              "Bad sizeof(GpuChannel_Flush_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) GpuChannel_Flush_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<GpuChannel_Flush_ResponseParams_Data>;

  GpuChannel_Flush_ResponseParams_Data();
  ~GpuChannel_Flush_ResponseParams_Data() = delete;
};
static_assert(sizeof(GpuChannel_Flush_ResponseParams_Data) == 8,
              "Bad sizeof(GpuChannel_Flush_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) GpuChannel_GetSharedMemoryForFlushId_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<GpuChannel_GetSharedMemoryForFlushId_Params_Data>;

  GpuChannel_GetSharedMemoryForFlushId_Params_Data();
  ~GpuChannel_GetSharedMemoryForFlushId_Params_Data() = delete;
};
static_assert(sizeof(GpuChannel_GetSharedMemoryForFlushId_Params_Data) == 8,
              "Bad sizeof(GpuChannel_GetSharedMemoryForFlushId_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) GpuChannel_GetSharedMemoryForFlushId_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlySharedMemoryRegion_Data> version_buffer;

 private:
  friend class mojo::internal::MessageFragment<GpuChannel_GetSharedMemoryForFlushId_ResponseParams_Data>;

  GpuChannel_GetSharedMemoryForFlushId_ResponseParams_Data();
  ~GpuChannel_GetSharedMemoryForFlushId_ResponseParams_Data() = delete;
};
static_assert(sizeof(GpuChannel_GetSharedMemoryForFlushId_ResponseParams_Data) == 16,
              "Bad sizeof(GpuChannel_GetSharedMemoryForFlushId_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) GpuChannel_CreateCommandBuffer_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::CreateCommandBufferParams_Data> params;
  int32_t routing_id;
  mojo::internal::AssociatedEndpointHandle_Data receiver;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnsafeSharedMemoryRegion_Data> shared_state;
  mojo::internal::AssociatedInterface_Data client;

 private:
  friend class mojo::internal::MessageFragment<GpuChannel_CreateCommandBuffer_Params_Data>;

  GpuChannel_CreateCommandBuffer_Params_Data();
  ~GpuChannel_CreateCommandBuffer_Params_Data() = delete;
};
static_assert(sizeof(GpuChannel_CreateCommandBuffer_Params_Data) == 40,
              "Bad sizeof(GpuChannel_CreateCommandBuffer_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) GpuChannel_CreateCommandBuffer_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t result;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::gpu::mojom::internal::Capabilities_Data> capabilties;
  mojo::internal::Pointer<::gpu::mojom::internal::GLCapabilities_Data> gl_capabilities;

 private:
  friend class mojo::internal::MessageFragment<GpuChannel_CreateCommandBuffer_ResponseParams_Data>;

  GpuChannel_CreateCommandBuffer_ResponseParams_Data();
  ~GpuChannel_CreateCommandBuffer_ResponseParams_Data() = delete;
};
static_assert(sizeof(GpuChannel_CreateCommandBuffer_ResponseParams_Data) == 32,
              "Bad sizeof(GpuChannel_CreateCommandBuffer_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) GpuChannel_DestroyCommandBuffer_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t routing_id;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<GpuChannel_DestroyCommandBuffer_Params_Data>;

  GpuChannel_DestroyCommandBuffer_Params_Data();
  ~GpuChannel_DestroyCommandBuffer_Params_Data() = delete;
};
static_assert(sizeof(GpuChannel_DestroyCommandBuffer_Params_Data) == 16,
              "Bad sizeof(GpuChannel_DestroyCommandBuffer_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) GpuChannel_DestroyCommandBuffer_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<GpuChannel_DestroyCommandBuffer_ResponseParams_Data>;

  GpuChannel_DestroyCommandBuffer_ResponseParams_Data();
  ~GpuChannel_DestroyCommandBuffer_ResponseParams_Data() = delete;
};
static_assert(sizeof(GpuChannel_DestroyCommandBuffer_ResponseParams_Data) == 8,
              "Bad sizeof(GpuChannel_DestroyCommandBuffer_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) GpuChannel_FlushDeferredRequests_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::DeferredRequest_Data>>> requests;
  uint32_t flushed_deferred_message_id;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<GpuChannel_FlushDeferredRequests_Params_Data>;

  GpuChannel_FlushDeferredRequests_Params_Data();
  ~GpuChannel_FlushDeferredRequests_Params_Data() = delete;
};
static_assert(sizeof(GpuChannel_FlushDeferredRequests_Params_Data) == 24,
              "Bad sizeof(GpuChannel_FlushDeferredRequests_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) GpuChannel_CreateGpuMemoryBuffer_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> size;
  ::viz::mojom::internal::SharedImageFormat_Data format;
  int32_t buffer_usage;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<GpuChannel_CreateGpuMemoryBuffer_Params_Data>;

  GpuChannel_CreateGpuMemoryBuffer_Params_Data();
  ~GpuChannel_CreateGpuMemoryBuffer_Params_Data() = delete;
};
static_assert(sizeof(GpuChannel_CreateGpuMemoryBuffer_Params_Data) == 40,
              "Bad sizeof(GpuChannel_CreateGpuMemoryBuffer_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) GpuChannel_CreateGpuMemoryBuffer_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gfx::mojom::internal::GpuMemoryBufferHandle_Data> buffer_handle;

 private:
  friend class mojo::internal::MessageFragment<GpuChannel_CreateGpuMemoryBuffer_ResponseParams_Data>;

  GpuChannel_CreateGpuMemoryBuffer_ResponseParams_Data();
  ~GpuChannel_CreateGpuMemoryBuffer_ResponseParams_Data() = delete;
};
static_assert(sizeof(GpuChannel_CreateGpuMemoryBuffer_ResponseParams_Data) == 16,
              "Bad sizeof(GpuChannel_CreateGpuMemoryBuffer_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) GpuChannel_WaitForTokenInRange_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t routing_id;
  int32_t start;
  int32_t end;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<GpuChannel_WaitForTokenInRange_Params_Data>;

  GpuChannel_WaitForTokenInRange_Params_Data();
  ~GpuChannel_WaitForTokenInRange_Params_Data() = delete;
};
static_assert(sizeof(GpuChannel_WaitForTokenInRange_Params_Data) == 24,
              "Bad sizeof(GpuChannel_WaitForTokenInRange_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) GpuChannel_WaitForTokenInRange_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::CommandBufferState_Data> state;

 private:
  friend class mojo::internal::MessageFragment<GpuChannel_WaitForTokenInRange_ResponseParams_Data>;

  GpuChannel_WaitForTokenInRange_ResponseParams_Data();
  ~GpuChannel_WaitForTokenInRange_ResponseParams_Data() = delete;
};
static_assert(sizeof(GpuChannel_WaitForTokenInRange_ResponseParams_Data) == 16,
              "Bad sizeof(GpuChannel_WaitForTokenInRange_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) GpuChannel_WaitForGetOffsetInRange_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t routing_id;
  uint32_t set_get_buffer_count;
  int32_t start;
  int32_t end;

 private:
  friend class mojo::internal::MessageFragment<GpuChannel_WaitForGetOffsetInRange_Params_Data>;

  GpuChannel_WaitForGetOffsetInRange_Params_Data();
  ~GpuChannel_WaitForGetOffsetInRange_Params_Data() = delete;
};
static_assert(sizeof(GpuChannel_WaitForGetOffsetInRange_Params_Data) == 24,
              "Bad sizeof(GpuChannel_WaitForGetOffsetInRange_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) GpuChannel_WaitForGetOffsetInRange_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::CommandBufferState_Data> state;

 private:
  friend class mojo::internal::MessageFragment<GpuChannel_WaitForGetOffsetInRange_ResponseParams_Data>;

  GpuChannel_WaitForGetOffsetInRange_ResponseParams_Data();
  ~GpuChannel_WaitForGetOffsetInRange_ResponseParams_Data() = delete;
};
static_assert(sizeof(GpuChannel_WaitForGetOffsetInRange_ResponseParams_Data) == 16,
              "Bad sizeof(GpuChannel_WaitForGetOffsetInRange_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) CommandBuffer_SetGetBuffer_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t shm_id;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<CommandBuffer_SetGetBuffer_Params_Data>;

  CommandBuffer_SetGetBuffer_Params_Data();
  ~CommandBuffer_SetGetBuffer_Params_Data() = delete;
};
static_assert(sizeof(CommandBuffer_SetGetBuffer_Params_Data) == 16,
              "Bad sizeof(CommandBuffer_SetGetBuffer_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) CommandBuffer_RegisterTransferBuffer_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t id;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnsafeSharedMemoryRegion_Data> buffer;

 private:
  friend class mojo::internal::MessageFragment<CommandBuffer_RegisterTransferBuffer_Params_Data>;

  CommandBuffer_RegisterTransferBuffer_Params_Data();
  ~CommandBuffer_RegisterTransferBuffer_Params_Data() = delete;
};
static_assert(sizeof(CommandBuffer_RegisterTransferBuffer_Params_Data) == 24,
              "Bad sizeof(CommandBuffer_RegisterTransferBuffer_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) CommandBuffer_CreateGpuFenceFromHandle_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t gpu_fence_id;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::gfx::mojom::internal::GpuFenceHandle_Data> fence_handle;

 private:
  friend class mojo::internal::MessageFragment<CommandBuffer_CreateGpuFenceFromHandle_Params_Data>;

  CommandBuffer_CreateGpuFenceFromHandle_Params_Data();
  ~CommandBuffer_CreateGpuFenceFromHandle_Params_Data() = delete;
};
static_assert(sizeof(CommandBuffer_CreateGpuFenceFromHandle_Params_Data) == 24,
              "Bad sizeof(CommandBuffer_CreateGpuFenceFromHandle_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) CommandBuffer_GetGpuFenceHandle_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t id;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<CommandBuffer_GetGpuFenceHandle_Params_Data>;

  CommandBuffer_GetGpuFenceHandle_Params_Data();
  ~CommandBuffer_GetGpuFenceHandle_Params_Data() = delete;
};
static_assert(sizeof(CommandBuffer_GetGpuFenceHandle_Params_Data) == 16,
              "Bad sizeof(CommandBuffer_GetGpuFenceHandle_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) CommandBuffer_GetGpuFenceHandle_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gfx::mojom::internal::GpuFenceHandle_Data> fence_handle;

 private:
  friend class mojo::internal::MessageFragment<CommandBuffer_GetGpuFenceHandle_ResponseParams_Data>;

  CommandBuffer_GetGpuFenceHandle_ResponseParams_Data();
  ~CommandBuffer_GetGpuFenceHandle_ResponseParams_Data() = delete;
};
static_assert(sizeof(CommandBuffer_GetGpuFenceHandle_ResponseParams_Data) == 16,
              "Bad sizeof(CommandBuffer_GetGpuFenceHandle_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) CommandBuffer_SignalSyncToken_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gpu::mojom::internal::SyncToken_Data> sync_token;
  uint32_t signal_id;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<CommandBuffer_SignalSyncToken_Params_Data>;

  CommandBuffer_SignalSyncToken_Params_Data();
  ~CommandBuffer_SignalSyncToken_Params_Data() = delete;
};
static_assert(sizeof(CommandBuffer_SignalSyncToken_Params_Data) == 24,
              "Bad sizeof(CommandBuffer_SignalSyncToken_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) CommandBuffer_SignalQuery_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t query;
  uint32_t signal_id;

 private:
  friend class mojo::internal::MessageFragment<CommandBuffer_SignalQuery_Params_Data>;

  CommandBuffer_SignalQuery_Params_Data();
  ~CommandBuffer_SignalQuery_Params_Data() = delete;
};
static_assert(sizeof(CommandBuffer_SignalQuery_Params_Data) == 16,
              "Bad sizeof(CommandBuffer_SignalQuery_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) CommandBufferClient_OnConsoleMessage_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> message;

 private:
  friend class mojo::internal::MessageFragment<CommandBufferClient_OnConsoleMessage_Params_Data>;

  CommandBufferClient_OnConsoleMessage_Params_Data();
  ~CommandBufferClient_OnConsoleMessage_Params_Data() = delete;
};
static_assert(sizeof(CommandBufferClient_OnConsoleMessage_Params_Data) == 16,
              "Bad sizeof(CommandBufferClient_OnConsoleMessage_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) CommandBufferClient_OnGpuSwitched_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<CommandBufferClient_OnGpuSwitched_Params_Data>;

  CommandBufferClient_OnGpuSwitched_Params_Data();
  ~CommandBufferClient_OnGpuSwitched_Params_Data() = delete;
};
static_assert(sizeof(CommandBufferClient_OnGpuSwitched_Params_Data) == 8,
              "Bad sizeof(CommandBufferClient_OnGpuSwitched_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) CommandBufferClient_OnDestroyed_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t reason;
  int32_t error;

 private:
  friend class mojo::internal::MessageFragment<CommandBufferClient_OnDestroyed_Params_Data>;

  CommandBufferClient_OnDestroyed_Params_Data();
  ~CommandBufferClient_OnDestroyed_Params_Data() = delete;
};
static_assert(sizeof(CommandBufferClient_OnDestroyed_Params_Data) == 16,
              "Bad sizeof(CommandBufferClient_OnDestroyed_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) CommandBufferClient_OnReturnData_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> data;

 private:
  friend class mojo::internal::MessageFragment<CommandBufferClient_OnReturnData_Params_Data>;

  CommandBufferClient_OnReturnData_Params_Data();
  ~CommandBufferClient_OnReturnData_Params_Data() = delete;
};
static_assert(sizeof(CommandBufferClient_OnReturnData_Params_Data) == 16,
              "Bad sizeof(CommandBufferClient_OnReturnData_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) CommandBufferClient_OnSignalAck_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t signal_id;
  uint8_t pad0_[4];
  mojo::internal::Pointer<internal::CommandBufferState_Data> state;

 private:
  friend class mojo::internal::MessageFragment<CommandBufferClient_OnSignalAck_Params_Data>;

  CommandBufferClient_OnSignalAck_Params_Data();
  ~CommandBufferClient_OnSignalAck_Params_Data() = delete;
};
static_assert(sizeof(CommandBufferClient_OnSignalAck_Params_Data) == 24,
              "Bad sizeof(CommandBufferClient_OnSignalAck_Params_Data)");

}  // namespace internal


class GpuChannel_CrashForTesting_ParamsDataView {
 public:
  GpuChannel_CrashForTesting_ParamsDataView() = default;

  GpuChannel_CrashForTesting_ParamsDataView(
      internal::GpuChannel_CrashForTesting_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuChannel_CrashForTesting_Params_Data* data_ = nullptr;
};


class GpuChannel_TerminateForTesting_ParamsDataView {
 public:
  GpuChannel_TerminateForTesting_ParamsDataView() = default;

  GpuChannel_TerminateForTesting_ParamsDataView(
      internal::GpuChannel_TerminateForTesting_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuChannel_TerminateForTesting_Params_Data* data_ = nullptr;
};


class GpuChannel_GetChannelToken_ParamsDataView {
 public:
  GpuChannel_GetChannelToken_ParamsDataView() = default;

  GpuChannel_GetChannelToken_ParamsDataView(
      internal::GpuChannel_GetChannelToken_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuChannel_GetChannelToken_Params_Data* data_ = nullptr;
};


class GpuChannel_GetChannelToken_ResponseParamsDataView {
 public:
  GpuChannel_GetChannelToken_ResponseParamsDataView() = default;

  GpuChannel_GetChannelToken_ResponseParamsDataView(
      internal::GpuChannel_GetChannelToken_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToken(UserType* output) {
    
    auto* pointer = data_->token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::GpuChannel_GetChannelToken_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GpuChannel_Flush_ParamsDataView {
 public:
  GpuChannel_Flush_ParamsDataView() = default;

  GpuChannel_Flush_ParamsDataView(
      internal::GpuChannel_Flush_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuChannel_Flush_Params_Data* data_ = nullptr;
};


class GpuChannel_Flush_ResponseParamsDataView {
 public:
  GpuChannel_Flush_ResponseParamsDataView() = default;

  GpuChannel_Flush_ResponseParamsDataView(
      internal::GpuChannel_Flush_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuChannel_Flush_ResponseParams_Data* data_ = nullptr;
};


class GpuChannel_GetSharedMemoryForFlushId_ParamsDataView {
 public:
  GpuChannel_GetSharedMemoryForFlushId_ParamsDataView() = default;

  GpuChannel_GetSharedMemoryForFlushId_ParamsDataView(
      internal::GpuChannel_GetSharedMemoryForFlushId_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuChannel_GetSharedMemoryForFlushId_Params_Data* data_ = nullptr;
};


class GpuChannel_GetSharedMemoryForFlushId_ResponseParamsDataView {
 public:
  GpuChannel_GetSharedMemoryForFlushId_ResponseParamsDataView() = default;

  GpuChannel_GetSharedMemoryForFlushId_ResponseParamsDataView(
      internal::GpuChannel_GetSharedMemoryForFlushId_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetVersionBufferDataView(
      ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVersionBuffer(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView, UserType>(),
    "Attempting to read the optional `version_buffer` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadVersionBuffer` instead "
    "of `ReadVersionBuffer if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->version_buffer.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
        pointer, output, message_);
  }
 private:
  internal::GpuChannel_GetSharedMemoryForFlushId_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GpuChannel_CreateCommandBuffer_ParamsDataView {
 public:
  GpuChannel_CreateCommandBuffer_ParamsDataView() = default;

  GpuChannel_CreateCommandBuffer_ParamsDataView(
      internal::GpuChannel_CreateCommandBuffer_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetParamsDataView(
      CreateCommandBufferParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::gpu::mojom::CreateCommandBufferParamsDataView>(
        pointer, output, message_);
  }
  int32_t routing_id() const {
    return data_->routing_id;
  }
  inline void GetSharedStateDataView(
      ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSharedState(UserType* output) {
    
    auto* pointer = data_->shared_state.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::gpu::mojom::CommandBufferAssociatedRequestDataView>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::gpu::mojom::CommandBufferClientAssociatedPtrInfoDataView>(
            &data_->client, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::GpuChannel_CreateCommandBuffer_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GpuChannel_CreateCommandBuffer_ResponseParamsDataView {
 public:
  GpuChannel_CreateCommandBuffer_ResponseParamsDataView() = default;

  GpuChannel_CreateCommandBuffer_ResponseParamsDataView(
      internal::GpuChannel_CreateCommandBuffer_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) const {
    auto data_value = data_->result;
    return mojo::internal::Deserialize<::gpu::mojom::ContextResult>(
        data_value, output);
  }
  ::gpu::mojom::ContextResult result() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gpu::mojom::ContextResult>(data_->result));
  }
  inline void GetCapabiltiesDataView(
      ::gpu::mojom::CapabilitiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCapabilties(UserType* output) {
    
    auto* pointer = data_->capabilties.Get();
    return mojo::internal::Deserialize<::gpu::mojom::CapabilitiesDataView>(
        pointer, output, message_);
  }
  inline void GetGlCapabilitiesDataView(
      ::gpu::mojom::GLCapabilitiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGlCapabilities(UserType* output) {
    
    auto* pointer = data_->gl_capabilities.Get();
    return mojo::internal::Deserialize<::gpu::mojom::GLCapabilitiesDataView>(
        pointer, output, message_);
  }
 private:
  internal::GpuChannel_CreateCommandBuffer_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GpuChannel_DestroyCommandBuffer_ParamsDataView {
 public:
  GpuChannel_DestroyCommandBuffer_ParamsDataView() = default;

  GpuChannel_DestroyCommandBuffer_ParamsDataView(
      internal::GpuChannel_DestroyCommandBuffer_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t routing_id() const {
    return data_->routing_id;
  }
 private:
  internal::GpuChannel_DestroyCommandBuffer_Params_Data* data_ = nullptr;
};


class GpuChannel_DestroyCommandBuffer_ResponseParamsDataView {
 public:
  GpuChannel_DestroyCommandBuffer_ResponseParamsDataView() = default;

  GpuChannel_DestroyCommandBuffer_ResponseParamsDataView(
      internal::GpuChannel_DestroyCommandBuffer_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuChannel_DestroyCommandBuffer_ResponseParams_Data* data_ = nullptr;
};


class GpuChannel_FlushDeferredRequests_ParamsDataView {
 public:
  GpuChannel_FlushDeferredRequests_ParamsDataView() = default;

  GpuChannel_FlushDeferredRequests_ParamsDataView(
      internal::GpuChannel_FlushDeferredRequests_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRequestsDataView(
      mojo::ArrayDataView<DeferredRequestDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequests(UserType* output) {
    
    auto* pointer = data_->requests.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gpu::mojom::DeferredRequestDataView>>(
        pointer, output, message_);
  }
  uint32_t flushed_deferred_message_id() const {
    return data_->flushed_deferred_message_id;
  }
 private:
  internal::GpuChannel_FlushDeferredRequests_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GpuChannel_CreateGpuMemoryBuffer_ParamsDataView {
 public:
  GpuChannel_CreateGpuMemoryBuffer_ParamsDataView() = default;

  GpuChannel_CreateGpuMemoryBuffer_ParamsDataView(
      internal::GpuChannel_CreateGpuMemoryBuffer_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSize(UserType* output) {
    
    auto* pointer = data_->size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetFormatDataView(
      ::viz::mojom::SharedImageFormatDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFormat(UserType* output) {
    
    auto* pointer = !data_->format.is_null() ? &data_->format : nullptr;
    return mojo::internal::Deserialize<::viz::mojom::SharedImageFormatDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadBufferUsage(UserType* output) const {
    auto data_value = data_->buffer_usage;
    return mojo::internal::Deserialize<::gfx::mojom::BufferUsage>(
        data_value, output);
  }
  ::gfx::mojom::BufferUsage buffer_usage() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gfx::mojom::BufferUsage>(data_->buffer_usage));
  }
 private:
  internal::GpuChannel_CreateGpuMemoryBuffer_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GpuChannel_CreateGpuMemoryBuffer_ResponseParamsDataView {
 public:
  GpuChannel_CreateGpuMemoryBuffer_ResponseParamsDataView() = default;

  GpuChannel_CreateGpuMemoryBuffer_ResponseParamsDataView(
      internal::GpuChannel_CreateGpuMemoryBuffer_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBufferHandleDataView(
      ::gfx::mojom::GpuMemoryBufferHandleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBufferHandle(UserType* output) {
    
    auto* pointer = data_->buffer_handle.Get();
    return mojo::internal::Deserialize<::gfx::mojom::GpuMemoryBufferHandleDataView>(
        pointer, output, message_);
  }
 private:
  internal::GpuChannel_CreateGpuMemoryBuffer_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GpuChannel_WaitForTokenInRange_ParamsDataView {
 public:
  GpuChannel_WaitForTokenInRange_ParamsDataView() = default;

  GpuChannel_WaitForTokenInRange_ParamsDataView(
      internal::GpuChannel_WaitForTokenInRange_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t routing_id() const {
    return data_->routing_id;
  }
  int32_t start() const {
    return data_->start;
  }
  int32_t end() const {
    return data_->end;
  }
 private:
  internal::GpuChannel_WaitForTokenInRange_Params_Data* data_ = nullptr;
};


class GpuChannel_WaitForTokenInRange_ResponseParamsDataView {
 public:
  GpuChannel_WaitForTokenInRange_ResponseParamsDataView() = default;

  GpuChannel_WaitForTokenInRange_ResponseParamsDataView(
      internal::GpuChannel_WaitForTokenInRange_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStateDataView(
      CommandBufferStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadState(UserType* output) {
    
    auto* pointer = data_->state.Get();
    return mojo::internal::Deserialize<::gpu::mojom::CommandBufferStateDataView>(
        pointer, output, message_);
  }
 private:
  internal::GpuChannel_WaitForTokenInRange_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GpuChannel_WaitForGetOffsetInRange_ParamsDataView {
 public:
  GpuChannel_WaitForGetOffsetInRange_ParamsDataView() = default;

  GpuChannel_WaitForGetOffsetInRange_ParamsDataView(
      internal::GpuChannel_WaitForGetOffsetInRange_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t routing_id() const {
    return data_->routing_id;
  }
  uint32_t set_get_buffer_count() const {
    return data_->set_get_buffer_count;
  }
  int32_t start() const {
    return data_->start;
  }
  int32_t end() const {
    return data_->end;
  }
 private:
  internal::GpuChannel_WaitForGetOffsetInRange_Params_Data* data_ = nullptr;
};


class GpuChannel_WaitForGetOffsetInRange_ResponseParamsDataView {
 public:
  GpuChannel_WaitForGetOffsetInRange_ResponseParamsDataView() = default;

  GpuChannel_WaitForGetOffsetInRange_ResponseParamsDataView(
      internal::GpuChannel_WaitForGetOffsetInRange_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStateDataView(
      CommandBufferStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadState(UserType* output) {
    
    auto* pointer = data_->state.Get();
    return mojo::internal::Deserialize<::gpu::mojom::CommandBufferStateDataView>(
        pointer, output, message_);
  }
 private:
  internal::GpuChannel_WaitForGetOffsetInRange_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CommandBuffer_SetGetBuffer_ParamsDataView {
 public:
  CommandBuffer_SetGetBuffer_ParamsDataView() = default;

  CommandBuffer_SetGetBuffer_ParamsDataView(
      internal::CommandBuffer_SetGetBuffer_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t shm_id() const {
    return data_->shm_id;
  }
 private:
  internal::CommandBuffer_SetGetBuffer_Params_Data* data_ = nullptr;
};


class CommandBuffer_RegisterTransferBuffer_ParamsDataView {
 public:
  CommandBuffer_RegisterTransferBuffer_ParamsDataView() = default;

  CommandBuffer_RegisterTransferBuffer_ParamsDataView(
      internal::CommandBuffer_RegisterTransferBuffer_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
  inline void GetBufferDataView(
      ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBuffer(UserType* output) {
    
    auto* pointer = data_->buffer.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
        pointer, output, message_);
  }
 private:
  internal::CommandBuffer_RegisterTransferBuffer_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CommandBuffer_CreateGpuFenceFromHandle_ParamsDataView {
 public:
  CommandBuffer_CreateGpuFenceFromHandle_ParamsDataView() = default;

  CommandBuffer_CreateGpuFenceFromHandle_ParamsDataView(
      internal::CommandBuffer_CreateGpuFenceFromHandle_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t gpu_fence_id() const {
    return data_->gpu_fence_id;
  }
  inline void GetFenceHandleDataView(
      ::gfx::mojom::GpuFenceHandleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFenceHandle(UserType* output) {
    
    auto* pointer = data_->fence_handle.Get();
    return mojo::internal::Deserialize<::gfx::mojom::GpuFenceHandleDataView>(
        pointer, output, message_);
  }
 private:
  internal::CommandBuffer_CreateGpuFenceFromHandle_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CommandBuffer_GetGpuFenceHandle_ParamsDataView {
 public:
  CommandBuffer_GetGpuFenceHandle_ParamsDataView() = default;

  CommandBuffer_GetGpuFenceHandle_ParamsDataView(
      internal::CommandBuffer_GetGpuFenceHandle_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t id() const {
    return data_->id;
  }
 private:
  internal::CommandBuffer_GetGpuFenceHandle_Params_Data* data_ = nullptr;
};


class CommandBuffer_GetGpuFenceHandle_ResponseParamsDataView {
 public:
  CommandBuffer_GetGpuFenceHandle_ResponseParamsDataView() = default;

  CommandBuffer_GetGpuFenceHandle_ResponseParamsDataView(
      internal::CommandBuffer_GetGpuFenceHandle_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFenceHandleDataView(
      ::gfx::mojom::GpuFenceHandleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFenceHandle(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::GpuFenceHandleDataView, UserType>(),
    "Attempting to read the optional `fence_handle` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFenceHandle` instead "
    "of `ReadFenceHandle if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->fence_handle.Get();
    return mojo::internal::Deserialize<::gfx::mojom::GpuFenceHandleDataView>(
        pointer, output, message_);
  }
 private:
  internal::CommandBuffer_GetGpuFenceHandle_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CommandBuffer_SignalSyncToken_ParamsDataView {
 public:
  CommandBuffer_SignalSyncToken_ParamsDataView() = default;

  CommandBuffer_SignalSyncToken_ParamsDataView(
      internal::CommandBuffer_SignalSyncToken_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSyncTokenDataView(
      ::gpu::mojom::SyncTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSyncToken(UserType* output) {
    
    auto* pointer = data_->sync_token.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SyncTokenDataView>(
        pointer, output, message_);
  }
  uint32_t signal_id() const {
    return data_->signal_id;
  }
 private:
  internal::CommandBuffer_SignalSyncToken_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CommandBuffer_SignalQuery_ParamsDataView {
 public:
  CommandBuffer_SignalQuery_ParamsDataView() = default;

  CommandBuffer_SignalQuery_ParamsDataView(
      internal::CommandBuffer_SignalQuery_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t query() const {
    return data_->query;
  }
  uint32_t signal_id() const {
    return data_->signal_id;
  }
 private:
  internal::CommandBuffer_SignalQuery_Params_Data* data_ = nullptr;
};


class CommandBufferClient_OnConsoleMessage_ParamsDataView {
 public:
  CommandBufferClient_OnConsoleMessage_ParamsDataView() = default;

  CommandBufferClient_OnConsoleMessage_ParamsDataView(
      internal::CommandBufferClient_OnConsoleMessage_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::CommandBufferClient_OnConsoleMessage_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CommandBufferClient_OnGpuSwitched_ParamsDataView {
 public:
  CommandBufferClient_OnGpuSwitched_ParamsDataView() = default;

  CommandBufferClient_OnGpuSwitched_ParamsDataView(
      internal::CommandBufferClient_OnGpuSwitched_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::CommandBufferClient_OnGpuSwitched_Params_Data* data_ = nullptr;
};


class CommandBufferClient_OnDestroyed_ParamsDataView {
 public:
  CommandBufferClient_OnDestroyed_ParamsDataView() = default;

  CommandBufferClient_OnDestroyed_ParamsDataView(
      internal::CommandBufferClient_OnDestroyed_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadReason(UserType* output) const {
    auto data_value = data_->reason;
    return mojo::internal::Deserialize<::gpu::mojom::ContextLostReason>(
        data_value, output);
  }
  ContextLostReason reason() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gpu::mojom::ContextLostReason>(data_->reason));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::gpu::mojom::Error>(
        data_value, output);
  }
  Error error() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gpu::mojom::Error>(data_->error));
  }
 private:
  internal::CommandBufferClient_OnDestroyed_Params_Data* data_ = nullptr;
};


class CommandBufferClient_OnReturnData_ParamsDataView {
 public:
  CommandBufferClient_OnReturnData_ParamsDataView() = default;

  CommandBufferClient_OnReturnData_ParamsDataView(
      internal::CommandBufferClient_OnReturnData_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::CommandBufferClient_OnReturnData_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CommandBufferClient_OnSignalAck_ParamsDataView {
 public:
  CommandBufferClient_OnSignalAck_ParamsDataView() = default;

  CommandBufferClient_OnSignalAck_ParamsDataView(
      internal::CommandBufferClient_OnSignalAck_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t signal_id() const {
    return data_->signal_id;
  }
  inline void GetStateDataView(
      CommandBufferStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadState(UserType* output) {
    
    auto* pointer = data_->state.Get();
    return mojo::internal::Deserialize<::gpu::mojom::CommandBufferStateDataView>(
        pointer, output, message_);
  }
 private:
  internal::CommandBufferClient_OnSignalAck_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};







inline void GpuChannel_GetChannelToken_ResponseParamsDataView::GetTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}








inline void GpuChannel_GetSharedMemoryForFlushId_ResponseParamsDataView::GetVersionBufferDataView(
    ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output) {
  auto pointer = data_->version_buffer.Get();
  *output = ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView(pointer, message_);
}


inline void GpuChannel_CreateCommandBuffer_ParamsDataView::GetParamsDataView(
    CreateCommandBufferParamsDataView* output) {
  auto pointer = data_->params.Get();
  *output = CreateCommandBufferParamsDataView(pointer, message_);
}
inline void GpuChannel_CreateCommandBuffer_ParamsDataView::GetSharedStateDataView(
    ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView* output) {
  auto pointer = data_->shared_state.Get();
  *output = ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView(pointer, message_);
}


inline void GpuChannel_CreateCommandBuffer_ResponseParamsDataView::GetCapabiltiesDataView(
    ::gpu::mojom::CapabilitiesDataView* output) {
  auto pointer = data_->capabilties.Get();
  *output = ::gpu::mojom::CapabilitiesDataView(pointer, message_);
}
inline void GpuChannel_CreateCommandBuffer_ResponseParamsDataView::GetGlCapabilitiesDataView(
    ::gpu::mojom::GLCapabilitiesDataView* output) {
  auto pointer = data_->gl_capabilities.Get();
  *output = ::gpu::mojom::GLCapabilitiesDataView(pointer, message_);
}






inline void GpuChannel_FlushDeferredRequests_ParamsDataView::GetRequestsDataView(
    mojo::ArrayDataView<DeferredRequestDataView>* output) {
  auto pointer = data_->requests.Get();
  *output = mojo::ArrayDataView<DeferredRequestDataView>(pointer, message_);
}


inline void GpuChannel_CreateGpuMemoryBuffer_ParamsDataView::GetSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void GpuChannel_CreateGpuMemoryBuffer_ParamsDataView::GetFormatDataView(
    ::viz::mojom::SharedImageFormatDataView* output) {
  auto pointer = &data_->format;
  *output = ::viz::mojom::SharedImageFormatDataView(pointer, message_);
}


inline void GpuChannel_CreateGpuMemoryBuffer_ResponseParamsDataView::GetBufferHandleDataView(
    ::gfx::mojom::GpuMemoryBufferHandleDataView* output) {
  auto pointer = data_->buffer_handle.Get();
  *output = ::gfx::mojom::GpuMemoryBufferHandleDataView(pointer, message_);
}




inline void GpuChannel_WaitForTokenInRange_ResponseParamsDataView::GetStateDataView(
    CommandBufferStateDataView* output) {
  auto pointer = data_->state.Get();
  *output = CommandBufferStateDataView(pointer, message_);
}




inline void GpuChannel_WaitForGetOffsetInRange_ResponseParamsDataView::GetStateDataView(
    CommandBufferStateDataView* output) {
  auto pointer = data_->state.Get();
  *output = CommandBufferStateDataView(pointer, message_);
}




inline void CommandBuffer_RegisterTransferBuffer_ParamsDataView::GetBufferDataView(
    ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView* output) {
  auto pointer = data_->buffer.Get();
  *output = ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView(pointer, message_);
}


inline void CommandBuffer_CreateGpuFenceFromHandle_ParamsDataView::GetFenceHandleDataView(
    ::gfx::mojom::GpuFenceHandleDataView* output) {
  auto pointer = data_->fence_handle.Get();
  *output = ::gfx::mojom::GpuFenceHandleDataView(pointer, message_);
}




inline void CommandBuffer_GetGpuFenceHandle_ResponseParamsDataView::GetFenceHandleDataView(
    ::gfx::mojom::GpuFenceHandleDataView* output) {
  auto pointer = data_->fence_handle.Get();
  *output = ::gfx::mojom::GpuFenceHandleDataView(pointer, message_);
}


inline void CommandBuffer_SignalSyncToken_ParamsDataView::GetSyncTokenDataView(
    ::gpu::mojom::SyncTokenDataView* output) {
  auto pointer = data_->sync_token.Get();
  *output = ::gpu::mojom::SyncTokenDataView(pointer, message_);
}




inline void CommandBufferClient_OnConsoleMessage_ParamsDataView::GetMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->message.Get();
  *output = mojo::StringDataView(pointer, message_);
}






inline void CommandBufferClient_OnReturnData_ParamsDataView::GetDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void CommandBufferClient_OnSignalAck_ParamsDataView::GetStateDataView(
    CommandBufferStateDataView* output) {
  auto pointer = data_->state.Get();
  *output = CommandBufferStateDataView(pointer, message_);
}



}  // gpu::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // GPU_IPC_COMMON_GPU_CHANNEL_MOJOM_PARAMS_DATA_H_