// gpu/ipc/common/gpu_channel.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_GPU_CHANNEL_MOJOM_DATA_VIEW_H_
#define GPU_IPC_COMMON_GPU_CHANNEL_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "gpu/ipc/common/gpu_channel.mojom-shared-internal.h"
#include "gpu/ipc/common/capabilities.mojom-shared.h"
#include "gpu/ipc/common/context_result.mojom-shared.h"
#include "gpu/ipc/common/mailbox.mojom-shared.h"
#include "gpu/ipc/common/shared_image_metadata.mojom-shared.h"
#include "gpu/ipc/common/shared_image_pool_id.mojom-shared.h"
#include "gpu/ipc/common/shared_image_pool_client_interface.mojom-shared.h"
#include "gpu/ipc/common/surface_handle.mojom-shared.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "gpu/ipc/common/vulkan_ycbcr_info.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/viz/public/mojom/compositing/shared_image_format.mojom-shared.h"
#include "skia/public/mojom/image_info.mojom-shared.h"
#include "skia/public/mojom/surface_origin.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"
#include "ui/gfx/mojom/gpu_fence_handle.mojom-shared.h"
#include "ui/gfx/mojom/native_handle_types.mojom-shared.h"
#include "ui/gfx/mojom/presentation_feedback.mojom-shared.h"
#include "ui/gl/mojom/gpu_preference.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace gpu::mojom {
class RasterCreationAttribsDataView;

class GLESCreationAttribsDataView;

class WebGPUCreationAttribsDataView;

class CreateCommandBufferParamsDataView;

class CommandBufferStateDataView;

using SwapBuffersCompleteParamsDataView = mojo::native::NativeStructDataView;

class DeferredRequestDataView;

class DeferredCommandBufferRequestDataView;

class AsyncFlushParamsDataView;

class SharedImageInfoDataView;

class CreateSharedImageParamsDataView;

class CreateSharedImageWithDataParamsDataView;

class CreateSharedImageWithBufferParamsDataView;

class UpdateSharedImageParamsDataView;

class AddReferenceToSharedImageParamsDataView;

class CopyToGpuMemoryBufferParamsDataView;

class CreateSharedImagePoolParamsDataView;

class DestroySharedImagePoolParamsDataView;

class ContextCreationAttribsDataView;
class DeferredRequestParamsDataView;
class DeferredCommandBufferRequestParamsDataView;
class DeferredSharedImageRequestDataView;


}  // gpu::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gpu::mojom::RasterCreationAttribsDataView> {
  using Data = ::gpu::mojom::internal::RasterCreationAttribs_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::GLESCreationAttribsDataView> {
  using Data = ::gpu::mojom::internal::GLESCreationAttribs_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::WebGPUCreationAttribsDataView> {
  using Data = ::gpu::mojom::internal::WebGPUCreationAttribs_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::CreateCommandBufferParamsDataView> {
  using Data = ::gpu::mojom::internal::CreateCommandBufferParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::CommandBufferStateDataView> {
  using Data = ::gpu::mojom::internal::CommandBufferState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::DeferredRequestDataView> {
  using Data = ::gpu::mojom::internal::DeferredRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::DeferredCommandBufferRequestDataView> {
  using Data = ::gpu::mojom::internal::DeferredCommandBufferRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::AsyncFlushParamsDataView> {
  using Data = ::gpu::mojom::internal::AsyncFlushParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::SharedImageInfoDataView> {
  using Data = ::gpu::mojom::internal::SharedImageInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::CreateSharedImageParamsDataView> {
  using Data = ::gpu::mojom::internal::CreateSharedImageParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::CreateSharedImageWithDataParamsDataView> {
  using Data = ::gpu::mojom::internal::CreateSharedImageWithDataParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::CreateSharedImageWithBufferParamsDataView> {
  using Data = ::gpu::mojom::internal::CreateSharedImageWithBufferParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::UpdateSharedImageParamsDataView> {
  using Data = ::gpu::mojom::internal::UpdateSharedImageParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::AddReferenceToSharedImageParamsDataView> {
  using Data = ::gpu::mojom::internal::AddReferenceToSharedImageParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::CopyToGpuMemoryBufferParamsDataView> {
  using Data = ::gpu::mojom::internal::CopyToGpuMemoryBufferParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::CreateSharedImagePoolParamsDataView> {
  using Data = ::gpu::mojom::internal::CreateSharedImagePoolParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::DestroySharedImagePoolParamsDataView> {
  using Data = ::gpu::mojom::internal::DestroySharedImagePoolParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::ContextCreationAttribsDataView> {
  using Data = ::gpu::mojom::internal::ContextCreationAttribs_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::gpu::mojom::DeferredRequestParamsDataView> {
  using Data = ::gpu::mojom::internal::DeferredRequestParams_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::gpu::mojom::DeferredCommandBufferRequestParamsDataView> {
  using Data = ::gpu::mojom::internal::DeferredCommandBufferRequestParams_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::gpu::mojom::DeferredSharedImageRequestDataView> {
  using Data = ::gpu::mojom::internal::DeferredSharedImageRequest_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace gpu::mojom {


enum class ContextType : int32_t {
  
  kWebGL1 = 0,
  
  kWebGL2 = 1,
  
  kOpenGLES2 = 2,
  
  kOpenGLES3 = 3,
  
  kOpenGLES31ForTesting = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) std::ostream& operator<<(std::ostream& os, ContextType value);
inline bool IsKnownEnumValue(ContextType value) {
  return internal::ContextType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ContextColorSpace : int32_t {
  
  kUnspecified = 0,
  
  kSRGB = 1,
  
  kDisplayP3 = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) std::ostream& operator<<(std::ostream& os, ContextColorSpace value);
inline bool IsKnownEnumValue(ContextColorSpace value) {
  return internal::ContextColorSpace_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SchedulingPriority : int32_t {
  
  kHigh = 0,
  
  kNormal = 1,
  
  kLow = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) std::ostream& operator<<(std::ostream& os, SchedulingPriority value);
inline bool IsKnownEnumValue(SchedulingPriority value) {
  return internal::SchedulingPriority_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
using Error = mojo::NativeEnum;
using ContextLostReason = mojo::NativeEnum;
// Interface base classes. They are used for type safety check.
class GpuChannelInterfaceBase {};

using GpuChannelPtrDataView =
    mojo::InterfacePtrDataView<GpuChannelInterfaceBase>;
using GpuChannelRequestDataView =
    mojo::InterfaceRequestDataView<GpuChannelInterfaceBase>;
using GpuChannelAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<GpuChannelInterfaceBase>;
using GpuChannelAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<GpuChannelInterfaceBase>;
class CommandBufferInterfaceBase {};

using CommandBufferPtrDataView =
    mojo::InterfacePtrDataView<CommandBufferInterfaceBase>;
using CommandBufferRequestDataView =
    mojo::InterfaceRequestDataView<CommandBufferInterfaceBase>;
using CommandBufferAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CommandBufferInterfaceBase>;
using CommandBufferAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CommandBufferInterfaceBase>;
class CommandBufferClientInterfaceBase {};

using CommandBufferClientPtrDataView =
    mojo::InterfacePtrDataView<CommandBufferClientInterfaceBase>;
using CommandBufferClientRequestDataView =
    mojo::InterfaceRequestDataView<CommandBufferClientInterfaceBase>;
using CommandBufferClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CommandBufferClientInterfaceBase>;
using CommandBufferClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CommandBufferClientInterfaceBase>;


class RasterCreationAttribsDataView {
 public:
  RasterCreationAttribsDataView() = default;

  RasterCreationAttribsDataView(
      internal::RasterCreationAttribs_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool enable_gpu_rasterization() const {
    return data_->enable_gpu_rasterization;
  }
  bool lose_context_when_out_of_memory() const {
    return data_->lose_context_when_out_of_memory;
  }
 private:
  internal::RasterCreationAttribs_Data* data_ = nullptr;
};


class GLESCreationAttribsDataView {
 public:
  GLESCreationAttribsDataView() = default;

  GLESCreationAttribsDataView(
      internal::GLESCreationAttribs_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadGpuPreference(UserType* output) const {
    auto data_value = data_->gpu_preference;
    return mojo::internal::Deserialize<::gl::mojom::GpuPreference>(
        data_value, output);
  }
  ::gl::mojom::GpuPreference gpu_preference() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gl::mojom::GpuPreference>(data_->gpu_preference));
  }
  bool fail_if_major_perf_caveat() const {
    return data_->fail_if_major_perf_caveat;
  }
  bool lose_context_when_out_of_memory() const {
    return data_->lose_context_when_out_of_memory;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadContextType(UserType* output) const {
    auto data_value = data_->context_type;
    return mojo::internal::Deserialize<::gpu::mojom::ContextType>(
        data_value, output);
  }
  ContextType context_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gpu::mojom::ContextType>(data_->context_type));
  }
 private:
  internal::GLESCreationAttribs_Data* data_ = nullptr;
};


class WebGPUCreationAttribsDataView {
 public:
  WebGPUCreationAttribsDataView() = default;

  WebGPUCreationAttribsDataView(
      internal::WebGPUCreationAttribs_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::WebGPUCreationAttribs_Data* data_ = nullptr;
};


class CreateCommandBufferParamsDataView {
 public:
  CreateCommandBufferParamsDataView() = default;

  CreateCommandBufferParamsDataView(
      internal::CreateCommandBufferParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t stream_id() const {
    return data_->stream_id;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadStreamPriority(UserType* output) const {
    auto data_value = data_->stream_priority;
    return mojo::internal::Deserialize<::gpu::mojom::SchedulingPriority>(
        data_value, output);
  }
  SchedulingPriority stream_priority() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gpu::mojom::SchedulingPriority>(data_->stream_priority));
  }
  inline void GetAttribsDataView(
      ContextCreationAttribsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAttribs(UserType* output) {
    
    auto* pointer = !data_->attribs.is_null() ? &data_->attribs : nullptr;
    return mojo::internal::Deserialize<::gpu::mojom::ContextCreationAttribsDataView>(
        pointer, output, message_);
  }
  inline void GetActiveUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadActiveUrl(UserType* output) {
    
    auto* pointer = data_->active_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::CreateCommandBufferParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CommandBufferStateDataView {
 public:
  CommandBufferStateDataView() = default;

  CommandBufferStateDataView(
      internal::CommandBufferState_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t get_offset() const {
    return data_->get_offset;
  }
  int32_t token() const {
    return data_->token;
  }
  uint64_t release_count() const {
    return data_->release_count;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::gpu::mojom::Error>(
        data_value, output);
  }
  Error error() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gpu::mojom::Error>(data_->error));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadContextLostReason(UserType* output) const {
    auto data_value = data_->context_lost_reason;
    return mojo::internal::Deserialize<::gpu::mojom::ContextLostReason>(
        data_value, output);
  }
  ContextLostReason context_lost_reason() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gpu::mojom::ContextLostReason>(data_->context_lost_reason));
  }
  uint32_t generation() const {
    return data_->generation;
  }
  uint32_t set_get_buffer_count() const {
    return data_->set_get_buffer_count;
  }
 private:
  internal::CommandBufferState_Data* data_ = nullptr;
};


class DeferredRequestDataView {
 public:
  DeferredRequestDataView() = default;

  DeferredRequestDataView(
      internal::DeferredRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetParamsDataView(
      DeferredRequestParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = !data_->params.is_null() ? &data_->params : nullptr;
    return mojo::internal::Deserialize<::gpu::mojom::DeferredRequestParamsDataView>(
        pointer, output, message_);
  }
  inline void GetSyncTokenFencesDataView(
      mojo::ArrayDataView<::gpu::mojom::SyncTokenDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSyncTokenFences(UserType* output) {
    
    auto* pointer = data_->sync_token_fences.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gpu::mojom::SyncTokenDataView>>(
        pointer, output, message_);
  }
  uint64_t release_count() const {
    return data_->release_count;
  }
 private:
  internal::DeferredRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DeferredCommandBufferRequestDataView {
 public:
  DeferredCommandBufferRequestDataView() = default;

  DeferredCommandBufferRequestDataView(
      internal::DeferredCommandBufferRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t routing_id() const {
    return data_->routing_id;
  }
  inline void GetParamsDataView(
      DeferredCommandBufferRequestParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = !data_->params.is_null() ? &data_->params : nullptr;
    return mojo::internal::Deserialize<::gpu::mojom::DeferredCommandBufferRequestParamsDataView>(
        pointer, output, message_);
  }
 private:
  internal::DeferredCommandBufferRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AsyncFlushParamsDataView {
 public:
  AsyncFlushParamsDataView() = default;

  AsyncFlushParamsDataView(
      internal::AsyncFlushParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t put_offset() const {
    return data_->put_offset;
  }
  uint32_t flush_id() const {
    return data_->flush_id;
  }
  inline void GetSyncTokenFencesDataView(
      mojo::ArrayDataView<::gpu::mojom::SyncTokenDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSyncTokenFences(UserType* output) {
    
    auto* pointer = data_->sync_token_fences.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gpu::mojom::SyncTokenDataView>>(
        pointer, output, message_);
  }
 private:
  internal::AsyncFlushParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SharedImageInfoDataView {
 public:
  SharedImageInfoDataView() = default;

  SharedImageInfoDataView(
      internal::SharedImageInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMetaDataView(
      ::gpu::mojom::SharedImageMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMeta(UserType* output) {
    
    auto* pointer = data_->meta.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SharedImageMetadataDataView>(
        pointer, output, message_);
  }
  inline void GetDebugLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDebugLabel(UserType* output) {
    
    auto* pointer = data_->debug_label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::SharedImageInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreateSharedImageParamsDataView {
 public:
  CreateSharedImageParamsDataView() = default;

  CreateSharedImageParamsDataView(
      internal::CreateSharedImageParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMailboxDataView(
      ::gpu::mojom::MailboxDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMailbox(UserType* output) {
    
    auto* pointer = data_->mailbox.Get();
    return mojo::internal::Deserialize<::gpu::mojom::MailboxDataView>(
        pointer, output, message_);
  }
  inline void GetSiInfoDataView(
      SharedImageInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSiInfo(UserType* output) {
    
    auto* pointer = data_->si_info.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SharedImageInfoDataView>(
        pointer, output, message_);
  }
  inline void GetPoolIdDataView(
      ::gpu::mojom::SharedImagePoolIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPoolId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gpu::mojom::SharedImagePoolIdDataView, UserType>(),
    "Attempting to read the optional `pool_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPoolId` instead "
    "of `ReadPoolId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->pool_id.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SharedImagePoolIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::CreateSharedImageParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreateSharedImageWithDataParamsDataView {
 public:
  CreateSharedImageWithDataParamsDataView() = default;

  CreateSharedImageWithDataParamsDataView(
      internal::CreateSharedImageWithDataParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMailboxDataView(
      ::gpu::mojom::MailboxDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMailbox(UserType* output) {
    
    auto* pointer = data_->mailbox.Get();
    return mojo::internal::Deserialize<::gpu::mojom::MailboxDataView>(
        pointer, output, message_);
  }
  inline void GetSiInfoDataView(
      SharedImageInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSiInfo(UserType* output) {
    
    auto* pointer = data_->si_info.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SharedImageInfoDataView>(
        pointer, output, message_);
  }
  uint32_t pixel_data_offset() const {
    return data_->pixel_data_offset;
  }
  uint32_t pixel_data_size() const {
    return data_->pixel_data_size;
  }
  bool done_with_shm() const {
    return data_->done_with_shm;
  }
 private:
  internal::CreateSharedImageWithDataParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreateSharedImageWithBufferParamsDataView {
 public:
  CreateSharedImageWithBufferParamsDataView() = default;

  CreateSharedImageWithBufferParamsDataView(
      internal::CreateSharedImageWithBufferParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMailboxDataView(
      ::gpu::mojom::MailboxDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMailbox(UserType* output) {
    
    auto* pointer = data_->mailbox.Get();
    return mojo::internal::Deserialize<::gpu::mojom::MailboxDataView>(
        pointer, output, message_);
  }
  inline void GetSiInfoDataView(
      SharedImageInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSiInfo(UserType* output) {
    
    auto* pointer = data_->si_info.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SharedImageInfoDataView>(
        pointer, output, message_);
  }
  inline void GetBufferHandleDataView(
      ::gfx::mojom::GpuMemoryBufferHandleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBufferHandle(UserType* output) {
    
    auto* pointer = data_->buffer_handle.Get();
    return mojo::internal::Deserialize<::gfx::mojom::GpuMemoryBufferHandleDataView>(
        pointer, output, message_);
  }
  inline void GetPoolIdDataView(
      ::gpu::mojom::SharedImagePoolIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPoolId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gpu::mojom::SharedImagePoolIdDataView, UserType>(),
    "Attempting to read the optional `pool_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPoolId` instead "
    "of `ReadPoolId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->pool_id.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SharedImagePoolIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::CreateSharedImageWithBufferParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UpdateSharedImageParamsDataView {
 public:
  UpdateSharedImageParamsDataView() = default;

  UpdateSharedImageParamsDataView(
      internal::UpdateSharedImageParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMailboxDataView(
      ::gpu::mojom::MailboxDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMailbox(UserType* output) {
    
    auto* pointer = data_->mailbox.Get();
    return mojo::internal::Deserialize<::gpu::mojom::MailboxDataView>(
        pointer, output, message_);
  }
  inline void GetInFenceHandleDataView(
      ::gfx::mojom::GpuFenceHandleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInFenceHandle(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::GpuFenceHandleDataView, UserType>(),
    "Attempting to read the optional `in_fence_handle` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInFenceHandle` instead "
    "of `ReadInFenceHandle if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->in_fence_handle.Get();
    return mojo::internal::Deserialize<::gfx::mojom::GpuFenceHandleDataView>(
        pointer, output, message_);
  }
 private:
  internal::UpdateSharedImageParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AddReferenceToSharedImageParamsDataView {
 public:
  AddReferenceToSharedImageParamsDataView() = default;

  AddReferenceToSharedImageParamsDataView(
      internal::AddReferenceToSharedImageParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMailboxDataView(
      ::gpu::mojom::MailboxDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMailbox(UserType* output) {
    
    auto* pointer = data_->mailbox.Get();
    return mojo::internal::Deserialize<::gpu::mojom::MailboxDataView>(
        pointer, output, message_);
  }
 private:
  internal::AddReferenceToSharedImageParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CopyToGpuMemoryBufferParamsDataView {
 public:
  CopyToGpuMemoryBufferParamsDataView() = default;

  CopyToGpuMemoryBufferParamsDataView(
      internal::CopyToGpuMemoryBufferParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMailboxDataView(
      ::gpu::mojom::MailboxDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMailbox(UserType* output) {
    
    auto* pointer = data_->mailbox.Get();
    return mojo::internal::Deserialize<::gpu::mojom::MailboxDataView>(
        pointer, output, message_);
  }
 private:
  internal::CopyToGpuMemoryBufferParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreateSharedImagePoolParamsDataView {
 public:
  CreateSharedImagePoolParamsDataView() = default;

  CreateSharedImagePoolParamsDataView(
      internal::CreateSharedImagePoolParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPoolIdDataView(
      ::gpu::mojom::SharedImagePoolIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPoolId(UserType* output) {
    
    auto* pointer = data_->pool_id.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SharedImagePoolIdDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeClientRemote() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::gpu::mojom::SharedImagePoolClientInterfaceInterfaceBase>>(
            &data_->client_remote, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::CreateSharedImagePoolParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DestroySharedImagePoolParamsDataView {
 public:
  DestroySharedImagePoolParamsDataView() = default;

  DestroySharedImagePoolParamsDataView(
      internal::DestroySharedImagePoolParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPoolIdDataView(
      ::gpu::mojom::SharedImagePoolIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPoolId(UserType* output) {
    
    auto* pointer = data_->pool_id.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SharedImagePoolIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::DestroySharedImagePoolParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ContextCreationAttribsDataView {
 public:
  using Tag = internal::ContextCreationAttribs_Data::ContextCreationAttribs_Tag;

  ContextCreationAttribsDataView() = default;

  ContextCreationAttribsDataView(
      internal::ContextCreationAttribs_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_gles() const { return data_->tag == Tag::kGles; }
  inline void GetGlesDataView(
      GLESCreationAttribsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadGles(UserType* output) const {
    
    CHECK(is_gles());
    return mojo::internal::Deserialize<::gpu::mojom::GLESCreationAttribsDataView>(
        data_->data.f_gles.Get(), output, message_);
  }
  bool is_raster() const { return data_->tag == Tag::kRaster; }
  inline void GetRasterDataView(
      RasterCreationAttribsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadRaster(UserType* output) const {
    
    CHECK(is_raster());
    return mojo::internal::Deserialize<::gpu::mojom::RasterCreationAttribsDataView>(
        data_->data.f_raster.Get(), output, message_);
  }
  bool is_webgpu() const { return data_->tag == Tag::kWebgpu; }
  inline void GetWebgpuDataView(
      WebGPUCreationAttribsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadWebgpu(UserType* output) const {
    
    CHECK(is_webgpu());
    return mojo::internal::Deserialize<::gpu::mojom::WebGPUCreationAttribsDataView>(
        data_->data.f_webgpu.Get(), output, message_);
  }

 private:
  internal::ContextCreationAttribs_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class DeferredRequestParamsDataView {
 public:
  using Tag = internal::DeferredRequestParams_Data::DeferredRequestParams_Tag;

  DeferredRequestParamsDataView() = default;

  DeferredRequestParamsDataView(
      internal::DeferredRequestParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_command_buffer_request() const { return data_->tag == Tag::kCommandBufferRequest; }
  inline void GetCommandBufferRequestDataView(
      DeferredCommandBufferRequestDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadCommandBufferRequest(UserType* output) const {
    
    CHECK(is_command_buffer_request());
    return mojo::internal::Deserialize<::gpu::mojom::DeferredCommandBufferRequestDataView>(
        data_->data.f_command_buffer_request.Get(), output, message_);
  }
  bool is_shared_image_request() const { return data_->tag == Tag::kSharedImageRequest; }
  inline void GetSharedImageRequestDataView(
      DeferredSharedImageRequestDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSharedImageRequest(UserType* output) const {
    
    CHECK(is_shared_image_request());
    return mojo::internal::Deserialize<::gpu::mojom::DeferredSharedImageRequestDataView>(
        data_->data.f_shared_image_request.Get(), output, message_);
  }

 private:
  internal::DeferredRequestParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class DeferredCommandBufferRequestParamsDataView {
 public:
  using Tag = internal::DeferredCommandBufferRequestParams_Data::DeferredCommandBufferRequestParams_Tag;

  DeferredCommandBufferRequestParamsDataView() = default;

  DeferredCommandBufferRequestParamsDataView(
      internal::DeferredCommandBufferRequestParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_async_flush() const { return data_->tag == Tag::kAsyncFlush; }
  inline void GetAsyncFlushDataView(
      AsyncFlushParamsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadAsyncFlush(UserType* output) const {
    
    CHECK(is_async_flush());
    return mojo::internal::Deserialize<::gpu::mojom::AsyncFlushParamsDataView>(
        data_->data.f_async_flush.Get(), output, message_);
  }
  bool is_destroy_transfer_buffer() const { return data_->tag == Tag::kDestroyTransferBuffer; }
  int32_t destroy_transfer_buffer() const {
    CHECK(is_destroy_transfer_buffer());
    return data_->data.f_destroy_transfer_buffer;
  }

 private:
  internal::DeferredCommandBufferRequestParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class DeferredSharedImageRequestDataView {
 public:
  using Tag = internal::DeferredSharedImageRequest_Data::DeferredSharedImageRequest_Tag;

  DeferredSharedImageRequestDataView() = default;

  DeferredSharedImageRequestDataView(
      internal::DeferredSharedImageRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_nop() const { return data_->tag == Tag::kNop; }
  uint8_t nop() const {
    CHECK(is_nop());
    return data_->data.f_nop;
  }
  bool is_create_shared_image() const { return data_->tag == Tag::kCreateSharedImage; }
  inline void GetCreateSharedImageDataView(
      CreateSharedImageParamsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadCreateSharedImage(UserType* output) const {
    
    CHECK(is_create_shared_image());
    return mojo::internal::Deserialize<::gpu::mojom::CreateSharedImageParamsDataView>(
        data_->data.f_create_shared_image.Get(), output, message_);
  }
  bool is_create_shared_image_with_data() const { return data_->tag == Tag::kCreateSharedImageWithData; }
  inline void GetCreateSharedImageWithDataDataView(
      CreateSharedImageWithDataParamsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadCreateSharedImageWithData(UserType* output) const {
    
    CHECK(is_create_shared_image_with_data());
    return mojo::internal::Deserialize<::gpu::mojom::CreateSharedImageWithDataParamsDataView>(
        data_->data.f_create_shared_image_with_data.Get(), output, message_);
  }
  bool is_create_shared_image_with_buffer() const { return data_->tag == Tag::kCreateSharedImageWithBuffer; }
  inline void GetCreateSharedImageWithBufferDataView(
      CreateSharedImageWithBufferParamsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadCreateSharedImageWithBuffer(UserType* output) const {
    
    CHECK(is_create_shared_image_with_buffer());
    return mojo::internal::Deserialize<::gpu::mojom::CreateSharedImageWithBufferParamsDataView>(
        data_->data.f_create_shared_image_with_buffer.Get(), output, message_);
  }
  bool is_register_upload_buffer() const { return data_->tag == Tag::kRegisterUploadBuffer; }
  inline void GetRegisterUploadBufferDataView(
      ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadRegisterUploadBuffer(UserType* output) const {
    
    CHECK(is_register_upload_buffer());
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
        data_->data.f_register_upload_buffer.Get(), output, message_);
  }
  bool is_update_shared_image() const { return data_->tag == Tag::kUpdateSharedImage; }
  inline void GetUpdateSharedImageDataView(
      UpdateSharedImageParamsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadUpdateSharedImage(UserType* output) const {
    
    CHECK(is_update_shared_image());
    return mojo::internal::Deserialize<::gpu::mojom::UpdateSharedImageParamsDataView>(
        data_->data.f_update_shared_image.Get(), output, message_);
  }
  bool is_copy_to_gpu_memory_buffer() const { return data_->tag == Tag::kCopyToGpuMemoryBuffer; }
  inline void GetCopyToGpuMemoryBufferDataView(
      CopyToGpuMemoryBufferParamsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadCopyToGpuMemoryBuffer(UserType* output) const {
    
    CHECK(is_copy_to_gpu_memory_buffer());
    return mojo::internal::Deserialize<::gpu::mojom::CopyToGpuMemoryBufferParamsDataView>(
        data_->data.f_copy_to_gpu_memory_buffer.Get(), output, message_);
  }
  bool is_destroy_shared_image() const { return data_->tag == Tag::kDestroySharedImage; }
  inline void GetDestroySharedImageDataView(
      ::gpu::mojom::MailboxDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadDestroySharedImage(UserType* output) const {
    
    CHECK(is_destroy_shared_image());
    return mojo::internal::Deserialize<::gpu::mojom::MailboxDataView>(
        data_->data.f_destroy_shared_image.Get(), output, message_);
  }
  bool is_add_reference_to_shared_image() const { return data_->tag == Tag::kAddReferenceToSharedImage; }
  inline void GetAddReferenceToSharedImageDataView(
      AddReferenceToSharedImageParamsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadAddReferenceToSharedImage(UserType* output) const {
    
    CHECK(is_add_reference_to_shared_image());
    return mojo::internal::Deserialize<::gpu::mojom::AddReferenceToSharedImageParamsDataView>(
        data_->data.f_add_reference_to_shared_image.Get(), output, message_);
  }
  bool is_create_shared_image_pool() const { return data_->tag == Tag::kCreateSharedImagePool; }
  inline void GetCreateSharedImagePoolDataView(
      CreateSharedImagePoolParamsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadCreateSharedImagePool(UserType* output) const {
    
    CHECK(is_create_shared_image_pool());
    return mojo::internal::Deserialize<::gpu::mojom::CreateSharedImagePoolParamsDataView>(
        data_->data.f_create_shared_image_pool.Get(), output, message_);
  }
  bool is_destroy_shared_image_pool() const { return data_->tag == Tag::kDestroySharedImagePool; }
  inline void GetDestroySharedImagePoolDataView(
      DestroySharedImagePoolParamsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadDestroySharedImagePool(UserType* output) const {
    
    CHECK(is_destroy_shared_image_pool());
    return mojo::internal::Deserialize<::gpu::mojom::DestroySharedImagePoolParamsDataView>(
        data_->data.f_destroy_shared_image_pool.Get(), output, message_);
  }

 private:
  internal::DeferredSharedImageRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // gpu::mojom

#endif  // GPU_IPC_COMMON_GPU_CHANNEL_MOJOM_DATA_VIEW_H_