// gpu/ipc/common/exported_shared_image.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_EXPORTED_SHARED_IMAGE_MOJOM_BLINK_H_
#define GPU_IPC_COMMON_EXPORTED_SHARED_IMAGE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "gpu/ipc/common/exported_shared_image.mojom-features.h"  // IWYU pragma: export
#include "gpu/ipc/common/exported_shared_image.mojom-shared.h"  // IWYU pragma: export
#include "gpu/ipc/common/exported_shared_image.mojom-blink-forward.h"  // IWYU pragma: export
#include "gpu/ipc/common/mailbox.mojom-blink.h"
#include "gpu/ipc/common/shared_image_metadata.mojom-blink.h"
#include "gpu/ipc/common/sync_token.mojom-blink.h"
#include "ui/gfx/mojom/buffer_types.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "gpu/ipc/common/exported_shared_image_mojom_traits.h"
#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace gpu::mojom::blink {








class BLINK_PLATFORM_EXPORT ExportedSharedImage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ExportedSharedImage, T>::value>;
  using DataView = ExportedSharedImageDataView;
  using Data_ = internal::ExportedSharedImage_Data;

  template <typename... Args>
  static ExportedSharedImagePtr New(Args&&... args) {
    return ExportedSharedImagePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ExportedSharedImagePtr From(const U& u) {
    return mojo::TypeConverter<ExportedSharedImagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ExportedSharedImage>::Convert(*this);
  }


  ExportedSharedImage();

  ExportedSharedImage(
      const ::gpu::Mailbox& mailbox,
      const ::gpu::SharedImageMetadata& metadata,
      const ::gpu::SyncToken& creation_sync_token,
      const ::blink::String& debug_label,
      std::optional<::gfx::GpuMemoryBufferHandle> buffer_handle,
      std::optional<::gfx::BufferUsage> buffer_usage,
      uint32_t texture_target);

ExportedSharedImage(const ExportedSharedImage&) = delete;
ExportedSharedImage& operator=(const ExportedSharedImage&) = delete;

  ~ExportedSharedImage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ExportedSharedImagePtr>
  ExportedSharedImagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ExportedSharedImage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ExportedSharedImage::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ExportedSharedImage::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ExportedSharedImage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ExportedSharedImage_UnserializedMessageContext<
            UserType, ExportedSharedImage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ExportedSharedImage::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ExportedSharedImage::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ExportedSharedImage_UnserializedMessageContext<
            UserType, ExportedSharedImage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ExportedSharedImage::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gpu::Mailbox mailbox;
  
  ::gpu::SharedImageMetadata metadata;
  
  ::gpu::SyncToken creation_sync_token;
  
  ::blink::String debug_label;
  
  std::optional<::gfx::GpuMemoryBufferHandle> buffer_handle;
  
  std::optional<::gfx::BufferUsage> buffer_usage;
  
  uint32_t texture_target;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ExportedSharedImage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ExportedSharedImage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ExportedSharedImage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ExportedSharedImage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ExportedSharedImagePtr ExportedSharedImage::Clone() const {
  return New(
      mojo::Clone(mailbox),
      mojo::Clone(metadata),
      mojo::Clone(creation_sync_token),
      mojo::Clone(debug_label),
      mojo::Clone(buffer_handle),
      mojo::Clone(buffer_usage),
      mojo::Clone(texture_target)
  );
}

template <typename T, ExportedSharedImage::EnableIfSame<T>*>
bool ExportedSharedImage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mailbox, other_struct.mailbox))
    return false;
  if (!mojo::Equals(this->metadata, other_struct.metadata))
    return false;
  if (!mojo::Equals(this->creation_sync_token, other_struct.creation_sync_token))
    return false;
  if (!mojo::Equals(this->debug_label, other_struct.debug_label))
    return false;
  if (!mojo::Equals(this->buffer_handle, other_struct.buffer_handle))
    return false;
  if (!mojo::Equals(this->buffer_usage, other_struct.buffer_usage))
    return false;
  if (!mojo::Equals(this->texture_target, other_struct.texture_target))
    return false;
  return true;
}

template <typename T, ExportedSharedImage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.mailbox < rhs.mailbox)
    return true;
  if (rhs.mailbox < lhs.mailbox)
    return false;
  if (lhs.metadata < rhs.metadata)
    return true;
  if (rhs.metadata < lhs.metadata)
    return false;
  if (lhs.creation_sync_token < rhs.creation_sync_token)
    return true;
  if (rhs.creation_sync_token < lhs.creation_sync_token)
    return false;
  if (lhs.debug_label < rhs.debug_label)
    return true;
  if (rhs.debug_label < lhs.debug_label)
    return false;
  if (lhs.buffer_handle < rhs.buffer_handle)
    return true;
  if (rhs.buffer_handle < lhs.buffer_handle)
    return false;
  if (lhs.buffer_usage < rhs.buffer_usage)
    return true;
  if (rhs.buffer_usage < lhs.buffer_usage)
    return false;
  if (lhs.texture_target < rhs.texture_target)
    return true;
  if (rhs.texture_target < lhs.texture_target)
    return false;
  return false;
}


}  // gpu::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::gpu::mojom::blink::ExportedSharedImage::DataView,
                                         ::gpu::mojom::blink::ExportedSharedImagePtr> {
  static bool IsNull(const ::gpu::mojom::blink::ExportedSharedImagePtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::blink::ExportedSharedImagePtr* output) { output->reset(); }

  static const decltype(::gpu::mojom::blink::ExportedSharedImage::mailbox)& mailbox(
      const ::gpu::mojom::blink::ExportedSharedImagePtr& input) {
    return input->mailbox;
  }

  static const decltype(::gpu::mojom::blink::ExportedSharedImage::metadata)& metadata(
      const ::gpu::mojom::blink::ExportedSharedImagePtr& input) {
    return input->metadata;
  }

  static const decltype(::gpu::mojom::blink::ExportedSharedImage::creation_sync_token)& creation_sync_token(
      const ::gpu::mojom::blink::ExportedSharedImagePtr& input) {
    return input->creation_sync_token;
  }

  static const decltype(::gpu::mojom::blink::ExportedSharedImage::debug_label)& debug_label(
      const ::gpu::mojom::blink::ExportedSharedImagePtr& input) {
    return input->debug_label;
  }

  static  decltype(::gpu::mojom::blink::ExportedSharedImage::buffer_handle)& buffer_handle(
       ::gpu::mojom::blink::ExportedSharedImagePtr& input) {
    return input->buffer_handle;
  }

  static decltype(::gpu::mojom::blink::ExportedSharedImage::buffer_usage) buffer_usage(
      const ::gpu::mojom::blink::ExportedSharedImagePtr& input) {
    return input->buffer_usage;
  }

  static decltype(::gpu::mojom::blink::ExportedSharedImage::texture_target) texture_target(
      const ::gpu::mojom::blink::ExportedSharedImagePtr& input) {
    return input->texture_target;
  }

  static bool Read(::gpu::mojom::blink::ExportedSharedImage::DataView input, ::gpu::mojom::blink::ExportedSharedImagePtr* output);
};

}  // namespace mojo

#endif  // GPU_IPC_COMMON_EXPORTED_SHARED_IMAGE_MOJOM_BLINK_H_