// gpu/ipc/common/exported_shared_image.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "gpu/ipc/common/exported_shared_image.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "gpu/ipc/common/exported_shared_image.mojom-params-data.h"
#include "gpu/ipc/common/exported_shared_image.mojom-shared-message-ids.h"

#include "gpu/ipc/common/exported_shared_image.mojom-blink-import-headers.h"
#include "gpu/ipc/common/exported_shared_image.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace gpu::mojom::blink {
ExportedSharedImage::ExportedSharedImage()
    : mailbox(),
      metadata(),
      creation_sync_token(),
      debug_label(),
      buffer_handle(),
      buffer_usage(),
      texture_target() {}

ExportedSharedImage::ExportedSharedImage(
    const ::gpu::Mailbox& mailbox_in,
    const ::gpu::SharedImageMetadata& metadata_in,
    const ::gpu::SyncToken& creation_sync_token_in,
    const ::blink::String& debug_label_in,
    std::optional<::gfx::GpuMemoryBufferHandle> buffer_handle_in,
    std::optional<::gfx::BufferUsage> buffer_usage_in,
    uint32_t texture_target_in)
    : mailbox(std::move(mailbox_in)),
      metadata(std::move(metadata_in)),
      creation_sync_token(std::move(creation_sync_token_in)),
      debug_label(std::move(debug_label_in)),
      buffer_handle(std::move(buffer_handle_in)),
      buffer_usage(std::move(buffer_usage_in)),
      texture_target(std::move(texture_target_in)) {}

ExportedSharedImage::~ExportedSharedImage() = default;

void ExportedSharedImage::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mailbox"), this->mailbox,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gpu::Mailbox&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "metadata"), this->metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gpu::SharedImageMetadata&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "creation_sync_token"), this->creation_sync_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gpu::SyncToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "debug_label"), this->debug_label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buffer_handle"), this->buffer_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::gfx::GpuMemoryBufferHandle>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buffer_usage"), this->buffer_usage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::gfx::BufferUsage>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "texture_target"), this->texture_target,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ExportedSharedImage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // gpu::mojom::blink


namespace mojo {


// static
bool StructTraits<::gpu::mojom::blink::ExportedSharedImage::DataView, ::gpu::mojom::blink::ExportedSharedImagePtr>::Read(
    ::gpu::mojom::blink::ExportedSharedImage::DataView input,
    ::gpu::mojom::blink::ExportedSharedImagePtr* output) {
  bool success = true;
  ::gpu::mojom::blink::ExportedSharedImagePtr result(::gpu::mojom::blink::ExportedSharedImage::New());
  
      if (success && !input.ReadMailbox(&result->mailbox))
        success = false;
      if (success && !input.ReadMetadata(&result->metadata))
        success = false;
      if (success && !input.ReadCreationSyncToken(&result->creation_sync_token))
        success = false;
      if (success && !input.ReadDebugLabel(&result->debug_label))
        success = false;
      if (success && !input.ReadBufferHandle(&result->buffer_handle))
        success = false;
      if (success && !input.ReadBufferUsage(&result->buffer_usage)) {
        success = false;
      }
      if (success)
        result->texture_target = input.texture_target();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace gpu::mojom::blink {




}  // gpu::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif