// extensions/common/mojom/guest_view.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../url/mojom/url.mojom.m.js';

import {
  BeforeUnloadControlRemote as extensions_mimeHandler_BeforeUnloadControlRemote,
  BeforeUnloadControlPendingReceiver as extensions_mimeHandler_BeforeUnloadControlPendingReceiver
} from '../api/mime_handler.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class GuestViewPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'extensions.mojom.GuestView', scope);
  }
}

/** @interface */
export class GuestViewInterface {
  
  /**
   * @param { !boolean } success
   */

  readyToCreateMimeHandlerView(success) {}
  
  /**
   * @param { !string } scriptId
   * @return {!Promise<{
        allowed: !boolean,
   *  }>}
   */

  canExecuteContentScript(scriptId) {}
}

/**
 * @implements { GuestViewInterface }
 */
export class GuestViewRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!GuestViewPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          GuestViewPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!GuestViewPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } success
   */

  readyToCreateMimeHandlerView(
      success) {
    this.proxy.sendMessage(
        0,
        GuestView_ReadyToCreateMimeHandlerView_ParamsSpec.$,
        null,
        [
          success
        ],
        false);
  }

  
  /**
   * @param { !string } scriptId
   * @return {!Promise<{
        allowed: !boolean,
   *  }>}
   */

  canExecuteContentScript(
      scriptId) {
    return this.proxy.sendMessage(
        1,
        GuestView_CanExecuteContentScript_ParamsSpec.$,
        GuestView_CanExecuteContentScript_ResponseParamsSpec.$,
        [
          scriptId
        ],
        false);
  }
}

/**
 * An object which receives request messages for the GuestView
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class GuestViewReceiver {
  /**
   * @param {!GuestViewInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!GuestViewRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        GuestViewRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!GuestViewRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        GuestView_ReadyToCreateMimeHandlerView_ParamsSpec.$,
        null,
        impl.readyToCreateMimeHandlerView.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        GuestView_CanExecuteContentScript_ParamsSpec.$,
        GuestView_CanExecuteContentScript_ResponseParamsSpec.$,
        impl.canExecuteContentScript.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class GuestView {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "extensions.mojom.GuestView";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!GuestViewRemote}
   */
  static getRemote() {
    let remote = new GuestViewRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the GuestView
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class GuestViewCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      GuestViewRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!GuestViewRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readyToCreateMimeHandlerView =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        GuestView_ReadyToCreateMimeHandlerView_ParamsSpec.$,
        null,
        this.readyToCreateMimeHandlerView.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.canExecuteContentScript =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        GuestView_CanExecuteContentScript_ParamsSpec.$,
        GuestView_CanExecuteContentScript_ResponseParamsSpec.$,
        this.canExecuteContentScript.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MimeHandlerViewContainerManagerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'extensions.mojom.MimeHandlerViewContainerManager', scope);
  }
}

/** @interface */
export class MimeHandlerViewContainerManagerInterface {
  
  /**
   * @param { !string } tokenId
   */

  setInternalId(tokenId) {}
  
  /**
   * @return {!Promise<{
        beforeUnloadControl: !extensions_mimeHandler_BeforeUnloadControlRemote,
   *  }>}
   */

  createBeforeUnloadControl() {}
  
  /**
   * @param { !number } elementInstanceId
   */

  destroyFrameContainer(elementInstanceId) {}
  
  /**
   * @param { !number } mimeHandlerViewGuestElementInstanceId
   * @param { !url_mojom_Url } resourceUrl
   */

  didLoad(mimeHandlerViewGuestElementInstanceId, resourceUrl) {}
}

/**
 * @implements { MimeHandlerViewContainerManagerInterface }
 */
export class MimeHandlerViewContainerManagerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MimeHandlerViewContainerManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MimeHandlerViewContainerManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MimeHandlerViewContainerManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } tokenId
   */

  setInternalId(
      tokenId) {
    this.proxy.sendMessage(
        0,
        MimeHandlerViewContainerManager_SetInternalId_ParamsSpec.$,
        null,
        [
          tokenId
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        beforeUnloadControl: !extensions_mimeHandler_BeforeUnloadControlRemote,
   *  }>}
   */

  createBeforeUnloadControl() {
    return this.proxy.sendMessage(
        1,
        MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ParamsSpec.$,
        MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } elementInstanceId
   */

  destroyFrameContainer(
      elementInstanceId) {
    this.proxy.sendMessage(
        2,
        MimeHandlerViewContainerManager_DestroyFrameContainer_ParamsSpec.$,
        null,
        [
          elementInstanceId
        ],
        false);
  }

  
  /**
   * @param { !number } mimeHandlerViewGuestElementInstanceId
   * @param { !url_mojom_Url } resourceUrl
   */

  didLoad(
      mimeHandlerViewGuestElementInstanceId,
      resourceUrl) {
    this.proxy.sendMessage(
        3,
        MimeHandlerViewContainerManager_DidLoad_ParamsSpec.$,
        null,
        [
          mimeHandlerViewGuestElementInstanceId,
          resourceUrl
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MimeHandlerViewContainerManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MimeHandlerViewContainerManagerReceiver {
  /**
   * @param {!MimeHandlerViewContainerManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MimeHandlerViewContainerManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MimeHandlerViewContainerManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MimeHandlerViewContainerManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MimeHandlerViewContainerManager_SetInternalId_ParamsSpec.$,
        null,
        impl.setInternalId.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ParamsSpec.$,
        MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ResponseParamsSpec.$,
        impl.createBeforeUnloadControl.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        MimeHandlerViewContainerManager_DestroyFrameContainer_ParamsSpec.$,
        null,
        impl.destroyFrameContainer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        MimeHandlerViewContainerManager_DidLoad_ParamsSpec.$,
        null,
        impl.didLoad.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MimeHandlerViewContainerManager {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "extensions.mojom.MimeHandlerViewContainerManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MimeHandlerViewContainerManagerRemote}
   */
  static getRemote() {
    let remote = new MimeHandlerViewContainerManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MimeHandlerViewContainerManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MimeHandlerViewContainerManagerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MimeHandlerViewContainerManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MimeHandlerViewContainerManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setInternalId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MimeHandlerViewContainerManager_SetInternalId_ParamsSpec.$,
        null,
        this.setInternalId.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createBeforeUnloadControl =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ParamsSpec.$,
        MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ResponseParamsSpec.$,
        this.createBeforeUnloadControl.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.destroyFrameContainer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        MimeHandlerViewContainerManager_DestroyFrameContainer_ParamsSpec.$,
        null,
        this.destroyFrameContainer.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didLoad =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        MimeHandlerViewContainerManager_DidLoad_ParamsSpec.$,
        null,
        this.didLoad.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GuestView_ReadyToCreateMimeHandlerView_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GuestView_CanExecuteContentScript_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GuestView_CanExecuteContentScript_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MimeHandlerViewContainerManager_SetInternalId_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MimeHandlerViewContainerManager_DestroyFrameContainer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MimeHandlerViewContainerManager_DidLoad_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    GuestView_ReadyToCreateMimeHandlerView_ParamsSpec.$,
    'GuestView_ReadyToCreateMimeHandlerView_Params',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class GuestView_ReadyToCreateMimeHandlerView_Params {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    GuestView_CanExecuteContentScript_ParamsSpec.$,
    'GuestView_CanExecuteContentScript_Params',
    [
      mojo.internal.StructField(
        'scriptId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class GuestView_CanExecuteContentScript_Params {
  constructor() {
    /** @type { !string } */
    this.scriptId;
  }
}



mojo.internal.Struct(
    GuestView_CanExecuteContentScript_ResponseParamsSpec.$,
    'GuestView_CanExecuteContentScript_ResponseParams',
    [
      mojo.internal.StructField(
        'allowed', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class GuestView_CanExecuteContentScript_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.allowed;
  }
}



mojo.internal.Struct(
    MimeHandlerViewContainerManager_SetInternalId_ParamsSpec.$,
    'MimeHandlerViewContainerManager_SetInternalId_Params',
    [
      mojo.internal.StructField(
        'tokenId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MimeHandlerViewContainerManager_SetInternalId_Params {
  constructor() {
    /** @type { !string } */
    this.tokenId;
  }
}



mojo.internal.Struct(
    MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ParamsSpec.$,
    'MimeHandlerViewContainerManager_CreateBeforeUnloadControl_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MimeHandlerViewContainerManager_CreateBeforeUnloadControl_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ResponseParamsSpec.$,
    'MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ResponseParams',
    [
      mojo.internal.StructField(
        'beforeUnloadControl', 0,
        0,
        mojo.internal.InterfaceProxy(extensions_mimeHandler_BeforeUnloadControlRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ResponseParams {
  constructor() {
    /** @type { !extensions_mimeHandler_BeforeUnloadControlRemote } */
    this.beforeUnloadControl;
  }
}



mojo.internal.Struct(
    MimeHandlerViewContainerManager_DestroyFrameContainer_ParamsSpec.$,
    'MimeHandlerViewContainerManager_DestroyFrameContainer_Params',
    [
      mojo.internal.StructField(
        'elementInstanceId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MimeHandlerViewContainerManager_DestroyFrameContainer_Params {
  constructor() {
    /** @type { !number } */
    this.elementInstanceId;
  }
}



mojo.internal.Struct(
    MimeHandlerViewContainerManager_DidLoad_ParamsSpec.$,
    'MimeHandlerViewContainerManager_DidLoad_Params',
    [
      mojo.internal.StructField(
        'mimeHandlerViewGuestElementInstanceId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'resourceUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MimeHandlerViewContainerManager_DidLoad_Params {
  constructor() {
    /** @type { !number } */
    this.mimeHandlerViewGuestElementInstanceId;
    /** @type { !url_mojom_Url } */
    this.resourceUrl;
  }
}

