// device/vr/public/mojom/vr_service.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_VR_PUBLIC_MOJOM_VR_SERVICE_MOJOM_DATA_VIEW_H_
#define DEVICE_VR_PUBLIC_MOJOM_VR_SERVICE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "device/vr/public/mojom/vr_service.mojom-shared-internal.h"
#include "device/gamepad/public/mojom/gamepad.mojom-shared.h"
#include "device/vr/public/mojom/xr_hand_tracking_data.mojom-shared.h"
#include "device/vr/public/mojom/xr_session.mojom-shared.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "gpu/ipc/common/exported_shared_image.mojom-shared.h"
#include "gpu/ipc/common/shared_image_metadata.mojom-shared.h"
#include "gpu/ipc/common/mailbox_holder.mojom-shared.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "ui/display/mojom/display.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/gpu_fence_handle.mojom-shared.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"


namespace device::mojom {
class XRDepthConfigDataView;

class XRSessionDeviceConfigDataView;

class XRSessionDataView;

class XRPresentationConnectionDataView;

class XRInputSourceDescriptionDataView;

class XRInputSourceStateDataView;

class VRFieldOfViewDataView;

class VRPoseDataView;

class PoseDataView;

class AnchorIdDataView;

class HitTestSubscriptionIdDataView;

class PlaneIdDataView;

class XrVisibilityMaskIdDataView;

class XRRayDataView;

class XRHitResultDataView;

class XRViewGeometryDataView;

class XRVisibilityMaskDataView;

class XRViewDataView;

class VRStageParametersDataView;

class XRPresentationTransportOptionsDataView;

class XRInputSourceSpaceInfoDataView;

class XRHandJointSpaceInfoDataView;

class XRPlanePointDataDataView;

class XRPlaneDataDataView;

class XRPlaneDetectionDataDataView;

class XRAnchorDataDataView;

class XRAnchorsDataDataView;

class XRHitTestSubscriptionResultDataDataView;

class XRHitTestTransientInputSubscriptionResultDataDataView;

class XRHitTestSubscriptionResultsDataDataView;

class RgbTupleF32DataView;

class XRSphericalHarmonicsDataView;

class XRCubeMapDataView;

class XRLightProbeDataView;

class XRReflectionProbeDataView;

class XRLightEstimationDataDataView;

class XRDepthDataStillValidDataView;

class XRDepthDataUpdatedDataView;

class XRTrackedImageDataDataView;

class XRTrackedImagesDataDataView;

class LayerIdDataView;

class XRProjectionLayerDataDataView;

class XRQuadLayerDataDataView;

class XRCylinderLayerDataDataView;

class XREquirectLayerDataDataView;

class XRLayerReadOnlyDataDataView;

class XRLayerMutableDataDataView;

class XRCompositionLayerDataDataView;

class XRLayerFrameDataDataView;

class XRRenderInfoDataView;

class XRFrameDataDataView;

class RequestSessionSuccessDataView;

class XRFrameDataRequestOptionsDataView;

class XRNativeOriginInformationDataView;
class XRDepthDataDataView;
class XRLayerSpecificDataDataView;
class RequestSessionResultDataView;


}  // device::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::device::mojom::XRDepthConfigDataView> {
  using Data = ::device::mojom::internal::XRDepthConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRSessionDeviceConfigDataView> {
  using Data = ::device::mojom::internal::XRSessionDeviceConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRSessionDataView> {
  using Data = ::device::mojom::internal::XRSession_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRPresentationConnectionDataView> {
  using Data = ::device::mojom::internal::XRPresentationConnection_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRInputSourceDescriptionDataView> {
  using Data = ::device::mojom::internal::XRInputSourceDescription_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRInputSourceStateDataView> {
  using Data = ::device::mojom::internal::XRInputSourceState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::VRFieldOfViewDataView> {
  using Data = ::device::mojom::internal::VRFieldOfView_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::VRPoseDataView> {
  using Data = ::device::mojom::internal::VRPose_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::PoseDataView> {
  using Data = ::device::mojom::internal::Pose_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::AnchorIdDataView> {
  using Data = ::device::mojom::internal::AnchorId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::HitTestSubscriptionIdDataView> {
  using Data = ::device::mojom::internal::HitTestSubscriptionId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::PlaneIdDataView> {
  using Data = ::device::mojom::internal::PlaneId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XrVisibilityMaskIdDataView> {
  using Data = ::device::mojom::internal::XrVisibilityMaskId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRRayDataView> {
  using Data = ::device::mojom::internal::XRRay_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRHitResultDataView> {
  using Data = ::device::mojom::internal::XRHitResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRViewGeometryDataView> {
  using Data = ::device::mojom::internal::XRViewGeometry_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRVisibilityMaskDataView> {
  using Data = ::device::mojom::internal::XRVisibilityMask_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRViewDataView> {
  using Data = ::device::mojom::internal::XRView_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::VRStageParametersDataView> {
  using Data = ::device::mojom::internal::VRStageParameters_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRPresentationTransportOptionsDataView> {
  using Data = ::device::mojom::internal::XRPresentationTransportOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRInputSourceSpaceInfoDataView> {
  using Data = ::device::mojom::internal::XRInputSourceSpaceInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRHandJointSpaceInfoDataView> {
  using Data = ::device::mojom::internal::XRHandJointSpaceInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRPlanePointDataDataView> {
  using Data = ::device::mojom::internal::XRPlanePointData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRPlaneDataDataView> {
  using Data = ::device::mojom::internal::XRPlaneData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRPlaneDetectionDataDataView> {
  using Data = ::device::mojom::internal::XRPlaneDetectionData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRAnchorDataDataView> {
  using Data = ::device::mojom::internal::XRAnchorData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRAnchorsDataDataView> {
  using Data = ::device::mojom::internal::XRAnchorsData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRHitTestSubscriptionResultDataDataView> {
  using Data = ::device::mojom::internal::XRHitTestSubscriptionResultData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRHitTestTransientInputSubscriptionResultDataDataView> {
  using Data = ::device::mojom::internal::XRHitTestTransientInputSubscriptionResultData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRHitTestSubscriptionResultsDataDataView> {
  using Data = ::device::mojom::internal::XRHitTestSubscriptionResultsData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::RgbTupleF32DataView> {
  using Data = ::device::mojom::internal::RgbTupleF32_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRSphericalHarmonicsDataView> {
  using Data = ::device::mojom::internal::XRSphericalHarmonics_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRCubeMapDataView> {
  using Data = ::device::mojom::internal::XRCubeMap_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRLightProbeDataView> {
  using Data = ::device::mojom::internal::XRLightProbe_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRReflectionProbeDataView> {
  using Data = ::device::mojom::internal::XRReflectionProbe_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRLightEstimationDataDataView> {
  using Data = ::device::mojom::internal::XRLightEstimationData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRDepthDataStillValidDataView> {
  using Data = ::device::mojom::internal::XRDepthDataStillValid_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRDepthDataUpdatedDataView> {
  using Data = ::device::mojom::internal::XRDepthDataUpdated_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRTrackedImageDataDataView> {
  using Data = ::device::mojom::internal::XRTrackedImageData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRTrackedImagesDataDataView> {
  using Data = ::device::mojom::internal::XRTrackedImagesData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::LayerIdDataView> {
  using Data = ::device::mojom::internal::LayerId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRProjectionLayerDataDataView> {
  using Data = ::device::mojom::internal::XRProjectionLayerData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRQuadLayerDataDataView> {
  using Data = ::device::mojom::internal::XRQuadLayerData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRCylinderLayerDataDataView> {
  using Data = ::device::mojom::internal::XRCylinderLayerData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XREquirectLayerDataDataView> {
  using Data = ::device::mojom::internal::XREquirectLayerData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRLayerReadOnlyDataDataView> {
  using Data = ::device::mojom::internal::XRLayerReadOnlyData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRLayerMutableDataDataView> {
  using Data = ::device::mojom::internal::XRLayerMutableData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRCompositionLayerDataDataView> {
  using Data = ::device::mojom::internal::XRCompositionLayerData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRLayerFrameDataDataView> {
  using Data = ::device::mojom::internal::XRLayerFrameData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRRenderInfoDataView> {
  using Data = ::device::mojom::internal::XRRenderInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRFrameDataDataView> {
  using Data = ::device::mojom::internal::XRFrameData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::RequestSessionSuccessDataView> {
  using Data = ::device::mojom::internal::RequestSessionSuccess_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRFrameDataRequestOptionsDataView> {
  using Data = ::device::mojom::internal::XRFrameDataRequestOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRNativeOriginInformationDataView> {
  using Data = ::device::mojom::internal::XRNativeOriginInformation_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::device::mojom::XRDepthDataDataView> {
  using Data = ::device::mojom::internal::XRDepthData_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::device::mojom::XRLayerSpecificDataDataView> {
  using Data = ::device::mojom::internal::XRLayerSpecificData_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::device::mojom::RequestSessionResultDataView> {
  using Data = ::device::mojom::internal::RequestSessionResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace device::mojom {


enum class XRHandedness : int32_t {
  
  NONE = 0,
  
  LEFT = 1,
  
  RIGHT = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRHandedness value);
inline bool IsKnownEnumValue(XRHandedness value) {
  return internal::XRHandedness_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRTargetRayMode : int32_t {
  
  GAZING = 1,
  
  POINTING = 2,
  
  TAPPING = 3,
  kMinValue = 1,
  kMaxValue = 3,
};

COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRTargetRayMode value);
inline bool IsKnownEnumValue(XRTargetRayMode value) {
  return internal::XRTargetRayMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRSessionFeatureRequestStatus : int32_t {
  
  kNotRequested = 0,
  
  kRequired = 1,
  
  kOptionalAccepted = 2,
  
  kOptionalRejected = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRSessionFeatureRequestStatus value);
inline bool IsKnownEnumValue(XRSessionFeatureRequestStatus value) {
  return internal::XRSessionFeatureRequestStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XREnvironmentBlendMode : int32_t {
  
  kOpaque = 1,
  
  kAlphaBlend = 2,
  
  kAdditive = 3,
  kMinValue = 1,
  kMaxValue = 3,
};

COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XREnvironmentBlendMode value);
inline bool IsKnownEnumValue(XREnvironmentBlendMode value) {
  return internal::XREnvironmentBlendMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRInteractionMode : int32_t {
  
  kScreenSpace = 1,
  
  kWorldSpace = 2,
  kMinValue = 1,
  kMaxValue = 2,
};

COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRInteractionMode value);
inline bool IsKnownEnumValue(XRInteractionMode value) {
  return internal::XRInteractionMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XREye : int32_t {
  
  kNone = 0,
  
  kLeft = 1,
  
  kRight = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XREye value);
inline bool IsKnownEnumValue(XREye value) {
  return internal::XREye_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRPresentationTransportMethod : int32_t {
  
  NONE = 0,
  
  SUBMIT_AS_TEXTURE_HANDLE = 1,
  
  SUBMIT_AS_MAILBOX_HOLDER = 2,
  
  DRAW_INTO_TEXTURE_MAILBOX = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRPresentationTransportMethod value);
inline bool IsKnownEnumValue(XRPresentationTransportMethod value) {
  return internal::XRPresentationTransportMethod_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRReferenceSpaceType : int32_t {
  
  kViewer = 0,
  
  kLocal = 1,
  
  kLocalFloor = 2,
  
  kBoundedFloor = 3,
  
  kUnbounded = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRReferenceSpaceType value);
inline bool IsKnownEnumValue(XRReferenceSpaceType value) {
  return internal::XRReferenceSpaceType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRInputSourceSpaceType : int32_t {
  
  kTargetRay = 0,
  
  kGrip = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRInputSourceSpaceType value);
inline bool IsKnownEnumValue(XRInputSourceSpaceType value) {
  return internal::XRInputSourceSpaceType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRPlaneOrientation : int32_t {
  
  UNKNOWN = 0,
  
  HORIZONTAL = 1,
  
  VERTICAL = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRPlaneOrientation value);
inline bool IsKnownEnumValue(XRPlaneOrientation value) {
  return internal::XRPlaneOrientation_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CreateCompositionLayerResult : int32_t {
  
  SUCCESS = 0,
  
  FAILURE = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, CreateCompositionLayerResult value);
inline bool IsKnownEnumValue(CreateCompositionLayerResult value) {
  return internal::CreateCompositionLayerResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XrCompatibleResult : int32_t {
  
  kAlreadyCompatible = 0,
  
  kNoDeviceAvailable = 1,
  
  kWebXrFeaturePolicyBlocked = 2,
  
  kCompatibleAfterRestart = 3,
  
  kNotCompatibleAfterRestart = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XrCompatibleResult value);
inline bool IsKnownEnumValue(XrCompatibleResult value) {
  return internal::XrCompatibleResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class EntityTypeForHitTest : int32_t {
  
  POINT = 1,
  
  PLANE = 2,
  kMinValue = 1,
  kMaxValue = 2,
};

COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, EntityTypeForHitTest value);
inline bool IsKnownEnumValue(EntityTypeForHitTest value) {
  return internal::EntityTypeForHitTest_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRVisibilityState : int32_t {
  
  VISIBLE = 1,
  
  VISIBLE_BLURRED = 2,
  
  HIDDEN = 3,
  kMinValue = 1,
  kMaxValue = 3,
};

COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRVisibilityState value);
inline bool IsKnownEnumValue(XRVisibilityState value) {
  return internal::XRVisibilityState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class VRServiceInterfaceBase {};

using VRServicePtrDataView =
    mojo::InterfacePtrDataView<VRServiceInterfaceBase>;
using VRServiceRequestDataView =
    mojo::InterfaceRequestDataView<VRServiceInterfaceBase>;
using VRServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<VRServiceInterfaceBase>;
using VRServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<VRServiceInterfaceBase>;
class XRSessionMetricsRecorderInterfaceBase {};

using XRSessionMetricsRecorderPtrDataView =
    mojo::InterfacePtrDataView<XRSessionMetricsRecorderInterfaceBase>;
using XRSessionMetricsRecorderRequestDataView =
    mojo::InterfaceRequestDataView<XRSessionMetricsRecorderInterfaceBase>;
using XRSessionMetricsRecorderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XRSessionMetricsRecorderInterfaceBase>;
using XRSessionMetricsRecorderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XRSessionMetricsRecorderInterfaceBase>;
class VRServiceClientInterfaceBase {};

using VRServiceClientPtrDataView =
    mojo::InterfacePtrDataView<VRServiceClientInterfaceBase>;
using VRServiceClientRequestDataView =
    mojo::InterfaceRequestDataView<VRServiceClientInterfaceBase>;
using VRServiceClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<VRServiceClientInterfaceBase>;
using VRServiceClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<VRServiceClientInterfaceBase>;
class XREnvironmentIntegrationProviderInterfaceBase {};

using XREnvironmentIntegrationProviderPtrDataView =
    mojo::InterfacePtrDataView<XREnvironmentIntegrationProviderInterfaceBase>;
using XREnvironmentIntegrationProviderRequestDataView =
    mojo::InterfaceRequestDataView<XREnvironmentIntegrationProviderInterfaceBase>;
using XREnvironmentIntegrationProviderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XREnvironmentIntegrationProviderInterfaceBase>;
using XREnvironmentIntegrationProviderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XREnvironmentIntegrationProviderInterfaceBase>;
class XRFrameDataProviderInterfaceBase {};

using XRFrameDataProviderPtrDataView =
    mojo::InterfacePtrDataView<XRFrameDataProviderInterfaceBase>;
using XRFrameDataProviderRequestDataView =
    mojo::InterfaceRequestDataView<XRFrameDataProviderInterfaceBase>;
using XRFrameDataProviderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XRFrameDataProviderInterfaceBase>;
using XRFrameDataProviderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XRFrameDataProviderInterfaceBase>;
class XRPresentationProviderInterfaceBase {};

using XRPresentationProviderPtrDataView =
    mojo::InterfacePtrDataView<XRPresentationProviderInterfaceBase>;
using XRPresentationProviderRequestDataView =
    mojo::InterfaceRequestDataView<XRPresentationProviderInterfaceBase>;
using XRPresentationProviderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XRPresentationProviderInterfaceBase>;
using XRPresentationProviderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XRPresentationProviderInterfaceBase>;
class XRPresentationClientInterfaceBase {};

using XRPresentationClientPtrDataView =
    mojo::InterfacePtrDataView<XRPresentationClientInterfaceBase>;
using XRPresentationClientRequestDataView =
    mojo::InterfaceRequestDataView<XRPresentationClientInterfaceBase>;
using XRPresentationClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XRPresentationClientInterfaceBase>;
using XRPresentationClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XRPresentationClientInterfaceBase>;
class XRSessionClientInterfaceBase {};

using XRSessionClientPtrDataView =
    mojo::InterfacePtrDataView<XRSessionClientInterfaceBase>;
using XRSessionClientRequestDataView =
    mojo::InterfaceRequestDataView<XRSessionClientInterfaceBase>;
using XRSessionClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XRSessionClientInterfaceBase>;
using XRSessionClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XRSessionClientInterfaceBase>;
class XRLayerManagerInterfaceBase {};

using XRLayerManagerPtrDataView =
    mojo::InterfacePtrDataView<XRLayerManagerInterfaceBase>;
using XRLayerManagerRequestDataView =
    mojo::InterfaceRequestDataView<XRLayerManagerInterfaceBase>;
using XRLayerManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XRLayerManagerInterfaceBase>;
using XRLayerManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XRLayerManagerInterfaceBase>;
class WebXrInternalsRendererListenerInterfaceBase {};

using WebXrInternalsRendererListenerPtrDataView =
    mojo::InterfacePtrDataView<WebXrInternalsRendererListenerInterfaceBase>;
using WebXrInternalsRendererListenerRequestDataView =
    mojo::InterfaceRequestDataView<WebXrInternalsRendererListenerInterfaceBase>;
using WebXrInternalsRendererListenerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebXrInternalsRendererListenerInterfaceBase>;
using WebXrInternalsRendererListenerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebXrInternalsRendererListenerInterfaceBase>;


class XRDepthConfigDataView {
 public:
  XRDepthConfigDataView() = default;

  XRDepthConfigDataView(
      internal::XRDepthConfig_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadDepthUsage(UserType* output) const {
    auto data_value = data_->depth_usage;
    return mojo::internal::Deserialize<::device::mojom::XRDepthUsage>(
        data_value, output);
  }
  ::device::mojom::XRDepthUsage depth_usage() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XRDepthUsage>(data_->depth_usage));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDepthDataFormat(UserType* output) const {
    auto data_value = data_->depth_data_format;
    return mojo::internal::Deserialize<::device::mojom::XRDepthDataFormat>(
        data_value, output);
  }
  ::device::mojom::XRDepthDataFormat depth_data_format() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XRDepthDataFormat>(data_->depth_data_format));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDepthType(UserType* output) const {
    if (!data_->depth_type_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::device::mojom::XRDepthType>(
        data_->depth_type_$value, &output->emplace());
  }
  std::optional<::device::mojom::XRDepthType> depth_type() const {
    if (!data_->depth_type_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XRDepthType>(data_->depth_type_$value));
  }
 private:
  internal::XRDepthConfig_Data* data_ = nullptr;
};


class XRSessionDeviceConfigDataView {
 public:
  XRSessionDeviceConfigDataView() = default;

  XRSessionDeviceConfigDataView(
      internal::XRSessionDeviceConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  float default_framebuffer_scale() const {
    return data_->default_framebuffer_scale;
  }
  inline void GetViewsDataView(
      mojo::ArrayDataView<XRViewDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViews(UserType* output) {
    
    auto* pointer = data_->views.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRViewDataView>>(
        pointer, output, message_);
  }
  bool supports_viewport_scaling() const {
    return data_->supports_viewport_scaling;
  }
  bool enable_anti_aliasing() const {
    return data_->enable_anti_aliasing;
  }
  inline void GetDepthConfigurationDataView(
      XRDepthConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDepthConfiguration(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRDepthConfigDataView, UserType>(),
    "Attempting to read the optional `depth_configuration` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDepthConfiguration` instead "
    "of `ReadDepthConfiguration if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->depth_configuration.Get();
    return mojo::internal::Deserialize<::device::mojom::XRDepthConfigDataView>(
        pointer, output, message_);
  }
 private:
  internal::XRSessionDeviceConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRSessionDataView {
 public:
  XRSessionDataView() = default;

  XRSessionDataView(
      internal::XRSession_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeDataProvider() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::device::mojom::XRFrameDataProviderInterfaceBase>>(
            &data_->data_provider, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeLayerManager() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::device::mojom::XRLayerManagerInterfaceBase>>(
            &data_->layer_manager, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeClientReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::device::mojom::XRSessionClientInterfaceBase>>(
            &data_->client_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetSubmitFrameSinkDataView(
      XRPresentationConnectionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubmitFrameSink(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRPresentationConnectionDataView, UserType>(),
    "Attempting to read the optional `submit_frame_sink` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSubmitFrameSink` instead "
    "of `ReadSubmitFrameSink if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->submit_frame_sink.Get();
    return mojo::internal::Deserialize<::device::mojom::XRPresentationConnectionDataView>(
        pointer, output, message_);
  }
  inline void GetEnabledFeaturesDataView(
      mojo::ArrayDataView<::device::mojom::XRSessionFeature>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEnabledFeatures(UserType* output) {
    
    auto* pointer = data_->enabled_features.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRSessionFeature>>(
        pointer, output, message_);
  }
  inline void GetDeviceConfigDataView(
      XRSessionDeviceConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeviceConfig(UserType* output) {
    
    auto* pointer = data_->device_config.Get();
    return mojo::internal::Deserialize<::device::mojom::XRSessionDeviceConfigDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadEnviromentBlendMode(UserType* output) const {
    auto data_value = data_->enviroment_blend_mode;
    return mojo::internal::Deserialize<::device::mojom::XREnvironmentBlendMode>(
        data_value, output);
  }
  XREnvironmentBlendMode enviroment_blend_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XREnvironmentBlendMode>(data_->enviroment_blend_mode));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInteractionMode(UserType* output) const {
    auto data_value = data_->interaction_mode;
    return mojo::internal::Deserialize<::device::mojom::XRInteractionMode>(
        data_value, output);
  }
  XRInteractionMode interaction_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XRInteractionMode>(data_->interaction_mode));
  }
 private:
  internal::XRSession_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRPresentationConnectionDataView {
 public:
  XRPresentationConnectionDataView() = default;

  XRPresentationConnectionDataView(
      internal::XRPresentationConnection_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeProvider() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::device::mojom::XRPresentationProviderInterfaceBase>>(
            &data_->provider, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeClientReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::device::mojom::XRPresentationClientInterfaceBase>>(
            &data_->client_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetTransportOptionsDataView(
      XRPresentationTransportOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransportOptions(UserType* output) {
    
    auto* pointer = data_->transport_options.Get();
    return mojo::internal::Deserialize<::device::mojom::XRPresentationTransportOptionsDataView>(
        pointer, output, message_);
  }
 private:
  internal::XRPresentationConnection_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRInputSourceDescriptionDataView {
 public:
  XRInputSourceDescriptionDataView() = default;

  XRInputSourceDescriptionDataView(
      internal::XRInputSourceDescription_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadTargetRayMode(UserType* output) const {
    auto data_value = data_->target_ray_mode;
    return mojo::internal::Deserialize<::device::mojom::XRTargetRayMode>(
        data_value, output);
  }
  XRTargetRayMode target_ray_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XRTargetRayMode>(data_->target_ray_mode));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadHandedness(UserType* output) const {
    auto data_value = data_->handedness;
    return mojo::internal::Deserialize<::device::mojom::XRHandedness>(
        data_value, output);
  }
  XRHandedness handedness() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XRHandedness>(data_->handedness));
  }
  inline void GetInputFromPointerDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputFromPointer(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::TransformDataView, UserType>(),
    "Attempting to read the optional `input_from_pointer` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInputFromPointer` instead "
    "of `ReadInputFromPointer if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->input_from_pointer.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, message_);
  }
  inline void GetProfilesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProfiles(UserType* output) {
    
    auto* pointer = data_->profiles.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::XRInputSourceDescription_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRInputSourceStateDataView {
 public:
  XRInputSourceStateDataView() = default;

  XRInputSourceStateDataView(
      internal::XRInputSourceState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t source_id() const {
    return data_->source_id;
  }
  inline void GetDescriptionDataView(
      XRInputSourceDescriptionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescription(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRInputSourceDescriptionDataView, UserType>(),
    "Attempting to read the optional `description` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDescription` instead "
    "of `ReadDescription if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<::device::mojom::XRInputSourceDescriptionDataView>(
        pointer, output, message_);
  }
  inline void GetMojoFromInputDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMojoFromInput(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::TransformDataView, UserType>(),
    "Attempting to read the optional `mojo_from_input` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMojoFromInput` instead "
    "of `ReadMojoFromInput if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mojo_from_input.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, message_);
  }
  bool emulated_position() const {
    return data_->emulated_position;
  }
  bool is_auxiliary() const {
    return data_->is_auxiliary;
  }
  bool primary_input_pressed() const {
    return data_->primary_input_pressed;
  }
  bool primary_input_clicked() const {
    return data_->primary_input_clicked;
  }
  bool primary_squeeze_pressed() const {
    return data_->primary_squeeze_pressed;
  }
  bool primary_squeeze_clicked() const {
    return data_->primary_squeeze_clicked;
  }
  inline void GetGamepadDataView(
      ::device::mojom::GamepadDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGamepad(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::GamepadDataView, UserType>(),
    "Attempting to read the optional `gamepad` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadGamepad` instead "
    "of `ReadGamepad if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->gamepad.Get();
    return mojo::internal::Deserialize<::device::mojom::GamepadDataView>(
        pointer, output, message_);
  }
  inline void GetOverlayPointerPositionDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOverlayPointerPosition(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::PointFDataView, UserType>(),
    "Attempting to read the optional `overlay_pointer_position` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOverlayPointerPosition` instead "
    "of `ReadOverlayPointerPosition if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->overlay_pointer_position.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetHandTrackingDataDataView(
      ::device::mojom::XRHandTrackingDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHandTrackingData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRHandTrackingDataDataView, UserType>(),
    "Attempting to read the optional `hand_tracking_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHandTrackingData` instead "
    "of `ReadHandTrackingData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->hand_tracking_data.Get();
    return mojo::internal::Deserialize<::device::mojom::XRHandTrackingDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::XRInputSourceState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VRFieldOfViewDataView {
 public:
  VRFieldOfViewDataView() = default;

  VRFieldOfViewDataView(
      internal::VRFieldOfView_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float up_degrees() const {
    return data_->up_degrees;
  }
  float down_degrees() const {
    return data_->down_degrees;
  }
  float left_degrees() const {
    return data_->left_degrees;
  }
  float right_degrees() const {
    return data_->right_degrees;
  }
 private:
  internal::VRFieldOfView_Data* data_ = nullptr;
};


class VRPoseDataView {
 public:
  VRPoseDataView() = default;

  VRPoseDataView(
      internal::VRPose_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOrientationDataView(
      ::gfx::mojom::QuaternionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrientation(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::QuaternionDataView, UserType>(),
    "Attempting to read the optional `orientation` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOrientation` instead "
    "of `ReadOrientation if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->orientation.Get();
    return mojo::internal::Deserialize<::gfx::mojom::QuaternionDataView>(
        pointer, output, message_);
  }
  inline void GetPositionDataView(
      ::gfx::mojom::Point3FDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPosition(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::Point3FDataView, UserType>(),
    "Attempting to read the optional `position` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPosition` instead "
    "of `ReadPosition if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->position.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Point3FDataView>(
        pointer, output, message_);
  }
  bool emulated_position() const {
    return data_->emulated_position;
  }
 private:
  internal::VRPose_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PoseDataView {
 public:
  PoseDataView() = default;

  PoseDataView(
      internal::Pose_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOrientationDataView(
      ::gfx::mojom::QuaternionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrientation(UserType* output) {
    
    auto* pointer = data_->orientation.Get();
    return mojo::internal::Deserialize<::gfx::mojom::QuaternionDataView>(
        pointer, output, message_);
  }
  inline void GetPositionDataView(
      ::gfx::mojom::Point3FDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPosition(UserType* output) {
    
    auto* pointer = data_->position.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Point3FDataView>(
        pointer, output, message_);
  }
 private:
  internal::Pose_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AnchorIdDataView {
 public:
  AnchorIdDataView() = default;

  AnchorIdDataView(
      internal::AnchorId_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t id_value() const {
    return data_->id_value;
  }
 private:
  internal::AnchorId_Data* data_ = nullptr;
};


class HitTestSubscriptionIdDataView {
 public:
  HitTestSubscriptionIdDataView() = default;

  HitTestSubscriptionIdDataView(
      internal::HitTestSubscriptionId_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t id_value() const {
    return data_->id_value;
  }
 private:
  internal::HitTestSubscriptionId_Data* data_ = nullptr;
};


class PlaneIdDataView {
 public:
  PlaneIdDataView() = default;

  PlaneIdDataView(
      internal::PlaneId_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t id_value() const {
    return data_->id_value;
  }
 private:
  internal::PlaneId_Data* data_ = nullptr;
};


class XrVisibilityMaskIdDataView {
 public:
  XrVisibilityMaskIdDataView() = default;

  XrVisibilityMaskIdDataView(
      internal::XrVisibilityMaskId_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t id_value() const {
    return data_->id_value;
  }
 private:
  internal::XrVisibilityMaskId_Data* data_ = nullptr;
};


class XRRayDataView {
 public:
  XRRayDataView() = default;

  XRRayDataView(
      internal::XRRay_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      ::gfx::mojom::Point3FDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Point3FDataView>(
        pointer, output, message_);
  }
  inline void GetDirectionDataView(
      ::gfx::mojom::Vector3dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDirection(UserType* output) {
    
    auto* pointer = data_->direction.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector3dFDataView>(
        pointer, output, message_);
  }
 private:
  internal::XRRay_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRHitResultDataView {
 public:
  XRHitResultDataView() = default;

  XRHitResultDataView(
      internal::XRHitResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMojoFromResultDataView(
      PoseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMojoFromResult(UserType* output) {
    
    auto* pointer = data_->mojo_from_result.Get();
    return mojo::internal::Deserialize<::device::mojom::PoseDataView>(
        pointer, output, message_);
  }
  inline void GetPlaneIdDataView(
      PlaneIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPlaneId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::PlaneIdDataView, UserType>(),
    "Attempting to read the optional `plane_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPlaneId` instead "
    "of `ReadPlaneId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->plane_id.Get();
    return mojo::internal::Deserialize<::device::mojom::PlaneIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::XRHitResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRViewGeometryDataView {
 public:
  XRViewGeometryDataView() = default;

  XRViewGeometryDataView(
      internal::XRViewGeometry_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFieldOfViewDataView(
      VRFieldOfViewDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFieldOfView(UserType* output) {
    
    auto* pointer = data_->field_of_view.Get();
    return mojo::internal::Deserialize<::device::mojom::VRFieldOfViewDataView>(
        pointer, output, message_);
  }
  inline void GetMojoFromViewDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMojoFromView(UserType* output) {
    
    auto* pointer = data_->mojo_from_view.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, message_);
  }
 private:
  internal::XRViewGeometry_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRVisibilityMaskDataView {
 public:
  XRVisibilityMaskDataView() = default;

  XRVisibilityMaskDataView(
      internal::XRVisibilityMask_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetVerticesDataView(
      mojo::ArrayDataView<::gfx::mojom::PointFDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVertices(UserType* output) {
    
    auto* pointer = data_->vertices.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::PointFDataView>>(
        pointer, output, message_);
  }
  inline void GetUnvalidatedIndicesDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUnvalidatedIndices(UserType* output) {
    
    auto* pointer = data_->unvalidated_indices.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
 private:
  internal::XRVisibilityMask_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRViewDataView {
 public:
  XRViewDataView() = default;

  XRViewDataView(
      internal::XRView_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadEye(UserType* output) const {
    auto data_value = data_->eye;
    return mojo::internal::Deserialize<::device::mojom::XREye>(
        data_value, output);
  }
  XREye eye() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XREye>(data_->eye));
  }
  inline void GetGeometryDataView(
      XRViewGeometryDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGeometry(UserType* output) {
    
    auto* pointer = data_->geometry.Get();
    return mojo::internal::Deserialize<::device::mojom::XRViewGeometryDataView>(
        pointer, output, message_);
  }
  inline void GetViewportDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewport(UserType* output) {
    
    auto* pointer = data_->viewport.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetDepthDataDataView(
      XRDepthDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDepthData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRDepthDataDataView, UserType>(),
    "Attempting to read the optional `depth_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDepthData` instead "
    "of `ReadDepthData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->depth_data.is_null() ? &data_->depth_data : nullptr;
    return mojo::internal::Deserialize<::device::mojom::XRDepthDataDataView>(
        pointer, output, message_);
  }
  bool is_first_person_observer() const {
    return data_->is_first_person_observer;
  }
  inline void GetVisibilityMaskDataView(
      XRVisibilityMaskDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisibilityMask(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRVisibilityMaskDataView, UserType>(),
    "Attempting to read the optional `visibility_mask` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadVisibilityMask` instead "
    "of `ReadVisibilityMask if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->visibility_mask.Get();
    return mojo::internal::Deserialize<::device::mojom::XRVisibilityMaskDataView>(
        pointer, output, message_);
  }
  inline void GetVisibilityMaskIdDataView(
      XrVisibilityMaskIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisibilityMaskId(UserType* output) {
    
    auto* pointer = data_->visibility_mask_id.Get();
    return mojo::internal::Deserialize<::device::mojom::XrVisibilityMaskIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::XRView_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VRStageParametersDataView {
 public:
  VRStageParametersDataView() = default;

  VRStageParametersDataView(
      internal::VRStageParameters_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMojoFromStageDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMojoFromStage(UserType* output) {
    
    auto* pointer = data_->mojo_from_stage.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, message_);
  }
  inline void GetBoundsDataView(
      mojo::ArrayDataView<::gfx::mojom::Point3FDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBounds(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::gfx::mojom::Point3FDataView>, UserType>(),
    "Attempting to read the optional `bounds` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBounds` instead "
    "of `ReadBounds if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->bounds.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::Point3FDataView>>(
        pointer, output, message_);
  }
 private:
  internal::VRStageParameters_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRPresentationTransportOptionsDataView {
 public:
  XRPresentationTransportOptionsDataView() = default;

  XRPresentationTransportOptionsDataView(
      internal::XRPresentationTransportOptions_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadTransportMethod(UserType* output) const {
    auto data_value = data_->transport_method;
    return mojo::internal::Deserialize<::device::mojom::XRPresentationTransportMethod>(
        data_value, output);
  }
  XRPresentationTransportMethod transport_method() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XRPresentationTransportMethod>(data_->transport_method));
  }
  bool wait_for_transfer_notification() const {
    return data_->wait_for_transfer_notification;
  }
  bool wait_for_render_notification() const {
    return data_->wait_for_render_notification;
  }
  bool wait_for_gpu_fence() const {
    return data_->wait_for_gpu_fence;
  }
 private:
  internal::XRPresentationTransportOptions_Data* data_ = nullptr;
};


class XRInputSourceSpaceInfoDataView {
 public:
  XRInputSourceSpaceInfoDataView() = default;

  XRInputSourceSpaceInfoDataView(
      internal::XRInputSourceSpaceInfo_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t input_source_id() const {
    return data_->input_source_id;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInputSourceSpaceType(UserType* output) const {
    auto data_value = data_->input_source_space_type;
    return mojo::internal::Deserialize<::device::mojom::XRInputSourceSpaceType>(
        data_value, output);
  }
  XRInputSourceSpaceType input_source_space_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XRInputSourceSpaceType>(data_->input_source_space_type));
  }
 private:
  internal::XRInputSourceSpaceInfo_Data* data_ = nullptr;
};


class XRHandJointSpaceInfoDataView {
 public:
  XRHandJointSpaceInfoDataView() = default;

  XRHandJointSpaceInfoDataView(
      internal::XRHandJointSpaceInfo_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadHandedness(UserType* output) const {
    auto data_value = data_->handedness;
    return mojo::internal::Deserialize<::device::mojom::XRHandedness>(
        data_value, output);
  }
  XRHandedness handedness() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XRHandedness>(data_->handedness));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadJoint(UserType* output) const {
    auto data_value = data_->joint;
    return mojo::internal::Deserialize<::device::mojom::XRHandJoint>(
        data_value, output);
  }
  ::device::mojom::XRHandJoint joint() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XRHandJoint>(data_->joint));
  }
 private:
  internal::XRHandJointSpaceInfo_Data* data_ = nullptr;
};


class XRPlanePointDataDataView {
 public:
  XRPlanePointDataDataView() = default;

  XRPlanePointDataDataView(
      internal::XRPlanePointData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float x() const {
    return data_->x;
  }
  float z() const {
    return data_->z;
  }
 private:
  internal::XRPlanePointData_Data* data_ = nullptr;
};


class XRPlaneDataDataView {
 public:
  XRPlaneDataDataView() = default;

  XRPlaneDataDataView(
      internal::XRPlaneData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      PlaneIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::device::mojom::PlaneIdDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadOrientation(UserType* output) const {
    auto data_value = data_->orientation;
    return mojo::internal::Deserialize<::device::mojom::XRPlaneOrientation>(
        data_value, output);
  }
  XRPlaneOrientation orientation() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XRPlaneOrientation>(data_->orientation));
  }
  inline void GetMojoFromPlaneDataView(
      PoseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMojoFromPlane(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::PoseDataView, UserType>(),
    "Attempting to read the optional `mojo_from_plane` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMojoFromPlane` instead "
    "of `ReadMojoFromPlane if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mojo_from_plane.Get();
    return mojo::internal::Deserialize<::device::mojom::PoseDataView>(
        pointer, output, message_);
  }
  inline void GetPolygonDataView(
      mojo::ArrayDataView<XRPlanePointDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPolygon(UserType* output) {
    
    auto* pointer = data_->polygon.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRPlanePointDataDataView>>(
        pointer, output, message_);
  }
 private:
  internal::XRPlaneData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRPlaneDetectionDataDataView {
 public:
  XRPlaneDetectionDataDataView() = default;

  XRPlaneDetectionDataDataView(
      internal::XRPlaneDetectionData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAllPlanesIdsDataView(
      mojo::ArrayDataView<PlaneIdDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllPlanesIds(UserType* output) {
    
    auto* pointer = data_->all_planes_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::PlaneIdDataView>>(
        pointer, output, message_);
  }
  inline void GetUpdatedPlanesDataDataView(
      mojo::ArrayDataView<XRPlaneDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUpdatedPlanesData(UserType* output) {
    
    auto* pointer = data_->updated_planes_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRPlaneDataDataView>>(
        pointer, output, message_);
  }
 private:
  internal::XRPlaneDetectionData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRAnchorDataDataView {
 public:
  XRAnchorDataDataView() = default;

  XRAnchorDataDataView(
      internal::XRAnchorData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      AnchorIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::device::mojom::AnchorIdDataView>(
        pointer, output, message_);
  }
  inline void GetMojoFromAnchorDataView(
      PoseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMojoFromAnchor(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::PoseDataView, UserType>(),
    "Attempting to read the optional `mojo_from_anchor` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMojoFromAnchor` instead "
    "of `ReadMojoFromAnchor if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mojo_from_anchor.Get();
    return mojo::internal::Deserialize<::device::mojom::PoseDataView>(
        pointer, output, message_);
  }
 private:
  internal::XRAnchorData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRAnchorsDataDataView {
 public:
  XRAnchorsDataDataView() = default;

  XRAnchorsDataDataView(
      internal::XRAnchorsData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAllAnchorsIdsDataView(
      mojo::ArrayDataView<AnchorIdDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllAnchorsIds(UserType* output) {
    
    auto* pointer = data_->all_anchors_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::AnchorIdDataView>>(
        pointer, output, message_);
  }
  inline void GetUpdatedAnchorsDataDataView(
      mojo::ArrayDataView<XRAnchorDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUpdatedAnchorsData(UserType* output) {
    
    auto* pointer = data_->updated_anchors_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRAnchorDataDataView>>(
        pointer, output, message_);
  }
 private:
  internal::XRAnchorsData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRHitTestSubscriptionResultDataDataView {
 public:
  XRHitTestSubscriptionResultDataDataView() = default;

  XRHitTestSubscriptionResultDataDataView(
      internal::XRHitTestSubscriptionResultData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSubscriptionIdDataView(
      HitTestSubscriptionIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubscriptionId(UserType* output) {
    
    auto* pointer = data_->subscription_id.Get();
    return mojo::internal::Deserialize<::device::mojom::HitTestSubscriptionIdDataView>(
        pointer, output, message_);
  }
  inline void GetHitTestResultsDataView(
      mojo::ArrayDataView<XRHitResultDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHitTestResults(UserType* output) {
    
    auto* pointer = data_->hit_test_results.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRHitResultDataView>>(
        pointer, output, message_);
  }
 private:
  internal::XRHitTestSubscriptionResultData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRHitTestTransientInputSubscriptionResultDataDataView {
 public:
  XRHitTestTransientInputSubscriptionResultDataDataView() = default;

  XRHitTestTransientInputSubscriptionResultDataDataView(
      internal::XRHitTestTransientInputSubscriptionResultData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSubscriptionIdDataView(
      HitTestSubscriptionIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubscriptionId(UserType* output) {
    
    auto* pointer = data_->subscription_id.Get();
    return mojo::internal::Deserialize<::device::mojom::HitTestSubscriptionIdDataView>(
        pointer, output, message_);
  }
  inline void GetInputSourceIdToHitTestResultsDataView(
      mojo::MapDataView<uint32_t, mojo::ArrayDataView<XRHitResultDataView>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputSourceIdToHitTestResults(UserType* output) {
    
    auto* pointer = data_->input_source_id_to_hit_test_results.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<uint32_t, mojo::ArrayDataView<::device::mojom::XRHitResultDataView>>>(
        pointer, output, message_);
  }
 private:
  internal::XRHitTestTransientInputSubscriptionResultData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRHitTestSubscriptionResultsDataDataView {
 public:
  XRHitTestSubscriptionResultsDataDataView() = default;

  XRHitTestSubscriptionResultsDataDataView(
      internal::XRHitTestSubscriptionResultsData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResultsDataView(
      mojo::ArrayDataView<XRHitTestSubscriptionResultDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResults(UserType* output) {
    
    auto* pointer = data_->results.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRHitTestSubscriptionResultDataDataView>>(
        pointer, output, message_);
  }
  inline void GetTransientInputResultsDataView(
      mojo::ArrayDataView<XRHitTestTransientInputSubscriptionResultDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransientInputResults(UserType* output) {
    
    auto* pointer = data_->transient_input_results.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRHitTestTransientInputSubscriptionResultDataDataView>>(
        pointer, output, message_);
  }
 private:
  internal::XRHitTestSubscriptionResultsData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RgbTupleF32DataView {
 public:
  RgbTupleF32DataView() = default;

  RgbTupleF32DataView(
      internal::RgbTupleF32_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float red() const {
    return data_->red;
  }
  float green() const {
    return data_->green;
  }
  float blue() const {
    return data_->blue;
  }
 private:
  internal::RgbTupleF32_Data* data_ = nullptr;
};


class XRSphericalHarmonicsDataView {
 public:
  XRSphericalHarmonicsDataView() = default;

  XRSphericalHarmonicsDataView(
      internal::XRSphericalHarmonics_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCoefficientsDataView(
      mojo::ArrayDataView<RgbTupleF32DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCoefficients(UserType* output) {
    
    auto* pointer = data_->coefficients.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::RgbTupleF32DataView>>(
        pointer, output, message_);
  }
 private:
  internal::XRSphericalHarmonics_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRCubeMapDataView {
 public:
  XRCubeMapDataView() = default;

  XRCubeMapDataView(
      internal::XRCubeMap_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t width_and_height() const {
    return data_->width_and_height;
  }
  inline void GetPositiveXDataView(
      mojo::ArrayDataView<uint16_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPositiveX(UserType* output) {
    
    auto* pointer = data_->positive_x.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint16_t>>(
        pointer, output, message_);
  }
  inline void GetNegativeXDataView(
      mojo::ArrayDataView<uint16_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNegativeX(UserType* output) {
    
    auto* pointer = data_->negative_x.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint16_t>>(
        pointer, output, message_);
  }
  inline void GetPositiveYDataView(
      mojo::ArrayDataView<uint16_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPositiveY(UserType* output) {
    
    auto* pointer = data_->positive_y.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint16_t>>(
        pointer, output, message_);
  }
  inline void GetNegativeYDataView(
      mojo::ArrayDataView<uint16_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNegativeY(UserType* output) {
    
    auto* pointer = data_->negative_y.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint16_t>>(
        pointer, output, message_);
  }
  inline void GetPositiveZDataView(
      mojo::ArrayDataView<uint16_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPositiveZ(UserType* output) {
    
    auto* pointer = data_->positive_z.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint16_t>>(
        pointer, output, message_);
  }
  inline void GetNegativeZDataView(
      mojo::ArrayDataView<uint16_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNegativeZ(UserType* output) {
    
    auto* pointer = data_->negative_z.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint16_t>>(
        pointer, output, message_);
  }
 private:
  internal::XRCubeMap_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRLightProbeDataView {
 public:
  XRLightProbeDataView() = default;

  XRLightProbeDataView(
      internal::XRLightProbe_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSphericalHarmonicsDataView(
      XRSphericalHarmonicsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSphericalHarmonics(UserType* output) {
    
    auto* pointer = data_->spherical_harmonics.Get();
    return mojo::internal::Deserialize<::device::mojom::XRSphericalHarmonicsDataView>(
        pointer, output, message_);
  }
  inline void GetMainLightDirectionDataView(
      ::gfx::mojom::Vector3dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMainLightDirection(UserType* output) {
    
    auto* pointer = data_->main_light_direction.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector3dFDataView>(
        pointer, output, message_);
  }
  inline void GetMainLightIntensityDataView(
      RgbTupleF32DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMainLightIntensity(UserType* output) {
    
    auto* pointer = data_->main_light_intensity.Get();
    return mojo::internal::Deserialize<::device::mojom::RgbTupleF32DataView>(
        pointer, output, message_);
  }
 private:
  internal::XRLightProbe_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRReflectionProbeDataView {
 public:
  XRReflectionProbeDataView() = default;

  XRReflectionProbeDataView(
      internal::XRReflectionProbe_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCubeMapDataView(
      XRCubeMapDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCubeMap(UserType* output) {
    
    auto* pointer = data_->cube_map.Get();
    return mojo::internal::Deserialize<::device::mojom::XRCubeMapDataView>(
        pointer, output, message_);
  }
 private:
  internal::XRReflectionProbe_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRLightEstimationDataDataView {
 public:
  XRLightEstimationDataDataView() = default;

  XRLightEstimationDataDataView(
      internal::XRLightEstimationData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLightProbeDataView(
      XRLightProbeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLightProbe(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRLightProbeDataView, UserType>(),
    "Attempting to read the optional `light_probe` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLightProbe` instead "
    "of `ReadLightProbe if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->light_probe.Get();
    return mojo::internal::Deserialize<::device::mojom::XRLightProbeDataView>(
        pointer, output, message_);
  }
  inline void GetReflectionProbeDataView(
      XRReflectionProbeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReflectionProbe(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRReflectionProbeDataView, UserType>(),
    "Attempting to read the optional `reflection_probe` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReflectionProbe` instead "
    "of `ReadReflectionProbe if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->reflection_probe.Get();
    return mojo::internal::Deserialize<::device::mojom::XRReflectionProbeDataView>(
        pointer, output, message_);
  }
 private:
  internal::XRLightEstimationData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRDepthDataStillValidDataView {
 public:
  XRDepthDataStillValidDataView() = default;

  XRDepthDataStillValidDataView(
      internal::XRDepthDataStillValid_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::XRDepthDataStillValid_Data* data_ = nullptr;
};


class XRDepthDataUpdatedDataView {
 public:
  XRDepthDataUpdatedDataView() = default;

  XRDepthDataUpdatedDataView(
      internal::XRDepthDataUpdated_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPixelDataDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPixelData(UserType* output) {
    
    auto* pointer = !data_->pixel_data.is_null() ? &data_->pixel_data : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, message_);
  }
  inline void GetNormTextureFromNormViewDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNormTextureFromNormView(UserType* output) {
    
    auto* pointer = data_->norm_texture_from_norm_view.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, message_);
  }
  inline void GetSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSize(UserType* output) {
    
    auto* pointer = data_->size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  float raw_value_to_meters() const {
    return data_->raw_value_to_meters;
  }
  inline void GetViewGeometryDataView(
      XRViewGeometryDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewGeometry(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRViewGeometryDataView, UserType>(),
    "Attempting to read the optional `view_geometry` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadViewGeometry` instead "
    "of `ReadViewGeometry if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->view_geometry.Get();
    return mojo::internal::Deserialize<::device::mojom::XRViewGeometryDataView>(
        pointer, output, message_);
  }
 private:
  internal::XRDepthDataUpdated_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRTrackedImageDataDataView {
 public:
  XRTrackedImageDataDataView() = default;

  XRTrackedImageDataDataView(
      internal::XRTrackedImageData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t index() const {
    return data_->index;
  }
  inline void GetMojoFromImageDataView(
      PoseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMojoFromImage(UserType* output) {
    
    auto* pointer = data_->mojo_from_image.Get();
    return mojo::internal::Deserialize<::device::mojom::PoseDataView>(
        pointer, output, message_);
  }
  bool actively_tracked() const {
    return data_->actively_tracked;
  }
  float width_in_meters() const {
    return data_->width_in_meters;
  }
 private:
  internal::XRTrackedImageData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRTrackedImagesDataDataView {
 public:
  XRTrackedImagesDataDataView() = default;

  XRTrackedImagesDataDataView(
      internal::XRTrackedImagesData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetImagesDataDataView(
      mojo::ArrayDataView<XRTrackedImageDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImagesData(UserType* output) {
    
    auto* pointer = data_->images_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRTrackedImageDataDataView>>(
        pointer, output, message_);
  }
  inline void GetImageTrackableScoresDataView(
      mojo::ArrayDataView<bool>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImageTrackableScores(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<bool>, UserType>(),
    "Attempting to read the optional `image_trackable_scores` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadImageTrackableScores` instead "
    "of `ReadImageTrackableScores if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->image_trackable_scores.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<bool>>(
        pointer, output, message_);
  }
 private:
  internal::XRTrackedImagesData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LayerIdDataView {
 public:
  LayerIdDataView() = default;

  LayerIdDataView(
      internal::LayerId_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t id_value() const {
    return data_->id_value;
  }
 private:
  internal::LayerId_Data* data_ = nullptr;
};


class XRProjectionLayerDataDataView {
 public:
  XRProjectionLayerDataDataView() = default;

  XRProjectionLayerDataDataView(
      internal::XRProjectionLayerData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::XRProjectionLayerData_Data* data_ = nullptr;
};


class XRQuadLayerDataDataView {
 public:
  XRQuadLayerDataDataView() = default;

  XRQuadLayerDataDataView(
      internal::XRQuadLayerData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTransformDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransform(UserType* output) {
    
    auto* pointer = data_->transform.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, message_);
  }
  float width() const {
    return data_->width;
  }
  float height() const {
    return data_->height;
  }
 private:
  internal::XRQuadLayerData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRCylinderLayerDataDataView {
 public:
  XRCylinderLayerDataDataView() = default;

  XRCylinderLayerDataDataView(
      internal::XRCylinderLayerData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTransformDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransform(UserType* output) {
    
    auto* pointer = data_->transform.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, message_);
  }
  float radius() const {
    return data_->radius;
  }
  float central_angle() const {
    return data_->central_angle;
  }
  float aspect_ratio() const {
    return data_->aspect_ratio;
  }
 private:
  internal::XRCylinderLayerData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XREquirectLayerDataDataView {
 public:
  XREquirectLayerDataDataView() = default;

  XREquirectLayerDataDataView(
      internal::XREquirectLayerData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTransformDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransform(UserType* output) {
    
    auto* pointer = data_->transform.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, message_);
  }
  float radius() const {
    return data_->radius;
  }
  float central_horizontal_angle() const {
    return data_->central_horizontal_angle;
  }
  float upper_vertical_angle() const {
    return data_->upper_vertical_angle;
  }
  float lower_vertical_angle() const {
    return data_->lower_vertical_angle;
  }
 private:
  internal::XREquirectLayerData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRLayerReadOnlyDataDataView {
 public:
  XRLayerReadOnlyDataDataView() = default;

  XRLayerReadOnlyDataDataView(
      internal::XRLayerReadOnlyData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLayerIdDataView(
      LayerIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLayerId(UserType* output) {
    
    auto* pointer = data_->layer_id.Get();
    return mojo::internal::Deserialize<::device::mojom::LayerIdDataView>(
        pointer, output, message_);
  }
  uint32_t texture_width() const {
    return data_->texture_width;
  }
  uint32_t texture_height() const {
    return data_->texture_height;
  }
  bool is_static() const {
    return data_->is_static;
  }
 private:
  internal::XRLayerReadOnlyData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRLayerMutableDataDataView {
 public:
  XRLayerMutableDataDataView() = default;

  XRLayerMutableDataDataView(
      internal::XRLayerMutableData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool blend_texture_source_alpha() const {
    return data_->blend_texture_source_alpha;
  }
  float opacity() const {
    return data_->opacity;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadReferenceSpaceType(UserType* output) const {
    auto data_value = data_->reference_space_type;
    return mojo::internal::Deserialize<::device::mojom::XRReferenceSpaceType>(
        data_value, output);
  }
  XRReferenceSpaceType reference_space_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XRReferenceSpaceType>(data_->reference_space_type));
  }
  inline void GetLayerDataDataView(
      XRLayerSpecificDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLayerData(UserType* output) {
    
    auto* pointer = !data_->layer_data.is_null() ? &data_->layer_data : nullptr;
    return mojo::internal::Deserialize<::device::mojom::XRLayerSpecificDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::XRLayerMutableData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRCompositionLayerDataDataView {
 public:
  XRCompositionLayerDataDataView() = default;

  XRCompositionLayerDataDataView(
      internal::XRCompositionLayerData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetReadOnlyDataDataView(
      XRLayerReadOnlyDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReadOnlyData(UserType* output) {
    
    auto* pointer = data_->read_only_data.Get();
    return mojo::internal::Deserialize<::device::mojom::XRLayerReadOnlyDataDataView>(
        pointer, output, message_);
  }
  inline void GetMutableDataDataView(
      XRLayerMutableDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMutableData(UserType* output) {
    
    auto* pointer = data_->mutable_data.Get();
    return mojo::internal::Deserialize<::device::mojom::XRLayerMutableDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::XRCompositionLayerData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRLayerFrameDataDataView {
 public:
  XRLayerFrameDataDataView() = default;

  XRLayerFrameDataDataView(
      internal::XRLayerFrameData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLayerIdDataView(
      LayerIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLayerId(UserType* output) {
    
    auto* pointer = data_->layer_id.Get();
    return mojo::internal::Deserialize<::device::mojom::LayerIdDataView>(
        pointer, output, message_);
  }
  inline void GetBufferSharedImageDataView(
      ::gpu::mojom::ExportedSharedImageDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBufferSharedImage(UserType* output) {
    
    auto* pointer = data_->buffer_shared_image.Get();
    return mojo::internal::Deserialize<::gpu::mojom::ExportedSharedImageDataView>(
        pointer, output, message_);
  }
  inline void GetBufferSyncTokenDataView(
      ::gpu::mojom::SyncTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBufferSyncToken(UserType* output) {
    
    auto* pointer = data_->buffer_sync_token.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SyncTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::XRLayerFrameData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRRenderInfoDataView {
 public:
  XRRenderInfoDataView() = default;

  XRRenderInfoDataView(
      internal::XRRenderInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int16_t frame_id() const {
    return data_->frame_id;
  }
  inline void GetMojoFromViewerDataView(
      VRPoseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMojoFromViewer(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::VRPoseDataView, UserType>(),
    "Attempting to read the optional `mojo_from_viewer` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMojoFromViewer` instead "
    "of `ReadMojoFromViewer if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mojo_from_viewer.Get();
    return mojo::internal::Deserialize<::device::mojom::VRPoseDataView>(
        pointer, output, message_);
  }
  inline void GetViewsDataView(
      mojo::ArrayDataView<XRViewDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViews(UserType* output) {
    
    auto* pointer = data_->views.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRViewDataView>>(
        pointer, output, message_);
  }
 private:
  internal::XRRenderInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRFrameDataDataView {
 public:
  XRFrameDataDataView() = default;

  XRFrameDataDataView(
      internal::XRFrameData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRenderInfoDataView(
      XRRenderInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRenderInfo(UserType* output) {
    
    auto* pointer = data_->render_info.Get();
    return mojo::internal::Deserialize<::device::mojom::XRRenderInfoDataView>(
        pointer, output, message_);
  }
  inline void GetTimeDeltaDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimeDelta(UserType* output) {
    
    auto* pointer = data_->time_delta.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetBufferSharedImageDataView(
      ::gpu::mojom::ExportedSharedImageDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBufferSharedImage(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gpu::mojom::ExportedSharedImageDataView, UserType>(),
    "Attempting to read the optional `buffer_shared_image` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBufferSharedImage` instead "
    "of `ReadBufferSharedImage if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->buffer_shared_image.Get();
    return mojo::internal::Deserialize<::gpu::mojom::ExportedSharedImageDataView>(
        pointer, output, message_);
  }
  inline void GetBufferSyncTokenDataView(
      ::gpu::mojom::SyncTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBufferSyncToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gpu::mojom::SyncTokenDataView, UserType>(),
    "Attempting to read the optional `buffer_sync_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBufferSyncToken` instead "
    "of `ReadBufferSyncToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->buffer_sync_token.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SyncTokenDataView>(
        pointer, output, message_);
  }
  inline void GetCameraImageBufferSharedImageDataView(
      ::gpu::mojom::ExportedSharedImageDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCameraImageBufferSharedImage(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gpu::mojom::ExportedSharedImageDataView, UserType>(),
    "Attempting to read the optional `camera_image_buffer_shared_image` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCameraImageBufferSharedImage` instead "
    "of `ReadCameraImageBufferSharedImage if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->camera_image_buffer_shared_image.Get();
    return mojo::internal::Deserialize<::gpu::mojom::ExportedSharedImageDataView>(
        pointer, output, message_);
  }
  inline void GetCameraImageBufferSyncTokenDataView(
      ::gpu::mojom::SyncTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCameraImageBufferSyncToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gpu::mojom::SyncTokenDataView, UserType>(),
    "Attempting to read the optional `camera_image_buffer_sync_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCameraImageBufferSyncToken` instead "
    "of `ReadCameraImageBufferSyncToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->camera_image_buffer_sync_token.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SyncTokenDataView>(
        pointer, output, message_);
  }
  inline void GetCameraImageSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCameraImageSize(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::SizeDataView, UserType>(),
    "Attempting to read the optional `camera_image_size` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCameraImageSize` instead "
    "of `ReadCameraImageSize if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->camera_image_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  bool mojo_space_reset() const {
    return data_->mojo_space_reset;
  }
  inline void GetMojoFromFloorDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMojoFromFloor(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::TransformDataView, UserType>(),
    "Attempting to read the optional `mojo_from_floor` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMojoFromFloor` instead "
    "of `ReadMojoFromFloor if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mojo_from_floor.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, message_);
  }
  inline void GetInputStateDataView(
      mojo::ArrayDataView<XRInputSourceStateDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputState(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::device::mojom::XRInputSourceStateDataView>, UserType>(),
    "Attempting to read the optional `input_state` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInputState` instead "
    "of `ReadInputState if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->input_state.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRInputSourceStateDataView>>(
        pointer, output, message_);
  }
  uint32_t stage_parameters_id() const {
    return data_->stage_parameters_id;
  }
  inline void GetStageParametersDataView(
      VRStageParametersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStageParameters(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::VRStageParametersDataView, UserType>(),
    "Attempting to read the optional `stage_parameters` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadStageParameters` instead "
    "of `ReadStageParameters if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->stage_parameters.Get();
    return mojo::internal::Deserialize<::device::mojom::VRStageParametersDataView>(
        pointer, output, message_);
  }
  inline void GetDetectedPlanesDataDataView(
      XRPlaneDetectionDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDetectedPlanesData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRPlaneDetectionDataDataView, UserType>(),
    "Attempting to read the optional `detected_planes_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDetectedPlanesData` instead "
    "of `ReadDetectedPlanesData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->detected_planes_data.Get();
    return mojo::internal::Deserialize<::device::mojom::XRPlaneDetectionDataDataView>(
        pointer, output, message_);
  }
  inline void GetAnchorsDataDataView(
      XRAnchorsDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAnchorsData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRAnchorsDataDataView, UserType>(),
    "Attempting to read the optional `anchors_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAnchorsData` instead "
    "of `ReadAnchorsData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->anchors_data.Get();
    return mojo::internal::Deserialize<::device::mojom::XRAnchorsDataDataView>(
        pointer, output, message_);
  }
  inline void GetCompositionLayersDataDataView(
      mojo::ArrayDataView<XRLayerFrameDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCompositionLayersData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::device::mojom::XRLayerFrameDataDataView>, UserType>(),
    "Attempting to read the optional `composition_layers_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCompositionLayersData` instead "
    "of `ReadCompositionLayersData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->composition_layers_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRLayerFrameDataDataView>>(
        pointer, output, message_);
  }
  inline void GetLightEstimationDataDataView(
      XRLightEstimationDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLightEstimationData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRLightEstimationDataDataView, UserType>(),
    "Attempting to read the optional `light_estimation_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLightEstimationData` instead "
    "of `ReadLightEstimationData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->light_estimation_data.Get();
    return mojo::internal::Deserialize<::device::mojom::XRLightEstimationDataDataView>(
        pointer, output, message_);
  }
  inline void GetHitTestSubscriptionResultsDataView(
      XRHitTestSubscriptionResultsDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHitTestSubscriptionResults(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRHitTestSubscriptionResultsDataDataView, UserType>(),
    "Attempting to read the optional `hit_test_subscription_results` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHitTestSubscriptionResults` instead "
    "of `ReadHitTestSubscriptionResults if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->hit_test_subscription_results.Get();
    return mojo::internal::Deserialize<::device::mojom::XRHitTestSubscriptionResultsDataDataView>(
        pointer, output, message_);
  }
  float rendering_time_ratio() const {
    return data_->rendering_time_ratio;
  }
  inline void GetTrackedImagesDataView(
      XRTrackedImagesDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrackedImages(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRTrackedImagesDataDataView, UserType>(),
    "Attempting to read the optional `tracked_images` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTrackedImages` instead "
    "of `ReadTrackedImages if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->tracked_images.Get();
    return mojo::internal::Deserialize<::device::mojom::XRTrackedImagesDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::XRFrameData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RequestSessionSuccessDataView {
 public:
  RequestSessionSuccessDataView() = default;

  RequestSessionSuccessDataView(
      internal::RequestSessionSuccess_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSessionDataView(
      XRSessionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSession(UserType* output) {
    
    auto* pointer = data_->session.Get();
    return mojo::internal::Deserialize<::device::mojom::XRSessionDataView>(
        pointer, output, message_);
  }
  uint64_t trace_id() const {
    return data_->trace_id;
  }
  template <typename UserType>
  UserType TakeMetricsRecorder() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::device::mojom::XRSessionMetricsRecorderInterfaceBase>>(
            &data_->metrics_recorder, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeXrInternalsListener() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::device::mojom::WebXrInternalsRendererListenerInterfaceBase>>(
            &data_->xr_internals_listener, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::RequestSessionSuccess_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRFrameDataRequestOptionsDataView {
 public:
  XRFrameDataRequestOptionsDataView() = default;

  XRFrameDataRequestOptionsDataView(
      internal::XRFrameDataRequestOptions_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool include_lighting_estimation_data() const {
    return data_->include_lighting_estimation_data;
  }
  bool depth_active() const {
    return data_->depth_active;
  }
  uint32_t stage_parameters_id() const {
    return data_->stage_parameters_id;
  }
 private:
  internal::XRFrameDataRequestOptions_Data* data_ = nullptr;
};


class XRNativeOriginInformationDataView {
 public:
  using Tag = internal::XRNativeOriginInformation_Data::XRNativeOriginInformation_Tag;

  XRNativeOriginInformationDataView() = default;

  XRNativeOriginInformationDataView(
      internal::XRNativeOriginInformation_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_input_source_space_info() const { return data_->tag == Tag::kInputSourceSpaceInfo; }
  inline void GetInputSourceSpaceInfoDataView(
      XRInputSourceSpaceInfoDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadInputSourceSpaceInfo(UserType* output) const {
    
    CHECK(is_input_source_space_info());
    return mojo::internal::Deserialize<::device::mojom::XRInputSourceSpaceInfoDataView>(
        data_->data.f_input_source_space_info.Get(), output, message_);
  }
  bool is_plane_id() const { return data_->tag == Tag::kPlaneId; }
  inline void GetPlaneIdDataView(
      PlaneIdDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadPlaneId(UserType* output) const {
    
    CHECK(is_plane_id());
    return mojo::internal::Deserialize<::device::mojom::PlaneIdDataView>(
        data_->data.f_plane_id.Get(), output, message_);
  }
  bool is_anchor_id() const { return data_->tag == Tag::kAnchorId; }
  inline void GetAnchorIdDataView(
      AnchorIdDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadAnchorId(UserType* output) const {
    
    CHECK(is_anchor_id());
    return mojo::internal::Deserialize<::device::mojom::AnchorIdDataView>(
        data_->data.f_anchor_id.Get(), output, message_);
  }
  bool is_reference_space_type() const { return data_->tag == Tag::kReferenceSpaceType; }
  template <typename UserType>
  [[nodiscard]] bool ReadReferenceSpaceType(UserType* output) const {
    CHECK(is_reference_space_type());
    return mojo::internal::Deserialize<::device::mojom::XRReferenceSpaceType>(
        data_->data.f_reference_space_type, output);
  }
  XRReferenceSpaceType reference_space_type() const {
    CHECK(is_reference_space_type());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::XRReferenceSpaceType>(data_->data.f_reference_space_type));
  }
  bool is_hand_joint_space_info() const { return data_->tag == Tag::kHandJointSpaceInfo; }
  inline void GetHandJointSpaceInfoDataView(
      XRHandJointSpaceInfoDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadHandJointSpaceInfo(UserType* output) const {
    
    CHECK(is_hand_joint_space_info());
    return mojo::internal::Deserialize<::device::mojom::XRHandJointSpaceInfoDataView>(
        data_->data.f_hand_joint_space_info.Get(), output, message_);
  }
  bool is_image_index() const { return data_->tag == Tag::kImageIndex; }
  uint32_t image_index() const {
    CHECK(is_image_index());
    return data_->data.f_image_index;
  }

 private:
  internal::XRNativeOriginInformation_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class XRDepthDataDataView {
 public:
  using Tag = internal::XRDepthData_Data::XRDepthData_Tag;

  XRDepthDataDataView() = default;

  XRDepthDataDataView(
      internal::XRDepthData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_data_still_valid() const { return data_->tag == Tag::kDataStillValid; }
  inline void GetDataStillValidDataView(
      XRDepthDataStillValidDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadDataStillValid(UserType* output) const {
    
    CHECK(is_data_still_valid());
    return mojo::internal::Deserialize<::device::mojom::XRDepthDataStillValidDataView>(
        data_->data.f_data_still_valid.Get(), output, message_);
  }
  bool is_updated_depth_data() const { return data_->tag == Tag::kUpdatedDepthData; }
  inline void GetUpdatedDepthDataDataView(
      XRDepthDataUpdatedDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadUpdatedDepthData(UserType* output) const {
    
    CHECK(is_updated_depth_data());
    return mojo::internal::Deserialize<::device::mojom::XRDepthDataUpdatedDataView>(
        data_->data.f_updated_depth_data.Get(), output, message_);
  }

 private:
  internal::XRDepthData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class XRLayerSpecificDataDataView {
 public:
  using Tag = internal::XRLayerSpecificData_Data::XRLayerSpecificData_Tag;

  XRLayerSpecificDataDataView() = default;

  XRLayerSpecificDataDataView(
      internal::XRLayerSpecificData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_projection() const { return data_->tag == Tag::kProjection; }
  inline void GetProjectionDataView(
      XRProjectionLayerDataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadProjection(UserType* output) const {
    
    CHECK(is_projection());
    return mojo::internal::Deserialize<::device::mojom::XRProjectionLayerDataDataView>(
        data_->data.f_projection.Get(), output, message_);
  }
  bool is_quad() const { return data_->tag == Tag::kQuad; }
  inline void GetQuadDataView(
      XRQuadLayerDataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadQuad(UserType* output) const {
    
    CHECK(is_quad());
    return mojo::internal::Deserialize<::device::mojom::XRQuadLayerDataDataView>(
        data_->data.f_quad.Get(), output, message_);
  }
  bool is_cylinder() const { return data_->tag == Tag::kCylinder; }
  inline void GetCylinderDataView(
      XRCylinderLayerDataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadCylinder(UserType* output) const {
    
    CHECK(is_cylinder());
    return mojo::internal::Deserialize<::device::mojom::XRCylinderLayerDataDataView>(
        data_->data.f_cylinder.Get(), output, message_);
  }
  bool is_equirect() const { return data_->tag == Tag::kEquirect; }
  inline void GetEquirectDataView(
      XREquirectLayerDataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadEquirect(UserType* output) const {
    
    CHECK(is_equirect());
    return mojo::internal::Deserialize<::device::mojom::XREquirectLayerDataDataView>(
        data_->data.f_equirect.Get(), output, message_);
  }

 private:
  internal::XRLayerSpecificData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class RequestSessionResultDataView {
 public:
  using Tag = internal::RequestSessionResult_Data::RequestSessionResult_Tag;

  RequestSessionResultDataView() = default;

  RequestSessionResultDataView(
      internal::RequestSessionResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      RequestSessionSuccessDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<::device::mojom::RequestSessionSuccessDataView>(
        data_->data.f_success.Get(), output, message_);
  }
  bool is_failure_reason() const { return data_->tag == Tag::kFailureReason; }
  template <typename UserType>
  [[nodiscard]] bool ReadFailureReason(UserType* output) const {
    CHECK(is_failure_reason());
    return mojo::internal::Deserialize<::device::mojom::RequestSessionError>(
        data_->data.f_failure_reason, output);
  }
  ::device::mojom::RequestSessionError failure_reason() const {
    CHECK(is_failure_reason());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::RequestSessionError>(data_->data.f_failure_reason));
  }

 private:
  internal::RequestSessionResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // device::mojom

#endif  // DEVICE_VR_PUBLIC_MOJOM_VR_SERVICE_MOJOM_DATA_VIEW_H_