// device/vr/public/mojom/vr_service.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "device/vr/public/mojom/vr_service.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "device/vr/public/mojom/vr_service.mojom-params-data.h"
#include "device/vr/public/mojom/vr_service.mojom-shared-message-ids.h"

#include "device/vr/public/mojom/vr_service.mojom-blink-import-headers.h"
#include "device/vr/public/mojom/vr_service.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace device::mojom::blink {
constexpr uint64_t XRCubeMap::kNumComponentsPerPixel;
XRDepthConfig::XRDepthConfig()
    : depth_usage(),
      depth_data_format(),
      depth_type() {}

XRDepthConfig::XRDepthConfig(
    ::device::mojom::blink::XRDepthUsage depth_usage_in,
    ::device::mojom::blink::XRDepthDataFormat depth_data_format_in,
    std::optional<::device::mojom::blink::XRDepthType> depth_type_in)
    : depth_usage(std::move(depth_usage_in)),
      depth_data_format(std::move(depth_data_format_in)),
      depth_type(std::move(depth_type_in)) {}

XRDepthConfig::~XRDepthConfig() = default;

void XRDepthConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "depth_usage"), this->depth_usage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::device::mojom::blink::XRDepthUsage>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "depth_data_format"), this->depth_data_format,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::device::mojom::blink::XRDepthDataFormat>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "depth_type"), this->depth_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::device::mojom::blink::XRDepthType>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRDepthConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRSessionDeviceConfig::XRSessionDeviceConfig()
    : default_framebuffer_scale(1.0f),
      views(),
      supports_viewport_scaling(),
      enable_anti_aliasing(true),
      depth_configuration() {}

XRSessionDeviceConfig::XRSessionDeviceConfig(
    float default_framebuffer_scale_in,
    ::blink::Vector<XRViewPtr> views_in,
    bool supports_viewport_scaling_in,
    bool enable_anti_aliasing_in,
    XRDepthConfigPtr depth_configuration_in)
    : default_framebuffer_scale(std::move(default_framebuffer_scale_in)),
      views(std::move(views_in)),
      supports_viewport_scaling(std::move(supports_viewport_scaling_in)),
      enable_anti_aliasing(std::move(enable_anti_aliasing_in)),
      depth_configuration(std::move(depth_configuration_in)) {}

XRSessionDeviceConfig::~XRSessionDeviceConfig() = default;

void XRSessionDeviceConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "default_framebuffer_scale"), this->default_framebuffer_scale,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "views"), this->views,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<XRViewPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supports_viewport_scaling"), this->supports_viewport_scaling,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_anti_aliasing"), this->enable_anti_aliasing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "depth_configuration"), this->depth_configuration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRDepthConfigPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRSessionDeviceConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRSession::XRSession()
    : data_provider(),
      layer_manager(),
      client_receiver(),
      submit_frame_sink(),
      enabled_features(),
      device_config(),
      enviroment_blend_mode(),
      interaction_mode() {}

XRSession::XRSession(
    ::mojo::PendingRemote<XRFrameDataProvider> data_provider_in,
    ::mojo::PendingRemote<XRLayerManager> layer_manager_in,
    ::mojo::PendingReceiver<XRSessionClient> client_receiver_in,
    XRPresentationConnectionPtr submit_frame_sink_in,
    ::blink::Vector<::device::mojom::blink::XRSessionFeature> enabled_features_in,
    XRSessionDeviceConfigPtr device_config_in,
    XREnvironmentBlendMode enviroment_blend_mode_in,
    XRInteractionMode interaction_mode_in)
    : data_provider(std::move(data_provider_in)),
      layer_manager(std::move(layer_manager_in)),
      client_receiver(std::move(client_receiver_in)),
      submit_frame_sink(std::move(submit_frame_sink_in)),
      enabled_features(std::move(enabled_features_in)),
      device_config(std::move(device_config_in)),
      enviroment_blend_mode(std::move(enviroment_blend_mode_in)),
      interaction_mode(std::move(interaction_mode_in)) {}

XRSession::~XRSession() = default;

void XRSession::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data_provider"), this->data_provider,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<XRFrameDataProvider>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "layer_manager"), this->layer_manager,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<XRLayerManager>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_receiver"), this->client_receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<XRSessionClient>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "submit_frame_sink"), this->submit_frame_sink,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRPresentationConnectionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enabled_features"), this->enabled_features,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::device::mojom::blink::XRSessionFeature>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_config"), this->device_config,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRSessionDeviceConfigPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enviroment_blend_mode"), this->enviroment_blend_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XREnvironmentBlendMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "interaction_mode"), this->interaction_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRInteractionMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRSession::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRPresentationConnection::XRPresentationConnection()
    : provider(),
      client_receiver(),
      transport_options() {}

XRPresentationConnection::XRPresentationConnection(
    ::mojo::PendingRemote<XRPresentationProvider> provider_in,
    ::mojo::PendingReceiver<XRPresentationClient> client_receiver_in,
    XRPresentationTransportOptionsPtr transport_options_in)
    : provider(std::move(provider_in)),
      client_receiver(std::move(client_receiver_in)),
      transport_options(std::move(transport_options_in)) {}

XRPresentationConnection::~XRPresentationConnection() = default;

void XRPresentationConnection::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "provider"), this->provider,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<XRPresentationProvider>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_receiver"), this->client_receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<XRPresentationClient>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transport_options"), this->transport_options,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRPresentationTransportOptionsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRPresentationConnection::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRInputSourceDescription::XRInputSourceDescription()
    : target_ray_mode(),
      handedness(),
      input_from_pointer(),
      profiles() {}

XRInputSourceDescription::XRInputSourceDescription(
    XRTargetRayMode target_ray_mode_in,
    XRHandedness handedness_in,
    const std::optional<::gfx::Transform>& input_from_pointer_in,
    ::blink::Vector<::blink::String> profiles_in)
    : target_ray_mode(std::move(target_ray_mode_in)),
      handedness(std::move(handedness_in)),
      input_from_pointer(std::move(input_from_pointer_in)),
      profiles(std::move(profiles_in)) {}

XRInputSourceDescription::~XRInputSourceDescription() = default;

void XRInputSourceDescription::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_ray_mode"), this->target_ray_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRTargetRayMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "handedness"), this->handedness,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRHandedness>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_from_pointer"), this->input_from_pointer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Transform>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "profiles"), this->profiles,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::blink::String>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRInputSourceDescription::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRInputSourceState::XRInputSourceState()
    : source_id(),
      description(),
      mojo_from_input(),
      emulated_position(),
      is_auxiliary(),
      primary_input_pressed(),
      primary_input_clicked(),
      primary_squeeze_pressed(),
      primary_squeeze_clicked(),
      gamepad(),
      overlay_pointer_position(),
      hand_tracking_data() {}

XRInputSourceState::XRInputSourceState(
    uint32_t source_id_in,
    XRInputSourceDescriptionPtr description_in,
    const std::optional<::gfx::Transform>& mojo_from_input_in,
    bool emulated_position_in,
    bool is_auxiliary_in,
    bool primary_input_pressed_in,
    bool primary_input_clicked_in,
    bool primary_squeeze_pressed_in,
    bool primary_squeeze_clicked_in,
    const std::optional<::device::Gamepad>& gamepad_in,
    const std::optional<::gfx::PointF>& overlay_pointer_position_in,
    ::device::mojom::blink::XRHandTrackingDataPtr hand_tracking_data_in)
    : source_id(std::move(source_id_in)),
      description(std::move(description_in)),
      mojo_from_input(std::move(mojo_from_input_in)),
      emulated_position(std::move(emulated_position_in)),
      is_auxiliary(std::move(is_auxiliary_in)),
      primary_input_pressed(std::move(primary_input_pressed_in)),
      primary_input_clicked(std::move(primary_input_clicked_in)),
      primary_squeeze_pressed(std::move(primary_squeeze_pressed_in)),
      primary_squeeze_clicked(std::move(primary_squeeze_clicked_in)),
      gamepad(std::move(gamepad_in)),
      overlay_pointer_position(std::move(overlay_pointer_position_in)),
      hand_tracking_data(std::move(hand_tracking_data_in)) {}

XRInputSourceState::~XRInputSourceState() = default;

void XRInputSourceState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_id"), this->source_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description"), this->description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRInputSourceDescriptionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mojo_from_input"), this->mojo_from_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Transform>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "emulated_position"), this->emulated_position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_auxiliary"), this->is_auxiliary,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_input_pressed"), this->primary_input_pressed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_input_clicked"), this->primary_input_clicked,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_squeeze_pressed"), this->primary_squeeze_pressed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_squeeze_clicked"), this->primary_squeeze_clicked,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gamepad"), this->gamepad,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::device::Gamepad>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "overlay_pointer_position"), this->overlay_pointer_position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::PointF>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hand_tracking_data"), this->hand_tracking_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::device::mojom::blink::XRHandTrackingDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRInputSourceState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VRFieldOfView::VRFieldOfView()
    : up_degrees(),
      down_degrees(),
      left_degrees(),
      right_degrees() {}

VRFieldOfView::VRFieldOfView(
    float up_degrees_in,
    float down_degrees_in,
    float left_degrees_in,
    float right_degrees_in)
    : up_degrees(std::move(up_degrees_in)),
      down_degrees(std::move(down_degrees_in)),
      left_degrees(std::move(left_degrees_in)),
      right_degrees(std::move(right_degrees_in)) {}

VRFieldOfView::~VRFieldOfView() = default;
size_t VRFieldOfView::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->up_degrees);
  seed = mojo::internal::WTFHash(seed, this->down_degrees);
  seed = mojo::internal::WTFHash(seed, this->left_degrees);
  seed = mojo::internal::WTFHash(seed, this->right_degrees);
  return seed;
}

void VRFieldOfView::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "up_degrees"), this->up_degrees,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "down_degrees"), this->down_degrees,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "left_degrees"), this->left_degrees,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "right_degrees"), this->right_degrees,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VRFieldOfView::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VRPose::VRPose()
    : orientation(),
      position(),
      emulated_position() {}

VRPose::VRPose(
    const std::optional<::gfx::Quaternion>& orientation_in,
    const std::optional<::gfx::Point3F>& position_in,
    bool emulated_position_in)
    : orientation(std::move(orientation_in)),
      position(std::move(position_in)),
      emulated_position(std::move(emulated_position_in)) {}

VRPose::~VRPose() = default;

void VRPose::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "orientation"), this->orientation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Quaternion>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "position"), this->position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Point3F>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "emulated_position"), this->emulated_position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VRPose::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Pose::Pose()
    : orientation(),
      position() {}

Pose::Pose(
    const ::gfx::Quaternion& orientation_in,
    const ::gfx::Point3F& position_in)
    : orientation(std::move(orientation_in)),
      position(std::move(position_in)) {}

Pose::~Pose() = default;

void Pose::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "orientation"), this->orientation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Quaternion&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "position"), this->position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Point3F&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Pose::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AnchorId::AnchorId()
    : id_value() {}

AnchorId::AnchorId(
    uint64_t id_value_in)
    : id_value(std::move(id_value_in)) {}

AnchorId::~AnchorId() = default;

void AnchorId::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id_value"), this->id_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AnchorId::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HitTestSubscriptionId::HitTestSubscriptionId()
    : id_value() {}

HitTestSubscriptionId::HitTestSubscriptionId(
    uint64_t id_value_in)
    : id_value(std::move(id_value_in)) {}

HitTestSubscriptionId::~HitTestSubscriptionId() = default;

void HitTestSubscriptionId::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id_value"), this->id_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HitTestSubscriptionId::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PlaneId::PlaneId()
    : id_value() {}

PlaneId::PlaneId(
    uint64_t id_value_in)
    : id_value(std::move(id_value_in)) {}

PlaneId::~PlaneId() = default;

void PlaneId::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id_value"), this->id_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PlaneId::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XrVisibilityMaskId::XrVisibilityMaskId()
    : id_value() {}

XrVisibilityMaskId::XrVisibilityMaskId(
    uint64_t id_value_in)
    : id_value(std::move(id_value_in)) {}

XrVisibilityMaskId::~XrVisibilityMaskId() = default;

void XrVisibilityMaskId::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id_value"), this->id_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XrVisibilityMaskId::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRRay::XRRay()
    : origin(),
      direction() {}

XRRay::XRRay(
    const ::gfx::Point3F& origin_in,
    const ::gfx::Vector3dF& direction_in)
    : origin(std::move(origin_in)),
      direction(std::move(direction_in)) {}

XRRay::~XRRay() = default;

void XRRay::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Point3F&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "direction"), this->direction,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector3dF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRRay::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRHitResult::XRHitResult()
    : mojo_from_result(),
      plane_id() {}

XRHitResult::XRHitResult(
    const ::device::Pose& mojo_from_result_in,
    const std::optional<::device::PlaneId>& plane_id_in)
    : mojo_from_result(std::move(mojo_from_result_in)),
      plane_id(std::move(plane_id_in)) {}

XRHitResult::~XRHitResult() = default;

void XRHitResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mojo_from_result"), this->mojo_from_result,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::device::Pose&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "plane_id"), this->plane_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::device::PlaneId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRHitResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRViewGeometry::XRViewGeometry()
    : field_of_view(),
      mojo_from_view() {}

XRViewGeometry::XRViewGeometry(
    VRFieldOfViewPtr field_of_view_in,
    const ::gfx::Transform& mojo_from_view_in)
    : field_of_view(std::move(field_of_view_in)),
      mojo_from_view(std::move(mojo_from_view_in)) {}

XRViewGeometry::~XRViewGeometry() = default;

void XRViewGeometry::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "field_of_view"), this->field_of_view,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type VRFieldOfViewPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mojo_from_view"), this->mojo_from_view,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Transform&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRViewGeometry::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRVisibilityMask::XRVisibilityMask()
    : vertices(),
      unvalidated_indices() {}

XRVisibilityMask::XRVisibilityMask(
    ::blink::Vector<::gfx::PointF> vertices_in,
    ::blink::Vector<uint32_t> unvalidated_indices_in)
    : vertices(std::move(vertices_in)),
      unvalidated_indices(std::move(unvalidated_indices_in)) {}

XRVisibilityMask::~XRVisibilityMask() = default;

void XRVisibilityMask::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vertices"), this->vertices,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::gfx::PointF>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unvalidated_indices"), this->unvalidated_indices,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<uint32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRVisibilityMask::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRView::XRView()
    : eye(),
      geometry(),
      viewport(),
      depth_data(),
      is_first_person_observer(false),
      visibility_mask(),
      visibility_mask_id() {}

XRView::XRView(
    XREye eye_in,
    XRViewGeometryPtr geometry_in,
    const ::gfx::Rect& viewport_in,
    XRDepthDataPtr depth_data_in,
    bool is_first_person_observer_in,
    XRVisibilityMaskPtr visibility_mask_in,
    const ::device::XrVisibilityMaskId& visibility_mask_id_in)
    : eye(std::move(eye_in)),
      geometry(std::move(geometry_in)),
      viewport(std::move(viewport_in)),
      depth_data(std::move(depth_data_in)),
      is_first_person_observer(std::move(is_first_person_observer_in)),
      visibility_mask(std::move(visibility_mask_in)),
      visibility_mask_id(std::move(visibility_mask_id_in)) {}

XRView::~XRView() = default;

void XRView::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "eye"), this->eye,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XREye>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "geometry"), this->geometry,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRViewGeometryPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "viewport"), this->viewport,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "depth_data"), this->depth_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRDepthDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_first_person_observer"), this->is_first_person_observer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visibility_mask"), this->visibility_mask,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRVisibilityMaskPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visibility_mask_id"), this->visibility_mask_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::device::XrVisibilityMaskId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRView::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VRStageParameters::VRStageParameters()
    : mojo_from_stage(),
      bounds() {}

VRStageParameters::VRStageParameters(
    const ::gfx::Transform& mojo_from_stage_in,
    std::optional<::blink::Vector<::gfx::Point3F>> bounds_in)
    : mojo_from_stage(std::move(mojo_from_stage_in)),
      bounds(std::move(bounds_in)) {}

VRStageParameters::~VRStageParameters() = default;

void VRStageParameters::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mojo_from_stage"), this->mojo_from_stage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Transform&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bounds"), this->bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::Vector<::gfx::Point3F>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VRStageParameters::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRPresentationTransportOptions::XRPresentationTransportOptions()
    : transport_method(),
      wait_for_transfer_notification(),
      wait_for_render_notification(),
      wait_for_gpu_fence() {}

XRPresentationTransportOptions::XRPresentationTransportOptions(
    XRPresentationTransportMethod transport_method_in,
    bool wait_for_transfer_notification_in,
    bool wait_for_render_notification_in,
    bool wait_for_gpu_fence_in)
    : transport_method(std::move(transport_method_in)),
      wait_for_transfer_notification(std::move(wait_for_transfer_notification_in)),
      wait_for_render_notification(std::move(wait_for_render_notification_in)),
      wait_for_gpu_fence(std::move(wait_for_gpu_fence_in)) {}

XRPresentationTransportOptions::~XRPresentationTransportOptions() = default;
size_t XRPresentationTransportOptions::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->transport_method);
  seed = mojo::internal::WTFHash(seed, this->wait_for_transfer_notification);
  seed = mojo::internal::WTFHash(seed, this->wait_for_render_notification);
  seed = mojo::internal::WTFHash(seed, this->wait_for_gpu_fence);
  return seed;
}

void XRPresentationTransportOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transport_method"), this->transport_method,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRPresentationTransportMethod>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wait_for_transfer_notification"), this->wait_for_transfer_notification,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wait_for_render_notification"), this->wait_for_render_notification,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wait_for_gpu_fence"), this->wait_for_gpu_fence,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRPresentationTransportOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRInputSourceSpaceInfo::XRInputSourceSpaceInfo()
    : input_source_id(),
      input_source_space_type() {}

XRInputSourceSpaceInfo::XRInputSourceSpaceInfo(
    uint32_t input_source_id_in,
    XRInputSourceSpaceType input_source_space_type_in)
    : input_source_id(std::move(input_source_id_in)),
      input_source_space_type(std::move(input_source_space_type_in)) {}

XRInputSourceSpaceInfo::~XRInputSourceSpaceInfo() = default;
size_t XRInputSourceSpaceInfo::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->input_source_id);
  seed = mojo::internal::WTFHash(seed, this->input_source_space_type);
  return seed;
}

void XRInputSourceSpaceInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_source_id"), this->input_source_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_source_space_type"), this->input_source_space_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRInputSourceSpaceType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRInputSourceSpaceInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRHandJointSpaceInfo::XRHandJointSpaceInfo()
    : handedness(),
      joint() {}

XRHandJointSpaceInfo::XRHandJointSpaceInfo(
    XRHandedness handedness_in,
    ::device::mojom::blink::XRHandJoint joint_in)
    : handedness(std::move(handedness_in)),
      joint(std::move(joint_in)) {}

XRHandJointSpaceInfo::~XRHandJointSpaceInfo() = default;
size_t XRHandJointSpaceInfo::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->handedness);
  seed = mojo::internal::WTFHash(seed, this->joint);
  return seed;
}

void XRHandJointSpaceInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "handedness"), this->handedness,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRHandedness>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "joint"), this->joint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::device::mojom::blink::XRHandJoint>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRHandJointSpaceInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRPlanePointData::XRPlanePointData()
    : x(),
      z() {}

XRPlanePointData::XRPlanePointData(
    float x_in,
    float z_in)
    : x(std::move(x_in)),
      z(std::move(z_in)) {}

XRPlanePointData::~XRPlanePointData() = default;
size_t XRPlanePointData::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->x);
  seed = mojo::internal::WTFHash(seed, this->z);
  return seed;
}

void XRPlanePointData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "x"), this->x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "z"), this->z,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRPlanePointData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRPlaneData::XRPlaneData()
    : id(),
      orientation(),
      mojo_from_plane(),
      polygon() {}

XRPlaneData::XRPlaneData(
    const ::device::PlaneId& id_in,
    XRPlaneOrientation orientation_in,
    const std::optional<::device::Pose>& mojo_from_plane_in,
    ::blink::Vector<XRPlanePointDataPtr> polygon_in)
    : id(std::move(id_in)),
      orientation(std::move(orientation_in)),
      mojo_from_plane(std::move(mojo_from_plane_in)),
      polygon(std::move(polygon_in)) {}

XRPlaneData::~XRPlaneData() = default;

void XRPlaneData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::device::PlaneId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "orientation"), this->orientation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRPlaneOrientation>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mojo_from_plane"), this->mojo_from_plane,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::device::Pose>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "polygon"), this->polygon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<XRPlanePointDataPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRPlaneData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRPlaneDetectionData::XRPlaneDetectionData()
    : all_planes_ids(),
      updated_planes_data() {}

XRPlaneDetectionData::XRPlaneDetectionData(
    ::blink::Vector<::device::PlaneId> all_planes_ids_in,
    ::blink::Vector<XRPlaneDataPtr> updated_planes_data_in)
    : all_planes_ids(std::move(all_planes_ids_in)),
      updated_planes_data(std::move(updated_planes_data_in)) {}

XRPlaneDetectionData::~XRPlaneDetectionData() = default;

void XRPlaneDetectionData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "all_planes_ids"), this->all_planes_ids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::device::PlaneId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "updated_planes_data"), this->updated_planes_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<XRPlaneDataPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRPlaneDetectionData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRAnchorData::XRAnchorData()
    : id(),
      mojo_from_anchor() {}

XRAnchorData::XRAnchorData(
    const ::device::AnchorId& id_in,
    const std::optional<::device::Pose>& mojo_from_anchor_in)
    : id(std::move(id_in)),
      mojo_from_anchor(std::move(mojo_from_anchor_in)) {}

XRAnchorData::~XRAnchorData() = default;

void XRAnchorData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::device::AnchorId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mojo_from_anchor"), this->mojo_from_anchor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::device::Pose>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRAnchorData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRAnchorsData::XRAnchorsData()
    : all_anchors_ids(),
      updated_anchors_data() {}

XRAnchorsData::XRAnchorsData(
    ::blink::Vector<::device::AnchorId> all_anchors_ids_in,
    ::blink::Vector<XRAnchorDataPtr> updated_anchors_data_in)
    : all_anchors_ids(std::move(all_anchors_ids_in)),
      updated_anchors_data(std::move(updated_anchors_data_in)) {}

XRAnchorsData::~XRAnchorsData() = default;

void XRAnchorsData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "all_anchors_ids"), this->all_anchors_ids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::device::AnchorId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "updated_anchors_data"), this->updated_anchors_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<XRAnchorDataPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRAnchorsData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRHitTestSubscriptionResultData::XRHitTestSubscriptionResultData()
    : subscription_id(),
      hit_test_results() {}

XRHitTestSubscriptionResultData::XRHitTestSubscriptionResultData(
    const ::device::HitTestSubscriptionId& subscription_id_in,
    ::blink::Vector<XRHitResultPtr> hit_test_results_in)
    : subscription_id(std::move(subscription_id_in)),
      hit_test_results(std::move(hit_test_results_in)) {}

XRHitTestSubscriptionResultData::~XRHitTestSubscriptionResultData() = default;

void XRHitTestSubscriptionResultData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subscription_id"), this->subscription_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::device::HitTestSubscriptionId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hit_test_results"), this->hit_test_results,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<XRHitResultPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRHitTestSubscriptionResultData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRHitTestTransientInputSubscriptionResultData::XRHitTestTransientInputSubscriptionResultData()
    : subscription_id(),
      input_source_id_to_hit_test_results() {}

XRHitTestTransientInputSubscriptionResultData::XRHitTestTransientInputSubscriptionResultData(
    const ::device::HitTestSubscriptionId& subscription_id_in,
    ::blink::HashMap<uint32_t, ::blink::Vector<XRHitResultPtr>> input_source_id_to_hit_test_results_in)
    : subscription_id(std::move(subscription_id_in)),
      input_source_id_to_hit_test_results(std::move(input_source_id_to_hit_test_results_in)) {}

XRHitTestTransientInputSubscriptionResultData::~XRHitTestTransientInputSubscriptionResultData() = default;

void XRHitTestTransientInputSubscriptionResultData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subscription_id"), this->subscription_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::device::HitTestSubscriptionId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_source_id_to_hit_test_results"), this->input_source_id_to_hit_test_results,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::HashMap<uint32_t, ::blink::Vector<XRHitResultPtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRHitTestTransientInputSubscriptionResultData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRHitTestSubscriptionResultsData::XRHitTestSubscriptionResultsData()
    : results(),
      transient_input_results() {}

XRHitTestSubscriptionResultsData::XRHitTestSubscriptionResultsData(
    ::blink::Vector<XRHitTestSubscriptionResultDataPtr> results_in,
    ::blink::Vector<XRHitTestTransientInputSubscriptionResultDataPtr> transient_input_results_in)
    : results(std::move(results_in)),
      transient_input_results(std::move(transient_input_results_in)) {}

XRHitTestSubscriptionResultsData::~XRHitTestSubscriptionResultsData() = default;

void XRHitTestSubscriptionResultsData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "results"), this->results,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<XRHitTestSubscriptionResultDataPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transient_input_results"), this->transient_input_results,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<XRHitTestTransientInputSubscriptionResultDataPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRHitTestSubscriptionResultsData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RgbTupleF32::RgbTupleF32()
    : red(),
      green(),
      blue() {}

RgbTupleF32::RgbTupleF32(
    float red_in,
    float green_in,
    float blue_in)
    : red(std::move(red_in)),
      green(std::move(green_in)),
      blue(std::move(blue_in)) {}

RgbTupleF32::~RgbTupleF32() = default;

void RgbTupleF32::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "red"), this->red,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "green"), this->green,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blue"), this->blue,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RgbTupleF32::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRSphericalHarmonics::XRSphericalHarmonics()
    : coefficients() {}

XRSphericalHarmonics::XRSphericalHarmonics(
    ::blink::Vector<::device::RgbTupleF32> coefficients_in)
    : coefficients(std::move(coefficients_in)) {}

XRSphericalHarmonics::~XRSphericalHarmonics() = default;

void XRSphericalHarmonics::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "coefficients"), this->coefficients,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::device::RgbTupleF32>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRSphericalHarmonics::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRCubeMap::XRCubeMap()
    : width_and_height(),
      positive_x(),
      negative_x(),
      positive_y(),
      negative_y(),
      positive_z(),
      negative_z() {}

XRCubeMap::XRCubeMap(
    uint32_t width_and_height_in,
    ::blink::Vector<uint16_t> positive_x_in,
    ::blink::Vector<uint16_t> negative_x_in,
    ::blink::Vector<uint16_t> positive_y_in,
    ::blink::Vector<uint16_t> negative_y_in,
    ::blink::Vector<uint16_t> positive_z_in,
    ::blink::Vector<uint16_t> negative_z_in)
    : width_and_height(std::move(width_and_height_in)),
      positive_x(std::move(positive_x_in)),
      negative_x(std::move(negative_x_in)),
      positive_y(std::move(positive_y_in)),
      negative_y(std::move(negative_y_in)),
      positive_z(std::move(positive_z_in)),
      negative_z(std::move(negative_z_in)) {}

XRCubeMap::~XRCubeMap() = default;

void XRCubeMap::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "width_and_height"), this->width_and_height,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "positive_x"), this->positive_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<uint16_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "negative_x"), this->negative_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<uint16_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "positive_y"), this->positive_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<uint16_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "negative_y"), this->negative_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<uint16_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "positive_z"), this->positive_z,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<uint16_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "negative_z"), this->negative_z,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<uint16_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRCubeMap::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRLightProbe::XRLightProbe()
    : spherical_harmonics(),
      main_light_direction(),
      main_light_intensity() {}

XRLightProbe::XRLightProbe(
    XRSphericalHarmonicsPtr spherical_harmonics_in,
    const ::gfx::Vector3dF& main_light_direction_in,
    const ::device::RgbTupleF32& main_light_intensity_in)
    : spherical_harmonics(std::move(spherical_harmonics_in)),
      main_light_direction(std::move(main_light_direction_in)),
      main_light_intensity(std::move(main_light_intensity_in)) {}

XRLightProbe::~XRLightProbe() = default;

void XRLightProbe::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "spherical_harmonics"), this->spherical_harmonics,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRSphericalHarmonicsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_light_direction"), this->main_light_direction,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector3dF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_light_intensity"), this->main_light_intensity,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::device::RgbTupleF32&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRLightProbe::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRReflectionProbe::XRReflectionProbe()
    : cube_map() {}

XRReflectionProbe::XRReflectionProbe(
    XRCubeMapPtr cube_map_in)
    : cube_map(std::move(cube_map_in)) {}

XRReflectionProbe::~XRReflectionProbe() = default;

void XRReflectionProbe::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cube_map"), this->cube_map,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRCubeMapPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRReflectionProbe::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRLightEstimationData::XRLightEstimationData()
    : light_probe(),
      reflection_probe() {}

XRLightEstimationData::XRLightEstimationData(
    XRLightProbePtr light_probe_in,
    XRReflectionProbePtr reflection_probe_in)
    : light_probe(std::move(light_probe_in)),
      reflection_probe(std::move(reflection_probe_in)) {}

XRLightEstimationData::~XRLightEstimationData() = default;

void XRLightEstimationData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "light_probe"), this->light_probe,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRLightProbePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reflection_probe"), this->reflection_probe,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRReflectionProbePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRLightEstimationData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRDepthDataStillValid::XRDepthDataStillValid() {}

XRDepthDataStillValid::~XRDepthDataStillValid() = default;
size_t XRDepthDataStillValid::Hash(size_t seed) const {
  return seed;
}

void XRDepthDataStillValid::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
}

bool XRDepthDataStillValid::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRDepthDataUpdated::XRDepthDataUpdated()
    : pixel_data(),
      norm_texture_from_norm_view(),
      size(),
      raw_value_to_meters(),
      view_geometry() {}

XRDepthDataUpdated::XRDepthDataUpdated(
    ::mojo_base::BigBuffer pixel_data_in,
    const ::gfx::Transform& norm_texture_from_norm_view_in,
    const ::gfx::Size& size_in,
    float raw_value_to_meters_in,
    XRViewGeometryPtr view_geometry_in)
    : pixel_data(std::move(pixel_data_in)),
      norm_texture_from_norm_view(std::move(norm_texture_from_norm_view_in)),
      size(std::move(size_in)),
      raw_value_to_meters(std::move(raw_value_to_meters_in)),
      view_geometry(std::move(view_geometry_in)) {}

XRDepthDataUpdated::~XRDepthDataUpdated() = default;

void XRDepthDataUpdated::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pixel_data"), this->pixel_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo_base::BigBuffer>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "norm_texture_from_norm_view"), this->norm_texture_from_norm_view,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Transform&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size"), this->size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "raw_value_to_meters"), this->raw_value_to_meters,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "view_geometry"), this->view_geometry,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRViewGeometryPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRDepthDataUpdated::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRTrackedImageData::XRTrackedImageData()
    : index(),
      mojo_from_image(),
      actively_tracked(),
      width_in_meters() {}

XRTrackedImageData::XRTrackedImageData(
    uint32_t index_in,
    const ::device::Pose& mojo_from_image_in,
    bool actively_tracked_in,
    float width_in_meters_in)
    : index(std::move(index_in)),
      mojo_from_image(std::move(mojo_from_image_in)),
      actively_tracked(std::move(actively_tracked_in)),
      width_in_meters(std::move(width_in_meters_in)) {}

XRTrackedImageData::~XRTrackedImageData() = default;

void XRTrackedImageData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "index"), this->index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mojo_from_image"), this->mojo_from_image,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::device::Pose&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "actively_tracked"), this->actively_tracked,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "width_in_meters"), this->width_in_meters,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRTrackedImageData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRTrackedImagesData::XRTrackedImagesData()
    : images_data(),
      image_trackable_scores() {}

XRTrackedImagesData::XRTrackedImagesData(
    ::blink::Vector<XRTrackedImageDataPtr> images_data_in,
    std::optional<::blink::Vector<bool>> image_trackable_scores_in)
    : images_data(std::move(images_data_in)),
      image_trackable_scores(std::move(image_trackable_scores_in)) {}

XRTrackedImagesData::~XRTrackedImagesData() = default;

void XRTrackedImagesData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "images_data"), this->images_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<XRTrackedImageDataPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_trackable_scores"), this->image_trackable_scores,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::Vector<bool>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRTrackedImagesData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LayerId::LayerId()
    : id_value() {}

LayerId::LayerId(
    uint64_t id_value_in)
    : id_value(std::move(id_value_in)) {}

LayerId::~LayerId() = default;

void LayerId::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id_value"), this->id_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LayerId::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRProjectionLayerData::XRProjectionLayerData() {}

XRProjectionLayerData::~XRProjectionLayerData() = default;
size_t XRProjectionLayerData::Hash(size_t seed) const {
  return seed;
}

void XRProjectionLayerData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
}

bool XRProjectionLayerData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRQuadLayerData::XRQuadLayerData()
    : transform(),
      width(),
      height() {}

XRQuadLayerData::XRQuadLayerData(
    const ::gfx::Transform& transform_in,
    float width_in,
    float height_in)
    : transform(std::move(transform_in)),
      width(std::move(width_in)),
      height(std::move(height_in)) {}

XRQuadLayerData::~XRQuadLayerData() = default;

void XRQuadLayerData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transform"), this->transform,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Transform&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "width"), this->width,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "height"), this->height,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRQuadLayerData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRCylinderLayerData::XRCylinderLayerData()
    : transform(),
      radius(),
      central_angle(),
      aspect_ratio() {}

XRCylinderLayerData::XRCylinderLayerData(
    const ::gfx::Transform& transform_in,
    float radius_in,
    float central_angle_in,
    float aspect_ratio_in)
    : transform(std::move(transform_in)),
      radius(std::move(radius_in)),
      central_angle(std::move(central_angle_in)),
      aspect_ratio(std::move(aspect_ratio_in)) {}

XRCylinderLayerData::~XRCylinderLayerData() = default;

void XRCylinderLayerData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transform"), this->transform,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Transform&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "radius"), this->radius,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "central_angle"), this->central_angle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aspect_ratio"), this->aspect_ratio,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRCylinderLayerData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XREquirectLayerData::XREquirectLayerData()
    : transform(),
      radius(),
      central_horizontal_angle(),
      upper_vertical_angle(),
      lower_vertical_angle() {}

XREquirectLayerData::XREquirectLayerData(
    const ::gfx::Transform& transform_in,
    float radius_in,
    float central_horizontal_angle_in,
    float upper_vertical_angle_in,
    float lower_vertical_angle_in)
    : transform(std::move(transform_in)),
      radius(std::move(radius_in)),
      central_horizontal_angle(std::move(central_horizontal_angle_in)),
      upper_vertical_angle(std::move(upper_vertical_angle_in)),
      lower_vertical_angle(std::move(lower_vertical_angle_in)) {}

XREquirectLayerData::~XREquirectLayerData() = default;

void XREquirectLayerData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transform"), this->transform,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Transform&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "radius"), this->radius,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "central_horizontal_angle"), this->central_horizontal_angle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "upper_vertical_angle"), this->upper_vertical_angle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lower_vertical_angle"), this->lower_vertical_angle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XREquirectLayerData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRLayerReadOnlyData::XRLayerReadOnlyData()
    : layer_id(),
      texture_width(),
      texture_height(),
      is_static() {}

XRLayerReadOnlyData::XRLayerReadOnlyData(
    const ::device::LayerId& layer_id_in,
    uint32_t texture_width_in,
    uint32_t texture_height_in,
    bool is_static_in)
    : layer_id(std::move(layer_id_in)),
      texture_width(std::move(texture_width_in)),
      texture_height(std::move(texture_height_in)),
      is_static(std::move(is_static_in)) {}

XRLayerReadOnlyData::~XRLayerReadOnlyData() = default;

void XRLayerReadOnlyData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "layer_id"), this->layer_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::device::LayerId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "texture_width"), this->texture_width,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "texture_height"), this->texture_height,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_static"), this->is_static,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRLayerReadOnlyData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRLayerMutableData::XRLayerMutableData()
    : blend_texture_source_alpha(),
      opacity(),
      reference_space_type(),
      layer_data() {}

XRLayerMutableData::XRLayerMutableData(
    bool blend_texture_source_alpha_in,
    float opacity_in,
    XRReferenceSpaceType reference_space_type_in,
    XRLayerSpecificDataPtr layer_data_in)
    : blend_texture_source_alpha(std::move(blend_texture_source_alpha_in)),
      opacity(std::move(opacity_in)),
      reference_space_type(std::move(reference_space_type_in)),
      layer_data(std::move(layer_data_in)) {}

XRLayerMutableData::~XRLayerMutableData() = default;

void XRLayerMutableData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blend_texture_source_alpha"), this->blend_texture_source_alpha,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "opacity"), this->opacity,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reference_space_type"), this->reference_space_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRReferenceSpaceType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "layer_data"), this->layer_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRLayerSpecificDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRLayerMutableData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRCompositionLayerData::XRCompositionLayerData()
    : read_only_data(),
      mutable_data() {}

XRCompositionLayerData::XRCompositionLayerData(
    XRLayerReadOnlyDataPtr read_only_data_in,
    XRLayerMutableDataPtr mutable_data_in)
    : read_only_data(std::move(read_only_data_in)),
      mutable_data(std::move(mutable_data_in)) {}

XRCompositionLayerData::~XRCompositionLayerData() = default;

void XRCompositionLayerData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "read_only_data"), this->read_only_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRLayerReadOnlyDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mutable_data"), this->mutable_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRLayerMutableDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRCompositionLayerData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRLayerFrameData::XRLayerFrameData()
    : layer_id(),
      buffer_shared_image(),
      buffer_sync_token() {}

XRLayerFrameData::XRLayerFrameData(
    const ::device::LayerId& layer_id_in,
    ::gpu::ExportedSharedImage buffer_shared_image_in,
    const ::gpu::SyncToken& buffer_sync_token_in)
    : layer_id(std::move(layer_id_in)),
      buffer_shared_image(std::move(buffer_shared_image_in)),
      buffer_sync_token(std::move(buffer_sync_token_in)) {}

XRLayerFrameData::~XRLayerFrameData() = default;

void XRLayerFrameData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "layer_id"), this->layer_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::device::LayerId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buffer_shared_image"), this->buffer_shared_image,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gpu::ExportedSharedImage>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buffer_sync_token"), this->buffer_sync_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gpu::SyncToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRLayerFrameData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRRenderInfo::XRRenderInfo()
    : frame_id(),
      mojo_from_viewer(),
      views() {}

XRRenderInfo::XRRenderInfo(
    int16_t frame_id_in,
    VRPosePtr mojo_from_viewer_in,
    ::blink::Vector<XRViewPtr> views_in)
    : frame_id(std::move(frame_id_in)),
      mojo_from_viewer(std::move(mojo_from_viewer_in)),
      views(std::move(views_in)) {}

XRRenderInfo::~XRRenderInfo() = default;

void XRRenderInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_id"), this->frame_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mojo_from_viewer"), this->mojo_from_viewer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type VRPosePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "views"), this->views,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<XRViewPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRRenderInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRFrameData::XRFrameData()
    : render_info(),
      time_delta(),
      buffer_shared_image(),
      buffer_sync_token(),
      camera_image_buffer_shared_image(),
      camera_image_buffer_sync_token(),
      camera_image_size(),
      mojo_space_reset(),
      mojo_from_floor(),
      input_state(),
      stage_parameters_id(),
      stage_parameters(),
      detected_planes_data(),
      anchors_data(),
      composition_layers_data(),
      light_estimation_data(),
      hit_test_subscription_results(),
      rendering_time_ratio(),
      tracked_images() {}

XRFrameData::XRFrameData(
    XRRenderInfoPtr render_info_in,
    ::base::TimeDelta time_delta_in,
    std::optional<::gpu::ExportedSharedImage> buffer_shared_image_in,
    const std::optional<::gpu::SyncToken>& buffer_sync_token_in,
    std::optional<::gpu::ExportedSharedImage> camera_image_buffer_shared_image_in,
    const std::optional<::gpu::SyncToken>& camera_image_buffer_sync_token_in,
    const std::optional<::gfx::Size>& camera_image_size_in,
    bool mojo_space_reset_in,
    const std::optional<::gfx::Transform>& mojo_from_floor_in,
    std::optional<::blink::Vector<XRInputSourceStatePtr>> input_state_in,
    uint32_t stage_parameters_id_in,
    VRStageParametersPtr stage_parameters_in,
    XRPlaneDetectionDataPtr detected_planes_data_in,
    XRAnchorsDataPtr anchors_data_in,
    std::optional<::blink::Vector<XRLayerFrameDataPtr>> composition_layers_data_in,
    XRLightEstimationDataPtr light_estimation_data_in,
    XRHitTestSubscriptionResultsDataPtr hit_test_subscription_results_in,
    float rendering_time_ratio_in,
    XRTrackedImagesDataPtr tracked_images_in)
    : render_info(std::move(render_info_in)),
      time_delta(std::move(time_delta_in)),
      buffer_shared_image(std::move(buffer_shared_image_in)),
      buffer_sync_token(std::move(buffer_sync_token_in)),
      camera_image_buffer_shared_image(std::move(camera_image_buffer_shared_image_in)),
      camera_image_buffer_sync_token(std::move(camera_image_buffer_sync_token_in)),
      camera_image_size(std::move(camera_image_size_in)),
      mojo_space_reset(std::move(mojo_space_reset_in)),
      mojo_from_floor(std::move(mojo_from_floor_in)),
      input_state(std::move(input_state_in)),
      stage_parameters_id(std::move(stage_parameters_id_in)),
      stage_parameters(std::move(stage_parameters_in)),
      detected_planes_data(std::move(detected_planes_data_in)),
      anchors_data(std::move(anchors_data_in)),
      composition_layers_data(std::move(composition_layers_data_in)),
      light_estimation_data(std::move(light_estimation_data_in)),
      hit_test_subscription_results(std::move(hit_test_subscription_results_in)),
      rendering_time_ratio(std::move(rendering_time_ratio_in)),
      tracked_images(std::move(tracked_images_in)) {}

XRFrameData::~XRFrameData() = default;

void XRFrameData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "render_info"), this->render_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRRenderInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "time_delta"), this->time_delta,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buffer_shared_image"), this->buffer_shared_image,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::gpu::ExportedSharedImage>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buffer_sync_token"), this->buffer_sync_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gpu::SyncToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "camera_image_buffer_shared_image"), this->camera_image_buffer_shared_image,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::gpu::ExportedSharedImage>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "camera_image_buffer_sync_token"), this->camera_image_buffer_sync_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gpu::SyncToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "camera_image_size"), this->camera_image_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Size>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mojo_space_reset"), this->mojo_space_reset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mojo_from_floor"), this->mojo_from_floor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Transform>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_state"), this->input_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::blink::Vector<XRInputSourceStatePtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stage_parameters_id"), this->stage_parameters_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stage_parameters"), this->stage_parameters,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type VRStageParametersPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "detected_planes_data"), this->detected_planes_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRPlaneDetectionDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "anchors_data"), this->anchors_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRAnchorsDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "composition_layers_data"), this->composition_layers_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::blink::Vector<XRLayerFrameDataPtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "light_estimation_data"), this->light_estimation_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRLightEstimationDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hit_test_subscription_results"), this->hit_test_subscription_results,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRHitTestSubscriptionResultsDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rendering_time_ratio"), this->rendering_time_ratio,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tracked_images"), this->tracked_images,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRTrackedImagesDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRFrameData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RequestSessionSuccess::RequestSessionSuccess()
    : session(),
      trace_id(),
      metrics_recorder(),
      xr_internals_listener() {}

RequestSessionSuccess::RequestSessionSuccess(
    XRSessionPtr session_in,
    uint64_t trace_id_in,
    ::mojo::PendingRemote<XRSessionMetricsRecorder> metrics_recorder_in,
    ::mojo::PendingRemote<WebXrInternalsRendererListener> xr_internals_listener_in)
    : session(std::move(session_in)),
      trace_id(std::move(trace_id_in)),
      metrics_recorder(std::move(metrics_recorder_in)),
      xr_internals_listener(std::move(xr_internals_listener_in)) {}

RequestSessionSuccess::~RequestSessionSuccess() = default;

void RequestSessionSuccess::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "session"), this->session,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRSessionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trace_id"), this->trace_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "metrics_recorder"), this->metrics_recorder,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<XRSessionMetricsRecorder>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "xr_internals_listener"), this->xr_internals_listener,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<WebXrInternalsRendererListener>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RequestSessionSuccess::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRFrameDataRequestOptions::XRFrameDataRequestOptions()
    : include_lighting_estimation_data(),
      depth_active(),
      stage_parameters_id() {}

XRFrameDataRequestOptions::XRFrameDataRequestOptions(
    bool include_lighting_estimation_data_in,
    bool depth_active_in,
    uint32_t stage_parameters_id_in)
    : include_lighting_estimation_data(std::move(include_lighting_estimation_data_in)),
      depth_active(std::move(depth_active_in)),
      stage_parameters_id(std::move(stage_parameters_id_in)) {}

XRFrameDataRequestOptions::~XRFrameDataRequestOptions() = default;
size_t XRFrameDataRequestOptions::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->include_lighting_estimation_data);
  seed = mojo::internal::WTFHash(seed, this->depth_active);
  seed = mojo::internal::WTFHash(seed, this->stage_parameters_id);
  return seed;
}

void XRFrameDataRequestOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "include_lighting_estimation_data"), this->include_lighting_estimation_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "depth_active"), this->depth_active,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stage_parameters_id"), this->stage_parameters_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRFrameDataRequestOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRNativeOriginInformationPtr
XRNativeOriginInformation::NewInputSourceSpaceInfo(
    XRInputSourceSpaceInfoPtr value) {
  return XRNativeOriginInformationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kInputSourceSpaceInfo)>,
      std::move(value));
}

XRNativeOriginInformationPtr
XRNativeOriginInformation::NewPlaneId(
    const ::device::PlaneId& value) {
  return XRNativeOriginInformationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kPlaneId)>,
      std::move(value));
}

XRNativeOriginInformationPtr
XRNativeOriginInformation::NewAnchorId(
    const ::device::AnchorId& value) {
  return XRNativeOriginInformationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kAnchorId)>,
      std::move(value));
}

XRNativeOriginInformationPtr
XRNativeOriginInformation::NewReferenceSpaceType(
    XRReferenceSpaceType value) {
  return XRNativeOriginInformationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kReferenceSpaceType)>,
      std::move(value));
}

XRNativeOriginInformationPtr
XRNativeOriginInformation::NewHandJointSpaceInfo(
    XRHandJointSpaceInfoPtr value) {
  return XRNativeOriginInformationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kHandJointSpaceInfo)>,
      std::move(value));
}

XRNativeOriginInformationPtr
XRNativeOriginInformation::NewImageIndex(
    uint32_t value) {
  return XRNativeOriginInformationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kImageIndex)>,
      std::move(value));
}

XRNativeOriginInformation::XRNativeOriginInformation(
    std::in_place_index_t<static_cast<size_t>(Tag::kInputSourceSpaceInfo)>,
    XRInputSourceSpaceInfoPtr value)
    : tag_(Tag::kInputSourceSpaceInfo),
      data_(std::in_place_index<static_cast<size_t>(Tag::kInputSourceSpaceInfo)>,
            std::move(value)) {}

XRNativeOriginInformation::XRNativeOriginInformation(
    std::in_place_index_t<static_cast<size_t>(Tag::kPlaneId)>,
    const ::device::PlaneId& value)
    : tag_(Tag::kPlaneId),
      data_(std::in_place_index<static_cast<size_t>(Tag::kPlaneId)>,
            std::move(value)) {}

XRNativeOriginInformation::XRNativeOriginInformation(
    std::in_place_index_t<static_cast<size_t>(Tag::kAnchorId)>,
    const ::device::AnchorId& value)
    : tag_(Tag::kAnchorId),
      data_(std::in_place_index<static_cast<size_t>(Tag::kAnchorId)>,
            std::move(value)) {}

XRNativeOriginInformation::XRNativeOriginInformation(
    std::in_place_index_t<static_cast<size_t>(Tag::kReferenceSpaceType)>,
    XRReferenceSpaceType value)
    : tag_(Tag::kReferenceSpaceType),
      data_(std::in_place_index<static_cast<size_t>(Tag::kReferenceSpaceType)>,
            std::move(value)) {}

XRNativeOriginInformation::XRNativeOriginInformation(
    std::in_place_index_t<static_cast<size_t>(Tag::kHandJointSpaceInfo)>,
    XRHandJointSpaceInfoPtr value)
    : tag_(Tag::kHandJointSpaceInfo),
      data_(std::in_place_index<static_cast<size_t>(Tag::kHandJointSpaceInfo)>,
            std::move(value)) {}

XRNativeOriginInformation::XRNativeOriginInformation(
    std::in_place_index_t<static_cast<size_t>(Tag::kImageIndex)>,
    uint32_t value)
    : tag_(Tag::kImageIndex),
      data_(std::in_place_index<static_cast<size_t>(Tag::kImageIndex)>,
            std::move(value)) {}
XRNativeOriginInformation::~XRNativeOriginInformation() {
  DestroyActive();
}

void XRNativeOriginInformation::set_input_source_space_info(XRInputSourceSpaceInfoPtr input_source_space_info) {
  if (tag_ == Tag::kInputSourceSpaceInfo) {
    data_.input_source_space_info = std::move(input_source_space_info);
  } else {
    DestroyActive();
    tag_ = Tag::kInputSourceSpaceInfo;
    new (&data_.input_source_space_info) XRInputSourceSpaceInfoPtr(
        std::move(input_source_space_info));
  }
}

void XRNativeOriginInformation::set_plane_id(const ::device::PlaneId& plane_id) {
  if (tag_ == Tag::kPlaneId) {
    data_.plane_id = std::move(plane_id);
  } else {
    DestroyActive();
    tag_ = Tag::kPlaneId;
    new (&data_.plane_id) ::device::PlaneId(
        std::move(plane_id));
  }
}

void XRNativeOriginInformation::set_anchor_id(const ::device::AnchorId& anchor_id) {
  if (tag_ == Tag::kAnchorId) {
    data_.anchor_id = std::move(anchor_id);
  } else {
    DestroyActive();
    tag_ = Tag::kAnchorId;
    new (&data_.anchor_id) ::device::AnchorId(
        std::move(anchor_id));
  }
}

void XRNativeOriginInformation::set_reference_space_type(XRReferenceSpaceType reference_space_type) {
  if (tag_ != Tag::kReferenceSpaceType) {
    DestroyActive();
    tag_ = Tag::kReferenceSpaceType;
  }
  data_.reference_space_type = reference_space_type;
}

void XRNativeOriginInformation::set_hand_joint_space_info(XRHandJointSpaceInfoPtr hand_joint_space_info) {
  if (tag_ == Tag::kHandJointSpaceInfo) {
    data_.hand_joint_space_info = std::move(hand_joint_space_info);
  } else {
    DestroyActive();
    tag_ = Tag::kHandJointSpaceInfo;
    new (&data_.hand_joint_space_info) XRHandJointSpaceInfoPtr(
        std::move(hand_joint_space_info));
  }
}

void XRNativeOriginInformation::set_image_index(uint32_t image_index) {
  if (tag_ != Tag::kImageIndex) {
    DestroyActive();
    tag_ = Tag::kImageIndex;
  }
  data_.image_index = image_index;
}


XRNativeOriginInformation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kInputSourceSpaceInfo)>,
    XRInputSourceSpaceInfoPtr value)
    : input_source_space_info(std::move(value)) {}

XRNativeOriginInformation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kPlaneId)>,
    const ::device::PlaneId& value)
    : plane_id(std::move(value)) {}

XRNativeOriginInformation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kAnchorId)>,
    const ::device::AnchorId& value)
    : anchor_id(std::move(value)) {}

XRNativeOriginInformation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kReferenceSpaceType)>,
    XRReferenceSpaceType value)
    : reference_space_type(std::move(value)) {}

XRNativeOriginInformation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kHandJointSpaceInfo)>,
    XRHandJointSpaceInfoPtr value)
    : hand_joint_space_info(std::move(value)) {}

XRNativeOriginInformation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kImageIndex)>,
    uint32_t value)
    : image_index(std::move(value)) {}

void XRNativeOriginInformation::DestroyActive() {
  switch (tag_) {

    case Tag::kInputSourceSpaceInfo:
      std::destroy_at(&data_.input_source_space_info);
      break;
    case Tag::kPlaneId:
      std::destroy_at(&data_.plane_id);
      break;
    case Tag::kAnchorId:
      std::destroy_at(&data_.anchor_id);
      break;
    case Tag::kReferenceSpaceType:
      std::destroy_at(&data_.reference_space_type);
      break;
    case Tag::kHandJointSpaceInfo:
      std::destroy_at(&data_.hand_joint_space_info);
      break;
    case Tag::kImageIndex:
      std::destroy_at(&data_.image_index);
      break;
  }
}

bool XRNativeOriginInformation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
XRDepthDataPtr
XRDepthData::NewDataStillValid(
    XRDepthDataStillValidPtr value) {
  return XRDepthDataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kDataStillValid)>,
      std::move(value));
}

XRDepthDataPtr
XRDepthData::NewUpdatedDepthData(
    XRDepthDataUpdatedPtr value) {
  return XRDepthDataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kUpdatedDepthData)>,
      std::move(value));
}

XRDepthData::XRDepthData(
    std::in_place_index_t<static_cast<size_t>(Tag::kDataStillValid)>,
    XRDepthDataStillValidPtr value)
    : tag_(Tag::kDataStillValid),
      data_(std::in_place_index<static_cast<size_t>(Tag::kDataStillValid)>,
            std::move(value)) {}

XRDepthData::XRDepthData(
    std::in_place_index_t<static_cast<size_t>(Tag::kUpdatedDepthData)>,
    XRDepthDataUpdatedPtr value)
    : tag_(Tag::kUpdatedDepthData),
      data_(std::in_place_index<static_cast<size_t>(Tag::kUpdatedDepthData)>,
            std::move(value)) {}
XRDepthData::~XRDepthData() {
  DestroyActive();
}

void XRDepthData::set_data_still_valid(XRDepthDataStillValidPtr data_still_valid) {
  if (tag_ == Tag::kDataStillValid) {
    data_.data_still_valid = std::move(data_still_valid);
  } else {
    DestroyActive();
    tag_ = Tag::kDataStillValid;
    new (&data_.data_still_valid) XRDepthDataStillValidPtr(
        std::move(data_still_valid));
  }
}

void XRDepthData::set_updated_depth_data(XRDepthDataUpdatedPtr updated_depth_data) {
  if (tag_ == Tag::kUpdatedDepthData) {
    data_.updated_depth_data = std::move(updated_depth_data);
  } else {
    DestroyActive();
    tag_ = Tag::kUpdatedDepthData;
    new (&data_.updated_depth_data) XRDepthDataUpdatedPtr(
        std::move(updated_depth_data));
  }
}


XRDepthData::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kDataStillValid)>,
    XRDepthDataStillValidPtr value)
    : data_still_valid(std::move(value)) {}

XRDepthData::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kUpdatedDepthData)>,
    XRDepthDataUpdatedPtr value)
    : updated_depth_data(std::move(value)) {}

void XRDepthData::DestroyActive() {
  switch (tag_) {

    case Tag::kDataStillValid:
      std::destroy_at(&data_.data_still_valid);
      break;
    case Tag::kUpdatedDepthData:
      std::destroy_at(&data_.updated_depth_data);
      break;
  }
}

bool XRDepthData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
XRLayerSpecificDataPtr
XRLayerSpecificData::NewProjection(
    XRProjectionLayerDataPtr value) {
  return XRLayerSpecificDataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kProjection)>,
      std::move(value));
}

XRLayerSpecificDataPtr
XRLayerSpecificData::NewQuad(
    XRQuadLayerDataPtr value) {
  return XRLayerSpecificDataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kQuad)>,
      std::move(value));
}

XRLayerSpecificDataPtr
XRLayerSpecificData::NewCylinder(
    XRCylinderLayerDataPtr value) {
  return XRLayerSpecificDataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kCylinder)>,
      std::move(value));
}

XRLayerSpecificDataPtr
XRLayerSpecificData::NewEquirect(
    XREquirectLayerDataPtr value) {
  return XRLayerSpecificDataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kEquirect)>,
      std::move(value));
}

XRLayerSpecificData::XRLayerSpecificData(
    std::in_place_index_t<static_cast<size_t>(Tag::kProjection)>,
    XRProjectionLayerDataPtr value)
    : tag_(Tag::kProjection),
      data_(std::in_place_index<static_cast<size_t>(Tag::kProjection)>,
            std::move(value)) {}

XRLayerSpecificData::XRLayerSpecificData(
    std::in_place_index_t<static_cast<size_t>(Tag::kQuad)>,
    XRQuadLayerDataPtr value)
    : tag_(Tag::kQuad),
      data_(std::in_place_index<static_cast<size_t>(Tag::kQuad)>,
            std::move(value)) {}

XRLayerSpecificData::XRLayerSpecificData(
    std::in_place_index_t<static_cast<size_t>(Tag::kCylinder)>,
    XRCylinderLayerDataPtr value)
    : tag_(Tag::kCylinder),
      data_(std::in_place_index<static_cast<size_t>(Tag::kCylinder)>,
            std::move(value)) {}

XRLayerSpecificData::XRLayerSpecificData(
    std::in_place_index_t<static_cast<size_t>(Tag::kEquirect)>,
    XREquirectLayerDataPtr value)
    : tag_(Tag::kEquirect),
      data_(std::in_place_index<static_cast<size_t>(Tag::kEquirect)>,
            std::move(value)) {}
XRLayerSpecificData::~XRLayerSpecificData() {
  DestroyActive();
}

void XRLayerSpecificData::set_projection(XRProjectionLayerDataPtr projection) {
  if (tag_ == Tag::kProjection) {
    data_.projection = std::move(projection);
  } else {
    DestroyActive();
    tag_ = Tag::kProjection;
    new (&data_.projection) XRProjectionLayerDataPtr(
        std::move(projection));
  }
}

void XRLayerSpecificData::set_quad(XRQuadLayerDataPtr quad) {
  if (tag_ == Tag::kQuad) {
    data_.quad = std::move(quad);
  } else {
    DestroyActive();
    tag_ = Tag::kQuad;
    new (&data_.quad) XRQuadLayerDataPtr(
        std::move(quad));
  }
}

void XRLayerSpecificData::set_cylinder(XRCylinderLayerDataPtr cylinder) {
  if (tag_ == Tag::kCylinder) {
    data_.cylinder = std::move(cylinder);
  } else {
    DestroyActive();
    tag_ = Tag::kCylinder;
    new (&data_.cylinder) XRCylinderLayerDataPtr(
        std::move(cylinder));
  }
}

void XRLayerSpecificData::set_equirect(XREquirectLayerDataPtr equirect) {
  if (tag_ == Tag::kEquirect) {
    data_.equirect = std::move(equirect);
  } else {
    DestroyActive();
    tag_ = Tag::kEquirect;
    new (&data_.equirect) XREquirectLayerDataPtr(
        std::move(equirect));
  }
}


XRLayerSpecificData::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kProjection)>,
    XRProjectionLayerDataPtr value)
    : projection(std::move(value)) {}

XRLayerSpecificData::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kQuad)>,
    XRQuadLayerDataPtr value)
    : quad(std::move(value)) {}

XRLayerSpecificData::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kCylinder)>,
    XRCylinderLayerDataPtr value)
    : cylinder(std::move(value)) {}

XRLayerSpecificData::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kEquirect)>,
    XREquirectLayerDataPtr value)
    : equirect(std::move(value)) {}

void XRLayerSpecificData::DestroyActive() {
  switch (tag_) {

    case Tag::kProjection:
      std::destroy_at(&data_.projection);
      break;
    case Tag::kQuad:
      std::destroy_at(&data_.quad);
      break;
    case Tag::kCylinder:
      std::destroy_at(&data_.cylinder);
      break;
    case Tag::kEquirect:
      std::destroy_at(&data_.equirect);
      break;
  }
}

bool XRLayerSpecificData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
RequestSessionResultPtr
RequestSessionResult::NewSuccess(
    RequestSessionSuccessPtr value) {
  return RequestSessionResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

RequestSessionResultPtr
RequestSessionResult::NewFailureReason(
    ::device::mojom::blink::RequestSessionError value) {
  return RequestSessionResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFailureReason)>,
      std::move(value));
}

RequestSessionResult::RequestSessionResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    RequestSessionSuccessPtr value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

RequestSessionResult::RequestSessionResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailureReason)>,
    ::device::mojom::blink::RequestSessionError value)
    : tag_(Tag::kFailureReason),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFailureReason)>,
            std::move(value)) {}
RequestSessionResult::~RequestSessionResult() {
  DestroyActive();
}

void RequestSessionResult::set_success(RequestSessionSuccessPtr success) {
  if (tag_ == Tag::kSuccess) {
    data_.success = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    new (&data_.success) RequestSessionSuccessPtr(
        std::move(success));
  }
}

void RequestSessionResult::set_failure_reason(::device::mojom::blink::RequestSessionError failure_reason) {
  if (tag_ != Tag::kFailureReason) {
    DestroyActive();
    tag_ = Tag::kFailureReason;
  }
  data_.failure_reason = failure_reason;
}


RequestSessionResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    RequestSessionSuccessPtr value)
    : success(std::move(value)) {}

RequestSessionResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailureReason)>,
    ::device::mojom::blink::RequestSessionError value)
    : failure_reason(std::move(value)) {}

void RequestSessionResult::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kFailureReason:
      std::destroy_at(&data_.failure_reason);
      break;
  }
}

bool RequestSessionResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

VRService::IPCStableHashFunction VRService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::VRService>(message.name())) {
    case messages::VRService::kSetClient: {
      return &VRService::SetClient_Sym::IPCStableHash;
    }
    case messages::VRService::kRequestSession: {
      return &VRService::RequestSession_Sym::IPCStableHash;
    }
    case messages::VRService::kSupportsSession: {
      return &VRService::SupportsSession_Sym::IPCStableHash;
    }
    case messages::VRService::kExitPresent: {
      return &VRService::ExitPresent_Sym::IPCStableHash;
    }
    case messages::VRService::kSetFramesThrottled: {
      return &VRService::SetFramesThrottled_Sym::IPCStableHash;
    }
    case messages::VRService::kMakeXrCompatible: {
      return &VRService::MakeXrCompatible_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* VRService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::VRService>(message.name())) {
      case messages::VRService::kSetClient:
            return "Receive device::mojom::VRService::SetClient";
      case messages::VRService::kRequestSession:
            return "Receive device::mojom::VRService::RequestSession";
      case messages::VRService::kSupportsSession:
            return "Receive device::mojom::VRService::SupportsSession";
      case messages::VRService::kExitPresent:
            return "Receive device::mojom::VRService::ExitPresent";
      case messages::VRService::kSetFramesThrottled:
            return "Receive device::mojom::VRService::SetFramesThrottled";
      case messages::VRService::kMakeXrCompatible:
            return "Receive device::mojom::VRService::MakeXrCompatible";
    }
  } else {
    switch (static_cast<messages::VRService>(message.name())) {
      case messages::VRService::kSetClient:
            return "Receive reply device::mojom::VRService::SetClient";
      case messages::VRService::kRequestSession:
            return "Receive reply device::mojom::VRService::RequestSession";
      case messages::VRService::kSupportsSession:
            return "Receive reply device::mojom::VRService::SupportsSession";
      case messages::VRService::kExitPresent:
            return "Receive reply device::mojom::VRService::ExitPresent";
      case messages::VRService::kSetFramesThrottled:
            return "Receive reply device::mojom::VRService::SetFramesThrottled";
      case messages::VRService::kMakeXrCompatible:
            return "Receive reply device::mojom::VRService::MakeXrCompatible";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t VRService::SetClient_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5536073d;  // IPCStableHash for device::mojom::VRService::SetClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VRService::RequestSession_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0873c789;  // IPCStableHash for device::mojom::VRService::RequestSession
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VRService::SupportsSession_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3f64e0cf;  // IPCStableHash for device::mojom::VRService::SupportsSession
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VRService::ExitPresent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x021b250a;  // IPCStableHash for device::mojom::VRService::ExitPresent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VRService::SetFramesThrottled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe3dec7e5;  // IPCStableHash for device::mojom::VRService::SetFramesThrottled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VRService::MakeXrCompatible_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x676eb271;  // IPCStableHash for device::mojom::VRService::MakeXrCompatible
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool VRService::MakeXrCompatible(XrCompatibleResult* out_xr_compatible_result) {
  NOTREACHED();
}

class VRService_RequestSession_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VRService_RequestSession_ForwardToCallback(
      VRService::RequestSessionCallback callback
      ) : callback_(std::move(callback)) {
  }

  VRService_RequestSession_ForwardToCallback(const VRService_RequestSession_ForwardToCallback&) = delete;
  VRService_RequestSession_ForwardToCallback& operator=(const VRService_RequestSession_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  VRService::RequestSessionCallback callback_;
};

class VRService_SupportsSession_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VRService_SupportsSession_ForwardToCallback(
      VRService::SupportsSessionCallback callback
      ) : callback_(std::move(callback)) {
  }

  VRService_SupportsSession_ForwardToCallback(const VRService_SupportsSession_ForwardToCallback&) = delete;
  VRService_SupportsSession_ForwardToCallback& operator=(const VRService_SupportsSession_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  VRService::SupportsSessionCallback callback_;
};

class VRService_ExitPresent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VRService_ExitPresent_ForwardToCallback(
      VRService::ExitPresentCallback callback
      ) : callback_(std::move(callback)) {
  }

  VRService_ExitPresent_ForwardToCallback(const VRService_ExitPresent_ForwardToCallback&) = delete;
  VRService_ExitPresent_ForwardToCallback& operator=(const VRService_ExitPresent_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  VRService::ExitPresentCallback callback_;
};
class VRService_MakeXrCompatible_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  VRService_MakeXrCompatible_HandleSyncResponse(
      bool* result, XrCompatibleResult* out_xr_compatible_result)
      : result_(result), out_xr_compatible_result_(out_xr_compatible_result) {
    DCHECK(!*result_);
  }

  VRService_MakeXrCompatible_HandleSyncResponse(const VRService_MakeXrCompatible_HandleSyncResponse&) = delete;
  VRService_MakeXrCompatible_HandleSyncResponse& operator=(const VRService_MakeXrCompatible_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  XrCompatibleResult* out_xr_compatible_result_;};

class VRService_MakeXrCompatible_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VRService_MakeXrCompatible_ForwardToCallback(
      VRService::MakeXrCompatibleCallback callback
      ) : callback_(std::move(callback)) {
  }

  VRService_MakeXrCompatible_ForwardToCallback(const VRService_MakeXrCompatible_ForwardToCallback&) = delete;
  VRService_MakeXrCompatible_ForwardToCallback& operator=(const VRService_MakeXrCompatible_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  VRService::MakeXrCompatibleCallback callback_;
};

VRServiceProxy::VRServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VRServiceProxy::SetClient(
    ::mojo::PendingRemote<VRServiceClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::VRService::SetClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<VRServiceClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VRService::kSetClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRService_SetClient_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::VRServiceClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in VRService.SetClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRService::Name_);
  message.set_method_name("SetClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VRServiceProxy::RequestSession(
    ::device::mojom::blink::XRSessionOptionsPtr in_options, RequestSessionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::VRService::RequestSession", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ::device::mojom::blink::XRSessionOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VRService::kRequestSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRService_RequestSession_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::XRSessionOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in VRService.RequestSession request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRService::Name_);
  message.set_method_name("RequestSession");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VRService_RequestSession_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void VRServiceProxy::SupportsSession(
    ::device::mojom::blink::XRSessionOptionsPtr in_options, SupportsSessionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::VRService::SupportsSession", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ::device::mojom::blink::XRSessionOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VRService::kSupportsSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRService_SupportsSession_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::XRSessionOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in VRService.SupportsSession request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRService::Name_);
  message.set_method_name("SupportsSession");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VRService_SupportsSession_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void VRServiceProxy::ExitPresent(
    ExitPresentCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::VRService::ExitPresent");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VRService::kExitPresent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRService_ExitPresent_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRService::Name_);
  message.set_method_name("ExitPresent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VRService_ExitPresent_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void VRServiceProxy::SetFramesThrottled(
    bool in_throttled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::VRService::SetFramesThrottled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("throttled"), in_throttled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VRService::kSetFramesThrottled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRService_SetFramesThrottled_Params_Data> params(
          message);
  params.Allocate();

  params->throttled = in_throttled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRService::Name_);
  message.set_method_name("SetFramesThrottled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool VRServiceProxy::MakeXrCompatible(
    XrCompatibleResult* out_param_xr_compatible_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call device::mojom::VRService::MakeXrCompatible (sync)");
#else
  TRACE_EVENT0("mojom", "VRService::MakeXrCompatible");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VRService::kMakeXrCompatible), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRService_MakeXrCompatible_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRService::Name_);
  message.set_method_name("MakeXrCompatible");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VRService_MakeXrCompatible_HandleSyncResponse(
          &result, out_param_xr_compatible_result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "VRService::MakeXrCompatible", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("xr_compatible_result"), out_param_xr_compatible_result,
                        "<value of type XrCompatibleResult>");
   });
#endif
  return result;
}

void VRServiceProxy::MakeXrCompatible(
    MakeXrCompatibleCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::VRService::MakeXrCompatible");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VRService::kMakeXrCompatible), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRService_MakeXrCompatible_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRService::Name_);
  message.set_method_name("MakeXrCompatible");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VRService_MakeXrCompatible_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class VRService_RequestSession_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static VRService::RequestSessionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<VRService_RequestSession_ProxyToResponder> proxy(
        new VRService_RequestSession_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&VRService_RequestSession_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VRService_RequestSession_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  VRService_RequestSession_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "VRService::RequestSessionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      RequestSessionResultPtr in_result);
};

bool VRService_RequestSession_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::VRService_RequestSession_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VRService_RequestSession_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for VRService.1
  bool success = true;
  RequestSessionResultPtr p_result{};
  VRService_RequestSession_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VRService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void VRService_RequestSession_ProxyToResponder::Run(
    RequestSessionResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::VRService::RequestSession", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type RequestSessionResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VRService::kRequestSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRService_RequestSession_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::device::mojom::RequestSessionResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRService::Name_);
  message.set_method_name("RequestSession");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VRService_SupportsSession_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static VRService::SupportsSessionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<VRService_SupportsSession_ProxyToResponder> proxy(
        new VRService_SupportsSession_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&VRService_SupportsSession_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VRService_SupportsSession_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  VRService_SupportsSession_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "VRService::SupportsSessionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_supports_session);
};

bool VRService_SupportsSession_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::VRService_SupportsSession_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VRService_SupportsSession_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for VRService.2
  bool success = true;
  bool p_supports_session{};
  VRService_SupportsSession_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_supports_session = input_data_view.supports_session();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VRService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_supports_session));
  }
  return true;
}

void VRService_SupportsSession_ProxyToResponder::Run(
    bool in_supports_session) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::VRService::SupportsSession", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("supports_session"), in_supports_session,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VRService::kSupportsSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRService_SupportsSession_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->supports_session = in_supports_session;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRService::Name_);
  message.set_method_name("SupportsSession");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VRService_ExitPresent_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static VRService::ExitPresentCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<VRService_ExitPresent_ProxyToResponder> proxy(
        new VRService_ExitPresent_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&VRService_ExitPresent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VRService_ExitPresent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  VRService_ExitPresent_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "VRService::ExitPresentCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool VRService_ExitPresent_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::VRService_ExitPresent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VRService_ExitPresent_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for VRService.3
  bool success = true;
  VRService_ExitPresent_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VRService::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void VRService_ExitPresent_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply device::mojom::VRService::ExitPresent");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VRService::kExitPresent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRService_ExitPresent_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRService::Name_);
  message.set_method_name("ExitPresent");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VRService_MakeXrCompatible_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static VRService::MakeXrCompatibleCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<VRService_MakeXrCompatible_ProxyToResponder> proxy(
        new VRService_MakeXrCompatible_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&VRService_MakeXrCompatible_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VRService_MakeXrCompatible_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  VRService_MakeXrCompatible_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "VRService::MakeXrCompatibleCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      XrCompatibleResult in_xr_compatible_result);
};

bool VRService_MakeXrCompatible_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::VRService_MakeXrCompatible_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VRService_MakeXrCompatible_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for VRService.5
  bool success = true;
  XrCompatibleResult p_xr_compatible_result{};
  VRService_MakeXrCompatible_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadXrCompatibleResult(&p_xr_compatible_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VRService::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_xr_compatible_result));
  }
  return true;
}

void VRService_MakeXrCompatible_ProxyToResponder::Run(
    XrCompatibleResult in_xr_compatible_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::VRService::MakeXrCompatible", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("xr_compatible_result"), in_xr_compatible_result,
                        "<value of type XrCompatibleResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VRService::kMakeXrCompatible), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRService_MakeXrCompatible_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::device::mojom::XrCompatibleResult>(
    in_xr_compatible_result,
    &params->xr_compatible_result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRService::Name_);
  message.set_method_name("MakeXrCompatible");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool VRService_MakeXrCompatible_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::VRService_MakeXrCompatible_ResponseParams_Data* params =
      reinterpret_cast<internal::VRService_MakeXrCompatible_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for VRService.5
  bool success = true;
  XrCompatibleResult p_xr_compatible_result{};
  VRService_MakeXrCompatible_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadXrCompatibleResult(&p_xr_compatible_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VRService::Name_, 5, true);
    return false;
  }
  *out_xr_compatible_result_ = std::move(p_xr_compatible_result);
  *result_ = true;
  return true;
}

// static
bool VRServiceStubDispatch::Accept(
    VRService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::VRService>(message->header()->name)) {
    case messages::VRService::kSetClient: {
      DCHECK(message->is_serialized());
      internal::VRService_SetClient_Params_Data* params =
          reinterpret_cast<internal::VRService_SetClient_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VRService.0
      bool success = true;
      ::mojo::PendingRemote<VRServiceClient> p_client{};
      VRService_SetClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VRService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetClient(        
        std::move(p_client));
      return true;
    }
    case messages::VRService::kRequestSession: {
      break;
    }
    case messages::VRService::kSupportsSession: {
      break;
    }
    case messages::VRService::kExitPresent: {
      break;
    }
    case messages::VRService::kSetFramesThrottled: {
      DCHECK(message->is_serialized());
      internal::VRService_SetFramesThrottled_Params_Data* params =
          reinterpret_cast<internal::VRService_SetFramesThrottled_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VRService.4
      bool success = true;
      bool p_throttled{};
      VRService_SetFramesThrottled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_throttled = input_data_view.throttled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VRService::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFramesThrottled(        
        std::move(p_throttled));
      return true;
    }
    case messages::VRService::kMakeXrCompatible: {
      break;
    }
  }
  return false;
}

// static
bool VRServiceStubDispatch::AcceptWithResponder(
    VRService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::VRService>(message->header()->name)) {
    case messages::VRService::kSetClient: {
      break;
    }
    case messages::VRService::kRequestSession: {
      internal::VRService_RequestSession_Params_Data* params =
          reinterpret_cast<
              internal::VRService_RequestSession_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for VRService.1
      bool success = true;
      ::device::mojom::blink::XRSessionOptionsPtr p_options{};
      VRService_RequestSession_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VRService::Name_, 1, false);
        return false;
      }
      auto callback =
          VRService_RequestSession_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestSession(        
        std::move(p_options), std::move(callback));
      return true;
    }
    case messages::VRService::kSupportsSession: {
      internal::VRService_SupportsSession_Params_Data* params =
          reinterpret_cast<
              internal::VRService_SupportsSession_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for VRService.2
      bool success = true;
      ::device::mojom::blink::XRSessionOptionsPtr p_options{};
      VRService_SupportsSession_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VRService::Name_, 2, false);
        return false;
      }
      auto callback =
          VRService_SupportsSession_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SupportsSession(        
        std::move(p_options), std::move(callback));
      return true;
    }
    case messages::VRService::kExitPresent: {
      internal::VRService_ExitPresent_Params_Data* params =
          reinterpret_cast<
              internal::VRService_ExitPresent_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for VRService.3
      bool success = true;
      VRService_ExitPresent_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VRService::Name_, 3, false);
        return false;
      }
      auto callback =
          VRService_ExitPresent_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExitPresent(std::move(callback));
      return true;
    }
    case messages::VRService::kSetFramesThrottled: {
      break;
    }
    case messages::VRService::kMakeXrCompatible: {
      internal::VRService_MakeXrCompatible_Params_Data* params =
          reinterpret_cast<
              internal::VRService_MakeXrCompatible_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for VRService.5
      bool success = true;
      VRService_MakeXrCompatible_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VRService::Name_, 5, false);
        return false;
      }
      auto callback =
          VRService_MakeXrCompatible_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MakeXrCompatible(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kVRServiceValidationInfo[] = {
    { &internal::VRService_SetClient_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VRService_RequestSession_Params_Data::Validate,
     &internal::VRService_RequestSession_ResponseParams_Data::Validate},
    { &internal::VRService_SupportsSession_Params_Data::Validate,
     &internal::VRService_SupportsSession_ResponseParams_Data::Validate},
    { &internal::VRService_ExitPresent_Params_Data::Validate,
     &internal::VRService_ExitPresent_ResponseParams_Data::Validate},
    { &internal::VRService_SetFramesThrottled_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VRService_MakeXrCompatible_Params_Data::Validate,
     &internal::VRService_MakeXrCompatible_ResponseParams_Data::Validate},
};

bool VRServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::blink::VRService::Name_,
    kVRServiceValidationInfo);
}

bool VRServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::device::mojom::blink::VRService::Name_,
    kVRServiceValidationInfo);
}
// The declaration includes the definition on other builds.

XRSessionMetricsRecorder::IPCStableHashFunction XRSessionMetricsRecorder::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::XRSessionMetricsRecorder>(message.name())) {
    case messages::XRSessionMetricsRecorder::kReportFeatureUsed: {
      return &XRSessionMetricsRecorder::ReportFeatureUsed_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* XRSessionMetricsRecorder::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::XRSessionMetricsRecorder>(message.name())) {
      case messages::XRSessionMetricsRecorder::kReportFeatureUsed:
            return "Receive device::mojom::XRSessionMetricsRecorder::ReportFeatureUsed";
    }
  } else {
    switch (static_cast<messages::XRSessionMetricsRecorder>(message.name())) {
      case messages::XRSessionMetricsRecorder::kReportFeatureUsed:
            return "Receive reply device::mojom::XRSessionMetricsRecorder::ReportFeatureUsed";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t XRSessionMetricsRecorder::ReportFeatureUsed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa8785bf1;  // IPCStableHash for device::mojom::XRSessionMetricsRecorder::ReportFeatureUsed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

XRSessionMetricsRecorderProxy::XRSessionMetricsRecorderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void XRSessionMetricsRecorderProxy::ReportFeatureUsed(
    ::device::mojom::blink::XRSessionFeature in_feature) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XRSessionMetricsRecorder::ReportFeatureUsed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("feature"), in_feature,
                        "<value of type ::device::mojom::blink::XRSessionFeature>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRSessionMetricsRecorder::kReportFeatureUsed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::device::mojom::XRSessionFeature>(
    in_feature,
    &params->feature);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRSessionMetricsRecorder::Name_);
  message.set_method_name("ReportFeatureUsed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool XRSessionMetricsRecorderStubDispatch::Accept(
    XRSessionMetricsRecorder* impl,
    mojo::Message* message) {
  switch (static_cast<messages::XRSessionMetricsRecorder>(message->header()->name)) {
    case messages::XRSessionMetricsRecorder::kReportFeatureUsed: {
      DCHECK(message->is_serialized());
      internal::XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data* params =
          reinterpret_cast<internal::XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for XRSessionMetricsRecorder.0
      bool success = true;
      ::device::mojom::blink::XRSessionFeature p_feature{};
      XRSessionMetricsRecorder_ReportFeatureUsed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeature(&p_feature))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRSessionMetricsRecorder::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportFeatureUsed(        
        std::move(p_feature));
      return true;
    }
  }
  return false;
}

// static
bool XRSessionMetricsRecorderStubDispatch::AcceptWithResponder(
    XRSessionMetricsRecorder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::XRSessionMetricsRecorder>(message->header()->name)) {
    case messages::XRSessionMetricsRecorder::kReportFeatureUsed: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kXRSessionMetricsRecorderValidationInfo[] = {
    { &internal::XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data::Validate,
     nullptr /* no response */},
};

bool XRSessionMetricsRecorderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::blink::XRSessionMetricsRecorder::Name_,
    kXRSessionMetricsRecorderValidationInfo);
}

// The declaration includes the definition on other builds.

VRServiceClient::IPCStableHashFunction VRServiceClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::VRServiceClient>(message.name())) {
    case messages::VRServiceClient::kOnDeviceChanged: {
      return &VRServiceClient::OnDeviceChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* VRServiceClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::VRServiceClient>(message.name())) {
      case messages::VRServiceClient::kOnDeviceChanged:
            return "Receive device::mojom::VRServiceClient::OnDeviceChanged";
    }
  } else {
    switch (static_cast<messages::VRServiceClient>(message.name())) {
      case messages::VRServiceClient::kOnDeviceChanged:
            return "Receive reply device::mojom::VRServiceClient::OnDeviceChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t VRServiceClient::OnDeviceChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8159c0f2;  // IPCStableHash for device::mojom::VRServiceClient::OnDeviceChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

VRServiceClientProxy::VRServiceClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VRServiceClientProxy::OnDeviceChanged(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::VRServiceClient::OnDeviceChanged");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VRServiceClient::kOnDeviceChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRServiceClient_OnDeviceChanged_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRServiceClient::Name_);
  message.set_method_name("OnDeviceChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool VRServiceClientStubDispatch::Accept(
    VRServiceClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::VRServiceClient>(message->header()->name)) {
    case messages::VRServiceClient::kOnDeviceChanged: {
      DCHECK(message->is_serialized());
      internal::VRServiceClient_OnDeviceChanged_Params_Data* params =
          reinterpret_cast<internal::VRServiceClient_OnDeviceChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VRServiceClient.0
      bool success = true;
      VRServiceClient_OnDeviceChanged_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VRServiceClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDeviceChanged(        );
      return true;
    }
  }
  return false;
}

// static
bool VRServiceClientStubDispatch::AcceptWithResponder(
    VRServiceClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::VRServiceClient>(message->header()->name)) {
    case messages::VRServiceClient::kOnDeviceChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kVRServiceClientValidationInfo[] = {
    { &internal::VRServiceClient_OnDeviceChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool VRServiceClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::blink::VRServiceClient::Name_,
    kVRServiceClientValidationInfo);
}

// The declaration includes the definition on other builds.

XREnvironmentIntegrationProvider::IPCStableHashFunction XREnvironmentIntegrationProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::XREnvironmentIntegrationProvider>(message.name())) {
    case messages::XREnvironmentIntegrationProvider::kSubscribeToHitTest: {
      return &XREnvironmentIntegrationProvider::SubscribeToHitTest_Sym::IPCStableHash;
    }
    case messages::XREnvironmentIntegrationProvider::kSubscribeToHitTestForTransientInput: {
      return &XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInput_Sym::IPCStableHash;
    }
    case messages::XREnvironmentIntegrationProvider::kUnsubscribeFromHitTest: {
      return &XREnvironmentIntegrationProvider::UnsubscribeFromHitTest_Sym::IPCStableHash;
    }
    case messages::XREnvironmentIntegrationProvider::kCreateAnchor: {
      return &XREnvironmentIntegrationProvider::CreateAnchor_Sym::IPCStableHash;
    }
    case messages::XREnvironmentIntegrationProvider::kDetachAnchor: {
      return &XREnvironmentIntegrationProvider::DetachAnchor_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* XREnvironmentIntegrationProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::XREnvironmentIntegrationProvider>(message.name())) {
      case messages::XREnvironmentIntegrationProvider::kSubscribeToHitTest:
            return "Receive device::mojom::XREnvironmentIntegrationProvider::SubscribeToHitTest";
      case messages::XREnvironmentIntegrationProvider::kSubscribeToHitTestForTransientInput:
            return "Receive device::mojom::XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInput";
      case messages::XREnvironmentIntegrationProvider::kUnsubscribeFromHitTest:
            return "Receive device::mojom::XREnvironmentIntegrationProvider::UnsubscribeFromHitTest";
      case messages::XREnvironmentIntegrationProvider::kCreateAnchor:
            return "Receive device::mojom::XREnvironmentIntegrationProvider::CreateAnchor";
      case messages::XREnvironmentIntegrationProvider::kDetachAnchor:
            return "Receive device::mojom::XREnvironmentIntegrationProvider::DetachAnchor";
    }
  } else {
    switch (static_cast<messages::XREnvironmentIntegrationProvider>(message.name())) {
      case messages::XREnvironmentIntegrationProvider::kSubscribeToHitTest:
            return "Receive reply device::mojom::XREnvironmentIntegrationProvider::SubscribeToHitTest";
      case messages::XREnvironmentIntegrationProvider::kSubscribeToHitTestForTransientInput:
            return "Receive reply device::mojom::XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInput";
      case messages::XREnvironmentIntegrationProvider::kUnsubscribeFromHitTest:
            return "Receive reply device::mojom::XREnvironmentIntegrationProvider::UnsubscribeFromHitTest";
      case messages::XREnvironmentIntegrationProvider::kCreateAnchor:
            return "Receive reply device::mojom::XREnvironmentIntegrationProvider::CreateAnchor";
      case messages::XREnvironmentIntegrationProvider::kDetachAnchor:
            return "Receive reply device::mojom::XREnvironmentIntegrationProvider::DetachAnchor";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t XREnvironmentIntegrationProvider::SubscribeToHitTest_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2282984d;  // IPCStableHash for device::mojom::XREnvironmentIntegrationProvider::SubscribeToHitTest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInput_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfa207f61;  // IPCStableHash for device::mojom::XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInput
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XREnvironmentIntegrationProvider::UnsubscribeFromHitTest_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8bff7c3c;  // IPCStableHash for device::mojom::XREnvironmentIntegrationProvider::UnsubscribeFromHitTest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XREnvironmentIntegrationProvider::CreateAnchor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x74721f89;  // IPCStableHash for device::mojom::XREnvironmentIntegrationProvider::CreateAnchor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XREnvironmentIntegrationProvider::DetachAnchor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x59a187bc;  // IPCStableHash for device::mojom::XREnvironmentIntegrationProvider::DetachAnchor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class XREnvironmentIntegrationProvider_SubscribeToHitTest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XREnvironmentIntegrationProvider_SubscribeToHitTest_ForwardToCallback(
      XREnvironmentIntegrationProvider::SubscribeToHitTestCallback callback
      ) : callback_(std::move(callback)) {
  }

  XREnvironmentIntegrationProvider_SubscribeToHitTest_ForwardToCallback(const XREnvironmentIntegrationProvider_SubscribeToHitTest_ForwardToCallback&) = delete;
  XREnvironmentIntegrationProvider_SubscribeToHitTest_ForwardToCallback& operator=(const XREnvironmentIntegrationProvider_SubscribeToHitTest_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  XREnvironmentIntegrationProvider::SubscribeToHitTestCallback callback_;
};

class XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ForwardToCallback(
      XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInputCallback callback
      ) : callback_(std::move(callback)) {
  }

  XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ForwardToCallback(const XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ForwardToCallback&) = delete;
  XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ForwardToCallback& operator=(const XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInputCallback callback_;
};

class XREnvironmentIntegrationProvider_CreateAnchor_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XREnvironmentIntegrationProvider_CreateAnchor_ForwardToCallback(
      XREnvironmentIntegrationProvider::CreateAnchorCallback callback
      ) : callback_(std::move(callback)) {
  }

  XREnvironmentIntegrationProvider_CreateAnchor_ForwardToCallback(const XREnvironmentIntegrationProvider_CreateAnchor_ForwardToCallback&) = delete;
  XREnvironmentIntegrationProvider_CreateAnchor_ForwardToCallback& operator=(const XREnvironmentIntegrationProvider_CreateAnchor_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  XREnvironmentIntegrationProvider::CreateAnchorCallback callback_;
};

XREnvironmentIntegrationProviderProxy::XREnvironmentIntegrationProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void XREnvironmentIntegrationProviderProxy::SubscribeToHitTest(
    XRNativeOriginInformationPtr in_native_origin_information, const ::blink::Vector<EntityTypeForHitTest>& in_entity_types, XRRayPtr in_ray, SubscribeToHitTestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XREnvironmentIntegrationProvider::SubscribeToHitTest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("native_origin_information"), in_native_origin_information,
                        "<value of type XRNativeOriginInformationPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entity_types"), in_entity_types,
                        "<value of type const ::blink::Vector<EntityTypeForHitTest>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ray"), in_ray,
                        "<value of type XRRayPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XREnvironmentIntegrationProvider::kSubscribeToHitTest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->native_origin_information)>
      native_origin_information_fragment(params.message());
  native_origin_information_fragment.Claim(&params->native_origin_information);
  
  mojo::internal::Serialize<::device::mojom::XRNativeOriginInformationDataView>(
    in_native_origin_information,
    native_origin_information_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->native_origin_information.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null native_origin_information in XREnvironmentIntegrationProvider.SubscribeToHitTest request");
  mojo::internal::MessageFragment<
      typename decltype(params->entity_types)::BaseType>
      entity_types_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& entity_types_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::EntityTypeForHitTest_Data::Validate>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::EntityTypeForHitTest>>(
    in_entity_types,
    entity_types_fragment,
    &entity_types_validate_params);

  params->entity_types.Set(
      entity_types_fragment.is_null() ? nullptr : entity_types_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->entity_types.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null entity_types in XREnvironmentIntegrationProvider.SubscribeToHitTest request");
  mojo::internal::MessageFragment<
      typename decltype(params->ray)::BaseType> ray_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::XRRayDataView>(
    in_ray,
    ray_fragment);

  params->ray.Set(
      ray_fragment.is_null() ? nullptr : ray_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ray.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ray in XREnvironmentIntegrationProvider.SubscribeToHitTest request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XREnvironmentIntegrationProvider::Name_);
  message.set_method_name("SubscribeToHitTest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XREnvironmentIntegrationProvider_SubscribeToHitTest_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void XREnvironmentIntegrationProviderProxy::SubscribeToHitTestForTransientInput(
    const ::blink::String& in_profile_name, const ::blink::Vector<EntityTypeForHitTest>& in_entity_types, XRRayPtr in_ray, SubscribeToHitTestForTransientInputCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInput", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("profile_name"), in_profile_name,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entity_types"), in_entity_types,
                        "<value of type const ::blink::Vector<EntityTypeForHitTest>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ray"), in_ray,
                        "<value of type XRRayPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XREnvironmentIntegrationProvider::kSubscribeToHitTestForTransientInput), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->profile_name)::BaseType> profile_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_profile_name,
    profile_name_fragment);

  params->profile_name.Set(
      profile_name_fragment.is_null() ? nullptr : profile_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->profile_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null profile_name in XREnvironmentIntegrationProvider.SubscribeToHitTestForTransientInput request");
  mojo::internal::MessageFragment<
      typename decltype(params->entity_types)::BaseType>
      entity_types_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& entity_types_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::EntityTypeForHitTest_Data::Validate>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::EntityTypeForHitTest>>(
    in_entity_types,
    entity_types_fragment,
    &entity_types_validate_params);

  params->entity_types.Set(
      entity_types_fragment.is_null() ? nullptr : entity_types_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->entity_types.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null entity_types in XREnvironmentIntegrationProvider.SubscribeToHitTestForTransientInput request");
  mojo::internal::MessageFragment<
      typename decltype(params->ray)::BaseType> ray_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::XRRayDataView>(
    in_ray,
    ray_fragment);

  params->ray.Set(
      ray_fragment.is_null() ? nullptr : ray_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ray.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ray in XREnvironmentIntegrationProvider.SubscribeToHitTestForTransientInput request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XREnvironmentIntegrationProvider::Name_);
  message.set_method_name("SubscribeToHitTestForTransientInput");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void XREnvironmentIntegrationProviderProxy::UnsubscribeFromHitTest(
    const ::device::HitTestSubscriptionId& in_subscription_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XREnvironmentIntegrationProvider::UnsubscribeFromHitTest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subscription_id"), in_subscription_id,
                        "<value of type const ::device::HitTestSubscriptionId&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XREnvironmentIntegrationProvider::kUnsubscribeFromHitTest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->subscription_id)::BaseType> subscription_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::HitTestSubscriptionIdDataView>(
    in_subscription_id,
    subscription_id_fragment);

  params->subscription_id.Set(
      subscription_id_fragment.is_null() ? nullptr : subscription_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->subscription_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null subscription_id in XREnvironmentIntegrationProvider.UnsubscribeFromHitTest request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XREnvironmentIntegrationProvider::Name_);
  message.set_method_name("UnsubscribeFromHitTest");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void XREnvironmentIntegrationProviderProxy::CreateAnchor(
    XRNativeOriginInformationPtr in_native_origin_information, const ::device::Pose& in_native_origin_from_anchor, const std::optional<::device::PlaneId>& in_plane_id, CreateAnchorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XREnvironmentIntegrationProvider::CreateAnchor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("native_origin_information"), in_native_origin_information,
                        "<value of type XRNativeOriginInformationPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("native_origin_from_anchor"), in_native_origin_from_anchor,
                        "<value of type const ::device::Pose&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plane_id"), in_plane_id,
                        "<value of type const std::optional<::device::PlaneId>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XREnvironmentIntegrationProvider::kCreateAnchor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XREnvironmentIntegrationProvider_CreateAnchor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->native_origin_information)>
      native_origin_information_fragment(params.message());
  native_origin_information_fragment.Claim(&params->native_origin_information);
  
  mojo::internal::Serialize<::device::mojom::XRNativeOriginInformationDataView>(
    in_native_origin_information,
    native_origin_information_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->native_origin_information.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null native_origin_information in XREnvironmentIntegrationProvider.CreateAnchor request");
  mojo::internal::MessageFragment<
      typename decltype(params->native_origin_from_anchor)::BaseType> native_origin_from_anchor_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::PoseDataView>(
    in_native_origin_from_anchor,
    native_origin_from_anchor_fragment);

  params->native_origin_from_anchor.Set(
      native_origin_from_anchor_fragment.is_null() ? nullptr : native_origin_from_anchor_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->native_origin_from_anchor.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null native_origin_from_anchor in XREnvironmentIntegrationProvider.CreateAnchor request");
  mojo::internal::MessageFragment<
      typename decltype(params->plane_id)::BaseType> plane_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::PlaneIdDataView>(
    in_plane_id,
    plane_id_fragment);

  params->plane_id.Set(
      plane_id_fragment.is_null() ? nullptr : plane_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XREnvironmentIntegrationProvider::Name_);
  message.set_method_name("CreateAnchor");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XREnvironmentIntegrationProvider_CreateAnchor_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void XREnvironmentIntegrationProviderProxy::DetachAnchor(
    const ::device::AnchorId& in_anchor_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XREnvironmentIntegrationProvider::DetachAnchor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("anchor_id"), in_anchor_id,
                        "<value of type const ::device::AnchorId&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XREnvironmentIntegrationProvider::kDetachAnchor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XREnvironmentIntegrationProvider_DetachAnchor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->anchor_id)::BaseType> anchor_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::AnchorIdDataView>(
    in_anchor_id,
    anchor_id_fragment);

  params->anchor_id.Set(
      anchor_id_fragment.is_null() ? nullptr : anchor_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->anchor_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null anchor_id in XREnvironmentIntegrationProvider.DetachAnchor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XREnvironmentIntegrationProvider::Name_);
  message.set_method_name("DetachAnchor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class XREnvironmentIntegrationProvider_SubscribeToHitTest_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static XREnvironmentIntegrationProvider::SubscribeToHitTestCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<XREnvironmentIntegrationProvider_SubscribeToHitTest_ProxyToResponder> proxy(
        new XREnvironmentIntegrationProvider_SubscribeToHitTest_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&XREnvironmentIntegrationProvider_SubscribeToHitTest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XREnvironmentIntegrationProvider_SubscribeToHitTest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  XREnvironmentIntegrationProvider_SubscribeToHitTest_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "XREnvironmentIntegrationProvider::SubscribeToHitTestCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<::device::HitTestSubscriptionId>& in_subscription_id);
};

bool XREnvironmentIntegrationProvider_SubscribeToHitTest_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for XREnvironmentIntegrationProvider.0
  bool success = true;
  std::optional<::device::HitTestSubscriptionId> p_subscription_id{};
  XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSubscriptionId(&p_subscription_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XREnvironmentIntegrationProvider::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_subscription_id));
  }
  return true;
}

void XREnvironmentIntegrationProvider_SubscribeToHitTest_ProxyToResponder::Run(
    const std::optional<::device::HitTestSubscriptionId>& in_subscription_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::XREnvironmentIntegrationProvider::SubscribeToHitTest", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subscription_id"), in_subscription_id,
                        "<value of type const std::optional<::device::HitTestSubscriptionId>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XREnvironmentIntegrationProvider::kSubscribeToHitTest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->subscription_id)::BaseType> subscription_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::HitTestSubscriptionIdDataView>(
    in_subscription_id,
    subscription_id_fragment);

  params->subscription_id.Set(
      subscription_id_fragment.is_null() ? nullptr : subscription_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XREnvironmentIntegrationProvider::Name_);
  message.set_method_name("SubscribeToHitTest");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInputCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ProxyToResponder> proxy(
        new XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInputCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<::device::HitTestSubscriptionId>& in_subscription_id);
};

bool XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for XREnvironmentIntegrationProvider.1
  bool success = true;
  std::optional<::device::HitTestSubscriptionId> p_subscription_id{};
  XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSubscriptionId(&p_subscription_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XREnvironmentIntegrationProvider::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_subscription_id));
  }
  return true;
}

void XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ProxyToResponder::Run(
    const std::optional<::device::HitTestSubscriptionId>& in_subscription_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInput", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subscription_id"), in_subscription_id,
                        "<value of type const std::optional<::device::HitTestSubscriptionId>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XREnvironmentIntegrationProvider::kSubscribeToHitTestForTransientInput), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->subscription_id)::BaseType> subscription_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::HitTestSubscriptionIdDataView>(
    in_subscription_id,
    subscription_id_fragment);

  params->subscription_id.Set(
      subscription_id_fragment.is_null() ? nullptr : subscription_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XREnvironmentIntegrationProvider::Name_);
  message.set_method_name("SubscribeToHitTestForTransientInput");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class XREnvironmentIntegrationProvider_CreateAnchor_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static XREnvironmentIntegrationProvider::CreateAnchorCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<XREnvironmentIntegrationProvider_CreateAnchor_ProxyToResponder> proxy(
        new XREnvironmentIntegrationProvider_CreateAnchor_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&XREnvironmentIntegrationProvider_CreateAnchor_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XREnvironmentIntegrationProvider_CreateAnchor_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  XREnvironmentIntegrationProvider_CreateAnchor_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "XREnvironmentIntegrationProvider::CreateAnchorCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<::device::AnchorId>& in_anchor_id);
};

bool XREnvironmentIntegrationProvider_CreateAnchor_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for XREnvironmentIntegrationProvider.3
  bool success = true;
  std::optional<::device::AnchorId> p_anchor_id{};
  XREnvironmentIntegrationProvider_CreateAnchor_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadAnchorId(&p_anchor_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XREnvironmentIntegrationProvider::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_anchor_id));
  }
  return true;
}

void XREnvironmentIntegrationProvider_CreateAnchor_ProxyToResponder::Run(
    const std::optional<::device::AnchorId>& in_anchor_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::XREnvironmentIntegrationProvider::CreateAnchor", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("anchor_id"), in_anchor_id,
                        "<value of type const std::optional<::device::AnchorId>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XREnvironmentIntegrationProvider::kCreateAnchor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->anchor_id)::BaseType> anchor_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::AnchorIdDataView>(
    in_anchor_id,
    anchor_id_fragment);

  params->anchor_id.Set(
      anchor_id_fragment.is_null() ? nullptr : anchor_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XREnvironmentIntegrationProvider::Name_);
  message.set_method_name("CreateAnchor");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool XREnvironmentIntegrationProviderStubDispatch::Accept(
    XREnvironmentIntegrationProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::XREnvironmentIntegrationProvider>(message->header()->name)) {
    case messages::XREnvironmentIntegrationProvider::kSubscribeToHitTest: {
      break;
    }
    case messages::XREnvironmentIntegrationProvider::kSubscribeToHitTestForTransientInput: {
      break;
    }
    case messages::XREnvironmentIntegrationProvider::kUnsubscribeFromHitTest: {
      DCHECK(message->is_serialized());
      internal::XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data* params =
          reinterpret_cast<internal::XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data*>(
              message->mutable_payload());
      

      // Validation for XREnvironmentIntegrationProvider.2
      bool success = true;
      ::device::HitTestSubscriptionId p_subscription_id{};
      XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSubscriptionId(&p_subscription_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XREnvironmentIntegrationProvider::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UnsubscribeFromHitTest(        
        std::move(p_subscription_id));
      return true;
    }
    case messages::XREnvironmentIntegrationProvider::kCreateAnchor: {
      break;
    }
    case messages::XREnvironmentIntegrationProvider::kDetachAnchor: {
      DCHECK(message->is_serialized());
      internal::XREnvironmentIntegrationProvider_DetachAnchor_Params_Data* params =
          reinterpret_cast<internal::XREnvironmentIntegrationProvider_DetachAnchor_Params_Data*>(
              message->mutable_payload());
      

      // Validation for XREnvironmentIntegrationProvider.4
      bool success = true;
      ::device::AnchorId p_anchor_id{};
      XREnvironmentIntegrationProvider_DetachAnchor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAnchorId(&p_anchor_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XREnvironmentIntegrationProvider::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DetachAnchor(        
        std::move(p_anchor_id));
      return true;
    }
  }
  return false;
}

// static
bool XREnvironmentIntegrationProviderStubDispatch::AcceptWithResponder(
    XREnvironmentIntegrationProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::XREnvironmentIntegrationProvider>(message->header()->name)) {
    case messages::XREnvironmentIntegrationProvider::kSubscribeToHitTest: {
      internal::XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data* params =
          reinterpret_cast<
              internal::XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for XREnvironmentIntegrationProvider.0
      bool success = true;
      XRNativeOriginInformationPtr p_native_origin_information{};
      ::blink::Vector<EntityTypeForHitTest> p_entity_types{};
      XRRayPtr p_ray{};
      XREnvironmentIntegrationProvider_SubscribeToHitTest_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNativeOriginInformation(&p_native_origin_information))
        success = false;
      if (success && !input_data_view.ReadEntityTypes(&p_entity_types))
        success = false;
      if (success && !input_data_view.ReadRay(&p_ray))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XREnvironmentIntegrationProvider::Name_, 0, false);
        return false;
      }
      auto callback =
          XREnvironmentIntegrationProvider_SubscribeToHitTest_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubscribeToHitTest(        
        std::move(p_native_origin_information), 
        std::move(p_entity_types), 
        std::move(p_ray), std::move(callback));
      return true;
    }
    case messages::XREnvironmentIntegrationProvider::kSubscribeToHitTestForTransientInput: {
      internal::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data* params =
          reinterpret_cast<
              internal::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for XREnvironmentIntegrationProvider.1
      bool success = true;
      ::blink::String p_profile_name{};
      ::blink::Vector<EntityTypeForHitTest> p_entity_types{};
      XRRayPtr p_ray{};
      XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadProfileName(&p_profile_name))
        success = false;
      if (success && !input_data_view.ReadEntityTypes(&p_entity_types))
        success = false;
      if (success && !input_data_view.ReadRay(&p_ray))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XREnvironmentIntegrationProvider::Name_, 1, false);
        return false;
      }
      auto callback =
          XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubscribeToHitTestForTransientInput(        
        std::move(p_profile_name), 
        std::move(p_entity_types), 
        std::move(p_ray), std::move(callback));
      return true;
    }
    case messages::XREnvironmentIntegrationProvider::kUnsubscribeFromHitTest: {
      break;
    }
    case messages::XREnvironmentIntegrationProvider::kCreateAnchor: {
      internal::XREnvironmentIntegrationProvider_CreateAnchor_Params_Data* params =
          reinterpret_cast<
              internal::XREnvironmentIntegrationProvider_CreateAnchor_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for XREnvironmentIntegrationProvider.3
      bool success = true;
      XRNativeOriginInformationPtr p_native_origin_information{};
      ::device::Pose p_native_origin_from_anchor{};
      std::optional<::device::PlaneId> p_plane_id{};
      XREnvironmentIntegrationProvider_CreateAnchor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNativeOriginInformation(&p_native_origin_information))
        success = false;
      if (success && !input_data_view.ReadNativeOriginFromAnchor(&p_native_origin_from_anchor))
        success = false;
      if (success && !input_data_view.ReadPlaneId(&p_plane_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XREnvironmentIntegrationProvider::Name_, 3, false);
        return false;
      }
      auto callback =
          XREnvironmentIntegrationProvider_CreateAnchor_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateAnchor(        
        std::move(p_native_origin_information), 
        std::move(p_native_origin_from_anchor), 
        std::move(p_plane_id), std::move(callback));
      return true;
    }
    case messages::XREnvironmentIntegrationProvider::kDetachAnchor: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kXREnvironmentIntegrationProviderValidationInfo[] = {
    { &internal::XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data::Validate,
     &internal::XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data::Validate},
    { &internal::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data::Validate,
     &internal::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data::Validate},
    { &internal::XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::XREnvironmentIntegrationProvider_CreateAnchor_Params_Data::Validate,
     &internal::XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data::Validate},
    { &internal::XREnvironmentIntegrationProvider_DetachAnchor_Params_Data::Validate,
     nullptr /* no response */},
};

bool XREnvironmentIntegrationProviderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::blink::XREnvironmentIntegrationProvider::Name_,
    kXREnvironmentIntegrationProviderValidationInfo);
}

bool XREnvironmentIntegrationProviderResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::device::mojom::blink::XREnvironmentIntegrationProvider::Name_,
    kXREnvironmentIntegrationProviderValidationInfo);
}
// The declaration includes the definition on other builds.

XRFrameDataProvider::IPCStableHashFunction XRFrameDataProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::XRFrameDataProvider>(message.name())) {
    case messages::XRFrameDataProvider::kGetFrameData: {
      return &XRFrameDataProvider::GetFrameData_Sym::IPCStableHash;
    }
    case messages::XRFrameDataProvider::kGetEnvironmentIntegrationProvider: {
      return &XRFrameDataProvider::GetEnvironmentIntegrationProvider_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* XRFrameDataProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::XRFrameDataProvider>(message.name())) {
      case messages::XRFrameDataProvider::kGetFrameData:
            return "Receive device::mojom::XRFrameDataProvider::GetFrameData";
      case messages::XRFrameDataProvider::kGetEnvironmentIntegrationProvider:
            return "Receive device::mojom::XRFrameDataProvider::GetEnvironmentIntegrationProvider";
    }
  } else {
    switch (static_cast<messages::XRFrameDataProvider>(message.name())) {
      case messages::XRFrameDataProvider::kGetFrameData:
            return "Receive reply device::mojom::XRFrameDataProvider::GetFrameData";
      case messages::XRFrameDataProvider::kGetEnvironmentIntegrationProvider:
            return "Receive reply device::mojom::XRFrameDataProvider::GetEnvironmentIntegrationProvider";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t XRFrameDataProvider::GetFrameData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xade4e91a;  // IPCStableHash for device::mojom::XRFrameDataProvider::GetFrameData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XRFrameDataProvider::GetEnvironmentIntegrationProvider_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x06636c1e;  // IPCStableHash for device::mojom::XRFrameDataProvider::GetEnvironmentIntegrationProvider
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class XRFrameDataProvider_GetFrameData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XRFrameDataProvider_GetFrameData_ForwardToCallback(
      XRFrameDataProvider::GetFrameDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  XRFrameDataProvider_GetFrameData_ForwardToCallback(const XRFrameDataProvider_GetFrameData_ForwardToCallback&) = delete;
  XRFrameDataProvider_GetFrameData_ForwardToCallback& operator=(const XRFrameDataProvider_GetFrameData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  XRFrameDataProvider::GetFrameDataCallback callback_;
};

XRFrameDataProviderProxy::XRFrameDataProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void XRFrameDataProviderProxy::GetFrameData(
    XRFrameDataRequestOptionsPtr in_options, GetFrameDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XRFrameDataProvider::GetFrameData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type XRFrameDataRequestOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRFrameDataProvider::kGetFrameData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRFrameDataProvider_GetFrameData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::XRFrameDataRequestOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRFrameDataProvider::Name_);
  message.set_method_name("GetFrameData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRFrameDataProvider_GetFrameData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void XRFrameDataProviderProxy::GetEnvironmentIntegrationProvider(
    ::mojo::PendingAssociatedReceiver<XREnvironmentIntegrationProvider> in_environment_provider) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XRFrameDataProvider::GetEnvironmentIntegrationProvider", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("environment_provider"), in_environment_provider,
                        "<value of type ::mojo::PendingAssociatedReceiver<XREnvironmentIntegrationProvider>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRFrameDataProvider::kGetEnvironmentIntegrationProvider), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::device::mojom::XREnvironmentIntegrationProviderAssociatedRequestDataView>(
    in_environment_provider,
    &params->environment_provider,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->environment_provider)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid environment_provider in XRFrameDataProvider.GetEnvironmentIntegrationProvider request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRFrameDataProvider::Name_);
  message.set_method_name("GetEnvironmentIntegrationProvider");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class XRFrameDataProvider_GetFrameData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static XRFrameDataProvider::GetFrameDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<XRFrameDataProvider_GetFrameData_ProxyToResponder> proxy(
        new XRFrameDataProvider_GetFrameData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&XRFrameDataProvider_GetFrameData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XRFrameDataProvider_GetFrameData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  XRFrameDataProvider_GetFrameData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "XRFrameDataProvider::GetFrameDataCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      XRFrameDataPtr in_frame_data);
};

bool XRFrameDataProvider_GetFrameData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XRFrameDataProvider_GetFrameData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XRFrameDataProvider_GetFrameData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for XRFrameDataProvider.0
  bool success = true;
  XRFrameDataPtr p_frame_data{};
  XRFrameDataProvider_GetFrameData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFrameData(&p_frame_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRFrameDataProvider::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_frame_data));
  }
  return true;
}

void XRFrameDataProvider_GetFrameData_ProxyToResponder::Run(
    XRFrameDataPtr in_frame_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::XRFrameDataProvider::GetFrameData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_data"), in_frame_data,
                        "<value of type XRFrameDataPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRFrameDataProvider::kGetFrameData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRFrameDataProvider_GetFrameData_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_data)::BaseType> frame_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::XRFrameDataDataView>(
    in_frame_data,
    frame_data_fragment);

  params->frame_data.Set(
      frame_data_fragment.is_null() ? nullptr : frame_data_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRFrameDataProvider::Name_);
  message.set_method_name("GetFrameData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool XRFrameDataProviderStubDispatch::Accept(
    XRFrameDataProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::XRFrameDataProvider>(message->header()->name)) {
    case messages::XRFrameDataProvider::kGetFrameData: {
      break;
    }
    case messages::XRFrameDataProvider::kGetEnvironmentIntegrationProvider: {
      DCHECK(message->is_serialized());
      internal::XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data* params =
          reinterpret_cast<internal::XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data*>(
              message->mutable_payload());
      

      // Validation for XRFrameDataProvider.1
      bool success = true;
      ::mojo::PendingAssociatedReceiver<XREnvironmentIntegrationProvider> p_environment_provider{};
      XRFrameDataProvider_GetEnvironmentIntegrationProvider_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_environment_provider =
            input_data_view.TakeEnvironmentProvider<decltype(p_environment_provider)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRFrameDataProvider::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetEnvironmentIntegrationProvider(        
        std::move(p_environment_provider));
      return true;
    }
  }
  return false;
}

// static
bool XRFrameDataProviderStubDispatch::AcceptWithResponder(
    XRFrameDataProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::XRFrameDataProvider>(message->header()->name)) {
    case messages::XRFrameDataProvider::kGetFrameData: {
      internal::XRFrameDataProvider_GetFrameData_Params_Data* params =
          reinterpret_cast<
              internal::XRFrameDataProvider_GetFrameData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for XRFrameDataProvider.0
      bool success = true;
      XRFrameDataRequestOptionsPtr p_options{};
      XRFrameDataProvider_GetFrameData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRFrameDataProvider::Name_, 0, false);
        return false;
      }
      auto callback =
          XRFrameDataProvider_GetFrameData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetFrameData(        
        std::move(p_options), std::move(callback));
      return true;
    }
    case messages::XRFrameDataProvider::kGetEnvironmentIntegrationProvider: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kXRFrameDataProviderValidationInfo[] = {
    { &internal::XRFrameDataProvider_GetFrameData_Params_Data::Validate,
     &internal::XRFrameDataProvider_GetFrameData_ResponseParams_Data::Validate},
    { &internal::XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data::Validate,
     nullptr /* no response */},
};

bool XRFrameDataProviderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::blink::XRFrameDataProvider::Name_,
    kXRFrameDataProviderValidationInfo);
}

bool XRFrameDataProviderResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::device::mojom::blink::XRFrameDataProvider::Name_,
    kXRFrameDataProviderValidationInfo);
}
// The declaration includes the definition on other builds.

XRPresentationProvider::IPCStableHashFunction XRPresentationProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::XRPresentationProvider>(message.name())) {
    case messages::XRPresentationProvider::kUpdateLayerBounds: {
      return &XRPresentationProvider::UpdateLayerBounds_Sym::IPCStableHash;
    }
    case messages::XRPresentationProvider::kSubmitFrameMissing: {
      return &XRPresentationProvider::SubmitFrameMissing_Sym::IPCStableHash;
    }
    case messages::XRPresentationProvider::kSubmitFrame: {
      return &XRPresentationProvider::SubmitFrame_Sym::IPCStableHash;
    }
    case messages::XRPresentationProvider::kSubmitFrameDrawnIntoTexture: {
      return &XRPresentationProvider::SubmitFrameDrawnIntoTexture_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* XRPresentationProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::XRPresentationProvider>(message.name())) {
      case messages::XRPresentationProvider::kUpdateLayerBounds:
            return "Receive device::mojom::XRPresentationProvider::UpdateLayerBounds";
      case messages::XRPresentationProvider::kSubmitFrameMissing:
            return "Receive device::mojom::XRPresentationProvider::SubmitFrameMissing";
      case messages::XRPresentationProvider::kSubmitFrame:
            return "Receive device::mojom::XRPresentationProvider::SubmitFrame";
      case messages::XRPresentationProvider::kSubmitFrameDrawnIntoTexture:
            return "Receive device::mojom::XRPresentationProvider::SubmitFrameDrawnIntoTexture";
    }
  } else {
    switch (static_cast<messages::XRPresentationProvider>(message.name())) {
      case messages::XRPresentationProvider::kUpdateLayerBounds:
            return "Receive reply device::mojom::XRPresentationProvider::UpdateLayerBounds";
      case messages::XRPresentationProvider::kSubmitFrameMissing:
            return "Receive reply device::mojom::XRPresentationProvider::SubmitFrameMissing";
      case messages::XRPresentationProvider::kSubmitFrame:
            return "Receive reply device::mojom::XRPresentationProvider::SubmitFrame";
      case messages::XRPresentationProvider::kSubmitFrameDrawnIntoTexture:
            return "Receive reply device::mojom::XRPresentationProvider::SubmitFrameDrawnIntoTexture";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t XRPresentationProvider::UpdateLayerBounds_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x75acad71;  // IPCStableHash for device::mojom::XRPresentationProvider::UpdateLayerBounds
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XRPresentationProvider::SubmitFrameMissing_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1991206c;  // IPCStableHash for device::mojom::XRPresentationProvider::SubmitFrameMissing
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XRPresentationProvider::SubmitFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x083deb4e;  // IPCStableHash for device::mojom::XRPresentationProvider::SubmitFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XRPresentationProvider::SubmitFrameDrawnIntoTexture_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbaabb3c1;  // IPCStableHash for device::mojom::XRPresentationProvider::SubmitFrameDrawnIntoTexture
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

XRPresentationProviderProxy::XRPresentationProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void XRPresentationProviderProxy::UpdateLayerBounds(
    int16_t in_frame_id, const ::gfx::RectF& in_left_bounds, const ::gfx::RectF& in_right_bounds, const ::gfx::Size& in_source_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XRPresentationProvider::UpdateLayerBounds", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_id"), in_frame_id,
                        "<value of type int16_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("left_bounds"), in_left_bounds,
                        "<value of type const ::gfx::RectF&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("right_bounds"), in_right_bounds,
                        "<value of type const ::gfx::RectF&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_size"), in_source_size,
                        "<value of type const ::gfx::Size&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRPresentationProvider::kUpdateLayerBounds), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRPresentationProvider_UpdateLayerBounds_Params_Data> params(
          message);
  params.Allocate();

  params->frame_id = in_frame_id;
  mojo::internal::MessageFragment<
      typename decltype(params->left_bounds)::BaseType> left_bounds_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
    in_left_bounds,
    left_bounds_fragment);

  params->left_bounds.Set(
      left_bounds_fragment.is_null() ? nullptr : left_bounds_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->left_bounds.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null left_bounds in XRPresentationProvider.UpdateLayerBounds request");
  mojo::internal::MessageFragment<
      typename decltype(params->right_bounds)::BaseType> right_bounds_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
    in_right_bounds,
    right_bounds_fragment);

  params->right_bounds.Set(
      right_bounds_fragment.is_null() ? nullptr : right_bounds_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->right_bounds.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null right_bounds in XRPresentationProvider.UpdateLayerBounds request");
  mojo::internal::MessageFragment<
      typename decltype(params->source_size)::BaseType> source_size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_source_size,
    source_size_fragment);

  params->source_size.Set(
      source_size_fragment.is_null() ? nullptr : source_size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_size in XRPresentationProvider.UpdateLayerBounds request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRPresentationProvider::Name_);
  message.set_method_name("UpdateLayerBounds");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void XRPresentationProviderProxy::SubmitFrameMissing(
    int16_t in_frame_id, const ::gpu::SyncToken& in_sync_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XRPresentationProvider::SubmitFrameMissing", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_id"), in_frame_id,
                        "<value of type int16_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sync_token"), in_sync_token,
                        "<value of type const ::gpu::SyncToken&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRPresentationProvider::kSubmitFrameMissing), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRPresentationProvider_SubmitFrameMissing_Params_Data> params(
          message);
  params.Allocate();

  params->frame_id = in_frame_id;
  mojo::internal::MessageFragment<
      typename decltype(params->sync_token)::BaseType> sync_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView>(
    in_sync_token,
    sync_token_fragment);

  params->sync_token.Set(
      sync_token_fragment.is_null() ? nullptr : sync_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->sync_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null sync_token in XRPresentationProvider.SubmitFrameMissing request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRPresentationProvider::Name_);
  message.set_method_name("SubmitFrameMissing");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void XRPresentationProviderProxy::SubmitFrame(
    int16_t in_frame_id, const ::gpu::MailboxHolder& in_mailbox_holder, ::base::TimeDelta in_time_waited) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XRPresentationProvider::SubmitFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_id"), in_frame_id,
                        "<value of type int16_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mailbox_holder"), in_mailbox_holder,
                        "<value of type const ::gpu::MailboxHolder&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("time_waited"), in_time_waited,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRPresentationProvider::kSubmitFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRPresentationProvider_SubmitFrame_Params_Data> params(
          message);
  params.Allocate();

  params->frame_id = in_frame_id;
  mojo::internal::MessageFragment<
      typename decltype(params->mailbox_holder)::BaseType> mailbox_holder_fragment(
          params.message());
  
  mojo::internal::Serialize<::gpu::mojom::MailboxHolderDataView>(
    in_mailbox_holder,
    mailbox_holder_fragment);

  params->mailbox_holder.Set(
      mailbox_holder_fragment.is_null() ? nullptr : mailbox_holder_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->mailbox_holder.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null mailbox_holder in XRPresentationProvider.SubmitFrame request");
  mojo::internal::MessageFragment<
      typename decltype(params->time_waited)::BaseType> time_waited_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_time_waited,
    time_waited_fragment);

  params->time_waited.Set(
      time_waited_fragment.is_null() ? nullptr : time_waited_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->time_waited.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null time_waited in XRPresentationProvider.SubmitFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRPresentationProvider::Name_);
  message.set_method_name("SubmitFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void XRPresentationProviderProxy::SubmitFrameDrawnIntoTexture(
    int16_t in_frame_id, const ::blink::Vector<::device::LayerId>& in_layer_ids, const ::gpu::SyncToken& in_sync_token, ::base::TimeDelta in_time_waited) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XRPresentationProvider::SubmitFrameDrawnIntoTexture", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_id"), in_frame_id,
                        "<value of type int16_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("layer_ids"), in_layer_ids,
                        "<value of type const ::blink::Vector<::device::LayerId>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sync_token"), in_sync_token,
                        "<value of type const ::gpu::SyncToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("time_waited"), in_time_waited,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRPresentationProvider::kSubmitFrameDrawnIntoTexture), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data> params(
          message);
  params.Allocate();

  params->frame_id = in_frame_id;
  mojo::internal::MessageFragment<
      typename decltype(params->layer_ids)::BaseType>
      layer_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& layer_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::LayerIdDataView>>(
    in_layer_ids,
    layer_ids_fragment,
    &layer_ids_validate_params);

  params->layer_ids.Set(
      layer_ids_fragment.is_null() ? nullptr : layer_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->layer_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null layer_ids in XRPresentationProvider.SubmitFrameDrawnIntoTexture request");
  mojo::internal::MessageFragment<
      typename decltype(params->sync_token)::BaseType> sync_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView>(
    in_sync_token,
    sync_token_fragment);

  params->sync_token.Set(
      sync_token_fragment.is_null() ? nullptr : sync_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->sync_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null sync_token in XRPresentationProvider.SubmitFrameDrawnIntoTexture request");
  mojo::internal::MessageFragment<
      typename decltype(params->time_waited)::BaseType> time_waited_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_time_waited,
    time_waited_fragment);

  params->time_waited.Set(
      time_waited_fragment.is_null() ? nullptr : time_waited_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->time_waited.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null time_waited in XRPresentationProvider.SubmitFrameDrawnIntoTexture request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRPresentationProvider::Name_);
  message.set_method_name("SubmitFrameDrawnIntoTexture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool XRPresentationProviderStubDispatch::Accept(
    XRPresentationProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::XRPresentationProvider>(message->header()->name)) {
    case messages::XRPresentationProvider::kUpdateLayerBounds: {
      DCHECK(message->is_serialized());
      internal::XRPresentationProvider_UpdateLayerBounds_Params_Data* params =
          reinterpret_cast<internal::XRPresentationProvider_UpdateLayerBounds_Params_Data*>(
              message->mutable_payload());
      

      // Validation for XRPresentationProvider.0
      bool success = true;
      int16_t p_frame_id{};
      ::gfx::RectF p_left_bounds{};
      ::gfx::RectF p_right_bounds{};
      ::gfx::Size p_source_size{};
      XRPresentationProvider_UpdateLayerBounds_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frame_id = input_data_view.frame_id();
      if (success && !input_data_view.ReadLeftBounds(&p_left_bounds))
        success = false;
      if (success && !input_data_view.ReadRightBounds(&p_right_bounds))
        success = false;
      if (success && !input_data_view.ReadSourceSize(&p_source_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRPresentationProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateLayerBounds(        
        std::move(p_frame_id), 
        std::move(p_left_bounds), 
        std::move(p_right_bounds), 
        std::move(p_source_size));
      return true;
    }
    case messages::XRPresentationProvider::kSubmitFrameMissing: {
      DCHECK(message->is_serialized());
      internal::XRPresentationProvider_SubmitFrameMissing_Params_Data* params =
          reinterpret_cast<internal::XRPresentationProvider_SubmitFrameMissing_Params_Data*>(
              message->mutable_payload());
      

      // Validation for XRPresentationProvider.1
      bool success = true;
      int16_t p_frame_id{};
      ::gpu::SyncToken p_sync_token{};
      XRPresentationProvider_SubmitFrameMissing_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frame_id = input_data_view.frame_id();
      if (success && !input_data_view.ReadSyncToken(&p_sync_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRPresentationProvider::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubmitFrameMissing(        
        std::move(p_frame_id), 
        std::move(p_sync_token));
      return true;
    }
    case messages::XRPresentationProvider::kSubmitFrame: {
      DCHECK(message->is_serialized());
      internal::XRPresentationProvider_SubmitFrame_Params_Data* params =
          reinterpret_cast<internal::XRPresentationProvider_SubmitFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for XRPresentationProvider.2
      bool success = true;
      int16_t p_frame_id{};
      ::gpu::MailboxHolder p_mailbox_holder{};
      ::base::TimeDelta p_time_waited{};
      XRPresentationProvider_SubmitFrame_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frame_id = input_data_view.frame_id();
      if (success && !input_data_view.ReadMailboxHolder(&p_mailbox_holder))
        success = false;
      if (success && !input_data_view.ReadTimeWaited(&p_time_waited))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRPresentationProvider::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubmitFrame(        
        std::move(p_frame_id), 
        std::move(p_mailbox_holder), 
        std::move(p_time_waited));
      return true;
    }
    case messages::XRPresentationProvider::kSubmitFrameDrawnIntoTexture: {
      DCHECK(message->is_serialized());
      internal::XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data* params =
          reinterpret_cast<internal::XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data*>(
              message->mutable_payload());
      

      // Validation for XRPresentationProvider.3
      bool success = true;
      int16_t p_frame_id{};
      ::blink::Vector<::device::LayerId> p_layer_ids{};
      ::gpu::SyncToken p_sync_token{};
      ::base::TimeDelta p_time_waited{};
      XRPresentationProvider_SubmitFrameDrawnIntoTexture_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frame_id = input_data_view.frame_id();
      if (success && !input_data_view.ReadLayerIds(&p_layer_ids))
        success = false;
      if (success && !input_data_view.ReadSyncToken(&p_sync_token))
        success = false;
      if (success && !input_data_view.ReadTimeWaited(&p_time_waited))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRPresentationProvider::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubmitFrameDrawnIntoTexture(        
        std::move(p_frame_id), 
        std::move(p_layer_ids), 
        std::move(p_sync_token), 
        std::move(p_time_waited));
      return true;
    }
  }
  return false;
}

// static
bool XRPresentationProviderStubDispatch::AcceptWithResponder(
    XRPresentationProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::XRPresentationProvider>(message->header()->name)) {
    case messages::XRPresentationProvider::kUpdateLayerBounds: {
      break;
    }
    case messages::XRPresentationProvider::kSubmitFrameMissing: {
      break;
    }
    case messages::XRPresentationProvider::kSubmitFrame: {
      break;
    }
    case messages::XRPresentationProvider::kSubmitFrameDrawnIntoTexture: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kXRPresentationProviderValidationInfo[] = {
    { &internal::XRPresentationProvider_UpdateLayerBounds_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::XRPresentationProvider_SubmitFrameMissing_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::XRPresentationProvider_SubmitFrame_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data::Validate,
     nullptr /* no response */},
};

bool XRPresentationProviderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::blink::XRPresentationProvider::Name_,
    kXRPresentationProviderValidationInfo);
}

// The declaration includes the definition on other builds.

XRPresentationClient::IPCStableHashFunction XRPresentationClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::XRPresentationClient>(message.name())) {
    case messages::XRPresentationClient::kOnSubmitFrameTransferred: {
      return &XRPresentationClient::OnSubmitFrameTransferred_Sym::IPCStableHash;
    }
    case messages::XRPresentationClient::kOnSubmitFrameRendered: {
      return &XRPresentationClient::OnSubmitFrameRendered_Sym::IPCStableHash;
    }
    case messages::XRPresentationClient::kOnSubmitFrameGpuFence: {
      return &XRPresentationClient::OnSubmitFrameGpuFence_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* XRPresentationClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::XRPresentationClient>(message.name())) {
      case messages::XRPresentationClient::kOnSubmitFrameTransferred:
            return "Receive device::mojom::XRPresentationClient::OnSubmitFrameTransferred";
      case messages::XRPresentationClient::kOnSubmitFrameRendered:
            return "Receive device::mojom::XRPresentationClient::OnSubmitFrameRendered";
      case messages::XRPresentationClient::kOnSubmitFrameGpuFence:
            return "Receive device::mojom::XRPresentationClient::OnSubmitFrameGpuFence";
    }
  } else {
    switch (static_cast<messages::XRPresentationClient>(message.name())) {
      case messages::XRPresentationClient::kOnSubmitFrameTransferred:
            return "Receive reply device::mojom::XRPresentationClient::OnSubmitFrameTransferred";
      case messages::XRPresentationClient::kOnSubmitFrameRendered:
            return "Receive reply device::mojom::XRPresentationClient::OnSubmitFrameRendered";
      case messages::XRPresentationClient::kOnSubmitFrameGpuFence:
            return "Receive reply device::mojom::XRPresentationClient::OnSubmitFrameGpuFence";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t XRPresentationClient::OnSubmitFrameTransferred_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa6a1bf55;  // IPCStableHash for device::mojom::XRPresentationClient::OnSubmitFrameTransferred
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XRPresentationClient::OnSubmitFrameRendered_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfd94b7d6;  // IPCStableHash for device::mojom::XRPresentationClient::OnSubmitFrameRendered
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XRPresentationClient::OnSubmitFrameGpuFence_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x327d24b1;  // IPCStableHash for device::mojom::XRPresentationClient::OnSubmitFrameGpuFence
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

XRPresentationClientProxy::XRPresentationClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void XRPresentationClientProxy::OnSubmitFrameTransferred(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XRPresentationClient::OnSubmitFrameTransferred", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRPresentationClient::kOnSubmitFrameTransferred), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRPresentationClient_OnSubmitFrameTransferred_Params_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRPresentationClient::Name_);
  message.set_method_name("OnSubmitFrameTransferred");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void XRPresentationClientProxy::OnSubmitFrameRendered(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::XRPresentationClient::OnSubmitFrameRendered");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRPresentationClient::kOnSubmitFrameRendered), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRPresentationClient_OnSubmitFrameRendered_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRPresentationClient::Name_);
  message.set_method_name("OnSubmitFrameRendered");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void XRPresentationClientProxy::OnSubmitFrameGpuFence(
    ::gfx::GpuFenceHandle in_gpu_fence_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XRPresentationClient::OnSubmitFrameGpuFence", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_fence_handle"), in_gpu_fence_handle,
                        "<value of type ::gfx::GpuFenceHandle>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRPresentationClient::kOnSubmitFrameGpuFence), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRPresentationClient_OnSubmitFrameGpuFence_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->gpu_fence_handle)::BaseType> gpu_fence_handle_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::GpuFenceHandleDataView>(
    in_gpu_fence_handle,
    gpu_fence_handle_fragment);

  params->gpu_fence_handle.Set(
      gpu_fence_handle_fragment.is_null() ? nullptr : gpu_fence_handle_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->gpu_fence_handle.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null gpu_fence_handle in XRPresentationClient.OnSubmitFrameGpuFence request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRPresentationClient::Name_);
  message.set_method_name("OnSubmitFrameGpuFence");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool XRPresentationClientStubDispatch::Accept(
    XRPresentationClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::XRPresentationClient>(message->header()->name)) {
    case messages::XRPresentationClient::kOnSubmitFrameTransferred: {
      DCHECK(message->is_serialized());
      internal::XRPresentationClient_OnSubmitFrameTransferred_Params_Data* params =
          reinterpret_cast<internal::XRPresentationClient_OnSubmitFrameTransferred_Params_Data*>(
              message->mutable_payload());
      

      // Validation for XRPresentationClient.0
      bool success = true;
      bool p_success{};
      XRPresentationClient_OnSubmitFrameTransferred_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_success = input_data_view.success();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRPresentationClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSubmitFrameTransferred(        
        std::move(p_success));
      return true;
    }
    case messages::XRPresentationClient::kOnSubmitFrameRendered: {
      DCHECK(message->is_serialized());
      internal::XRPresentationClient_OnSubmitFrameRendered_Params_Data* params =
          reinterpret_cast<internal::XRPresentationClient_OnSubmitFrameRendered_Params_Data*>(
              message->mutable_payload());
      

      // Validation for XRPresentationClient.1
      bool success = true;
      XRPresentationClient_OnSubmitFrameRendered_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRPresentationClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSubmitFrameRendered(        );
      return true;
    }
    case messages::XRPresentationClient::kOnSubmitFrameGpuFence: {
      DCHECK(message->is_serialized());
      internal::XRPresentationClient_OnSubmitFrameGpuFence_Params_Data* params =
          reinterpret_cast<internal::XRPresentationClient_OnSubmitFrameGpuFence_Params_Data*>(
              message->mutable_payload());
      

      // Validation for XRPresentationClient.2
      bool success = true;
      ::gfx::GpuFenceHandle p_gpu_fence_handle{};
      XRPresentationClient_OnSubmitFrameGpuFence_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGpuFenceHandle(&p_gpu_fence_handle))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRPresentationClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSubmitFrameGpuFence(        
        std::move(p_gpu_fence_handle));
      return true;
    }
  }
  return false;
}

// static
bool XRPresentationClientStubDispatch::AcceptWithResponder(
    XRPresentationClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::XRPresentationClient>(message->header()->name)) {
    case messages::XRPresentationClient::kOnSubmitFrameTransferred: {
      break;
    }
    case messages::XRPresentationClient::kOnSubmitFrameRendered: {
      break;
    }
    case messages::XRPresentationClient::kOnSubmitFrameGpuFence: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kXRPresentationClientValidationInfo[] = {
    { &internal::XRPresentationClient_OnSubmitFrameTransferred_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::XRPresentationClient_OnSubmitFrameRendered_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::XRPresentationClient_OnSubmitFrameGpuFence_Params_Data::Validate,
     nullptr /* no response */},
};

bool XRPresentationClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::blink::XRPresentationClient::Name_,
    kXRPresentationClientValidationInfo);
}

// The declaration includes the definition on other builds.

XRSessionClient::IPCStableHashFunction XRSessionClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::XRSessionClient>(message.name())) {
    case messages::XRSessionClient::kOnExitPresent: {
      return &XRSessionClient::OnExitPresent_Sym::IPCStableHash;
    }
    case messages::XRSessionClient::kOnVisibilityStateChanged: {
      return &XRSessionClient::OnVisibilityStateChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* XRSessionClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::XRSessionClient>(message.name())) {
      case messages::XRSessionClient::kOnExitPresent:
            return "Receive device::mojom::XRSessionClient::OnExitPresent";
      case messages::XRSessionClient::kOnVisibilityStateChanged:
            return "Receive device::mojom::XRSessionClient::OnVisibilityStateChanged";
    }
  } else {
    switch (static_cast<messages::XRSessionClient>(message.name())) {
      case messages::XRSessionClient::kOnExitPresent:
            return "Receive reply device::mojom::XRSessionClient::OnExitPresent";
      case messages::XRSessionClient::kOnVisibilityStateChanged:
            return "Receive reply device::mojom::XRSessionClient::OnVisibilityStateChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t XRSessionClient::OnExitPresent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4b8a3d50;  // IPCStableHash for device::mojom::XRSessionClient::OnExitPresent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XRSessionClient::OnVisibilityStateChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7f1abdb5;  // IPCStableHash for device::mojom::XRSessionClient::OnVisibilityStateChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

XRSessionClientProxy::XRSessionClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void XRSessionClientProxy::OnExitPresent(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::XRSessionClient::OnExitPresent");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRSessionClient::kOnExitPresent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRSessionClient_OnExitPresent_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRSessionClient::Name_);
  message.set_method_name("OnExitPresent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void XRSessionClientProxy::OnVisibilityStateChanged(
    XRVisibilityState in_visibility_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XRSessionClient::OnVisibilityStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visibility_state"), in_visibility_state,
                        "<value of type XRVisibilityState>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRSessionClient::kOnVisibilityStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRSessionClient_OnVisibilityStateChanged_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::device::mojom::XRVisibilityState>(
    in_visibility_state,
    &params->visibility_state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRSessionClient::Name_);
  message.set_method_name("OnVisibilityStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool XRSessionClientStubDispatch::Accept(
    XRSessionClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::XRSessionClient>(message->header()->name)) {
    case messages::XRSessionClient::kOnExitPresent: {
      DCHECK(message->is_serialized());
      internal::XRSessionClient_OnExitPresent_Params_Data* params =
          reinterpret_cast<internal::XRSessionClient_OnExitPresent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for XRSessionClient.0
      bool success = true;
      XRSessionClient_OnExitPresent_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRSessionClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnExitPresent(        );
      return true;
    }
    case messages::XRSessionClient::kOnVisibilityStateChanged: {
      DCHECK(message->is_serialized());
      internal::XRSessionClient_OnVisibilityStateChanged_Params_Data* params =
          reinterpret_cast<internal::XRSessionClient_OnVisibilityStateChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for XRSessionClient.1
      bool success = true;
      XRVisibilityState p_visibility_state{};
      XRSessionClient_OnVisibilityStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVisibilityState(&p_visibility_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRSessionClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnVisibilityStateChanged(        
        std::move(p_visibility_state));
      return true;
    }
  }
  return false;
}

// static
bool XRSessionClientStubDispatch::AcceptWithResponder(
    XRSessionClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::XRSessionClient>(message->header()->name)) {
    case messages::XRSessionClient::kOnExitPresent: {
      break;
    }
    case messages::XRSessionClient::kOnVisibilityStateChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kXRSessionClientValidationInfo[] = {
    { &internal::XRSessionClient_OnExitPresent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::XRSessionClient_OnVisibilityStateChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool XRSessionClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::blink::XRSessionClient::Name_,
    kXRSessionClientValidationInfo);
}

// The declaration includes the definition on other builds.

XRLayerManager::IPCStableHashFunction XRLayerManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::XRLayerManager>(message.name())) {
    case messages::XRLayerManager::kCreateCompositionLayer: {
      return &XRLayerManager::CreateCompositionLayer_Sym::IPCStableHash;
    }
    case messages::XRLayerManager::kDestroyCompositionLayer: {
      return &XRLayerManager::DestroyCompositionLayer_Sym::IPCStableHash;
    }
    case messages::XRLayerManager::kUpdateCompositionLayer: {
      return &XRLayerManager::UpdateCompositionLayer_Sym::IPCStableHash;
    }
    case messages::XRLayerManager::kSetEnabledCompositionLayers: {
      return &XRLayerManager::SetEnabledCompositionLayers_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* XRLayerManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::XRLayerManager>(message.name())) {
      case messages::XRLayerManager::kCreateCompositionLayer:
            return "Receive device::mojom::XRLayerManager::CreateCompositionLayer";
      case messages::XRLayerManager::kDestroyCompositionLayer:
            return "Receive device::mojom::XRLayerManager::DestroyCompositionLayer";
      case messages::XRLayerManager::kUpdateCompositionLayer:
            return "Receive device::mojom::XRLayerManager::UpdateCompositionLayer";
      case messages::XRLayerManager::kSetEnabledCompositionLayers:
            return "Receive device::mojom::XRLayerManager::SetEnabledCompositionLayers";
    }
  } else {
    switch (static_cast<messages::XRLayerManager>(message.name())) {
      case messages::XRLayerManager::kCreateCompositionLayer:
            return "Receive reply device::mojom::XRLayerManager::CreateCompositionLayer";
      case messages::XRLayerManager::kDestroyCompositionLayer:
            return "Receive reply device::mojom::XRLayerManager::DestroyCompositionLayer";
      case messages::XRLayerManager::kUpdateCompositionLayer:
            return "Receive reply device::mojom::XRLayerManager::UpdateCompositionLayer";
      case messages::XRLayerManager::kSetEnabledCompositionLayers:
            return "Receive reply device::mojom::XRLayerManager::SetEnabledCompositionLayers";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t XRLayerManager::CreateCompositionLayer_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x85eb16d2;  // IPCStableHash for device::mojom::XRLayerManager::CreateCompositionLayer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XRLayerManager::DestroyCompositionLayer_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1b7be5b0;  // IPCStableHash for device::mojom::XRLayerManager::DestroyCompositionLayer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XRLayerManager::UpdateCompositionLayer_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9a2878e2;  // IPCStableHash for device::mojom::XRLayerManager::UpdateCompositionLayer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XRLayerManager::SetEnabledCompositionLayers_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x43b3e69c;  // IPCStableHash for device::mojom::XRLayerManager::SetEnabledCompositionLayers
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class XRLayerManager_CreateCompositionLayer_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XRLayerManager_CreateCompositionLayer_ForwardToCallback(
      XRLayerManager::CreateCompositionLayerCallback callback
      ) : callback_(std::move(callback)) {
  }

  XRLayerManager_CreateCompositionLayer_ForwardToCallback(const XRLayerManager_CreateCompositionLayer_ForwardToCallback&) = delete;
  XRLayerManager_CreateCompositionLayer_ForwardToCallback& operator=(const XRLayerManager_CreateCompositionLayer_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  XRLayerManager::CreateCompositionLayerCallback callback_;
};

XRLayerManagerProxy::XRLayerManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void XRLayerManagerProxy::CreateCompositionLayer(
    XRCompositionLayerDataPtr in_create_data, CreateCompositionLayerCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XRLayerManager::CreateCompositionLayer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("create_data"), in_create_data,
                        "<value of type XRCompositionLayerDataPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRLayerManager::kCreateCompositionLayer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRLayerManager_CreateCompositionLayer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->create_data)::BaseType> create_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::XRCompositionLayerDataDataView>(
    in_create_data,
    create_data_fragment);

  params->create_data.Set(
      create_data_fragment.is_null() ? nullptr : create_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->create_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null create_data in XRLayerManager.CreateCompositionLayer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRLayerManager::Name_);
  message.set_method_name("CreateCompositionLayer");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRLayerManager_CreateCompositionLayer_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void XRLayerManagerProxy::DestroyCompositionLayer(
    const ::device::LayerId& in_layer_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XRLayerManager::DestroyCompositionLayer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("layer_id"), in_layer_id,
                        "<value of type const ::device::LayerId&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRLayerManager::kDestroyCompositionLayer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRLayerManager_DestroyCompositionLayer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->layer_id)::BaseType> layer_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::LayerIdDataView>(
    in_layer_id,
    layer_id_fragment);

  params->layer_id.Set(
      layer_id_fragment.is_null() ? nullptr : layer_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->layer_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null layer_id in XRLayerManager.DestroyCompositionLayer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRLayerManager::Name_);
  message.set_method_name("DestroyCompositionLayer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void XRLayerManagerProxy::UpdateCompositionLayer(
    const ::device::LayerId& in_layer_id, XRLayerMutableDataPtr in_update_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XRLayerManager::UpdateCompositionLayer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("layer_id"), in_layer_id,
                        "<value of type const ::device::LayerId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("update_data"), in_update_data,
                        "<value of type XRLayerMutableDataPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRLayerManager::kUpdateCompositionLayer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRLayerManager_UpdateCompositionLayer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->layer_id)::BaseType> layer_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::LayerIdDataView>(
    in_layer_id,
    layer_id_fragment);

  params->layer_id.Set(
      layer_id_fragment.is_null() ? nullptr : layer_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->layer_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null layer_id in XRLayerManager.UpdateCompositionLayer request");
  mojo::internal::MessageFragment<
      typename decltype(params->update_data)::BaseType> update_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::XRLayerMutableDataDataView>(
    in_update_data,
    update_data_fragment);

  params->update_data.Set(
      update_data_fragment.is_null() ? nullptr : update_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->update_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null update_data in XRLayerManager.UpdateCompositionLayer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRLayerManager::Name_);
  message.set_method_name("UpdateCompositionLayer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void XRLayerManagerProxy::SetEnabledCompositionLayers(
    const ::blink::Vector<::device::LayerId>& in_layer_ids) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XRLayerManager::SetEnabledCompositionLayers", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("layer_ids"), in_layer_ids,
                        "<value of type const ::blink::Vector<::device::LayerId>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRLayerManager::kSetEnabledCompositionLayers), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRLayerManager_SetEnabledCompositionLayers_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->layer_ids)::BaseType>
      layer_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& layer_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::LayerIdDataView>>(
    in_layer_ids,
    layer_ids_fragment,
    &layer_ids_validate_params);

  params->layer_ids.Set(
      layer_ids_fragment.is_null() ? nullptr : layer_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->layer_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null layer_ids in XRLayerManager.SetEnabledCompositionLayers request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRLayerManager::Name_);
  message.set_method_name("SetEnabledCompositionLayers");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class XRLayerManager_CreateCompositionLayer_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static XRLayerManager::CreateCompositionLayerCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<XRLayerManager_CreateCompositionLayer_ProxyToResponder> proxy(
        new XRLayerManager_CreateCompositionLayer_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&XRLayerManager_CreateCompositionLayer_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XRLayerManager_CreateCompositionLayer_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  XRLayerManager_CreateCompositionLayer_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "XRLayerManager::CreateCompositionLayerCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CreateCompositionLayerResult in_code);
};

bool XRLayerManager_CreateCompositionLayer_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XRLayerManager_CreateCompositionLayer_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XRLayerManager_CreateCompositionLayer_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for XRLayerManager.0
  bool success = true;
  CreateCompositionLayerResult p_code{};
  XRLayerManager_CreateCompositionLayer_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCode(&p_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRLayerManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_code));
  }
  return true;
}

void XRLayerManager_CreateCompositionLayer_ProxyToResponder::Run(
    CreateCompositionLayerResult in_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::XRLayerManager::CreateCompositionLayer", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("code"), in_code,
                        "<value of type CreateCompositionLayerResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRLayerManager::kCreateCompositionLayer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRLayerManager_CreateCompositionLayer_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::device::mojom::CreateCompositionLayerResult>(
    in_code,
    &params->code);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRLayerManager::Name_);
  message.set_method_name("CreateCompositionLayer");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool XRLayerManagerStubDispatch::Accept(
    XRLayerManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::XRLayerManager>(message->header()->name)) {
    case messages::XRLayerManager::kCreateCompositionLayer: {
      break;
    }
    case messages::XRLayerManager::kDestroyCompositionLayer: {
      DCHECK(message->is_serialized());
      internal::XRLayerManager_DestroyCompositionLayer_Params_Data* params =
          reinterpret_cast<internal::XRLayerManager_DestroyCompositionLayer_Params_Data*>(
              message->mutable_payload());
      

      // Validation for XRLayerManager.1
      bool success = true;
      ::device::LayerId p_layer_id{};
      XRLayerManager_DestroyCompositionLayer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLayerId(&p_layer_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRLayerManager::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DestroyCompositionLayer(        
        std::move(p_layer_id));
      return true;
    }
    case messages::XRLayerManager::kUpdateCompositionLayer: {
      DCHECK(message->is_serialized());
      internal::XRLayerManager_UpdateCompositionLayer_Params_Data* params =
          reinterpret_cast<internal::XRLayerManager_UpdateCompositionLayer_Params_Data*>(
              message->mutable_payload());
      

      // Validation for XRLayerManager.2
      bool success = true;
      ::device::LayerId p_layer_id{};
      XRLayerMutableDataPtr p_update_data{};
      XRLayerManager_UpdateCompositionLayer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLayerId(&p_layer_id))
        success = false;
      if (success && !input_data_view.ReadUpdateData(&p_update_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRLayerManager::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateCompositionLayer(        
        std::move(p_layer_id), 
        std::move(p_update_data));
      return true;
    }
    case messages::XRLayerManager::kSetEnabledCompositionLayers: {
      DCHECK(message->is_serialized());
      internal::XRLayerManager_SetEnabledCompositionLayers_Params_Data* params =
          reinterpret_cast<internal::XRLayerManager_SetEnabledCompositionLayers_Params_Data*>(
              message->mutable_payload());
      

      // Validation for XRLayerManager.3
      bool success = true;
      ::blink::Vector<::device::LayerId> p_layer_ids{};
      XRLayerManager_SetEnabledCompositionLayers_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLayerIds(&p_layer_ids))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRLayerManager::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetEnabledCompositionLayers(        
        std::move(p_layer_ids));
      return true;
    }
  }
  return false;
}

// static
bool XRLayerManagerStubDispatch::AcceptWithResponder(
    XRLayerManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::XRLayerManager>(message->header()->name)) {
    case messages::XRLayerManager::kCreateCompositionLayer: {
      internal::XRLayerManager_CreateCompositionLayer_Params_Data* params =
          reinterpret_cast<
              internal::XRLayerManager_CreateCompositionLayer_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for XRLayerManager.0
      bool success = true;
      XRCompositionLayerDataPtr p_create_data{};
      XRLayerManager_CreateCompositionLayer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCreateData(&p_create_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRLayerManager::Name_, 0, false);
        return false;
      }
      auto callback =
          XRLayerManager_CreateCompositionLayer_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateCompositionLayer(        
        std::move(p_create_data), std::move(callback));
      return true;
    }
    case messages::XRLayerManager::kDestroyCompositionLayer: {
      break;
    }
    case messages::XRLayerManager::kUpdateCompositionLayer: {
      break;
    }
    case messages::XRLayerManager::kSetEnabledCompositionLayers: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kXRLayerManagerValidationInfo[] = {
    { &internal::XRLayerManager_CreateCompositionLayer_Params_Data::Validate,
     &internal::XRLayerManager_CreateCompositionLayer_ResponseParams_Data::Validate},
    { &internal::XRLayerManager_DestroyCompositionLayer_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::XRLayerManager_UpdateCompositionLayer_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::XRLayerManager_SetEnabledCompositionLayers_Params_Data::Validate,
     nullptr /* no response */},
};

bool XRLayerManagerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::blink::XRLayerManager::Name_,
    kXRLayerManagerValidationInfo);
}

bool XRLayerManagerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::device::mojom::blink::XRLayerManager::Name_,
    kXRLayerManagerValidationInfo);
}
// The declaration includes the definition on other builds.

WebXrInternalsRendererListener::IPCStableHashFunction WebXrInternalsRendererListener::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebXrInternalsRendererListener>(message.name())) {
    case messages::WebXrInternalsRendererListener::kOnFrameData: {
      return &WebXrInternalsRendererListener::OnFrameData_Sym::IPCStableHash;
    }
    case messages::WebXrInternalsRendererListener::kOnConsoleLog: {
      return &WebXrInternalsRendererListener::OnConsoleLog_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebXrInternalsRendererListener::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebXrInternalsRendererListener>(message.name())) {
      case messages::WebXrInternalsRendererListener::kOnFrameData:
            return "Receive device::mojom::WebXrInternalsRendererListener::OnFrameData";
      case messages::WebXrInternalsRendererListener::kOnConsoleLog:
            return "Receive device::mojom::WebXrInternalsRendererListener::OnConsoleLog";
    }
  } else {
    switch (static_cast<messages::WebXrInternalsRendererListener>(message.name())) {
      case messages::WebXrInternalsRendererListener::kOnFrameData:
            return "Receive reply device::mojom::WebXrInternalsRendererListener::OnFrameData";
      case messages::WebXrInternalsRendererListener::kOnConsoleLog:
            return "Receive reply device::mojom::WebXrInternalsRendererListener::OnConsoleLog";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebXrInternalsRendererListener::OnFrameData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2c22e1e2;  // IPCStableHash for device::mojom::WebXrInternalsRendererListener::OnFrameData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebXrInternalsRendererListener::OnConsoleLog_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x386ad32e;  // IPCStableHash for device::mojom::WebXrInternalsRendererListener::OnConsoleLog
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

WebXrInternalsRendererListenerProxy::WebXrInternalsRendererListenerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebXrInternalsRendererListenerProxy::OnFrameData(
    ::device::mojom::blink::XrFrameStatisticsPtr in_xrframe_statistics) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::WebXrInternalsRendererListener::OnFrameData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("xrframe_statistics"), in_xrframe_statistics,
                        "<value of type ::device::mojom::blink::XrFrameStatisticsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebXrInternalsRendererListener::kOnFrameData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::WebXrInternalsRendererListener_OnFrameData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->xrframe_statistics)::BaseType> xrframe_statistics_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::XrFrameStatisticsDataView>(
    in_xrframe_statistics,
    xrframe_statistics_fragment);

  params->xrframe_statistics.Set(
      xrframe_statistics_fragment.is_null() ? nullptr : xrframe_statistics_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->xrframe_statistics.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null xrframe_statistics in WebXrInternalsRendererListener.OnFrameData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebXrInternalsRendererListener::Name_);
  message.set_method_name("OnFrameData");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebXrInternalsRendererListenerProxy::OnConsoleLog(
    ::device::mojom::blink::XrLogMessagePtr in_xrlogging_statistics) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::WebXrInternalsRendererListener::OnConsoleLog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("xrlogging_statistics"), in_xrlogging_statistics,
                        "<value of type ::device::mojom::blink::XrLogMessagePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebXrInternalsRendererListener::kOnConsoleLog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::WebXrInternalsRendererListener_OnConsoleLog_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->xrlogging_statistics)::BaseType> xrlogging_statistics_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::XrLogMessageDataView>(
    in_xrlogging_statistics,
    xrlogging_statistics_fragment);

  params->xrlogging_statistics.Set(
      xrlogging_statistics_fragment.is_null() ? nullptr : xrlogging_statistics_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->xrlogging_statistics.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null xrlogging_statistics in WebXrInternalsRendererListener.OnConsoleLog request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebXrInternalsRendererListener::Name_);
  message.set_method_name("OnConsoleLog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool WebXrInternalsRendererListenerStubDispatch::Accept(
    WebXrInternalsRendererListener* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebXrInternalsRendererListener>(message->header()->name)) {
    case messages::WebXrInternalsRendererListener::kOnFrameData: {
      DCHECK(message->is_serialized());
      internal::WebXrInternalsRendererListener_OnFrameData_Params_Data* params =
          reinterpret_cast<internal::WebXrInternalsRendererListener_OnFrameData_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebXrInternalsRendererListener.0
      bool success = true;
      ::device::mojom::blink::XrFrameStatisticsPtr p_xrframe_statistics{};
      WebXrInternalsRendererListener_OnFrameData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadXrframeStatistics(&p_xrframe_statistics))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebXrInternalsRendererListener::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFrameData(        
        std::move(p_xrframe_statistics));
      return true;
    }
    case messages::WebXrInternalsRendererListener::kOnConsoleLog: {
      DCHECK(message->is_serialized());
      internal::WebXrInternalsRendererListener_OnConsoleLog_Params_Data* params =
          reinterpret_cast<internal::WebXrInternalsRendererListener_OnConsoleLog_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebXrInternalsRendererListener.1
      bool success = true;
      ::device::mojom::blink::XrLogMessagePtr p_xrlogging_statistics{};
      WebXrInternalsRendererListener_OnConsoleLog_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadXrloggingStatistics(&p_xrlogging_statistics))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebXrInternalsRendererListener::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnConsoleLog(        
        std::move(p_xrlogging_statistics));
      return true;
    }
  }
  return false;
}

// static
bool WebXrInternalsRendererListenerStubDispatch::AcceptWithResponder(
    WebXrInternalsRendererListener* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebXrInternalsRendererListener>(message->header()->name)) {
    case messages::WebXrInternalsRendererListener::kOnFrameData: {
      break;
    }
    case messages::WebXrInternalsRendererListener::kOnConsoleLog: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebXrInternalsRendererListenerValidationInfo[] = {
    { &internal::WebXrInternalsRendererListener_OnFrameData_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebXrInternalsRendererListener_OnConsoleLog_Params_Data::Validate,
     nullptr /* no response */},
};

bool WebXrInternalsRendererListenerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::blink::WebXrInternalsRendererListener::Name_,
    kWebXrInternalsRendererListenerValidationInfo);
}



}  // device::mojom::blink


namespace mojo {


// static
bool StructTraits<::device::mojom::blink::XRDepthConfig::DataView, ::device::mojom::blink::XRDepthConfigPtr>::Read(
    ::device::mojom::blink::XRDepthConfig::DataView input,
    ::device::mojom::blink::XRDepthConfigPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRDepthConfigPtr result(::device::mojom::blink::XRDepthConfig::New());
  
      if (success && !input.ReadDepthUsage(&result->depth_usage))
        success = false;
      if (success && !input.ReadDepthDataFormat(&result->depth_data_format))
        success = false;
      if (success && !input.ReadDepthType(&result->depth_type)) {
        success = false;
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRSessionDeviceConfig::DataView, ::device::mojom::blink::XRSessionDeviceConfigPtr>::Read(
    ::device::mojom::blink::XRSessionDeviceConfig::DataView input,
    ::device::mojom::blink::XRSessionDeviceConfigPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRSessionDeviceConfigPtr result(::device::mojom::blink::XRSessionDeviceConfig::New());
  
      if (success)
        result->default_framebuffer_scale = input.default_framebuffer_scale();
      if (success && !input.ReadViews(&result->views))
        success = false;
      if (success)
        result->supports_viewport_scaling = input.supports_viewport_scaling();
      if (success)
        result->enable_anti_aliasing = input.enable_anti_aliasing();
      if (success && !input.ReadDepthConfiguration(&result->depth_configuration))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRSession::DataView, ::device::mojom::blink::XRSessionPtr>::Read(
    ::device::mojom::blink::XRSession::DataView input,
    ::device::mojom::blink::XRSessionPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRSessionPtr result(::device::mojom::blink::XRSession::New());
  
      if (success) {
        result->data_provider =
            input.TakeDataProvider<decltype(result->data_provider)>();
      }
      if (success) {
        result->layer_manager =
            input.TakeLayerManager<decltype(result->layer_manager)>();
      }
      if (success) {
        result->client_receiver =
            input.TakeClientReceiver<decltype(result->client_receiver)>();
      }
      if (success && !input.ReadSubmitFrameSink(&result->submit_frame_sink))
        success = false;
      if (success && !input.ReadEnabledFeatures(&result->enabled_features))
        success = false;
      if (success && !input.ReadDeviceConfig(&result->device_config))
        success = false;
      if (success && !input.ReadEnviromentBlendMode(&result->enviroment_blend_mode))
        success = false;
      if (success && !input.ReadInteractionMode(&result->interaction_mode))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRPresentationConnection::DataView, ::device::mojom::blink::XRPresentationConnectionPtr>::Read(
    ::device::mojom::blink::XRPresentationConnection::DataView input,
    ::device::mojom::blink::XRPresentationConnectionPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRPresentationConnectionPtr result(::device::mojom::blink::XRPresentationConnection::New());
  
      if (success) {
        result->provider =
            input.TakeProvider<decltype(result->provider)>();
      }
      if (success) {
        result->client_receiver =
            input.TakeClientReceiver<decltype(result->client_receiver)>();
      }
      if (success && !input.ReadTransportOptions(&result->transport_options))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRInputSourceDescription::DataView, ::device::mojom::blink::XRInputSourceDescriptionPtr>::Read(
    ::device::mojom::blink::XRInputSourceDescription::DataView input,
    ::device::mojom::blink::XRInputSourceDescriptionPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRInputSourceDescriptionPtr result(::device::mojom::blink::XRInputSourceDescription::New());
  
      if (success && !input.ReadTargetRayMode(&result->target_ray_mode))
        success = false;
      if (success && !input.ReadHandedness(&result->handedness))
        success = false;
      if (success && !input.ReadInputFromPointer(&result->input_from_pointer))
        success = false;
      if (success && !input.ReadProfiles(&result->profiles))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRInputSourceState::DataView, ::device::mojom::blink::XRInputSourceStatePtr>::Read(
    ::device::mojom::blink::XRInputSourceState::DataView input,
    ::device::mojom::blink::XRInputSourceStatePtr* output) {
  bool success = true;
  ::device::mojom::blink::XRInputSourceStatePtr result(::device::mojom::blink::XRInputSourceState::New());
  
      if (success)
        result->source_id = input.source_id();
      if (success && !input.ReadDescription(&result->description))
        success = false;
      if (success && !input.ReadMojoFromInput(&result->mojo_from_input))
        success = false;
      if (success)
        result->emulated_position = input.emulated_position();
      if (success)
        result->is_auxiliary = input.is_auxiliary();
      if (success)
        result->primary_input_pressed = input.primary_input_pressed();
      if (success)
        result->primary_input_clicked = input.primary_input_clicked();
      if (success)
        result->primary_squeeze_pressed = input.primary_squeeze_pressed();
      if (success)
        result->primary_squeeze_clicked = input.primary_squeeze_clicked();
      if (success && !input.ReadGamepad(&result->gamepad))
        success = false;
      if (success && !input.ReadOverlayPointerPosition(&result->overlay_pointer_position))
        success = false;
      if (success && !input.ReadHandTrackingData(&result->hand_tracking_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::VRFieldOfView::DataView, ::device::mojom::blink::VRFieldOfViewPtr>::Read(
    ::device::mojom::blink::VRFieldOfView::DataView input,
    ::device::mojom::blink::VRFieldOfViewPtr* output) {
  bool success = true;
  ::device::mojom::blink::VRFieldOfViewPtr result(::device::mojom::blink::VRFieldOfView::New());
  
      if (success)
        result->up_degrees = input.up_degrees();
      if (success)
        result->down_degrees = input.down_degrees();
      if (success)
        result->left_degrees = input.left_degrees();
      if (success)
        result->right_degrees = input.right_degrees();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::VRPose::DataView, ::device::mojom::blink::VRPosePtr>::Read(
    ::device::mojom::blink::VRPose::DataView input,
    ::device::mojom::blink::VRPosePtr* output) {
  bool success = true;
  ::device::mojom::blink::VRPosePtr result(::device::mojom::blink::VRPose::New());
  
      if (success && !input.ReadOrientation(&result->orientation))
        success = false;
      if (success && !input.ReadPosition(&result->position))
        success = false;
      if (success)
        result->emulated_position = input.emulated_position();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::Pose::DataView, ::device::mojom::blink::PosePtr>::Read(
    ::device::mojom::blink::Pose::DataView input,
    ::device::mojom::blink::PosePtr* output) {
  bool success = true;
  ::device::mojom::blink::PosePtr result(::device::mojom::blink::Pose::New());
  
      if (success && !input.ReadOrientation(&result->orientation))
        success = false;
      if (success && !input.ReadPosition(&result->position))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::AnchorId::DataView, ::device::mojom::blink::AnchorIdPtr>::Read(
    ::device::mojom::blink::AnchorId::DataView input,
    ::device::mojom::blink::AnchorIdPtr* output) {
  bool success = true;
  ::device::mojom::blink::AnchorIdPtr result(::device::mojom::blink::AnchorId::New());
  
      if (success)
        result->id_value = input.id_value();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::HitTestSubscriptionId::DataView, ::device::mojom::blink::HitTestSubscriptionIdPtr>::Read(
    ::device::mojom::blink::HitTestSubscriptionId::DataView input,
    ::device::mojom::blink::HitTestSubscriptionIdPtr* output) {
  bool success = true;
  ::device::mojom::blink::HitTestSubscriptionIdPtr result(::device::mojom::blink::HitTestSubscriptionId::New());
  
      if (success)
        result->id_value = input.id_value();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::PlaneId::DataView, ::device::mojom::blink::PlaneIdPtr>::Read(
    ::device::mojom::blink::PlaneId::DataView input,
    ::device::mojom::blink::PlaneIdPtr* output) {
  bool success = true;
  ::device::mojom::blink::PlaneIdPtr result(::device::mojom::blink::PlaneId::New());
  
      if (success)
        result->id_value = input.id_value();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XrVisibilityMaskId::DataView, ::device::mojom::blink::XrVisibilityMaskIdPtr>::Read(
    ::device::mojom::blink::XrVisibilityMaskId::DataView input,
    ::device::mojom::blink::XrVisibilityMaskIdPtr* output) {
  bool success = true;
  ::device::mojom::blink::XrVisibilityMaskIdPtr result(::device::mojom::blink::XrVisibilityMaskId::New());
  
      if (success)
        result->id_value = input.id_value();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRRay::DataView, ::device::mojom::blink::XRRayPtr>::Read(
    ::device::mojom::blink::XRRay::DataView input,
    ::device::mojom::blink::XRRayPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRRayPtr result(::device::mojom::blink::XRRay::New());
  
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success && !input.ReadDirection(&result->direction))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRHitResult::DataView, ::device::mojom::blink::XRHitResultPtr>::Read(
    ::device::mojom::blink::XRHitResult::DataView input,
    ::device::mojom::blink::XRHitResultPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRHitResultPtr result(::device::mojom::blink::XRHitResult::New());
  
      if (success && !input.ReadMojoFromResult(&result->mojo_from_result))
        success = false;
      if (success && !input.ReadPlaneId(&result->plane_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRViewGeometry::DataView, ::device::mojom::blink::XRViewGeometryPtr>::Read(
    ::device::mojom::blink::XRViewGeometry::DataView input,
    ::device::mojom::blink::XRViewGeometryPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRViewGeometryPtr result(::device::mojom::blink::XRViewGeometry::New());
  
      if (success && !input.ReadFieldOfView(&result->field_of_view))
        success = false;
      if (success && !input.ReadMojoFromView(&result->mojo_from_view))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRVisibilityMask::DataView, ::device::mojom::blink::XRVisibilityMaskPtr>::Read(
    ::device::mojom::blink::XRVisibilityMask::DataView input,
    ::device::mojom::blink::XRVisibilityMaskPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRVisibilityMaskPtr result(::device::mojom::blink::XRVisibilityMask::New());
  
      if (success && !input.ReadVertices(&result->vertices))
        success = false;
      if (success && !input.ReadUnvalidatedIndices(&result->unvalidated_indices))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRView::DataView, ::device::mojom::blink::XRViewPtr>::Read(
    ::device::mojom::blink::XRView::DataView input,
    ::device::mojom::blink::XRViewPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRViewPtr result(::device::mojom::blink::XRView::New());
  
      if (success && !input.ReadEye(&result->eye))
        success = false;
      if (success && !input.ReadGeometry(&result->geometry))
        success = false;
      if (success && !input.ReadViewport(&result->viewport))
        success = false;
      if (success && !input.ReadDepthData(&result->depth_data))
        success = false;
      if (success)
        result->is_first_person_observer = input.is_first_person_observer();
      if (success && !input.ReadVisibilityMask(&result->visibility_mask))
        success = false;
      if (success && !input.ReadVisibilityMaskId(&result->visibility_mask_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::VRStageParameters::DataView, ::device::mojom::blink::VRStageParametersPtr>::Read(
    ::device::mojom::blink::VRStageParameters::DataView input,
    ::device::mojom::blink::VRStageParametersPtr* output) {
  bool success = true;
  ::device::mojom::blink::VRStageParametersPtr result(::device::mojom::blink::VRStageParameters::New());
  
      if (success && !input.ReadMojoFromStage(&result->mojo_from_stage))
        success = false;
      if (success && !input.ReadBounds(&result->bounds))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRPresentationTransportOptions::DataView, ::device::mojom::blink::XRPresentationTransportOptionsPtr>::Read(
    ::device::mojom::blink::XRPresentationTransportOptions::DataView input,
    ::device::mojom::blink::XRPresentationTransportOptionsPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRPresentationTransportOptionsPtr result(::device::mojom::blink::XRPresentationTransportOptions::New());
  
      if (success && !input.ReadTransportMethod(&result->transport_method))
        success = false;
      if (success)
        result->wait_for_transfer_notification = input.wait_for_transfer_notification();
      if (success)
        result->wait_for_render_notification = input.wait_for_render_notification();
      if (success)
        result->wait_for_gpu_fence = input.wait_for_gpu_fence();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRInputSourceSpaceInfo::DataView, ::device::mojom::blink::XRInputSourceSpaceInfoPtr>::Read(
    ::device::mojom::blink::XRInputSourceSpaceInfo::DataView input,
    ::device::mojom::blink::XRInputSourceSpaceInfoPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRInputSourceSpaceInfoPtr result(::device::mojom::blink::XRInputSourceSpaceInfo::New());
  
      if (success)
        result->input_source_id = input.input_source_id();
      if (success && !input.ReadInputSourceSpaceType(&result->input_source_space_type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRHandJointSpaceInfo::DataView, ::device::mojom::blink::XRHandJointSpaceInfoPtr>::Read(
    ::device::mojom::blink::XRHandJointSpaceInfo::DataView input,
    ::device::mojom::blink::XRHandJointSpaceInfoPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRHandJointSpaceInfoPtr result(::device::mojom::blink::XRHandJointSpaceInfo::New());
  
      if (success && !input.ReadHandedness(&result->handedness))
        success = false;
      if (success && !input.ReadJoint(&result->joint))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRPlanePointData::DataView, ::device::mojom::blink::XRPlanePointDataPtr>::Read(
    ::device::mojom::blink::XRPlanePointData::DataView input,
    ::device::mojom::blink::XRPlanePointDataPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRPlanePointDataPtr result(::device::mojom::blink::XRPlanePointData::New());
  
      if (success)
        result->x = input.x();
      if (success)
        result->z = input.z();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRPlaneData::DataView, ::device::mojom::blink::XRPlaneDataPtr>::Read(
    ::device::mojom::blink::XRPlaneData::DataView input,
    ::device::mojom::blink::XRPlaneDataPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRPlaneDataPtr result(::device::mojom::blink::XRPlaneData::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadOrientation(&result->orientation))
        success = false;
      if (success && !input.ReadMojoFromPlane(&result->mojo_from_plane))
        success = false;
      if (success && !input.ReadPolygon(&result->polygon))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRPlaneDetectionData::DataView, ::device::mojom::blink::XRPlaneDetectionDataPtr>::Read(
    ::device::mojom::blink::XRPlaneDetectionData::DataView input,
    ::device::mojom::blink::XRPlaneDetectionDataPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRPlaneDetectionDataPtr result(::device::mojom::blink::XRPlaneDetectionData::New());
  
      if (success && !input.ReadAllPlanesIds(&result->all_planes_ids))
        success = false;
      if (success && !input.ReadUpdatedPlanesData(&result->updated_planes_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRAnchorData::DataView, ::device::mojom::blink::XRAnchorDataPtr>::Read(
    ::device::mojom::blink::XRAnchorData::DataView input,
    ::device::mojom::blink::XRAnchorDataPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRAnchorDataPtr result(::device::mojom::blink::XRAnchorData::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadMojoFromAnchor(&result->mojo_from_anchor))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRAnchorsData::DataView, ::device::mojom::blink::XRAnchorsDataPtr>::Read(
    ::device::mojom::blink::XRAnchorsData::DataView input,
    ::device::mojom::blink::XRAnchorsDataPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRAnchorsDataPtr result(::device::mojom::blink::XRAnchorsData::New());
  
      if (success && !input.ReadAllAnchorsIds(&result->all_anchors_ids))
        success = false;
      if (success && !input.ReadUpdatedAnchorsData(&result->updated_anchors_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRHitTestSubscriptionResultData::DataView, ::device::mojom::blink::XRHitTestSubscriptionResultDataPtr>::Read(
    ::device::mojom::blink::XRHitTestSubscriptionResultData::DataView input,
    ::device::mojom::blink::XRHitTestSubscriptionResultDataPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRHitTestSubscriptionResultDataPtr result(::device::mojom::blink::XRHitTestSubscriptionResultData::New());
  
      if (success && !input.ReadSubscriptionId(&result->subscription_id))
        success = false;
      if (success && !input.ReadHitTestResults(&result->hit_test_results))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRHitTestTransientInputSubscriptionResultData::DataView, ::device::mojom::blink::XRHitTestTransientInputSubscriptionResultDataPtr>::Read(
    ::device::mojom::blink::XRHitTestTransientInputSubscriptionResultData::DataView input,
    ::device::mojom::blink::XRHitTestTransientInputSubscriptionResultDataPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRHitTestTransientInputSubscriptionResultDataPtr result(::device::mojom::blink::XRHitTestTransientInputSubscriptionResultData::New());
  
      if (success && !input.ReadSubscriptionId(&result->subscription_id))
        success = false;
      if (success && !input.ReadInputSourceIdToHitTestResults(&result->input_source_id_to_hit_test_results))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRHitTestSubscriptionResultsData::DataView, ::device::mojom::blink::XRHitTestSubscriptionResultsDataPtr>::Read(
    ::device::mojom::blink::XRHitTestSubscriptionResultsData::DataView input,
    ::device::mojom::blink::XRHitTestSubscriptionResultsDataPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRHitTestSubscriptionResultsDataPtr result(::device::mojom::blink::XRHitTestSubscriptionResultsData::New());
  
      if (success && !input.ReadResults(&result->results))
        success = false;
      if (success && !input.ReadTransientInputResults(&result->transient_input_results))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::RgbTupleF32::DataView, ::device::mojom::blink::RgbTupleF32Ptr>::Read(
    ::device::mojom::blink::RgbTupleF32::DataView input,
    ::device::mojom::blink::RgbTupleF32Ptr* output) {
  bool success = true;
  ::device::mojom::blink::RgbTupleF32Ptr result(::device::mojom::blink::RgbTupleF32::New());
  
      if (success)
        result->red = input.red();
      if (success)
        result->green = input.green();
      if (success)
        result->blue = input.blue();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRSphericalHarmonics::DataView, ::device::mojom::blink::XRSphericalHarmonicsPtr>::Read(
    ::device::mojom::blink::XRSphericalHarmonics::DataView input,
    ::device::mojom::blink::XRSphericalHarmonicsPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRSphericalHarmonicsPtr result(::device::mojom::blink::XRSphericalHarmonics::New());
  
      if (success && !input.ReadCoefficients(&result->coefficients))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRCubeMap::DataView, ::device::mojom::blink::XRCubeMapPtr>::Read(
    ::device::mojom::blink::XRCubeMap::DataView input,
    ::device::mojom::blink::XRCubeMapPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRCubeMapPtr result(::device::mojom::blink::XRCubeMap::New());
  
      if (success)
        result->width_and_height = input.width_and_height();
      if (success && !input.ReadPositiveX(&result->positive_x))
        success = false;
      if (success && !input.ReadNegativeX(&result->negative_x))
        success = false;
      if (success && !input.ReadPositiveY(&result->positive_y))
        success = false;
      if (success && !input.ReadNegativeY(&result->negative_y))
        success = false;
      if (success && !input.ReadPositiveZ(&result->positive_z))
        success = false;
      if (success && !input.ReadNegativeZ(&result->negative_z))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRLightProbe::DataView, ::device::mojom::blink::XRLightProbePtr>::Read(
    ::device::mojom::blink::XRLightProbe::DataView input,
    ::device::mojom::blink::XRLightProbePtr* output) {
  bool success = true;
  ::device::mojom::blink::XRLightProbePtr result(::device::mojom::blink::XRLightProbe::New());
  
      if (success && !input.ReadSphericalHarmonics(&result->spherical_harmonics))
        success = false;
      if (success && !input.ReadMainLightDirection(&result->main_light_direction))
        success = false;
      if (success && !input.ReadMainLightIntensity(&result->main_light_intensity))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRReflectionProbe::DataView, ::device::mojom::blink::XRReflectionProbePtr>::Read(
    ::device::mojom::blink::XRReflectionProbe::DataView input,
    ::device::mojom::blink::XRReflectionProbePtr* output) {
  bool success = true;
  ::device::mojom::blink::XRReflectionProbePtr result(::device::mojom::blink::XRReflectionProbe::New());
  
      if (success && !input.ReadCubeMap(&result->cube_map))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRLightEstimationData::DataView, ::device::mojom::blink::XRLightEstimationDataPtr>::Read(
    ::device::mojom::blink::XRLightEstimationData::DataView input,
    ::device::mojom::blink::XRLightEstimationDataPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRLightEstimationDataPtr result(::device::mojom::blink::XRLightEstimationData::New());
  
      if (success && !input.ReadLightProbe(&result->light_probe))
        success = false;
      if (success && !input.ReadReflectionProbe(&result->reflection_probe))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRDepthDataStillValid::DataView, ::device::mojom::blink::XRDepthDataStillValidPtr>::Read(
    ::device::mojom::blink::XRDepthDataStillValid::DataView input,
    ::device::mojom::blink::XRDepthDataStillValidPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRDepthDataStillValidPtr result(::device::mojom::blink::XRDepthDataStillValid::New());
  
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRDepthDataUpdated::DataView, ::device::mojom::blink::XRDepthDataUpdatedPtr>::Read(
    ::device::mojom::blink::XRDepthDataUpdated::DataView input,
    ::device::mojom::blink::XRDepthDataUpdatedPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRDepthDataUpdatedPtr result(::device::mojom::blink::XRDepthDataUpdated::New());
  
      if (success && !input.ReadPixelData(&result->pixel_data))
        success = false;
      if (success && !input.ReadNormTextureFromNormView(&result->norm_texture_from_norm_view))
        success = false;
      if (success && !input.ReadSize(&result->size))
        success = false;
      if (success)
        result->raw_value_to_meters = input.raw_value_to_meters();
      if (success && !input.ReadViewGeometry(&result->view_geometry))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRTrackedImageData::DataView, ::device::mojom::blink::XRTrackedImageDataPtr>::Read(
    ::device::mojom::blink::XRTrackedImageData::DataView input,
    ::device::mojom::blink::XRTrackedImageDataPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRTrackedImageDataPtr result(::device::mojom::blink::XRTrackedImageData::New());
  
      if (success)
        result->index = input.index();
      if (success && !input.ReadMojoFromImage(&result->mojo_from_image))
        success = false;
      if (success)
        result->actively_tracked = input.actively_tracked();
      if (success)
        result->width_in_meters = input.width_in_meters();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRTrackedImagesData::DataView, ::device::mojom::blink::XRTrackedImagesDataPtr>::Read(
    ::device::mojom::blink::XRTrackedImagesData::DataView input,
    ::device::mojom::blink::XRTrackedImagesDataPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRTrackedImagesDataPtr result(::device::mojom::blink::XRTrackedImagesData::New());
  
      if (success && !input.ReadImagesData(&result->images_data))
        success = false;
      if (success && !input.ReadImageTrackableScores(&result->image_trackable_scores))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::LayerId::DataView, ::device::mojom::blink::LayerIdPtr>::Read(
    ::device::mojom::blink::LayerId::DataView input,
    ::device::mojom::blink::LayerIdPtr* output) {
  bool success = true;
  ::device::mojom::blink::LayerIdPtr result(::device::mojom::blink::LayerId::New());
  
      if (success)
        result->id_value = input.id_value();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRProjectionLayerData::DataView, ::device::mojom::blink::XRProjectionLayerDataPtr>::Read(
    ::device::mojom::blink::XRProjectionLayerData::DataView input,
    ::device::mojom::blink::XRProjectionLayerDataPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRProjectionLayerDataPtr result(::device::mojom::blink::XRProjectionLayerData::New());
  
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRQuadLayerData::DataView, ::device::mojom::blink::XRQuadLayerDataPtr>::Read(
    ::device::mojom::blink::XRQuadLayerData::DataView input,
    ::device::mojom::blink::XRQuadLayerDataPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRQuadLayerDataPtr result(::device::mojom::blink::XRQuadLayerData::New());
  
      if (success && !input.ReadTransform(&result->transform))
        success = false;
      if (success)
        result->width = input.width();
      if (success)
        result->height = input.height();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRCylinderLayerData::DataView, ::device::mojom::blink::XRCylinderLayerDataPtr>::Read(
    ::device::mojom::blink::XRCylinderLayerData::DataView input,
    ::device::mojom::blink::XRCylinderLayerDataPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRCylinderLayerDataPtr result(::device::mojom::blink::XRCylinderLayerData::New());
  
      if (success && !input.ReadTransform(&result->transform))
        success = false;
      if (success)
        result->radius = input.radius();
      if (success)
        result->central_angle = input.central_angle();
      if (success)
        result->aspect_ratio = input.aspect_ratio();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XREquirectLayerData::DataView, ::device::mojom::blink::XREquirectLayerDataPtr>::Read(
    ::device::mojom::blink::XREquirectLayerData::DataView input,
    ::device::mojom::blink::XREquirectLayerDataPtr* output) {
  bool success = true;
  ::device::mojom::blink::XREquirectLayerDataPtr result(::device::mojom::blink::XREquirectLayerData::New());
  
      if (success && !input.ReadTransform(&result->transform))
        success = false;
      if (success)
        result->radius = input.radius();
      if (success)
        result->central_horizontal_angle = input.central_horizontal_angle();
      if (success)
        result->upper_vertical_angle = input.upper_vertical_angle();
      if (success)
        result->lower_vertical_angle = input.lower_vertical_angle();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRLayerReadOnlyData::DataView, ::device::mojom::blink::XRLayerReadOnlyDataPtr>::Read(
    ::device::mojom::blink::XRLayerReadOnlyData::DataView input,
    ::device::mojom::blink::XRLayerReadOnlyDataPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRLayerReadOnlyDataPtr result(::device::mojom::blink::XRLayerReadOnlyData::New());
  
      if (success && !input.ReadLayerId(&result->layer_id))
        success = false;
      if (success)
        result->texture_width = input.texture_width();
      if (success)
        result->texture_height = input.texture_height();
      if (success)
        result->is_static = input.is_static();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRLayerMutableData::DataView, ::device::mojom::blink::XRLayerMutableDataPtr>::Read(
    ::device::mojom::blink::XRLayerMutableData::DataView input,
    ::device::mojom::blink::XRLayerMutableDataPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRLayerMutableDataPtr result(::device::mojom::blink::XRLayerMutableData::New());
  
      if (success)
        result->blend_texture_source_alpha = input.blend_texture_source_alpha();
      if (success)
        result->opacity = input.opacity();
      if (success && !input.ReadReferenceSpaceType(&result->reference_space_type))
        success = false;
      if (success && !input.ReadLayerData(&result->layer_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRCompositionLayerData::DataView, ::device::mojom::blink::XRCompositionLayerDataPtr>::Read(
    ::device::mojom::blink::XRCompositionLayerData::DataView input,
    ::device::mojom::blink::XRCompositionLayerDataPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRCompositionLayerDataPtr result(::device::mojom::blink::XRCompositionLayerData::New());
  
      if (success && !input.ReadReadOnlyData(&result->read_only_data))
        success = false;
      if (success && !input.ReadMutableData(&result->mutable_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRLayerFrameData::DataView, ::device::mojom::blink::XRLayerFrameDataPtr>::Read(
    ::device::mojom::blink::XRLayerFrameData::DataView input,
    ::device::mojom::blink::XRLayerFrameDataPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRLayerFrameDataPtr result(::device::mojom::blink::XRLayerFrameData::New());
  
      if (success && !input.ReadLayerId(&result->layer_id))
        success = false;
      if (success && !input.ReadBufferSharedImage(&result->buffer_shared_image))
        success = false;
      if (success && !input.ReadBufferSyncToken(&result->buffer_sync_token))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRRenderInfo::DataView, ::device::mojom::blink::XRRenderInfoPtr>::Read(
    ::device::mojom::blink::XRRenderInfo::DataView input,
    ::device::mojom::blink::XRRenderInfoPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRRenderInfoPtr result(::device::mojom::blink::XRRenderInfo::New());
  
      if (success)
        result->frame_id = input.frame_id();
      if (success && !input.ReadMojoFromViewer(&result->mojo_from_viewer))
        success = false;
      if (success && !input.ReadViews(&result->views))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRFrameData::DataView, ::device::mojom::blink::XRFrameDataPtr>::Read(
    ::device::mojom::blink::XRFrameData::DataView input,
    ::device::mojom::blink::XRFrameDataPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRFrameDataPtr result(::device::mojom::blink::XRFrameData::New());
  
      if (success && !input.ReadRenderInfo(&result->render_info))
        success = false;
      if (success && !input.ReadTimeDelta(&result->time_delta))
        success = false;
      if (success && !input.ReadBufferSharedImage(&result->buffer_shared_image))
        success = false;
      if (success && !input.ReadBufferSyncToken(&result->buffer_sync_token))
        success = false;
      if (success && !input.ReadCameraImageBufferSharedImage(&result->camera_image_buffer_shared_image))
        success = false;
      if (success && !input.ReadCameraImageBufferSyncToken(&result->camera_image_buffer_sync_token))
        success = false;
      if (success && !input.ReadCameraImageSize(&result->camera_image_size))
        success = false;
      if (success)
        result->mojo_space_reset = input.mojo_space_reset();
      if (success && !input.ReadMojoFromFloor(&result->mojo_from_floor))
        success = false;
      if (success && !input.ReadInputState(&result->input_state))
        success = false;
      if (success)
        result->stage_parameters_id = input.stage_parameters_id();
      if (success && !input.ReadStageParameters(&result->stage_parameters))
        success = false;
      if (success && !input.ReadDetectedPlanesData(&result->detected_planes_data))
        success = false;
      if (success && !input.ReadAnchorsData(&result->anchors_data))
        success = false;
      if (success && !input.ReadCompositionLayersData(&result->composition_layers_data))
        success = false;
      if (success && !input.ReadLightEstimationData(&result->light_estimation_data))
        success = false;
      if (success && !input.ReadHitTestSubscriptionResults(&result->hit_test_subscription_results))
        success = false;
      if (success)
        result->rendering_time_ratio = input.rendering_time_ratio();
      if (success && !input.ReadTrackedImages(&result->tracked_images))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::RequestSessionSuccess::DataView, ::device::mojom::blink::RequestSessionSuccessPtr>::Read(
    ::device::mojom::blink::RequestSessionSuccess::DataView input,
    ::device::mojom::blink::RequestSessionSuccessPtr* output) {
  bool success = true;
  ::device::mojom::blink::RequestSessionSuccessPtr result(::device::mojom::blink::RequestSessionSuccess::New());
  
      if (success && !input.ReadSession(&result->session))
        success = false;
      if (success)
        result->trace_id = input.trace_id();
      if (success) {
        result->metrics_recorder =
            input.TakeMetricsRecorder<decltype(result->metrics_recorder)>();
      }
      if (success) {
        result->xr_internals_listener =
            input.TakeXrInternalsListener<decltype(result->xr_internals_listener)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRFrameDataRequestOptions::DataView, ::device::mojom::blink::XRFrameDataRequestOptionsPtr>::Read(
    ::device::mojom::blink::XRFrameDataRequestOptions::DataView input,
    ::device::mojom::blink::XRFrameDataRequestOptionsPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRFrameDataRequestOptionsPtr result(::device::mojom::blink::XRFrameDataRequestOptions::New());
  
      if (success)
        result->include_lighting_estimation_data = input.include_lighting_estimation_data();
      if (success)
        result->depth_active = input.depth_active();
      if (success)
        result->stage_parameters_id = input.stage_parameters_id();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::device::mojom::blink::XRNativeOriginInformation::DataView, ::device::mojom::blink::XRNativeOriginInformationPtr>::Read(
    ::device::mojom::blink::XRNativeOriginInformation::DataView input,
    ::device::mojom::blink::XRNativeOriginInformationPtr* output) {
  using UnionType = ::device::mojom::blink::XRNativeOriginInformation;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kInputSourceSpaceInfo: {
      ::device::mojom::blink::XRInputSourceSpaceInfoPtr result_input_source_space_info{};
      if (!input.ReadInputSourceSpaceInfo(&result_input_source_space_info))
        return false;

      *output = UnionType::NewInputSourceSpaceInfo(
          std::move(result_input_source_space_info));
      break;
    }
    case Tag::kPlaneId: {
      ::device::PlaneId result_plane_id{};
      if (!input.ReadPlaneId(&result_plane_id))
        return false;

      *output = UnionType::NewPlaneId(
          std::move(result_plane_id));
      break;
    }
    case Tag::kAnchorId: {
      ::device::AnchorId result_anchor_id{};
      if (!input.ReadAnchorId(&result_anchor_id))
        return false;

      *output = UnionType::NewAnchorId(
          std::move(result_anchor_id));
      break;
    }
    case Tag::kReferenceSpaceType: {
      ::device::mojom::blink::XRReferenceSpaceType result_reference_space_type;
      if (!input.ReadReferenceSpaceType(&result_reference_space_type))
        return false;

      *output = UnionType::NewReferenceSpaceType(result_reference_space_type);
      break;
    }
    case Tag::kHandJointSpaceInfo: {
      ::device::mojom::blink::XRHandJointSpaceInfoPtr result_hand_joint_space_info{};
      if (!input.ReadHandJointSpaceInfo(&result_hand_joint_space_info))
        return false;

      *output = UnionType::NewHandJointSpaceInfo(
          std::move(result_hand_joint_space_info));
      break;
    }
    case Tag::kImageIndex: {
      *output = UnionType::NewImageIndex(input.image_index());
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::device::mojom::blink::XRDepthData::DataView, ::device::mojom::blink::XRDepthDataPtr>::Read(
    ::device::mojom::blink::XRDepthData::DataView input,
    ::device::mojom::blink::XRDepthDataPtr* output) {
  using UnionType = ::device::mojom::blink::XRDepthData;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kDataStillValid: {
      ::device::mojom::blink::XRDepthDataStillValidPtr result_data_still_valid{};
      if (!input.ReadDataStillValid(&result_data_still_valid))
        return false;

      *output = UnionType::NewDataStillValid(
          std::move(result_data_still_valid));
      break;
    }
    case Tag::kUpdatedDepthData: {
      ::device::mojom::blink::XRDepthDataUpdatedPtr result_updated_depth_data{};
      if (!input.ReadUpdatedDepthData(&result_updated_depth_data))
        return false;

      *output = UnionType::NewUpdatedDepthData(
          std::move(result_updated_depth_data));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::device::mojom::blink::XRLayerSpecificData::DataView, ::device::mojom::blink::XRLayerSpecificDataPtr>::Read(
    ::device::mojom::blink::XRLayerSpecificData::DataView input,
    ::device::mojom::blink::XRLayerSpecificDataPtr* output) {
  using UnionType = ::device::mojom::blink::XRLayerSpecificData;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kProjection: {
      ::device::mojom::blink::XRProjectionLayerDataPtr result_projection{};
      if (!input.ReadProjection(&result_projection))
        return false;

      *output = UnionType::NewProjection(
          std::move(result_projection));
      break;
    }
    case Tag::kQuad: {
      ::device::mojom::blink::XRQuadLayerDataPtr result_quad{};
      if (!input.ReadQuad(&result_quad))
        return false;

      *output = UnionType::NewQuad(
          std::move(result_quad));
      break;
    }
    case Tag::kCylinder: {
      ::device::mojom::blink::XRCylinderLayerDataPtr result_cylinder{};
      if (!input.ReadCylinder(&result_cylinder))
        return false;

      *output = UnionType::NewCylinder(
          std::move(result_cylinder));
      break;
    }
    case Tag::kEquirect: {
      ::device::mojom::blink::XREquirectLayerDataPtr result_equirect{};
      if (!input.ReadEquirect(&result_equirect))
        return false;

      *output = UnionType::NewEquirect(
          std::move(result_equirect));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::device::mojom::blink::RequestSessionResult::DataView, ::device::mojom::blink::RequestSessionResultPtr>::Read(
    ::device::mojom::blink::RequestSessionResult::DataView input,
    ::device::mojom::blink::RequestSessionResultPtr* output) {
  using UnionType = ::device::mojom::blink::RequestSessionResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      ::device::mojom::blink::RequestSessionSuccessPtr result_success{};
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::kFailureReason: {
      ::device::mojom::blink::RequestSessionError result_failure_reason;
      if (!input.ReadFailureReason(&result_failure_reason))
        return false;

      *output = UnionType::NewFailureReason(result_failure_reason);
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device::mojom::blink {


void VRServiceInterceptorForTesting::SetClient(::mojo::PendingRemote<VRServiceClient> client) {
  GetForwardingInterface()->SetClient(
    std::move(client)
    );
}
void VRServiceInterceptorForTesting::RequestSession(::device::mojom::blink::XRSessionOptionsPtr options, RequestSessionCallback callback) {
  GetForwardingInterface()->RequestSession(
    std::move(options)
    , std::move(callback));
}
void VRServiceInterceptorForTesting::SupportsSession(::device::mojom::blink::XRSessionOptionsPtr options, SupportsSessionCallback callback) {
  GetForwardingInterface()->SupportsSession(
    std::move(options)
    , std::move(callback));
}
void VRServiceInterceptorForTesting::ExitPresent(ExitPresentCallback callback) {
  GetForwardingInterface()->ExitPresent(std::move(callback));
}
void VRServiceInterceptorForTesting::SetFramesThrottled(bool throttled) {
  GetForwardingInterface()->SetFramesThrottled(
    std::move(throttled)
    );
}
void VRServiceInterceptorForTesting::MakeXrCompatible(MakeXrCompatibleCallback callback) {
  GetForwardingInterface()->MakeXrCompatible(std::move(callback));
}
VRServiceAsyncWaiter::VRServiceAsyncWaiter(
    VRService* proxy) : proxy_(proxy) {}

VRServiceAsyncWaiter::~VRServiceAsyncWaiter() = default;


void VRServiceAsyncWaiter::RequestSession(
    ::device::mojom::blink::XRSessionOptionsPtr options, RequestSessionResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->RequestSession(
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             RequestSessionResultPtr* out_result
,
             RequestSessionResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

RequestSessionResultPtr VRServiceAsyncWaiter::RequestSession(
    ::device::mojom::blink::XRSessionOptionsPtr options) {
  RequestSessionResultPtr async_wait_result;
  RequestSession(std::move(options),&async_wait_result);
  return async_wait_result;
}

void VRServiceAsyncWaiter::SupportsSession(
    ::device::mojom::blink::XRSessionOptionsPtr options, bool* out_supports_session) {
  base::RunLoop loop;
  proxy_->SupportsSession(
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_supports_session
,
             bool supports_session) {*out_supports_session = std::move(supports_session);
            loop->Quit();
          },
          &loop,
          out_supports_session));
  loop.Run();
}

bool VRServiceAsyncWaiter::SupportsSession(
    ::device::mojom::blink::XRSessionOptionsPtr options) {
  bool async_wait_result;
  SupportsSession(std::move(options),&async_wait_result);
  return async_wait_result;
}

void VRServiceAsyncWaiter::ExitPresent(
    ) {
  base::RunLoop loop;
  proxy_->ExitPresent(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void VRServiceAsyncWaiter::MakeXrCompatible(
    XrCompatibleResult* out_xr_compatible_result) {
  base::RunLoop loop;
  proxy_->MakeXrCompatible(
      base::BindOnce(
          [](base::RunLoop* loop,
             XrCompatibleResult* out_xr_compatible_result
,
             XrCompatibleResult xr_compatible_result) {*out_xr_compatible_result = std::move(xr_compatible_result);
            loop->Quit();
          },
          &loop,
          out_xr_compatible_result));
  loop.Run();
}

XrCompatibleResult VRServiceAsyncWaiter::MakeXrCompatible(
    ) {
  XrCompatibleResult async_wait_result;
  MakeXrCompatible(&async_wait_result);
  return async_wait_result;
}




void XRSessionMetricsRecorderInterceptorForTesting::ReportFeatureUsed(::device::mojom::blink::XRSessionFeature feature) {
  GetForwardingInterface()->ReportFeatureUsed(
    std::move(feature)
    );
}
XRSessionMetricsRecorderAsyncWaiter::XRSessionMetricsRecorderAsyncWaiter(
    XRSessionMetricsRecorder* proxy) : proxy_(proxy) {}

XRSessionMetricsRecorderAsyncWaiter::~XRSessionMetricsRecorderAsyncWaiter() = default;





void VRServiceClientInterceptorForTesting::OnDeviceChanged() {
  GetForwardingInterface()->OnDeviceChanged();
}
VRServiceClientAsyncWaiter::VRServiceClientAsyncWaiter(
    VRServiceClient* proxy) : proxy_(proxy) {}

VRServiceClientAsyncWaiter::~VRServiceClientAsyncWaiter() = default;





void XREnvironmentIntegrationProviderInterceptorForTesting::SubscribeToHitTest(XRNativeOriginInformationPtr native_origin_information, const ::blink::Vector<EntityTypeForHitTest>& entity_types, XRRayPtr ray, SubscribeToHitTestCallback callback) {
  GetForwardingInterface()->SubscribeToHitTest(
    std::move(native_origin_information)
    , 
    std::move(entity_types)
    , 
    std::move(ray)
    , std::move(callback));
}
void XREnvironmentIntegrationProviderInterceptorForTesting::SubscribeToHitTestForTransientInput(const ::blink::String& profile_name, const ::blink::Vector<EntityTypeForHitTest>& entity_types, XRRayPtr ray, SubscribeToHitTestForTransientInputCallback callback) {
  GetForwardingInterface()->SubscribeToHitTestForTransientInput(
    std::move(profile_name)
    , 
    std::move(entity_types)
    , 
    std::move(ray)
    , std::move(callback));
}
void XREnvironmentIntegrationProviderInterceptorForTesting::UnsubscribeFromHitTest(const ::device::HitTestSubscriptionId& subscription_id) {
  GetForwardingInterface()->UnsubscribeFromHitTest(
    std::move(subscription_id)
    );
}
void XREnvironmentIntegrationProviderInterceptorForTesting::CreateAnchor(XRNativeOriginInformationPtr native_origin_information, const ::device::Pose& native_origin_from_anchor, const std::optional<::device::PlaneId>& plane_id, CreateAnchorCallback callback) {
  GetForwardingInterface()->CreateAnchor(
    std::move(native_origin_information)
    , 
    std::move(native_origin_from_anchor)
    , 
    std::move(plane_id)
    , std::move(callback));
}
void XREnvironmentIntegrationProviderInterceptorForTesting::DetachAnchor(const ::device::AnchorId& anchor_id) {
  GetForwardingInterface()->DetachAnchor(
    std::move(anchor_id)
    );
}
XREnvironmentIntegrationProviderAsyncWaiter::XREnvironmentIntegrationProviderAsyncWaiter(
    XREnvironmentIntegrationProvider* proxy) : proxy_(proxy) {}

XREnvironmentIntegrationProviderAsyncWaiter::~XREnvironmentIntegrationProviderAsyncWaiter() = default;


void XREnvironmentIntegrationProviderAsyncWaiter::SubscribeToHitTest(
    XRNativeOriginInformationPtr native_origin_information, const ::blink::Vector<EntityTypeForHitTest>& entity_types, XRRayPtr ray, std::optional<::device::HitTestSubscriptionId>* out_subscription_id) {
  base::RunLoop loop;
  proxy_->SubscribeToHitTest(
      std::move(native_origin_information),
      std::move(entity_types),
      std::move(ray),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::device::HitTestSubscriptionId>* out_subscription_id
,
             const std::optional<::device::HitTestSubscriptionId>& subscription_id) {*out_subscription_id = std::move(subscription_id);
            loop->Quit();
          },
          &loop,
          out_subscription_id));
  loop.Run();
}

std::optional<::device::HitTestSubscriptionId> XREnvironmentIntegrationProviderAsyncWaiter::SubscribeToHitTest(
    XRNativeOriginInformationPtr native_origin_information, const ::blink::Vector<EntityTypeForHitTest>& entity_types, XRRayPtr ray) {
  std::optional<::device::HitTestSubscriptionId> async_wait_result;
  SubscribeToHitTest(std::move(native_origin_information),std::move(entity_types),std::move(ray),&async_wait_result);
  return async_wait_result;
}

void XREnvironmentIntegrationProviderAsyncWaiter::SubscribeToHitTestForTransientInput(
    const ::blink::String& profile_name, const ::blink::Vector<EntityTypeForHitTest>& entity_types, XRRayPtr ray, std::optional<::device::HitTestSubscriptionId>* out_subscription_id) {
  base::RunLoop loop;
  proxy_->SubscribeToHitTestForTransientInput(
      std::move(profile_name),
      std::move(entity_types),
      std::move(ray),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::device::HitTestSubscriptionId>* out_subscription_id
,
             const std::optional<::device::HitTestSubscriptionId>& subscription_id) {*out_subscription_id = std::move(subscription_id);
            loop->Quit();
          },
          &loop,
          out_subscription_id));
  loop.Run();
}

std::optional<::device::HitTestSubscriptionId> XREnvironmentIntegrationProviderAsyncWaiter::SubscribeToHitTestForTransientInput(
    const ::blink::String& profile_name, const ::blink::Vector<EntityTypeForHitTest>& entity_types, XRRayPtr ray) {
  std::optional<::device::HitTestSubscriptionId> async_wait_result;
  SubscribeToHitTestForTransientInput(std::move(profile_name),std::move(entity_types),std::move(ray),&async_wait_result);
  return async_wait_result;
}

void XREnvironmentIntegrationProviderAsyncWaiter::CreateAnchor(
    XRNativeOriginInformationPtr native_origin_information, const ::device::Pose& native_origin_from_anchor, const std::optional<::device::PlaneId>& plane_id, std::optional<::device::AnchorId>* out_anchor_id) {
  base::RunLoop loop;
  proxy_->CreateAnchor(
      std::move(native_origin_information),
      std::move(native_origin_from_anchor),
      std::move(plane_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::device::AnchorId>* out_anchor_id
,
             const std::optional<::device::AnchorId>& anchor_id) {*out_anchor_id = std::move(anchor_id);
            loop->Quit();
          },
          &loop,
          out_anchor_id));
  loop.Run();
}

std::optional<::device::AnchorId> XREnvironmentIntegrationProviderAsyncWaiter::CreateAnchor(
    XRNativeOriginInformationPtr native_origin_information, const ::device::Pose& native_origin_from_anchor, const std::optional<::device::PlaneId>& plane_id) {
  std::optional<::device::AnchorId> async_wait_result;
  CreateAnchor(std::move(native_origin_information),std::move(native_origin_from_anchor),std::move(plane_id),&async_wait_result);
  return async_wait_result;
}




void XRFrameDataProviderInterceptorForTesting::GetFrameData(XRFrameDataRequestOptionsPtr options, GetFrameDataCallback callback) {
  GetForwardingInterface()->GetFrameData(
    std::move(options)
    , std::move(callback));
}
void XRFrameDataProviderInterceptorForTesting::GetEnvironmentIntegrationProvider(::mojo::PendingAssociatedReceiver<XREnvironmentIntegrationProvider> environment_provider) {
  GetForwardingInterface()->GetEnvironmentIntegrationProvider(
    std::move(environment_provider)
    );
}
XRFrameDataProviderAsyncWaiter::XRFrameDataProviderAsyncWaiter(
    XRFrameDataProvider* proxy) : proxy_(proxy) {}

XRFrameDataProviderAsyncWaiter::~XRFrameDataProviderAsyncWaiter() = default;


void XRFrameDataProviderAsyncWaiter::GetFrameData(
    XRFrameDataRequestOptionsPtr options, XRFrameDataPtr* out_frame_data) {
  base::RunLoop loop;
  proxy_->GetFrameData(
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             XRFrameDataPtr* out_frame_data
,
             XRFrameDataPtr frame_data) {*out_frame_data = std::move(frame_data);
            loop->Quit();
          },
          &loop,
          out_frame_data));
  loop.Run();
}

XRFrameDataPtr XRFrameDataProviderAsyncWaiter::GetFrameData(
    XRFrameDataRequestOptionsPtr options) {
  XRFrameDataPtr async_wait_result;
  GetFrameData(std::move(options),&async_wait_result);
  return async_wait_result;
}




void XRPresentationProviderInterceptorForTesting::UpdateLayerBounds(int16_t frame_id, const ::gfx::RectF& left_bounds, const ::gfx::RectF& right_bounds, const ::gfx::Size& source_size) {
  GetForwardingInterface()->UpdateLayerBounds(
    std::move(frame_id)
    , 
    std::move(left_bounds)
    , 
    std::move(right_bounds)
    , 
    std::move(source_size)
    );
}
void XRPresentationProviderInterceptorForTesting::SubmitFrameMissing(int16_t frame_id, const ::gpu::SyncToken& sync_token) {
  GetForwardingInterface()->SubmitFrameMissing(
    std::move(frame_id)
    , 
    std::move(sync_token)
    );
}
void XRPresentationProviderInterceptorForTesting::SubmitFrame(int16_t frame_id, const ::gpu::MailboxHolder& mailbox_holder, ::base::TimeDelta time_waited) {
  GetForwardingInterface()->SubmitFrame(
    std::move(frame_id)
    , 
    std::move(mailbox_holder)
    , 
    std::move(time_waited)
    );
}
void XRPresentationProviderInterceptorForTesting::SubmitFrameDrawnIntoTexture(int16_t frame_id, const ::blink::Vector<::device::LayerId>& layer_ids, const ::gpu::SyncToken& sync_token, ::base::TimeDelta time_waited) {
  GetForwardingInterface()->SubmitFrameDrawnIntoTexture(
    std::move(frame_id)
    , 
    std::move(layer_ids)
    , 
    std::move(sync_token)
    , 
    std::move(time_waited)
    );
}
XRPresentationProviderAsyncWaiter::XRPresentationProviderAsyncWaiter(
    XRPresentationProvider* proxy) : proxy_(proxy) {}

XRPresentationProviderAsyncWaiter::~XRPresentationProviderAsyncWaiter() = default;





void XRPresentationClientInterceptorForTesting::OnSubmitFrameTransferred(bool success) {
  GetForwardingInterface()->OnSubmitFrameTransferred(
    std::move(success)
    );
}
void XRPresentationClientInterceptorForTesting::OnSubmitFrameRendered() {
  GetForwardingInterface()->OnSubmitFrameRendered();
}
void XRPresentationClientInterceptorForTesting::OnSubmitFrameGpuFence(::gfx::GpuFenceHandle gpu_fence_handle) {
  GetForwardingInterface()->OnSubmitFrameGpuFence(
    std::move(gpu_fence_handle)
    );
}
XRPresentationClientAsyncWaiter::XRPresentationClientAsyncWaiter(
    XRPresentationClient* proxy) : proxy_(proxy) {}

XRPresentationClientAsyncWaiter::~XRPresentationClientAsyncWaiter() = default;





void XRSessionClientInterceptorForTesting::OnExitPresent() {
  GetForwardingInterface()->OnExitPresent();
}
void XRSessionClientInterceptorForTesting::OnVisibilityStateChanged(XRVisibilityState visibility_state) {
  GetForwardingInterface()->OnVisibilityStateChanged(
    std::move(visibility_state)
    );
}
XRSessionClientAsyncWaiter::XRSessionClientAsyncWaiter(
    XRSessionClient* proxy) : proxy_(proxy) {}

XRSessionClientAsyncWaiter::~XRSessionClientAsyncWaiter() = default;





void XRLayerManagerInterceptorForTesting::CreateCompositionLayer(XRCompositionLayerDataPtr create_data, CreateCompositionLayerCallback callback) {
  GetForwardingInterface()->CreateCompositionLayer(
    std::move(create_data)
    , std::move(callback));
}
void XRLayerManagerInterceptorForTesting::DestroyCompositionLayer(const ::device::LayerId& layer_id) {
  GetForwardingInterface()->DestroyCompositionLayer(
    std::move(layer_id)
    );
}
void XRLayerManagerInterceptorForTesting::UpdateCompositionLayer(const ::device::LayerId& layer_id, XRLayerMutableDataPtr update_data) {
  GetForwardingInterface()->UpdateCompositionLayer(
    std::move(layer_id)
    , 
    std::move(update_data)
    );
}
void XRLayerManagerInterceptorForTesting::SetEnabledCompositionLayers(const ::blink::Vector<::device::LayerId>& layer_ids) {
  GetForwardingInterface()->SetEnabledCompositionLayers(
    std::move(layer_ids)
    );
}
XRLayerManagerAsyncWaiter::XRLayerManagerAsyncWaiter(
    XRLayerManager* proxy) : proxy_(proxy) {}

XRLayerManagerAsyncWaiter::~XRLayerManagerAsyncWaiter() = default;


void XRLayerManagerAsyncWaiter::CreateCompositionLayer(
    XRCompositionLayerDataPtr create_data, CreateCompositionLayerResult* out_code) {
  base::RunLoop loop;
  proxy_->CreateCompositionLayer(
      std::move(create_data),
      base::BindOnce(
          [](base::RunLoop* loop,
             CreateCompositionLayerResult* out_code
,
             CreateCompositionLayerResult code) {*out_code = std::move(code);
            loop->Quit();
          },
          &loop,
          out_code));
  loop.Run();
}

CreateCompositionLayerResult XRLayerManagerAsyncWaiter::CreateCompositionLayer(
    XRCompositionLayerDataPtr create_data) {
  CreateCompositionLayerResult async_wait_result;
  CreateCompositionLayer(std::move(create_data),&async_wait_result);
  return async_wait_result;
}




void WebXrInternalsRendererListenerInterceptorForTesting::OnFrameData(::device::mojom::blink::XrFrameStatisticsPtr xrframe_statistics) {
  GetForwardingInterface()->OnFrameData(
    std::move(xrframe_statistics)
    );
}
void WebXrInternalsRendererListenerInterceptorForTesting::OnConsoleLog(::device::mojom::blink::XrLogMessagePtr xrlogging_statistics) {
  GetForwardingInterface()->OnConsoleLog(
    std::move(xrlogging_statistics)
    );
}
WebXrInternalsRendererListenerAsyncWaiter::WebXrInternalsRendererListenerAsyncWaiter(
    WebXrInternalsRendererListener* proxy) : proxy_(proxy) {}

WebXrInternalsRendererListenerAsyncWaiter::~WebXrInternalsRendererListenerAsyncWaiter() = default;







}  // device::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif