// device/vr/public/mojom/isolated_xr_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "device/vr/public/mojom/isolated_xr_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "device/vr/public/mojom/isolated_xr_service.mojom-params-data.h"
#include "device/vr/public/mojom/isolated_xr_service.mojom-shared-message-ids.h"

#include "device/vr/public/mojom/isolated_xr_service.mojom-import-headers.h"
#include "device/vr/public/mojom/isolated_xr_service.mojom-test-utils.h"


namespace device::mojom {
XRRuntimeSessionOptions::XRRuntimeSessionOptions()
    : mode(),
      required_features(),
      optional_features(),
      render_process_id(),
      render_frame_id(),
      tracked_images(),
      depth_options(),
      trace_id() {}

XRRuntimeSessionOptions::XRRuntimeSessionOptions(
    ::device::mojom::XRSessionMode mode_in,
    std::vector<::device::mojom::XRSessionFeature> required_features_in,
    std::vector<::device::mojom::XRSessionFeature> optional_features_in,
    int32_t render_process_id_in,
    int32_t render_frame_id_in,
    std::vector<::device::mojom::XRTrackedImagePtr> tracked_images_in,
    ::device::mojom::XRDepthOptionsPtr depth_options_in,
    uint64_t trace_id_in)
    : mode(std::move(mode_in)),
      required_features(std::move(required_features_in)),
      optional_features(std::move(optional_features_in)),
      render_process_id(std::move(render_process_id_in)),
      render_frame_id(std::move(render_frame_id_in)),
      tracked_images(std::move(tracked_images_in)),
      depth_options(std::move(depth_options_in)),
      trace_id(std::move(trace_id_in)) {}

XRRuntimeSessionOptions::~XRRuntimeSessionOptions() = default;

void XRRuntimeSessionOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mode"), this->mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::device::mojom::XRSessionMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "required_features"), this->required_features,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::device::mojom::XRSessionFeature>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "optional_features"), this->optional_features,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::device::mojom::XRSessionFeature>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "render_process_id"), this->render_process_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "render_frame_id"), this->render_frame_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tracked_images"), this->tracked_images,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::device::mojom::XRTrackedImagePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "depth_options"), this->depth_options,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::device::mojom::XRDepthOptionsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trace_id"), this->trace_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRRuntimeSessionOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRRuntimeSessionResult::XRRuntimeSessionResult()
    : controller(),
      session(),
      frame_sink_id(),
      overlay() {}

XRRuntimeSessionResult::XRRuntimeSessionResult(
    ::mojo::PendingRemote<XRSessionController> controller_in,
    ::device::mojom::XRSessionPtr session_in,
    const std::optional<::viz::FrameSinkId>& frame_sink_id_in,
    ::mojo::PendingRemote<ImmersiveOverlay> overlay_in)
    : controller(std::move(controller_in)),
      session(std::move(session_in)),
      frame_sink_id(std::move(frame_sink_id_in)),
      overlay(std::move(overlay_in)) {}

XRRuntimeSessionResult::~XRRuntimeSessionResult() = default;

void XRRuntimeSessionResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "controller"), this->controller,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<XRSessionController>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "session"), this->session,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::device::mojom::XRSessionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_sink_id"), this->frame_sink_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::viz::FrameSinkId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "overlay"), this->overlay,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<ImmersiveOverlay>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRRuntimeSessionResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRDeviceData::XRDeviceData()
    : supported_features(),
      is_ar_blend_mode_supported() {}

XRDeviceData::XRDeviceData(
    std::vector<::device::mojom::XRSessionFeature> supported_features_in,
    bool is_ar_blend_mode_supported_in)
    : supported_features(std::move(supported_features_in)),
      is_ar_blend_mode_supported(std::move(is_ar_blend_mode_supported_in)) {}

XRDeviceData::~XRDeviceData() = default;

void XRDeviceData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supported_features"), this->supported_features,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::device::mojom::XRSessionFeature>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_ar_blend_mode_supported"), this->is_ar_blend_mode_supported,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRDeviceData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

XRSessionController::IPCStableHashFunction XRSessionController::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::XRSessionController>(message.name())) {
    case messages::XRSessionController::kSetFrameDataRestricted: {
      return &XRSessionController::SetFrameDataRestricted_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* XRSessionController::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::XRSessionController>(message.name())) {
      case messages::XRSessionController::kSetFrameDataRestricted:
            return "Receive device::mojom::XRSessionController::SetFrameDataRestricted";
    }
  } else {
    switch (static_cast<messages::XRSessionController>(message.name())) {
      case messages::XRSessionController::kSetFrameDataRestricted:
            return "Receive reply device::mojom::XRSessionController::SetFrameDataRestricted";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t XRSessionController::SetFrameDataRestricted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x653fc378;  // IPCStableHash for device::mojom::XRSessionController::SetFrameDataRestricted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

XRSessionControllerProxy::XRSessionControllerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void XRSessionControllerProxy::SetFrameDataRestricted(
    bool in_restricted) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XRSessionController::SetFrameDataRestricted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("restricted"), in_restricted,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRSessionController::kSetFrameDataRestricted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRSessionController_SetFrameDataRestricted_Params_Data> params(
          message);
  params.Allocate();

  params->restricted = in_restricted;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRSessionController::Name_);
  message.set_method_name("SetFrameDataRestricted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool XRSessionControllerStubDispatch::Accept(
    XRSessionController* impl,
    mojo::Message* message) {
  switch (static_cast<messages::XRSessionController>(message->header()->name)) {
    case messages::XRSessionController::kSetFrameDataRestricted: {
      DCHECK(message->is_serialized());
      internal::XRSessionController_SetFrameDataRestricted_Params_Data* params =
          reinterpret_cast<internal::XRSessionController_SetFrameDataRestricted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for XRSessionController.0
      bool success = true;
      bool p_restricted{};
      XRSessionController_SetFrameDataRestricted_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_restricted = input_data_view.restricted();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRSessionController::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFrameDataRestricted(        
        std::move(p_restricted));
      return true;
    }
  }
  return false;
}

// static
bool XRSessionControllerStubDispatch::AcceptWithResponder(
    XRSessionController* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::XRSessionController>(message->header()->name)) {
    case messages::XRSessionController::kSetFrameDataRestricted: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kXRSessionControllerValidationInfo[] = {
    { &internal::XRSessionController_SetFrameDataRestricted_Params_Data::Validate,
     nullptr /* no response */},
};

bool XRSessionControllerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::XRSessionController::Name_,
    kXRSessionControllerValidationInfo);
}

// The declaration includes the definition on other builds.

XRRuntimeEventListener::IPCStableHashFunction XRRuntimeEventListener::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::XRRuntimeEventListener>(message.name())) {
    case messages::XRRuntimeEventListener::kOnVisibilityStateChanged: {
      return &XRRuntimeEventListener::OnVisibilityStateChanged_Sym::IPCStableHash;
    }
    case messages::XRRuntimeEventListener::kOnExitPresent: {
      return &XRRuntimeEventListener::OnExitPresent_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* XRRuntimeEventListener::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::XRRuntimeEventListener>(message.name())) {
      case messages::XRRuntimeEventListener::kOnVisibilityStateChanged:
            return "Receive device::mojom::XRRuntimeEventListener::OnVisibilityStateChanged";
      case messages::XRRuntimeEventListener::kOnExitPresent:
            return "Receive device::mojom::XRRuntimeEventListener::OnExitPresent";
    }
  } else {
    switch (static_cast<messages::XRRuntimeEventListener>(message.name())) {
      case messages::XRRuntimeEventListener::kOnVisibilityStateChanged:
            return "Receive reply device::mojom::XRRuntimeEventListener::OnVisibilityStateChanged";
      case messages::XRRuntimeEventListener::kOnExitPresent:
            return "Receive reply device::mojom::XRRuntimeEventListener::OnExitPresent";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t XRRuntimeEventListener::OnVisibilityStateChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x20cfdc0d;  // IPCStableHash for device::mojom::XRRuntimeEventListener::OnVisibilityStateChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XRRuntimeEventListener::OnExitPresent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1f3a7d33;  // IPCStableHash for device::mojom::XRRuntimeEventListener::OnExitPresent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

XRRuntimeEventListenerProxy::XRRuntimeEventListenerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void XRRuntimeEventListenerProxy::OnVisibilityStateChanged(
    ::device::mojom::XRVisibilityState in_visibility_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XRRuntimeEventListener::OnVisibilityStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visibility_state"), in_visibility_state,
                        "<value of type ::device::mojom::XRVisibilityState>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRRuntimeEventListener::kOnVisibilityStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRRuntimeEventListener_OnVisibilityStateChanged_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::device::mojom::XRVisibilityState>(
    in_visibility_state,
    &params->visibility_state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRRuntimeEventListener::Name_);
  message.set_method_name("OnVisibilityStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void XRRuntimeEventListenerProxy::OnExitPresent(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::XRRuntimeEventListener::OnExitPresent");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRRuntimeEventListener::kOnExitPresent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRRuntimeEventListener_OnExitPresent_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRRuntimeEventListener::Name_);
  message.set_method_name("OnExitPresent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool XRRuntimeEventListenerStubDispatch::Accept(
    XRRuntimeEventListener* impl,
    mojo::Message* message) {
  switch (static_cast<messages::XRRuntimeEventListener>(message->header()->name)) {
    case messages::XRRuntimeEventListener::kOnVisibilityStateChanged: {
      DCHECK(message->is_serialized());
      internal::XRRuntimeEventListener_OnVisibilityStateChanged_Params_Data* params =
          reinterpret_cast<internal::XRRuntimeEventListener_OnVisibilityStateChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for XRRuntimeEventListener.0
      bool success = true;
      ::device::mojom::XRVisibilityState p_visibility_state{};
      XRRuntimeEventListener_OnVisibilityStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVisibilityState(&p_visibility_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRRuntimeEventListener::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnVisibilityStateChanged(        
        std::move(p_visibility_state));
      return true;
    }
    case messages::XRRuntimeEventListener::kOnExitPresent: {
      DCHECK(message->is_serialized());
      internal::XRRuntimeEventListener_OnExitPresent_Params_Data* params =
          reinterpret_cast<internal::XRRuntimeEventListener_OnExitPresent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for XRRuntimeEventListener.1
      bool success = true;
      XRRuntimeEventListener_OnExitPresent_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRRuntimeEventListener::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnExitPresent(        );
      return true;
    }
  }
  return false;
}

// static
bool XRRuntimeEventListenerStubDispatch::AcceptWithResponder(
    XRRuntimeEventListener* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::XRRuntimeEventListener>(message->header()->name)) {
    case messages::XRRuntimeEventListener::kOnVisibilityStateChanged: {
      break;
    }
    case messages::XRRuntimeEventListener::kOnExitPresent: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kXRRuntimeEventListenerValidationInfo[] = {
    { &internal::XRRuntimeEventListener_OnVisibilityStateChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::XRRuntimeEventListener_OnExitPresent_Params_Data::Validate,
     nullptr /* no response */},
};

bool XRRuntimeEventListenerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::XRRuntimeEventListener::Name_,
    kXRRuntimeEventListenerValidationInfo);
}

// The declaration includes the definition on other builds.

XRRuntime::IPCStableHashFunction XRRuntime::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::XRRuntime>(message.name())) {
    case messages::XRRuntime::kRequestSession: {
      return &XRRuntime::RequestSession_Sym::IPCStableHash;
    }
    case messages::XRRuntime::kShutdownSession: {
      return &XRRuntime::ShutdownSession_Sym::IPCStableHash;
    }
    case messages::XRRuntime::kListenToDeviceChanges: {
      return &XRRuntime::ListenToDeviceChanges_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* XRRuntime::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::XRRuntime>(message.name())) {
      case messages::XRRuntime::kRequestSession:
            return "Receive device::mojom::XRRuntime::RequestSession";
      case messages::XRRuntime::kShutdownSession:
            return "Receive device::mojom::XRRuntime::ShutdownSession";
      case messages::XRRuntime::kListenToDeviceChanges:
            return "Receive device::mojom::XRRuntime::ListenToDeviceChanges";
    }
  } else {
    switch (static_cast<messages::XRRuntime>(message.name())) {
      case messages::XRRuntime::kRequestSession:
            return "Receive reply device::mojom::XRRuntime::RequestSession";
      case messages::XRRuntime::kShutdownSession:
            return "Receive reply device::mojom::XRRuntime::ShutdownSession";
      case messages::XRRuntime::kListenToDeviceChanges:
            return "Receive reply device::mojom::XRRuntime::ListenToDeviceChanges";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t XRRuntime::RequestSession_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x411734b5;  // IPCStableHash for device::mojom::XRRuntime::RequestSession
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XRRuntime::ShutdownSession_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7a62bdeb;  // IPCStableHash for device::mojom::XRRuntime::ShutdownSession
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XRRuntime::ListenToDeviceChanges_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe0318f55;  // IPCStableHash for device::mojom::XRRuntime::ListenToDeviceChanges
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class XRRuntime_RequestSession_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XRRuntime_RequestSession_ForwardToCallback(
      XRRuntime::RequestSessionCallback callback
      ) : callback_(std::move(callback)) {
  }

  XRRuntime_RequestSession_ForwardToCallback(const XRRuntime_RequestSession_ForwardToCallback&) = delete;
  XRRuntime_RequestSession_ForwardToCallback& operator=(const XRRuntime_RequestSession_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  XRRuntime::RequestSessionCallback callback_;
};

class XRRuntime_ShutdownSession_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XRRuntime_ShutdownSession_ForwardToCallback(
      XRRuntime::ShutdownSessionCallback callback
      ) : callback_(std::move(callback)) {
  }

  XRRuntime_ShutdownSession_ForwardToCallback(const XRRuntime_ShutdownSession_ForwardToCallback&) = delete;
  XRRuntime_ShutdownSession_ForwardToCallback& operator=(const XRRuntime_ShutdownSession_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  XRRuntime::ShutdownSessionCallback callback_;
};

XRRuntimeProxy::XRRuntimeProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void XRRuntimeProxy::RequestSession(
    XRRuntimeSessionOptionsPtr in_options, RequestSessionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XRRuntime::RequestSession", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type XRRuntimeSessionOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRRuntime::kRequestSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRRuntime_RequestSession_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::XRRuntimeSessionOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in XRRuntime.RequestSession request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRRuntime::Name_);
  message.set_method_name("RequestSession");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRRuntime_RequestSession_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void XRRuntimeProxy::ShutdownSession(
    ShutdownSessionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::XRRuntime::ShutdownSession");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRRuntime::kShutdownSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRRuntime_ShutdownSession_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRRuntime::Name_);
  message.set_method_name("ShutdownSession");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRRuntime_ShutdownSession_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void XRRuntimeProxy::ListenToDeviceChanges(
    ::mojo::PendingAssociatedRemote<XRRuntimeEventListener> in_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XRRuntime::ListenToDeviceChanges", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener,
                        "<value of type ::mojo::PendingAssociatedRemote<XRRuntimeEventListener>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRRuntime::kListenToDeviceChanges), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRRuntime_ListenToDeviceChanges_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::device::mojom::XRRuntimeEventListenerAssociatedPtrInfoDataView>(
    in_listener,
    &params->listener,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->listener)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid listener in XRRuntime.ListenToDeviceChanges request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRRuntime::Name_);
  message.set_method_name("ListenToDeviceChanges");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class XRRuntime_RequestSession_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static XRRuntime::RequestSessionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<XRRuntime_RequestSession_ProxyToResponder> proxy(
        new XRRuntime_RequestSession_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&XRRuntime_RequestSession_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XRRuntime_RequestSession_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  XRRuntime_RequestSession_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "XRRuntime::RequestSessionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      XRRuntimeSessionResultPtr in_session);
};

bool XRRuntime_RequestSession_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XRRuntime_RequestSession_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XRRuntime_RequestSession_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for XRRuntime.0
  bool success = true;
  XRRuntimeSessionResultPtr p_session{};
  XRRuntime_RequestSession_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSession(&p_session))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRRuntime::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_session));
  }
  return true;
}

void XRRuntime_RequestSession_ProxyToResponder::Run(
    XRRuntimeSessionResultPtr in_session) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::XRRuntime::RequestSession", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session"), in_session,
                        "<value of type XRRuntimeSessionResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRRuntime::kRequestSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRRuntime_RequestSession_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->session)::BaseType> session_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::XRRuntimeSessionResultDataView>(
    in_session,
    session_fragment);

  params->session.Set(
      session_fragment.is_null() ? nullptr : session_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRRuntime::Name_);
  message.set_method_name("RequestSession");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class XRRuntime_ShutdownSession_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static XRRuntime::ShutdownSessionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<XRRuntime_ShutdownSession_ProxyToResponder> proxy(
        new XRRuntime_ShutdownSession_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&XRRuntime_ShutdownSession_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XRRuntime_ShutdownSession_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  XRRuntime_ShutdownSession_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "XRRuntime::ShutdownSessionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool XRRuntime_ShutdownSession_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XRRuntime_ShutdownSession_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XRRuntime_ShutdownSession_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for XRRuntime.1
  bool success = true;
  XRRuntime_ShutdownSession_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRRuntime::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void XRRuntime_ShutdownSession_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply device::mojom::XRRuntime::ShutdownSession");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRRuntime::kShutdownSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRRuntime_ShutdownSession_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRRuntime::Name_);
  message.set_method_name("ShutdownSession");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool XRRuntimeStubDispatch::Accept(
    XRRuntime* impl,
    mojo::Message* message) {
  switch (static_cast<messages::XRRuntime>(message->header()->name)) {
    case messages::XRRuntime::kRequestSession: {
      break;
    }
    case messages::XRRuntime::kShutdownSession: {
      break;
    }
    case messages::XRRuntime::kListenToDeviceChanges: {
      DCHECK(message->is_serialized());
      internal::XRRuntime_ListenToDeviceChanges_Params_Data* params =
          reinterpret_cast<internal::XRRuntime_ListenToDeviceChanges_Params_Data*>(
              message->mutable_payload());
      

      // Validation for XRRuntime.2
      bool success = true;
      ::mojo::PendingAssociatedRemote<XRRuntimeEventListener> p_listener{};
      XRRuntime_ListenToDeviceChanges_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRRuntime::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ListenToDeviceChanges(        
        std::move(p_listener));
      return true;
    }
  }
  return false;
}

// static
bool XRRuntimeStubDispatch::AcceptWithResponder(
    XRRuntime* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::XRRuntime>(message->header()->name)) {
    case messages::XRRuntime::kRequestSession: {
      internal::XRRuntime_RequestSession_Params_Data* params =
          reinterpret_cast<
              internal::XRRuntime_RequestSession_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for XRRuntime.0
      bool success = true;
      XRRuntimeSessionOptionsPtr p_options{};
      XRRuntime_RequestSession_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRRuntime::Name_, 0, false);
        return false;
      }
      auto callback =
          XRRuntime_RequestSession_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestSession(        
        std::move(p_options), std::move(callback));
      return true;
    }
    case messages::XRRuntime::kShutdownSession: {
      internal::XRRuntime_ShutdownSession_Params_Data* params =
          reinterpret_cast<
              internal::XRRuntime_ShutdownSession_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for XRRuntime.1
      bool success = true;
      XRRuntime_ShutdownSession_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRRuntime::Name_, 1, false);
        return false;
      }
      auto callback =
          XRRuntime_ShutdownSession_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShutdownSession(std::move(callback));
      return true;
    }
    case messages::XRRuntime::kListenToDeviceChanges: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kXRRuntimeValidationInfo[] = {
    { &internal::XRRuntime_RequestSession_Params_Data::Validate,
     &internal::XRRuntime_RequestSession_ResponseParams_Data::Validate},
    { &internal::XRRuntime_ShutdownSession_Params_Data::Validate,
     &internal::XRRuntime_ShutdownSession_ResponseParams_Data::Validate},
    { &internal::XRRuntime_ListenToDeviceChanges_Params_Data::Validate,
     nullptr /* no response */},
};

bool XRRuntimeRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::XRRuntime::Name_,
    kXRRuntimeValidationInfo);
}

bool XRRuntimeResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::device::mojom::XRRuntime::Name_,
    kXRRuntimeValidationInfo);
}
// The declaration includes the definition on other builds.

ImmersiveOverlay::IPCStableHashFunction ImmersiveOverlay::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ImmersiveOverlay>(message.name())) {
    case messages::ImmersiveOverlay::kRequestNextOverlayPose: {
      return &ImmersiveOverlay::RequestNextOverlayPose_Sym::IPCStableHash;
    }
    case messages::ImmersiveOverlay::kSubmitOverlayTexture: {
      return &ImmersiveOverlay::SubmitOverlayTexture_Sym::IPCStableHash;
    }
    case messages::ImmersiveOverlay::kSetOverlayAndWebXRVisibility: {
      return &ImmersiveOverlay::SetOverlayAndWebXRVisibility_Sym::IPCStableHash;
    }
    case messages::ImmersiveOverlay::kRequestNotificationOnWebXrSubmitted: {
      return &ImmersiveOverlay::RequestNotificationOnWebXrSubmitted_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ImmersiveOverlay::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ImmersiveOverlay>(message.name())) {
      case messages::ImmersiveOverlay::kRequestNextOverlayPose:
            return "Receive device::mojom::ImmersiveOverlay::RequestNextOverlayPose";
      case messages::ImmersiveOverlay::kSubmitOverlayTexture:
            return "Receive device::mojom::ImmersiveOverlay::SubmitOverlayTexture";
      case messages::ImmersiveOverlay::kSetOverlayAndWebXRVisibility:
            return "Receive device::mojom::ImmersiveOverlay::SetOverlayAndWebXRVisibility";
      case messages::ImmersiveOverlay::kRequestNotificationOnWebXrSubmitted:
            return "Receive device::mojom::ImmersiveOverlay::RequestNotificationOnWebXrSubmitted";
    }
  } else {
    switch (static_cast<messages::ImmersiveOverlay>(message.name())) {
      case messages::ImmersiveOverlay::kRequestNextOverlayPose:
            return "Receive reply device::mojom::ImmersiveOverlay::RequestNextOverlayPose";
      case messages::ImmersiveOverlay::kSubmitOverlayTexture:
            return "Receive reply device::mojom::ImmersiveOverlay::SubmitOverlayTexture";
      case messages::ImmersiveOverlay::kSetOverlayAndWebXRVisibility:
            return "Receive reply device::mojom::ImmersiveOverlay::SetOverlayAndWebXRVisibility";
      case messages::ImmersiveOverlay::kRequestNotificationOnWebXrSubmitted:
            return "Receive reply device::mojom::ImmersiveOverlay::RequestNotificationOnWebXrSubmitted";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ImmersiveOverlay::RequestNextOverlayPose_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xccc6fdab;  // IPCStableHash for device::mojom::ImmersiveOverlay::RequestNextOverlayPose
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ImmersiveOverlay::SubmitOverlayTexture_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x67fec9b2;  // IPCStableHash for device::mojom::ImmersiveOverlay::SubmitOverlayTexture
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ImmersiveOverlay::SetOverlayAndWebXRVisibility_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdaaa4289;  // IPCStableHash for device::mojom::ImmersiveOverlay::SetOverlayAndWebXRVisibility
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ImmersiveOverlay::RequestNotificationOnWebXrSubmitted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5b5d902f;  // IPCStableHash for device::mojom::ImmersiveOverlay::RequestNotificationOnWebXrSubmitted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ImmersiveOverlay_RequestNextOverlayPose_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ImmersiveOverlay_RequestNextOverlayPose_ForwardToCallback(
      ImmersiveOverlay::RequestNextOverlayPoseCallback callback
      ) : callback_(std::move(callback)) {
  }

  ImmersiveOverlay_RequestNextOverlayPose_ForwardToCallback(const ImmersiveOverlay_RequestNextOverlayPose_ForwardToCallback&) = delete;
  ImmersiveOverlay_RequestNextOverlayPose_ForwardToCallback& operator=(const ImmersiveOverlay_RequestNextOverlayPose_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ImmersiveOverlay::RequestNextOverlayPoseCallback callback_;
};

class ImmersiveOverlay_SubmitOverlayTexture_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ImmersiveOverlay_SubmitOverlayTexture_ForwardToCallback(
      ImmersiveOverlay::SubmitOverlayTextureCallback callback
      ) : callback_(std::move(callback)) {
  }

  ImmersiveOverlay_SubmitOverlayTexture_ForwardToCallback(const ImmersiveOverlay_SubmitOverlayTexture_ForwardToCallback&) = delete;
  ImmersiveOverlay_SubmitOverlayTexture_ForwardToCallback& operator=(const ImmersiveOverlay_SubmitOverlayTexture_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ImmersiveOverlay::SubmitOverlayTextureCallback callback_;
};

class ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ForwardToCallback(
      ImmersiveOverlay::RequestNotificationOnWebXrSubmittedCallback callback
      ) : callback_(std::move(callback)) {
  }

  ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ForwardToCallback(const ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ForwardToCallback&) = delete;
  ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ForwardToCallback& operator=(const ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ImmersiveOverlay::RequestNotificationOnWebXrSubmittedCallback callback_;
};

ImmersiveOverlayProxy::ImmersiveOverlayProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ImmersiveOverlayProxy::RequestNextOverlayPose(
    RequestNextOverlayPoseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::ImmersiveOverlay::RequestNextOverlayPose");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ImmersiveOverlay::kRequestNextOverlayPose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::ImmersiveOverlay_RequestNextOverlayPose_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImmersiveOverlay::Name_);
  message.set_method_name("RequestNextOverlayPose");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ImmersiveOverlay_RequestNextOverlayPose_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ImmersiveOverlayProxy::SubmitOverlayTexture(
    int16_t in_frame_id, ::gfx::GpuMemoryBufferHandle in_texture, const ::gpu::SyncToken& in_sync_token, const ::gfx::RectF& in_left_bounds, const ::gfx::RectF& in_right_bounds, SubmitOverlayTextureCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::ImmersiveOverlay::SubmitOverlayTexture", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_id"), in_frame_id,
                        "<value of type int16_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("texture"), in_texture,
                        "<value of type ::gfx::GpuMemoryBufferHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sync_token"), in_sync_token,
                        "<value of type const ::gpu::SyncToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("left_bounds"), in_left_bounds,
                        "<value of type const ::gfx::RectF&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("right_bounds"), in_right_bounds,
                        "<value of type const ::gfx::RectF&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ImmersiveOverlay::kSubmitOverlayTexture), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::ImmersiveOverlay_SubmitOverlayTexture_Params_Data> params(
          message);
  params.Allocate();

  params->frame_id = in_frame_id;
  mojo::internal::MessageFragment<
      typename decltype(params->texture)::BaseType> texture_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferHandleDataView>(
    in_texture,
    texture_fragment);

  params->texture.Set(
      texture_fragment.is_null() ? nullptr : texture_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->texture.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null texture in ImmersiveOverlay.SubmitOverlayTexture request");
  mojo::internal::MessageFragment<
      typename decltype(params->sync_token)::BaseType> sync_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView>(
    in_sync_token,
    sync_token_fragment);

  params->sync_token.Set(
      sync_token_fragment.is_null() ? nullptr : sync_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->sync_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null sync_token in ImmersiveOverlay.SubmitOverlayTexture request");
  mojo::internal::MessageFragment<
      typename decltype(params->left_bounds)::BaseType> left_bounds_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
    in_left_bounds,
    left_bounds_fragment);

  params->left_bounds.Set(
      left_bounds_fragment.is_null() ? nullptr : left_bounds_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->left_bounds.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null left_bounds in ImmersiveOverlay.SubmitOverlayTexture request");
  mojo::internal::MessageFragment<
      typename decltype(params->right_bounds)::BaseType> right_bounds_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
    in_right_bounds,
    right_bounds_fragment);

  params->right_bounds.Set(
      right_bounds_fragment.is_null() ? nullptr : right_bounds_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->right_bounds.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null right_bounds in ImmersiveOverlay.SubmitOverlayTexture request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImmersiveOverlay::Name_);
  message.set_method_name("SubmitOverlayTexture");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ImmersiveOverlay_SubmitOverlayTexture_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ImmersiveOverlayProxy::SetOverlayAndWebXRVisibility(
    bool in_overlay_visible, bool in_webxr_visible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::ImmersiveOverlay::SetOverlayAndWebXRVisibility", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("overlay_visible"), in_overlay_visible,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("webxr_visible"), in_webxr_visible,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ImmersiveOverlay::kSetOverlayAndWebXRVisibility), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::ImmersiveOverlay_SetOverlayAndWebXRVisibility_Params_Data> params(
          message);
  params.Allocate();

  params->overlay_visible = in_overlay_visible;

  params->webxr_visible = in_webxr_visible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImmersiveOverlay::Name_);
  message.set_method_name("SetOverlayAndWebXRVisibility");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ImmersiveOverlayProxy::RequestNotificationOnWebXrSubmitted(
    RequestNotificationOnWebXrSubmittedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::ImmersiveOverlay::RequestNotificationOnWebXrSubmitted");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ImmersiveOverlay::kRequestNotificationOnWebXrSubmitted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImmersiveOverlay::Name_);
  message.set_method_name("RequestNotificationOnWebXrSubmitted");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ImmersiveOverlay_RequestNextOverlayPose_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ImmersiveOverlay::RequestNextOverlayPoseCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ImmersiveOverlay_RequestNextOverlayPose_ProxyToResponder> proxy(
        new ImmersiveOverlay_RequestNextOverlayPose_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ImmersiveOverlay_RequestNextOverlayPose_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ImmersiveOverlay_RequestNextOverlayPose_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ImmersiveOverlay_RequestNextOverlayPose_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ImmersiveOverlay::RequestNextOverlayPoseCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::device::mojom::XRRenderInfoPtr in_render_info);
};

bool ImmersiveOverlay_RequestNextOverlayPose_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ImmersiveOverlay_RequestNextOverlayPose_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ImmersiveOverlay_RequestNextOverlayPose_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ImmersiveOverlay.0
  bool success = true;
  ::device::mojom::XRRenderInfoPtr p_render_info{};
  ImmersiveOverlay_RequestNextOverlayPose_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadRenderInfo(&p_render_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ImmersiveOverlay::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_render_info));
  }
  return true;
}

void ImmersiveOverlay_RequestNextOverlayPose_ProxyToResponder::Run(
    ::device::mojom::XRRenderInfoPtr in_render_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::ImmersiveOverlay::RequestNextOverlayPose", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("render_info"), in_render_info,
                        "<value of type ::device::mojom::XRRenderInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ImmersiveOverlay::kRequestNextOverlayPose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::ImmersiveOverlay_RequestNextOverlayPose_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->render_info)::BaseType> render_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::XRRenderInfoDataView>(
    in_render_info,
    render_info_fragment);

  params->render_info.Set(
      render_info_fragment.is_null() ? nullptr : render_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->render_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null render_info in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImmersiveOverlay::Name_);
  message.set_method_name("RequestNextOverlayPose");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ImmersiveOverlay_SubmitOverlayTexture_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ImmersiveOverlay::SubmitOverlayTextureCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ImmersiveOverlay_SubmitOverlayTexture_ProxyToResponder> proxy(
        new ImmersiveOverlay_SubmitOverlayTexture_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ImmersiveOverlay_SubmitOverlayTexture_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ImmersiveOverlay_SubmitOverlayTexture_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ImmersiveOverlay_SubmitOverlayTexture_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ImmersiveOverlay::SubmitOverlayTextureCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool ImmersiveOverlay_SubmitOverlayTexture_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ImmersiveOverlay_SubmitOverlayTexture_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ImmersiveOverlay_SubmitOverlayTexture_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ImmersiveOverlay.1
  bool success = true;
  bool p_success{};
  ImmersiveOverlay_SubmitOverlayTexture_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ImmersiveOverlay::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void ImmersiveOverlay_SubmitOverlayTexture_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::ImmersiveOverlay::SubmitOverlayTexture", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ImmersiveOverlay::kSubmitOverlayTexture), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::ImmersiveOverlay_SubmitOverlayTexture_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImmersiveOverlay::Name_);
  message.set_method_name("SubmitOverlayTexture");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ImmersiveOverlay::RequestNotificationOnWebXrSubmittedCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ProxyToResponder> proxy(
        new ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ImmersiveOverlay::RequestNotificationOnWebXrSubmittedCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ImmersiveOverlay.3
  bool success = true;
  ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ImmersiveOverlay::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply device::mojom::ImmersiveOverlay::RequestNotificationOnWebXrSubmitted");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ImmersiveOverlay::kRequestNotificationOnWebXrSubmitted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImmersiveOverlay::Name_);
  message.set_method_name("RequestNotificationOnWebXrSubmitted");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ImmersiveOverlayStubDispatch::Accept(
    ImmersiveOverlay* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ImmersiveOverlay>(message->header()->name)) {
    case messages::ImmersiveOverlay::kRequestNextOverlayPose: {
      break;
    }
    case messages::ImmersiveOverlay::kSubmitOverlayTexture: {
      break;
    }
    case messages::ImmersiveOverlay::kSetOverlayAndWebXRVisibility: {
      DCHECK(message->is_serialized());
      internal::ImmersiveOverlay_SetOverlayAndWebXRVisibility_Params_Data* params =
          reinterpret_cast<internal::ImmersiveOverlay_SetOverlayAndWebXRVisibility_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ImmersiveOverlay.2
      bool success = true;
      bool p_overlay_visible{};
      bool p_webxr_visible{};
      ImmersiveOverlay_SetOverlayAndWebXRVisibility_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_overlay_visible = input_data_view.overlay_visible();
      if (success)
        p_webxr_visible = input_data_view.webxr_visible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ImmersiveOverlay::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetOverlayAndWebXRVisibility(        
        std::move(p_overlay_visible), 
        std::move(p_webxr_visible));
      return true;
    }
    case messages::ImmersiveOverlay::kRequestNotificationOnWebXrSubmitted: {
      break;
    }
  }
  return false;
}

// static
bool ImmersiveOverlayStubDispatch::AcceptWithResponder(
    ImmersiveOverlay* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ImmersiveOverlay>(message->header()->name)) {
    case messages::ImmersiveOverlay::kRequestNextOverlayPose: {
      internal::ImmersiveOverlay_RequestNextOverlayPose_Params_Data* params =
          reinterpret_cast<
              internal::ImmersiveOverlay_RequestNextOverlayPose_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ImmersiveOverlay.0
      bool success = true;
      ImmersiveOverlay_RequestNextOverlayPose_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ImmersiveOverlay::Name_, 0, false);
        return false;
      }
      auto callback =
          ImmersiveOverlay_RequestNextOverlayPose_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestNextOverlayPose(std::move(callback));
      return true;
    }
    case messages::ImmersiveOverlay::kSubmitOverlayTexture: {
      internal::ImmersiveOverlay_SubmitOverlayTexture_Params_Data* params =
          reinterpret_cast<
              internal::ImmersiveOverlay_SubmitOverlayTexture_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ImmersiveOverlay.1
      bool success = true;
      int16_t p_frame_id{};
      ::gfx::GpuMemoryBufferHandle p_texture{};
      ::gpu::SyncToken p_sync_token{};
      ::gfx::RectF p_left_bounds{};
      ::gfx::RectF p_right_bounds{};
      ImmersiveOverlay_SubmitOverlayTexture_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frame_id = input_data_view.frame_id();
      if (success && !input_data_view.ReadTexture(&p_texture))
        success = false;
      if (success && !input_data_view.ReadSyncToken(&p_sync_token))
        success = false;
      if (success && !input_data_view.ReadLeftBounds(&p_left_bounds))
        success = false;
      if (success && !input_data_view.ReadRightBounds(&p_right_bounds))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ImmersiveOverlay::Name_, 1, false);
        return false;
      }
      auto callback =
          ImmersiveOverlay_SubmitOverlayTexture_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubmitOverlayTexture(        
        std::move(p_frame_id), 
        std::move(p_texture), 
        std::move(p_sync_token), 
        std::move(p_left_bounds), 
        std::move(p_right_bounds), std::move(callback));
      return true;
    }
    case messages::ImmersiveOverlay::kSetOverlayAndWebXRVisibility: {
      break;
    }
    case messages::ImmersiveOverlay::kRequestNotificationOnWebXrSubmitted: {
      internal::ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_Params_Data* params =
          reinterpret_cast<
              internal::ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ImmersiveOverlay.3
      bool success = true;
      ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ImmersiveOverlay::Name_, 3, false);
        return false;
      }
      auto callback =
          ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestNotificationOnWebXrSubmitted(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kImmersiveOverlayValidationInfo[] = {
    { &internal::ImmersiveOverlay_RequestNextOverlayPose_Params_Data::Validate,
     &internal::ImmersiveOverlay_RequestNextOverlayPose_ResponseParams_Data::Validate},
    { &internal::ImmersiveOverlay_SubmitOverlayTexture_Params_Data::Validate,
     &internal::ImmersiveOverlay_SubmitOverlayTexture_ResponseParams_Data::Validate},
    { &internal::ImmersiveOverlay_SetOverlayAndWebXRVisibility_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_Params_Data::Validate,
     &internal::ImmersiveOverlay_RequestNotificationOnWebXrSubmitted_ResponseParams_Data::Validate},
};

bool ImmersiveOverlayRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::ImmersiveOverlay::Name_,
    kImmersiveOverlayValidationInfo);
}

bool ImmersiveOverlayResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::device::mojom::ImmersiveOverlay::Name_,
    kImmersiveOverlayValidationInfo);
}
// The declaration includes the definition on other builds.

IsolatedXRRuntimeProviderClient::IPCStableHashFunction IsolatedXRRuntimeProviderClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::IsolatedXRRuntimeProviderClient>(message.name())) {
    case messages::IsolatedXRRuntimeProviderClient::kOnDeviceAdded: {
      return &IsolatedXRRuntimeProviderClient::OnDeviceAdded_Sym::IPCStableHash;
    }
    case messages::IsolatedXRRuntimeProviderClient::kOnDeviceRemoved: {
      return &IsolatedXRRuntimeProviderClient::OnDeviceRemoved_Sym::IPCStableHash;
    }
    case messages::IsolatedXRRuntimeProviderClient::kOnDevicesEnumerated: {
      return &IsolatedXRRuntimeProviderClient::OnDevicesEnumerated_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* IsolatedXRRuntimeProviderClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::IsolatedXRRuntimeProviderClient>(message.name())) {
      case messages::IsolatedXRRuntimeProviderClient::kOnDeviceAdded:
            return "Receive device::mojom::IsolatedXRRuntimeProviderClient::OnDeviceAdded";
      case messages::IsolatedXRRuntimeProviderClient::kOnDeviceRemoved:
            return "Receive device::mojom::IsolatedXRRuntimeProviderClient::OnDeviceRemoved";
      case messages::IsolatedXRRuntimeProviderClient::kOnDevicesEnumerated:
            return "Receive device::mojom::IsolatedXRRuntimeProviderClient::OnDevicesEnumerated";
    }
  } else {
    switch (static_cast<messages::IsolatedXRRuntimeProviderClient>(message.name())) {
      case messages::IsolatedXRRuntimeProviderClient::kOnDeviceAdded:
            return "Receive reply device::mojom::IsolatedXRRuntimeProviderClient::OnDeviceAdded";
      case messages::IsolatedXRRuntimeProviderClient::kOnDeviceRemoved:
            return "Receive reply device::mojom::IsolatedXRRuntimeProviderClient::OnDeviceRemoved";
      case messages::IsolatedXRRuntimeProviderClient::kOnDevicesEnumerated:
            return "Receive reply device::mojom::IsolatedXRRuntimeProviderClient::OnDevicesEnumerated";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t IsolatedXRRuntimeProviderClient::OnDeviceAdded_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x602bf3af;  // IPCStableHash for device::mojom::IsolatedXRRuntimeProviderClient::OnDeviceAdded
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IsolatedXRRuntimeProviderClient::OnDeviceRemoved_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7e559718;  // IPCStableHash for device::mojom::IsolatedXRRuntimeProviderClient::OnDeviceRemoved
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IsolatedXRRuntimeProviderClient::OnDevicesEnumerated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2ae70ea0;  // IPCStableHash for device::mojom::IsolatedXRRuntimeProviderClient::OnDevicesEnumerated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

IsolatedXRRuntimeProviderClientProxy::IsolatedXRRuntimeProviderClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void IsolatedXRRuntimeProviderClientProxy::OnDeviceAdded(
    ::mojo::PendingRemote<XRRuntime> in_runtime, XRDeviceDataPtr in_device_data, ::device::mojom::XRDeviceId in_device_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::IsolatedXRRuntimeProviderClient::OnDeviceAdded", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("runtime"), in_runtime,
                        "<value of type ::mojo::PendingRemote<XRRuntime>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_data"), in_device_data,
                        "<value of type XRDeviceDataPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type ::device::mojom::XRDeviceId>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IsolatedXRRuntimeProviderClient::kOnDeviceAdded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::IsolatedXRRuntimeProviderClient_OnDeviceAdded_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::XRRuntimeInterfaceBase>>(
    in_runtime,
    &params->runtime,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->runtime)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid runtime in IsolatedXRRuntimeProviderClient.OnDeviceAdded request");
  mojo::internal::MessageFragment<
      typename decltype(params->device_data)::BaseType> device_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::XRDeviceDataDataView>(
    in_device_data,
    device_data_fragment);

  params->device_data.Set(
      device_data_fragment.is_null() ? nullptr : device_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_data in IsolatedXRRuntimeProviderClient.OnDeviceAdded request");

  
  mojo::internal::Serialize<::device::mojom::XRDeviceId>(
    in_device_id,
    &params->device_id);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IsolatedXRRuntimeProviderClient::Name_);
  message.set_method_name("OnDeviceAdded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void IsolatedXRRuntimeProviderClientProxy::OnDeviceRemoved(
    ::device::mojom::XRDeviceId in_device_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::IsolatedXRRuntimeProviderClient::OnDeviceRemoved", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_index"), in_device_index,
                        "<value of type ::device::mojom::XRDeviceId>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IsolatedXRRuntimeProviderClient::kOnDeviceRemoved), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::IsolatedXRRuntimeProviderClient_OnDeviceRemoved_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::device::mojom::XRDeviceId>(
    in_device_index,
    &params->device_index);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IsolatedXRRuntimeProviderClient::Name_);
  message.set_method_name("OnDeviceRemoved");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void IsolatedXRRuntimeProviderClientProxy::OnDevicesEnumerated(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::IsolatedXRRuntimeProviderClient::OnDevicesEnumerated");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IsolatedXRRuntimeProviderClient::kOnDevicesEnumerated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::IsolatedXRRuntimeProviderClient_OnDevicesEnumerated_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IsolatedXRRuntimeProviderClient::Name_);
  message.set_method_name("OnDevicesEnumerated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool IsolatedXRRuntimeProviderClientStubDispatch::Accept(
    IsolatedXRRuntimeProviderClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::IsolatedXRRuntimeProviderClient>(message->header()->name)) {
    case messages::IsolatedXRRuntimeProviderClient::kOnDeviceAdded: {
      DCHECK(message->is_serialized());
      internal::IsolatedXRRuntimeProviderClient_OnDeviceAdded_Params_Data* params =
          reinterpret_cast<internal::IsolatedXRRuntimeProviderClient_OnDeviceAdded_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IsolatedXRRuntimeProviderClient.0
      bool success = true;
      ::mojo::PendingRemote<XRRuntime> p_runtime{};
      XRDeviceDataPtr p_device_data{};
      ::device::mojom::XRDeviceId p_device_id{};
      IsolatedXRRuntimeProviderClient_OnDeviceAdded_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_runtime =
            input_data_view.TakeRuntime<decltype(p_runtime)>();
      }
      if (success && !input_data_view.ReadDeviceData(&p_device_data))
        success = false;
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IsolatedXRRuntimeProviderClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDeviceAdded(        
        std::move(p_runtime), 
        std::move(p_device_data), 
        std::move(p_device_id));
      return true;
    }
    case messages::IsolatedXRRuntimeProviderClient::kOnDeviceRemoved: {
      DCHECK(message->is_serialized());
      internal::IsolatedXRRuntimeProviderClient_OnDeviceRemoved_Params_Data* params =
          reinterpret_cast<internal::IsolatedXRRuntimeProviderClient_OnDeviceRemoved_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IsolatedXRRuntimeProviderClient.1
      bool success = true;
      ::device::mojom::XRDeviceId p_device_index{};
      IsolatedXRRuntimeProviderClient_OnDeviceRemoved_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceIndex(&p_device_index))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IsolatedXRRuntimeProviderClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDeviceRemoved(        
        std::move(p_device_index));
      return true;
    }
    case messages::IsolatedXRRuntimeProviderClient::kOnDevicesEnumerated: {
      DCHECK(message->is_serialized());
      internal::IsolatedXRRuntimeProviderClient_OnDevicesEnumerated_Params_Data* params =
          reinterpret_cast<internal::IsolatedXRRuntimeProviderClient_OnDevicesEnumerated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IsolatedXRRuntimeProviderClient.2
      bool success = true;
      IsolatedXRRuntimeProviderClient_OnDevicesEnumerated_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IsolatedXRRuntimeProviderClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDevicesEnumerated(        );
      return true;
    }
  }
  return false;
}

// static
bool IsolatedXRRuntimeProviderClientStubDispatch::AcceptWithResponder(
    IsolatedXRRuntimeProviderClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::IsolatedXRRuntimeProviderClient>(message->header()->name)) {
    case messages::IsolatedXRRuntimeProviderClient::kOnDeviceAdded: {
      break;
    }
    case messages::IsolatedXRRuntimeProviderClient::kOnDeviceRemoved: {
      break;
    }
    case messages::IsolatedXRRuntimeProviderClient::kOnDevicesEnumerated: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kIsolatedXRRuntimeProviderClientValidationInfo[] = {
    { &internal::IsolatedXRRuntimeProviderClient_OnDeviceAdded_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::IsolatedXRRuntimeProviderClient_OnDeviceRemoved_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::IsolatedXRRuntimeProviderClient_OnDevicesEnumerated_Params_Data::Validate,
     nullptr /* no response */},
};

bool IsolatedXRRuntimeProviderClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::IsolatedXRRuntimeProviderClient::Name_,
    kIsolatedXRRuntimeProviderClientValidationInfo);
}

// The declaration includes the definition on other builds.

IsolatedXRRuntimeProvider::IPCStableHashFunction IsolatedXRRuntimeProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::IsolatedXRRuntimeProvider>(message.name())) {
    case messages::IsolatedXRRuntimeProvider::kRequestDevices: {
      return &IsolatedXRRuntimeProvider::RequestDevices_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* IsolatedXRRuntimeProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::IsolatedXRRuntimeProvider>(message.name())) {
      case messages::IsolatedXRRuntimeProvider::kRequestDevices:
            return "Receive device::mojom::IsolatedXRRuntimeProvider::RequestDevices";
    }
  } else {
    switch (static_cast<messages::IsolatedXRRuntimeProvider>(message.name())) {
      case messages::IsolatedXRRuntimeProvider::kRequestDevices:
            return "Receive reply device::mojom::IsolatedXRRuntimeProvider::RequestDevices";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t IsolatedXRRuntimeProvider::RequestDevices_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x78ea71c8;  // IPCStableHash for device::mojom::IsolatedXRRuntimeProvider::RequestDevices
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

IsolatedXRRuntimeProviderProxy::IsolatedXRRuntimeProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void IsolatedXRRuntimeProviderProxy::RequestDevices(
    ::mojo::PendingRemote<IsolatedXRRuntimeProviderClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::IsolatedXRRuntimeProvider::RequestDevices", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<IsolatedXRRuntimeProviderClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IsolatedXRRuntimeProvider::kRequestDevices), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::IsolatedXRRuntimeProvider_RequestDevices_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::IsolatedXRRuntimeProviderClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in IsolatedXRRuntimeProvider.RequestDevices request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IsolatedXRRuntimeProvider::Name_);
  message.set_method_name("RequestDevices");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool IsolatedXRRuntimeProviderStubDispatch::Accept(
    IsolatedXRRuntimeProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::IsolatedXRRuntimeProvider>(message->header()->name)) {
    case messages::IsolatedXRRuntimeProvider::kRequestDevices: {
      DCHECK(message->is_serialized());
      internal::IsolatedXRRuntimeProvider_RequestDevices_Params_Data* params =
          reinterpret_cast<internal::IsolatedXRRuntimeProvider_RequestDevices_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IsolatedXRRuntimeProvider.0
      bool success = true;
      ::mojo::PendingRemote<IsolatedXRRuntimeProviderClient> p_client{};
      IsolatedXRRuntimeProvider_RequestDevices_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IsolatedXRRuntimeProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestDevices(        
        std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool IsolatedXRRuntimeProviderStubDispatch::AcceptWithResponder(
    IsolatedXRRuntimeProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::IsolatedXRRuntimeProvider>(message->header()->name)) {
    case messages::IsolatedXRRuntimeProvider::kRequestDevices: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kIsolatedXRRuntimeProviderValidationInfo[] = {
    { &internal::IsolatedXRRuntimeProvider_RequestDevices_Params_Data::Validate,
     nullptr /* no response */},
};

bool IsolatedXRRuntimeProviderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::IsolatedXRRuntimeProvider::Name_,
    kIsolatedXRRuntimeProviderValidationInfo);
}

// The declaration includes the definition on other builds.

XRDeviceService::IPCStableHashFunction XRDeviceService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::XRDeviceService>(message.name())) {
    case messages::XRDeviceService::kBindRuntimeProvider: {
      return &XRDeviceService::BindRuntimeProvider_Sym::IPCStableHash;
    }
    case messages::XRDeviceService::kBindTestHook: {
      return &XRDeviceService::BindTestHook_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* XRDeviceService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::XRDeviceService>(message.name())) {
      case messages::XRDeviceService::kBindRuntimeProvider:
            return "Receive device::mojom::XRDeviceService::BindRuntimeProvider";
      case messages::XRDeviceService::kBindTestHook:
            return "Receive device::mojom::XRDeviceService::BindTestHook";
    }
  } else {
    switch (static_cast<messages::XRDeviceService>(message.name())) {
      case messages::XRDeviceService::kBindRuntimeProvider:
            return "Receive reply device::mojom::XRDeviceService::BindRuntimeProvider";
      case messages::XRDeviceService::kBindTestHook:
            return "Receive reply device::mojom::XRDeviceService::BindTestHook";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t XRDeviceService::BindRuntimeProvider_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa0ec75a6;  // IPCStableHash for device::mojom::XRDeviceService::BindRuntimeProvider
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XRDeviceService::BindTestHook_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x48c2d164;  // IPCStableHash for device::mojom::XRDeviceService::BindTestHook
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

XRDeviceServiceProxy::XRDeviceServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void XRDeviceServiceProxy::BindRuntimeProvider(
    ::mojo::PendingReceiver<IsolatedXRRuntimeProvider> in_receiver, ::mojo::PendingRemote<XRDeviceServiceHost> in_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XRDeviceService::BindRuntimeProvider", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<IsolatedXRRuntimeProvider>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type ::mojo::PendingRemote<XRDeviceServiceHost>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRDeviceService::kBindRuntimeProvider), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRDeviceService_BindRuntimeProvider_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::IsolatedXRRuntimeProviderInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in XRDeviceService.BindRuntimeProvider request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::XRDeviceServiceHostInterfaceBase>>(
    in_host,
    &params->host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid host in XRDeviceService.BindRuntimeProvider request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRDeviceService::Name_);
  message.set_method_name("BindRuntimeProvider");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void XRDeviceServiceProxy::BindTestHook(
    ::mojo::PendingReceiver<::device_test::mojom::XRServiceTestHook> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XRDeviceService::BindTestHook", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device_test::mojom::XRServiceTestHook>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRDeviceService::kBindTestHook), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRDeviceService_BindTestHook_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device_test::mojom::XRServiceTestHookInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in XRDeviceService.BindTestHook request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRDeviceService::Name_);
  message.set_method_name("BindTestHook");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool XRDeviceServiceStubDispatch::Accept(
    XRDeviceService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::XRDeviceService>(message->header()->name)) {
    case messages::XRDeviceService::kBindRuntimeProvider: {
      DCHECK(message->is_serialized());
      internal::XRDeviceService_BindRuntimeProvider_Params_Data* params =
          reinterpret_cast<internal::XRDeviceService_BindRuntimeProvider_Params_Data*>(
              message->mutable_payload());
      

      // Validation for XRDeviceService.0
      bool success = true;
      ::mojo::PendingReceiver<IsolatedXRRuntimeProvider> p_receiver{};
      ::mojo::PendingRemote<XRDeviceServiceHost> p_host{};
      XRDeviceService_BindRuntimeProvider_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_host =
            input_data_view.TakeHost<decltype(p_host)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRDeviceService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindRuntimeProvider(        
        std::move(p_receiver), 
        std::move(p_host));
      return true;
    }
    case messages::XRDeviceService::kBindTestHook: {
      DCHECK(message->is_serialized());
      internal::XRDeviceService_BindTestHook_Params_Data* params =
          reinterpret_cast<internal::XRDeviceService_BindTestHook_Params_Data*>(
              message->mutable_payload());
      

      // Validation for XRDeviceService.1
      bool success = true;
      ::mojo::PendingReceiver<::device_test::mojom::XRServiceTestHook> p_receiver{};
      XRDeviceService_BindTestHook_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRDeviceService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindTestHook(        
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool XRDeviceServiceStubDispatch::AcceptWithResponder(
    XRDeviceService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::XRDeviceService>(message->header()->name)) {
    case messages::XRDeviceService::kBindRuntimeProvider: {
      break;
    }
    case messages::XRDeviceService::kBindTestHook: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kXRDeviceServiceValidationInfo[] = {
    { &internal::XRDeviceService_BindRuntimeProvider_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::XRDeviceService_BindTestHook_Params_Data::Validate,
     nullptr /* no response */},
};

bool XRDeviceServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::XRDeviceService::Name_,
    kXRDeviceServiceValidationInfo);
}

// The declaration includes the definition on other builds.

XRDeviceServiceHost::IPCStableHashFunction XRDeviceServiceHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::XRDeviceServiceHost>(message.name())) {
    case messages::XRDeviceServiceHost::kBindGpu: {
      return &XRDeviceServiceHost::BindGpu_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* XRDeviceServiceHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::XRDeviceServiceHost>(message.name())) {
      case messages::XRDeviceServiceHost::kBindGpu:
            return "Receive device::mojom::XRDeviceServiceHost::BindGpu";
    }
  } else {
    switch (static_cast<messages::XRDeviceServiceHost>(message.name())) {
      case messages::XRDeviceServiceHost::kBindGpu:
            return "Receive reply device::mojom::XRDeviceServiceHost::BindGpu";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t XRDeviceServiceHost::BindGpu_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2a307a3c;  // IPCStableHash for device::mojom::XRDeviceServiceHost::BindGpu
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

XRDeviceServiceHostProxy::XRDeviceServiceHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void XRDeviceServiceHostProxy::BindGpu(
    ::mojo::PendingReceiver<::viz::mojom::Gpu> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XRDeviceServiceHost::BindGpu", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::viz::mojom::Gpu>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRDeviceServiceHost::kBindGpu), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRDeviceServiceHost_BindGpu_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::viz::mojom::GpuInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in XRDeviceServiceHost.BindGpu request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRDeviceServiceHost::Name_);
  message.set_method_name("BindGpu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool XRDeviceServiceHostStubDispatch::Accept(
    XRDeviceServiceHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::XRDeviceServiceHost>(message->header()->name)) {
    case messages::XRDeviceServiceHost::kBindGpu: {
      DCHECK(message->is_serialized());
      internal::XRDeviceServiceHost_BindGpu_Params_Data* params =
          reinterpret_cast<internal::XRDeviceServiceHost_BindGpu_Params_Data*>(
              message->mutable_payload());
      

      // Validation for XRDeviceServiceHost.0
      bool success = true;
      ::mojo::PendingReceiver<::viz::mojom::Gpu> p_receiver{};
      XRDeviceServiceHost_BindGpu_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRDeviceServiceHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindGpu(        
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool XRDeviceServiceHostStubDispatch::AcceptWithResponder(
    XRDeviceServiceHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::XRDeviceServiceHost>(message->header()->name)) {
    case messages::XRDeviceServiceHost::kBindGpu: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kXRDeviceServiceHostValidationInfo[] = {
    { &internal::XRDeviceServiceHost_BindGpu_Params_Data::Validate,
     nullptr /* no response */},
};

bool XRDeviceServiceHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::XRDeviceServiceHost::Name_,
    kXRDeviceServiceHostValidationInfo);
}



}  // device::mojom


namespace mojo {


// static
bool StructTraits<::device::mojom::XRRuntimeSessionOptions::DataView, ::device::mojom::XRRuntimeSessionOptionsPtr>::Read(
    ::device::mojom::XRRuntimeSessionOptions::DataView input,
    ::device::mojom::XRRuntimeSessionOptionsPtr* output) {
  bool success = true;
  ::device::mojom::XRRuntimeSessionOptionsPtr result(::device::mojom::XRRuntimeSessionOptions::New());
  
      if (success && !input.ReadMode(&result->mode))
        success = false;
      if (success && !input.ReadRequiredFeatures(&result->required_features))
        success = false;
      if (success && !input.ReadOptionalFeatures(&result->optional_features))
        success = false;
      if (success)
        result->render_process_id = input.render_process_id();
      if (success)
        result->render_frame_id = input.render_frame_id();
      if (success && !input.ReadTrackedImages(&result->tracked_images))
        success = false;
      if (success && !input.ReadDepthOptions(&result->depth_options))
        success = false;
      if (success)
        result->trace_id = input.trace_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRRuntimeSessionResult::DataView, ::device::mojom::XRRuntimeSessionResultPtr>::Read(
    ::device::mojom::XRRuntimeSessionResult::DataView input,
    ::device::mojom::XRRuntimeSessionResultPtr* output) {
  bool success = true;
  ::device::mojom::XRRuntimeSessionResultPtr result(::device::mojom::XRRuntimeSessionResult::New());
  
      if (success) {
        result->controller =
            input.TakeController<decltype(result->controller)>();
      }
      if (success && !input.ReadSession(&result->session))
        success = false;
      if (success && !input.ReadFrameSinkId(&result->frame_sink_id))
        success = false;
      if (success) {
        result->overlay =
            input.TakeOverlay<decltype(result->overlay)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRDeviceData::DataView, ::device::mojom::XRDeviceDataPtr>::Read(
    ::device::mojom::XRDeviceData::DataView input,
    ::device::mojom::XRDeviceDataPtr* output) {
  bool success = true;
  ::device::mojom::XRDeviceDataPtr result(::device::mojom::XRDeviceData::New());
  
      if (success && !input.ReadSupportedFeatures(&result->supported_features))
        success = false;
      if (success)
        result->is_ar_blend_mode_supported = input.is_ar_blend_mode_supported();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device::mojom {


void XRSessionControllerInterceptorForTesting::SetFrameDataRestricted(bool restricted) {
  GetForwardingInterface()->SetFrameDataRestricted(
    std::move(restricted)
    );
}
XRSessionControllerAsyncWaiter::XRSessionControllerAsyncWaiter(
    XRSessionController* proxy) : proxy_(proxy) {}

XRSessionControllerAsyncWaiter::~XRSessionControllerAsyncWaiter() = default;





void XRRuntimeEventListenerInterceptorForTesting::OnVisibilityStateChanged(::device::mojom::XRVisibilityState visibility_state) {
  GetForwardingInterface()->OnVisibilityStateChanged(
    std::move(visibility_state)
    );
}
void XRRuntimeEventListenerInterceptorForTesting::OnExitPresent() {
  GetForwardingInterface()->OnExitPresent();
}
XRRuntimeEventListenerAsyncWaiter::XRRuntimeEventListenerAsyncWaiter(
    XRRuntimeEventListener* proxy) : proxy_(proxy) {}

XRRuntimeEventListenerAsyncWaiter::~XRRuntimeEventListenerAsyncWaiter() = default;





void XRRuntimeInterceptorForTesting::RequestSession(XRRuntimeSessionOptionsPtr options, RequestSessionCallback callback) {
  GetForwardingInterface()->RequestSession(
    std::move(options)
    , std::move(callback));
}
void XRRuntimeInterceptorForTesting::ShutdownSession(ShutdownSessionCallback callback) {
  GetForwardingInterface()->ShutdownSession(std::move(callback));
}
void XRRuntimeInterceptorForTesting::ListenToDeviceChanges(::mojo::PendingAssociatedRemote<XRRuntimeEventListener> listener) {
  GetForwardingInterface()->ListenToDeviceChanges(
    std::move(listener)
    );
}
XRRuntimeAsyncWaiter::XRRuntimeAsyncWaiter(
    XRRuntime* proxy) : proxy_(proxy) {}

XRRuntimeAsyncWaiter::~XRRuntimeAsyncWaiter() = default;


void XRRuntimeAsyncWaiter::RequestSession(
    XRRuntimeSessionOptionsPtr options, XRRuntimeSessionResultPtr* out_session) {
  base::RunLoop loop;
  proxy_->RequestSession(
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             XRRuntimeSessionResultPtr* out_session
,
             XRRuntimeSessionResultPtr session) {*out_session = std::move(session);
            loop->Quit();
          },
          &loop,
          out_session));
  loop.Run();
}

XRRuntimeSessionResultPtr XRRuntimeAsyncWaiter::RequestSession(
    XRRuntimeSessionOptionsPtr options) {
  XRRuntimeSessionResultPtr async_wait_result;
  RequestSession(std::move(options),&async_wait_result);
  return async_wait_result;
}

void XRRuntimeAsyncWaiter::ShutdownSession(
    ) {
  base::RunLoop loop;
  proxy_->ShutdownSession(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void ImmersiveOverlayInterceptorForTesting::RequestNextOverlayPose(RequestNextOverlayPoseCallback callback) {
  GetForwardingInterface()->RequestNextOverlayPose(std::move(callback));
}
void ImmersiveOverlayInterceptorForTesting::SubmitOverlayTexture(int16_t frame_id, ::gfx::GpuMemoryBufferHandle texture, const ::gpu::SyncToken& sync_token, const ::gfx::RectF& left_bounds, const ::gfx::RectF& right_bounds, SubmitOverlayTextureCallback callback) {
  GetForwardingInterface()->SubmitOverlayTexture(
    std::move(frame_id)
    , 
    std::move(texture)
    , 
    std::move(sync_token)
    , 
    std::move(left_bounds)
    , 
    std::move(right_bounds)
    , std::move(callback));
}
void ImmersiveOverlayInterceptorForTesting::SetOverlayAndWebXRVisibility(bool overlay_visible, bool webxr_visible) {
  GetForwardingInterface()->SetOverlayAndWebXRVisibility(
    std::move(overlay_visible)
    , 
    std::move(webxr_visible)
    );
}
void ImmersiveOverlayInterceptorForTesting::RequestNotificationOnWebXrSubmitted(RequestNotificationOnWebXrSubmittedCallback callback) {
  GetForwardingInterface()->RequestNotificationOnWebXrSubmitted(std::move(callback));
}
ImmersiveOverlayAsyncWaiter::ImmersiveOverlayAsyncWaiter(
    ImmersiveOverlay* proxy) : proxy_(proxy) {}

ImmersiveOverlayAsyncWaiter::~ImmersiveOverlayAsyncWaiter() = default;


void ImmersiveOverlayAsyncWaiter::RequestNextOverlayPose(
    ::device::mojom::XRRenderInfoPtr* out_render_info) {
  base::RunLoop loop;
  proxy_->RequestNextOverlayPose(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::device::mojom::XRRenderInfoPtr* out_render_info
,
             ::device::mojom::XRRenderInfoPtr render_info) {*out_render_info = std::move(render_info);
            loop->Quit();
          },
          &loop,
          out_render_info));
  loop.Run();
}

::device::mojom::XRRenderInfoPtr ImmersiveOverlayAsyncWaiter::RequestNextOverlayPose(
    ) {
  ::device::mojom::XRRenderInfoPtr async_wait_result;
  RequestNextOverlayPose(&async_wait_result);
  return async_wait_result;
}

void ImmersiveOverlayAsyncWaiter::SubmitOverlayTexture(
    int16_t frame_id, ::gfx::GpuMemoryBufferHandle texture, const ::gpu::SyncToken& sync_token, const ::gfx::RectF& left_bounds, const ::gfx::RectF& right_bounds, bool* out_success) {
  base::RunLoop loop;
  proxy_->SubmitOverlayTexture(
      std::move(frame_id),
      std::move(texture),
      std::move(sync_token),
      std::move(left_bounds),
      std::move(right_bounds),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool ImmersiveOverlayAsyncWaiter::SubmitOverlayTexture(
    int16_t frame_id, ::gfx::GpuMemoryBufferHandle texture, const ::gpu::SyncToken& sync_token, const ::gfx::RectF& left_bounds, const ::gfx::RectF& right_bounds) {
  bool async_wait_result;
  SubmitOverlayTexture(std::move(frame_id),std::move(texture),std::move(sync_token),std::move(left_bounds),std::move(right_bounds),&async_wait_result);
  return async_wait_result;
}

void ImmersiveOverlayAsyncWaiter::RequestNotificationOnWebXrSubmitted(
    ) {
  base::RunLoop loop;
  proxy_->RequestNotificationOnWebXrSubmitted(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void IsolatedXRRuntimeProviderClientInterceptorForTesting::OnDeviceAdded(::mojo::PendingRemote<XRRuntime> runtime, XRDeviceDataPtr device_data, ::device::mojom::XRDeviceId device_id) {
  GetForwardingInterface()->OnDeviceAdded(
    std::move(runtime)
    , 
    std::move(device_data)
    , 
    std::move(device_id)
    );
}
void IsolatedXRRuntimeProviderClientInterceptorForTesting::OnDeviceRemoved(::device::mojom::XRDeviceId device_index) {
  GetForwardingInterface()->OnDeviceRemoved(
    std::move(device_index)
    );
}
void IsolatedXRRuntimeProviderClientInterceptorForTesting::OnDevicesEnumerated() {
  GetForwardingInterface()->OnDevicesEnumerated();
}
IsolatedXRRuntimeProviderClientAsyncWaiter::IsolatedXRRuntimeProviderClientAsyncWaiter(
    IsolatedXRRuntimeProviderClient* proxy) : proxy_(proxy) {}

IsolatedXRRuntimeProviderClientAsyncWaiter::~IsolatedXRRuntimeProviderClientAsyncWaiter() = default;





void IsolatedXRRuntimeProviderInterceptorForTesting::RequestDevices(::mojo::PendingRemote<IsolatedXRRuntimeProviderClient> client) {
  GetForwardingInterface()->RequestDevices(
    std::move(client)
    );
}
IsolatedXRRuntimeProviderAsyncWaiter::IsolatedXRRuntimeProviderAsyncWaiter(
    IsolatedXRRuntimeProvider* proxy) : proxy_(proxy) {}

IsolatedXRRuntimeProviderAsyncWaiter::~IsolatedXRRuntimeProviderAsyncWaiter() = default;





void XRDeviceServiceInterceptorForTesting::BindRuntimeProvider(::mojo::PendingReceiver<IsolatedXRRuntimeProvider> receiver, ::mojo::PendingRemote<XRDeviceServiceHost> host) {
  GetForwardingInterface()->BindRuntimeProvider(
    std::move(receiver)
    , 
    std::move(host)
    );
}
void XRDeviceServiceInterceptorForTesting::BindTestHook(::mojo::PendingReceiver<::device_test::mojom::XRServiceTestHook> receiver) {
  GetForwardingInterface()->BindTestHook(
    std::move(receiver)
    );
}
XRDeviceServiceAsyncWaiter::XRDeviceServiceAsyncWaiter(
    XRDeviceService* proxy) : proxy_(proxy) {}

XRDeviceServiceAsyncWaiter::~XRDeviceServiceAsyncWaiter() = default;





void XRDeviceServiceHostInterceptorForTesting::BindGpu(::mojo::PendingReceiver<::viz::mojom::Gpu> receiver) {
  GetForwardingInterface()->BindGpu(
    std::move(receiver)
    );
}
XRDeviceServiceHostAsyncWaiter::XRDeviceServiceHostAsyncWaiter(
    XRDeviceServiceHost* proxy) : proxy_(proxy) {}

XRDeviceServiceHostAsyncWaiter::~XRDeviceServiceHostAsyncWaiter() = default;







}  // device::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif