// device/vr/public/mojom/isolated_xr_service.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_VR_PUBLIC_MOJOM_ISOLATED_XR_SERVICE_MOJOM_SHARED_H_
#define DEVICE_VR_PUBLIC_MOJOM_ISOLATED_XR_SERVICE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "device/vr/public/mojom/isolated_xr_service.mojom-shared-internal.h"
#include "device/vr/public/mojom/test/browser_test_interfaces.mojom-shared.h"
#include "device/vr/public/mojom/vr_service.mojom-shared.h"
#include "device/vr/public/mojom/xr_device.mojom-shared.h"
#include "device/vr/public/mojom/xr_session.mojom-shared.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom-shared.h"
#include "services/viz/public/mojom/gpu.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "device/vr/public/mojom/isolated_xr_service.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRRuntimeSessionOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRRuntimeSessionOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRRuntimeSessionOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::device::mojom::XRSessionMode>(
      Traits::mode(input),
      &fragment->mode);

    decltype(Traits::required_features(input)) in_required_features = Traits::required_features(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->required_features)::BaseType>
        required_features_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& required_features_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::XRSessionFeature_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRSessionFeature>>(
      in_required_features,
      required_features_fragment,
      &required_features_validate_params);

    fragment->required_features.Set(
        required_features_fragment.is_null() ? nullptr : required_features_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->required_features.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null required_features in XRRuntimeSessionOptions struct");

    decltype(Traits::optional_features(input)) in_optional_features = Traits::optional_features(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->optional_features)::BaseType>
        optional_features_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& optional_features_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::XRSessionFeature_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRSessionFeature>>(
      in_optional_features,
      optional_features_fragment,
      &optional_features_validate_params);

    fragment->optional_features.Set(
        optional_features_fragment.is_null() ? nullptr : optional_features_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->optional_features.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null optional_features in XRRuntimeSessionOptions struct");

    fragment->render_process_id = Traits::render_process_id(input);

    fragment->render_frame_id = Traits::render_frame_id(input);

    decltype(Traits::tracked_images(input)) in_tracked_images = Traits::tracked_images(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tracked_images)::BaseType>
        tracked_images_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& tracked_images_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRTrackedImageDataView>>(
      in_tracked_images,
      tracked_images_fragment,
      &tracked_images_validate_params);

    fragment->tracked_images.Set(
        tracked_images_fragment.is_null() ? nullptr : tracked_images_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tracked_images.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tracked_images in XRRuntimeSessionOptions struct");

    decltype(Traits::depth_options(input)) in_depth_options = Traits::depth_options(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->depth_options)::BaseType> depth_options_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::device::mojom::XRDepthOptionsDataView>(
      in_depth_options,
      depth_options_fragment);

    fragment->depth_options.Set(
        depth_options_fragment.is_null() ? nullptr : depth_options_fragment.data());

    fragment->trace_id = Traits::trace_id(input);
  }

  static bool Deserialize(::device::mojom::internal::XRRuntimeSessionOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRRuntimeSessionOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRRuntimeSessionResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRRuntimeSessionResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRRuntimeSessionResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::controller(input)) in_controller = Traits::controller(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::XRSessionControllerInterfaceBase>>(
      in_controller,
      &fragment->controller,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->controller)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid controller in XRRuntimeSessionResult struct");

    decltype(Traits::session(input)) in_session = Traits::session(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->session)::BaseType> session_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::device::mojom::XRSessionDataView>(
      in_session,
      session_fragment);

    fragment->session.Set(
        session_fragment.is_null() ? nullptr : session_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->session.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null session in XRRuntimeSessionResult struct");

    decltype(Traits::frame_sink_id(input)) in_frame_sink_id = Traits::frame_sink_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_sink_id)::BaseType> frame_sink_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
      in_frame_sink_id,
      frame_sink_id_fragment);

    fragment->frame_sink_id.Set(
        frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());

    decltype(Traits::overlay(input)) in_overlay = Traits::overlay(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::ImmersiveOverlayInterfaceBase>>(
      in_overlay,
      &fragment->overlay,
      &fragment.message());
  }

  static bool Deserialize(::device::mojom::internal::XRRuntimeSessionResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRRuntimeSessionResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRDeviceDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRDeviceDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRDeviceData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::supported_features(input)) in_supported_features = Traits::supported_features(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->supported_features)::BaseType>
        supported_features_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& supported_features_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::XRSessionFeature_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRSessionFeature>>(
      in_supported_features,
      supported_features_fragment,
      &supported_features_validate_params);

    fragment->supported_features.Set(
        supported_features_fragment.is_null() ? nullptr : supported_features_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->supported_features.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null supported_features in XRDeviceData struct");

    fragment->is_ar_blend_mode_supported = Traits::is_ar_blend_mode_supported(input);
  }

  static bool Deserialize(::device::mojom::internal::XRDeviceData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRDeviceDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace device::mojom {

inline void XRRuntimeSessionOptionsDataView::GetRequiredFeaturesDataView(
    mojo::ArrayDataView<::device::mojom::XRSessionFeature>* output) {
  auto pointer = data_->required_features.Get();
  *output = mojo::ArrayDataView<::device::mojom::XRSessionFeature>(pointer, message_);
}
inline void XRRuntimeSessionOptionsDataView::GetOptionalFeaturesDataView(
    mojo::ArrayDataView<::device::mojom::XRSessionFeature>* output) {
  auto pointer = data_->optional_features.Get();
  *output = mojo::ArrayDataView<::device::mojom::XRSessionFeature>(pointer, message_);
}
inline void XRRuntimeSessionOptionsDataView::GetTrackedImagesDataView(
    mojo::ArrayDataView<::device::mojom::XRTrackedImageDataView>* output) {
  auto pointer = data_->tracked_images.Get();
  *output = mojo::ArrayDataView<::device::mojom::XRTrackedImageDataView>(pointer, message_);
}
inline void XRRuntimeSessionOptionsDataView::GetDepthOptionsDataView(
    ::device::mojom::XRDepthOptionsDataView* output) {
  auto pointer = data_->depth_options.Get();
  *output = ::device::mojom::XRDepthOptionsDataView(pointer, message_);
}


inline void XRRuntimeSessionResultDataView::GetSessionDataView(
    ::device::mojom::XRSessionDataView* output) {
  auto pointer = data_->session.Get();
  *output = ::device::mojom::XRSessionDataView(pointer, message_);
}
inline void XRRuntimeSessionResultDataView::GetFrameSinkIdDataView(
    ::viz::mojom::FrameSinkIdDataView* output) {
  auto pointer = data_->frame_sink_id.Get();
  *output = ::viz::mojom::FrameSinkIdDataView(pointer, message_);
}


inline void XRDeviceDataDataView::GetSupportedFeaturesDataView(
    mojo::ArrayDataView<::device::mojom::XRSessionFeature>* output) {
  auto pointer = data_->supported_features.Get();
  *output = mojo::ArrayDataView<::device::mojom::XRSessionFeature>(pointer, message_);
}



}  // device::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // DEVICE_VR_PUBLIC_MOJOM_ISOLATED_XR_SERVICE_MOJOM_SHARED_H_