// device/vr/public/mojom/isolated_xr_service.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_VR_PUBLIC_MOJOM_ISOLATED_XR_SERVICE_MOJOM_DATA_VIEW_H_
#define DEVICE_VR_PUBLIC_MOJOM_ISOLATED_XR_SERVICE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "device/vr/public/mojom/isolated_xr_service.mojom-shared-internal.h"
#include "device/vr/public/mojom/test/browser_test_interfaces.mojom-shared.h"
#include "device/vr/public/mojom/vr_service.mojom-shared.h"
#include "device/vr/public/mojom/xr_device.mojom-shared.h"
#include "device/vr/public/mojom/xr_session.mojom-shared.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom-shared.h"
#include "services/viz/public/mojom/gpu.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared.h"


namespace device::mojom {
class XRRuntimeSessionOptionsDataView;

class XRRuntimeSessionResultDataView;

class XRDeviceDataDataView;



}  // device::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::device::mojom::XRRuntimeSessionOptionsDataView> {
  using Data = ::device::mojom::internal::XRRuntimeSessionOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRRuntimeSessionResultDataView> {
  using Data = ::device::mojom::internal::XRRuntimeSessionResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRDeviceDataDataView> {
  using Data = ::device::mojom::internal::XRDeviceData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace device::mojom {
// Interface base classes. They are used for type safety check.
class XRSessionControllerInterfaceBase {};

using XRSessionControllerPtrDataView =
    mojo::InterfacePtrDataView<XRSessionControllerInterfaceBase>;
using XRSessionControllerRequestDataView =
    mojo::InterfaceRequestDataView<XRSessionControllerInterfaceBase>;
using XRSessionControllerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XRSessionControllerInterfaceBase>;
using XRSessionControllerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XRSessionControllerInterfaceBase>;
class XRRuntimeEventListenerInterfaceBase {};

using XRRuntimeEventListenerPtrDataView =
    mojo::InterfacePtrDataView<XRRuntimeEventListenerInterfaceBase>;
using XRRuntimeEventListenerRequestDataView =
    mojo::InterfaceRequestDataView<XRRuntimeEventListenerInterfaceBase>;
using XRRuntimeEventListenerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XRRuntimeEventListenerInterfaceBase>;
using XRRuntimeEventListenerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XRRuntimeEventListenerInterfaceBase>;
class XRRuntimeInterfaceBase {};

using XRRuntimePtrDataView =
    mojo::InterfacePtrDataView<XRRuntimeInterfaceBase>;
using XRRuntimeRequestDataView =
    mojo::InterfaceRequestDataView<XRRuntimeInterfaceBase>;
using XRRuntimeAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XRRuntimeInterfaceBase>;
using XRRuntimeAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XRRuntimeInterfaceBase>;
class ImmersiveOverlayInterfaceBase {};

using ImmersiveOverlayPtrDataView =
    mojo::InterfacePtrDataView<ImmersiveOverlayInterfaceBase>;
using ImmersiveOverlayRequestDataView =
    mojo::InterfaceRequestDataView<ImmersiveOverlayInterfaceBase>;
using ImmersiveOverlayAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ImmersiveOverlayInterfaceBase>;
using ImmersiveOverlayAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ImmersiveOverlayInterfaceBase>;
class IsolatedXRRuntimeProviderClientInterfaceBase {};

using IsolatedXRRuntimeProviderClientPtrDataView =
    mojo::InterfacePtrDataView<IsolatedXRRuntimeProviderClientInterfaceBase>;
using IsolatedXRRuntimeProviderClientRequestDataView =
    mojo::InterfaceRequestDataView<IsolatedXRRuntimeProviderClientInterfaceBase>;
using IsolatedXRRuntimeProviderClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<IsolatedXRRuntimeProviderClientInterfaceBase>;
using IsolatedXRRuntimeProviderClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<IsolatedXRRuntimeProviderClientInterfaceBase>;
class IsolatedXRRuntimeProviderInterfaceBase {};

using IsolatedXRRuntimeProviderPtrDataView =
    mojo::InterfacePtrDataView<IsolatedXRRuntimeProviderInterfaceBase>;
using IsolatedXRRuntimeProviderRequestDataView =
    mojo::InterfaceRequestDataView<IsolatedXRRuntimeProviderInterfaceBase>;
using IsolatedXRRuntimeProviderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<IsolatedXRRuntimeProviderInterfaceBase>;
using IsolatedXRRuntimeProviderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<IsolatedXRRuntimeProviderInterfaceBase>;
class XRDeviceServiceInterfaceBase {};

using XRDeviceServicePtrDataView =
    mojo::InterfacePtrDataView<XRDeviceServiceInterfaceBase>;
using XRDeviceServiceRequestDataView =
    mojo::InterfaceRequestDataView<XRDeviceServiceInterfaceBase>;
using XRDeviceServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XRDeviceServiceInterfaceBase>;
using XRDeviceServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XRDeviceServiceInterfaceBase>;
class XRDeviceServiceHostInterfaceBase {};

using XRDeviceServiceHostPtrDataView =
    mojo::InterfacePtrDataView<XRDeviceServiceHostInterfaceBase>;
using XRDeviceServiceHostRequestDataView =
    mojo::InterfaceRequestDataView<XRDeviceServiceHostInterfaceBase>;
using XRDeviceServiceHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XRDeviceServiceHostInterfaceBase>;
using XRDeviceServiceHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XRDeviceServiceHostInterfaceBase>;


class XRRuntimeSessionOptionsDataView {
 public:
  XRRuntimeSessionOptionsDataView() = default;

  XRRuntimeSessionOptionsDataView(
      internal::XRRuntimeSessionOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::device::mojom::XRSessionMode>(
        data_value, output);
  }
  ::device::mojom::XRSessionMode mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XRSessionMode>(data_->mode));
  }
  inline void GetRequiredFeaturesDataView(
      mojo::ArrayDataView<::device::mojom::XRSessionFeature>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequiredFeatures(UserType* output) {
    
    auto* pointer = data_->required_features.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRSessionFeature>>(
        pointer, output, message_);
  }
  inline void GetOptionalFeaturesDataView(
      mojo::ArrayDataView<::device::mojom::XRSessionFeature>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOptionalFeatures(UserType* output) {
    
    auto* pointer = data_->optional_features.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRSessionFeature>>(
        pointer, output, message_);
  }
  int32_t render_process_id() const {
    return data_->render_process_id;
  }
  int32_t render_frame_id() const {
    return data_->render_frame_id;
  }
  inline void GetTrackedImagesDataView(
      mojo::ArrayDataView<::device::mojom::XRTrackedImageDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrackedImages(UserType* output) {
    
    auto* pointer = data_->tracked_images.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRTrackedImageDataView>>(
        pointer, output, message_);
  }
  inline void GetDepthOptionsDataView(
      ::device::mojom::XRDepthOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDepthOptions(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRDepthOptionsDataView, UserType>(),
    "Attempting to read the optional `depth_options` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDepthOptions` instead "
    "of `ReadDepthOptions if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->depth_options.Get();
    return mojo::internal::Deserialize<::device::mojom::XRDepthOptionsDataView>(
        pointer, output, message_);
  }
  uint64_t trace_id() const {
    return data_->trace_id;
  }
 private:
  internal::XRRuntimeSessionOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRRuntimeSessionResultDataView {
 public:
  XRRuntimeSessionResultDataView() = default;

  XRRuntimeSessionResultDataView(
      internal::XRRuntimeSessionResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeController() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::device::mojom::XRSessionControllerInterfaceBase>>(
            &data_->controller, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetSessionDataView(
      ::device::mojom::XRSessionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSession(UserType* output) {
    
    auto* pointer = data_->session.Get();
    return mojo::internal::Deserialize<::device::mojom::XRSessionDataView>(
        pointer, output, message_);
  }
  inline void GetFrameSinkIdDataView(
      ::viz::mojom::FrameSinkIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameSinkId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::viz::mojom::FrameSinkIdDataView, UserType>(),
    "Attempting to read the optional `frame_sink_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFrameSinkId` instead "
    "of `ReadFrameSinkId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->frame_sink_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::FrameSinkIdDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeOverlay() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::device::mojom::ImmersiveOverlayInterfaceBase>>(
            &data_->overlay, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::XRRuntimeSessionResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRDeviceDataDataView {
 public:
  XRDeviceDataDataView() = default;

  XRDeviceDataDataView(
      internal::XRDeviceData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSupportedFeaturesDataView(
      mojo::ArrayDataView<::device::mojom::XRSessionFeature>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupportedFeatures(UserType* output) {
    
    auto* pointer = data_->supported_features.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRSessionFeature>>(
        pointer, output, message_);
  }
  bool is_ar_blend_mode_supported() const {
    return data_->is_ar_blend_mode_supported;
  }
 private:
  internal::XRDeviceData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // device::mojom

#endif  // DEVICE_VR_PUBLIC_MOJOM_ISOLATED_XR_SERVICE_MOJOM_DATA_VIEW_H_