// device/bluetooth/public/mojom/device.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_BLUETOOTH_PUBLIC_MOJOM_DEVICE_MOJOM_SHARED_INTERNAL_H_
#define DEVICE_BLUETOOTH_PUBLIC_MOJOM_DEVICE_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "device/bluetooth/public/mojom/uuid.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace bluetooth::mojom {
namespace internal {
class RSSIWrapper_Data;
class DeviceInfo_Data;
class ServiceInfo_Data;
class CharacteristicInfo_Data;
class DescriptorInfo_Data;

struct Property_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 4:
      case 8:
      case 16:
      case 32:
      case 64:
      case 128:
      case 256:
      case 512:
      case 1024:
      case 2048:
      case 4096:
      case 8192:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct GattResult_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)
class  RSSIWrapper_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int8_t value;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<RSSIWrapper_Data>;

  RSSIWrapper_Data();
  ~RSSIWrapper_Data() = delete;
};
static_assert(sizeof(RSSIWrapper_Data) == 16,
              "Bad sizeof(RSSIWrapper_Data)");
// Used by RSSIWrapper::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct RSSIWrapper_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  RSSIWrapper_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~RSSIWrapper_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<RSSIWrapper_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    RSSIWrapper_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  DeviceInfo_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> name;
  mojo::internal::Pointer<mojo::internal::String_Data> name_for_display;
  mojo::internal::Pointer<mojo::internal::String_Data> address;
  uint8_t is_gatt_connected : 1;
  uint8_t pad3_[7];
  mojo::internal::Pointer<internal::RSSIWrapper_Data> rssi;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::bluetooth::mojom::internal::UUID_Data>>> service_uuids;
  mojo::internal::Pointer<mojo::internal::Map_Data<uint16_t, mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>>>> manufacturer_data_map;
  mojo::internal::Pointer<mojo::internal::Map_Data<mojo::internal::Pointer<::bluetooth::mojom::internal::UUID_Data>, mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>>>> service_data_map;

 private:
  friend class mojo::internal::MessageFragment<DeviceInfo_Data>;

  DeviceInfo_Data();
  ~DeviceInfo_Data() = delete;
};
static_assert(sizeof(DeviceInfo_Data) == 72,
              "Bad sizeof(DeviceInfo_Data)");
// Used by DeviceInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct DeviceInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  DeviceInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~DeviceInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<DeviceInfo_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    DeviceInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  ServiceInfo_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> id;
  mojo::internal::Pointer<::bluetooth::mojom::internal::UUID_Data> uuid;
  uint8_t is_primary : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<ServiceInfo_Data>;

  ServiceInfo_Data();
  ~ServiceInfo_Data() = delete;
};
static_assert(sizeof(ServiceInfo_Data) == 32,
              "Bad sizeof(ServiceInfo_Data)");
// Used by ServiceInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ServiceInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ServiceInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ServiceInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ServiceInfo_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ServiceInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  CharacteristicInfo_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> id;
  mojo::internal::Pointer<::bluetooth::mojom::internal::UUID_Data> uuid;
  uint32_t properties;
  uint32_t permissions;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> last_known_value;

 private:
  friend class mojo::internal::MessageFragment<CharacteristicInfo_Data>;

  CharacteristicInfo_Data();
  ~CharacteristicInfo_Data() = delete;
};
static_assert(sizeof(CharacteristicInfo_Data) == 40,
              "Bad sizeof(CharacteristicInfo_Data)");
// Used by CharacteristicInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CharacteristicInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CharacteristicInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CharacteristicInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<CharacteristicInfo_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CharacteristicInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  DescriptorInfo_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> id;
  mojo::internal::Pointer<::bluetooth::mojom::internal::UUID_Data> uuid;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> last_known_value;

 private:
  friend class mojo::internal::MessageFragment<DescriptorInfo_Data>;

  DescriptorInfo_Data();
  ~DescriptorInfo_Data() = delete;
};
static_assert(sizeof(DescriptorInfo_Data) == 32,
              "Bad sizeof(DescriptorInfo_Data)");
// Used by DescriptorInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct DescriptorInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  DescriptorInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~DescriptorInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<DescriptorInfo_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    DescriptorInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // bluetooth::mojom

#endif  // DEVICE_BLUETOOTH_PUBLIC_MOJOM_DEVICE_MOJOM_SHARED_INTERNAL_H_