// device/bluetooth/public/mojom/device.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_BLUETOOTH_PUBLIC_MOJOM_DEVICE_MOJOM_SEND_VALIDATION_H_
#define DEVICE_BLUETOOTH_PUBLIC_MOJOM_DEVICE_MOJOM_SEND_VALIDATION_H_

#include "device/bluetooth/public/mojom/device.mojom-shared-internal.h"
#include "device/bluetooth/public/mojom/uuid.mojom-shared.h"

#include "device/bluetooth/public/mojom/device.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::bluetooth::mojom::Property, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::bluetooth::mojom::GattResult, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::bluetooth::mojom::RSSIWrapperDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::bluetooth::mojom::RSSIWrapperDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::bluetooth::mojom::internal::RSSIWrapper_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->value = Traits::value(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::bluetooth::mojom::DeviceInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::bluetooth::mojom::DeviceInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::bluetooth::mojom::internal::DeviceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      decltype(Traits::name_for_display(input)) in_name_for_display = Traits::name_for_display(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name_for_display)::BaseType> name_for_display_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name_for_display,
        name_for_display_fragment);

      fragment->name_for_display.Set(
          name_for_display_fragment.is_null() ? nullptr : name_for_display_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name_for_display.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name_for_display in DeviceInfo struct");

      decltype(Traits::address(input)) in_address = Traits::address(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->address)::BaseType> address_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_address,
        address_fragment);

      fragment->address.Set(
          address_fragment.is_null() ? nullptr : address_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->address.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null address in DeviceInfo struct");

      fragment->is_gatt_connected = Traits::is_gatt_connected(input);

      decltype(Traits::rssi(input)) in_rssi = Traits::rssi(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->rssi)::BaseType> rssi_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::bluetooth::mojom::RSSIWrapperDataView, send_validation>(
        in_rssi,
        rssi_fragment);

      fragment->rssi.Set(
          rssi_fragment.is_null() ? nullptr : rssi_fragment.data());

      decltype(Traits::service_uuids(input)) in_service_uuids = Traits::service_uuids(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->service_uuids)::BaseType>
          service_uuids_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& service_uuids_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>, send_validation>(
        in_service_uuids,
        service_uuids_fragment,
        &service_uuids_validate_params);

      fragment->service_uuids.Set(
          service_uuids_fragment.is_null() ? nullptr : service_uuids_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->service_uuids.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null service_uuids in DeviceInfo struct");

      decltype(Traits::manufacturer_data_map(input)) in_manufacturer_data_map = Traits::manufacturer_data_map(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->manufacturer_data_map)::BaseType>
          manufacturer_data_map_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& manufacturer_data_map_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<uint16_t, mojo::ArrayDataView<uint8_t>>, send_validation>(
        in_manufacturer_data_map,
        manufacturer_data_map_fragment,
        &manufacturer_data_map_validate_params);

      fragment->manufacturer_data_map.Set(
          manufacturer_data_map_fragment.is_null() ? nullptr : manufacturer_data_map_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->manufacturer_data_map.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null manufacturer_data_map in DeviceInfo struct");

      decltype(Traits::service_data_map(input)) in_service_data_map = Traits::service_data_map(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->service_data_map)::BaseType>
          service_data_map_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& service_data_map_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<::bluetooth::mojom::UUIDDataView, mojo::ArrayDataView<uint8_t>>, send_validation>(
        in_service_data_map,
        service_data_map_fragment,
        &service_data_map_validate_params);

      fragment->service_data_map.Set(
          service_data_map_fragment.is_null() ? nullptr : service_data_map_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->service_data_map.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null service_data_map in DeviceInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::bluetooth::mojom::ServiceInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::bluetooth::mojom::ServiceInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::bluetooth::mojom::internal::ServiceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::id(input)) in_id = Traits::id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->id)::BaseType> id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_id,
        id_fragment);

      fragment->id.Set(
          id_fragment.is_null() ? nullptr : id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in ServiceInfo struct");

      decltype(Traits::uuid(input)) in_uuid = Traits::uuid(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->uuid)::BaseType> uuid_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::bluetooth::mojom::UUIDDataView, send_validation>(
        in_uuid,
        uuid_fragment);

      fragment->uuid.Set(
          uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->uuid.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null uuid in ServiceInfo struct");

      fragment->is_primary = Traits::is_primary(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::bluetooth::mojom::CharacteristicInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::bluetooth::mojom::CharacteristicInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::bluetooth::mojom::internal::CharacteristicInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::id(input)) in_id = Traits::id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->id)::BaseType> id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_id,
        id_fragment);

      fragment->id.Set(
          id_fragment.is_null() ? nullptr : id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in CharacteristicInfo struct");

      decltype(Traits::uuid(input)) in_uuid = Traits::uuid(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->uuid)::BaseType> uuid_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::bluetooth::mojom::UUIDDataView, send_validation>(
        in_uuid,
        uuid_fragment);

      fragment->uuid.Set(
          uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->uuid.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null uuid in CharacteristicInfo struct");

      fragment->properties = Traits::properties(input);

      fragment->permissions = Traits::permissions(input);

      decltype(Traits::last_known_value(input)) in_last_known_value = Traits::last_known_value(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->last_known_value)::BaseType>
          last_known_value_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& last_known_value_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_last_known_value,
        last_known_value_fragment,
        &last_known_value_validate_params);

      fragment->last_known_value.Set(
          last_known_value_fragment.is_null() ? nullptr : last_known_value_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->last_known_value.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_known_value in CharacteristicInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::bluetooth::mojom::DescriptorInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::bluetooth::mojom::DescriptorInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::bluetooth::mojom::internal::DescriptorInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::id(input)) in_id = Traits::id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->id)::BaseType> id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_id,
        id_fragment);

      fragment->id.Set(
          id_fragment.is_null() ? nullptr : id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in DescriptorInfo struct");

      decltype(Traits::uuid(input)) in_uuid = Traits::uuid(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->uuid)::BaseType> uuid_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::bluetooth::mojom::UUIDDataView, send_validation>(
        in_uuid,
        uuid_fragment);

      fragment->uuid.Set(
          uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->uuid.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null uuid in DescriptorInfo struct");

      decltype(Traits::last_known_value(input)) in_last_known_value = Traits::last_known_value(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->last_known_value)::BaseType>
          last_known_value_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& last_known_value_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_last_known_value,
        last_known_value_fragment,
        &last_known_value_validate_params);

      fragment->last_known_value.Set(
          last_known_value_fragment.is_null() ? nullptr : last_known_value_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->last_known_value.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_known_value in DescriptorInfo struct");
  }
};

}  // namespace mojo::internal

#endif  // DEVICE_BLUETOOTH_PUBLIC_MOJOM_DEVICE_MOJOM_SEND_VALIDATION_H_