// device/bluetooth/public/mojom/adapter.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_BLUETOOTH_PUBLIC_MOJOM_ADAPTER_MOJOM_SHARED_H_
#define DEVICE_BLUETOOTH_PUBLIC_MOJOM_ADAPTER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "device/bluetooth/public/mojom/adapter.mojom-shared-internal.h"
#include "device/bluetooth/public/mojom/device.mojom-shared.h"
#include "device/bluetooth/public/mojom/uuid.mojom-shared.h"
#include "device/bluetooth/public/mojom/gatt_characteristic_permissions.mojom-shared.h"
#include "device/bluetooth/public/mojom/gatt_characteristic_properties.mojom-shared.h"
#include "device/bluetooth/public/mojom/gatt_service_error_code.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "device/bluetooth/public/mojom/adapter.mojom-data-view.h"




namespace std {

template <>
struct hash<::bluetooth::mojom::ConnectResult>
    : public mojo::internal::EnumHashImpl<::bluetooth::mojom::ConnectResult> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::bluetooth::mojom::ConnectResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::bluetooth::mojom::ConnectResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::bluetooth::mojom::ConnectResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::bluetooth::mojom::ConnectToServiceResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::bluetooth::mojom::ConnectToServiceResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::bluetooth::mojom::internal::ConnectToServiceResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::socket(input)) in_socket = Traits::socket(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::bluetooth::mojom::SocketInterfaceBase>>(
      in_socket,
      &fragment->socket,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->socket)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid socket in ConnectToServiceResult struct");

    decltype(Traits::receive_stream(input)) in_receive_stream = Traits::receive_stream(input);

    
    mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_receive_stream,
      &fragment->receive_stream,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->receive_stream)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receive_stream in ConnectToServiceResult struct");

    decltype(Traits::send_stream(input)) in_send_stream = Traits::send_stream(input);

    
    mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
      in_send_stream,
      &fragment->send_stream,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->send_stream)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid send_stream in ConnectToServiceResult struct");
  }

  static bool Deserialize(::bluetooth::mojom::internal::ConnectToServiceResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::bluetooth::mojom::ConnectToServiceResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::bluetooth::mojom::AcceptConnectionResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::bluetooth::mojom::AcceptConnectionResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::bluetooth::mojom::internal::AcceptConnectionResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::device(input)) in_device = Traits::device(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->device)::BaseType> device_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::bluetooth::mojom::DeviceInfoDataView>(
      in_device,
      device_fragment);

    fragment->device.Set(
        device_fragment.is_null() ? nullptr : device_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->device.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device in AcceptConnectionResult struct");

    decltype(Traits::socket(input)) in_socket = Traits::socket(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::bluetooth::mojom::SocketInterfaceBase>>(
      in_socket,
      &fragment->socket,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->socket)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid socket in AcceptConnectionResult struct");

    decltype(Traits::receive_stream(input)) in_receive_stream = Traits::receive_stream(input);

    
    mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_receive_stream,
      &fragment->receive_stream,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->receive_stream)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receive_stream in AcceptConnectionResult struct");

    decltype(Traits::send_stream(input)) in_send_stream = Traits::send_stream(input);

    
    mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
      in_send_stream,
      &fragment->send_stream,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->send_stream)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid send_stream in AcceptConnectionResult struct");
  }

  static bool Deserialize(::bluetooth::mojom::internal::AcceptConnectionResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::bluetooth::mojom::AcceptConnectionResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::bluetooth::mojom::AdapterInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::bluetooth::mojom::AdapterInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::bluetooth::mojom::internal::AdapterInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::address(input)) in_address = Traits::address(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->address)::BaseType> address_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_address,
      address_fragment);

    fragment->address.Set(
        address_fragment.is_null() ? nullptr : address_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->address.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null address in AdapterInfo struct");

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in AdapterInfo struct");

    decltype(Traits::system_name(input)) in_system_name = Traits::system_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->system_name)::BaseType> system_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_system_name,
      system_name_fragment);

    fragment->system_name.Set(
        system_name_fragment.is_null() ? nullptr : system_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->system_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null system_name in AdapterInfo struct");

    fragment->floss = Traits::floss(input);

    fragment->extended_advertisement_support = Traits::extended_advertisement_support(input);

    fragment->initialized = Traits::initialized(input);

    fragment->present = Traits::present(input);

    fragment->powered = Traits::powered(input);

    fragment->discoverable = Traits::discoverable(input);

    fragment->discovering = Traits::discovering(input);
  }

  static bool Deserialize(::bluetooth::mojom::internal::AdapterInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::bluetooth::mojom::AdapterInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::bluetooth::mojom::LocalCharacteristicReadResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::bluetooth::mojom::LocalCharacteristicReadResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::bluetooth::mojom::internal::LocalCharacteristicReadResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::bluetooth::mojom::LocalCharacteristicReadResultDataView::Tag::kErrorCode: {
    decltype(Traits::error_code(input))
    in_error_code = Traits::error_code(input);
        
mojo::internal::Serialize<::bluetooth::mojom::GattServiceErrorCode>(
  in_error_code,
  &fragment->data.f_error_code);
    break;
  }
  case ::bluetooth::mojom::LocalCharacteristicReadResultDataView::Tag::kData: {
    decltype(Traits::data(input))
    in_data = Traits::data(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_data)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        
mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
  in_data,
  value_fragment,
  &data_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null data in LocalCharacteristicReadResult union");
    fragment->data.f_data.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::bluetooth::mojom::internal::LocalCharacteristicReadResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::bluetooth::mojom::LocalCharacteristicReadResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace bluetooth::mojom {



inline void AcceptConnectionResultDataView::GetDeviceDataView(
    ::bluetooth::mojom::DeviceInfoDataView* output) {
  auto pointer = data_->device.Get();
  *output = ::bluetooth::mojom::DeviceInfoDataView(pointer, message_);
}


inline void AdapterInfoDataView::GetAddressDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->address.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AdapterInfoDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AdapterInfoDataView::GetSystemNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->system_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void LocalCharacteristicReadResultDataView::GetDataDataView(
    mojo::ArrayDataView<uint8_t>* output) const {
  CHECK(is_data());
  *output = mojo::ArrayDataView<uint8_t>(data_->data.f_data.Get(), message_);
}


}  // bluetooth::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::bluetooth::mojom::ConnectResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::bluetooth::mojom::ConnectResult value);
};

} // namespace perfetto

#endif  // DEVICE_BLUETOOTH_PUBLIC_MOJOM_ADAPTER_MOJOM_SHARED_H_