// content/common/web_contents_ns_view_bridge.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/web_contents_ns_view_bridge.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/web_contents_ns_view_bridge.mojom-params-data.h"
#include "content/common/web_contents_ns_view_bridge.mojom-shared-message-ids.h"

#include "content/common/web_contents_ns_view_bridge.mojom-import-headers.h"
#include "content/common/web_contents_ns_view_bridge.mojom-test-utils.h"
#include "content/public/common/common_param_traits_macros.h"
#include "ui/events/mojom/event_mojom_traits.h"


namespace remote_cocoa::mojom {
DraggingInfo::DraggingInfo()
    : location_in_view(),
      location_in_screen(),
      url(),
      operation_mask() {}

DraggingInfo::DraggingInfo(
    const ::gfx::PointF& location_in_view_in,
    const ::gfx::PointF& location_in_screen_in,
    const std::optional<::GURL>& url_in,
    uint32_t operation_mask_in)
    : location_in_view(std::move(location_in_view_in)),
      location_in_screen(std::move(location_in_screen_in)),
      url(std::move(url_in)),
      operation_mask(std::move(operation_mask_in)) {}

DraggingInfo::~DraggingInfo() = default;

void DraggingInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "location_in_view"), this->location_in_view,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "location_in_screen"), this->location_in_screen,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "operation_mask"), this->operation_mask,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DraggingInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

WebContentsNSView::IPCStableHashFunction WebContentsNSView::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebContentsNSView>(message.name())) {
    case messages::WebContentsNSView::kSetParentNSView: {
      return &WebContentsNSView::SetParentNSView_Sym::IPCStableHash;
    }
    case messages::WebContentsNSView::kResetParentNSView: {
      return &WebContentsNSView::ResetParentNSView_Sym::IPCStableHash;
    }
    case messages::WebContentsNSView::kSetBounds: {
      return &WebContentsNSView::SetBounds_Sym::IPCStableHash;
    }
    case messages::WebContentsNSView::kSetVisible: {
      return &WebContentsNSView::SetVisible_Sym::IPCStableHash;
    }
    case messages::WebContentsNSView::kMakeFirstResponder: {
      return &WebContentsNSView::MakeFirstResponder_Sym::IPCStableHash;
    }
    case messages::WebContentsNSView::kTakeFocus: {
      return &WebContentsNSView::TakeFocus_Sym::IPCStableHash;
    }
    case messages::WebContentsNSView::kStartDrag: {
      return &WebContentsNSView::StartDrag_Sym::IPCStableHash;
    }
    case messages::WebContentsNSView::kDestroy: {
      return &WebContentsNSView::Destroy_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebContentsNSView::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebContentsNSView>(message.name())) {
      case messages::WebContentsNSView::kSetParentNSView:
            return "Receive remote_cocoa::mojom::WebContentsNSView::SetParentNSView";
      case messages::WebContentsNSView::kResetParentNSView:
            return "Receive remote_cocoa::mojom::WebContentsNSView::ResetParentNSView";
      case messages::WebContentsNSView::kSetBounds:
            return "Receive remote_cocoa::mojom::WebContentsNSView::SetBounds";
      case messages::WebContentsNSView::kSetVisible:
            return "Receive remote_cocoa::mojom::WebContentsNSView::SetVisible";
      case messages::WebContentsNSView::kMakeFirstResponder:
            return "Receive remote_cocoa::mojom::WebContentsNSView::MakeFirstResponder";
      case messages::WebContentsNSView::kTakeFocus:
            return "Receive remote_cocoa::mojom::WebContentsNSView::TakeFocus";
      case messages::WebContentsNSView::kStartDrag:
            return "Receive remote_cocoa::mojom::WebContentsNSView::StartDrag";
      case messages::WebContentsNSView::kDestroy:
            return "Receive remote_cocoa::mojom::WebContentsNSView::Destroy";
    }
  } else {
    switch (static_cast<messages::WebContentsNSView>(message.name())) {
      case messages::WebContentsNSView::kSetParentNSView:
            return "Receive reply remote_cocoa::mojom::WebContentsNSView::SetParentNSView";
      case messages::WebContentsNSView::kResetParentNSView:
            return "Receive reply remote_cocoa::mojom::WebContentsNSView::ResetParentNSView";
      case messages::WebContentsNSView::kSetBounds:
            return "Receive reply remote_cocoa::mojom::WebContentsNSView::SetBounds";
      case messages::WebContentsNSView::kSetVisible:
            return "Receive reply remote_cocoa::mojom::WebContentsNSView::SetVisible";
      case messages::WebContentsNSView::kMakeFirstResponder:
            return "Receive reply remote_cocoa::mojom::WebContentsNSView::MakeFirstResponder";
      case messages::WebContentsNSView::kTakeFocus:
            return "Receive reply remote_cocoa::mojom::WebContentsNSView::TakeFocus";
      case messages::WebContentsNSView::kStartDrag:
            return "Receive reply remote_cocoa::mojom::WebContentsNSView::StartDrag";
      case messages::WebContentsNSView::kDestroy:
            return "Receive reply remote_cocoa::mojom::WebContentsNSView::Destroy";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebContentsNSView::SetParentNSView_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x354aadbc;  // IPCStableHash for remote_cocoa::mojom::WebContentsNSView::SetParentNSView
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentsNSView::ResetParentNSView_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x89141aae;  // IPCStableHash for remote_cocoa::mojom::WebContentsNSView::ResetParentNSView
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentsNSView::SetBounds_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1a42c7b6;  // IPCStableHash for remote_cocoa::mojom::WebContentsNSView::SetBounds
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentsNSView::SetVisible_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6912fdfc;  // IPCStableHash for remote_cocoa::mojom::WebContentsNSView::SetVisible
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentsNSView::MakeFirstResponder_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcca12089;  // IPCStableHash for remote_cocoa::mojom::WebContentsNSView::MakeFirstResponder
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentsNSView::TakeFocus_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1493e328;  // IPCStableHash for remote_cocoa::mojom::WebContentsNSView::TakeFocus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentsNSView::StartDrag_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x084d6b77;  // IPCStableHash for remote_cocoa::mojom::WebContentsNSView::StartDrag
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentsNSView::Destroy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xca24086b;  // IPCStableHash for remote_cocoa::mojom::WebContentsNSView::Destroy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

WebContentsNSViewProxy::WebContentsNSViewProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebContentsNSViewProxy::SetParentNSView(
    uint64_t in_parent_ns_view_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::WebContentsNSView::SetParentNSView", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("parent_ns_view_id"), in_parent_ns_view_id,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentsNSView::kSetParentNSView), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::WebContentsNSView_SetParentNSView_Params_Data> params(
          message);
  params.Allocate();

  params->parent_ns_view_id = in_parent_ns_view_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentsNSView::Name_);
  message.set_method_name("SetParentNSView");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentsNSViewProxy::ResetParentNSView(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::WebContentsNSView::ResetParentNSView");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentsNSView::kResetParentNSView), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::WebContentsNSView_ResetParentNSView_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentsNSView::Name_);
  message.set_method_name("ResetParentNSView");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentsNSViewProxy::SetBounds(
    const ::gfx::Rect& in_bounds_in_window) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::WebContentsNSView::SetBounds", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bounds_in_window"), in_bounds_in_window,
                        "<value of type const ::gfx::Rect&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentsNSView::kSetBounds), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::WebContentsNSView_SetBounds_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bounds_in_window)::BaseType> bounds_in_window_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_bounds_in_window,
    bounds_in_window_fragment);

  params->bounds_in_window.Set(
      bounds_in_window_fragment.is_null() ? nullptr : bounds_in_window_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bounds_in_window.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bounds_in_window in WebContentsNSView.SetBounds request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentsNSView::Name_);
  message.set_method_name("SetBounds");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentsNSViewProxy::SetVisible(
    bool in_visible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::WebContentsNSView::SetVisible", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visible"), in_visible,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentsNSView::kSetVisible), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::WebContentsNSView_SetVisible_Params_Data> params(
          message);
  params.Allocate();

  params->visible = in_visible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentsNSView::Name_);
  message.set_method_name("SetVisible");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentsNSViewProxy::MakeFirstResponder(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::WebContentsNSView::MakeFirstResponder");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentsNSView::kMakeFirstResponder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::WebContentsNSView_MakeFirstResponder_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentsNSView::Name_);
  message.set_method_name("MakeFirstResponder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentsNSViewProxy::TakeFocus(
    bool in_reverse) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::WebContentsNSView::TakeFocus", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reverse"), in_reverse,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentsNSView::kTakeFocus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::WebContentsNSView_TakeFocus_Params_Data> params(
          message);
  params.Allocate();

  params->reverse = in_reverse;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentsNSView::Name_);
  message.set_method_name("TakeFocus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentsNSViewProxy::StartDrag(
    const ::content::DropData& in_drop_data, const ::url::Origin& in_source_origin, uint32_t in_operation_mask, const ::gfx::ImageSkia& in_image, const ::gfx::Vector2d& in_image_offset, bool in_is_privileged) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::WebContentsNSView::StartDrag", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("drop_data"), in_drop_data,
                        "<value of type const ::content::DropData&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_origin"), in_source_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("operation_mask"), in_operation_mask,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image"), in_image,
                        "<value of type const ::gfx::ImageSkia&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image_offset"), in_image_offset,
                        "<value of type const ::gfx::Vector2d&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_privileged"), in_is_privileged,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentsNSView::kStartDrag), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::WebContentsNSView_StartDrag_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->drop_data)::BaseType> drop_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::content::mojom::DropDataDataView>(
    in_drop_data,
    drop_data_fragment);

  params->drop_data.Set(
      drop_data_fragment.is_null() ? nullptr : drop_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->drop_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null drop_data in WebContentsNSView.StartDrag request");
  mojo::internal::MessageFragment<
      typename decltype(params->source_origin)::BaseType> source_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_source_origin,
    source_origin_fragment);

  params->source_origin.Set(
      source_origin_fragment.is_null() ? nullptr : source_origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_origin in WebContentsNSView.StartDrag request");

  params->operation_mask = in_operation_mask;
  mojo::internal::MessageFragment<
      typename decltype(params->image)::BaseType> image_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::ImageSkiaDataView>(
    in_image,
    image_fragment);

  params->image.Set(
      image_fragment.is_null() ? nullptr : image_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->image_offset)::BaseType> image_offset_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::Vector2dDataView>(
    in_image_offset,
    image_offset_fragment);

  params->image_offset.Set(
      image_offset_fragment.is_null() ? nullptr : image_offset_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->image_offset.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null image_offset in WebContentsNSView.StartDrag request");

  params->is_privileged = in_is_privileged;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentsNSView::Name_);
  message.set_method_name("StartDrag");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentsNSViewProxy::Destroy(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::WebContentsNSView::Destroy");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentsNSView::kDestroy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::WebContentsNSView_Destroy_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentsNSView::Name_);
  message.set_method_name("Destroy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool WebContentsNSViewStubDispatch::Accept(
    WebContentsNSView* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebContentsNSView>(message->header()->name)) {
    case messages::WebContentsNSView::kSetParentNSView: {
      DCHECK(message->is_serialized());
      internal::WebContentsNSView_SetParentNSView_Params_Data* params =
          reinterpret_cast<internal::WebContentsNSView_SetParentNSView_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentsNSView.0
      bool success = true;
      uint64_t p_parent_ns_view_id{};
      WebContentsNSView_SetParentNSView_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_parent_ns_view_id = input_data_view.parent_ns_view_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentsNSView::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetParentNSView(        
        std::move(p_parent_ns_view_id));
      return true;
    }
    case messages::WebContentsNSView::kResetParentNSView: {
      DCHECK(message->is_serialized());
      internal::WebContentsNSView_ResetParentNSView_Params_Data* params =
          reinterpret_cast<internal::WebContentsNSView_ResetParentNSView_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentsNSView.1
      bool success = true;
      WebContentsNSView_ResetParentNSView_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentsNSView::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResetParentNSView(        );
      return true;
    }
    case messages::WebContentsNSView::kSetBounds: {
      DCHECK(message->is_serialized());
      internal::WebContentsNSView_SetBounds_Params_Data* params =
          reinterpret_cast<internal::WebContentsNSView_SetBounds_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentsNSView.2
      bool success = true;
      ::gfx::Rect p_bounds_in_window{};
      WebContentsNSView_SetBounds_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBoundsInWindow(&p_bounds_in_window))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentsNSView::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetBounds(        
        std::move(p_bounds_in_window));
      return true;
    }
    case messages::WebContentsNSView::kSetVisible: {
      DCHECK(message->is_serialized());
      internal::WebContentsNSView_SetVisible_Params_Data* params =
          reinterpret_cast<internal::WebContentsNSView_SetVisible_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentsNSView.3
      bool success = true;
      bool p_visible{};
      WebContentsNSView_SetVisible_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_visible = input_data_view.visible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentsNSView::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetVisible(        
        std::move(p_visible));
      return true;
    }
    case messages::WebContentsNSView::kMakeFirstResponder: {
      DCHECK(message->is_serialized());
      internal::WebContentsNSView_MakeFirstResponder_Params_Data* params =
          reinterpret_cast<internal::WebContentsNSView_MakeFirstResponder_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentsNSView.4
      bool success = true;
      WebContentsNSView_MakeFirstResponder_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentsNSView::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MakeFirstResponder(        );
      return true;
    }
    case messages::WebContentsNSView::kTakeFocus: {
      DCHECK(message->is_serialized());
      internal::WebContentsNSView_TakeFocus_Params_Data* params =
          reinterpret_cast<internal::WebContentsNSView_TakeFocus_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentsNSView.5
      bool success = true;
      bool p_reverse{};
      WebContentsNSView_TakeFocus_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_reverse = input_data_view.reverse();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentsNSView::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TakeFocus(        
        std::move(p_reverse));
      return true;
    }
    case messages::WebContentsNSView::kStartDrag: {
      DCHECK(message->is_serialized());
      internal::WebContentsNSView_StartDrag_Params_Data* params =
          reinterpret_cast<internal::WebContentsNSView_StartDrag_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentsNSView.6
      bool success = true;
      ::content::DropData p_drop_data{};
      ::url::Origin p_source_origin{};
      uint32_t p_operation_mask{};
      ::gfx::ImageSkia p_image{};
      ::gfx::Vector2d p_image_offset{};
      bool p_is_privileged{};
      WebContentsNSView_StartDrag_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDropData(&p_drop_data))
        success = false;
      if (success && !input_data_view.ReadSourceOrigin(&p_source_origin))
        success = false;
      if (success)
        p_operation_mask = input_data_view.operation_mask();
      if (success && !input_data_view.ReadImage(&p_image))
        success = false;
      if (success && !input_data_view.ReadImageOffset(&p_image_offset))
        success = false;
      if (success)
        p_is_privileged = input_data_view.is_privileged();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentsNSView::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartDrag(        
        std::move(p_drop_data), 
        std::move(p_source_origin), 
        std::move(p_operation_mask), 
        std::move(p_image), 
        std::move(p_image_offset), 
        std::move(p_is_privileged));
      return true;
    }
    case messages::WebContentsNSView::kDestroy: {
      DCHECK(message->is_serialized());
      internal::WebContentsNSView_Destroy_Params_Data* params =
          reinterpret_cast<internal::WebContentsNSView_Destroy_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentsNSView.7
      bool success = true;
      WebContentsNSView_Destroy_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentsNSView::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Destroy(        );
      return true;
    }
  }
  return false;
}

// static
bool WebContentsNSViewStubDispatch::AcceptWithResponder(
    WebContentsNSView* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebContentsNSView>(message->header()->name)) {
    case messages::WebContentsNSView::kSetParentNSView: {
      break;
    }
    case messages::WebContentsNSView::kResetParentNSView: {
      break;
    }
    case messages::WebContentsNSView::kSetBounds: {
      break;
    }
    case messages::WebContentsNSView::kSetVisible: {
      break;
    }
    case messages::WebContentsNSView::kMakeFirstResponder: {
      break;
    }
    case messages::WebContentsNSView::kTakeFocus: {
      break;
    }
    case messages::WebContentsNSView::kStartDrag: {
      break;
    }
    case messages::WebContentsNSView::kDestroy: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebContentsNSViewValidationInfo[] = {
    { &internal::WebContentsNSView_SetParentNSView_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentsNSView_ResetParentNSView_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentsNSView_SetBounds_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentsNSView_SetVisible_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentsNSView_MakeFirstResponder_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentsNSView_TakeFocus_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentsNSView_StartDrag_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentsNSView_Destroy_Params_Data::Validate,
     nullptr /* no response */},
};

bool WebContentsNSViewRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::remote_cocoa::mojom::WebContentsNSView::Name_,
    kWebContentsNSViewValidationInfo);
}

// The declaration includes the definition on other builds.

WebContentsNSViewHost::IPCStableHashFunction WebContentsNSViewHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebContentsNSViewHost>(message.name())) {
    case messages::WebContentsNSViewHost::kOnMouseEvent: {
      return &WebContentsNSViewHost::OnMouseEvent_Sym::IPCStableHash;
    }
    case messages::WebContentsNSViewHost::kOnBecameFirstResponder: {
      return &WebContentsNSViewHost::OnBecameFirstResponder_Sym::IPCStableHash;
    }
    case messages::WebContentsNSViewHost::kOnWindowVisibilityChanged: {
      return &WebContentsNSViewHost::OnWindowVisibilityChanged_Sym::IPCStableHash;
    }
    case messages::WebContentsNSViewHost::kSetDropData: {
      return &WebContentsNSViewHost::SetDropData_Sym::IPCStableHash;
    }
    case messages::WebContentsNSViewHost::kDraggingEntered: {
      return &WebContentsNSViewHost::DraggingEntered_Sym::IPCStableHash;
    }
    case messages::WebContentsNSViewHost::kDraggingExited: {
      return &WebContentsNSViewHost::DraggingExited_Sym::IPCStableHash;
    }
    case messages::WebContentsNSViewHost::kDraggingUpdated: {
      return &WebContentsNSViewHost::DraggingUpdated_Sym::IPCStableHash;
    }
    case messages::WebContentsNSViewHost::kPerformDragOperation: {
      return &WebContentsNSViewHost::PerformDragOperation_Sym::IPCStableHash;
    }
    case messages::WebContentsNSViewHost::kDragPromisedFileTo: {
      return &WebContentsNSViewHost::DragPromisedFileTo_Sym::IPCStableHash;
    }
    case messages::WebContentsNSViewHost::kEndDrag: {
      return &WebContentsNSViewHost::EndDrag_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebContentsNSViewHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebContentsNSViewHost>(message.name())) {
      case messages::WebContentsNSViewHost::kOnMouseEvent:
            return "Receive remote_cocoa::mojom::WebContentsNSViewHost::OnMouseEvent";
      case messages::WebContentsNSViewHost::kOnBecameFirstResponder:
            return "Receive remote_cocoa::mojom::WebContentsNSViewHost::OnBecameFirstResponder";
      case messages::WebContentsNSViewHost::kOnWindowVisibilityChanged:
            return "Receive remote_cocoa::mojom::WebContentsNSViewHost::OnWindowVisibilityChanged";
      case messages::WebContentsNSViewHost::kSetDropData:
            return "Receive remote_cocoa::mojom::WebContentsNSViewHost::SetDropData";
      case messages::WebContentsNSViewHost::kDraggingEntered:
            return "Receive remote_cocoa::mojom::WebContentsNSViewHost::DraggingEntered";
      case messages::WebContentsNSViewHost::kDraggingExited:
            return "Receive remote_cocoa::mojom::WebContentsNSViewHost::DraggingExited";
      case messages::WebContentsNSViewHost::kDraggingUpdated:
            return "Receive remote_cocoa::mojom::WebContentsNSViewHost::DraggingUpdated";
      case messages::WebContentsNSViewHost::kPerformDragOperation:
            return "Receive remote_cocoa::mojom::WebContentsNSViewHost::PerformDragOperation";
      case messages::WebContentsNSViewHost::kDragPromisedFileTo:
            return "Receive remote_cocoa::mojom::WebContentsNSViewHost::DragPromisedFileTo";
      case messages::WebContentsNSViewHost::kEndDrag:
            return "Receive remote_cocoa::mojom::WebContentsNSViewHost::EndDrag";
    }
  } else {
    switch (static_cast<messages::WebContentsNSViewHost>(message.name())) {
      case messages::WebContentsNSViewHost::kOnMouseEvent:
            return "Receive reply remote_cocoa::mojom::WebContentsNSViewHost::OnMouseEvent";
      case messages::WebContentsNSViewHost::kOnBecameFirstResponder:
            return "Receive reply remote_cocoa::mojom::WebContentsNSViewHost::OnBecameFirstResponder";
      case messages::WebContentsNSViewHost::kOnWindowVisibilityChanged:
            return "Receive reply remote_cocoa::mojom::WebContentsNSViewHost::OnWindowVisibilityChanged";
      case messages::WebContentsNSViewHost::kSetDropData:
            return "Receive reply remote_cocoa::mojom::WebContentsNSViewHost::SetDropData";
      case messages::WebContentsNSViewHost::kDraggingEntered:
            return "Receive reply remote_cocoa::mojom::WebContentsNSViewHost::DraggingEntered";
      case messages::WebContentsNSViewHost::kDraggingExited:
            return "Receive reply remote_cocoa::mojom::WebContentsNSViewHost::DraggingExited";
      case messages::WebContentsNSViewHost::kDraggingUpdated:
            return "Receive reply remote_cocoa::mojom::WebContentsNSViewHost::DraggingUpdated";
      case messages::WebContentsNSViewHost::kPerformDragOperation:
            return "Receive reply remote_cocoa::mojom::WebContentsNSViewHost::PerformDragOperation";
      case messages::WebContentsNSViewHost::kDragPromisedFileTo:
            return "Receive reply remote_cocoa::mojom::WebContentsNSViewHost::DragPromisedFileTo";
      case messages::WebContentsNSViewHost::kEndDrag:
            return "Receive reply remote_cocoa::mojom::WebContentsNSViewHost::EndDrag";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebContentsNSViewHost::OnMouseEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4ba0b3bd;  // IPCStableHash for remote_cocoa::mojom::WebContentsNSViewHost::OnMouseEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentsNSViewHost::OnBecameFirstResponder_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x74845cb0;  // IPCStableHash for remote_cocoa::mojom::WebContentsNSViewHost::OnBecameFirstResponder
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentsNSViewHost::OnWindowVisibilityChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7ab745b8;  // IPCStableHash for remote_cocoa::mojom::WebContentsNSViewHost::OnWindowVisibilityChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentsNSViewHost::SetDropData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x807de6b8;  // IPCStableHash for remote_cocoa::mojom::WebContentsNSViewHost::SetDropData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentsNSViewHost::DraggingEntered_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa37b4a47;  // IPCStableHash for remote_cocoa::mojom::WebContentsNSViewHost::DraggingEntered
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentsNSViewHost::DraggingExited_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8496836a;  // IPCStableHash for remote_cocoa::mojom::WebContentsNSViewHost::DraggingExited
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentsNSViewHost::DraggingUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe45e5505;  // IPCStableHash for remote_cocoa::mojom::WebContentsNSViewHost::DraggingUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentsNSViewHost::PerformDragOperation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc785f32a;  // IPCStableHash for remote_cocoa::mojom::WebContentsNSViewHost::PerformDragOperation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentsNSViewHost::DragPromisedFileTo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcc95f899;  // IPCStableHash for remote_cocoa::mojom::WebContentsNSViewHost::DragPromisedFileTo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentsNSViewHost::EndDrag_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8dc2d782;  // IPCStableHash for remote_cocoa::mojom::WebContentsNSViewHost::EndDrag
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool WebContentsNSViewHost::DraggingEntered(DraggingInfoPtr dragging_info, uint32_t* out_result) {
  NOTREACHED();
}
bool WebContentsNSViewHost::DraggingUpdated(DraggingInfoPtr dragging_info, uint32_t* out_result) {
  NOTREACHED();
}
bool WebContentsNSViewHost::PerformDragOperation(DraggingInfoPtr dragging_info, bool* out_result) {
  NOTREACHED();
}
bool WebContentsNSViewHost::DragPromisedFileTo(const ::base::FilePath& file_path, const ::content::DropData& drop_data, const ::GURL& download_url, const ::url::Origin& source_origin, ::base::FilePath* out_file_path) {
  NOTREACHED();
}
class WebContentsNSViewHost_DraggingEntered_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  WebContentsNSViewHost_DraggingEntered_HandleSyncResponse(
      bool* result, uint32_t* out_result)
      : result_(result), out_result_(out_result) {
    DCHECK(!*result_);
  }

  WebContentsNSViewHost_DraggingEntered_HandleSyncResponse(const WebContentsNSViewHost_DraggingEntered_HandleSyncResponse&) = delete;
  WebContentsNSViewHost_DraggingEntered_HandleSyncResponse& operator=(const WebContentsNSViewHost_DraggingEntered_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  uint32_t* out_result_;};

class WebContentsNSViewHost_DraggingEntered_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebContentsNSViewHost_DraggingEntered_ForwardToCallback(
      WebContentsNSViewHost::DraggingEnteredCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebContentsNSViewHost_DraggingEntered_ForwardToCallback(const WebContentsNSViewHost_DraggingEntered_ForwardToCallback&) = delete;
  WebContentsNSViewHost_DraggingEntered_ForwardToCallback& operator=(const WebContentsNSViewHost_DraggingEntered_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebContentsNSViewHost::DraggingEnteredCallback callback_;
};
class WebContentsNSViewHost_DraggingUpdated_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  WebContentsNSViewHost_DraggingUpdated_HandleSyncResponse(
      bool* result, uint32_t* out_result)
      : result_(result), out_result_(out_result) {
    DCHECK(!*result_);
  }

  WebContentsNSViewHost_DraggingUpdated_HandleSyncResponse(const WebContentsNSViewHost_DraggingUpdated_HandleSyncResponse&) = delete;
  WebContentsNSViewHost_DraggingUpdated_HandleSyncResponse& operator=(const WebContentsNSViewHost_DraggingUpdated_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  uint32_t* out_result_;};

class WebContentsNSViewHost_DraggingUpdated_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebContentsNSViewHost_DraggingUpdated_ForwardToCallback(
      WebContentsNSViewHost::DraggingUpdatedCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebContentsNSViewHost_DraggingUpdated_ForwardToCallback(const WebContentsNSViewHost_DraggingUpdated_ForwardToCallback&) = delete;
  WebContentsNSViewHost_DraggingUpdated_ForwardToCallback& operator=(const WebContentsNSViewHost_DraggingUpdated_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebContentsNSViewHost::DraggingUpdatedCallback callback_;
};
class WebContentsNSViewHost_PerformDragOperation_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  WebContentsNSViewHost_PerformDragOperation_HandleSyncResponse(
      bool* result, bool* out_result)
      : result_(result), out_result_(out_result) {
    DCHECK(!*result_);
  }

  WebContentsNSViewHost_PerformDragOperation_HandleSyncResponse(const WebContentsNSViewHost_PerformDragOperation_HandleSyncResponse&) = delete;
  WebContentsNSViewHost_PerformDragOperation_HandleSyncResponse& operator=(const WebContentsNSViewHost_PerformDragOperation_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_result_;};

class WebContentsNSViewHost_PerformDragOperation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebContentsNSViewHost_PerformDragOperation_ForwardToCallback(
      WebContentsNSViewHost::PerformDragOperationCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebContentsNSViewHost_PerformDragOperation_ForwardToCallback(const WebContentsNSViewHost_PerformDragOperation_ForwardToCallback&) = delete;
  WebContentsNSViewHost_PerformDragOperation_ForwardToCallback& operator=(const WebContentsNSViewHost_PerformDragOperation_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebContentsNSViewHost::PerformDragOperationCallback callback_;
};
class WebContentsNSViewHost_DragPromisedFileTo_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  WebContentsNSViewHost_DragPromisedFileTo_HandleSyncResponse(
      bool* result, ::base::FilePath* out_file_path)
      : result_(result), out_file_path_(out_file_path) {
    DCHECK(!*result_);
  }

  WebContentsNSViewHost_DragPromisedFileTo_HandleSyncResponse(const WebContentsNSViewHost_DragPromisedFileTo_HandleSyncResponse&) = delete;
  WebContentsNSViewHost_DragPromisedFileTo_HandleSyncResponse& operator=(const WebContentsNSViewHost_DragPromisedFileTo_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::FilePath* out_file_path_;};

class WebContentsNSViewHost_DragPromisedFileTo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebContentsNSViewHost_DragPromisedFileTo_ForwardToCallback(
      WebContentsNSViewHost::DragPromisedFileToCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebContentsNSViewHost_DragPromisedFileTo_ForwardToCallback(const WebContentsNSViewHost_DragPromisedFileTo_ForwardToCallback&) = delete;
  WebContentsNSViewHost_DragPromisedFileTo_ForwardToCallback& operator=(const WebContentsNSViewHost_DragPromisedFileTo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebContentsNSViewHost::DragPromisedFileToCallback callback_;
};

WebContentsNSViewHostProxy::WebContentsNSViewHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebContentsNSViewHostProxy::OnMouseEvent(
    ::std::unique_ptr<::ui::Event> in_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::WebContentsNSViewHost::OnMouseEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::std::unique_ptr<::ui::Event>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentsNSViewHost::kOnMouseEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::WebContentsNSViewHost_OnMouseEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  
  mojo::internal::Serialize<::ui::mojom::EventDataView>(
    in_event,
    event_fragment);

  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event in WebContentsNSViewHost.OnMouseEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentsNSViewHost::Name_);
  message.set_method_name("OnMouseEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentsNSViewHostProxy::OnBecameFirstResponder(
    SelectionDirection in_direction) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::WebContentsNSViewHost::OnBecameFirstResponder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("direction"), in_direction,
                        "<value of type SelectionDirection>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentsNSViewHost::kOnBecameFirstResponder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::WebContentsNSViewHost_OnBecameFirstResponder_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::remote_cocoa::mojom::SelectionDirection>(
    in_direction,
    &params->direction);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentsNSViewHost::Name_);
  message.set_method_name("OnBecameFirstResponder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentsNSViewHostProxy::OnWindowVisibilityChanged(
    Visibility in_visibility) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::WebContentsNSViewHost::OnWindowVisibilityChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visibility"), in_visibility,
                        "<value of type Visibility>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentsNSViewHost::kOnWindowVisibilityChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::WebContentsNSViewHost_OnWindowVisibilityChanged_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::remote_cocoa::mojom::Visibility>(
    in_visibility,
    &params->visibility);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentsNSViewHost::Name_);
  message.set_method_name("OnWindowVisibilityChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentsNSViewHostProxy::SetDropData(
    const ::content::DropData& in_drop_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::WebContentsNSViewHost::SetDropData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("drop_data"), in_drop_data,
                        "<value of type const ::content::DropData&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentsNSViewHost::kSetDropData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::WebContentsNSViewHost_SetDropData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->drop_data)::BaseType> drop_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::content::mojom::DropDataDataView>(
    in_drop_data,
    drop_data_fragment);

  params->drop_data.Set(
      drop_data_fragment.is_null() ? nullptr : drop_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->drop_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null drop_data in WebContentsNSViewHost.SetDropData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentsNSViewHost::Name_);
  message.set_method_name("SetDropData");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool WebContentsNSViewHostProxy::DraggingEntered(
    DraggingInfoPtr param_dragging_info, uint32_t* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call remote_cocoa::mojom::WebContentsNSViewHost::DraggingEntered (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dragging_info"), param_dragging_info,
                        "<value of type DraggingInfoPtr>");
   });
#else
  TRACE_EVENT0("mojom", "WebContentsNSViewHost::DraggingEntered");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentsNSViewHost::kDraggingEntered), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::WebContentsNSViewHost_DraggingEntered_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->dragging_info)::BaseType> dragging_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::remote_cocoa::mojom::DraggingInfoDataView>(
    param_dragging_info,
    dragging_info_fragment);

  params->dragging_info.Set(
      dragging_info_fragment.is_null() ? nullptr : dragging_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->dragging_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null dragging_info in WebContentsNSViewHost.DraggingEntered request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentsNSViewHost::Name_);
  message.set_method_name("DraggingEntered");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebContentsNSViewHost_DraggingEntered_HandleSyncResponse(
          &result, out_param_result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "WebContentsNSViewHost::DraggingEntered", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result,
                        "<value of type uint32_t>");
   });
#endif
  return result;
}

void WebContentsNSViewHostProxy::DraggingEntered(
    DraggingInfoPtr in_dragging_info, DraggingEnteredCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::WebContentsNSViewHost::DraggingEntered", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dragging_info"), in_dragging_info,
                        "<value of type DraggingInfoPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentsNSViewHost::kDraggingEntered), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::WebContentsNSViewHost_DraggingEntered_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->dragging_info)::BaseType> dragging_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::remote_cocoa::mojom::DraggingInfoDataView>(
    in_dragging_info,
    dragging_info_fragment);

  params->dragging_info.Set(
      dragging_info_fragment.is_null() ? nullptr : dragging_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->dragging_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null dragging_info in WebContentsNSViewHost.DraggingEntered request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentsNSViewHost::Name_);
  message.set_method_name("DraggingEntered");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebContentsNSViewHost_DraggingEntered_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebContentsNSViewHostProxy::DraggingExited(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::WebContentsNSViewHost::DraggingExited");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentsNSViewHost::kDraggingExited), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::WebContentsNSViewHost_DraggingExited_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentsNSViewHost::Name_);
  message.set_method_name("DraggingExited");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool WebContentsNSViewHostProxy::DraggingUpdated(
    DraggingInfoPtr param_dragging_info, uint32_t* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call remote_cocoa::mojom::WebContentsNSViewHost::DraggingUpdated (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dragging_info"), param_dragging_info,
                        "<value of type DraggingInfoPtr>");
   });
#else
  TRACE_EVENT0("mojom", "WebContentsNSViewHost::DraggingUpdated");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentsNSViewHost::kDraggingUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::WebContentsNSViewHost_DraggingUpdated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->dragging_info)::BaseType> dragging_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::remote_cocoa::mojom::DraggingInfoDataView>(
    param_dragging_info,
    dragging_info_fragment);

  params->dragging_info.Set(
      dragging_info_fragment.is_null() ? nullptr : dragging_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->dragging_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null dragging_info in WebContentsNSViewHost.DraggingUpdated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentsNSViewHost::Name_);
  message.set_method_name("DraggingUpdated");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebContentsNSViewHost_DraggingUpdated_HandleSyncResponse(
          &result, out_param_result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "WebContentsNSViewHost::DraggingUpdated", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result,
                        "<value of type uint32_t>");
   });
#endif
  return result;
}

void WebContentsNSViewHostProxy::DraggingUpdated(
    DraggingInfoPtr in_dragging_info, DraggingUpdatedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::WebContentsNSViewHost::DraggingUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dragging_info"), in_dragging_info,
                        "<value of type DraggingInfoPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentsNSViewHost::kDraggingUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::WebContentsNSViewHost_DraggingUpdated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->dragging_info)::BaseType> dragging_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::remote_cocoa::mojom::DraggingInfoDataView>(
    in_dragging_info,
    dragging_info_fragment);

  params->dragging_info.Set(
      dragging_info_fragment.is_null() ? nullptr : dragging_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->dragging_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null dragging_info in WebContentsNSViewHost.DraggingUpdated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentsNSViewHost::Name_);
  message.set_method_name("DraggingUpdated");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebContentsNSViewHost_DraggingUpdated_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool WebContentsNSViewHostProxy::PerformDragOperation(
    DraggingInfoPtr param_dragging_info, bool* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call remote_cocoa::mojom::WebContentsNSViewHost::PerformDragOperation (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dragging_info"), param_dragging_info,
                        "<value of type DraggingInfoPtr>");
   });
#else
  TRACE_EVENT0("mojom", "WebContentsNSViewHost::PerformDragOperation");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentsNSViewHost::kPerformDragOperation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::WebContentsNSViewHost_PerformDragOperation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->dragging_info)::BaseType> dragging_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::remote_cocoa::mojom::DraggingInfoDataView>(
    param_dragging_info,
    dragging_info_fragment);

  params->dragging_info.Set(
      dragging_info_fragment.is_null() ? nullptr : dragging_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->dragging_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null dragging_info in WebContentsNSViewHost.PerformDragOperation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentsNSViewHost::Name_);
  message.set_method_name("PerformDragOperation");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebContentsNSViewHost_PerformDragOperation_HandleSyncResponse(
          &result, out_param_result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "WebContentsNSViewHost::PerformDragOperation", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result,
                        "<value of type bool>");
   });
#endif
  return result;
}

void WebContentsNSViewHostProxy::PerformDragOperation(
    DraggingInfoPtr in_dragging_info, PerformDragOperationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::WebContentsNSViewHost::PerformDragOperation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dragging_info"), in_dragging_info,
                        "<value of type DraggingInfoPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentsNSViewHost::kPerformDragOperation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::WebContentsNSViewHost_PerformDragOperation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->dragging_info)::BaseType> dragging_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::remote_cocoa::mojom::DraggingInfoDataView>(
    in_dragging_info,
    dragging_info_fragment);

  params->dragging_info.Set(
      dragging_info_fragment.is_null() ? nullptr : dragging_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->dragging_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null dragging_info in WebContentsNSViewHost.PerformDragOperation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentsNSViewHost::Name_);
  message.set_method_name("PerformDragOperation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebContentsNSViewHost_PerformDragOperation_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool WebContentsNSViewHostProxy::DragPromisedFileTo(
    const ::base::FilePath& param_file_path, const ::content::DropData& param_drop_data, const ::GURL& param_download_url, const ::url::Origin& param_source_origin, ::base::FilePath* out_param_file_path) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call remote_cocoa::mojom::WebContentsNSViewHost::DragPromisedFileTo (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_path"), param_file_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("drop_data"), param_drop_data,
                        "<value of type const ::content::DropData&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("download_url"), param_download_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_origin"), param_source_origin,
                        "<value of type const ::url::Origin&>");
   });
#else
  TRACE_EVENT0("mojom", "WebContentsNSViewHost::DragPromisedFileTo");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentsNSViewHost::kDragPromisedFileTo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::WebContentsNSViewHost_DragPromisedFileTo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->file_path)::BaseType> file_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    param_file_path,
    file_path_fragment);

  params->file_path.Set(
      file_path_fragment.is_null() ? nullptr : file_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->file_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null file_path in WebContentsNSViewHost.DragPromisedFileTo request");
  mojo::internal::MessageFragment<
      typename decltype(params->drop_data)::BaseType> drop_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::content::mojom::DropDataDataView>(
    param_drop_data,
    drop_data_fragment);

  params->drop_data.Set(
      drop_data_fragment.is_null() ? nullptr : drop_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->drop_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null drop_data in WebContentsNSViewHost.DragPromisedFileTo request");
  mojo::internal::MessageFragment<
      typename decltype(params->download_url)::BaseType> download_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    param_download_url,
    download_url_fragment);

  params->download_url.Set(
      download_url_fragment.is_null() ? nullptr : download_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->download_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null download_url in WebContentsNSViewHost.DragPromisedFileTo request");
  mojo::internal::MessageFragment<
      typename decltype(params->source_origin)::BaseType> source_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    param_source_origin,
    source_origin_fragment);

  params->source_origin.Set(
      source_origin_fragment.is_null() ? nullptr : source_origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_origin in WebContentsNSViewHost.DragPromisedFileTo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentsNSViewHost::Name_);
  message.set_method_name("DragPromisedFileTo");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebContentsNSViewHost_DragPromisedFileTo_HandleSyncResponse(
          &result, out_param_file_path));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "WebContentsNSViewHost::DragPromisedFileTo", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_path"), out_param_file_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif
  return result;
}

void WebContentsNSViewHostProxy::DragPromisedFileTo(
    const ::base::FilePath& in_file_path, const ::content::DropData& in_drop_data, const ::GURL& in_download_url, const ::url::Origin& in_source_origin, DragPromisedFileToCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::WebContentsNSViewHost::DragPromisedFileTo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_path"), in_file_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("drop_data"), in_drop_data,
                        "<value of type const ::content::DropData&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("download_url"), in_download_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_origin"), in_source_origin,
                        "<value of type const ::url::Origin&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentsNSViewHost::kDragPromisedFileTo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::WebContentsNSViewHost_DragPromisedFileTo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->file_path)::BaseType> file_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_file_path,
    file_path_fragment);

  params->file_path.Set(
      file_path_fragment.is_null() ? nullptr : file_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->file_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null file_path in WebContentsNSViewHost.DragPromisedFileTo request");
  mojo::internal::MessageFragment<
      typename decltype(params->drop_data)::BaseType> drop_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::content::mojom::DropDataDataView>(
    in_drop_data,
    drop_data_fragment);

  params->drop_data.Set(
      drop_data_fragment.is_null() ? nullptr : drop_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->drop_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null drop_data in WebContentsNSViewHost.DragPromisedFileTo request");
  mojo::internal::MessageFragment<
      typename decltype(params->download_url)::BaseType> download_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_download_url,
    download_url_fragment);

  params->download_url.Set(
      download_url_fragment.is_null() ? nullptr : download_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->download_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null download_url in WebContentsNSViewHost.DragPromisedFileTo request");
  mojo::internal::MessageFragment<
      typename decltype(params->source_origin)::BaseType> source_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_source_origin,
    source_origin_fragment);

  params->source_origin.Set(
      source_origin_fragment.is_null() ? nullptr : source_origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_origin in WebContentsNSViewHost.DragPromisedFileTo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentsNSViewHost::Name_);
  message.set_method_name("DragPromisedFileTo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebContentsNSViewHost_DragPromisedFileTo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebContentsNSViewHostProxy::EndDrag(
    uint32_t in_drag_operation, const ::gfx::PointF& in_local_point, const ::gfx::PointF& in_screen_point) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::WebContentsNSViewHost::EndDrag", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("drag_operation"), in_drag_operation,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_point"), in_local_point,
                        "<value of type const ::gfx::PointF&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("screen_point"), in_screen_point,
                        "<value of type const ::gfx::PointF&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentsNSViewHost::kEndDrag), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::WebContentsNSViewHost_EndDrag_Params_Data> params(
          message);
  params.Allocate();

  params->drag_operation = in_drag_operation;
  mojo::internal::MessageFragment<
      typename decltype(params->local_point)::BaseType> local_point_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
    in_local_point,
    local_point_fragment);

  params->local_point.Set(
      local_point_fragment.is_null() ? nullptr : local_point_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->local_point.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null local_point in WebContentsNSViewHost.EndDrag request");
  mojo::internal::MessageFragment<
      typename decltype(params->screen_point)::BaseType> screen_point_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
    in_screen_point,
    screen_point_fragment);

  params->screen_point.Set(
      screen_point_fragment.is_null() ? nullptr : screen_point_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->screen_point.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null screen_point in WebContentsNSViewHost.EndDrag request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentsNSViewHost::Name_);
  message.set_method_name("EndDrag");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class WebContentsNSViewHost_DraggingEntered_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebContentsNSViewHost::DraggingEnteredCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebContentsNSViewHost_DraggingEntered_ProxyToResponder> proxy(
        new WebContentsNSViewHost_DraggingEntered_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebContentsNSViewHost_DraggingEntered_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebContentsNSViewHost_DraggingEntered_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebContentsNSViewHost_DraggingEntered_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebContentsNSViewHost::DraggingEnteredCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint32_t in_result);
};

bool WebContentsNSViewHost_DraggingEntered_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebContentsNSViewHost_DraggingEntered_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebContentsNSViewHost_DraggingEntered_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebContentsNSViewHost.4
  bool success = true;
  uint32_t p_result{};
  WebContentsNSViewHost_DraggingEntered_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebContentsNSViewHost::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebContentsNSViewHost_DraggingEntered_ProxyToResponder::Run(
    uint32_t in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply remote_cocoa::mojom::WebContentsNSViewHost::DraggingEntered", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type uint32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentsNSViewHost::kDraggingEntered), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::WebContentsNSViewHost_DraggingEntered_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentsNSViewHost::Name_);
  message.set_method_name("DraggingEntered");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool WebContentsNSViewHost_DraggingEntered_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebContentsNSViewHost_DraggingEntered_ResponseParams_Data* params =
      reinterpret_cast<internal::WebContentsNSViewHost_DraggingEntered_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for WebContentsNSViewHost.4
  bool success = true;
  uint32_t p_result{};
  WebContentsNSViewHost_DraggingEntered_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebContentsNSViewHost::Name_, 4, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  *result_ = true;
  return true;
}
class WebContentsNSViewHost_DraggingUpdated_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebContentsNSViewHost::DraggingUpdatedCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebContentsNSViewHost_DraggingUpdated_ProxyToResponder> proxy(
        new WebContentsNSViewHost_DraggingUpdated_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebContentsNSViewHost_DraggingUpdated_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebContentsNSViewHost_DraggingUpdated_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebContentsNSViewHost_DraggingUpdated_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebContentsNSViewHost::DraggingUpdatedCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint32_t in_result);
};

bool WebContentsNSViewHost_DraggingUpdated_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebContentsNSViewHost_DraggingUpdated_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebContentsNSViewHost_DraggingUpdated_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebContentsNSViewHost.6
  bool success = true;
  uint32_t p_result{};
  WebContentsNSViewHost_DraggingUpdated_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebContentsNSViewHost::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebContentsNSViewHost_DraggingUpdated_ProxyToResponder::Run(
    uint32_t in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply remote_cocoa::mojom::WebContentsNSViewHost::DraggingUpdated", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type uint32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentsNSViewHost::kDraggingUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::WebContentsNSViewHost_DraggingUpdated_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentsNSViewHost::Name_);
  message.set_method_name("DraggingUpdated");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool WebContentsNSViewHost_DraggingUpdated_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebContentsNSViewHost_DraggingUpdated_ResponseParams_Data* params =
      reinterpret_cast<internal::WebContentsNSViewHost_DraggingUpdated_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for WebContentsNSViewHost.6
  bool success = true;
  uint32_t p_result{};
  WebContentsNSViewHost_DraggingUpdated_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebContentsNSViewHost::Name_, 6, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  *result_ = true;
  return true;
}
class WebContentsNSViewHost_PerformDragOperation_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebContentsNSViewHost::PerformDragOperationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebContentsNSViewHost_PerformDragOperation_ProxyToResponder> proxy(
        new WebContentsNSViewHost_PerformDragOperation_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebContentsNSViewHost_PerformDragOperation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebContentsNSViewHost_PerformDragOperation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebContentsNSViewHost_PerformDragOperation_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebContentsNSViewHost::PerformDragOperationCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_result);
};

bool WebContentsNSViewHost_PerformDragOperation_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebContentsNSViewHost_PerformDragOperation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebContentsNSViewHost_PerformDragOperation_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebContentsNSViewHost.7
  bool success = true;
  bool p_result{};
  WebContentsNSViewHost_PerformDragOperation_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebContentsNSViewHost::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebContentsNSViewHost_PerformDragOperation_ProxyToResponder::Run(
    bool in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply remote_cocoa::mojom::WebContentsNSViewHost::PerformDragOperation", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentsNSViewHost::kPerformDragOperation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::WebContentsNSViewHost_PerformDragOperation_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentsNSViewHost::Name_);
  message.set_method_name("PerformDragOperation");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool WebContentsNSViewHost_PerformDragOperation_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebContentsNSViewHost_PerformDragOperation_ResponseParams_Data* params =
      reinterpret_cast<internal::WebContentsNSViewHost_PerformDragOperation_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for WebContentsNSViewHost.7
  bool success = true;
  bool p_result{};
  WebContentsNSViewHost_PerformDragOperation_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebContentsNSViewHost::Name_, 7, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  *result_ = true;
  return true;
}
class WebContentsNSViewHost_DragPromisedFileTo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebContentsNSViewHost::DragPromisedFileToCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebContentsNSViewHost_DragPromisedFileTo_ProxyToResponder> proxy(
        new WebContentsNSViewHost_DragPromisedFileTo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebContentsNSViewHost_DragPromisedFileTo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebContentsNSViewHost_DragPromisedFileTo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebContentsNSViewHost_DragPromisedFileTo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebContentsNSViewHost::DragPromisedFileToCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::base::FilePath& in_file_path);
};

bool WebContentsNSViewHost_DragPromisedFileTo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebContentsNSViewHost_DragPromisedFileTo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebContentsNSViewHost_DragPromisedFileTo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebContentsNSViewHost.8
  bool success = true;
  ::base::FilePath p_file_path{};
  WebContentsNSViewHost_DragPromisedFileTo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFilePath(&p_file_path))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebContentsNSViewHost::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_file_path));
  }
  return true;
}

void WebContentsNSViewHost_DragPromisedFileTo_ProxyToResponder::Run(
    const ::base::FilePath& in_file_path) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply remote_cocoa::mojom::WebContentsNSViewHost::DragPromisedFileTo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_path"), in_file_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentsNSViewHost::kDragPromisedFileTo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::WebContentsNSViewHost_DragPromisedFileTo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->file_path)::BaseType> file_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_file_path,
    file_path_fragment);

  params->file_path.Set(
      file_path_fragment.is_null() ? nullptr : file_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->file_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null file_path in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentsNSViewHost::Name_);
  message.set_method_name("DragPromisedFileTo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool WebContentsNSViewHost_DragPromisedFileTo_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebContentsNSViewHost_DragPromisedFileTo_ResponseParams_Data* params =
      reinterpret_cast<internal::WebContentsNSViewHost_DragPromisedFileTo_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for WebContentsNSViewHost.8
  bool success = true;
  ::base::FilePath p_file_path{};
  WebContentsNSViewHost_DragPromisedFileTo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFilePath(&p_file_path))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebContentsNSViewHost::Name_, 8, true);
    return false;
  }
  *out_file_path_ = std::move(p_file_path);
  *result_ = true;
  return true;
}

// static
bool WebContentsNSViewHostStubDispatch::Accept(
    WebContentsNSViewHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebContentsNSViewHost>(message->header()->name)) {
    case messages::WebContentsNSViewHost::kOnMouseEvent: {
      DCHECK(message->is_serialized());
      internal::WebContentsNSViewHost_OnMouseEvent_Params_Data* params =
          reinterpret_cast<internal::WebContentsNSViewHost_OnMouseEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentsNSViewHost.0
      bool success = true;
      ::std::unique_ptr<::ui::Event> p_event{};
      WebContentsNSViewHost_OnMouseEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentsNSViewHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMouseEvent(        
        std::move(p_event));
      return true;
    }
    case messages::WebContentsNSViewHost::kOnBecameFirstResponder: {
      DCHECK(message->is_serialized());
      internal::WebContentsNSViewHost_OnBecameFirstResponder_Params_Data* params =
          reinterpret_cast<internal::WebContentsNSViewHost_OnBecameFirstResponder_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentsNSViewHost.1
      bool success = true;
      SelectionDirection p_direction{};
      WebContentsNSViewHost_OnBecameFirstResponder_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDirection(&p_direction))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentsNSViewHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBecameFirstResponder(        
        std::move(p_direction));
      return true;
    }
    case messages::WebContentsNSViewHost::kOnWindowVisibilityChanged: {
      DCHECK(message->is_serialized());
      internal::WebContentsNSViewHost_OnWindowVisibilityChanged_Params_Data* params =
          reinterpret_cast<internal::WebContentsNSViewHost_OnWindowVisibilityChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentsNSViewHost.2
      bool success = true;
      Visibility p_visibility{};
      WebContentsNSViewHost_OnWindowVisibilityChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVisibility(&p_visibility))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentsNSViewHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnWindowVisibilityChanged(        
        std::move(p_visibility));
      return true;
    }
    case messages::WebContentsNSViewHost::kSetDropData: {
      DCHECK(message->is_serialized());
      internal::WebContentsNSViewHost_SetDropData_Params_Data* params =
          reinterpret_cast<internal::WebContentsNSViewHost_SetDropData_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentsNSViewHost.3
      bool success = true;
      ::content::DropData p_drop_data{};
      WebContentsNSViewHost_SetDropData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDropData(&p_drop_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentsNSViewHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetDropData(        
        std::move(p_drop_data));
      return true;
    }
    case messages::WebContentsNSViewHost::kDraggingEntered: {
      break;
    }
    case messages::WebContentsNSViewHost::kDraggingExited: {
      DCHECK(message->is_serialized());
      internal::WebContentsNSViewHost_DraggingExited_Params_Data* params =
          reinterpret_cast<internal::WebContentsNSViewHost_DraggingExited_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentsNSViewHost.5
      bool success = true;
      WebContentsNSViewHost_DraggingExited_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentsNSViewHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DraggingExited(        );
      return true;
    }
    case messages::WebContentsNSViewHost::kDraggingUpdated: {
      break;
    }
    case messages::WebContentsNSViewHost::kPerformDragOperation: {
      break;
    }
    case messages::WebContentsNSViewHost::kDragPromisedFileTo: {
      break;
    }
    case messages::WebContentsNSViewHost::kEndDrag: {
      DCHECK(message->is_serialized());
      internal::WebContentsNSViewHost_EndDrag_Params_Data* params =
          reinterpret_cast<internal::WebContentsNSViewHost_EndDrag_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentsNSViewHost.9
      bool success = true;
      uint32_t p_drag_operation{};
      ::gfx::PointF p_local_point{};
      ::gfx::PointF p_screen_point{};
      WebContentsNSViewHost_EndDrag_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_drag_operation = input_data_view.drag_operation();
      if (success && !input_data_view.ReadLocalPoint(&p_local_point))
        success = false;
      if (success && !input_data_view.ReadScreenPoint(&p_screen_point))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentsNSViewHost::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EndDrag(        
        std::move(p_drag_operation), 
        std::move(p_local_point), 
        std::move(p_screen_point));
      return true;
    }
  }
  return false;
}

// static
bool WebContentsNSViewHostStubDispatch::AcceptWithResponder(
    WebContentsNSViewHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebContentsNSViewHost>(message->header()->name)) {
    case messages::WebContentsNSViewHost::kOnMouseEvent: {
      break;
    }
    case messages::WebContentsNSViewHost::kOnBecameFirstResponder: {
      break;
    }
    case messages::WebContentsNSViewHost::kOnWindowVisibilityChanged: {
      break;
    }
    case messages::WebContentsNSViewHost::kSetDropData: {
      break;
    }
    case messages::WebContentsNSViewHost::kDraggingEntered: {
      internal::WebContentsNSViewHost_DraggingEntered_Params_Data* params =
          reinterpret_cast<
              internal::WebContentsNSViewHost_DraggingEntered_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebContentsNSViewHost.4
      bool success = true;
      DraggingInfoPtr p_dragging_info{};
      WebContentsNSViewHost_DraggingEntered_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDraggingInfo(&p_dragging_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentsNSViewHost::Name_, 4, false);
        return false;
      }
      auto callback =
          WebContentsNSViewHost_DraggingEntered_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DraggingEntered(        
        std::move(p_dragging_info), std::move(callback));
      return true;
    }
    case messages::WebContentsNSViewHost::kDraggingExited: {
      break;
    }
    case messages::WebContentsNSViewHost::kDraggingUpdated: {
      internal::WebContentsNSViewHost_DraggingUpdated_Params_Data* params =
          reinterpret_cast<
              internal::WebContentsNSViewHost_DraggingUpdated_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebContentsNSViewHost.6
      bool success = true;
      DraggingInfoPtr p_dragging_info{};
      WebContentsNSViewHost_DraggingUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDraggingInfo(&p_dragging_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentsNSViewHost::Name_, 6, false);
        return false;
      }
      auto callback =
          WebContentsNSViewHost_DraggingUpdated_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DraggingUpdated(        
        std::move(p_dragging_info), std::move(callback));
      return true;
    }
    case messages::WebContentsNSViewHost::kPerformDragOperation: {
      internal::WebContentsNSViewHost_PerformDragOperation_Params_Data* params =
          reinterpret_cast<
              internal::WebContentsNSViewHost_PerformDragOperation_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebContentsNSViewHost.7
      bool success = true;
      DraggingInfoPtr p_dragging_info{};
      WebContentsNSViewHost_PerformDragOperation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDraggingInfo(&p_dragging_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentsNSViewHost::Name_, 7, false);
        return false;
      }
      auto callback =
          WebContentsNSViewHost_PerformDragOperation_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PerformDragOperation(        
        std::move(p_dragging_info), std::move(callback));
      return true;
    }
    case messages::WebContentsNSViewHost::kDragPromisedFileTo: {
      internal::WebContentsNSViewHost_DragPromisedFileTo_Params_Data* params =
          reinterpret_cast<
              internal::WebContentsNSViewHost_DragPromisedFileTo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebContentsNSViewHost.8
      bool success = true;
      ::base::FilePath p_file_path{};
      ::content::DropData p_drop_data{};
      ::GURL p_download_url{};
      ::url::Origin p_source_origin{};
      WebContentsNSViewHost_DragPromisedFileTo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFilePath(&p_file_path))
        success = false;
      if (success && !input_data_view.ReadDropData(&p_drop_data))
        success = false;
      if (success && !input_data_view.ReadDownloadUrl(&p_download_url))
        success = false;
      if (success && !input_data_view.ReadSourceOrigin(&p_source_origin))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentsNSViewHost::Name_, 8, false);
        return false;
      }
      auto callback =
          WebContentsNSViewHost_DragPromisedFileTo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DragPromisedFileTo(        
        std::move(p_file_path), 
        std::move(p_drop_data), 
        std::move(p_download_url), 
        std::move(p_source_origin), std::move(callback));
      return true;
    }
    case messages::WebContentsNSViewHost::kEndDrag: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebContentsNSViewHostValidationInfo[] = {
    { &internal::WebContentsNSViewHost_OnMouseEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentsNSViewHost_OnBecameFirstResponder_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentsNSViewHost_OnWindowVisibilityChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentsNSViewHost_SetDropData_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentsNSViewHost_DraggingEntered_Params_Data::Validate,
     &internal::WebContentsNSViewHost_DraggingEntered_ResponseParams_Data::Validate},
    { &internal::WebContentsNSViewHost_DraggingExited_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentsNSViewHost_DraggingUpdated_Params_Data::Validate,
     &internal::WebContentsNSViewHost_DraggingUpdated_ResponseParams_Data::Validate},
    { &internal::WebContentsNSViewHost_PerformDragOperation_Params_Data::Validate,
     &internal::WebContentsNSViewHost_PerformDragOperation_ResponseParams_Data::Validate},
    { &internal::WebContentsNSViewHost_DragPromisedFileTo_Params_Data::Validate,
     &internal::WebContentsNSViewHost_DragPromisedFileTo_ResponseParams_Data::Validate},
    { &internal::WebContentsNSViewHost_EndDrag_Params_Data::Validate,
     nullptr /* no response */},
};

bool WebContentsNSViewHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::remote_cocoa::mojom::WebContentsNSViewHost::Name_,
    kWebContentsNSViewHostValidationInfo);
}

bool WebContentsNSViewHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::remote_cocoa::mojom::WebContentsNSViewHost::Name_,
    kWebContentsNSViewHostValidationInfo);
}


}  // remote_cocoa::mojom


namespace mojo {


// static
bool StructTraits<::remote_cocoa::mojom::DraggingInfo::DataView, ::remote_cocoa::mojom::DraggingInfoPtr>::Read(
    ::remote_cocoa::mojom::DraggingInfo::DataView input,
    ::remote_cocoa::mojom::DraggingInfoPtr* output) {
  bool success = true;
  ::remote_cocoa::mojom::DraggingInfoPtr result(::remote_cocoa::mojom::DraggingInfo::New());
  
      if (success && !input.ReadLocationInView(&result->location_in_view))
        success = false;
      if (success && !input.ReadLocationInScreen(&result->location_in_screen))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success)
        result->operation_mask = input.operation_mask();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace remote_cocoa::mojom {


void WebContentsNSViewInterceptorForTesting::SetParentNSView(uint64_t parent_ns_view_id) {
  GetForwardingInterface()->SetParentNSView(
    std::move(parent_ns_view_id)
    );
}
void WebContentsNSViewInterceptorForTesting::ResetParentNSView() {
  GetForwardingInterface()->ResetParentNSView();
}
void WebContentsNSViewInterceptorForTesting::SetBounds(const ::gfx::Rect& bounds_in_window) {
  GetForwardingInterface()->SetBounds(
    std::move(bounds_in_window)
    );
}
void WebContentsNSViewInterceptorForTesting::SetVisible(bool visible) {
  GetForwardingInterface()->SetVisible(
    std::move(visible)
    );
}
void WebContentsNSViewInterceptorForTesting::MakeFirstResponder() {
  GetForwardingInterface()->MakeFirstResponder();
}
void WebContentsNSViewInterceptorForTesting::TakeFocus(bool reverse) {
  GetForwardingInterface()->TakeFocus(
    std::move(reverse)
    );
}
void WebContentsNSViewInterceptorForTesting::StartDrag(const ::content::DropData& drop_data, const ::url::Origin& source_origin, uint32_t operation_mask, const ::gfx::ImageSkia& image, const ::gfx::Vector2d& image_offset, bool is_privileged) {
  GetForwardingInterface()->StartDrag(
    std::move(drop_data)
    , 
    std::move(source_origin)
    , 
    std::move(operation_mask)
    , 
    std::move(image)
    , 
    std::move(image_offset)
    , 
    std::move(is_privileged)
    );
}
void WebContentsNSViewInterceptorForTesting::Destroy() {
  GetForwardingInterface()->Destroy();
}
WebContentsNSViewAsyncWaiter::WebContentsNSViewAsyncWaiter(
    WebContentsNSView* proxy) : proxy_(proxy) {}

WebContentsNSViewAsyncWaiter::~WebContentsNSViewAsyncWaiter() = default;





void WebContentsNSViewHostInterceptorForTesting::OnMouseEvent(::std::unique_ptr<::ui::Event> event) {
  GetForwardingInterface()->OnMouseEvent(
    std::move(event)
    );
}
void WebContentsNSViewHostInterceptorForTesting::OnBecameFirstResponder(SelectionDirection direction) {
  GetForwardingInterface()->OnBecameFirstResponder(
    std::move(direction)
    );
}
void WebContentsNSViewHostInterceptorForTesting::OnWindowVisibilityChanged(Visibility visibility) {
  GetForwardingInterface()->OnWindowVisibilityChanged(
    std::move(visibility)
    );
}
void WebContentsNSViewHostInterceptorForTesting::SetDropData(const ::content::DropData& drop_data) {
  GetForwardingInterface()->SetDropData(
    std::move(drop_data)
    );
}
void WebContentsNSViewHostInterceptorForTesting::DraggingEntered(DraggingInfoPtr dragging_info, DraggingEnteredCallback callback) {
  GetForwardingInterface()->DraggingEntered(
    std::move(dragging_info)
    , std::move(callback));
}
void WebContentsNSViewHostInterceptorForTesting::DraggingExited() {
  GetForwardingInterface()->DraggingExited();
}
void WebContentsNSViewHostInterceptorForTesting::DraggingUpdated(DraggingInfoPtr dragging_info, DraggingUpdatedCallback callback) {
  GetForwardingInterface()->DraggingUpdated(
    std::move(dragging_info)
    , std::move(callback));
}
void WebContentsNSViewHostInterceptorForTesting::PerformDragOperation(DraggingInfoPtr dragging_info, PerformDragOperationCallback callback) {
  GetForwardingInterface()->PerformDragOperation(
    std::move(dragging_info)
    , std::move(callback));
}
void WebContentsNSViewHostInterceptorForTesting::DragPromisedFileTo(const ::base::FilePath& file_path, const ::content::DropData& drop_data, const ::GURL& download_url, const ::url::Origin& source_origin, DragPromisedFileToCallback callback) {
  GetForwardingInterface()->DragPromisedFileTo(
    std::move(file_path)
    , 
    std::move(drop_data)
    , 
    std::move(download_url)
    , 
    std::move(source_origin)
    , std::move(callback));
}
void WebContentsNSViewHostInterceptorForTesting::EndDrag(uint32_t drag_operation, const ::gfx::PointF& local_point, const ::gfx::PointF& screen_point) {
  GetForwardingInterface()->EndDrag(
    std::move(drag_operation)
    , 
    std::move(local_point)
    , 
    std::move(screen_point)
    );
}
WebContentsNSViewHostAsyncWaiter::WebContentsNSViewHostAsyncWaiter(
    WebContentsNSViewHost* proxy) : proxy_(proxy) {}

WebContentsNSViewHostAsyncWaiter::~WebContentsNSViewHostAsyncWaiter() = default;


void WebContentsNSViewHostAsyncWaiter::DraggingEntered(
    DraggingInfoPtr dragging_info, uint32_t* out_result) {
  base::RunLoop loop;
  proxy_->DraggingEntered(
      std::move(dragging_info),
      base::BindOnce(
          [](base::RunLoop* loop,
             uint32_t* out_result
,
             uint32_t result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

uint32_t WebContentsNSViewHostAsyncWaiter::DraggingEntered(
    DraggingInfoPtr dragging_info) {
  uint32_t async_wait_result;
  DraggingEntered(std::move(dragging_info),&async_wait_result);
  return async_wait_result;
}

void WebContentsNSViewHostAsyncWaiter::DraggingUpdated(
    DraggingInfoPtr dragging_info, uint32_t* out_result) {
  base::RunLoop loop;
  proxy_->DraggingUpdated(
      std::move(dragging_info),
      base::BindOnce(
          [](base::RunLoop* loop,
             uint32_t* out_result
,
             uint32_t result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

uint32_t WebContentsNSViewHostAsyncWaiter::DraggingUpdated(
    DraggingInfoPtr dragging_info) {
  uint32_t async_wait_result;
  DraggingUpdated(std::move(dragging_info),&async_wait_result);
  return async_wait_result;
}

void WebContentsNSViewHostAsyncWaiter::PerformDragOperation(
    DraggingInfoPtr dragging_info, bool* out_result) {
  base::RunLoop loop;
  proxy_->PerformDragOperation(
      std::move(dragging_info),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_result
,
             bool result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

bool WebContentsNSViewHostAsyncWaiter::PerformDragOperation(
    DraggingInfoPtr dragging_info) {
  bool async_wait_result;
  PerformDragOperation(std::move(dragging_info),&async_wait_result);
  return async_wait_result;
}

void WebContentsNSViewHostAsyncWaiter::DragPromisedFileTo(
    const ::base::FilePath& file_path, const ::content::DropData& drop_data, const ::GURL& download_url, const ::url::Origin& source_origin, ::base::FilePath* out_file_path) {
  base::RunLoop loop;
  proxy_->DragPromisedFileTo(
      std::move(file_path),
      std::move(drop_data),
      std::move(download_url),
      std::move(source_origin),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::FilePath* out_file_path
,
             const ::base::FilePath& file_path) {*out_file_path = std::move(file_path);
            loop->Quit();
          },
          &loop,
          out_file_path));
  loop.Run();
}

::base::FilePath WebContentsNSViewHostAsyncWaiter::DragPromisedFileTo(
    const ::base::FilePath& file_path, const ::content::DropData& drop_data, const ::GURL& download_url, const ::url::Origin& source_origin) {
  ::base::FilePath async_wait_result;
  DragPromisedFileTo(std::move(file_path),std::move(drop_data),std::move(download_url),std::move(source_origin),&async_wait_result);
  return async_wait_result;
}






}  // remote_cocoa::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif