// content/common/renderer_host.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/renderer_host.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/renderer_host.mojom-params-data.h"
#include "content/common/renderer_host.mojom-shared-message-ids.h"

#include "content/common/renderer_host.mojom-import-headers.h"
#include "content/common/renderer_host.mojom-test-utils.h"


namespace content::mojom {
// The declaration includes the definition on other builds.

RendererHost::IPCStableHashFunction RendererHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RendererHost>(message.name())) {
    case messages::RendererHost::kGetBrowserHistogram: {
      return &RendererHost::GetBrowserHistogram_Sym::IPCStableHash;
    }
    case messages::RendererHost::kSuddenTerminationAllowedChanged: {
      return &RendererHost::SuddenTerminationAllowedChanged_Sym::IPCStableHash;
    }
    case messages::RendererHost::kRecordUserMetricsAction: {
      return &RendererHost::RecordUserMetricsAction_Sym::IPCStableHash;
    }
    case messages::RendererHost::kHasGpuProcess: {
      return &RendererHost::HasGpuProcess_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RendererHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RendererHost>(message.name())) {
      case messages::RendererHost::kGetBrowserHistogram:
            return "Receive content::mojom::RendererHost::GetBrowserHistogram";
      case messages::RendererHost::kSuddenTerminationAllowedChanged:
            return "Receive content::mojom::RendererHost::SuddenTerminationAllowedChanged";
      case messages::RendererHost::kRecordUserMetricsAction:
            return "Receive content::mojom::RendererHost::RecordUserMetricsAction";
      case messages::RendererHost::kHasGpuProcess:
            return "Receive content::mojom::RendererHost::HasGpuProcess";
    }
  } else {
    switch (static_cast<messages::RendererHost>(message.name())) {
      case messages::RendererHost::kGetBrowserHistogram:
            return "Receive reply content::mojom::RendererHost::GetBrowserHistogram";
      case messages::RendererHost::kSuddenTerminationAllowedChanged:
            return "Receive reply content::mojom::RendererHost::SuddenTerminationAllowedChanged";
      case messages::RendererHost::kRecordUserMetricsAction:
            return "Receive reply content::mojom::RendererHost::RecordUserMetricsAction";
      case messages::RendererHost::kHasGpuProcess:
            return "Receive reply content::mojom::RendererHost::HasGpuProcess";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RendererHost::GetBrowserHistogram_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x807468f9;  // IPCStableHash for content::mojom::RendererHost::GetBrowserHistogram
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RendererHost::SuddenTerminationAllowedChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xab1c3210;  // IPCStableHash for content::mojom::RendererHost::SuddenTerminationAllowedChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RendererHost::RecordUserMetricsAction_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc7a86f41;  // IPCStableHash for content::mojom::RendererHost::RecordUserMetricsAction
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RendererHost::HasGpuProcess_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x08be22a8;  // IPCStableHash for content::mojom::RendererHost::HasGpuProcess
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool RendererHost::GetBrowserHistogram(const std::string& name, std::string* out_histogram_json) {
  NOTREACHED();
}
bool RendererHost::HasGpuProcess(bool* out_has_gpu_process) {
  NOTREACHED();
}
class RendererHost_GetBrowserHistogram_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  RendererHost_GetBrowserHistogram_HandleSyncResponse(
      bool* result, std::string* out_histogram_json)
      : result_(result), out_histogram_json_(out_histogram_json) {
    DCHECK(!*result_);
  }

  RendererHost_GetBrowserHistogram_HandleSyncResponse(const RendererHost_GetBrowserHistogram_HandleSyncResponse&) = delete;
  RendererHost_GetBrowserHistogram_HandleSyncResponse& operator=(const RendererHost_GetBrowserHistogram_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  std::string* out_histogram_json_;};

class RendererHost_GetBrowserHistogram_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RendererHost_GetBrowserHistogram_ForwardToCallback(
      RendererHost::GetBrowserHistogramCallback callback
      ) : callback_(std::move(callback)) {
  }

  RendererHost_GetBrowserHistogram_ForwardToCallback(const RendererHost_GetBrowserHistogram_ForwardToCallback&) = delete;
  RendererHost_GetBrowserHistogram_ForwardToCallback& operator=(const RendererHost_GetBrowserHistogram_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  RendererHost::GetBrowserHistogramCallback callback_;
};
class RendererHost_HasGpuProcess_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  RendererHost_HasGpuProcess_HandleSyncResponse(
      bool* result, bool* out_has_gpu_process)
      : result_(result), out_has_gpu_process_(out_has_gpu_process) {
    DCHECK(!*result_);
  }

  RendererHost_HasGpuProcess_HandleSyncResponse(const RendererHost_HasGpuProcess_HandleSyncResponse&) = delete;
  RendererHost_HasGpuProcess_HandleSyncResponse& operator=(const RendererHost_HasGpuProcess_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_has_gpu_process_;};

class RendererHost_HasGpuProcess_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RendererHost_HasGpuProcess_ForwardToCallback(
      RendererHost::HasGpuProcessCallback callback
      ) : callback_(std::move(callback)) {
  }

  RendererHost_HasGpuProcess_ForwardToCallback(const RendererHost_HasGpuProcess_ForwardToCallback&) = delete;
  RendererHost_HasGpuProcess_ForwardToCallback& operator=(const RendererHost_HasGpuProcess_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  RendererHost::HasGpuProcessCallback callback_;
};

RendererHostProxy::RendererHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool RendererHostProxy::GetBrowserHistogram(
    const std::string& param_name, std::string* out_param_histogram_json) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call content::mojom::RendererHost::GetBrowserHistogram (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), param_name,
                        "<value of type const std::string&>");
   });
#else
  TRACE_EVENT0("mojom", "RendererHost::GetBrowserHistogram");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererHost::kGetBrowserHistogram), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RendererHost_GetBrowserHistogram_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    param_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in RendererHost.GetBrowserHistogram request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererHost::Name_);
  message.set_method_name("GetBrowserHistogram");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RendererHost_GetBrowserHistogram_HandleSyncResponse(
          &result, out_param_histogram_json));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "RendererHost::GetBrowserHistogram", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("histogram_json"), out_param_histogram_json,
                        "<value of type const std::string&>");
   });
#endif
  return result;
}

void RendererHostProxy::GetBrowserHistogram(
    const std::string& in_name, GetBrowserHistogramCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::RendererHost::GetBrowserHistogram", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererHost::kGetBrowserHistogram), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RendererHost_GetBrowserHistogram_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in RendererHost.GetBrowserHistogram request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererHost::Name_);
  message.set_method_name("GetBrowserHistogram");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RendererHost_GetBrowserHistogram_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void RendererHostProxy::SuddenTerminationAllowedChanged(
    bool in_allowed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::RendererHost::SuddenTerminationAllowedChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allowed"), in_allowed,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererHost::kSuddenTerminationAllowedChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RendererHost_SuddenTerminationAllowedChanged_Params_Data> params(
          message);
  params.Allocate();

  params->allowed = in_allowed;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererHost::Name_);
  message.set_method_name("SuddenTerminationAllowedChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererHostProxy::RecordUserMetricsAction(
    const std::string& in_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::RendererHost::RecordUserMetricsAction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action"), in_action,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererHost::kRecordUserMetricsAction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RendererHost_RecordUserMetricsAction_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->action)::BaseType> action_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_action,
    action_fragment);

  params->action.Set(
      action_fragment.is_null() ? nullptr : action_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->action.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null action in RendererHost.RecordUserMetricsAction request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererHost::Name_);
  message.set_method_name("RecordUserMetricsAction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool RendererHostProxy::HasGpuProcess(
    bool* out_param_has_gpu_process) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call content::mojom::RendererHost::HasGpuProcess (sync)");
#else
  TRACE_EVENT0("mojom", "RendererHost::HasGpuProcess");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererHost::kHasGpuProcess), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RendererHost_HasGpuProcess_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererHost::Name_);
  message.set_method_name("HasGpuProcess");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RendererHost_HasGpuProcess_HandleSyncResponse(
          &result, out_param_has_gpu_process));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "RendererHost::HasGpuProcess", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_gpu_process"), out_param_has_gpu_process,
                        "<value of type bool>");
   });
#endif
  return result;
}

void RendererHostProxy::HasGpuProcess(
    HasGpuProcessCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send content::mojom::RendererHost::HasGpuProcess");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererHost::kHasGpuProcess), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RendererHost_HasGpuProcess_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererHost::Name_);
  message.set_method_name("HasGpuProcess");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RendererHost_HasGpuProcess_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class RendererHost_GetBrowserHistogram_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static RendererHost::GetBrowserHistogramCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<RendererHost_GetBrowserHistogram_ProxyToResponder> proxy(
        new RendererHost_GetBrowserHistogram_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&RendererHost_GetBrowserHistogram_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RendererHost_GetBrowserHistogram_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  RendererHost_GetBrowserHistogram_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "RendererHost::GetBrowserHistogramCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_histogram_json);
};

bool RendererHost_GetBrowserHistogram_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RendererHost_GetBrowserHistogram_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RendererHost_GetBrowserHistogram_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for RendererHost.0
  bool success = true;
  std::string p_histogram_json{};
  RendererHost_GetBrowserHistogram_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadHistogramJson(&p_histogram_json))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RendererHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_histogram_json));
  }
  return true;
}

void RendererHost_GetBrowserHistogram_ProxyToResponder::Run(
    const std::string& in_histogram_json) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply content::mojom::RendererHost::GetBrowserHistogram", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("histogram_json"), in_histogram_json,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererHost::kGetBrowserHistogram), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RendererHost_GetBrowserHistogram_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->histogram_json)::BaseType> histogram_json_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_histogram_json,
    histogram_json_fragment);

  params->histogram_json.Set(
      histogram_json_fragment.is_null() ? nullptr : histogram_json_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->histogram_json.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null histogram_json in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererHost::Name_);
  message.set_method_name("GetBrowserHistogram");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool RendererHost_GetBrowserHistogram_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RendererHost_GetBrowserHistogram_ResponseParams_Data* params =
      reinterpret_cast<internal::RendererHost_GetBrowserHistogram_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for RendererHost.0
  bool success = true;
  std::string p_histogram_json{};
  RendererHost_GetBrowserHistogram_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadHistogramJson(&p_histogram_json))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RendererHost::Name_, 0, true);
    return false;
  }
  *out_histogram_json_ = std::move(p_histogram_json);
  *result_ = true;
  return true;
}
class RendererHost_HasGpuProcess_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static RendererHost::HasGpuProcessCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<RendererHost_HasGpuProcess_ProxyToResponder> proxy(
        new RendererHost_HasGpuProcess_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&RendererHost_HasGpuProcess_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RendererHost_HasGpuProcess_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  RendererHost_HasGpuProcess_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "RendererHost::HasGpuProcessCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_has_gpu_process);
};

bool RendererHost_HasGpuProcess_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RendererHost_HasGpuProcess_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RendererHost_HasGpuProcess_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for RendererHost.3
  bool success = true;
  bool p_has_gpu_process{};
  RendererHost_HasGpuProcess_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_has_gpu_process = input_data_view.has_gpu_process();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RendererHost::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_has_gpu_process));
  }
  return true;
}

void RendererHost_HasGpuProcess_ProxyToResponder::Run(
    bool in_has_gpu_process) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply content::mojom::RendererHost::HasGpuProcess", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_gpu_process"), in_has_gpu_process,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererHost::kHasGpuProcess), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RendererHost_HasGpuProcess_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->has_gpu_process = in_has_gpu_process;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererHost::Name_);
  message.set_method_name("HasGpuProcess");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool RendererHost_HasGpuProcess_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RendererHost_HasGpuProcess_ResponseParams_Data* params =
      reinterpret_cast<internal::RendererHost_HasGpuProcess_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for RendererHost.3
  bool success = true;
  bool p_has_gpu_process{};
  RendererHost_HasGpuProcess_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_has_gpu_process = input_data_view.has_gpu_process();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RendererHost::Name_, 3, true);
    return false;
  }
  *out_has_gpu_process_ = std::move(p_has_gpu_process);
  *result_ = true;
  return true;
}

// static
bool RendererHostStubDispatch::Accept(
    RendererHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RendererHost>(message->header()->name)) {
    case messages::RendererHost::kGetBrowserHistogram: {
      break;
    }
    case messages::RendererHost::kSuddenTerminationAllowedChanged: {
      DCHECK(message->is_serialized());
      internal::RendererHost_SuddenTerminationAllowedChanged_Params_Data* params =
          reinterpret_cast<internal::RendererHost_SuddenTerminationAllowedChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RendererHost.1
      bool success = true;
      bool p_allowed{};
      RendererHost_SuddenTerminationAllowedChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_allowed = input_data_view.allowed();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SuddenTerminationAllowedChanged(        
        std::move(p_allowed));
      return true;
    }
    case messages::RendererHost::kRecordUserMetricsAction: {
      DCHECK(message->is_serialized());
      internal::RendererHost_RecordUserMetricsAction_Params_Data* params =
          reinterpret_cast<internal::RendererHost_RecordUserMetricsAction_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RendererHost.2
      bool success = true;
      std::string p_action{};
      RendererHost_RecordUserMetricsAction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAction(&p_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordUserMetricsAction(        
        std::move(p_action));
      return true;
    }
    case messages::RendererHost::kHasGpuProcess: {
      break;
    }
  }
  return false;
}

// static
bool RendererHostStubDispatch::AcceptWithResponder(
    RendererHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RendererHost>(message->header()->name)) {
    case messages::RendererHost::kGetBrowserHistogram: {
      internal::RendererHost_GetBrowserHistogram_Params_Data* params =
          reinterpret_cast<
              internal::RendererHost_GetBrowserHistogram_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for RendererHost.0
      bool success = true;
      std::string p_name{};
      RendererHost_GetBrowserHistogram_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererHost::Name_, 0, false);
        return false;
      }
      auto callback =
          RendererHost_GetBrowserHistogram_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetBrowserHistogram(        
        std::move(p_name), std::move(callback));
      return true;
    }
    case messages::RendererHost::kSuddenTerminationAllowedChanged: {
      break;
    }
    case messages::RendererHost::kRecordUserMetricsAction: {
      break;
    }
    case messages::RendererHost::kHasGpuProcess: {
      internal::RendererHost_HasGpuProcess_Params_Data* params =
          reinterpret_cast<
              internal::RendererHost_HasGpuProcess_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for RendererHost.3
      bool success = true;
      RendererHost_HasGpuProcess_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererHost::Name_, 3, false);
        return false;
      }
      auto callback =
          RendererHost_HasGpuProcess_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HasGpuProcess(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRendererHostValidationInfo[] = {
    { &internal::RendererHost_GetBrowserHistogram_Params_Data::Validate,
     &internal::RendererHost_GetBrowserHistogram_ResponseParams_Data::Validate},
    { &internal::RendererHost_SuddenTerminationAllowedChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RendererHost_RecordUserMetricsAction_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RendererHost_HasGpuProcess_Params_Data::Validate,
     &internal::RendererHost_HasGpuProcess_ResponseParams_Data::Validate},
};

bool RendererHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::content::mojom::RendererHost::Name_,
    kRendererHostValidationInfo);
}

bool RendererHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::content::mojom::RendererHost::Name_,
    kRendererHostValidationInfo);
}


}  // content::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace content::mojom {


void RendererHostInterceptorForTesting::GetBrowserHistogram(const std::string& name, GetBrowserHistogramCallback callback) {
  GetForwardingInterface()->GetBrowserHistogram(
    std::move(name)
    , std::move(callback));
}
void RendererHostInterceptorForTesting::SuddenTerminationAllowedChanged(bool allowed) {
  GetForwardingInterface()->SuddenTerminationAllowedChanged(
    std::move(allowed)
    );
}
void RendererHostInterceptorForTesting::RecordUserMetricsAction(const std::string& action) {
  GetForwardingInterface()->RecordUserMetricsAction(
    std::move(action)
    );
}
void RendererHostInterceptorForTesting::HasGpuProcess(HasGpuProcessCallback callback) {
  GetForwardingInterface()->HasGpuProcess(std::move(callback));
}
RendererHostAsyncWaiter::RendererHostAsyncWaiter(
    RendererHost* proxy) : proxy_(proxy) {}

RendererHostAsyncWaiter::~RendererHostAsyncWaiter() = default;


void RendererHostAsyncWaiter::GetBrowserHistogram(
    const std::string& name, std::string* out_histogram_json) {
  base::RunLoop loop;
  proxy_->GetBrowserHistogram(
      std::move(name),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_histogram_json
,
             const std::string& histogram_json) {*out_histogram_json = std::move(histogram_json);
            loop->Quit();
          },
          &loop,
          out_histogram_json));
  loop.Run();
}

std::string RendererHostAsyncWaiter::GetBrowserHistogram(
    const std::string& name) {
  std::string async_wait_result;
  GetBrowserHistogram(std::move(name),&async_wait_result);
  return async_wait_result;
}

void RendererHostAsyncWaiter::HasGpuProcess(
    bool* out_has_gpu_process) {
  base::RunLoop loop;
  proxy_->HasGpuProcess(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_has_gpu_process
,
             bool has_gpu_process) {*out_has_gpu_process = std::move(has_gpu_process);
            loop->Quit();
          },
          &loop,
          out_has_gpu_process));
  loop.Run();
}

bool RendererHostAsyncWaiter::HasGpuProcess(
    ) {
  bool async_wait_result;
  HasGpuProcess(&async_wait_result);
  return async_wait_result;
}






}  // content::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif